﻿:::::::::::::::::::::::::::::::::::::::::
::	file: Arma3Tools_diag_retail.bat
::	======
::	Author: Tom_48_97
::  © 2014 Bohemia Interactive a.s.
::	Description: This script will check some registry keys, files and other stuff to produce a report to help debugging your tools. Report is stored in %temp%\BIStudio and named "Arma3Tools_diag_retail.rpt"
::	Note:
::		this script doesn't suggest any solution, it collects data.
::	Wiki:
::		http://community.bistudio.com/
:::::::::::::::::::::::::::::::::::::::::
:: Small kid, after this line, GET OUT OF MY CODE ;-)
@echo off
color f1
mode con:cols=140 lines=60
title Arma 3 Tools Diagnostic
set scriptVersion=0.95.10
cls
rem SHIFT & SHIFT
if "%1" EQU "-nostore" (
	if not exist "%temp%\BIStudio" mkdir "%temp%\BIStudio"
	set "output=%temp%\BIStudio\Arma3CommunityTools_diag.rpt"
) else (
	if not exist "%~dp0Logs" mkdir "%~dp0Logs"
	call:fileName
)
echo. > %output%
echo /*----------------------------------------------------------------------------- >> %output%
echo 	                  Arma 3 Tools Diagnostic 							>> %output%
echo -----------------------------------------------------------------------------*/ >> %output%
echo . . . . .          .....   ..Z.MMMM.        ..8MMMM=.. ....        .         ..
echo .         . . . . ..........8MMMMMMM..........MMMMMM...........................
echo ..        . ..... ..:,.=8MMM.,MMMMMMM.........OMMMM............................
echo ..  .   . ..MMMMMMMMMMMMMMMMMMMMMMMMMMMM...MMMMMMMMMMM........~................
echo ... .............MM...MMMMMMMMMMMMMMMMMM.MMMMMMMMMMMMMM.....:...................
echo ... .  ..........MMI....MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM.......................
echo   ......=M~MMMMMM..M.......M..MMMMMMMMMMMMMMMMMMMMMMMMMM. .MM ...  .        ..
echo     ......MMMMMMM...,.,,,.....MMMMMMMMMM:MMMMMMMMMMMMMMMMNMMMMMM.  .        :.
echo   ..........DMMMMMMM=..........MMMMMMM ...MMMMMMMMMMMM ~MMMMMMMM.        .. ..
echo     ........MMMMMMMMMM........OMMMMMMMM.  ,MMMMMMMMMM ..MMMMMMMMMMMMM=:~....
echo     .......MMMMMMMMMMMMM......MMMMMMMMM.  MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM...OM.
echo  ........MMMMMMMMMMMMMMM+...8MMMMMMMMM...MMMMMMMMMMMMMMMMMMMMMMMMMMMMM..   .....
echo  . . ....MMM..MMMMMMMMMMMMMMMMMMMMMMM=..MMMMMMM...MMMMMMMMMMMMMMMMMMMM. ... ....
echo   .......MMMMMMMMMMMMMMMMMMMMMM .MMMM...MMMMMM.. ...MMMMMMMMMMMM..MMMMMO.
echo   ......8MM.8MMMMMMMMMMMMMMMMMM...MMMMM,MMMMM.......MMMMMMMMMMMMMMMMMMMM~.......
echo . .... .8....MMMM.M.MMMMMM. MMM.....MMMMMMMM........ MMMMMMMMMMMMMMMMMM.........
echo . ...........MMMM. MMMMM=...MMM......MMMMMM.  .   . .MMMMMMMMMMM~.MMMM..  .
echo . ...........MMMM..MMMMMMMMMMMMMMM....MMM...... ... ..MMMMMMMM. .MMMM.. ... ...:
echo   . .... ....OMM~..MMMMMI+ZMMMMMM7.MMMMMMMMMMMZZ: .   =MMMMMMMMZMMM   .   .   .:
echo   ....   .MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMNMMMMMNMM.
echo MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM
echo MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM
echo MMMMMMMMMMM.............MMMMMMMMMMMMMMMMMMMMMMMMMMMMMM.............MMMMMMMMMMMMM
echo MMMMMMMMMM......................  MM........ MMM=...................MMMMMMMMMMMM
echo MMMMMMMMM ......8........................... MMM............ .......7MMMMMMMMMMM
echo MMMMMMMM=.      M  ... ....M~. ... M.. ...... M..............M.......MMMMMMMMMMM
echo MMMMMMMM.      MM  . . . . . . . MMM . .....................8M .......MMMMMMMMMM
echo MMMMMMM .           ......MM=......M......M ......M....................MMMMMMMMM
echo MMMMMM.... .   ,.  . . . . M~. . . . . ...M ......M....................MMMMMMMMM
echo MMMMM+...    ?MMM         MM~          ...MM.....MM.........8MMM........MMMMMMMM
echo MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMARUK
echo /*-----------------------------------------------------------------------------
echo 	                  Arma 3 Tools Diagnostic
echo -----------------------------------------------------------------------------*/
echo output: %output% >> %output%
echo params: %* >> %output%
echo Version: %scriptVersion%
echo. >> %output%
echo.
echo this script will just search for Arma 3 and P Drive key into
echo your Windows registry and store results into %output%
echo.
if "%1" EQU "-autoStart" goto:proceeed
echo do you want to proceeed?
choice /c:yn
if %errorlevel% EQU 2 (set ERRCODE=1 & goto:error)
echo.
:proceeed
starter.exe /parent=shell /mode=messageBox /tool=Diagnostic "The output of the Diagnostic will be stored in the log directory and opened once done\n\n%output%."

if not exist "%SystemRoot%\System32\ping.exe" (set ERRCODE=5 & goto:error)
if not exist "%~dp0\steam_api.dll" (set ERRCODE=2 & goto:error)
if "%~dp0" EQU "P:\" (set ERRCODE=4 & goto:error)
::-----------------------------------
call:BeginOfSection Local defined vars
rem FOR /F "usebackq delims==" %%i IN (`set`) DO @echo %%i >> %output%
FOR /F "usebackq delims=" %%A IN (`set`) DO (echo %%A >> %output%)
call:EndOfSection
::-----------------------------------
call:BeginOfSection System informations
echo User="%USERNAME%" 1>> %output%
FOR /F "tokens=3 delims= " %%G in ('reg query "hklm\system\controlset001\control\nls\language" /v Installlanguage') DO (
	IF [%%G] EQU [0409] (
		echo language="ENGLISH" 1>> %output%
	) ELSE (
		ECHO language="%%G" 1>> %output%
	)
)
set recentOS=0
for /f "tokens=1-9" %%a in ('"systeminfo | find /i "OS Name""') do (echo OSName="%%e"  1>> %output%)
call:getOSVersion "5.1." "Windows XP" 1>> %output%
call:getOSVersion "5.0." "Windows 2000" 1>> %output%
call:getOSVersion "5.2." "Server 2003" 1>> %output%
call:getOSVersion "6.0." "Vista || Server 2008" 1>> %output%
call:getOSVersion "6.1." "Windows 7 || Server 2008R2" 1>> %output%
call:getOSVersion "6.2." "Windows 8 || Server 2012" 1>> %output%
call:getOSVersion "6.3." "Windows 8.1 || Server 2012R2" 1>> %output%
call:getOSVersion "10." "Windows 10" 1>> %output%
:EndOfSysteminformations
call:EndOfSection

::-----------------------------------
call:BeginOfSection Scan Arma 3 Tools folder
echo Working dir = "%~dp0" 1>> %output%
@cd "%~dp0"
if not exist P: (echo "!(p:)" 1>> %output%) else (echo "P:" 1>> %output%)
pushd %~dp0
dir /o /q /c /w /x 1>> %output%
echo. 1>> %output%
echo steamapps steam_appid.txt 1>> %output%
if not exist steam_appid.txt (ERRCODE=3 & goto:error) else (type steam_appid.txt 1>> %output%)
echo. 1>> %output%
echo. 1>> %output%
echo size	date		time		name 1>> %output%
forfiles /P . /m *.bat /c "cmd /c echo @fsize0x09@fdate0x09@ftime0x09@fname 1>> %output%"
if %recentOS% EQU 0 goto:skipFileTree
tree /A /F 1>> %output%
:skipFileTree
popd
call:EndOfSection

::-----------------------------------
call:BeginOfSection Looking for file type entries
FOR %%X IN ("Audio WSS","Script","Config","3D","Image","FSM") DO (call:search_HKCRType %%X)
call:EndOfSection

::-----------------------------------
call:BeginOfSection Looking for file entries
FOR %%X IN (sqm,xml,sqf,sqs,ext,hpp,cpp,paa,p3d,pac,tv4p,xv4p,pew,wrp,pbo,fsm,bifsm) DO (call:search_HKCRFile %%X)
call:EndOfSection

::-----------------------------------
call:BeginOfSection Looking for Arma 3 nodes
For /F "Tokens=2* skip=2" %%A In ('REG QUERY "HKLM\SOFTWARE\Wow6432Node\Bohemia Interactive\Arma 3" /v "MAIN"') Do 			(set v64_path_a3="%%B")
if defined v64_path_a3 (echo v64_path_a3=%v64_path_a3% 1>> %output%) else (echo v64_path_a3="NULL" 1>> %output%)
For /F "Tokens=2* skip=2" %%C In ('REG QUERY "HKLM\SOFTWARE\Bohemia Interactive\Arma 3" /v "MAIN"') Do 						(set v32_path_a3="%%D")
if defined v32_path_a3 (echo v32_path_a3=%v32_path_a3% 1>> %output%) else (echo v32_path_a3="NULL" 1>> %output%)
for /F "tokens=2* delims=	 " %%I IN ('REG QUERY "HKLM\SOFTWARE\Wow6432Node\Bohemia Interactive\Arma 3" /v "MAIN"') do 	(set uac_PATH_a3="%%J")
if defined uac_PATH_a3 (echo uac_PATH_a3=%uac_PATH_a3% 1>> %output%) else (echo uac_PATH_a3="NULL" 1>> %output%)
for /F "tokens=2* delims=	 " %%K IN ('REG QUERY "HKLM\SOFTWARE\Bohemia Interactive\Arma 3" /v "MAIN"') DO 				(set std_PATH_a3="%%L")
if defined std_PATH_a3 (echo std_PATH_a3=%std_PATH_a3% 1>> %output%) else (echo std_PATH_a3="NULL" 1>> %output%)
for /F "Tokens=2* skip=2" %%A In ('REG QUERY "HKLM\SOFTWARE\Wow6432Node\Valve\Steam" /v "InstallPath" 2^>nul') do 			(set steam_v64_path="%%B\steamapps\common\Arma 3")
if defined steam_v64_path (echo steam_v64_path=%steam_v64_path% 1>> %output%) else (echo steam_v64_path="NULL" 1>> %output%)
for /F "Tokens=2* skip=2" %%A In ('REG QUERY "HKLM\SOFTWARE\Valve\Steam" /v "InstallPath" 2^>nul') do 						(set steam_v32_path="%%B\steamapps\common\Arma 3")
if defined steam_v32_path (echo steam_v32_path=%steam_v32_path% 1>> %output%) else (echo steam_v32_path="NULL" 1>> %output%)
for /F "tokens=2* delims=	 " %%K IN ('REG QUERY "HKCU\Software\Bohemia Interactive\gameupdater" /v "path_d"') DO 				(set std_PATH_GUa3="%%L")
if defined std_PATH_GUa3 (echo std_PATH_GUa3=%std_PATH_GUa3% 1>> %output%) else (echo std_PATH_GUa3="NULL" 1>> %output%)
for /F "tokens=2* delims=	 " %%K IN ('REG QUERY "HKCU\Software\Bohemia Interactive\gameupdater" /v "Branch"') DO 				(set std_PATH_GUBranch="%%L")
if defined std_PATH_GUBranch (echo std_PATH_GUBranch=%std_PATH_GUBranch% 1>> %output%) else (echo std_PATH_GUBranch="NULL" 1>> %output%)
for /F "tokens=2* delims=	 " %%K IN ('REG QUERY "HKCU\Software\Bohemia Interactive\gameupdater_TN" /v "path_d"') DO 				(set std_PATH_GUTN="%%L")
if defined std_PATH_GUTN (echo std_PATH_GUTN=%std_PATH_GUTN% 1>> %output%) else (echo std_PATH_GUTN="NULL" 1>> %output%)
call:EndOfSection

::-----------------------------------
call:BeginOfSection Looking for Arma 3 tools nodes
REG Query "HKEY_CURRENT_USER\Software\bohemia interactive" /S 1>> %output%
REG Query "HKEY_CURRENT_USER\Software\Bohemia Interactive Studio" /S 1>> %output%
call:EndOfSection

::-----------------------------------
call:BeginOfSection User Settings
if not exist settings.ini (echo settings.ini is missing 1>> %output% ) else (type settings.ini 1>> %output% )
echo. 1>> %output%
call:EndOfSection

::-----------------------------------
call:BeginOfSection Run scripts with -DIAG
pushd %~dp0
echo. 1>> %output%
echo ------------------------ 1>> %output%
echo ☠ DevP.bat -DIAG 1>> %output%
if exist DevP.bat 		(call DevP.bat -DIAG 1>> %output% 2>&1) else 		(echo MISSING DevP.bat 1>> %output%)
echo ------------------------ 1>> %output%
echo ☠ mapDisk.bat -DIAG 1>> %output%
if exist mapDisk.bat 	(call mapDisk.bat -DIAG 1>> %output% 2>&1) else 	(echo MISSING DevP.bat 1>> %output%)
echo ------------------------ 1>> %output%
echo ☠ mapFolders.bat -DIAG 1>> %output%
if exist mapFolders.bat (call mapFolders.bat -DIAG 1>> %output% 2>&1) else (echo MISSING DevP.bat 1>> %output%)
popd
call:EndOfSection

::-----------------------------------
call:BeginOfSection BinMakeRules
pushd %~dp0
if exist "BinMake\binMakeRules.txt" (
	type "BinMake\binMakeRules.txt" 1>> %output%
) else (
	echo BinMake\binMakeRules.txt is missing 1>> %output%
)
popd
call:EndOfSection

echo ------------------------------------------------ 1>> %output%
echo End of output [%formatedDate%] 1>> %output%
echo ------------------------------------------------ 1>> %output%

::-----------------------------------
START "Arma3Tools_diag_retail" %output%
rem del %output%
exit 0


::---------------------------------------------------------------------------
::	ERRORS
::---------------------------------------------------------------------------
:error
color 0c
echo /!\ Error, cannot proceed /!\
if %ERRCODE% EQU 1 set content=User cancel
if %ERRCODE% EQU 2 set content=This script must be placed at the root directory of Arma 3 Tools
if %ERRCODE% EQU 3 set content=Arma 3 Tools is not properly installed, please, reinstall it or verify the cache from Steam
if %ERRCODE% EQU 4 set content='Arma3Tools_diag_retail.bat' must be run from the Arma 3 Tools, not P:
if %ERRCODE% EQU 5 set content=Your system environment variable PATH is wrong
echo %content%
echo %content% 1>> %output%
if exist "%output%" START "Arma3Tools_diag_retail" "%output%"
starter.exe /parent=shell /mode=messageBox /tool=Diagnostic "%content%"
timeout /T 3 /noBreak
exit %ERRCODE%
exit /B


::---------------------------------------------------------------------------
::	FUNCTIONS
::---------------------------------------------------------------------------
:search_HKCRFile
::	Description: search the default action assign to a given file type
::	Parameter(s):
::		%1: file type to search
::	Returns:
::		Nothing
echo %1...
REG Query "HKCR\.%1" /S 1>> %output% & echo %1 [OK]
goto:eof

:search_HKCRType
::	Description: search the default action assign to a given file type
::	Parameter(s):
::		%1: file type to search
::	Returns:
::		Nothing
echo %1...
REG Query "HKCR\BI_%1" /S 1>> %output% & echo %1 [OK]
goto:eof


:BeginOfSection
::	Description: Print new title and store it to log
::	Parameter(s):
::		%0-9: Title
::	Returns:
::		Nothing
echo.
call:formatDate
echo ------------------------------------------------
echo %* [%formatedDate%]
echo. 1>> %output%
echo ------------------------------------------------ 1>> %output%
echo %* [%formatedDate%] 1>> %output%
echo ------------------------------------------------ 1>> %output%
goto:eof

:EndOfSection
::	Description: Print new title and store it to log
::	Parameter(s):
::		%0-9: Title
::	Returns:
::		Nothing
echo.
call:formatDate
echo End of Section [%formatedDate%]
echo ------------------------------------------------
echo ------------------------------------------------ 1>> %output%
echo End of Section [%formatedDate%] 1>> %output%
echo ------------------------------------------------ 1>> %output%
goto:eof


:formatDate
::	Description:
::		Set the real date & time
::	Parameter(s):
::	Returns:
set timeIs=%TIME::=-%
set today=%DATE:/=-%
set formatedDate=%today% %timeIs%
goto:eof

:fileName
::	Description:
::		returns file name with current date and time when -store is used
::	Parameter(s):
::	Returns:
@echo off
SET Today=%Date: =0%
SET Year=%Today:~-4%
SET Month=%Today:~-10,3%
SET Month=%Month:-=%
SET Month=%Month:/=%
SET /A Month = 100%Month% %% 100
SET /A Month = 100 + %Month%
SET Month=%Month:~-2%
SET Day=%Today:~-7,2%
SET Day=%Day:-=%
SET Day=%Day:/=%
SET /A Day = 100%Day% %% 100
SET /A Day = 100 + %Day%
SET Day=%Day:~-2%
set TimeOfLog=%TIME::=%
set TimeOfLog=%TimeOfLog: =%
set TimeOfLog=%TimeOfLog:.=-%
rem echo %Year%%Month%%Day%_%TimeOfLog%
set output="%~dp0logs\Arma3CommunityTools_%Year%%Month%%Day%_%TimeOfLog%.rpt"
goto:eof

:print_time
::	Description:
::	Parameter(s):
::	Returns:
call:formatDate
echo %timeIs%
goto:eof

:getOSVersion
::	Description:
::	Parameter(s):
::		%1 Version
::		%2 Name
::	Returns:
@ver | findstr /i %1
if %ERRORLEVEL% EQU 0 (echo OS=%2 %1)
if %ERRORLEVEL% EQU 0 (
	if %1 EQU "6.1." set recentOS=1
	if %1 EQU "6.2." set recentOS=1
	if %1 EQU "6.3." set recentOS=1
	if %1 EQU "6.4." set recentOS=1
	if %1 EQU "10." set recentOS=1
)
goto:eof