#ifndef _SPECIALLOD_HPP_
#define _SPECIALLOD_HPP_
//Defined constants
#ifndef FLOAT_VALUE
#define FLOAT_VALUE(x) x
#endif

#define SPEC_LOD FLOAT_VALUE(1e15)
#define CALCSPECLOD(x) (SPEC_LOD*(x))
#define LOD_MEMORY CALCSPECLOD(1)
#define LOD_LANDCONTACT CALCSPECLOD(2)
#define LOD_ROADWAY CALCSPECLOD(3)
#define LOD_PATHS CALCSPECLOD(4)
#define LOD_HPOINTS CALCSPECLOD(5)
#define LOD_VIEWGEO CALCSPECLOD(6)
#define LOD_FIREGEO CALCSPECLOD(7)
#define LOD_VIEW_CARGO_GEOMETRY CALCSPECLOD(8)
#define LOD_VIEW_CARGO_FGEOMETRY CALCSPECLOD(9)
#define LOD_VIEW_COMMANDER CALCSPECLOD(10)
#define LOD_VIEW_COMM_GEOMETRY CALCSPECLOD(11)
#define LOD_VIEW_COMM_FGEOMETRY CALCSPECLOD(12)
#define LOD_VIEW_PILOT_GEOMETRY CALCSPECLOD(13)
#define LOD_VIEW_PILOT_FGEOMETRY CALCSPECLOD(14)
#define LOD_VIEW_GUNNER_GEOMETRY CALCSPECLOD(15)
#define LOD_VIEW_GUNNER_FGEOMETRY CALCSPECLOD(16)
#define LOD_SUB_PARTS CALCSPECLOD(17)
#define LOD_VIEW_GUNNER FLOAT_VALUE(1000.0)
#define LOD_VIEW_PILOT FLOAT_VALUE(1100.0)
#define LOD_VIEW_CARGO FLOAT_VALUE(1200.0)
#define LOD_SHADOW_MIN FLOAT_VALUE(10000.0)
#define LOD_SHADOW_MAX FLOAT_VALUE(20000.0)
#define LOD_SHADOW_B LOD_SHADOW_MIN
#define LOD_SHADOW(x) (x-LOD_SHADOW_MIN)
#define LOD_GET_SHADOW(x) (x+LOD_SHADOW_MIN) 
#define LOD_EDIT_MIN FLOAT_VALUE(20000.0)
#define LOD_EDIT_MAX FLOAT_VALUE(30000.0)
#define LOD_EDIT(x) (x-LOD_EDIT_MIN)
#define LOD_SHADOW_MAX_VALUE (LOD_SHADOW_MAX-LOD_SHADOW_MIN)
#define LOD_GEOMETRY FLOAT_VALUE(1e13)
#define IS_LOD_RESOLUTION(x) ((x)<LOD_SHADOW_MIN || (x)==LOD_VIEW_COMMANDER)
#define IS_LOD_GEOMETRY(x) ((x)==LOD_VIEWGEO || (x)==LOD_FIREGEO || (x)==LOD_VIEW_CARGO_GEOMETRY || (x)==LOD_VIEW_CARGO_FGEOMETRY || (x)==LOD_VIEW_COMM_GEOMETRY || (x)==LOD_VIEW_COMM_FGEOMETRY || (x)==LOD_VIEW_PILOT_GEOMETRY || (x)==LOD_VIEW_PILOT_FGEOMETRY || (x)==LOD_VIEW_GUNNER_GEOMETRY || (x)==LOD_VIEW_GUNNER_FGEOMETRY || (x)==LOD_GEOMETRY)
#define	LOD_ARR_GEOMETRY [LOD_VIEWGEO,LOD_FIREGEO,LOD_VIEW_CARGO_GEOMETRY,LOD_VIEW_CARGO_FGEOMETRY,LOD_VIEW_COMM_GEOMETRY,LOD_VIEW_COMM_FGEOMETRY,LOD_VIEW_PILOT_GEOMETRY,LOD_VIEW_PILOT_FGEOMETRY,LOD_VIEW_GUNNER_GEOMETRY,LOD_VIEW_GUNNER_FGEOMETRY,LOD_GEOMETRY]
#define IS_LOD_FIREGEOMETRY(x) ((x)==LOD_FIREGEO || (x)==LOD_VIEW_CARGO_FGEOMETRY || (x)==LOD_VIEW_COMM_FGEOMETRY || (x)==LOD_VIEW_PILOT_FGEOMETRY || (x)==LOD_VIEW_GUNNER_FGEOMETRY)

#define LOD_SHADOW_VIEW_CARGO 1.8e+016
#define LOD_SHADOW_VIEW_PILOT 1.9e+016
#define LOD_SHADOW_VIEW_GUNNER 2.0e+016
#define IS_LOD_SHADOW(x) ((x)==LOD_SHADOW_VIEW_GUNNER ||(x)==LOD_SHADOW_VIEW_PILOT ||(x)==LOD_SHADOW_VIEW_CARGO || ((x)>=LOD_SHADOW_MIN && (x)<LOD_SHADOW_MAX))

#endif