float4x4 matWorldViewProj;
float alpha;
sampler TextureSampler;

struct PS_INPUT 
{
   float4 Color : COLOR;
   float2 Texcoord : TEXCOORD0;
};

struct PS_OUTPUT 
{
   float4 Color : COLOR;
};


PS_OUTPUT PS_Texture( PS_INPUT Input)
{
   PS_OUTPUT Output;
 

   Output.Color = tex2D(TextureSampler, Input.Texcoord);
   Output.Color.a *= Input.Color.a;
   Output.Color.a *= alpha;
  
   return( Output );   
}

PS_OUTPUT PS_Color( PS_INPUT Input)
{
   PS_OUTPUT Output;
   Output.Color = Input.Color;
   Output.Color.a *= alpha;
   return( Output );   
}

technique TextureBlender
{
  pass P0
  {
    PixelShader  = compile ps_2_0 PS_Texture();
  }
}

technique ColorBlender
{
  pass P0
  {
    PixelShader  = compile ps_2_0 PS_Color();
  }
}
