#define INTERPOLATE_NORMAL_EDGES

bool4 SwitchesA
<
   string UIName = "SwitchesA";
   string UIWidget = "Numeric";
   bool UIVisible =  true;
> = bool4( true, true, true, true );

bool4 SwitchesB
<
   string UIName = "SwitchesB";
   string UIWidget = "Numeric";
   bool UIVisible =  true;
> = bool4( true, true, true, false );

bool4 SwitchesC
<
   string UIName = "SwitchesC";
   string UIWidget = "Numeric";
   bool UIVisible =  true;
> = bool4( true, true, false, false );

float4 RealSize
<
   string UIName = "RealSize";
   string UIWidget = "Numeric";
   bool UIVisible =  false;
   float UIMin = 0.00;
   float UIMax = 10000.00;
> = float4( 0, 0, 0, 0 );

float4 Resolution
<
   string UIName = "Resolution";
   string UIWidget = "Numeric";
   bool UIVisible =  false;
   float UIMin = 0.00;
   float UIMax = 10000.00;
> = float4( 1 / 8000, 0, 0, 0 );

/* HeightPars1: x = 1.0 / ( h2 - h1 ); y = h1 / ( h1 - h2 ); z = 1.0 / ( h2w - h1w ); w = h1w / ( h1w - h2w );
  h1, h2 ..begin & end height (in metres) for terrain gradient and contours; h1w, h2w ..begin & end height for water gradient  */
float4 HeightPars1
<
   string UIName = "HeightPars1";
   string UIWidget = "Numeric";
   bool UIVisible =  false;
   float UIMin = 0.00;
   float UIMax = 10000.00;
> = float4( 1.0 / 4000.0, 0, 1.0 / 1000.0, 1.0 );

/* ContourStepKoef = ( h2 - h1 ) / contourStep;
  h1,h2 ..viz HeightPars1; contourStep .. height between contours; */
float ContourStepKoef
<
   string UIName = "ContourStepKoef";
   string UIWidget = "Numeric";
   bool UIVisible =  false;
   float UIMin = 1.00;
   float UIMax = 100.00;
> = float( 13 );

float2 SourceResXY
<
   string UIName = "SourceResXY";
   string UIWidget = "Numeric";
   bool UIVisible =  false;
   float UIMin = 8.00;
   float UIMax = 4096.00;
> = float2( 512.00, 512.00 );


float fTime0_X : Time0_X;

float4 LightPosPars
<
   string UIName = "LightPosPars";
   string UIWidget = "Direction";
   bool UIVisible =  false;
   float4 UIMin = float4( 0.00, 0.00, 0.00, 0.00 );
   float4 UIMax = float4( 180.00, 180.00, 180.00, 180.00 );
   bool Normalize =  false;
> = float4( 60.0, 22.0, 30.60, 1.00 );
//> = float4( 88.20, 25.40, 30.60, 1.00 );

float ContourHeightBlur
<
   string UIName = "ContourHeightBlur";
   string UIWidget = "Numeric";
   bool UIVisible =  true;
   float UIMin = 0.00;
   float UIMax = 10.00;
> = float( 1.00 );

float ContourStep0
<
   string UIName = "ContourStep0";
   string UIWidget = "Numeric";
   bool UIVisible =  true;
   float UIMin = 1.00;
   float UIMax = 100.00;
> = float( 16.00 );

float ContourOffset0
<
   string UIName = "ContourOffset0";
   string UIWidget = "Numeric";
   bool UIVisible =  true;
   float UIMin = 0.00;
   float UIMax = 10.00;
> = float( 4.00 );

float4 ContourPars
<
   string UIName = "ContourPars";
   string UIWidget = "Direction";
   bool UIVisible =  false;
   float4 UIMin = float4( 0.00, 0.00, 0.00, 0.00 );
   float4 UIMax = float4( 2.00, 2.00, 2.00, 2.00 );
   bool Normalize =  false;
> = float4( 0.00, 1.5, 0.67, 0.50 );

int4 GradientPars
<
   string UIName = "GradientPars";
   string UIWidget = "Numeric";
   bool UIVisible =  true;
   int UIMin = 0;
   int UIMax = 32;
> = int4( 8, 32, 0, 0 );

// Max height is 4000 meters
// Gradient scale is set to 1/4000
float4 GradientScale
<
   string UIName = "GradientScale";
   string UIWidget = "Direction";
   bool UIVisible =  false;
   float4 UIMin = float4( 0.00, 0.00, 0.00, 0.00 );
   float4 UIMax = float4( 1.00, 1.00, 1.00, 1.00 );
   bool Normalize =  false;
> = float4( 1.0, 0.04, 0.00, 1.00 );


float4 LightColor
<
   string UIName = "LightColor";
   string UIWidget = "Color";
   bool UIVisible =  false;
> = float4( 0.82, 0.77, 0.66, 0.78 );

float4 SkyColor
<
   string UIName = "SkyColor";
   string UIWidget = "Color";
   bool UIVisible =  false;
> = float4( 0.59, 0.74, 0.95, 0.72 );

float4 MaterialColor
<
   string UIName = "MaterialColor";
   string UIWidget = "Color";
   bool UIVisible =  false;
> = float4( 0.50, 0.50, 0.50, 0.68 );

float4 ContourColor
<
   string UIName = "ContourColor";
   string UIWidget = "Color";
   bool UIVisible =  false;
> = float4( 1.00, 0.00, 0.00, 0.70 );

float ShadowFactor
<
   string UIName = "ShadowFactor";
   string UIWidget = "Numeric";
   bool UIVisible =  false;
   float UIMin = -1.00;
   float UIMax = 1.00;
> = float( 0.70 );

float DarkeningFactor
<
   string UIName = "DarkeningFactor";
   string UIWidget = "Numeric";
   bool UIVisible =  false;
   float UIMin = -1.00;
   float UIMax = 1.00;
> = float( 0.60 );

////////////////////////////////////////////////////////////////////////////////////////////////////
// TEXTURES & SAMPLERS
////////////////////////////////////////////////////////////////////////////////////////////////////

// height map
texture HeightMap_Tex
<
   string ResourceName = ".\\Textures\\TOPOMAP1.tga";
>;
// height map sampler (nearest sampling)
sampler2D Texture0 = sampler_state
{
   Texture = (HeightMap_Tex);
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   MINFILTER = POINT;
   MIPFILTER = NONE;
   MAGFILTER = POINT;
};
sampler2D Texture0L = sampler_state
{
   Texture = (HeightMap_Tex);
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   MINFILTER = LINEAR;
   MIPFILTER = NONE;
   MAGFILTER = LINEAR;
};

// RT A (normal map)
texture RT_A_Tex : RenderColorTarget
<
   float2 RenderTargetDimensions = {512,512};
   string Format="D3DFMT_A8R8G8B8";
   float  ClearDepth=1.000000;
   int    ClearColor=-16777216;
>;
// RT A sampler
sampler2D Texture1 = sampler_state
{
   Texture = (RT_A_Tex);
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   MINFILTER = POINT;
   MIPFILTER = NONE;
   MAGFILTER = POINT;
};
sampler2D Texture1L = sampler_state
{
   Texture = (RT_A_Tex);
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   MINFILTER = LINEAR;
   MIPFILTER = NONE;
   MAGFILTER = LINEAR;
};

// RT B (shadow mask)
texture RT_B_Tex : RenderColorTarget
<
   float2 RenderTargetDimensions = {1024,1024};
   string Format="D3DFMT_A8R8G8B8";
   float  ClearDepth=1.000000;
   int    ClearColor=-16777216;
>;
// RT B sampler
sampler2D Texture2 = sampler_state
{
   Texture = (RT_B_Tex);
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   MINFILTER = POINT;
   MIPFILTER = NONE;
   MAGFILTER = POINT;
};
sampler2D Texture2L = sampler_state
{
   Texture = (RT_B_Tex);
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   MINFILTER = LINEAR;
   MIPFILTER = NONE;
   MAGFILTER = LINEAR;
};

// gradients texture
texture Gradients_Tex
<
   string ResourceName = ".\\Textures\\Gradients.tga";
>;
// gradients texture sampler
sampler2D Texture3 = sampler_state
{
   Texture = (Gradients_Tex);
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   MINFILTER = POINT;
   MIPFILTER = NONE;
   MAGFILTER = POINT;
};
sampler2D Texture3L = sampler_state
{
   Texture = (Gradients_Tex);
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   MINFILTER = LINEAR;
   MIPFILTER = NONE;
   MAGFILTER = LINEAR;
};

// diffuse map
texture DiffuseMap_Tex
<
   string ResourceName = ".\\Textures\\DiffuseMap.tga";
>;
sampler2D Texture4 = sampler_state
{
   Texture = (DiffuseMap_Tex);
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   MAGFILTER = POINT;
   MINFILTER = POINT;
   MIPFILTER = NONE;
};
sampler2D Texture4L = sampler_state
{
   Texture = (DiffuseMap_Tex);
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   MAGFILTER = LINEAR;
   MINFILTER = LINEAR;
   MIPFILTER = LINEAR;
};

// RT C (contour map)
texture RT_C_Tex : RenderColorTarget
<
   float2 RenderTargetDimensions = {1024,1024};
   string Format="D3DFMT_A8R8G8B8";
   float  ClearDepth=1.000000;
   int    ClearColor=-16777216;
>;
// RT C sampler
sampler2D Texture5 = sampler_state
{
   Texture = (RT_C_Tex);
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   MAGFILTER = POINT;
   MINFILTER = POINT;
   MIPFILTER = NONE;
};
sampler2D Texture5L = sampler_state
{
   Texture = (RT_C_Tex);
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   MAGFILTER = LINEAR;
   MINFILTER = LINEAR;
   MIPFILTER = NONE;
};

// RT D (contour map)
texture RT_D_Tex : RenderColorTarget
<
   float2 RenderTargetDimensions = {1024,1024};
   string Format="D3DFMT_A8R8G8B8";
   float  ClearDepth=1.000000;
   int    ClearColor=-16777216;
>;
// RT D sampler
sampler2D Texture6 = sampler_state
{
   Texture = (RT_D_Tex);
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   MAGFILTER = POINT;
   MINFILTER = POINT;
   MIPFILTER = NONE;
};
sampler2D Texture6L = sampler_state
{
   Texture = (RT_D_Tex);
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   MAGFILTER = LINEAR;
   MINFILTER = LINEAR;
   MIPFILTER = NONE;
};


////////////////////////////////////////////////////////////////////////////////////////////////////
// NormalPass
////////////////////////////////////////////////////////////////////////////////////////////////////

struct NP_VSOut
{
   float4 pos : POSITION0;
   float2 tc0 : TEXCOORD0;
};

NP_VSOut VS_NormalPass( float4 inPos : POSITION )
{
   NP_VSOut o = ( NP_VSOut )0;
   float2 pos0 = sign( inPos.xy );
   o.pos = float4( pos0, 0.0f, 1.0f);
   float2 eps = float2( 0.5 * Resolution.z, 0.5 * Resolution.w );
   o.tc0 = float2( 0.5 * pos0.x + 0.5, -0.5 * pos0.y + 0.5 ) + eps;
   return o;
}

float4 PS_NormalPass( float2 tc0  : TEXCOORD0 ) : COLOR
{
  half4 final = 1;
  float dx = Resolution.z;
  float dy = Resolution.w;
  float2 sx0 = tex2D( Texture0, tc0 ).ra;
  float3 dir = float3( 0, 0, 1 );
  float3 VerySmallVec3X = float3( 0.00001, 0, 0 );
  float3 VerySmallVec3Y = float3( 0, 0.00001, 0 );
  float rdx = RealSize.x * dx;
  float rdy = RealSize.y * dy;
  float normScale = 1.0;
  if( sx0.y >= 0.99999 )
  {
    // X
    float2 sx1p = tex2D( Texture0, tc0 + float2( dx, 0 ) ).ra;
    float2 sx1n = tex2D( Texture0, tc0 - float2( dx, 0 ) ).ra;
    float3 dirX1n = float3( rdx, 0, ( sx0.x - sx1n.x ) * normScale );
    float3 dirX1p = float3( rdx, 0, ( sx1p.x - sx0.x ) * normScale );
    float3 dirX = normalize( normalize( dirX1n ) * sx1n.y + normalize( dirX1p ) * sx1p.y + VerySmallVec3X );
 #ifndef INTERPOLATE_NORMAL_EDGES
    float kx = sx0.y * sx1p.y * sx1n.y;
    dirX = lerp( float3( 1, 0, 0 ), dirX, kx ); 
 #endif
    // Y
    float2 sy0 = sx0;
    float2 sy1p = tex2D( Texture0, tc0 + float2( 0, dy ) ).ra;
    float2 sy1n = tex2D( Texture0, tc0 - float2( 0, dy ) ).ra;
    float3 dirY1n = float3( 0, rdy, ( sy0.x - sy1n.x ) * normScale );
    float3 dirY1p = float3( 0, rdy, ( sy1p.x - sy0.x ) * normScale );
    float3 dirY = normalize( normalize( dirY1n ) * sy1n.y + normalize( dirY1p ) * sy1p.y + VerySmallVec3Y );
#ifndef INTERPOLATE_NORMAL_EDGES
    float ky = sy0.y * sy1p.y * sy1n.y;
    dirY = lerp( float3( 0, 1, 0 ), dirY, ky );
#endif
    // final normal dir
    dir = cross( dirX, dirY );
  }
  
  final.rgb = dir.rgb * float3( 0.5, -0.5, 0.5  ) + 0.5;
  //final.a = kx;
  return final;
}


////////////////////////////////////////////////////////////////////////////////////////////////////
// ShadowPass
////////////////////////////////////////////////////////////////////////////////////////////////////

struct VSOut
{
   float4 pos : POSITION0;
   float4 tc0 : TEXCOORD0;
   float4 tc1 : TEXCOORD1;
   float4 tc2 : TEXCOORD2;
   float4 tc3 : TEXCOORD3;
   float4 tc4 : TEXCOORD4;
   float4 tc5 : TEXCOORD5;
   float4 tc6 : TEXCOORD6;
};

half3 ComputeLightDir()
{
  half3 dir = 0;
  float kDeg2Rad = 0.0174533f;
  float azimut = LightPosPars.x;
  float elevace = LightPosPars.y * kDeg2Rad;
  if( SwitchesB.w )
    azimut = LightPosPars.z * fTime0_X;
  azimut *= kDeg2Rad;
  dir.x = sin( azimut );
  dir.y = cos( azimut );
  dir.z = sin( elevace );
  dir.xy *= cos( elevace );
  return dir;
}

VSOut VS_ShadowPass( float4 inPos: POSITION )
{
  VSOut o = ( VSOut )0;
  float2 pos0 = sign( inPos.xy );
  o.pos = float4( pos0, 0.0f, 1.0f);
  float2 eps = float2( 0.5 * Resolution.z, 0.5 * Resolution.w );
  o.tc0.xy = float2( 0.5 * pos0.x + 0.5, -0.5 * pos0.y + 0.5 );
  o.tc1.xyz = normalize( ComputeLightDir() );
  return o;
}

float4 PS_ShadowPass( VSOut i ) : COLOR
{
  half4 final = 1;
  float2 tc0 = i.tc0;
  float dx = Resolution.z;
  float dy = Resolution.w;
  float2 tex = tex2D( Texture0, tc0 ).ra;
  float h0 = tex.x;
  final.g = tex.y;
  float3 dir = i.tc1.xyz;
  float r = 1.0f / max( abs( dir.x ), abs( dir.y ) );
  dir.xyz *= r;
  const int loopCount = 150;
  dir.xyz *= 2;
  float2 dtc = dir.xy * float2( dx, -dy );
  float dh = dir.z * dx * RealSize.x;
  float h;
  for( int i = 0; i < loopCount; i++ )
  {
    tc0 += dtc;
    h0 += dh;
    h = tex2Dlod( Texture0, float4( tc0, 0, 0 ) ).r;
    if( h0 - h <= 0 )
    {
      final.r = 0;
      break;
    }
  }
  return final;
}


////////////////////////////////////////////////////////////////////////////////////////////////////
// BlurH  - height map horizontal blur to RT_C
////////////////////////////////////////////////////////////////////////////////////////////////////

VSOut VS_BlurH( float4 inPos: POSITION )
{
   VSOut o = ( VSOut )0;
   float2 pos0 = sign( inPos.xy );
   float2 tc0 = float2( 0.5 * pos0.x + 0.5, -0.5 * pos0.y + 0.5 );
   o.pos = float4( pos0, 0.0f, 1.0f);
   float2 dir = float2( Resolution.z, 0 ) * ContourHeightBlur;
   float2 tc = tc0 - dir * 3;
   o.tc0.xy = tc; tc += dir;
   o.tc1.xy = tc; tc += dir;
   o.tc2.xy = tc; tc += dir;
   o.tc3.xy = tc; tc += dir;
   o.tc4.xy = tc; tc += dir;
   o.tc5.xy = tc; tc += dir;
   o.tc6.xy = tc;
   o.tc3.a = 0.24;
   o.tc2.a = o.tc4.a = 0.20;
   o.tc1.a = o.tc5.a = 0.12;
   o.tc0.a = o.tc6.a = 0.06;
   return o;
}

float4 PS_BlurH( VSOut i ) : COLOR
{
  float4 final = 0;
  float sum = 0;
  float4 s;
  float w = 0;
  float t = 0.99999; 
  float4 hPars1 = HeightPars1;

  s = tex2D( Texture0, i.tc0.xy );
  if( s.a > t ) { sum += s.x * i.tc0.a; w += i.tc0.a; }
  
  s = tex2D( Texture0, i.tc1.xy );
  if( s.a > t ) { sum += s.x * i.tc1.a; w += i.tc1.a; }
  
  s = tex2D( Texture0, i.tc2.xy );
  if( s.a > t ) { sum += s.x * i.tc2.a; w += i.tc2.a; }
  
  s = tex2D( Texture0, i.tc3.xy );
  final.a = s.a;
  if( s.a > t ) { sum += s.x * i.tc3.a; w += i.tc3.a; }
  
  s = tex2D( Texture0, i.tc4.xy );
  if( s.a > t ) { sum += s.x * i.tc4.a; w += i.tc4.a; }
  
  s = tex2D( Texture0, i.tc5.xy );
  if( s.a > t ) { sum += s.x * i.tc5.a; w += i.tc5.a; }
  
  s = tex2D( Texture0, i.tc6.xy );
  if( s.a > t ) { sum += s.x * i.tc6.a; w += i.tc6.a; }
  
  if( w > 0.0 )
  {
    float h = sum / w;
    final.rgb = saturate( hPars1.x * h + hPars1.y );
  }
  return final;
}


////////////////////////////////////////////////////////////////////////////////////////////////////
// BlurV  - height map vertical blur ( from RT_C to RT_D )
////////////////////////////////////////////////////////////////////////////////////////////////////

VSOut VS_BlurV( float4 inPos: POSITION )
{
   VSOut o = ( VSOut )0;
   float2 pos0 = sign( inPos.xy );
   float2 tc0 = float2( 0.5 * pos0.x + 0.5, -0.5 * pos0.y + 0.5 );
   o.pos = float4( pos0, 0.0f, 1.0f);
   float2 dir = float2( 0, Resolution.w ) * ContourHeightBlur;
   float2 tc = tc0 - dir * 3;
   o.tc0.xy = tc; tc += dir;
   o.tc1.xy = tc; tc += dir;
   o.tc2.xy = tc; tc += dir;
   o.tc3.xy = tc; tc += dir;
   o.tc4.xy = tc; tc += dir;
   o.tc5.xy = tc; tc += dir;
   o.tc6.xy = tc;
   o.tc3.a = 0.24;
   o.tc2.a = o.tc4.a = 0.20;
   o.tc1.a = o.tc5.a = 0.12;
   o.tc0.a = o.tc6.a = 0.06;
   return o;
}

float4 PS_BlurV( VSOut i ) : COLOR
{
  float4 final = 0;
  float sum = 0;
  float4 s;
  float w = 0;
  float t = 0.99999; 

  s = tex2D( Texture5, i.tc0.xy );
  if( s.a > t ) { sum += s.x * i.tc0.a; w += i.tc0.a; }
  
  s = tex2D( Texture5, i.tc1.xy );
  if( s.a > t ) { sum += s.x * i.tc1.a; w += i.tc1.a; }
  
  s = tex2D( Texture5, i.tc2.xy );
  if( s.a > t ) { sum += s.x * i.tc2.a; w += i.tc2.a; }
  
  s = tex2D( Texture5, i.tc3.xy );
  final.a = s.a;
  if( s.a > t ) { sum += s.x * i.tc3.a; w += i.tc3.a; }
  
  s = tex2D( Texture5, i.tc4.xy );
  if( s.a > t ) { sum += s.x * i.tc4.a; w += i.tc4.a; }
  
  s = tex2D( Texture5, i.tc5.xy );
  if( s.a > t ) { sum += s.x * i.tc5.a; w += i.tc5.a; }
  
  s = tex2D( Texture5, i.tc6.xy );
  if( s.a > t ) { sum += s.x * i.tc6.a; w += i.tc6.a; }
  
  if( w > 0.0 )
    final.rgb = sum / w;
  
  return final;
}


////////////////////////////////////////////////////////////////////////////////////////////////////
// ContourA
////////////////////////////////////////////////////////////////////////////////////////////////////

VSOut VS_ContourA( float4 inPos: POSITION )
{
   VSOut o = ( VSOut )0;
   float2 pos0 = sign( inPos.xy );
   float2 tc0 = float2( 0.5 * pos0.x + 0.5, -0.5 * pos0.y + 0.5 );
   o.pos = float4( pos0, 0.0f, 1.0f);
   o.tc0.xy = tc0;
   return o;
}

float4 PS_ContourA( VSOut i ) : COLOR
{
  half4 final = 1;
  float4 hPars1 = HeightPars1;
  
  float4 s = tex2D( Texture6, i.tc0.xy );
  float h; 
  float k1; 
  h = s.x;
  k1 = ContourStepKoef;
  float steps = int( h * k1 ) / k1;
  final.rgb = steps;
  final.a = s.a;
  return final;
}


////////////////////////////////////////////////////////////////////////////////////////////////////
// ContourB
////////////////////////////////////////////////////////////////////////////////////////////////////

VSOut VS_ContourB( float4 inPos: POSITION )
{
   VSOut o = ( VSOut )0;
   float2 pos0 = sign( inPos.xy );
   float2 tc0 = float2( 0.5 * pos0.x + 0.5, -0.5 * pos0.y + 0.5 );
   o.pos = float4( pos0, 0.0f, 1.0f);
   float dx = ContourPars.z * Resolution.z;
   float dy = ContourPars.z * Resolution.w;
   dx *= 2; dy *= 2;
   float2 e = float2( ContourPars.w * Resolution.z, ContourPars.w * Resolution.w );
   tc0 += e;
   o.tc0.xy = tc0;
   o.tc1.xy = tc0 + float2( dx, 0 );
   o.tc1.zw = tc0 + float2( dx, -dy );
   o.tc2.xy = tc0 + float2( 0, -dy );
   o.tc2.zw = tc0 + float2( -dx, -dy );
   o.tc3.xy = tc0 + float2( -dx, 0 );
   o.tc3.zw = tc0 + float2( -dx, dy );
   o.tc4.xy = tc0 + float2( 0, dy );
   o.tc4.zw = tc0 + float2( dx, dy );
   return o;
}

float4 PS_ContourB( VSOut i ) : COLOR
{
  half4 final = 0;
  float t = 0.99999;
  float2 s0 = tex2D( Texture5L, i.tc0.xy ).ra;
  if( s0.y > t )
  {
    float d = s0.x;
    float sum = 0;
    float w = 0;
    float2 s;
    s = tex2D( Texture5L, i.tc1.xy ).ra;
    if( s.y > t ) { sum += abs( d - s.x ); w += 1; }
    s = tex2D( Texture5L, i.tc1.zw ).ra;
    if( s.y > t ) { sum += abs( d - s.x ); w += 1; }
    s = tex2D( Texture5L, i.tc2.xy ).ra;
    if( s.y > t ) { sum += abs( d - s.x ); w += 1; }
    s = tex2D( Texture5L, i.tc2.zw ).ra;
    if( s.y > t ) { sum += abs( d - s.x ); w += 1; }
    s = tex2D( Texture5L, i.tc3.xy ).ra;
    if( s.y > t ) { sum += abs( d - s.x ); w += 1; }
    s = tex2D( Texture5L, i.tc3.zw ).ra;
    if( s.y > t ) { sum += abs( d - s.x ); w += 1; }
    s = tex2D( Texture5L, i.tc4.xy ).ra;
    if( s.y > t ) { sum += abs( d - s.x ); w += 1; }
    s = tex2D( Texture5L, i.tc4.zw ).ra;
    if( s.y > t ) { sum += abs( d - s.x ); w += 1; }
    
    //if( w > 0 )
    {
      final.rgb = ( sum - ContourPars.x ) * ContourPars.y * ContourStepKoef / w;
    }
      
  }
  return final;
}


////////////////////////////////////////////////////////////////////////////////////////////////////
// FinalColor
////////////////////////////////////////////////////////////////////////////////////////////////////

struct FC_VSOut
{
   float4 pos : POSITION0;
   float4 tc0 : TEXCOORD0;
   float4 tc1 : TEXCOORD1;
};

FC_VSOut VS_FinalColor( float4 inPos: POSITION )
{
   FC_VSOut o = ( FC_VSOut )0;
   float2 pos0 = sign( inPos.xy );
   o.pos = float4( pos0, 0.0f, 1.0f);
   float2 eps = 0.5 * float2( Resolution.z, Resolution.w );
   o.tc0.xy = float2( 0.5 * pos0.x + 0.5, -0.5 * pos0.y + 0.5 ) + eps;
   o.tc0.zw = 0.5 * float2( Resolution.z, Resolution.w );
   o.tc1.xyz = ComputeLightDir(); 

   return o;
}



//-------------------------------------------------------------------------------
half3 RemoveGamma22( half3 color )
{
  return pow( color, 1.0f/2.2f );
}

//-------------------------------------------------------------------------------
half3 AplyGamma22( half3 color )
{
  return pow( color, 2.2f );
}

//===============================================================================
float4 PS_FinalColor( FC_VSOut i ) : COLOR
{
  float4 hPars1 = HeightPars1;
  
  half4 final = 1;
  float2 tc0 = i.tc0.xy;
  float2 dtc = i.tc0.zw;
  half3 lightDir = i.tc1.xyz;
  float4 hmap = tex2D( Texture0, tc0 );
  float h = hmap.r;
  half4 normTex = tex2D( Texture1, tc0 );
  half3 norm = normTex.rgb * 2.0 - 1.0;
  half shadow = 0;
  half sumA = 0;

#if SHADER_VERSION >= 3
  half2 shadowTex = tex2D( Texture2, tc0 + dtc ).rg;
  shadow += shadowTex.x * shadowTex.y; sumA += shadowTex.y;
  shadowTex = tex2D( Texture2, tc0 - dtc ).rg;
  shadow += shadowTex.x * shadowTex.y; sumA += shadowTex.y;
  shadowTex = tex2D( Texture2, tc0 + float2( -dtc.x, dtc.y ) ).rg;
  shadow += shadowTex.x * shadowTex.y; sumA += shadowTex.y;
  shadowTex = tex2D( Texture2, tc0 + float2( dtc.x, -dtc.y ) ).rg;
  shadow += shadowTex.x * shadowTex.y; sumA += shadowTex.y;
  if( sumA > 0 )
  shadow = shadow / sumA;
#else
  shadow = tex2D( Texture2, tc0 ).r;
#endif
  
  
  half3 diffTex = tex2D( Texture4L, tc0 ).rgb;
  half4 contourTex = tex2D( Texture6L, tc0 );
  float v = ( 0.5 + (float)GradientPars.x ) / (float)GradientPars.y;
  float h0;
  float h0w;
  h0 = saturate( h * hPars1.x + hPars1.y );
  h0w = saturate( h * hPars1.z + hPars1.w );
  float waterMask = saturate( 999 - h0w * 1000 );
    
  half3 grad = tex2D( Texture3L, float2( h0, v ) ).rgb;
  half3 gradw = tex2D( Texture3L, float2( h0w, 1 ) ).rgb;
// HACK for sea
if (h <= 0)
{
  waterMask = 1;
  gradw = half3( 0.1, 0.4, 0.6 );
}
  grad.rgb = lerp( grad.rgb, gradw.rgb, waterMask );
  norm = lerp( norm, half3( 0, 0, 1 ), waterMask );

  half3 matColor = MaterialColor.rgb * MaterialColor.a * 2.0;
  if( SwitchesB.y )
    matColor = grad.rgb;
  if( SwitchesB.z )
    matColor = diffTex.rgb;
  matColor.rgb = lerp( matColor.rgb, AplyGamma22( matColor.rgb ), SwitchesC.x );
 
// LIGHTING
  half3 light = 1;
  half3 mainLight = 0;
  half3 hemiLight = 0;
  if( SwitchesA.x )
  {
    half3 lightCol = LightColor.rgb * LightColor.a * 2.0;
    if( SwitchesA.z )
      mainLight = lightCol.rgb * saturate( dot( norm.xyz, lightDir.xyz ) );
    if( SwitchesB.x )
      mainLight *= shadow;
    if( SwitchesA.y )
      hemiLight = SkyColor.rgb * SkyColor.a * 2.0 * normTex.z;
    if( SwitchesA.w )
      hemiLight *= ( DarkeningFactor + ( 1 - DarkeningFactor ) * h0 );
    light = mainLight + hemiLight;
  }
  else
  {
    if( SwitchesB.x )
      light *= ( shadow * ShadowFactor + 1 - ShadowFactor );
  }
  final.rgb = light * matColor.rgb;
  
  final.rgb = lerp( final.rgb, RemoveGamma22( final.rgb ), SwitchesC.x );
  if( SwitchesC.y )
    final.rgb = lerp( final.rgb, ContourColor.rgb, contourTex.r * ContourColor.a );
  if( SwitchesC.w )
    final.rgb = h;
 
  final.a = saturate( hmap.a * 1000.0 - 999.0 );
  
  return final;
}


////////////////////////////////////////////////////////////////////////////////////////////////////
// Gradient - not used
////////////////////////////////////////////////////////////////////////////////////////////////////

struct GR_VSOut
{
   float4 pos : POSITION0;
   float2 tc0 : TEXCOORD0;
};

GR_VSOut VS_Gradient( float4 inPos: POSITION )
{
   GR_VSOut o = ( GR_VSOut )0;
   float2 pos0 = sign( inPos.xy );
   o.pos = float4( pos0, 0.0f, 1.0f);
   o.tc0 = float2( 0.5 * pos0.x + 0.5, -0.5 * pos0.y + 0.5 );
   return o;
}

float4 PS_Gradient( float2 tc0  : TEXCOORD0 ) : COLOR
{
  half4 final = 0;
  float d = -1;
  if( SwitchesB.y && !SwitchesB.z )
    d = 0.020;
  clip( d - tc0.x );
  if( tc0.x < 0.016 )
  {
    float v = ( 0.5 + (float)GradientPars.x ) / (float)GradientPars.y;
    float u = GradientScale.x * ( 1.0 - tc0.y ) + GradientScale.y;
    half4 tex0 = tex2D( Texture3, float2( u, v ) );
    final = tex0;
  }
  return final;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
// Technique Section
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

technique Solution1
{
   pass NormalPass
   <
      string Script = "RenderColorTarget0 = RT_A_Tex;"
                      "ClearColor = (0, 0, 0, 255);"
                      "ClearDepth = 1.000000;";
   >
   {
      CULLMODE = NONE;

      VertexShader = compile vs_2_0 VS_NormalPass();
      PixelShader = compile ps_2_0 PS_NormalPass();
   }

   pass ShadowPass
   <
      string Script = "RenderColorTarget0 = RT_B_Tex;"
                      "ClearColor = (0, 0, 0, 255);"
                      "ClearDepth = 1.000000;";
   >
   {
      CULLMODE = NONE;
#if SHADER_VERSION >= 3
      VertexShader = compile vs_3_0 VS_ShadowPass();
      PixelShader = compile ps_3_0 PS_ShadowPass();
#else
#endif      
   }

   pass BlurH
   <
      string Script = "RenderColorTarget0 = RT_C_Tex;"
                      "ClearColor = (0, 0, 0, 255);"
                      "ClearDepth = 1.000000;";
   >
   {
      CULLMODE = NONE;

      VertexShader = compile vs_2_0 VS_BlurH();
      PixelShader = compile ps_2_0 PS_BlurH();
   }

   pass BlurV
   <
      string Script = "RenderColorTarget0 = RT_D_Tex;"
                      "ClearColor = (0, 0, 0, 255);"
                      "ClearDepth = 1.000000;";
   >
   {
      CULLMODE = NONE;

      VertexShader = compile vs_2_0 VS_BlurV();
      PixelShader = compile ps_2_0 PS_BlurV();
   }

   pass ContourA
   <
      string Script = "RenderColorTarget0 = RT_C;"
                      "ClearColor = (0, 0, 0, 255);"
                      "ClearDepth = 1.000000;";
   >
   {
      CULLMODE = NONE;
      VertexShader = compile vs_2_0 VS_ContourA();
      PixelShader = compile ps_2_0 PS_ContourA();
   }

   pass ContourB
   <
      string Script = "RenderColorTarget0 = RT_D;"
                      "ClearColor = (0, 0, 0, 255);"
                      "ClearDepth = 1.000000;";
   >
   {
      CULLMODE = NONE;

      VertexShader = compile vs_2_0 VS_ContourB();
      PixelShader = compile ps_2_0 PS_ContourB();
   }

   pass FinalColor
   {
      CULLMODE = NONE;
#if SHADER_VERSION >= 3
      VertexShader = compile vs_3_0 VS_FinalColor();
      PixelShader = compile ps_3_0 PS_FinalColor();
#else
      VertexShader = compile vs_2_0 VS_FinalColor();
      PixelShader = compile ps_2_0 PS_FinalColor();
#endif
   }
}

// END OF FILE /////////////////////////////////////////////////////////////////////////////////////
