class ScrollBar
{
	color[]={1,1,1,0.60000002};
	thumb="#(argb,8,8,3)color(1,1,1,1)";
	arrowEmpty="#(argb,8,8,3)color(1,1,1,1)";
	arrowFull="#(argb,8,8,3)color(1,1,1,1)";
	border="#(argb,8,8,3)color(1,1,1,1)";
	shadow=0;
	scrollSpeed=0.0099999998;
	autoScrollEnabled=0;
	autoScrollSpeed=-1;
	autoScrollDelay=5;
	autoScrollRewind=0;
	width=0;
	height=0;
};
class CfgMods
{
	defaultAction="";
};
scriptsPath="scripts\";
startupScript="";
cameraScript="";
playerKilledScript="onPlayerKilled.sqs";
playerRespawnScript="onPlayerRespawn.sqs";
playerRespawnOtherUnitScript="onPlayerRespawnOtherUnit.sqs";
playerRespawnSeagullScript="onPlayerRespawnAsSeagull.sqs";
playerResurrectScript="onPlayerResurrect.sqs";
teamSwitchScript="onTeamSwitch.sqs";
tooltipDelay=0;
class CfgExperience
{
	access=1;
	destroyUnit[]=
	{
		"unit1",
		"unit2",
		"unit3",
		"unit4"
	};
	unit1[]={2000,0};
	unit2[]={200000,200};
	unit3[]={500000,500};
	unit4[]={1000000,1000};
	destroyEnemy=1;
	destroyFriendly=-7;
	destroyCivilian=-5;
	destroyStatic=0;
	destroyYourUnit=-0.2;
	renegadeLimit=-2000;
	playerKilled=0;
	commandCompleted=0;
	commandFailed=0;
	followMe=0;
	missionCompleted=0;
	missionFailed=0;
	ranks[]={0,50,150,250,350,500,750};
};
class CfgAISkill
{
	aimingAccuracy[]={0,0,1,1};
	aimingShake[]={0,0,1,1};
	aimingSpeed[]={0,0.5,1,1};
	endurance[]={0,0,1,1};
	spotDistance[]={0,0.2,1,0.40000001};
	spotTime[]={0,0,1,0.69999999};
	courage[]={0,0,1,1};
	reloadSpeed[]={0,0,1,1};
	commanding[]={0,0,1,1};
	general[]={0,0,1,1};
};
class CfgAILevelPresets
{
	class AILevelLow
	{
		displayName="$STR_AILEVEL_NOVICE";
		skillAI=0.5;
		precisionAI=0.2;
	};
	class AILevelMedium
	{
		displayName="$STR_AILEVEL_NORMAL";
		skillAI=0.69999999;
		precisionAI=0.5;
	};
	class AILevelHigh
	{
		displayName="$STR_AILEVEL_EXPERT";
		skillAI=0.80000001;
		precisionAI=0.69999999;
	};
	class Custom
	{
		displayName="$STR_AILEVEL_CUSTOM";
		skillAI=0.5;
		precisionAI=0.5;
	};
};
class CfgDifficultyPresets
{
	defaultPreset="Regular";
	myArmorCoef=1.5;
	groupArmorCoef=1.5;
	fadeDistanceStart=40;
	fadeDistanceSpan=10;
	recoilCoef=1;
	visionAidCoef=0.80000001;
	divingLimitMultiplier=1;
	animSpeedCoef=0;
	cancelThreshold=0;
	showCadetHints=1;
	showCadetWP=1;
	class Recruit
	{
		displayName="$STR_Difficulty0";
		description="$STR_Difficulty0_desc";
		levelAI="AILevelLow";
		class Options
		{
			reducedDamage=1;
			groupIndicators=2;
			friendlyTags=2;
			enemyTags=0;
			detectedMines=2;
			commands=2;
			waypoints=2;
			tacticalPing=1;
			weaponInfo=2;
			stanceIndicator=2;
			staminaBar=1;
			weaponCrosshair=1;
			visionAid=1;
			squadRadar=1;
			thirdPersonView=1;
			cameraShake=1;
			scoreTable=1;
			deathMessages=1;
			vonID=1;
			mapContent=1;
			autoReport=1;
			multipleSaves=1;
		};
	};
	class Regular
	{
		displayName="$STR_Difficulty1";
		description="$STR_Difficulty1_desc";
		levelAI="AILevelMedium";
		class Options
		{
			reducedDamage=0;
			groupIndicators=2;
			friendlyTags=2;
			enemyTags=0;
			detectedMines=2;
			commands=2;
			waypoints=2;
			tacticalPing=1;
			weaponInfo=2;
			stanceIndicator=2;
			staminaBar=1;
			weaponCrosshair=1;
			visionAid=0;
			squadRadar=1;
			thirdPersonView=1;
			cameraShake=1;
			scoreTable=1;
			deathMessages=1;
			vonID=1;
			mapContent=1;
			autoReport=1;
			multipleSaves=1;
		};
	};
	class Veteran
	{
		displayName="$STR_Difficulty2";
		description="$STR_Difficulty2_desc";
		levelAI="AILevelHigh";
		class Options
		{
			reducedDamage=0;
			groupIndicators=0;
			friendlyTags=0;
			enemyTags=0;
			detectedMines=0;
			commands=1;
			waypoints=1;
			tacticalPing=0;
			weaponInfo=1;
			stanceIndicator=1;
			staminaBar=0;
			weaponCrosshair=0;
			visionAid=0;
			squadRadar=0;
			thirdPersonView=0;
			cameraShake=1;
			scoreTable=1;
			deathMessages=1;
			vonID=1;
			mapContent=0;
			autoReport=0;
			multipleSaves=0;
		};
	};
	class Custom
	{
		displayName="$STR_Difficulty_Custom";
		description="$STR_Difficulty_Custom_desc";
		levelAI="AILevelMedium";
		class Options
		{
			reducedDamage=0;
			groupIndicators=0;
			friendlyTags=0;
			enemyTags=0;
			detectedMines=0;
			commands=0;
			waypoints=0;
			tacticalPing=0;
			weaponInfo=1;
			stanceIndicator=0;
			staminaBar=0;
			weaponCrosshair=0;
			visionAid=0;
			squadRadar=0;
			thirdPersonView=0;
			cameraShake=0;
			scoreTable=0;
			deathMessages=0;
			vonID=0;
			mapContent=0;
			autoReport=0;
			multipleSaves=0;
		};
	};
};
class CfgDifficulties
{
	default="Regular";
	defaultNormal="Regular";
	defaultEasy="Regular";
	defaultHard="Veteran";
	class Recruit
	{
		displayName="$STR_Difficulty0";
		description="$STR_Difficulty0_desc";
		showCadetHints=1;
		showCadetWP=1;
		maxPilotHeight=150;
		scoreImage="#(argb,8,8,3)color(1,1,1,1)";
		scoreChar="o";
		badScoreImage="#(argb,8,8,3)color(1,1,1,1)";
		badScoreChar="X";
		levelAI="AILevelLow";
		myArmorCoef=5;
		groupArmorCoef=4;
		peripheralVisionAid=0.80000001;
		visionAid=0.80000001;
		recoilCoef=1;
		autoReload=0;
		animSpeedCoef=0;
		HealSpeedMedicMedikit=0.1;
		HealSpeedMedicFAK=0.1;
		HealSpeedMedic=0.1;
		HealSpeedSoldierFAK=0.039999999;
		HealSpeedSoldier=0.039999999;
		BleedingRate=0.079999998;
		CancelThreshold=0.2;
		DivingLimitMultiplier=1;
		class Flags
		{
			armor[]={1,1};
			friendlyTag[]={1,1};
			enemyTag[]={0,1};
			mineTag[]={1,1};
			hud[]={1,1};
			hudPerm[]={1,1};
			hudWp[]={1,1};
			hudWpPerm[]={1,1};
			stanceIndicator[]={1,1};
			staminaBar[]={1,1};
			autoSpot[]={1,1};
			map[]={1,1};
			weaponCursor[]={1,1};
			autoGuideAT[]={1,1};
			clockIndicator[]={1,1};
			3rdPersonView[]={1,1};
			unlimitedSaves[]={0,0};
			deathMessages[]={1,1};
			netStats[]={1,1};
			vonID[]={1,1};
			cameraShake[]={0,1};
			hudGroupInfo[]={1,1};
		};
	};
	class Regular
	{
		displayName="$STR_Difficulty1";
		description="$STR_Difficulty1_desc";
		showCadetHints=1;
		showCadetWP=1;
		maxPilotHeight=400;
		scoreImage="#(argb,8,8,3)color(1,1,1,1)";
		scoreChar="o";
		badScoreImage="#(argb,8,8,3)color(1,1,1,1)";
		badScoreChar="X";
		levelAI="AILevelMedium";
		myArmorCoef=3;
		groupArmorCoef=2.4000001;
		peripheralVisionAid=0.89999998;
		visionAid=0;
		HealSpeedMedicMedikit=0.1;
		HealSpeedMedicFAK=0.1;
		HealSpeedMedic=0.1;
		HealSpeedSoldierFAK=0.039999999;
		HealSpeedSoldier=0.039999999;
		BleedingRate=0.079999998;
		CancelThreshold=0.2;
		DivingLimitMultiplier=1;
		recoilCoef=1;
		autoReload=0;
		animSpeedCoef=0;
		class Flags
		{
			armor[]={1,1};
			friendlyTag[]={1,1};
			enemyTag[]={0,1};
			mineTag[]={1,1};
			hud[]={1,1};
			hudPerm[]={1,1};
			hudWp[]={1,1};
			hudWpPerm[]={1,1};
			stanceIndicator[]={1,1};
			staminaBar[]={1,1};
			autoSpot[]={1,1};
			map[]={1,1};
			weaponCursor[]={1,1};
			autoGuideAT[]={1,1};
			clockIndicator[]={1,1};
			3rdPersonView[]={1,1};
			unlimitedSaves[]={1,1};
			deathMessages[]={1,1};
			netStats[]={1,1};
			vonId[]={1,1};
			cameraShake[]={1,1};
			hudGroupInfo[]={1,1};
		};
	};
	class Veteran
	{
		displayName="$STR_Difficulty2";
		description="$STR_Difficulty2_desc";
		showCadetHints=0;
		showCadetWP=1;
		maxPilotHeight=10000;
		scoreImage="#(argb,8,8,3)color(1,1,1,1)";
		scoreChar="*";
		badScoreImage="#(argb,8,8,3)color(1,1,1,1)";
		badScoreChar="X";
		levelAI="AILevelHigh";
		myArmorCoef=1.2;
		groupArmorCoef=1.1;
		peripheralVisionAid=0.60000002;
		visionAid=0;
		HealSpeedMedicMedikit=0.1;
		HealSpeedMedicFAK=0.1;
		HealSpeedMedic=0.1;
		HealSpeedSoldierFAK=0.039999999;
		HealSpeedSoldier=0.039999999;
		BleedingRate=0.079999998;
		CancelThreshold=0.2;
		DivingLimitMultiplier=1;
		recoilCoef=1;
		autoReload=0;
		animSpeedCoef=0;
		class Flags
		{
			armor[]={0,0};
			friendlyTag[]={0,0};
			enemyTag[]={0,0};
			mineTag[]={0,0};
			hud[]={1,1};
			hudPerm[]={0,0};
			hudWp[]={1,1};
			hudWpPerm[]={1,1};
			stanceIndicator[]={1,1};
			staminaBar[]={1,1};
			autoSpot[]={0,0};
			map[]={0,0};
			weaponCursor[]={1,1};
			autoGuideAT[]={0,0};
			clockIndicator[]={1,1};
			3rdPersonView[]={1,1};
			unlimitedSaves[]={0,0};
			deathMessages[]={1,1};
			netStats[]={1,1};
			vonId[]={0,1};
			cameraShake[]={1,1};
			hudGroupInfo[]={1,1};
		};
	};
	class Mercenary
	{
		displayName="$STR_Difficulty3";
		description="$STR_Difficulty3_desc";
		showCadetHints=0;
		showCadetWP=0;
		maxPilotHeight=10000;
		scoreImage="#(argb,8,8,3)color(1,1,1,1)";
		scoreChar="*";
		badScoreImage="#(argb,8,8,3)color(1,1,1,1)";
		badScoreChar="X";
		levelAI="AILevelHigh";
		myArmorCoef=1;
		groupArmorCoef=1;
		peripheralVisionAid=0.25;
		visionAid=0;
		HealSpeedMedicMedikit=0.1;
		HealSpeedMedicFAK=0.1;
		HealSpeedMedic=0.1;
		HealSpeedSoldierFAK=0.039999999;
		HealSpeedSoldier=0.039999999;
		BleedingRate=0.079999998;
		CancelThreshold=0.2;
		DivingLimitMultiplier=1;
		recoilCoef=1;
		autoReload=0;
		animSpeedCoef=0;
		class Flags
		{
			armor[]={0,0};
			friendlyTag[]={0,0};
			enemyTag[]={0,0};
			mineTag[]={0,0};
			hud[]={1,1};
			hudPerm[]={0,0};
			hudWp[]={0,0};
			hudWpPerm[]={0,0};
			stanceIndicator[]={0,0};
			staminaBar[]={0,0};
			autoSpot[]={0,0};
			map[]={0,0};
			weaponCursor[]={1,1};
			autoGuideAT[]={0,0};
			clockIndicator[]={0,0};
			3rdPersonView[]={0,0};
			unlimitedSaves[]={0,0};
			deathMessages[]={1,1};
			netStats[]={1,1};
			vonID[]={0,1};
			cameraShake[]={1,0};
			hudGroupInfo[]={0,0};
		};
	};
};
class CfgInventory
{
	class SlotTypes
	{
		class WeaponInUse
		{
		};
		class RightHand
		{
		};
		class LeftHand
		{
		};
		class Googles
		{
		};
		class Back
		{
		};
		class Weapon
		{
		};
		class Common
		{
		};
		class EarPhones
		{
		};
	};
	class Objects
	{
		class Man
		{
			simulation="Man";
			class InventorySlots
			{
				class Weapon
				{
					type="WeaponInUse";
					size=1;
				};
				class RightHand
				{
					type="RightHand";
					size=1;
				};
				class LeftHand
				{
					type="LeftHand";
					size=1;
				};
				class Goggles
				{
					type="Goggles";
					size=1;
				};
				class Back
				{
					type="Back";
					size=1;
				};
				class EarPhones
				{
					type="EarPhones";
					size=1;
				};
			};
		};
		class Rucksack
		{
			simulation="Baggage";
			weight=1.5;
			class InventoryPlacements
			{
				class OnBack
				{
					type="Back";
					size=1;
					priority=1;
				};
				class InHands
				{
					type="WeaponInUse";
					size=1;
					priority=0;
				};
			};
			class InventorySlots
			{
				class Inside
				{
					type="Common";
					size=16;
				};
				class Weapon1
				{
					type="Weapon";
					size=1;
				};
				class Weapon2
				{
					type="Weapon";
					size=1;
				};
				class Bottle
				{
					type="Bottle";
					size=1;
				};
			};
		};
		class Bottle
		{
			simulation="InventoryItem";
			weight=0.5;
			class InventoryPlacements
			{
				class Bottle
				{
					type="Bottle";
					size=1;
					priority=1;
				};
			};
		};
	};
};
class CfgCurator
{
	class EditingArea
	{
		class 2D
		{
			textureBorder="";
			colorBorder[]={1,1,1,1};
			iconSizeMultiplier=0.0020000001;
		};
		class 3D
		{
			objectBorder="";
		};
	};
	class DrawCamera
	{
		class 2D
		{
			texture="";
			color[]={0,0,0,1};
			maxLineDistance=1000;
		};
	};
	class DrawGroup
	{
		textureWest="#(argb,1,1,1)color(1,1,1,0)";
		textureEast="#(argb,1,1,1)color(1,1,1,0)";
		textureGuer="#(argb,1,1,1)color(1,1,1,0)";
		textureCivilian="#(argb,1,1,1)color(1,1,1,0)";
		textureUnknown="#(argb,1,1,1)color(1,1,1,0)";
	};
	class DrawObject
	{
		iconSize=0.64999998;
		iconDriver="#(argb,1,1,1)color(1,1,1,0)";
		iconCommander="#(argb,1,1,1)color(1,1,1,0)";
		iconGunner="#(argb,1,1,1)color(1,1,1,0)";
		iconCargo="#(argb,1,1,1)color(1,1,1,0)";
		class PlayerPings
		{
			animationLength=6000;
			alowRepeatAfter=4000;
		};
		class 3D
		{
			colorLogic[]={1,1,1,1};
			colorLogicBackground[]={0.5,0.5,0.5,1};
			colorLogicDisabled[]={1,1,1,1};
			colorLogicDisabledBackground[]={0.5,0.5,0.5,1};
			alphaNormal=0.30000001;
			alphaNormalBackground=0.15000001;
			alphaSelected=1;
			alphaSelectedBackground=0.5;
			alphaHover=1;
			alphaHoverBackground=1;
			sizeNormal=1;
			sizeSelected=1;
			sizeTarget=1.1;
			sizeCoefStartDistance=50;
			sizeCoefEndDistance=200;
			texture="#(argb,1,1,1)color(1,1,1,0)";
			textureBackground="#(argb,1,1,1)color(1,1,1,0)";
			textureDisabled="#(argb,1,1,1)color(1,1,1,0)";
			textureDisabledBackground="#(argb,1,1,1)color(1,1,1,0)";
			color[]={1,1,1,1};
			colorBackground[]=
			{
				"side"
			};
			colorDisabled[]={1,1,1,1};
			colorDisabledBackground[]=
			{
				"side"
			};
			colorPreview[]={1,1,1,1};
			colorPreviewBackground[]={1,1,1,1};
			colorPreviewDisabled[]={1,0,0,1};
			colorPreviewDisabledBackground[]={1,1,1,1};
			colorSelectionSquare[]={0,1,0,1};
			colorLineGroupingUnits[]={0,1,1,1};
			colorBBoxWhileDragging[]={0,1,1,1};
			colorGroupsPreviewColor[]={0,1,1,1};
			startIconFading=250;
			endIconFading=750;
			startLogicIconFading=1000;
			endLogicIconFading=1500;
		};
		class 2D
		{
			size=26;
			alphaNormal=0.30000001;
			alphaNormalBackground=0.15000001;
			alphaSelected=1;
			alphaSelectedBackground=0.5;
			alphaTarget=1;
			alphaTargetBackground=1;
			sizeNormal=1;
			sizeSelected=1;
			sizeTarget=1.1;
			sizeCoefStartDistance=50;
			sizeCoefEndDistance=200;
			texture="#(argb,1,1,1)color(1,1,1,0)";
			textureBackground="#(argb,8,8,3)color(1,1,1,1)";
			textureDisabled="#(argb,1,1,1)color(1,1,1,0)";
			textureDisabledBackground="#(argb,8,8,3)color(1,1,1,1)";
			color[]={0,0,0,1};
			colorBackground[]=
			{
				"side"
			};
			colorLogic[]={1,0.5,1,1};
			colorLogicBackground[]={1,1,1,1};
			colorLogicDisabled[]={1,0,1,1};
			colorLogicDisabledBackground[]={1,0,1,0};
			colorDisabled[]={1,0,0.5,1};
			colorDisabledBackground[]=
			{
				"side"
			};
			colorPreview[]={0,0,0,0};
			colorPreviewBackground[]={0,0,0,0};
			colorPreviewDisabled[]={0,0,0,1};
			colorPreviewDisabledBackground[]={1,1,1,0.5};
		};
	};
	class DrawWaypoint
	{
		class 3D
		{
			texture="#(argb,1,1,1)color(1,1,1,0)";
			colorNormal[]={0,0,0,0.5};
			colorSelected[]={1,1,1,0.5};
			colorHover[]={1,1,1,1};
			textureCycle="#(argb,1,1,1)color(1,1,1,0)";
			colorCycleNormal[]={0,0,0,0.5};
			colorCycleSelected[]={1,1,1,0.5};
			colorCycleHover[]={1,1,1,1};
			texturePreview="#(argb,1,1,1)color(1,1,1,0)";
			colorPreview[]={0,0,0,0.5};
		};
		class 2D
		{
			texture="#(argb,1,1,1)color(1,1,1,0)";
			colorNormal[]={0,0,0,0.5};
			colorSelected[]={1,1,1,0.5};
			colorHover[]={1,1,1,1};
			textureCycle="#(argb,1,1,1)color(1,1,1,0)";
			colorCycleNormal[]={0,0,0,0.5};
			colorCycleSelected[]={1,1,1,0.5};
			colorCycleHover[]={1,1,1,1};
			texturePreview="#(argb,1,1,1)color(1,1,1,0)";
			colorPreview[]={0,0,0,0.5};
		};
	};
	class DrawPlayer
	{
		class 3D
		{
			texture="#(argb,1,1,1)color(1,1,1,0)";
			color[]={0.69999999,0.1,0,1};
			textureLaser="#(argb,1,1,1)color(1,1,1,0)";
			colorLaser[]={1,1,1,0.5};
			textureRemote="#(argb,1,1,1)color(1,1,1,0)";
			colorRemote[]={1,1,1,0.5};
		};
		class 2D
		{
			texture="#(argb,1,1,1)color(1,1,1,0)";
			color[]={0.69999999,0.1,0,1};
			textureLaser="#(argb,1,1,1)color(1,1,1,0)";
			colorLaser[]={1,1,1,0.5};
			textureRemote="#(argb,1,1,1)color(1,1,1,0)";
			colorRemote[]={1,1,1,0.5};
		};
	};
};
corpseLimit=15;
corpseRemovalMinTime=10;
corpseRemovalMaxTime=3600;
wreckLimit=15;
wreckRemovalMinTime=10;
wreckRemovalMaxTime=3600;
rptFileLimit=10;
battleyeLicenceUrl="BattlEye\EULA.txt";
autoJoinTimeOut=20;
class ForcedMissionDifficulty
{
	access=2;
	class Mission1
	{
		missionName="A3\Missions_F_Bootcamp\Campaign\missions\BOOT_m01.VR\";
		difficulty="Regular";
	};
	class Mission2
	{
		missionName="A3\Missions_F_Bootcamp\Campaign\missions\BOOT_m02.Altis\";
		difficulty="Regular";
	};
	class Mission3
	{
		missionName="A3\Missions_F_Bootcamp\Campaign\missions\BOOT_m03.Altis\";
		difficulty="Regular";
	};
	class Mission4
	{
		missionName="A3\Missions_F_Bootcamp\Campaign\missions\BOOT_m04.Altis\";
		difficulty="Regular";
	};
	class Mission5
	{
		missionName="A3\Missions_F_Bootcamp\Campaign\missions\BOOT_m05.Altis\";
		difficulty="Regular";
	};
};
class MonetizedServers
{
	access=2;
	url="https://www.bistudio.com/monetization/servers";
	updateInterval="24 * 3600";
	listDirectory="MonetizedServersCache";
	listFileName="list.json";
	tmpListFileName="tmp.json";
};
class OfficialServersArma
{
	access=2;
	url="https://www.bistudio.com/export/servers/official";
	updateInterval="24 * 3600";
	listDirectory="OfficialServersCache";
	listFileName="list.json";
	tmpListFileName="tmp.json";
};
class OfficialServersArgo
{
	access=2;
	url="http://argo-cdn.bistudio.com/servers.json";
	updateInterval="24 * 3600";
	listDirectory="OfficialServersCache";
	listFileName="list.json";
	tmpListFileName="tmp.json";
};
class SteamManagerConfig
{
	fileBankMissionName="__cur_sp";
	creatorAppIds[]={233800};
	class CacheConfig
	{
		steamOffCacheDir="steam\";
		metaDir="meta\";
		subscribedFilename="subscribedContent.list";
		publishedFilename="publishedContent.list";
		persistedItemsFilename="cacheItems.map";
	};
	class Tags
	{
		class TagCommonBase
		{
			missionAddAsDefault=0;
			missionUserCanAddRemove=1;
			missionAddWhenMP=0;
			missionAddWhenMods=0;
			missionAddWhenFireDrill=0;
			missionAddWhenTimeTrial=0;
		};
		class DataType
		{
			class ScenarioTag
			{
				title="Scenario";
				tooltip="";
				missionAddAsDefault=1;
				missionUserCanAddRemove=0;
				missionAddWhenMP=0;
				missionAddWhenMods=0;
				missionAddWhenFireDrill=0;
				missionAddWhenTimeTrial=0;
			};
			class ModTag
			{
				title="Mod";
				tooltip="$STR_sw_tag_mod";
				addonRequiredTag=1;
			};
			class ServerTag: TagCommonBase
			{
				title="Server";
				tooltip="$STR_sw_tag_server";
			};
		};
		class ModType
		{
			class TerrainTag: TagCommonBase
			{
				title="Terrain";
				tooltip="$STR_sw_tag_terrain";
			};
			class SoundTag: TagCommonBase
			{
				title="Sound";
				tooltip="$STR_sw_tag_sound";
			};
			class MechanicsTag: TagCommonBase
			{
				title="Mechanics";
				tooltip="$STR_sw_tag_mechanics";
			};
			class AnimationTag: TagCommonBase
			{
				title="Animation";
				tooltip="$STR_sw_tag_animation";
			};
			class EquipmentTag: TagCommonBase
			{
				title="Equipment";
				tooltip="$STR_sw_tag_equipment";
			};
			class CharacterTag: TagCommonBase
			{
				title="Character";
				tooltip="$STR_sw_tag_character";
			};
			class WeaponTag: TagCommonBase
			{
				title="Weapon";
				tooltip="$STR_sw_tag_weapon";
			};
			class CampaignTag: TagCommonBase
			{
				title="Campaign";
				tooltip="$STR_sw_tag_campaign";
			};
			class StructureTag: TagCommonBase
			{
				title="Structure";
				tooltip="$STR_sw_tag_structure";
			};
			class PlaneTag: TagCommonBase
			{
				title="Plane";
				tooltip="$STR_sw_tag_plane";
			};
			class BoatTag: TagCommonBase
			{
				title="Boat";
				tooltip="$STR_sw_tag_boat";
			};
			class HelicopterTag: TagCommonBase
			{
				title="Helicopter";
				tooltip="$STR_sw_tag_helicopter";
			};
			class TrackedTag: TagCommonBase
			{
				title="Tracked";
				tooltip="$STR_sw_tag_tracked";
			};
			class WheeledTag: TagCommonBase
			{
				title="Wheeled";
				tooltip="$STR_sw_tag_wheeled";
			};
			class EditorExtensionTag: TagCommonBase
			{
				title="Editor Extension";
				tooltip="$STR_sw_tag_editorExtension";
			};
		};
		class ScenarioGameplay
		{
			class SingleplayerTag
			{
				title="Singleplayer";
				tooltip="$STR_sw_tag_singleplayer";
				missionAddAsDefault=0;
				missionUserCanAddRemove=1;
				missionAddWhenMP=0;
				missionAddWhenMods=0;
				missionAddWhenFireDrill=0;
				missionAddWhenTimeTrial=0;
			};
			class MultiplayerTag
			{
				title="Multiplayer";
				tooltip="$STR_sw_tag_multiplayer";
				missionAddAsDefault=0;
				missionUserCanAddRemove=1;
				missionAddWhenMP=1;
				missionAddWhenMods=0;
				missionAddWhenFireDrill=0;
				missionAddWhenTimeTrial=0;
			};
			class CoopTag: TagCommonBase
			{
				title="Coop";
				tooltip="$STR_sw_tag_coop";
			};
			class PersistentTag: TagCommonBase
			{
				title="Persistent";
				tooltip="$STR_sw_tag_persistent";
			};
			class PvPTag: TagCommonBase
			{
				title="PvP";
				tooltip="$STR_sw_tag_pvp";
			};
			class FiringDrillTag: TagCommonBase
			{
				title="FiringDrill";
				tooltip="$STR_sw_tag_firedrill";
			};
			class TimeTrialTag: TagCommonBase
			{
				title="TimeTrial";
				tooltip="$STR_sw_tag_timetrial";
			};
			class Zeus
			{
				title="Zeus";
				tooltip="$STR_SW_TAG_ZEUS";
				missionAddAsDefault=0;
				missionUserCanAddRemove=1;
				missionAddWhenMP=0;
				missionAddWhenMods=0;
				missionAddWhenFireDrill=0;
				missionAddWhenTimeTrial=0;
			};
		};
		class ScenarioType
		{
			class InfantryTag: TagCommonBase
			{
				title="Infantry";
				tooltip="$STR_sw_tag_Infantry";
			};
			class VehiclesTag: TagCommonBase
			{
				title="Vehicles";
				tooltip="$STR_sw_tag_Vehicles";
			};
			class AirTag: TagCommonBase
			{
				title="Air";
				tooltip="$STR_sw_tag_Air";
			};
			class WaterTag: TagCommonBase
			{
				title="Water";
				tooltip="$STR_sw_tag_Water";
			};
		};
		class ScenarioMap
		{
			class StratisTag
			{
				title="Stratis";
				tooltip="$STR_sw_tag_stratis";
				mapName="Stratis";
				missionAddAsDefault=0;
				missionUserCanAddRemove=0;
				missionAddWhenMP=0;
				missionAddWhenMods=0;
				missionAddWhenFireDrill=0;
				missionAddWhenTimeTrial=0;
			};
			class AltisTag
			{
				title="Altis";
				tooltip="$STR_sw_tag_altis";
				mapName="Altis";
				missionAddAsDefault=0;
				missionUserCanAddRemove=0;
				missionAddWhenMP=0;
				missionAddWhenMods=0;
				missionAddWhenFireDrill=0;
				missionAddWhenTimeTrial=0;
			};
			class TanoaTag: TagCommonBase
			{
				title="Tanoa";
				tooltip="$STR_A3_CFGWORLDS_TANOA0";
				mapName="Tanoa";
				missionAddAsDefault=0;
				missionUserCanAddRemove=0;
				missionAddWhenMP=0;
				missionAddWhenMods=0;
				missionAddWhenFireDrill=0;
				missionAddWhenTimeTrial=0;
			};
			class VrTag
			{
				title="VR";
				tooltip="$STR_sw_tag_virtualreality";
				mapName="VR";
				missionAddAsDefault=0;
				missionUserCanAddRemove=0;
				missionAddWhenMP=0;
				missionAddWhenMods=0;
				missionAddWhenFireDrill=0;
				missionAddWhenTimeTrial=0;
			};
			class OtherMap
			{
				title="OtherMap";
				tooltip="$STR_sw_tag_othermap";
				missionFromOtherMap=1;
			};
		};
		class DLC
		{
			class KartsDLCTag: TagCommonBase
			{
				title="KartsDLC";
				tooltip="$STR_sw_tag_dlc_karts";
			};
			class MarksmenDLCTag: TagCommonBase
			{
				title="MarksmenDLC";
				tooltip="$STR_sw_tag_dlc_marksmen";
			};
			class HelicoptersDLCTag: TagCommonBase
			{
				title="HelicoptersDLC";
				tooltip="$STR_sw_tag_dlc_helicopters";
			};
			class ApexTag: TagCommonBase
			{
				title="Apex";
				tooltip="$STR_A3_RSCDISPLAYDEBRIEFING_DLCBUTTONAPEX";
			};
		};
		class Meta
		{
			class DependencyTag
			{
				title="Dependency";
				tooltip="$STR_sw_tag_Dependency";
				missionAddAsDefault=0;
				missionUserCanAddRemove=1;
				missionAddWhenMP=0;
				missionAddWhenMods=1;
				missionAddWhenFireDrill=0;
				missionAddWhenTimeTrial=0;
			};
			class CollectionTag: TagCommonBase
			{
				title="Collection";
				tooltip="$STR_sw_tag_collection";
			};
		};
	};
};
class CfgSteamSettings
{
	access=3;
	class Stats
	{
		class Curator
		{
			curatorPlayerPlayTime[]=
			{
				"ZeusPlayerPlayTime"
			};
			curatorUnitControlPlayTime[]=
			{
				"ZeusUnitControlPlayTime"
			};
			curatorNormalPlayerPlayTime[]=
			{
				"ZeusNormalPlayerGamePlayTime"
			};
		};
		class Worlds
		{
			class Altis
			{
				worldName="altis";
				playtimeStats[]=
				{
					"AltisPlayTime"
				};
			};
			class Stratis
			{
				worldName="stratis";
				playtimeStats[]=
				{
					"StratisPlayTime"
				};
			};
		};
		class Campaigns
		{
			class CampaignEPA
			{
				campaignName="A3\Missions_F_EPA\Campaign\";
				playtimeStats[]=
				{
					"CampaignEPAPlayTime",
					"CampaignPlayTime"
				};
				class Rules
				{
					class Finished
					{
						requiredMissions[]=
						{
							"A_in",
							"A_in2",
							"A_hub01",
							"A_hub02",
							"A_m01",
							"A_m02",
							"A_m03",
							"A_m04",
							"A_m05",
							"A_out"
						};
						statFlagName="CompletedEPA";
					};
				};
			};
			class CampaignEPB
			{
				campaignName="A3\Missions_F_EPB\Campaign\";
				playtimeStats[]=
				{
					"CampaignEPBPlayTime",
					"CampaignPlayTime"
				};
				class Rules
				{
					class Finished
					{
						campaignName="A3\Missions_F_EPB\Campaign";
						requiredMissions[]=
						{
							"B_in",
							"B_in2",
							"B_hub01",
							"B_hub02",
							"B_hub03",
							"B_m01",
							"B_m02_1",
							"B_m02_2",
							"B_m03",
							"B_m05",
							"B_m06",
							"B_out2"
						};
						statFlagName="CompletedEPB";
					};
				};
			};
			class CampaignEPC
			{
				campaignName="A3\Missions_F_EPC\Campaign\";
				playtimeStats[]=
				{
					"CampaignEPCPlayTime",
					"CampaignPlayTime"
				};
				class Rules
				{
					class MainMissions
					{
						requiredMissions[]=
						{
							"C_in1",
							"C_in2",
							"C_m01",
							"C_m02",
							"C_out1",
							"C_out2"
						};
						statFlagName="CompletedEPC";
					};
					class EndA
					{
						requiredMissions[]=
						{
							"C_in1",
							"C_in2",
							"C_m01",
							"C_m02",
							"C_out1",
							"C_out2",
							"C_EA"
						};
						statFlagName="CompletedEPC_A";
					};
					class EndB
					{
						requiredMissions[]=
						{
							"C_in1",
							"C_in2",
							"C_m01",
							"C_m02",
							"C_out1",
							"C_out2",
							"C_EB"
						};
						statFlagName="CompletedEPC_B";
					};
				};
			};
		};
		class Missions
		{
			class Drill1
			{
				missionName="A3\missions_f_beta\Challenges\Firing_Drills\SP_FD01.Stratis\";
				playtimeStats[]=
				{
					"FiringDrillsPlayTime"
				};
			};
			class Drill2
			{
				missionName="A3\missions_f_beta\Challenges\Firing_Drills\SP_FD02.Stratis\";
				playtimeStats[]=
				{
					"FiringDrillsPlayTime"
				};
			};
			class Drill3
			{
				missionName="A3\missions_f_beta\Challenges\Firing_Drills\SP_FD03.Stratis\";
				playtimeStats[]=
				{
					"FiringDrillsPlayTime"
				};
			};
			class Drill4
			{
				missionName="A3\missions_f_beta\Challenges\Firing_Drills\SP_FD04.Stratis\";
				playtimeStats[]=
				{
					"FiringDrillsPlayTime"
				};
			};
			class Drill5
			{
				missionName="A3\Missions_F_Gamma\Challenges\Firing_Drills\SP_FD05.Altis\";
				playtimeStats[]=
				{
					"FiringDrillsPlayTime"
				};
			};
			class Drill6
			{
				missionName="A3\Missions_F_Gamma\Challenges\Firing_Drills\SP_FD06.Altis\";
				playtimeStats[]=
				{
					"FiringDrillsPlayTime"
				};
			};
			class Drill7
			{
				missionName="A3\Missions_F_Gamma\Challenges\Firing_Drills\SP_FD07.Altis\";
				playtimeStats[]=
				{
					"FiringDrillsPlayTime"
				};
			};
			class Drill8
			{
				missionName="A3\Missions_F_Gamma\Challenges\Firing_Drills\SP_FD08.Altis\";
				playtimeStats[]=
				{
					"FiringDrillsPlayTime"
				};
			};
			class Drill9
			{
				missionName="A3\Missions_F_Gamma\Challenges\Firing_Drills\SP_FD09.Altis\";
				playtimeStats[]=
				{
					"FiringDrillsPlayTime"
				};
			};
			class Drill10
			{
				missionName="A3\Missions_F_Gamma\Challenges\Firing_Drills\SP_FD10.Altis\";
				playtimeStats[]=
				{
					"FiringDrillsPlayTime"
				};
			};
			class Showcase1
			{
				missionName="A3\Missions_F\showcases\Showcase_Helicopters.Stratis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase2
			{
				missionName="A3\Missions_F\showcases\Showcase_Infantry.Stratis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase3
			{
				missionName="A3\Missions_F\showcases\Showcase_SCUBA.Stratis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase4
			{
				missionName="A3\Missions_F\showcases\Showcase_Vehicles.Stratis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase5
			{
				missionName="A3\missions_f_beta\Showcases\Showcase_Combined_Arms.Stratis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase6
			{
				missionName="A3\missions_f_beta\Showcases\Showcase_Commanding_I.Stratis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase7
			{
				missionName="A3\missions_f_beta\Showcases\Showcase_Night.Stratis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase8
			{
				missionName="A3\missions_f_beta\Showcases\Showcase_Supports.Stratis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase9
			{
				missionName="A3\Missions_F_Curator\Showcases\Showcase_Curator.Altis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase10
			{
				missionName="A3\Missions_F_EPC\showcases\Showcase_FixedWings.Altis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase11
			{
				missionName="A3\Missions_F_Gamma\Showcases\Faction_BLUFOR.Altis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase12
			{
				missionName="A3\Missions_F_Gamma\Showcases\Faction_INDEPENDENT.Altis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase13
			{
				missionName="A3\Missions_F_Gamma\Showcases\Faction_OPFOR.Altis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase14
			{
				missionName="A3\Missions_F_Gamma\Showcases\Faction_shared\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase15
			{
				missionName="A3\Missions_F_Gamma\Showcases\Showcase_Arma.Altis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase16
			{
				missionName="A3\Missions_F_Gamma\Showcases\Showcase_Drones.Altis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase17
			{
				missionName="A3\Missions_F_Gamma\Showcases\Showcase_Gunships.Altis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
			class Showcase18
			{
				missionName="A3\Missions_F_Gamma\Showcases\Showcase_Tanks.Altis\";
				playtimeStats[]=
				{
					"ShowcasesPlayTime"
				};
			};
		};
	};
	class Tags
	{
		class ScenarioTag
		{
			title="Scenario";
			tooltip="";
			missionAddAsDefault=1;
			missionUserCanAddRemove=0;
			missionAddWhenMP=0;
			missionAddWhenMods=0;
			missionAddWhenFireDrill=0;
			missionAddWhenTimeTrial=0;
		};
		class DependencyTag
		{
			title="Dependency";
			tooltip="$STR_sw_tag_Dependency";
			missionAddAsDefault=0;
			missionUserCanAddRemove=1;
			missionAddWhenMP=0;
			missionAddWhenMods=1;
			missionAddWhenFireDrill=0;
			missionAddWhenTimeTrial=0;
		};
		class SingleplayerTag
		{
			title="Singleplayer";
			tooltip="$STR_sw_tag_singleplayer";
			missionAddAsDefault=0;
			missionUserCanAddRemove=1;
			missionAddWhenMP=0;
			missionAddWhenMods=0;
			missionAddWhenFireDrill=0;
			missionAddWhenTimeTrial=0;
		};
		class MultiplayerTag
		{
			title="Multiplayer";
			tooltip="$STR_sw_tag_multiplayer";
			missionAddAsDefault=0;
			missionUserCanAddRemove=1;
			missionAddWhenMP=1;
			missionAddWhenMods=0;
			missionAddWhenFireDrill=0;
			missionAddWhenTimeTrial=0;
		};
		class TagCommonBase
		{
			title="Infantry";
			tooltip="$STR_sw_tag_Infantry";
			missionAddAsDefault=0;
			missionUserCanAddRemove=1;
			missionAddWhenMP=0;
			missionAddWhenMods=0;
			missionAddWhenFireDrill=0;
			missionAddWhenTimeTrial=0;
		};
		class VehiclesTag: TagCommonBase
		{
			title="Vehicles";
			tooltip="$STR_sw_tag_Vehicles";
		};
		class AirTag: TagCommonBase
		{
			title="Air";
			tooltip="$STR_sw_tag_Air";
		};
		class WaterTag: TagCommonBase
		{
			title="Water";
			tooltip="$STR_sw_tag_Water";
		};
		class StratisTag
		{
			title="Stratis";
			missionAddAsDefault=0;
			missionUserCanAddRemove=0;
			missionAddWhenMP=0;
			missionAddWhenMods=0;
			missionAddWhenFireDrill=0;
			missionAddWhenTimeTrial=0;
		};
		class AltisTag
		{
			title="Altis";
			tooltip="$STR_sw_tag_Altis";
			missionAddAsDefault=0;
			missionUserCanAddRemove=0;
			missionAddWhenMP=0;
			missionAddWhenMods=0;
			missionAddWhenFireDrill=0;
			missionAddWhenTimeTrial=0;
		};
	};
	workshopAgreement="http://steamcommunity.com/sharedfiles/workshoplegalagreement";
	steamTmpPreviewDirectory="SteamPreviewCache";
	maxPreviewDirCacheSize=25;
	steamPreviewFileExtension="jpg";
	steamPreviewDefaultImage="\core\All\SteamWorksDefaultImage_co.jpg";
	publishDialogAdditionalSpaceColor[]={1,0,0,1};
	publishDialogFreedSpaceColor[]={0,1,0,1};
};
class CfgBrains
{
	class DefaultSoldierBrain
	{
		class Components
		{
			class AIBrainAimingErrorComponent
			{
			};
			class AIBrainCountermeasuresComponent
			{
			};
			class AIBrainSuppressionComponent
			{
			};
			class AIBrainTargetSelectorComponent
			{
			};
		};
	};
	class DefaultCivilianBrain
	{
		class Components
		{
		};
	};
	class DefaultAnimalBrain
	{
		class Components
		{
		};
	};
};
class CfgTextureToMaterial
{
	class CarGlass
	{
		textures[]={};
		material="#SpecularGlass";
	};
	class AirborneGlass
	{
		textures[]={};
		material="#SpecularGlass";
	};
	class Metal
	{
		textures[]={};
		material="#Metal";
	};
	class AirBorneMetal
	{
		textures[]={};
		material="#Metal";
	};
	class RifleMetal
	{
		textures[]={};
		material="#RifleMetal";
	};
};
class CfgMaterials
{
	class Water
	{
		PixelShaderID="Water";
		VertexShaderID="Water";
		ambient[]={0.016000001,0.0264,0.039999999,0.40000001};
		diffuse[]={0.032000002,0.12800001,0.12800001,1};
		forcedDiffuse[]={0,0,0,0};
		specular[]={1,1,1,0};
		specularPower=4;
		emmisive[]={0,0,0,0};
		class Stage1
		{
			texture="#(rgb,8,8,3)color(0.5,0.5,1.0,1)";
			uvSource="texWaterAnim";
			class uvTransform
			{
				aside[]={0,4,0};
				up[]={4,0,0};
				dir[]={0,0,4};
				pos[]={0.2,0.5,0};
			};
		};
		class Stage3
		{
			texture="#(ai,16,64,1)waterirradiance(16)";
			uvSource="none";
		};
		class Stage4
		{
			texture="#(argb,8,8,3)color(0.5,0.5,0.5,1)";
			uvSource="none";
		};
		class Stage5
		{
			texture="#(argb,8,8,3)color(0.5,0.5,0.5,1)";
			uvSource="none";
		};
	};
	class Shore
	{
		PixelShaderID="Shore";
		VertexShaderID="Shore";
		ambient[]={0.016000001,0.0264,0.039999999,0.40000001};
		diffuse[]={0.032000002,0.12800001,0.12800001,1};
		forcedDiffuse[]={0,0,0,0};
		specular[]={1,1,1,0};
		specularPower=4;
		emmisive[]={0,0,0,0};
		class Stage1
		{
			texture="#(rgb,8,8,3)color(0.5,0.5,1.0,1)";
			uvSource="texWaterAnim";
			class uvTransform
			{
				aside[]={0,4,0};
				up[]={4,0,0};
				dir[]={0,0,4};
				pos[]={0.2,0.5,0};
			};
		};
		class Stage3
		{
			texture="#(ai,16,64,1)waterirradiance(16)";
			uvSource="none";
		};
		class Stage4
		{
			texture="#(argb,8,8,3)color(0.5,0.5,0.5,1)";
			uvSource="none";
		};
		class Stage5
		{
			texture="#(argb,8,8,3)color(0.5,0.5,0.5,1)";
			uvSource="none";
		};
	};
	class ShoreFoam
	{
		PixelShaderID="ShoreFoam";
		VertexShaderID="Shore";
		ambient[]={0.016000001,0.0264,0.039999999,0.40000001};
		diffuse[]={0.032000002,0.12800001,0.12800001,1};
		forcedDiffuse[]={0,0,0,0};
		specular[]={1,1,1,0};
		specularPower=4;
		emmisive[]={0,0,0,0};
		class Stage1
		{
			texture="#(rgb,8,8,3)color(0.5,0.5,1.0,1)";
			uvSource="texWaterAnim";
			class uvTransform
			{
				aside[]={0,4,0};
				up[]={4,0,0};
				dir[]={0,0,4};
				pos[]={0.2,0.5,0};
			};
		};
		class Stage3
		{
			texture="#(ai,16,64,1)waterirradiance(16)";
			uvSource="none";
		};
		class Stage4
		{
			texture="#(argb,8,8,3)color(0.5,0.5,0.5,1)";
			uvSource="none";
		};
		class Stage5
		{
			texture="#(argb,8,8,3)color(0.5,0.5,0.5,1)";
			uvSource="none";
		};
	};
	class ShoreWet
	{
		PixelShaderID="ShoreWet";
		VertexShaderID="Shore";
	};
	class Terrain
	{
		ambient[]={1,1,1,1};
		diffuse[]={0.60000002,0.60000002,0.60000002,1};
		forcedDiffuse[]={0.050000001,0.050000001,0.050000001,1};
		specular[]={0,0,0,0};
		specularPower=1;
		emmisive[]={0,0,0,0};
		PixelShaderID="NormalMapDiffuse";
		VertexShaderID="NormalMapDiffuseAlpha";
		class Stage1
		{
			texture="#(argb,8,8,3)color(0,0,1,1)";
			uvSource="tex";
			class uvTransform
			{
				aside[]={1,0,0};
				up[]={0,1,0};
				dir[]={0,0,1};
				pos[]={0,0,0};
			};
		};
		class Stage2
		{
			texture="#(argb,8,8,3)color(0.5,0.5,0.5,1)";
			uvSource="tex";
			class uvTransform
			{
				aside[]={1,0,0};
				up[]={0,1,0};
				dir[]={0,0,1};
				pos[]={0,0,0};
			};
		};
	};
	class SpecularGlass
	{
		ambient[]={1,1,1,1};
		diffuse[]={1,1,1,1};
		forcedDiffuse[]={0,0,0,0};
		specular[]={0.5,0.5,0.80000001,0};
		specularPower=5;
		emmisive[]={0,0,0,0};
	};
	class Metal
	{
		ambient[]={1,1,1,1};
		diffuse[]={1,1,1,1};
		forcedDiffuse[]={0,0,0,0};
		specular[]={0.2,0.2,0.2,0};
		specularPower=5;
		emmisive[]={0,0,0,0};
	};
	class RifleMetal
	{
		ambient[]={1,1,1,1};
		diffuse[]={1,1,1,1};
		forcedDiffuse[]={0,0,0,0};
		specular[]={0.2,0.2,0.2,0};
		specularPower=5;
		emmisive[]={0,0,0,0};
	};
};
class CfgTLMaterials
{
	class ShiningAdjustable
	{
		ambient[]={10,10,10,1};
		diffuse[]={10,10,10,1};
		emissive[]={20,20,20,1};
	};
};
class CfgVehicleActions
{
};
class CfgWeaponCursors
{
	class RifleCursorCore
	{
		texture="";
		fade=0.19;
		fadeRatioDamage=0.5;
		fadeRatioFatigue=0.5;
		class Sections
		{
			class Section1
			{
				uMin=0;
				vMin=0;
				uMax=0.328125;
				vMax=1;
				xOffset=-20;
				yOffset=0;
			};
			class Section2
			{
				uMin=0.65625;
				vMin=0;
				uMax=1;
				vMax=1;
				xOffset=20;
				yOffset=0;
			};
		};
	};
	class MGCursorCore
	{
		texture="";
		fade=0.19;
		fadeRatioDamage=0.5;
		fadeRatioFatigue=0.5;
		class Sections
		{
			class Section1
			{
				uMin=0;
				uMax=0.328125;
				vMin=0.328125;
				vMax=0.65625;
				xOffset=-25;
				yOffset=0;
			};
			class Section2
			{
				uMin=0.65625;
				uMax=1;
				vMin=0.328125;
				vMax=0.65625;
				xOffset=25;
				yOffset=0;
			};
			class Section3
			{
				uMin=0.328125;
				uMax=0.65625;
				vMin=0.65625;
				vMax=1;
				xOffset=0;
				yOffset=25;
			};
		};
	};
	class LawCursorCore
	{
		texture="";
		fade=0.19;
		fadeRatioDamage=0.5;
		fadeRatioFatigue=0.5;
		class Sections
		{
			class Section1
			{
				uMin=0;
				uMax=0.328125;
				vMin=0.328125;
				vMax=0.65625;
				xOffset=-30;
				yOffset=0;
			};
			class Section2
			{
				uMin=0.65625;
				uMax=1;
				vMin=0.328125;
				vMax=0.65625;
				xOffset=30;
				yOffset=0;
			};
			class Section3
			{
				uMin=0.328125;
				uMax=0.65625;
				vMin=0;
				vMax=0.328125;
				xOffset=0;
				yOffset=-30;
			};
			class Section4
			{
				uMin=0.328125;
				uMax=0.65625;
				vMin=0.65625;
				vMax=1;
				xOffset=0;
				yOffset=30;
			};
		};
	};
};
class CfgMineTriggers
{
	access=1;
	class Default
	{
		scope=0;
		mineTriggerType="radius";
		mineTriggerRange=2;
		mineTriggerMass=30;
		mineDelay=0.2;
		mineMagnetic=0;
		mineUnderwaterOnly=0;
		mineWireStart[]={0,1,0};
		mineWireEnd[]={0,1,5};
		restrictZoneCenter[]={0,0,0};
		restrictZoneRadius=3;
		timerStep=-1;
	};
	class RangeTrigger: Default
	{
		mineTriggerType="radius";
		mineTriggerRange=2;
		mineTriggerMass=30;
		mineMagnetic=0;
	};
	class TimeTrigger: Default
	{
		mineTriggerType="timer";
		timerStep=30;
	};
	class RemoteTrigger: Default
	{
		mineTriggerType="remote";
		restrictZoneRadius=3;
		mineTriggerMass=0;
		timerStep=40;
	};
	class WireTrigger: Default
	{
		mineTriggerType="wire";
		restrictZoneCenter[]={0.1,0,0};
		restrictZoneRadius=3;
		mineWireStart[]={-1.4,0.1,0};
		mineWireEnd[]={1.6,0.1,0};
		mineTriggerMass=14;
	};
};
class CfgAmmo
{
	access=1;
	class Default
	{
		access=3;
		hit=0;
		indirectHit=0;
		indirectHitRange=1;
		underwaterHitRangeCoef=1;
		typicalSpeed=900;
		explosionForceCoef=1;
		isCraterOriented=0;
		model="";
		proxyShape="";
		craterShape="";
		simulation="";
		weaponType="Default";
		animated=0;
		shadow=0;
		cost=0;
		maxSpeed=0;
		cartridge="";
		simulationStep=0.050000001;
		tracerColor[]={0.69999999,0.69999999,0.5,0.039999999};
		tracerColorR[]={0.69999999,0.69999999,0.5,0.039999999};
		soundFly[]=
		{
			"",
			1,
			1
		};
		soundEngine[]=
		{
			"",
			1,
			1
		};
		soundHit[]=
		{
			"",
			1,
			1
		};
		supersonicCrackNear[]=
		{
			"",
			1,
			1
		};
		supersonicCrackFar[]=
		{
			"",
			1,
			1
		};
		soundFall[]=
		{
			"",
			1,
			1
		};
		soundFakeFall[]=
		{
			"soundFall",
			1
		};
		hitGroundSoft[]=
		{
			"soundHit",
			1
		};
		hitGroundHard[]=
		{
			"soundHit",
			1
		};
		hitMan[]=
		{
			"soundHit",
			1
		};
		hitArmor[]=
		{
			"soundHit",
			1
		};
		hitIron[]=
		{
			"soundHit",
			1
		};
		hitBuilding[]=
		{
			"soundHit",
			1
		};
		hitFoliage[]=
		{
			"soundHit",
			1
		};
		hitWood[]=
		{
			"soundHit",
			1
		};
		hitGlass[]=
		{
			"soundHit",
			1
		};
		hitGlassArmored[]=
		{
			"soundHit",
			1
		};
		hitConcrete[]=
		{
			"soundHit",
			1
		};
		hitRubber[]=
		{
			"soundHit",
			1
		};
		hitPlastic[]=
		{
			"soundHit",
			1
		};
		hitDefault[]=
		{
			"soundHit",
			1
		};
		hitMetal[]=
		{
			"soundHit",
			1
		};
		hitMetalplate[]=
		{
			"soundHit",
			1
		};
		hitTyre[]=
		{
			"soundHit",
			1
		};
		hitWater[]=
		{
			"soundHit",
			1
		};
		soundImpact[]=
		{
			"",
			1,
			1
		};
		impactGroundSoft[]=
		{
			"soundImpact",
			1
		};
		impactGroundHard[]=
		{
			"soundImpact",
			1
		};
		impactMan[]=
		{
			"soundImpact",
			1
		};
		impactIron[]=
		{
			"soundImpact",
			1
		};
		impactArmor[]=
		{
			"soundImpact",
			1
		};
		impactBuilding[]=
		{
			"soundImpact",
			1
		};
		impactFoliage[]=
		{
			"soundImpact",
			1
		};
		impactWood[]=
		{
			"soundImpact",
			1
		};
		impactGlass[]=
		{
			"soundImpact",
			1
		};
		impactGlassArmored[]=
		{
			"soundImpact",
			1
		};
		impactConcrete[]=
		{
			"soundImpact",
			1
		};
		impactRubber[]=
		{
			"soundImpact",
			1
		};
		impactPlastic[]=
		{
			"soundImpact",
			1
		};
		impactDefault[]=
		{
			"soundImpact",
			1
		};
		impactMetal[]=
		{
			"soundImpact",
			1
		};
		impactMetalplate[]=
		{
			"soundImpact",
			1
		};
		impactTyre[]=
		{
			"soundImpact",
			1
		};
		impactWater[]=
		{
			"soundImpact",
			1
		};
		grenadeFireSound[]={};
		grenadeBurningSound[]={};
		deflecting=0;
		deflectionSlowDown=0.80000001;
		explosive=1;
		explosionEffects="ExplosionEffects";
		craterEffects="ImpactEffectsMedium";
		craterWaterEffects="ImpactEffectsWater";
		effectsMissile="ExplosionEffects";
		effectsMissileInit="";
		effectsSmoke="SmokeShellWhite";
		effectsFire="CannonFire";
		effectFlare="FlareShell";
		effectFly="";
		mineJumpEffects="";
		waterEffectOffset=0.44999999;
		directionalExplosion=0;
		explosionAngle=60;
		explosionDir="explosionDir";
		explosionPos="explosionPos";
		explosionEffectsDir="explosionDir";
		minimumSafeZone=0.1;
		soundTrigger[]={};
		soundActivation[]={};
		soundDeactivation[]={};
		explosionSoundEffect="";
		timeToLive=10;
		minTimeToLive=0;
		irLock=0;
		airLock=0;
		laserLock=0;
		nvLock=0;
		artilleryLock=0;
		hitOnWater=0;
		lockSeekRadius=100;
		manualControl=0;
		maxControlRange=350;
		maneuvrability=1;
		trackLead=1;
		trackOversteer=1;
		missileLockCone=0;
		weaponLockSystem=0;
		cmImmunity=1;
		lockType=0;
		maverickweaponIndexOffset=0;
		sideAirFriction=1;
		artilleryDispersion=1;
		artilleryCharge=1;
		autoSeekTarget=0;
		visibleFire=0;
		audibleFire=0;
		shootDistraction=-1;
		visibleFireTime=0;
		explosionTime=0;
		fuseDistance=0;
		initTime=0;
		thrustTime=1.5;
		thrust=210;
		airFriction=-0.00050000002;
		icon="";
		submunitionAmmo="";
		explosionType="explosive";
		mineTrigger="RangeTrigger";
		mineBoundingTime=3;
		mineBoundingDist=3;
		mineInconspicuousness=10;
		mineFloating=-1;
		mineDiveSpeed=1;
		minePlaceDist=0.5;
		class HitEffects
		{
			vehicle="ImpactMetal";
			object="ImpactConcrete";
		};
		suppressionRadiusBulletClose=-1;
		suppressionRadiusHit=-1;
		dangerRadiusBulletClose=-1;
		dangerRadiusHit=-1;
		caliber=1;
		whistleDist=0;
		whistleOnFire=0;
		class NVGMarkers
		{
		};
	};
	class MissileCore: Default
	{
		simulation="shotMissile";
		simulationStep=0.050000001;
		timeToLive=20;
		manualControl=1;
		maxControlRange=250;
		initTime=0.15000001;
		thrustTime=2.5;
		thrust=350;
		maneuvrability=3;
		missileLockCone=50;
		visibleFire=32;
		audibleFire=32;
		visibleFireTime=20;
		soundHit[]=
		{
			"",
			100.00001,
			1
		};
		soundFly[]=
		{
			"",
			0.0099999998,
			2
		};
		soundEngine[]=
		{
			"",
			0.00099999993,
			1
		};
		cost=10000;
		deflecting=5;
	};
	class BombCore: Default
	{
		hit=50;
		indirectHit=40;
		indirectHitRange=10;
		cost=200;
		irLock=0;
		laserLock=0;
		maxControlRange=0;
		maneuvrability=16;
		sideAirFriction=0.1;
		simulation="shotMissile";
		maxSpeed=100;
		timeToLive=120;
		initTime=0;
		thrustTime=0;
		thrust=0;
	};
	class LaserBombCore: BombCore
	{
		hit=5000;
		indirectHit=3500;
		indirectHitRange=15;
		cost=20000;
		irLock=0;
		laserLock=1;
		maxControlRange=100000;
		maneuvrability=16;
		sideAirFriction=0.1;
		simulation="shotMissile";
		maxSpeed=100;
		timeToLive=120;
		initTime=0;
		thrustTime=0;
		thrust=0;
		missileLockCone=50;
	};
	class RocketCore: Default
	{
		simulation="shotRocket";
		simulationStep=0.050000001;
		timeToLive=20;
		maneuvrability=0;
		maxControlRange=0;
		initTime=0.050000001;
		thrustTime=1;
		thrust=1500;
		visibleFire=32;
		audibleFire=32;
		visibleFireTime=20;
		cost=2000;
		deflecting=5;
	};
	class ArtilleryRocketCore: RocketCore
	{
		artilleryLock=1;
	};
	class BulletCore: Default
	{
		simulation="shotBullet";
		simulationStep=0.050000001;
		timeToLive=3;
		soundFly[]=
		{
			"",
			0.25118864,
			0.69999999
		};
		explosive=0;
		visibleFire=16;
		audibleFire=16;
		visibleFireTime=3;
		soundHit1[]=
		{
			"",
			0.031622775,
			1
		};
		soundHit2[]=
		{
			"",
			0.031622775,
			1
		};
		soundHit3[]=
		{
			"",
			0.031622775,
			1
		};
		soundHitMan1[]=
		{
			"",
			0.012589253,
			1
		};
		soundHitMan2[]=
		{
			"",
			0.012589253,
			1
		};
		soundHitArmor1[]=
		{
			"",
			0.031622775,
			1
		};
		soundHitArmor2[]=
		{
			"",
			0.031622775,
			1
		};
		soundHitBuilding1[]=
		{
			"",
			0.031622775,
			1
		};
		soundHitBuilding2[]=
		{
			"",
			0.031622775,
			1
		};
		hitGround[]=
		{
			"soundHit1",
			0.33000001,
			"soundHit2",
			0.33000001,
			"soundHit3",
			0.33000001
		};
		hitMan[]=
		{
			"soundHitMan1",
			0.5,
			"soundHitMan2",
			0.5
		};
		hitArmor[]=
		{
			"soundHitArmor1",
			0.69999999,
			"soundHitArmor2",
			0.30000001
		};
		hitBuilding[]=
		{
			"soundHitBuilding1",
			0.5,
			"soundHitBuilding2",
			0.5
		};
		cost=0.69999999;
	};
	class ShotgunCore: Default
	{
		simulation="shotSpread";
		simulationStep=0.050000001;
		timeToLive=3;
		soundFly[]=
		{
			"",
			0.25118864,
			0.69999999
		};
		explosive=0;
		visibleFire=16;
		audibleFire=16;
		visibleFireTime=3;
		soundHit1[]=
		{
			"",
			0.031622775,
			1
		};
		soundHit2[]=
		{
			"",
			0.031622775,
			1
		};
		soundHit3[]=
		{
			"",
			0.031622775,
			1
		};
		soundHitMan1[]=
		{
			"",
			0.012589253,
			1
		};
		soundHitMan2[]=
		{
			"",
			0.012589253,
			1
		};
		soundHitArmor1[]=
		{
			"",
			0.031622775,
			1
		};
		soundHitArmor2[]=
		{
			"",
			0.031622775,
			1
		};
		soundHitBuilding1[]=
		{
			"",
			0.031622775,
			1
		};
		soundHitBuilding2[]=
		{
			"",
			0.031622775,
			1
		};
		hitGround[]=
		{
			"soundHit1",
			0.33000001,
			"soundHit2",
			0.33000001,
			"soundHit3",
			0.33000001
		};
		hitMan[]=
		{
			"soundHitMan1",
			0.5,
			"soundHitMan2",
			0.5
		};
		hitArmor[]=
		{
			"soundHitArmor1",
			0.69999999,
			"soundHitArmor2",
			0.30000001
		};
		hitBuilding[]=
		{
			"soundHitBuilding1",
			0.5,
			"soundHitBuilding2",
			0.5
		};
		cost=0.69999999;
	};
	class ShellCore: Default
	{
		simulation="shotShell";
		simulationStep=0.050000001;
		timeToLive=20;
		cost=1000;
		soundHit[]=
		{
			"",
			316.22778,
			1
		};
		soundFly[]=
		{
			"",
			0.031622775,
			4
		};
		indirectHitRange=8;
		visibleFire=16;
		audibleFire=16;
		visibleFireTime=10;
		deflecting=5;
	};
	class SubmunitionCore: Default
	{
		simulation="shotSubmunitions";
		simulationStep=0.050000001;
		timeToLive=180;
		cost=1000;
		soundHit[]=
		{
			"",
			316.22778,
			1
		};
		soundFly[]=
		{
			"",
			0.031622775,
			4
		};
		hitOnWater=1;
		artilleryLock=1;
		indirectHitRange=8;
		visibleFire=16;
		audibleFire=16;
		visibleFireTime=10;
		deflecting=5;
	};
	class ShotDeployCore: Default
	{
		simulation="shotDeploy";
		simulationStep=0.050000001;
		timeToLive=180;
		cost=1000;
		soundHit[]=
		{
			"",
			316.22778,
			1
		};
		soundFly[]=
		{
			"",
			0.031622775,
			4
		};
		hitOnWater=1;
		artilleryLock=1;
		indirectHitRange=8;
		visibleFire=16;
		audibleFire=16;
		visibleFireTime=10;
		deflecting=5;
	};
	class GrenadeCore: Default
	{
		explosive=1;
		hit=20;
		indirectHit=18;
		indirectHitRange=7;
		cost=40;
		simulation="shotShell";
		simulationStep=0.050000001;
		soundHit[]=
		{
			"",
			10,
			1
		};
		soundFly[]=
		{
			"",
			3.1622771e-005,
			1
		};
		soundEngine[]=
		{
			"",
			9.9999983e-005,
			4
		};
		visibleFire=2;
		audibleFire=0.25;
		visibleFireTime=0;
		timeToLive=20;
		deflecting=60;
	};
	class TimeBombCore: Default
	{
		hit=700;
		indirectHit=700;
		indirectHitRange=7;
		model="";
		cost=2000;
		simulation="shotTimeBomb";
		simulationStep=0.1;
		soundHit[]=
		{
			"",
			100.00001,
			1
		};
		soundFly[]=
		{
			"",
			0,
			1
		};
		soundEngine[]=
		{
			"",
			0,
			1
		};
		visibleFire=0;
		audibleFire=0;
		visibleFireTime=0;
		timeToLive=0;
		triggerWhenDestroyed=1;
	};
	class LaserCore: Default
	{
		simulation="shotLaser";
		simulationStep=0.050000001;
		timeToLive=1;
		soundFly[]=
		{
			"",
			0.25118864,
			0.69999999
		};
		explosive=0;
		visibleFire=32;
		audibleFire=32;
		visibleFireTime=1;
		recoil="Empty";
		recoilProne="Empty";
		soundHit1[]=
		{
			"",
			0.031622775,
			1
		};
		soundHit2[]=
		{
			"",
			0.031622775,
			1
		};
		soundHit3[]=
		{
			"",
			0.031622775,
			1
		};
		soundHitMan1[]=
		{
			"",
			0.012589253,
			1
		};
		soundHitMan2[]=
		{
			"",
			0.012589253,
			1
		};
		soundHitArmor1[]=
		{
			"",
			0.031622775,
			1
		};
		soundHitArmor2[]=
		{
			"",
			0.031622775,
			1
		};
		soundHitBuilding1[]=
		{
			"",
			0.031622775,
			1
		};
		soundHitBuilding2[]=
		{
			"",
			0.031622775,
			1
		};
		hitGround[]=
		{
			"soundHit1",
			0.33000001,
			"soundHit2",
			0.33000001,
			"soundHit3",
			0.33000001
		};
		hitMan[]=
		{
			"soundHitMan1",
			0.5,
			"soundHitMan2",
			0.5
		};
		hitArmor[]=
		{
			"soundHitArmor1",
			0.69999999,
			"soundHitArmor2",
			0.30000001
		};
		hitBuilding[]=
		{
			"soundHitBuilding1",
			0.5,
			"soundHitBuilding2",
			0.5
		};
		cost=0.69999999;
	};
	class PipeBombCore: TimeBombCore
	{
		simulation="shotMine";
		mineTrigger="RemoteTrigger";
	};
	class DirectionalBombCore: TimeBombCore
	{
		hit=750;
		indirectHit=750;
		indirectHitRange=10;
		simulation="shotDirectionalBomb";
		directionalExplosion=1;
		explosionAngle=80;
	};
	class BoundingMineCore: TimeBombCore
	{
		hit=750;
		indirectHit=750;
		indirectHitRange=5;
		simulation="shotBoundingMine";
		mineBoundingTime=0.2;
		mineBoundingDist=3;
	};
	class MineCore: TimeBombCore
	{
		hit=750;
		indirectHit=750;
		indirectHitRange=5;
		simulation="shotMine";
		model="";
		defaultMagazine="";
	};
	class FlareCore: GrenadeCore
	{
		timeToLive=30;
		hit=5;
		indirectHit=2;
		indirectHitRange=0.2;
		cost=100;
		simulation="shotIlluminating";
		simulationStep=0.050000001;
		explosive=0;
		soundHit[]=
		{
			"",
			0,
			1
		};
		lightColor[]={1,1,1,0};
		brightness=2;
		size=1;
		deflecting=60;
		thrust=0;
		airFriction=0;
		sideairFriction=0;
		artilleryLock=1;
	};
	class SmokeShellCore: GrenadeCore
	{
		timeToLive=60;
		visibleFire=2;
		audibleFire=0.25;
		visibleFireTime=1;
		hit=5;
		indirectHit=2;
		indirectHitRange=0.2;
		cost=100;
		simulation="shotSmokeX";
		explosive=0;
		soundHit[]=
		{
			"",
			0,
			1
		};
		smokeColor[]={1,1,1,0};
		deflecting=60;
	};
	class FakeAmmo: BulletCore
	{
		hit=13;
		indirectHit=4;
		indirectHitRange=0.2;
		cost=6;
		airlock=1;
		explosive=0;
		visibleFire=16;
		audibleFire=16;
		visibleFireTime=3;
	};
};
class CfgRecoils
{
	access=0;
	empty[]={};
	impulse[]={0.029999999,0.02,0.2,0.079999998,0.079999998,0.80000001,0.1,0.029999999,-0.1,0.30000001,0,0};
	class Default
	{
		muzzleOuter[]={0,0.40000001,0.5,0.60000002};
		kickBack[]={0.050000001,0.1};
		permanent=0.1;
		temporary=0.0099999998;
	};
};
class CfgMagazines
{
	class Default
	{
		scope=0;
		value=2;
		type=0;
		simulation="ProxyMagazines";
		model="";
		picture="";
		ammo="";
		count=1;
		displayName="";
		displayNameShort="";
		nameSound="";
		weight=0;
		maxLeadSpeed=50;
		initSpeed=100;
		reloadAction="";
		useAction=0;
		useActionTitle="";
		modelSpecial="";
		class InventoryPlacements
		{
		};
		class Library
		{
			libTextDesc="";
		};
		descriptionShort="";
		maxThrowHoldTime=2;
		minThrowIntensityCoef=0.30000001;
		maxThrowIntensityCoef=1.4;
		quickReload=0;
	};
	class FakeMagazine: Default
	{
		scope=1;
		ammo="FakeAmmo";
	};
	class FakeWeapon: FakeMagazine
	{
	};
};
class Mode_SemiAuto
{
	multiplier=1;
	burst=1;
	burstRangeMax=-1;
	displayName="";
	textureType="default";
	dispersion=0.00019999999;
	sound[]=
	{
		"",
		10,
		1
	};
	soundBegin[]=
	{
		"sound",
		1
	};
	soundBeginWater[]=
	{
		"sound",
		1
	};
	soundClosure[]=
	{
		"sound",
		1
	};
	soundEnd[]={};
	soundLoop[]={};
	soundContinuous=0;
	weaponSoundEffect="";
	soundBurst=1;
	reloadTime=0.1;
	ffCount=1;
	ffMagnitude=0.5;
	ffFrequency=11;
	flash="gunfire";
	flashSize=0.1;
	recoil="Empty";
	recoilProne="Empty";
	autoFire=0;
	aiRateOfFire=0.5;
	aiRateOfFireDistance=500;
	useAction=0;
	useActionTitle="";
	showToPlayer=1;
	minRange=30;
	minRangeProbab=0.25;
	midRange=300;
	midRangeProbab=0.57999998;
	maxRange=600;
	maxRangeProbab=0.039999999;
	artilleryDispersion=1;
	artilleryCharge=1;
	canShootInWater=0;
};
class Mode_Burst: Mode_SemiAuto
{
	displayName="";
	sound[]=
	{
		"",
		10,
		1
	};
	soundLoop[]=
	{
		"sound",
		1
	};
	soundEnd[]=
	{
		"sound",
		1
	};
	soundBurst=1;
	burst=3;
	dispersion=0.00050000002;
	minRange=10;
	minRangeProbab=0.30000001;
	midRange=60;
	midRangeProbab=0.57999998;
	maxRange=150;
	maxRangeProbab=0.039999999;
};
class Mode_FullAuto: Mode_SemiAuto
{
	displayName="";
	dispersion=0.00050000002;
	sound[]=
	{
		"",
		10,
		1
	};
	soundEnd[]=
	{
		"sound",
		1
	};
	soundContinuous=0;
	reloadTime=0.079999998;
	autoFire=1;
	minRange=1;
	minRangeProbab=0.2;
	midRange=30;
	midRangeProbab=0.57999998;
	maxRange=80;
	maxRangeProbab=0.039999999;
};
class CfgWeapons
{
	access=1;
	class Default
	{
		access=3;
		scope=0;
		value=2;
		picture="";
		uiPicture="";
		ammo="";
		cursor="";
		cursorAim="";
		cursorSize=1;
		showAimCursorInternal=1;
		cursorAimOn="";
		laser=0;
		hiddenSelections[]={};
		hiddenSelectionsTextures[]={};
		hiddenUnderwaterSelections[]={};
		shownUnderwaterSelections[]={};
		hiddenUnderwaterSelectionsTextures[]={};
		simulation="Weapon";
		type=65536;
		displayName="";
		nameSound="";
		count=0;
		multiplier=1;
		burst=1;
		magazineReloadTime=0;
		reloadTime=1;
		magazineReloadSwitchPhase=1;
		sound[]=
		{
			"",
			1,
			1
		};
		soundBegin[]=
		{
			"sound",
			1
		};
		soundBeginWater[]=
		{
			"sound",
			1
		};
		soundClosure[]=
		{
			"sound",
			1
		};
		soundEnd[]=
		{
			"sound",
			1
		};
		soundLoop[]=
		{
			"sound",
			1
		};
		soundContinuous=0;
		weaponSoundEffect="";
		soundBurst=1;
		drySound[]=
		{
			"",
			1,
			1
		};
		zeroingSound[]=
		{
			"",
			1,
			1
		};
		reloadSound[]=
		{
			"",
			1,
			1
		};
		changeFiremodeSound[]=
		{
			"",
			1,
			1
		};
		reloadMagazineSound[]=
		{
			"",
			1,
			1
		};
		emptySound[]=
		{
			"",
			1,
			1
		};
		soundBullet[]=
		{
			"emptySound",
			1
		};
		initSpeed=0;
		ballisticsComputer=0;
		irDistance=0;
		irDotIntensity=0.001;
		dispersion=0.0020000001;
		aiDispersionCoefX=1;
		aiDispersionCoefY=1;
		canLock=2;
		lockAcquire=1;
		enableAttack=1;
		ffMagnitude=0;
		ffFrequency=1;
		ffCount=1;
		recoil="empty";
		recoilProne="";
		maxRecoilSway=0.0080000004;
		swayDecaySpeed=2;
		model="";
		modelSpecial="";
		modelMagazine="";
		muzzlePos="usti hlavne";
		muzzleEnd="konec hlavne";
		irLaserPos="laser pos";
		irLaserEnd="laser dir";
		cartridgePos="nabojnicestart";
		cartridgeVel="nabojniceend";
		selectionFireAnim="zasleh";
		memoryPointCamera="eye";
		fireSpreadAngle=3;
		useModelOptics=1;
		opticsID=0;
		modelOptics="";
		opticsPPEffects[]={};
		opticsFlare=1;
		optics=1;
		forceOptics=0;
		useAsBinocular=0;
		opticsDisablePeripherialVision=0.67000002;
		opticsZoomMin=0.25;
		opticsZoomMax=1.25;
		opticsZoomInit=0.75;
		distanceZoomMin=400;
		distanceZoomMax=400;
		primary=10;
		showSwitchAction=0;
		showEmpty=1;
		autoFire=0;
		autoReload=1;
		showToPlayer=1;
		canShootInWater=0;
		aiRateOfFire=5;
		aiRateOfFireDistance=500;
		aiRateOfFireDispersion=0;
		fireLightDuration=0.050000001;
		fireLightIntensity=0.2;
		fireLightDiffuse[]={0.93699998,0.63099998,0.259};
		fireLightAmbient[]={0,0,0};
		backgroundReload=0;
		reloadAction="";
		muzzles[]=
		{
			"this"
		};
		magazines[]={};
		modes[]=
		{
			"this"
		};
		useAction=0;
		useActionTitle="";
		canDrop=1;
		weaponLockDelay=0;
		weaponLockSystem=0;
		cmImmunity=1;
		weight=0;
		minRange=1;
		minRangeProbab=0.30000001;
		midRange=150;
		midRangeProbab=0.57999998;
		maxRange=500;
		maxRangeProbab=0.039999999;
		handAnim[]={};
		lockingTargetSound[]=
		{
			"",
			0.00031622773,
			2
		};
		lockedTargetSound[]=
		{
			"",
			0.00031622773,
			6
		};
		detectRange=0;
		artilleryDispersion=1;
		artilleryCharge=1;
		fireAnims[]={};
		class Library
		{
			libTextDesc="";
		};
		descriptionShort="";
		class GunFire
		{
			access=0;
			cloudletDuration=0.2;
			cloudletAnimPeriod=1;
			cloudletSize=1;
			cloudletAlpha=1;
			cloudletGrowUp=0.2;
			cloudletFadeIn=0.0099999998;
			cloudletFadeOut=0.5;
			cloudletAccY=0;
			cloudletMinYSpeed=-100;
			cloudletMaxYSpeed=100;
			cloudletShape="cloudletFire";
			cloudletColor[]={1,1,1,0};
			cloudletDensityCoef=-1;
			interval=-0.0099999998;
			size=3;
			sourceSize=0.5;
			timeToLive=0;
			initT=4500;
			deltaT=-3000;
			class Table
			{
				class T0
				{
					maxT=0;
					color[]={0.81999999,0.94999999,0.93000001,0};
				};
				class T1
				{
					maxT=200;
					color[]={0.75,0.76999998,0.89999998,0};
				};
				class T2
				{
					maxT=400;
					color[]={0.56,0.62,0.67000002,0};
				};
				class T3
				{
					maxT=600;
					color[]={0.38999999,0.46000001,0.47,0};
				};
				class T4
				{
					maxT=800;
					color[]={0.23999999,0.31,0.31,0};
				};
				class T5
				{
					maxT=1000;
					color[]={0.23,0.31,0.28999999,0};
				};
				class T6
				{
					maxT=1500;
					color[]={0.20999999,0.28999999,0.27000001,0};
				};
				class T7
				{
					maxT=2000;
					color[]={0.19,0.23,0.20999999,0};
				};
				class T8
				{
					maxT=2300;
					color[]={0.22,0.19,0.1,0};
				};
				class T9
				{
					maxT=2500;
					color[]={0.34999999,0.2,0.02,0};
				};
				class T10
				{
					maxT=2600;
					color[]={0.62,0.28999999,0.029999999,0};
				};
				class T11
				{
					maxT=2650;
					color[]={0.58999997,0.34999999,0.050000001,0};
				};
				class T12
				{
					maxT=2700;
					color[]={0.75,0.37,0.029999999,0};
				};
				class T13
				{
					maxT=2750;
					color[]={0.88,0.34,0.029999999,0};
				};
				class T14
				{
					maxT=2800;
					color[]={0.91000003,0.5,0.17,0};
				};
				class T15
				{
					maxT=2850;
					color[]={1,0.60000002,0.2,0};
				};
				class T16
				{
					maxT=2900;
					color[]={1,0.70999998,0.30000001,0};
				};
				class T17
				{
					maxT=2950;
					color[]={0.98000002,0.82999998,0.41,0};
				};
				class T18
				{
					maxT=3000;
					color[]={0.98000002,0.91000003,0.54000002,0};
				};
				class T19
				{
					maxT=3100;
					color[]={0.98000002,0.99000001,0.60000002,0};
				};
				class T20
				{
					maxT=3300;
					color[]={0.95999998,0.99000001,0.72000003,0};
				};
				class T21
				{
					maxT=3600;
					color[]={1,0.98000002,0.91000003,0};
				};
				class T22
				{
					maxT=4200;
					color[]={1,1,1,0};
				};
			};
		};
		class GunClouds
		{
			access=0;
			cloudletGrowUp=0.050000001;
			cloudletFadeIn=0;
			cloudletFadeOut=0.1;
			cloudletDuration=0.050000001;
			cloudletAlpha=0.30000001;
			cloudletAccY=0;
			cloudletMinYSpeed=-100;
			cloudletMaxYSpeed=100;
			interval=-0.02;
			size=0.30000001;
			sourceSize=0.02;
			cloudletAnimPeriod=1;
			cloudletSize=1;
			cloudletShape="cloudletClouds";
			cloudletColor[]={1,1,1,0};
			timeToLive=0;
			initT=0;
			deltaT=0;
			class Table
			{
				class T0
				{
					maxT=0;
					color[]={1,1,1,0};
				};
			};
		};
		textureType="default";
		inertia=0.5;
		aimTransitionSpeed=1;
	};
	class PistolCore: Default
	{
		dexterity=2;
		type=2;
		canLock=0;
		inertia=0.1;
	};
	class RifleCore: Default
	{
		type=1;
		dexterity=1.7;
		aiRateOfFire=0.5;
		aiRateOfFireDistance=500;
		canLock=0;
		inertia=0.5;
	};
	class MGunCore: Default
	{
		type="1	+	4";
		dexterity=0.5;
		aiRateOfFire=0.5;
		aiRateOfFireDistance=400;
		inertia=0.69999999;
	};
	class LauncherCore: Default
	{
		type=4;
		dexterity=0.5;
		aiRateOfFire=0.5;
		aiRateOfFireDistance=300;
		count=1;
		inertia=1;
	};
	class GrenadeCore: Default
	{
		type=0;
		dexterity=3;
		aiRateOfFire=1;
		aiRateOfFireDistance=40;
		count=1;
		canLock=0;
	};
	class CannonCore: Default
	{
		type=65536;
		class GunClouds
		{
		};
	};
	class FakeWeapon: MGunCore
	{
		scope=1;
		type=0;
		cursor="";
		cursoraim="";
		sound[]={};
		magazines[]=
		{
			"FakeMagazine"
		};
		sounds[]=
		{
			"StandardSound"
		};
		class StandardSound
		{
			weaponSoundEffect="DefaultRifle";
			begin1[]=
			{
				"",
				0.00031622799,
				1
			};
			soundBegin[]=
			{
				"begin1",
				1
			};
			closure1[]=
			{
				"",
				1,
				1,
				10
			};
			closure2[]=
			{
				"",
				1,
				1,
				10
			};
			soundClosure[]=
			{
				"closure1",
				0.5,
				"closure2",
				0.5
			};
		};
	};
	class DetectorCore: Default
	{
		type=4;
		simulation="ItemMineDetector";
		model="";
		picture="";
		muzzles[]={};
		class Armory
		{
			disabled=1;
		};
		detectRange=100;
	};
};
class SlotInfo
{
	access=1;
	scope=0;
	linkProxy="defaultProxy";
	compatibleItems[]=
	{
		"defaultItem1",
		"defaultItem2"
	};
	iconPosition[]={0,0};
	iconScale=0;
	iconPicture="";
	iconPinpoint="Center";
};
class CfgInventoryGlobalVariable
{
	maxSoldierLoad=50;
};
class CfgDestroySounds
{
};
class CfgCloudlets
{
	access=0;
	class Default
	{
		particleFSNtieth=1;
		particleFSIndex=0;
		particleFSFrameCount=1;
		particleFSLoop=1;
		angle=0;
		angleVar=0;
	};
	class Explosion
	{
		access=0;
		cloudletDuration=0.2;
		cloudletAnimPeriod=0.5;
		cloudletSize=1;
		cloudletAlpha=1;
		cloudletGrowUp=0.050000001;
		cloudletFadeIn=0.0099999998;
		cloudletFadeOut=0.2;
		cloudletMinYSpeed=0;
		cloudletAccY=-0.2;
		cloudletMaxYSpeed=6;
		cloudletShape="cloudletExplosion";
		cloudletColor[]={1,1,1,0};
		interval=0.001;
		size=4;
		sourceSize=3;
		timeToLive=0;
		initT=2500;
		deltaT=-4000;
		class Table
		{
			class T14
			{
				maxT=1400;
				color[]={0.91000003,0.5,0.17,0};
			};
			class T15
			{
				maxT=1500;
				color[]={1,0.60000002,0.2,0};
			};
			class T16
			{
				maxT=1600;
				color[]={1,0.70999998,0.30000001,0};
			};
			class T17
			{
				maxT=1700;
				color[]={0.98000002,0.82999998,0.41,0};
			};
			class T18
			{
				maxT=1800;
				color[]={0.98000002,0.91000003,0.54000002,0};
			};
			class T19
			{
				maxT=1900;
				color[]={0.98000002,0.99000001,0.60000002,0};
			};
			class T20
			{
				maxT=2000;
				color[]={0.95999998,0.99000001,0.72000003,0};
			};
			class T21
			{
				maxT=2100;
				color[]={1,0.98000002,0.91000003,0};
			};
			class T22
			{
				maxT=2200;
				color[]={1,1,1,0};
			};
		};
	};
	class CraterSmoke1
	{
		access=0;
		interval="0.05 / 0.8";
		cloudletAnimPeriod="1 * 0.8";
		cloudletSize=2;
		cloudletAlpha=1;
		cloudletGrowUp="1.0 * 0.8";
		cloudletFadeIn="0.1 * 0.8";
		cloudletDuration="3.0 * 0.8";
		cloudletFadeOut="1.5 * 0.8";
		cloudletAccY=-0.1;
		cloudletMinYSpeed="0.0 / 0.8";
		cloudletMaxYSpeed="5.0 / 0.8";
		cloudletColor[]={1,1,1,0};
		initT=500;
		deltaT="-50 * 0.8";
		class Table
		{
			class T0
			{
				maxT=0;
				color[]={1,1,1,0};
			};
			class T1
			{
				maxT=500;
				color[]={0.5,0.5,0.5,0};
			};
		};
		cloudletShape="cloudletSmoke";
		density="1.0 / 0.7";
		size=1;
		timeToLive="0.4 * 0.8";
		in="0.0 * 0.8";
		out="0.0 * 0.8";
		initYSpeed="5.0 / 0.8";
	};
	class CraterSmoke2
	{
		access=0;
		interval="0.1 / 0.8";
		cloudletAnimPeriod="1 * 0.8";
		cloudletSize=2;
		cloudletAlpha=1;
		cloudletGrowUp="1.0 * 0.8";
		cloudletFadeIn="0.1 * 0.8";
		cloudletDuration="2.5 * 0.8";
		cloudletFadeOut="1.5 * 0.8";
		cloudletAccY=-0.1;
		cloudletMinYSpeed="0.0 / 0.8";
		cloudletMaxYSpeed="2.0 / 0.8";
		cloudletColor[]={1,1,1,0};
		initT=0;
		deltaT="0 * 0.8";
		class Table
		{
			class T0
			{
				maxT=0;
				color[]={1,1,1,0};
			};
		};
		cloudletShape="cloudletSmoke";
		density="1.0 / 0.7";
		size=1;
		timeToLive="1.0 * 0.8";
		in="0.0 * 0.8";
		out="2.0 * 0.8";
		initYSpeed="0 / 0.8";
	};
	class CraterSmoke3
	{
		access=0;
		interval="0.1 / 0.8";
		cloudletAnimPeriod="1 * 0.8";
		cloudletSize=1;
		cloudletAlpha=0.30000001;
		cloudletGrowUp="1.0 * 0.8";
		cloudletFadeIn="0.5 * 0.8";
		cloudletDuration="3 * 0.8";
		cloudletFadeOut="1 * 0.8";
		cloudletAccY="-0.1 * 0.8";
		cloudletMinYSpeed="0.0 / 0.8";
		cloudletMaxYSpeed="5.0 / 0.8";
		cloudletColor[]={1,1,1,0};
		initT=500;
		deltaT="-80 * 0.8";
		class Table
		{
			class T0
			{
				maxT=0;
				color[]={1,1,1,0};
			};
		};
		cloudletShape="cloudletSmoke";
		density="0.5 / 0.7";
		size=1;
		timeToLive="2.0 * 0.8";
		in="0.2 * 0.8";
		out="0.0 * 0.8";
		initYSpeed="5.0 / 0.8";
	};
	class CraterDustSmall
	{
		access=0;
		interval=0.0099999998;
		cloudletSize=1;
		cloudletAlpha=0.60000002;
		cloudletDuration=0.2;
		cloudletAnimPeriod=1;
		cloudletGrowUp=0.60000002;
		cloudletFadeIn=0;
		cloudletFadeOut=0.60000002;
		cloudletAccY=-3.5;
		cloudletMinYSpeed=-20;
		cloudletMaxYSpeed=10;
		cloudletColor[]={0.25,0.23,0.16,0};
		initT=0;
		deltaT=0;
		class Table
		{
			class T0
			{
				maxT=0;
				color[]={1,1,1,0};
			};
		};
		cloudletShape="cloudletDust";
		size=0.2;
		sourceSize=0.02;
	};
	class CraterBlood: CraterDustSmall
	{
		access=0;
		interval=0.0049999999;
		cloudletAlpha=0.5;
		cloudletDuration=0.1;
		cloudletAnimPeriod=1;
		cloudletGrowUp=0.30000001;
		cloudletFadeIn=0;
		cloudletFadeOut=0.30000001;
		cloudletAccY=-1;
		cloudletMinYSpeed=-10;
		cloudletMaxYSpeed=10;
		cloudletShape="cloudletBlood";
		cloudletColor[]={0.34999999,0,0.050000001,0};
		size=0.15000001;
		sourceSize=0.050000001;
	};
	class CraterWater: CraterDustSmall
	{
		access=0;
		interval=0.0099999998;
		cloudletAlpha=1;
		cloudletDuration=0.30000001;
		cloudletAnimPeriod=1;
		cloudletGrowUp=0.30000001;
		cloudletFadeIn=0;
		cloudletFadeOut=0.2;
		cloudletAccY=-10;
		cloudletMinYSpeed=-100;
		cloudletMaxYSpeed=100;
		cloudletShape="cloudletWater";
		cloudletColor[]={0.54000002,0.69,0.64499998,0};
		size=0.02;
		sourceSize=0.02;
	};
	class CraterDustBig: CraterDustSmall
	{
		access=0;
		cloudletDuration=2;
		cloudletGrowUp=0.2;
		cloudletFadeIn=0.2;
		cloudletFadeOut=1.5;
		cloudletAccY=-8;
		cloudletMinYSpeed=-20;
		cloudletMaxYSpeed=10;
	};
	class CloudletsMissile
	{
		access=0;
		interval=0.0049999999;
		cloudletSize=1.7;
		cloudletAlpha=0.5;
		cloudletDuration=0.44999999;
		cloudletAnimPeriod=1;
		cloudletGrowUp=0.050000001;
		cloudletFadeIn=0;
		cloudletFadeOut=0.5;
		cloudletAccY=0;
		cloudletMinYSpeed=-10;
		cloudletMaxYSpeed=10;
		cloudletColor[]={1,1,1,0};
		initT=0;
		deltaT=0;
		class Table
		{
			class T0
			{
				maxT=0;
				color[]={1,1,1,0};
			};
		};
		cloudletShape="cloudletMissile";
	};
	class CloudletsMissileManual: CloudletsMissile
	{
		cloudletSize=0.30000001;
		cloudletAlpha=0.40000001;
	};
	class CloudletsDebugTrace: CloudletsMissile
	{
		cloudletSize=0.02;
		cloudletAlpha=0.5;
		cloudletDuration=1;
		cloudletColor[]={0.5,0.5,0,0};
	};
	class CloudletsScud: CloudletsMissile
	{
		cloudletSize=5;
		cloudletAlpha=0.5;
		cloudletColor[]={1,1,1,0};
		cloudletFadeIn=0;
		cloudletDuration=1.5;
		cloudletFadeOut=0.5;
		cloudletGrowUp=1;
		cloudletAccY=0;
		cloudletMinYSpeed=-1000;
		cloudletMaxYSpeed=1000;
		interval=0.02;
		size=8;
		sourceSize=1;
	};
	class DefaultSmoke
	{
		interval=0.30000001;
		cloudletDuration=1;
		cloudletAnimPeriod=3;
		cloudletSize=1;
		cloudletAlpha=1;
		cloudletGrowUp=0.30000001;
		cloudletFadeIn=0.5;
		cloudletFadeOut=2;
		cloudletAccY=0;
		cloudletMinYSpeed=-10;
		cloudletMaxYSpeed=10;
		cloudletColor[]={1,1,1,1};
		initT=0;
		deltaT=0;
		class Table
		{
		};
		cloudletShape="cloudletSmoke";
		density=1;
		size=1;
		timeToLive=30;
		in=1;
		out=1;
		initYSpeed=3.5;
	};
	class DestructedObjectDust
	{
		interval=0.15000001;
		cloudletDuration=0.5;
		cloudletAnimPeriod=1;
		cloudletSize=0.5;
		cloudletAlpha=1;
		cloudletGrowUp=0.40000001;
		cloudletFadeIn=0.2;
		cloudletFadeOut=1.5;
		cloudletAccY=-0.5;
		cloudletMinYSpeed=-1;
		cloudletMaxYSpeed=1;
		cloudletColor[]={0.25,0.23,0.16,1};
		initT=0;
		deltaT=0;
		class Table
		{
		};
		cloudletShape="cloudletSmoke";
		density=2;
		size=0.5;
		timeToLive=0.40000001;
		in=0.80000001;
		out=0.80000001;
		initYSpeed=2.5;
	};
	class DestructedEngineSmoke
	{
		interval=0.30000001;
		cloudletDuration=0.5;
		cloudletAnimPeriod=3;
		cloudletSize=1;
		cloudletAlpha=1;
		cloudletGrowUp=0.5;
		cloudletFadeIn=0.5;
		cloudletFadeOut=3;
		cloudletAccY=-0.80000001;
		cloudletMinYSpeed=0;
		cloudletMaxYSpeed=5;
		cloudletColor[]={0.15000001,0.15000001,0.1,1};
		initT=0;
		deltaT=0;
		class Table
		{
		};
		cloudletShape="cloudletSmoke";
		density=1;
		size=1;
		timeToLive=6;
		in=1;
		out=6;
		initYSpeed=3.5;
	};
	class ObjectDestructionFire1: Default
	{
		damageType="Fire";
	};
	class ObjectDestructionFire2: Default
	{
		damageType="Fire";
	};
	class SmallFireF: Default
	{
		damageType="Fire";
	};
};
class CfgOpticsEffect
{
};
class MissileManualEffects
{
};
class MissileEffects
{
};
class ImpactEffectsBig
{
};
class ImpactEffectsSmall
{
};
class ImpactEffectsBlood
{
};
class ImpactEffectsWater
{
};
class ExplosionEffects
{
};
class ExhaustsEffect
{
};
class ExhaustsEffectBig
{
};
class LDustEffects
{
};
class RDustEffects
{
};
class LWaterEffects
{
};
class RWaterEffects
{
};
class LEngEffects
{
};
class REngEffects
{
};
class FDustEffects
{
};
class HeliDust
{
};
class HeliWater
{
};
class DamageSmokeHeli
{
};
class DamageSmokePlane
{
};
class ScudEffect
{
};
class CfgDestructPos
{
	class DelayedDestruction
	{
		timeBeforeHiding="0.2";
		hideDuration="0.65+lifeTime*0.05";
	};
};
class CfgDamageAround
{
	class DamageAroundHouse
	{
		radiusRatio="1.0";
		indirectHit="11";
	};
};
class WeaponFireGun
{
	access=0;
	cloudletDuration=0.2;
	cloudletAnimPeriod=1;
	cloudletSize=1;
	cloudletAlpha=1;
	cloudletGrowUp=0.2;
	cloudletFadeIn=0.0099999998;
	cloudletFadeOut=0.5;
	cloudletAccY=0;
	cloudletMinYSpeed=-100;
	cloudletMaxYSpeed=100;
	cloudletShape="cloudletFire";
	cloudletColor[]={1,1,1,0};
	interval=0.0099999998;
	size=3;
	sourceSize=0.5;
	timeToLive=0;
	initT=4500;
	deltaT=-3000;
	class Table
	{
		class T0
		{
			maxT=0;
			color[]={0.81999999,0.94999999,0.93000001,0};
		};
		class T1
		{
			maxT=200;
			color[]={0.75,0.76999998,0.89999998,0};
		};
		class T2
		{
			maxT=400;
			color[]={0.56,0.62,0.67000002,0};
		};
		class T3
		{
			maxT=600;
			color[]={0.38999999,0.46000001,0.47,0};
		};
		class T4
		{
			maxT=800;
			color[]={0.23999999,0.31,0.31,0};
		};
		class T5
		{
			maxT=1000;
			color[]={0.23,0.31,0.28999999,0};
		};
		class T6
		{
			maxT=1500;
			color[]={0.20999999,0.28999999,0.27000001,0};
		};
		class T7
		{
			maxT=2000;
			color[]={0.19,0.23,0.20999999,0};
		};
		class T8
		{
			maxT=2300;
			color[]={0.22,0.19,0.1,0};
		};
		class T9
		{
			maxT=2500;
			color[]={0.34999999,0.2,0.02,0};
		};
		class T10
		{
			maxT=2600;
			color[]={0.62,0.28999999,0.029999999,0};
		};
		class T11
		{
			maxT=2650;
			color[]={0.58999997,0.34999999,0.050000001,0};
		};
		class T12
		{
			maxT=2700;
			color[]={0.75,0.37,0.029999999,0};
		};
		class T13
		{
			maxT=2750;
			color[]={0.88,0.34,0.029999999,0};
		};
		class T14
		{
			maxT=2800;
			color[]={0.91000003,0.5,0.17,0};
		};
		class T15
		{
			maxT=2850;
			color[]={1,0.60000002,0.2,0};
		};
		class T16
		{
			maxT=2900;
			color[]={1,0.70999998,0.30000001,0};
		};
		class T17
		{
			maxT=2950;
			color[]={0.98000002,0.82999998,0.41,0};
		};
		class T18
		{
			maxT=3000;
			color[]={0.98000002,0.91000003,0.54000002,0};
		};
		class T19
		{
			maxT=3100;
			color[]={0.98000002,0.99000001,0.60000002,0};
		};
		class T20
		{
			maxT=3300;
			color[]={0.95999998,0.99000001,0.72000003,0};
		};
		class T21
		{
			maxT=3600;
			color[]={1,0.98000002,0.91000003,0};
		};
		class T22
		{
			maxT=4200;
			color[]={1,1,1,0};
		};
	};
};
class WeaponFireMGun: WeaponFireGun
{
	cloudletDuration=0;
	cloudletGrowUp=0.059999999;
	cloudletFadeIn=0;
	cloudletFadeOut=0.12;
	interval=0.0049999999;
	size=0.12;
	sourceSize=0.0099999998;
	initT=3200;
	deltaT=-4000;
};
class WeaponCloudsGun
{
	access=0;
	cloudletDuration=0.30000001;
	cloudletAnimPeriod=1;
	cloudletSize=1;
	cloudletAlpha=1;
	cloudletGrowUp=1;
	cloudletFadeIn=0.0099999998;
	cloudletFadeOut=1;
	cloudletAccY=0.40000001;
	cloudletMinYSpeed=0.2;
	cloudletMaxYSpeed=0.80000001;
	cloudletShape="cloudletClouds";
	cloudletColor[]={1,1,1,0};
	interval=0.050000001;
	size=3;
	sourceSize=0.5;
	timeToLive=0;
	initT=0;
	deltaT=0;
	class Table
	{
		class T0
		{
			maxT=0;
			color[]={1,1,1,0};
		};
	};
};
class WeaponCloudsMGun: WeaponCloudsGun
{
	access=0;
	cloudletGrowUp=0.050000001;
	cloudletFadeIn=0;
	cloudletFadeOut=0.1;
	cloudletDuration=0.050000001;
	cloudletAlpha=0.30000001;
	cloudletAccY=0;
	cloudletMinYSpeed=-100;
	cloudletMaxYSpeed=100;
	interval=0.02;
	size=0.30000001;
	sourceSize=0.02;
};
class CfgLights
{
	class ObjectDestructionLight
	{
		color[]={1.5,0.75,0};
		ambient[]={0.44999999,0.22,0};
		brightness[]=
		{
			"fireIntensity",
			0,
			0.0099999998
		};
	};
	class ExplosionLight
	{
		color[]={1,1,1};
		ambient[]={0.44999999,0.22,0};
		brightness[]=
		{
			"fireIntensity",
			0,
			0.0099999998
		};
	};
};
class CfgCloth
{
	class Flag
	{
		stepSize=0.0049999999;
		colPoints=9;
		rowPoints=9;
		stretchCoef=1000;
		fricCoef=1;
		windCoef=10;
		gravCoef=1;
	};
};
class CfgVehicleClasses
{
	access=1;
	class Men
	{
		displayName="$STR_DN_MEN";
	};
	class Animals
	{
		displayName="$STR_DN_ANIMALS";
	};
	class Car
	{
		displayName="$STR_DN_CARS";
	};
	class Armored
	{
		displayName="$STR_DN_ARMORED";
	};
	class Air
	{
		displayName="$STR_DN_AIR";
	};
	class Support
	{
		displayName="$STR_DN_SUPPORTS";
	};
	class Camera
	{
		displayName="$STR_DN_CAMERAS";
	};
	class Objects
	{
		displayName="$STR_DN_OBJECTS";
	};
	class Ammo
	{
		displayName="$STR_DN_AMMO";
	};
	class Sounds
	{
		displayName="$STR_DN_SOUNDS";
	};
	class Mines
	{
		displayName="$STR_DN_MINES";
	};
	class Ship
	{
		displayName="$STR_DN_SHIPS";
	};
};
class CfgFactionClasses
{
	access=1;
	class Default
	{
		displayName="$STR_disp_other";
		priority=10000;
		side=-1;
	};
};
class AirplaneHUD
{
	topLeft="HUD LH";
	topRight="HUD PH";
	bottomLeft="HUD LD";
	borderLeft=0;
	borderRight=0;
	borderTop=0;
	borderBottom=0;
	color[]={0,1,0,0.1};
	class Pos10Vector
	{
		type="vector";
		pos0[]={0.5,0.27000001};
		pos10[]=
		{
			"0.5+0.9",
			"0.27+0.7"
		};
	};
	class Bones
	{
		class AGLMove1
		{
			type="linear";
			source="altitudeAGL";
			min=0;
			max=100;
			minPos[]={0.050000001,0.1};
			maxPos[]={0.050000001,0.80000001};
		};
		class AGLMove2
		{
			type="fixed";
			pos[]={0.050000001,0.80000001};
		};
		class ASLMove1
		{
			type="linear";
			source="altitudeASL";
			min=0;
			max=500;
			minPos[]={0.1,0.1};
			maxPos[]={0.1,0.80000001};
		};
		class ASLMove2
		{
			type="fixed";
			pos[]={0.1,0.80000001};
		};
		class VertSpeed
		{
			type="linear";
			source="vSpeed";
			min=-25;
			max=25;
			minPos[]={0,-0.40000001};
			maxPos[]={0,0.40000001};
		};
		class SpdMove2
		{
			source="speed";
			min=33;
			max=200;
			type="linear";
			minPos[]={0.94,0.1};
			maxPos[]={0.94,0.87};
		};
		class ILS
		{
			type="ils";
			pos0[]={0.5,0.40000001};
			pos3[]={0.69999999,0.60000002};
		};
		class WeaponAim: Pos10Vector
		{
			source="weapon";
		};
		class Target: Pos10Vector
		{
			source="target";
		};
		class TargetDistanceMissile
		{
			type="rotational";
			source="targetDist";
			center[]={0,0};
			min=100;
			max=3000;
			minAngle=-120;
			maxAngle=120;
		};
		class TargetDistanceMGun
		{
			type="rotational";
			source="targetDist";
			center[]={0,0};
			min=100;
			max=1000;
			minAngle=-180;
			maxAngle=90;
		};
		class Level0: Pos10Vector
		{
			type="horizon";
			angle=0;
		};
		class LevelP5: Level0
		{
			angle=5;
		};
		class LevelM5: Level0
		{
			angle=-5;
		};
		class LevelP10: Level0
		{
			angle=10;
		};
		class LevelM10: Level0
		{
			angle=-10;
		};
		class LevelP15: Level0
		{
			angle=15;
		};
		class LevelM15: Level0
		{
			angle=-15;
		};
		class Velocity: Pos10Vector
		{
			type="vector";
			source="velocity";
		};
		class PlaneW
		{
			type="fixed";
			pos[]={0.5,0.27000001};
		};
	};
	class Draw
	{
		alpha=0.80000001;
		color[]={0.1,0.5,0.050000001};
		clipTL[]={0,0.050000001};
		clipBR[]={1,0.89999998};
		condition="on";
		class Altitude
		{
			type="line";
			points[]=
			{
				
				{
					"AGLMove1",
					1
				},
				
				{
					"AGLMove2",
					1
				},
				{},
				
				{
					"ASLMove2",
					1
				},
				
				{
					"ASLMove1",
					1
				},
				
				{
					"ASLMove1",
					{0.02,0},
					1
				},
				
				{
					"ASLMove1",
					{0.02,0},
					1,
					"VertSpeed",
					1
				}
			};
		};
		class DimmedBase
		{
			alpha=0.30000001;
			class AltitudeBase
			{
				type="line";
				points[]=
				{
					
					{
						"AGLMove2",
						1
					},
					
					{
						"ASLMove2",
						1
					}
				};
			};
		};
		class Speed
		{
			type="line";
			points[]=
			{
				
				{
					{0.94999999,0.87},
					1
				},
				
				{
					{0.94999999,0.1},
					1
				},
				{},
				
				{
					"SpdMove2",
					{-0.050000001,0},
					1
				},
				
				{
					"SpdMove2",
					1
				}
			};
		};
		class SpeedNumber
		{
			type="text";
			align="left";
			scale=1;
			source="speed";
			sourceScale=3.5999999;
			pos[]=
			{
				"SpdMove2",
				{-0.050000001,-0.029999999},
				1
			};
			right[]=
			{
				"SpdMove2",
				{0.0099999998,-0.029999999},
				1
			};
			down[]=
			{
				"SpdMove2",
				{-0.050000001,0.029999999},
				1
			};
		};
		class PlaneW
		{
			clipTL[]={0,0.1};
			clipBR[]={1,0.89999998};
			class LineHL
			{
				type="line";
				points[]=
				{
					
					{
						"PlaneW",
						{-0.07,0},
						1
					},
					
					{
						"PlaneW",
						{-0.02,0},
						1
					},
					
					{
						"PlaneW",
						{0,-0.02},
						1
					},
					
					{
						"PlaneW",
						{0.02,0},
						1
					},
					
					{
						"PlaneW",
						{0,0.02},
						1
					},
					
					{
						"PlaneW",
						{-0.02,0},
						1
					},
					{},
					
					{
						"PlaneW",
						{0.02,0},
						1
					},
					
					{
						"PlaneW",
						{0.07,0},
						1
					}
				};
			};
			class Velocity
			{
				type="line";
				points[]=
				{
					
					{
						"Velocity",
						{0,-0.02},
						1
					},
					
					{
						"Velocity",
						{0.02,0},
						1
					},
					
					{
						"Velocity",
						{0,0.02},
						1
					},
					
					{
						"Velocity",
						{-0.02,0},
						1
					},
					
					{
						"Velocity",
						{0,-0.02},
						1
					}
				};
			};
		};
		class MGun
		{
			condition="mgun";
			class Circle
			{
				type="line";
				points[]=
				{
					
					{
						"WeaponAim",
						{0,-0.07},
						1
					},
					
					{
						"WeaponAim",
						
						{
							"+0.7*0.07",
							"-0.7*0.07"
						},
						1
					},
					
					{
						"WeaponAim",
						{0.07,0},
						1
					},
					
					{
						"WeaponAim",
						
						{
							"+0.7*0.07",
							"+0.7*0.07"
						},
						1
					},
					
					{
						"WeaponAim",
						{0,0.07},
						1
					},
					
					{
						"WeaponAim",
						
						{
							"-0.7*0.07",
							"+0.7*0.07"
						},
						1
					},
					
					{
						"WeaponAim",
						{-0.07,0},
						1
					},
					
					{
						"WeaponAim",
						
						{
							"-0.7*0.07",
							"-0.7*0.07"
						},
						1
					},
					
					{
						"WeaponAim",
						{0,-0.07},
						1
					},
					{},
					
					{
						"WeaponAim",
						{0,-0.0099999998},
						1
					},
					
					{
						"WeaponAim",
						
						{
							"+0.7*0.01",
							"-0.7*0.01"
						},
						1
					},
					
					{
						"WeaponAim",
						{0.0099999998,0},
						1
					},
					
					{
						"WeaponAim",
						
						{
							"+0.7*0.01",
							"+0.7*0.01"
						},
						1
					},
					
					{
						"WeaponAim",
						{0,0.0099999998},
						1
					},
					
					{
						"WeaponAim",
						
						{
							"-0.7*0.01",
							"+0.7*0.01"
						},
						1
					},
					
					{
						"WeaponAim",
						{-0.0099999998,0},
						1
					},
					
					{
						"WeaponAim",
						
						{
							"-0.7*0.01",
							"-0.7*0.01"
						},
						1
					},
					
					{
						"WeaponAim",
						{0,-0.0099999998},
						1
					},
					{},
					
					{
						"WeaponAim",
						
						{
							"0.03*sin(-180)",
							"-0.03*cos(-180)"
						},
						1
					},
					
					{
						"WeaponAim",
						
						{
							"0.07*sin(-180)",
							"-0.07*cos(-180)"
						},
						1
					},
					{},
					
					{
						"WeaponAim",
						
						{
							"0.03*sin(+90)",
							"-0.03*cos(+90)"
						},
						1
					},
					
					{
						"WeaponAim",
						
						{
							"0.07*sin(+90)",
							"-0.07*cos(+90)"
						},
						1
					},
					{},
					
					{
						"WeaponAim",
						1,
						"TargetDistanceMGun",
						{0,0.039999999},
						1
					},
					
					{
						"WeaponAim",
						1,
						"TargetDistanceMGun",
						{0,0.07},
						1
					}
				};
			};
		};
		class Missile
		{
			condition="missile";
			class Circle
			{
				type="line";
				points[]=
				{
					
					{
						"WeaponAim",
						{0,-0.1},
						1
					},
					
					{
						"WeaponAim",
						
						{
							"+0.7*0.1",
							"-0.7*0.1"
						},
						1
					},
					
					{
						"WeaponAim",
						{0.1,0},
						1
					},
					
					{
						"WeaponAim",
						
						{
							"+0.7*0.1",
							"+0.7*0.1"
						},
						1
					},
					
					{
						"WeaponAim",
						{0,0.1},
						1
					},
					
					{
						"WeaponAim",
						
						{
							"-0.7*0.1",
							"+0.7*0.1"
						},
						1
					},
					
					{
						"WeaponAim",
						{-0.1,0},
						1
					},
					
					{
						"WeaponAim",
						
						{
							"-0.7*0.1",
							"-0.7*0.1"
						},
						1
					},
					
					{
						"WeaponAim",
						{0,-0.1},
						1
					},
					{},
					
					{
						"WeaponAim",
						
						{
							"0.1*0.8*sin(-120)",
							"-0.1*0.8*cos(-120)"
						},
						1
					},
					
					{
						"WeaponAim",
						
						{
							"0.1*1.2*sin(-120)",
							"-0.1*1.2*cos(-120)"
						},
						1
					},
					{},
					
					{
						"WeaponAim",
						
						{
							"0.1*0.8*sin(+120)",
							"-0.1*0.8*cos(+120)"
						},
						1
					},
					
					{
						"WeaponAim",
						
						{
							"0.1*1.2*sin(+120)",
							"-0.1*1.2*cos(+120)"
						},
						1
					},
					{},
					
					{
						"WeaponAim",
						1,
						"TargetDistanceMissile",
						
						{
							0,
							"0.1*0.8"
						},
						1
					},
					
					{
						"WeaponAim",
						1,
						"TargetDistanceMissile",
						
						{
							0,
							"0.1*1.2"
						},
						1
					}
				};
			};
			class Target
			{
				type="line";
				points[]=
				{
					
					{
						"Target",
						{-0.050000001,-0.050000001},
						1
					},
					
					{
						"Target",
						{0.050000001,-0.050000001},
						1
					},
					
					{
						"Target",
						{0.050000001,0.050000001},
						1
					},
					
					{
						"Target",
						{-0.050000001,0.050000001},
						1
					},
					
					{
						"Target",
						{-0.050000001,-0.050000001},
						1
					}
				};
			};
		};
		class Horizont
		{
			clipTL[]={0.2,0.1};
			clipBR[]={0.80000001,0.89999998};
			class Dimmed
			{
				alpha=0.60000002;
				class Level0
				{
					type="line";
					points[]=
					{
						
						{
							"Level0",
							{-0.40000001,0},
							1
						},
						
						{
							"Level0",
							{-0.13,0},
							1
						},
						{},
						
						{
							"Level0",
							{0.13,0},
							1
						},
						
						{
							"Level0",
							{0.40000001,0},
							1
						}
					};
				};
			};
			class LevelP5
			{
				type="line";
				points[]=
				{
					
					{
						"LevelP5",
						{-0.15000001,0.029999999},
						1
					},
					
					{
						"LevelP5",
						{-0.15000001,0},
						1
					},
					
					{
						"LevelP5",
						{0.15000001,0},
						1
					},
					
					{
						"LevelP5",
						{0.15000001,0.029999999},
						1
					}
				};
			};
			class LevelM5
			{
				type="line";
				points[]=
				{
					
					{
						"LevelM5",
						{-0.15000001,-0.029999999},
						1
					},
					
					{
						"LevelM5",
						{-0.15000001,0},
						1
					},
					
					{
						"LevelM5",
						{0.15000001,0},
						1
					},
					
					{
						"LevelM5",
						{0.15000001,-0.029999999},
						1
					}
				};
			};
			class LevelP10
			{
				type="line";
				points[]=
				{
					
					{
						"LevelP10",
						{-0.2,0.050000001},
						1
					},
					
					{
						"LevelP10",
						{-0.2,0},
						1
					},
					
					{
						"LevelP10",
						{0.2,0},
						1
					},
					
					{
						"LevelP10",
						{0.2,0.050000001},
						1
					}
				};
			};
			class LevelM10
			{
				type="line";
				points[]=
				{
					
					{
						"LevelM10",
						{-0.2,-0.050000001},
						1
					},
					
					{
						"LevelM10",
						{-0.2,0},
						1
					},
					
					{
						"LevelM10",
						{0.2,0},
						1
					},
					
					{
						"LevelM10",
						{0.2,-0.050000001},
						1
					}
				};
			};
			class LevelP15
			{
				type="line";
				points[]=
				{
					
					{
						"LevelP15",
						{-0.2,0.07},
						1
					},
					
					{
						"LevelP15",
						{-0.2,0},
						1
					},
					
					{
						"LevelP15",
						{0.2,0},
						1
					},
					
					{
						"LevelP15",
						{0.2,0.07},
						1
					}
				};
			};
			class LevelM15
			{
				type="line";
				points[]=
				{
					
					{
						"LevelM15",
						{-0.2,-0.07},
						1
					},
					
					{
						"LevelM15",
						{-0.2,0},
						1
					},
					
					{
						"LevelM15",
						{0.2,0},
						1
					},
					
					{
						"LevelM15",
						{0.2,-0.07},
						1
					}
				};
			};
		};
		class ILS
		{
			condition="ils";
			class Glideslope
			{
				clipTL[]={0.28999999,0.28999999};
				clipBR[]={0.70999998,0.70999998};
				class ILS
				{
					type="line";
					points[]=
					{
						
						{
							"ILS",
							{-10,0},
							1
						},
						
						{
							"ILS",
							{10,0},
							1
						},
						{},
						
						{
							"ILS",
							{0,-10},
							1
						},
						
						{
							"ILS",
							{0,10},
							1
						}
					};
				};
			};
			class AOABracket
			{
				type="line";
				points[]=
				{
					
					{
						{0.41999999,0.77999997},
						1
					},
					
					{
						{0.40000001,0.77999997},
						1
					},
					
					{
						{0.40000001,0.88},
						1
					},
					
					{
						{0.41999999,0.88},
						1
					}
				};
			};
		};
	};
};
class CfgVehicles
{
	access=1;
	class All
	{
		access=0;
		scope=0;
		reversed=1;
		autocenter=1;
		animated=1;
		shadow=1;
		mapSize=10;
		featureSize=0;
		vehicleClass="";
		icon="iconObject";
		side=4;
		faction="Default";
		displayName="$STR_DN_UNKNOWN";
		nameSound="unknown";
		speechSingular[]={};
		speechPlural[]={};
		textSingular="";
		textPlural="";
		maxDetectRange=20;
		detectSkill=20;
		mineAlertIconRange=200;
		killFriendlyExpCoef=1;
		weaponSlots=0;
		camouflage=2;
		audible=1;
		accuracy=0;
		spotableDarkNightLightsOff=0.001;
		spotableNightLightsOff=0.02;
		spotableNightLightsOn=4;
		accuracyDarkNightLightsOff=0.001;
		accuracyNightLightsOff=0.0060000001;
		accuracyNightLightsOn=0.1;
		attenuationEffectType="";
		insideSoundCoef=0.5;
		outsideSoundFilter=0;
		insideDetectCoef=0.5;
		occludeSoundsWhenIn=0.31622776;
		obstructSoundsWhenIn=0.56234133;
		obstructSoundLFRatio=0;
		occludeSoundLFRatio=0.25;
		unloadInCombat=0;
		antiRollbarForceCoef=0;
		antiRollbarForceLimit=5;
		antiRollbarSpeedMin=20;
		antiRollbarSpeedMax=60;
		slowSpeedForwardCoef=0.30000001;
		normalSpeedForwardCoef=0.85000002;
		epeImpulseDamageCoef=30;
		gunnerHasFlares=1;
		enableManualFire=1;
		sensitivity=2.5;
		sensitivityEar=0.0074999998;
		model="bmp";
		picture="";
		portrait="";
		ghostPreview="";
		simulation="";
		destrType="DestructDefault";
		armor=100;
		armorLights=0.40000001;
		armorStructural=1;
		crewVulnerable=1;
		damageResistance=0.0040000002;
		crewCrashProtection=1;
		replaceDamaged="";
		replaceDamagedLimit=0.89999998;
		replaceDamagedHitpoints[]={};
		keepInEPESceneAfterDeath=0;
		cost=500000;
		fuelCapacity=0;
		fuelConsumptionRate=0.0099999998;
		extCameraPosition[]={0,2,-20};
		groupCameraPosition[]={0,5,-30};
		steerAheadSimul=0.30000001;
		steerAheadPlan=0.40000001;
		cameraSmoothSpeed=5;
		minFireTime=20;
		predictTurnSimul=1.2;
		predictTurnPlan=1;
		indirectHitEnemyCoefAI=10;
		indirectHitFriendlyCoefAI=-20;
		indirectHitCivilianCoefAI=-20;
		indirectHitUnknownCoefAI=-0.5;
		precision=5;
		brakeDistance=5;
		formationX=10;
		formationZ=20;
		formationTime=5;
		alwaysTarget=0;
		irTarget=1;
		irScanRangeMin=0;
		irScanRangeMax=0;
		irScanToEyeFactor=1;
		irScanGround=1;
		laserTarget=0;
		laserScanner=0;
		nvTarget=0;
		nvScanner=0;
		artilleryTarget=0;
		artilleryScanner=0;
		canUseScanners=1;
		preferRoads=0;
		unitInfoType="RscUnitInfoTank";
		unitInfoTypeLite=0;
		hideUnitInfo=0;
		nightVision=0;
		commanderCanSee=31;
		gunnerCanSee="4+8+16";
		driverCanSee="2+8+16";
		showCrewAim=7;
		radarType=0;
		maxSpeed=80;
		limitedSpeedCoef=0.22;
		secondaryExplosion=-1;
		hasDriver=1;
		driverForceOptics=0;
		hideWeaponsDriver=1;
		hideWeaponsCargo=0;
		getInRadius=2.5;
		selectionClan="";
		selectionDashboard="";
		selectionShowDamage="";
		selectionBackLights="";
		memoryPointSupply="doplnovani";
		supplyRadius=-1;
		enableGPS=0;
		enableWatch=0;
		enableRadio=0;
		lockDetectionSystem=0;
		incomingMissileDetectionSystem=0;
		usePreciseGetInAction=0;
		allowTabLock=1;
		showAllTargets=0;
		dustFrontLeftPos="dustFrontLeft";
		dustFrontRightPos="dustFrontRight";
		dustBackLeftPos="dustBackLeft";
		dustBackRightPos="dustBackRight";
		wheelCircumference=1;
		waterLeakiness=0.5;
		waterResistanceCoef=0.5;
		waterLinearDampingCoefX=0;
		waterLinearDampingCoefY=0;
		waterAngularDampingCoef=0;
		showNVGDriver=0;
		showNVGCommander=0;
		showNVGGunner=0;
		showNVGCargo[]={0};
		soundAttenuationCargo[]={1};
		countsForScoreboard=1;
		hullDamageCauseExplosion=0;
		class EventHandlers
		{
		};
		class MarkerLights
		{
		};
		class NVGMarkers
		{
		};
		class NVGMarker
		{
			diffuse[]={1,1,1,1};
			ambient[]={1,1,1,1};
			brightness=1;
			blinking=0;
			onlyInNvg=0;
		};
		class Turrets
		{
		};
		class HeadLimits
		{
			initAngleX=5;
			minAngleX=-30;
			maxAngleX=40;
			initAngleY=0;
			minAngleY=-90;
			maxAngleY=90;
			minAngleZ=-45;
			maxAngleZ=45;
			rotZRadius=0.2;
		};
		class ViewPilot
		{
			initAngleX=5;
			minAngleX=-55;
			maxAngleX=85;
			initAngleY=0;
			minAngleY=-150;
			maxAngleY=150;
			minFov=0.25;
			maxFov=1.25;
			initFov=0.75;
			minMoveX=0;
			maxMoveX=0;
			minMoveY=0;
			maxMoveY=0;
			minMoveZ=0;
			maxMoveZ=0;
		};
		class ViewCargo
		{
			initAngleX=5;
			minAngleX=-85;
			maxAngleX=85;
			initAngleY=0;
			minAngleY=-150;
			maxAngleY=150;
			minFov=0.25;
			maxFov=1.25;
			initFov=0.75;
			minMoveX=0;
			maxMoveX=0;
			minMoveY=0;
			maxMoveY=0;
			minMoveZ=0;
			maxMoveZ=0;
		};
		class ViewOptics
		{
			initAngleX=0;
			minAngleX=-30;
			maxAngleX=30;
			initAngleY=0;
			minAngleY=-100;
			maxAngleY=100;
			initFov=0.69999999;
			minFov=0.41999999;
			maxFov=0.85000002;
			minMoveX=0;
			maxMoveX=0;
			minMoveY=0;
			maxMoveY=0;
			minMoveZ=0;
			maxMoveZ=0;
		};
		class PilotSpec
		{
			showHeadPhones=0;
		};
		class CargoSpec
		{
			class Cargo1
			{
				showHeadPhones=0;
			};
		};
		transportSoldier=0;
		transportAmmo=0;
		transportMaxMagazines=0;
		transportMaxWeapons=0;
		transportMaxBackpacks=0;
		isbackpack=0;
		transportFuel=0;
		transportRepair=0;
		transportVehiclesCount=0;
		transportVehiclesMass=0;
		class TransportWeapons
		{
		};
		class TransportMagazines
		{
		};
		attendant=0;
		engineer=0;
		uavHacker=0;
		soundEngine[]=
		{
			"",
			1,
			1
		};
		soundEnviron[]=
		{
			"",
			1,
			1
		};
		class SoundEnvironExt
		{
		};
		class SoundEquipment
		{
		};
		class SoundGear
		{
		};
		class SoundBreath
		{
		};
		class SoundBreathSwimming
		{
		};
		class SoundBreathInjured
		{
		};
		class SoundHitScream
		{
		};
		class SoundInjured
		{
		};
		class SoundBreathAutomatic
		{
		};
		class SoundDrown
		{
		};
		class SoundChoke
		{
		};
		class SoundRecovered
		{
		};
		class SoundBurning
		{
		};
		class PulsationSound
		{
		};
		class SoundDrowning
		{
		};
		soundCrash[]=
		{
			"",
			0.31622776,
			1
		};
		soundLandCrash[]=
		{
			"",
			1,
			1
		};
		soundWaterCrash[]=
		{
			"",
			0.17782794,
			1
		};
		soundGetIn[]=
		{
			"",
			0.00031622773,
			1
		};
		soundGetOut[]=
		{
			"",
			0.00031622773,
			1
		};
		soundServo[]=
		{
			"",
			0.0031622774,
			0.5
		};
		soundElevation[]=
		{
			"",
			1,
			0.5
		};
		sounddamage[]=
		{
			"",
			1,
			1
		};
		soundEngineOnInt[]=
		{
			"",
			1,
			1
		};
		soundEngineOffInt[]=
		{
			"",
			1,
			1
		};
		soundEngineOnExt[]=
		{
			"",
			1,
			1
		};
		soundEngineOffExt[]=
		{
			"",
			1,
			1
		};
		soundGearUp[]=
		{
			"",
			1,
			1
		};
		soundGearDown[]=
		{
			"",
			1,
			1
		};
		soundFlapsUp[]=
		{
			"",
			1,
			1
		};
		soundFlapsDown[]=
		{
			"",
			1,
			1
		};
		soundCrashes[]=
		{
			"soundCrash",
			1
		};
		soundLandCrashes[]=
		{
			"soundLandCrash",
			1
		};
		soundWaterCrashes[]=
		{
			"soundWaterCrash",
			1
		};
		emptySound[]=
		{
			"",
			0,
			1
		};
		soundWoodCrash[]=
		{
			"emptySound",
			0
		};
		soundBushCrash[]=
		{
			"emptySound",
			0
		};
		soundBuildingCrash[]=
		{
			"emptySound",
			0
		};
		soundArmorCrash[]=
		{
			"emptySound",
			0
		};
		soundLocked[]=
		{
			"",
			1,
			1
		};
		soundIncommingMissile[]=
		{
			"",
			1,
			1
		};
		soundDammage[]=
		{
			"",
			1,
			1
		};
		weapons[]={};
		magazines[]={};
		type=1;
		threat[]={0.69999999,0.5,0.30000001};
		typicalCargo[]={};
		class Reflectors
		{
		};
		aggregateReflectors[]={};
		getInAction="";
		getOutAction="";
		driverAction="";
		driverInAction="";
		cargoGetInAction[]={};
		cargoGetOutAction[]={};
		cargoAction[]={};
		cargoIsCoDriver[]={0};
		driverCompartments="Compartment1";
		cargoCompartments[]=
		{
			"Compartment1"
		};
		driverOpticsModel="";
		driverOpticsEffect[]={};
		driverOpticsColor[]={1,1,1,1};
		hideProxyInCombat=0;
		forceHideDriver=0;
		canHideDriver=-1;
		castDriverShadow=0;
		castCargoShadow=0;
		viewDriverShadow=1;
		viewDriverShadowDiff=1;
		viewDriverShadowAmb=1;
		viewCargoShadow=1;
		viewCargoShadowDiff=1;
		viewCargoShadowAmb=1;
		ejectDeadDriver=0;
		ejectDeadCargo=0;
		crew="Civilian";
		hiddenSelections[]={};
		hiddenSelectionsTextures[]={};
		hiddenSelectionsMaterials[]={};
		hiddenUnderwaterSelections[]={};
		shownUnderWaterSelections[]={};
		hiddenUnderwaterSelectionsTextures[]={};
		class FxExplo
		{
			access=1;
		};
		class AnimationSources
		{
		};
		selectionFireAnim="";
		class GunFire: WeaponFireGun
		{
		};
		class GunClouds: WeaponCloudsGun
		{
		};
		class MGunClouds: WeaponCloudsMGun
		{
		};
		class Damage
		{
			tex[]={};
			mat[]={};
		};
		selectionDamage="zbytek";
		HeadAimDown=0;
		class DestructionEffects
		{
			class Light1
			{
				simulation="light";
				type="ObjectDestructionLight";
				position="destructionEffect1";
				intensity=1;
				interval=1;
				lifeTime=1;
			};
			class Smoke1
			{
				simulation="particles";
				type="ObjectDestructionSmoke";
				position="destructionEffect1";
				intensity=1;
				interval=1;
				lifeTime=1;
			};
			class Fire1
			{
				simulation="particles";
				type="ObjectDestructionFire";
				position="destructionEffect1";
				intensity=1;
				interval=1;
				lifeTime=1;
			};
			class Sparks1
			{
				simulation="particles";
				type="ObjectDestructionSparks";
				position="destructionEffect1";
				intensity=1;
				interval=1;
				lifeTime=1;
			};
			class Sound
			{
				simulation="sound";
				type="";
				position="destructionEffect1";
				intensity=1;
				interval=1;
				lifeTime=1;
			};
		};
		cargoCanEject=1;
		driverCanEject=1;
		fireResistance=10;
		airCapacity=10;
		waterResistance=10;
		waterDamageEngine=0.2;
		maxFordingDepth=1;
		impactEffectsSea="ImpactEffectsSea";
		damageTexDelay=0;
		coefInside=2;
		coefInsideHeur=2;
		coefSpeedInside=2;
		windSockExist=0;
		slingLoadCargoMemoryPoints[]={};
		slingLoadCargoMemoryPointsDir[]={};
		numberPhysicalWheels=0;
		damageHalf[]={};
		damageFull[]={};
		class camShakeGForce
		{
			power=1;
			frequency=20;
			distance=0;
			minSpeed=1;
			duration=3;
		};
		minGForce=0.2;
		maxGForce=2;
		gForceShakeAttenuation=0.5;
		class camShakeDamage
		{
			power=0.5;
			frequency=60;
			distance=-1;
			minSpeed=1;
			attenuation=0.5;
			duration=3;
		};
		weaponsGroup1="1 + 2";
		weaponsGroup2=4;
		weaponsGroup3="8 + 16 + 32";
		weaponsGroup4="64 + 128";
	};
	class Logic: All
	{
		displayName="$STR_DN_LOGIC";
		nameSound="unknown";
		scope=2;
		vehicleClass="Objects";
		simulation="invisible";
		side=7;
		icon="#(argb,8,8,3)color(1,1,1,1)";
		model="\core\default\default.p3d";
		picture="#(argb,8,8,3)color(1,1,1,1)";
		fsmFormation="";
		fsmDanger="";
	};
	class AllVehicles: All
	{
		icon="iconVehicle";
		nameSound="unknown";
		class SquadTitles
		{
			name="clan_sign";
			color[]={0,0,0,0.75};
		};
		memoryPointDriverOptics[]=
		{
			"driverview",
			"pilot"
		};
		memoryPointsGetInDriver="pos driver";
		memoryPointsGetInDriverDir="pos driver dir";
		memoryPointsGetInCargo="pos cargo";
		memoryPointsGetInCargoDir="pos cargo dir";
		memoryPointsGetInCoDriver="pos codriver";
		memoryPointsGetInCoDriverDir="pos codriver dir";
		memoryPointsGetInDriverPrecise="pos driver";
		memoryPointsGetInCargoPrecise[]=
		{
			"pos cargo"
		};
		memoryPointsLeftWaterEffect="waterEffectL";
		memoryPointsRightWaterEffect="waterEffectR";
		memoryPointTaskMarker="";
		memoryPointTaskMarkerOffset[]={0,0,0};
		selectionClan="clan";
		selectionDashboard="podsvit pristroju";
		selectionShowDamage="poskozeni";
		selectionBackLights="zadni svetlo";
		class NewTurret
		{
			body="mainTurret";
			gun="mainGun";
			animationSourceBody="mainTurret";
			animationSourceGun="mainGun";
			animationSourceHatch="hatchGunner";
			animationSourceCamElev="camElev";
			proxyType="CPGunner";
			proxyIndex=1;
			gunnerName="$STR_POSITION_GUNNER";
			gunnerType="";
			primaryGunner=1;
			primaryObserver=0;
			weapons[]={};
			magazines[]={};
			soundServo[]=
			{
				"",
				0.0031622774,
				1
			};
			soundElevation[]=
			{
				"",
				1,
				1
			};
			gunBeg="";
			gunEnd="";
			minElev=-4;
			maxElev=20;
			initElev=0;
			minTurn=-360;
			maxTurn=360;
			initTurn=0;
			minOutElev=-4;
			maxOutElev=20;
			initOutElev=0;
			minOutTurn=-60;
			maxOutTurn=60;
			initOutTurn=0;
			maxHorizontalRotSpeed=1.2;
			maxVerticalRotSpeed=1.2;
			stabilizedInAxes=3;
			primary=1;
			hasGunner=1;
			commanding=1;
			gunnerGetInAction="";
			gunnerGetOutAction="";
			gunnerAction="";
			gunnerInAction="";
			turretCanSee=0;
			showCrewAim=7;
			canUseScanners=1;
			class ViewGunner: ViewOptics
			{
				initAngleX=5;
				minAngleX=-75;
				maxAngleX=85;
				initAngleY=0;
				minAngleY=-150;
				maxAngleY=150;
				minFov=0.25;
				maxFov=1.25;
				initFov=0.75;
				minMoveX=0;
				maxMoveX=0;
				minMoveY=0;
				maxMoveY=0;
				minMoveZ=0;
				maxMoveZ=0;
				continuous=0;
			};
			class TurretSpec
			{
				showHeadPhones=0;
			};
			gunnerOpticsModel="";
			gunnerOpticsColor[]={0,0,0,1};
			memoryPointGunnerOptics="";
			gunnerForceOptics=1;
			gunnerOpticsShowCursor=0;
			turrentInfoType="";
			gunnerOutOpticsModel="";
			gunnerOutOpticsColor[]={0,0,0,1};
			gunnerOpticsEffect[]={};
			gunnerOutOpticsEffect[]={};
			memoryPointGunnerOutOptics="";
			gunnerOutForceOptics=0;
			gunnerOutOpticsShowCursor=0;
			gunnerFireAlsoInInternalCamera=1;
			gunnerOutFireAlsoInInternalCamera=1;
			gunnerUsesPilotView=0;
			castGunnerShadow=0;
			viewGunnerShadow=1;
			viewGunnerShadowDiff=1;
			viewGunnerShadowAmb=1;
			ejectDeadGunner=0;
			hideWeaponsGunner=1;
			canHideGunner=-1;
			forceHideGunner=0;
			outGunnerMayFire=0;
			inGunnerMayFire=1;
			showHMD=0;
			viewGunnerInExternal=0;
			lockWhenDriverOut=0;
			lockWhenVehicleSpeed=-1;
			gunnerCompartments="Compartment1";
			LODTurnedIn=-1;
			LODTurnedOut=-1;
			startEngine=1;
			memoryPointsGetInGunner="";
			memoryPointsGetInGunnerDir="";
			memoryPointsGetInGunnerPrecise="";
			memoryPointGun="";
			selectionFireAnim="";
			missileBeg="spice rakety";
			missileEnd="konec rakety";
			armorLights=0.40000001;
			class Reflectors
			{
			};
			aggregateReflectors[]={};
			class GunFire: WeaponFireGun
			{
			};
			class GunClouds: WeaponCloudsGun
			{
			};
			class MGunClouds: WeaponCloudsMGun
			{
			};
			class HitPoints
			{
				class HitTurret
				{
					armor=0.80000001;
					material=51;
					name="turret";
					visual="turret";
					passThrough=1;
					explosionShielding=1;
				};
				class HitGun
				{
					armor=0.60000002;
					material=52;
					name="gun";
					visual="gun";
					passThrough=1;
					explosionShielding=1;
				};
			};
			class Turrets
			{
			};
			class ViewOptics
			{
				initAngleX=0;
				minAngleX=-30;
				maxAngleX=30;
				initAngleY=0;
				minAngleY=-100;
				maxAngleY=100;
				initFov=0.30000001;
				minFov=0.07;
				maxFov=0.34999999;
				minMoveX=0;
				maxMoveX=0;
				minMoveY=0;
				maxMoveY=0;
				minMoveZ=0;
				maxMoveZ=0;
			};
			forceNVG=0;
			isCopilot=0;
			canEject=1;
			gunnerLeftHandAnimName="";
			gunnerRightHandAnimName="";
			gunnerLeftLegAnimName="";
			gunnerRightLegAnimName="";
			gunnerDoor="";
			preciseGetInOut=0;
			turretFollowFreeLook=0;
			allowTabLock=1;
			showAllTargets=0;
			dontCreateAI=0;
			disableSoundAttenuation=0;
			slingLoadOperator=0;
			playerPosition=0;
			allowLauncherIn=0;
			allowLauncherOut=0;
			class TurnIn
			{
				turnOffset=0;
			};
			class TurnOut: TurnIn
			{
			};
		};
		class ViewPilot
		{
			initAngleX=5;
			minAngleX=-85;
			maxAngleX=85;
			initAngleY=0;
			minAngleY=-150;
			maxAngleY=150;
			minFov=0.25;
			maxFov=1.25;
			initFov=0.75;
			minMoveX=0;
			maxMoveX=0;
			minMoveY=0;
			maxMoveY=0;
			minMoveZ=0;
			maxMoveZ=0;
		};
		class ViewCargo
		{
			initAngleX=5;
			minAngleX=-75;
			maxAngleX=85;
			initAngleY=0;
			minAngleY=-150;
			maxAngleY=150;
			minFov=0.25;
			maxFov=1.25;
			initFov=0.75;
			minMoveX=0;
			maxMoveX=0;
			minMoveY=0;
			maxMoveY=0;
			minMoveZ=0;
			maxMoveZ=0;
		};
		class ViewOptics
		{
			initAngleX=0;
			minAngleX=-30;
			maxAngleX=30;
			initAngleY=0;
			minAngleY=-100;
			maxAngleY=100;
			initFov=0.69999999;
			minFov=0.41999999;
			maxFov=0.85000002;
			minMoveX=0;
			maxMoveX=0;
			minMoveY=0;
			maxMoveY=0;
			minMoveZ=0;
			maxMoveZ=0;
		};
		class PilotSpec
		{
			showHeadPhones=0;
		};
		class CargoSpec
		{
			class Cargo1
			{
				showHeadPhones=0;
			};
		};
		class MFD
		{
		};
		class Sounds
		{
			class Engine
			{
				sound="soundEngine";
				frequency="rpm";
				volume="rpm + speed";
			};
			class Movement
			{
				sound="soundEnviron";
				frequency="speed";
				volume="speed";
			};
		};
		class SoundEvents
		{
		};
		tracksSpeed=0;
		selectionLeftOffset="";
		selectionRightOffset="";
		class RenderTargets
		{
		};
		cargoProxyIndexes[]={};
		driverLeftHandAnimName="";
		driverRightHandAnimName="";
		driverLeftLegAnimName="";
		driverRightLegAnimName="";
		driverDoor="";
		cargoDoors[]={};
		hasTerminal=0;
		getInOutOnProxy=0;
		preciseGetInOut=0;
		cargoPreciseGetInOut[]={0};
		availableForSupportTypes[]={};
		waterPPInVehicle=1;
	};
	class Land: AllVehicles
	{
		displayName="$STR_DN_VEHICLE";
		nameSound="unknown";
		accuracy=0.00050000002;
		armor=30;
		cost=100000;
		fuelCapacity=0;
		weapons[]=
		{
			"FakeWeapon"
		};
		magazines[]=
		{
			"FakeWeapon"
		};
		type=1;
		threat[]={0.80000001,0.80000001,0.30000001};
		wheelDamageThreshold=0.2;
		wheelDestroyThreshold=0.99000001;
		wheelDamageRadiusCoef=0.89999998;
		wheelDestroyRadiusCoef=0.40000001;
	};
	class LandVehicle: Land
	{
		displayName="$STR_DN_VEHICLE";
		accuracy=0.02;
		cost=500000;
		class Components
		{
			class TransportCountermeasuresComponent
			{
			};
		};
		selectionBrakeLights="brzdove svetlo";
		memoryPointMissile[]=
		{
			"spice rakety",
			"usti hlavne"
		};
		memoryPointMissileDir[]=
		{
			"konec rakety",
			"konec hlavne"
		};
		class Exhausts
		{
			class Exhaust1
			{
				position="exhaust";
				direction="exhaust_dir";
				effect="ExhaustsEffect";
			};
		};
		engineStartSpeed=1.5;
		leftDustEffect="LDustEffects";
		rightDustEffect="RDustEffects";
		leftWaterEffect="LWaterEffects";
		rightWaterEffect="RWaterEffects";
		leftFastWaterEffect="LWaterEffects";
		rightFastWaterEffect="RWaterEffects";
		class Reflectors
		{
			class Left
			{
				color[]={0.89999998,0.80000001,0.80000001,1};
				ambient[]={0.1,0.1,0.1,1};
				position="L svetlo";
				direction="konec L svetla";
				hitpoint="L svetlo";
				selection="L svetlo";
				size=0.5;
				brightness=0.5;
			};
			class Right
			{
				color[]={0.89999998,0.80000001,0.80000001,1};
				ambient[]={0.1,0.1,0.1,1};
				position="P svetlo";
				direction="konec P svetla";
				hitpoint="P svetlo";
				selection="P svetlo";
				size=0.5;
				brightness=0.5;
			};
		};
		aggregateReflectors[]=
		{
			
			{
				"Left",
				"Right"
			}
		};
		tracksSpeed=0;
		selectionLeftOffset="PasOffsetL";
		selectionRightOffset="PasOffsetP";
		explosionEffect="FuelExplosion";
	};
	class Car: LandVehicle
	{
		class Components: Components
		{
			class AICarSteeringComponent
			{
				steeringPIDWeights[]={2.9000001,0.1,0.2};
				speedPIDWeights[]={0.69999999,0.2,0};
				convoyPIDWeights[]={1,0.0099999998,0.0099999998};
				doRemapSpeed=1;
				remapSpeedRange[]={30,70};
				remapSpeedScalar[]={1,0.34999999};
				doPredictForward=1;
				predictForwardRange[]={1,20};
				steerAheadSaturation[]={0.0099999998,0.40000001};
				speedPredictionMethod=2;
				wheelAngleCoef=0.69999999;
				forwardAngleCoef=0.69999999;
				steeringAngleCoef=1;
				differenceAngleCoef=0.40000001;
				stuckMaxTime=3;
				allowOvertaking=1;
				allowDrifting=0;
				allowCollisionAvoidance=1;
				maxWheelAngleDiff=0.26159999;
				minSpeedToKeep=0.1;
				commandTurnFactor=1;
			};
		};
		mapSize=5;
		fuelExplosionPower=100;
		icon="iconCar";
		displayName="$STR_DN_CAR";
		nameSound="veh_car";
		accuracy=0.2;
		cost=40000;
		fuelCapacity=100;
		unloadInCombat=1;
		canFloat=0;
		collisionEffect="";
		limitedSpeedCoef=0.5;
		armor=20;
		armorStructural=4;
		driverCanSee="4+8+2+32";
		gunnerCanSee="4+2+8+32";
		holdOffroadFormation=0;
		hullDamageCauseExplosion=1;
		class PlateInfos
		{
			name="spz";
			color[]={0,0,0,0.75};
		};
		class HitPoints
		{
			class HitEngine
			{
				armor=1.2;
				material=60;
				name="engine";
				visual="engine";
				passThrough=1;
				explosionShielding=1;
			};
			class HitRGlass
			{
				armor=0.5;
				material=-1;
				name="sklo predni P";
				convexComponent="sklo predni P";
				visual="";
				passThrough=1;
				explosionShielding=1;
			};
			class HitLGlass
			{
				armor=0.5;
				material=-1;
				name="sklo predni L";
				convexComponent="sklo predni L";
				visual="";
				passThrough=1;
				explosionShielding=1;
			};
			class HitBody
			{
				armor=0.40000001;
				material=50;
				name="karoserie";
				visual="karoserie";
				passThrough=1;
				explosionShielding=1;
			};
			class HitFuel
			{
				armor=1.4;
				material=-1;
				name="palivo";
				visual="palivo";
				passThrough=1;
				explosionShielding=1;
			};
			class HitLFWheel
			{
				armor=0.050000001;
				material=-1;
				name="Levy predni tlumic";
				visual="Levy predni";
				passThrough=1;
				explosionShielding=1;
			};
			class HitRFWheel
			{
				armor=0.050000001;
				material=-1;
				name="Pravy predni tlumic";
				visual="Pravy predni";
				passThrough=1;
				explosionShielding=1;
			};
			class HitLF2Wheel
			{
				armor=0.050000001;
				material=-1;
				name="Levy dalsi tlumic";
				visual="Levy dalsi";
				passThrough=1;
				explosionShielding=1;
			};
			class HitRF2Wheel
			{
				armor=0.050000001;
				material=-1;
				name="Pravy dalsi tlumic";
				visual="Pravy dalsi";
				passThrough=1;
				explosionShielding=1;
			};
			class HitLMWheel
			{
				armor=0.050000001;
				material=-1;
				name="Levy prostredni tlumic";
				visual="Levy prostredni";
				passThrough=1;
				explosionShielding=1;
			};
			class HitRMWheel
			{
				armor=0.050000001;
				material=-1;
				name="Pravy prostredni tlumic";
				visual="Pravy prostredni";
				passThrough=1;
				explosionShielding=1;
			};
			class HitLBWheel
			{
				armor=0.050000001;
				material=-1;
				name="Levy zadni tlumic";
				visual="Levy zadni";
				passThrough=1;
				explosionShielding=1;
			};
			class HitRBWheel
			{
				armor=0.050000001;
				material=-1;
				name="Pravy zadni tlumic";
				visual="Pravy zadni";
				passThrough=1;
				explosionShielding=1;
			};
		};
		selectionFireAnim="zasleh";
		alphaTracks=0.2;
		memoryPointTrackFLL="Stopa PLL";
		memoryPointTrackFLR="Stopa PLP";
		memoryPointTrackBLL="Stopa ZLL";
		memoryPointTrackBLR="Stopa ZLP";
		memoryPointTrackFRL="Stopa PPL";
		memoryPointTrackFRR="Stopa PPP";
		memoryPointTrackBRL="Stopa ZPL";
		memoryPointTrackBRR="Stopa ZPP";
		memoryPointCirculumReference="circulumReference";
		gearBox[]={-8,0,10,6.1500001,4.4400001,3.3299999};
		Scudeffect="ScudEffect";
		armorLights=0.40000001;
		vehicleClass="Car";
		wheelCircumference=2.513;
		turnCoef=2;
		terrainCoef=2;
		waterSpeedFactor=0.2;
		maxSpeed=100;
		preferRoads=1;
		unitInfoType="RscUnitInfo";
		hideUnitInfo=1;
		formationX=20;
		formationZ=20;
		precision=10;
		brakeDistance=7;
		steerAheadSimul=0.40000001;
		steerAheadPlan=0.2;
		predictTurnSimul=0.40000001;
		predictTurnPlan=0.80000001;
		sensitivity=3;
		soundGear[]=
		{
			"",
			0.00017782791,
			1
		};
		extCameraPosition[]={0.5,2,-10};
		class ViewPilot: ViewPilot
		{
			minFov=0.25;
			maxFov=1.25;
			initFov=0.75;
			initAngleX=15;
			minAngleX=-85;
			maxAngleX=85;
			initAngleY=0;
			minAngleY=-150;
			maxAngleY=150;
		};
		simulation="car";
		weapons[]={};
		magazines[]={};
		type=0;
		threat[]={0.5,0.5,0.5};
		typicalCargo[]=
		{
			"Soldier"
		};
		audible=3;
		occludeSoundsWhenIn=0.099999994;
		obstructSoundsWhenIn=0.31622776;
		getInAction="";
		getOutAction="";
		scudModel="";
		damperSize=0.1;
		damperForce=1;
		damperDamping=1;
		inputTurnCurve[]=
		{
			
			{
				0,
				{0,0,1,1}
			},
			
			{
				30,
				{0,0,0.2,0.0080000004,0.40000001,0.032000002,0.60000002,0.21600001,0.80000001,0.51200002,1,1}
			}
		};
		transportMaxMagazines=50;
		transportMaxWeapons=10;
		enableGPS=0;
		soundEngine[]=
		{
			"",
			1.7782794,
			0.89999998
		};
		soundEnviron[]=
		{
			"",
			0.56234133,
			1
		};
		class Sounds: Sounds
		{
			class Engine: Engine
			{
				sound="soundEngine";
				frequency="(randomizer*0.05+0.95)*rpm*1.2";
				volume="thrust*0.5+0.5";
			};
			class Movement: Movement
			{
				sound="soundEnviron";
				frequency="1";
				volume="speed*0.03334";
			};
		};
		class PlayerSteeringCoefficients
		{
			turnIncreaseConst=0.30000001;
			turnIncreaseLinear=1;
			turnIncreaseTime=1;
			turnDecreaseConst=5;
			turnDecreaseLinear=3;
			turnDecreaseTime=0;
			maxTurnHundred=0.69999999;
		};
		numberPhysicalWheels=4;
	};
	class Motorcycle: LandVehicle
	{
		simulation="motorcycle";
		displayName="$STR_DN_MOTORCYCLE";
		accuracy=0.2;
		mapSize=5;
		icon="iconMotorcycle";
		nameSound="veh_car";
		isBicycle=0;
		unloadInCombat=1;
		castDriverShadow=1;
		castCargoShadow=1;
		ejectDeadDriver=1;
		ejectDeadCargo=1;
		armor=10;
		armorStructural=4;
		cost=500;
		fuelCapacity=50;
		damperSize=0.2;
		damperForce=1;
		damperDamping=3;
		transportSoldier=0;
		typicalCargo[]={};
		occludeSoundsWhenIn=1;
		obstructSoundsWhenIn=1;
		driverCanSee="8+2+32";
		gunnerCanSee="2+8+32";
		class PlateInfos
		{
			name="spz";
			color[]={0,0,0,0.75};
		};
		class HitPoints
		{
			class HitEngine
			{
				armor=1.2;
				material=60;
				name="engine";
				visual="engine";
				passThrough=1;
				explosionShielding=1;
			};
			class HitRGlass
			{
				armor=0.5;
				material=-1;
				name="sklo predni P";
				convexComponent="sklo predni P";
				visual="";
				passThrough=1;
				explosionShielding=1;
			};
			class HitLGlass
			{
				armor=0.5;
				material=-1;
				name="sklo predni L";
				convexComponent="sklo predni L";
				visual="";
				passThrough=1;
				explosionShielding=1;
			};
			class HitBody
			{
				armor=0.40000001;
				material=-1;
				name="karoserie";
				visual="karoserie";
				passThrough=1;
				explosionShielding=1;
			};
			class HitFuel
			{
				armor=1.4;
				material=-1;
				name="palivo";
				visual="palivo";
				passThrough=1;
				explosionShielding=1;
			};
			class HitFWheel
			{
				armor=0.050000001;
				material=-1;
				name="Pravy predni tlumic";
				visual="Pravy predni";
				passThrough=1;
				explosionShielding=1;
			};
			class HitBWheel
			{
				armor=0.050000001;
				material=-1;
				name="Pravy zadni tlumic";
				visual="Pravy zadni";
				passThrough=1;
				explosionShielding=1;
			};
		};
		selectionFireAnim="zasleh";
		alphaTracks=0.1;
		textureTrackWheel=1;
		memoryPointTrack1L="Stopa PPL";
		memoryPointTrack1R="Stopa PPP";
		memoryPointTrack2L="Stopa ZPL";
		memoryPointTrack2R="Stopa ZPP";
		vehicleClass="Car";
		wheelCircumference=2.513;
		turnCoef=1;
		terrainCoef=3;
		maxSpeed=120;
		gearBox[]={-8,0,10,6.1500001,4.4400001,3.3299999};
		preferRoads=1;
		unitInfoType="RscUnitInfo";
		hideUnitInfo=1;
		formationX=20;
		formationZ=20;
		precision=10;
		brakeDistance=16.5;
		steerAheadSimul=0.5;
		steerAheadPlan=0.34999999;
		predictTurnSimul=1.2;
		predictTurnPlan=1.2;
		sensitivity=3;
		soundGear[]=
		{
			"",
			9.9999979e-006,
			1
		};
		extCameraPosition[]={0,1,-10};
		class ViewPilot: ViewPilot
		{
			minFov=0.25;
			maxFov=1.25;
			initFov=0.75;
			initAngleX=15;
			minAngleX=-85;
			maxAngleX=85;
			initAngleY=0;
			minAngleY=-150;
			maxAngleY=150;
		};
		class Reflectors
		{
			class Right
			{
				color[]={0.89999998,0.80000001,0.80000001,1};
				ambient[]={0.1,0.1,0.1,1};
				position="P svetlo";
				direction="konec P svetla";
				hitpoint="P svetlo";
				selection="P svetlo";
				size=0.5;
				brightness=0.5;
			};
		};
		weapons[]={};
		magazines[]={};
		type=0;
		threat[]={0.5,0.5,0.5};
		audible=3;
		getInAction="";
		getOutAction="";
		transportMaxMagazines=5;
		transportMaxWeapons=0;
		class AnimationSources
		{
			class FrontDamper
			{
				source="damper";
				selection="pravy predni tlumic nerot";
			};
			class BackDamper
			{
				source="damper";
				selection="pravy zadni tlumic";
			};
		};
		numberPhysicalWheels=2;
	};
	class Bicycle: Motorcycle
	{
		canFloat=0;
		isBicycle=1;
		hideWeaponsDriver=0;
		formationX=5;
		formationZ=5;
		precision=5;
		brakeDistance=4;
		steerAheadSimul=0.5;
		steerAheadPlan=0.69999999;
		predictTurnSimul=1.2;
		predictTurnPlan=1.2;
	};
	class Tank: LandVehicle
	{
		vehicleClass="Armored";
		icon="iconTank";
		displayName="$STR_DN_TANK";
		nameSound="veh_tank";
		accuracy=0.12;
		class Components: Components
		{
			class AITankSteeringComponent
			{
				steeringPIDWeights[]={2.5,0.30000001,0};
				speedPIDWeights[]={1,0,0};
				convoyPIDWeights[]={1,0,0};
				doRemapSpeed=0;
				doPredictForward=1;
				predictForwardMaxSpeed=15;
				predictForwardRange[]={1,20};
				speedPredictionMethod=3;
				wheelAngleCoef=0.30000001;
				stuckMaxTime=30;
				maxWheelAngleDiff=0.26159999;
				minSpeedToKeep=0.1;
				allowTurnAroundInPoint=1;
			};
		};
		getInRadius=3.5;
		fuelCapacity=700;
		irScanRangeMin=500;
		irScanRangeMax=4000;
		irScanToEyeFactor=1;
		armor=400;
		armorStructural=2;
		crewVulnerable=0;
		class HitPoints
		{
			class HitEngine
			{
				armor=0.80000001;
				material=60;
				name="engine";
				visual="engine";
				passThrough=1;
				explosionShielding=1;
			};
			class HitHull
			{
				armor=1;
				material=50;
				name="hull";
				visual="hull";
				passThrough=1;
				explosionShielding=1;
			};
			class HitLTrack
			{
				armor=0.60000002;
				material=53;
				name="pasL";
				visual="pasL";
				passThrough=1;
				explosionShielding=1;
			};
			class HitRTrack
			{
				armor=0.60000002;
				material=54;
				name="pasP";
				visual="pasP";
				passThrough=1;
				explosionShielding=1;
			};
		};
		hullDamageCauseExplosion=1;
		selectionFireAnim="zasleh";
		memoryPointCargoLight="cargo light";
		bounding="usti hlavne";
		fireDustEffect="FDustEffects";
		gearBox[]={-7,0,11,8,5.6999998,4.1999998};
		alphaTracks=0.69999999;
		textureTrackWheel=0;
		memoryPointTrack1L="Stopa LL";
		memoryPointTrack1R="Stopa LR";
		memoryPointTrack2L="Stopa RL";
		memoryPointTrack2R="Stopa RR";
		extCameraPosition[]={0,1.5,-9};
		class ViewPilot: ViewPilot
		{
			initAngleX=7;
			minAngleX=-15;
			maxAngleX=25;
			initAngleY=0;
			minAngleY=-90;
			maxAngleY=90;
		};
		class ViewOptics: ViewOptics
		{
			initFov=0.30000001;
			minFov=0.07;
			maxFov=0.34999999;
		};
		cost=1000000;
		steerAheadSimul=0.5;
		steerAheadPlan=0.40000001;
		predictTurnSimul=1.2;
		predictTurnPlan=1;
		soundGear[]=
		{
			"",
			0.00031622773,
			1
		};
		occludeSoundsWhenIn=0.0099999998;
		obstructSoundsWhenIn=0.17782794;
		outsideSoundFilter=1;
		nightVision=0;
		driverAction="";
		driverInAction="";
		simulation="tank";
		formationX=20;
		formationZ=30;
		precision=5;
		brakeDistance=7;
		maxSpeed=80;
		tracksSpeed=1;
		turnCoef=1;
		class Turrets
		{
			class MainTurret: NewTurret
			{
				commanding=1;
				class Turrets
				{
					class CommanderOptics: NewTurret
					{
						gunnerName="$STR_POSITION_COMMANDER";
						primaryGunner=0;
						primaryObserver=1;
						body="obsTurret";
						gun="obsGun";
						animationSourceBody="obsTurret";
						animationSourceGun="obsGun";
						animationSourceHatch="hatchCommander";
						animationSourceCamElev="camElev";
						commanding=2;
					};
				};
			};
		};
		canFloat=0;
		weapons[]=
		{
			"FakeWeapon"
		};
		magazines[]=
		{
			"FakeWeapon"
		};
		type=1;
		threat[]={0.69999999,1,0.30000001};
		camouflage=8;
		audible=18;
		sensitivityEar="0.0075 /3";
		hideProxyInCombat=1;
		driverOpticsModel="optika_tank_driver";
		driverOpticsColor[]={1,1,1,1};
		class CargoLight
		{
			color[]={0,0,0,0};
			ambient[]={0.60000002,0,0.15000001,1};
			brightness=0.0070000002;
		};
		transportMaxMagazines=100;
		transportMaxWeapons=10;
		enableGPS=1;
		tankTurnForce=500000;
		class Sounds: Sounds
		{
			class Engine: Engine
			{
				sound="soundEngine";
				frequency="(1-(randomizer*0.05))*rpm*1.2";
				volume="thrust*0.5+0.5";
			};
			class Movement: Movement
			{
				sound="soundEnviron";
				frequency="(speed+angVelocity)*0.03334";
				volume="((speed+angVelocity)*0.03334)+(1-((speed+angVelocity)*0.03334))*0.3";
			};
		};
		numberPhysicalWheels=16;
	};
	class APC: Tank
	{
		icon="iconAPC";
		vehicleClass="Armored";
		displayName="$STR_DN_APC";
		nameSound="veh_apc";
		accuracy=0.12;
		fuelCapacity=700;
		armor=200;
		cost=1000000;
		soundGear[]=
		{
			"",
			0.00099999993,
			1
		};
		simulation="tank";
		maxSpeed=60;
		class Turrets: Turrets
		{
			class MainTurret: MainTurret
			{
				minElev=-4.5;
				maxElev=20;
			};
		};
		canFloat=0;
		weapons[]=
		{
			"FakeWeapon"
		};
		magazines[]=
		{
			"FakeWeapon"
		};
		type=1;
		threat[]={0.80000001,1,0.30000001};
	};
	class Man: Land
	{
		mapSize=0.5;
		vehicleClass="Men";
		icon="iconMan";
		autocenter=0;
		isMan=1;
		breathingBubblesPoint="";
		breathingBubblesPointDir="";
		breathingBubblesEffect="ScubaEffect";
		breathingBubblesInteval=3;
		impactEffectsBlood="ImpactEffectsBlood";
		impactEffectsNoBlood="ImpactPlastic";
		impactDamageMultiplier=3;
		displayName="$STR_DN_MAN";
		nameSound="veh_man";
		genericNames="EnglishMen";
		extCameraPosition[]={0,1,-3.5};
		aiBrainType="DefaultSoldierBrain";
		accuracy=0.25;
		audible=0.050000001;
		camouflage=1;
		sensitivity=3;
		sensitivityEar=0.13;
		formationX=5;
		formationZ=5;
		precision=1;
		brakeDistance=1;
		steerAheadSimul=0.1;
		steerAheadPlan=0.1;
		steerAheadSimulDiving=0.5;
		steerAheadPlanDiving=0.5;
		maxSpeed=24;
		maxTurnAngularVelocity=3;
		costTurnCoef=0.025;
		lyingLimitSpeedHiding=0.80000001;
		crouchProbabilityHiding=0.80000001;
		lyingLimitSpeedCombat=1.8;
		crouchProbabilityCombat=0.40000001;
		crouchProbabilityEngage=0.75;
		lyingLimitSpeedStealth=2;
		irTarget=0;
		canHideBodies=0;
		canDeactivateMines=0;
		useInternalLODInVehicles=1;
		unitInfoType="RscUnitInfoSoldier";
		hideUnitInfo=1;
		armor=3;
		armorStructural=2;
		class HitPoints
		{
			class HitHead
			{
				armor=0.69999999;
				material=-1;
				name="hlava_hit";
				visual="";
				passThrough=1;
				explosionShielding=1;
			};
			class HitBody
			{
				armor=0.80000001;
				material=-1;
				name="telo";
				visual="";
				passThrough=1;
				explosionShielding=1;
			};
			class HitHands
			{
				armor=0.5;
				material=-1;
				name="ruce";
				visual="";
				passThrough=1;
				explosionShielding=1;
			};
			class HitLegs
			{
				armor=0.5;
				material=-1;
				name="nohy";
				visual="";
				passThrough=1;
				explosionShielding=1;
			};
		};
		oxygenCapacity=180;
		cost=100000;
		simulation="soldier";
		class TalkTopics
		{
		};
		class Wounds
		{
		};
		minGunElev=-60;
		maxGunElev=60;
		minGunTurn=-5;
		maxGunTurn=5;
		minGunTurnAI=-30;
		maxGunTurnAI=30;
		commanderCanSee="31+32";
		respawnWeapons[]={};
		respawnMagazines[]={};
		respawnItems[]={};
		respawnLinkedItems[]={};
		grenadeThrowDir[]={0,0,1};
		class HeadLimits: HeadLimits
		{
			initAngleX=5;
			minAngleX=-40;
			maxAngleX=40;
			initAngleY=0;
			minAngleY=-90;
			maxAngleY=90;
		};
		class ViewPilot: ViewPilot
		{
			minFov=0.25;
			maxFov=1.25;
			initFov=0.75;
			initAngleX=8;
			minAngleX=-85;
			maxAngleX=85;
			initAngleY=0;
			minAngleY=-150;
			maxAngleY=150;
		};
		microMimics="Micro";
		minHeadTurnAI=-70;
		maxHeadTurnAI=70;
		ISangleMod[]={0.0049999999,0.0099999998,0.0099999998};
		ISrecoilMod[]={0,0,2};
		ISspeedMod[]={0.00019999999,0.00019999999,0};
		ISmaxTurn=0.5;
		ISanimMod[]={0.0020000001,0.0020000001,0};
		weaponSlots="1	 + 5 * 		256	 + 	4096	 + 	2	 + 4*	16  + 12* 131072";
		weapons[]={};
		magazines[]={};
		model="";
		picture="";
		backpack="";
		canCarryBackPack=0;
		boneHead="hlava";
		boneHeadCutScene="hlava";
		identityTypes[]=
		{
			"Default"
		};
		glassesEnabled=1;
		triggerAnim="";
		selectionHeadWound="head injury";
		selectionBodyWound="body injury";
		selectionLArmWound="l arm injury";
		selectionRArmWound[]=
		{
			"r arm injury",
			"p arm injury"
		};
		selectionLLegWound="l leg injury";
		selectionRLegWound[]=
		{
			"r leg injury",
			"p leg injury"
		};
		selectionLArmWound1="l arm injury";
		selectionRArmWound1[]=
		{
			"r arm injury",
			"p arm injury"
		};
		selectionLLegWound1="l leg injury";
		selectionRLegWound1[]=
		{
			"r leg injury",
			"p leg injury"
		};
		selectionLArmWound2="l arm injury";
		selectionRArmWound2[]=
		{
			"r arm injury",
			"p arm injury"
		};
		selectionLLegWound2="l leg injury";
		selectionRLegWound2[]=
		{
			"r leg injury",
			"p leg injury"
		};
		selectionHeadHide="";
		memoryPointPilot="pilot";
		memoryPointLStep="stopaL";
		memoryPointRStep="stopaP";
		memoryPointAim="zamerny";
		memoryPointCameraTarget="zamerny";
		memoryPointAimingAxis="osa mireni";
		memoryPointLeaningAxis="osa naklaneni";
		memoryPointHeadAxis="osa otaceni";
		memoryPointWaterSurface="osa otaceni";
		memoryPointHandGrenade="granat";
		memoryPointCommonDamage="zamerny";
		selectionPersonality="osobnost";
		selectionPersonalityHL="hl";
		selectionGlasses="brejle";
		selectionLBrow="loboci";
		selectionMBrow="soboci";
		selectionRBrow="poboci";
		selectionLMouth="lkoutek";
		selectionMMouth="skoutek";
		selectionRMouth="pkoutek";
		selectionEyelid="vicka";
		selectionLip="spodni ret";
		hitSound1[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound2[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound3[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound4[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound5[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound6[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound7[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound8[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound9[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound10[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound11[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound12[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound13[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound14[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound15[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound16[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound17[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound18[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound19[]=
		{
			"",
			0.056234129,
			1
		};
		hitSound20[]=
		{
			"",
			0.056234129,
			1
		};
		hitSounds[]=
		{
			"hitSound1",
			0.050000001,
			"hitSound2",
			0.050000001,
			"hitSound3",
			0.050000001,
			"hitSound4",
			0.050000001,
			"hitSound5",
			0.050000001,
			"hitSound6",
			0.050000001,
			"hitSound7",
			0.050000001,
			"hitSound8",
			0.050000001,
			"hitSound9",
			0.050000001,
			"hitSound10",
			0.050000001,
			"hitSound11",
			0.050000001,
			"hitSound12",
			0.050000001,
			"hitSound13",
			0.050000001,
			"hitSound14",
			0.050000001,
			"hitSound15",
			0.050000001,
			"hitSound16",
			0.050000001,
			"hitSound17",
			0.050000001,
			"hitSound18",
			0.050000001,
			"hitSound19",
			0.050000001,
			"hitSound20",
			0.050000001
		};
		moves="NoDefaultMoves";
		movesFatigue="";
		gestures="";
		emptySound[]=
		{
			"",
			0,
			1
		};
		vegetationSounds[]=
		{
			"emptySound",
			0
		};
		additionalSound[]=
		{
			"",
			9.9999977e-007,
			1
		};
		class SoundEnvironExt
		{
			normalExt[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			normal[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			road[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			rock[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			water[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			gravel[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			sand[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			drygrass[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			grass[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			forest[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			mud[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			wood[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			metal[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			snow[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			hallway[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			fallbody[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			laydown[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			standup[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
			crawl[]=
			{
				
				{
					"",
					9.9999979e-006,
					1,
					0
				}
			};
		};
		class SoundEquipment
		{
			civilian[]=
			{
				
				{
					"",
					
					{
						"",
						9.9999979e-006,
						1,
						0
					}
				}
			};
			soldier[]=
			{
				
				{
					"",
					
					{
						"",
						9.9999979e-006,
						1,
						0
					}
				}
			};
		};
		class SoundGear
		{
			primary[]=
			{
				
				{
					"",
					
					{
						"",
						9.9999979e-006,
						1,
						0
					}
				}
			};
			secondary[]=
			{
				
				{
					"",
					
					{
						"",
						9.9999979e-006,
						1,
						0
					}
				}
			};
		};
		class SoundBreath
		{
			breath[]={};
		};
		class SoundDrown
		{
			breath[]={};
		};
		class SoundInjured
		{
			breath[]={};
		};
		class SoundBleeding
		{
			breath[]={};
		};
		class SoundBurning
		{
			breath[]={};
		};
		class SoundChoke
		{
			breath[]={};
		};
		class SoundRecovered
		{
			breath[]={};
		};
		class HitDamage
		{
		};
		type=0;
		threat[]={1,0.80000001,0.2};
		class Reflectors
		{
		};
		class MGunClouds: WeaponCloudsMGun
		{
		};
		class GunClouds: WeaponCloudsGun
		{
			cloudletGrowUp=0.2;
			cloudletFadeIn=0;
			cloudletFadeOut=0.40000001;
			cloudletDuration=0.2;
			cloudletAlpha=1;
			cloudletAccY=2;
			cloudletMinYSpeed=-10;
			cloudletMaxYSpeed=10;
			interval=0.02;
			size=0.30000001;
			sourceSize=0.015;
		};
		class InventorySlots
		{
		};
		fsmFormation="";
		fsmDanger="";
		enableGPS=0;
		leftArmToElbow[]={};
		leftArmFromElbow[]={};
		leftWrist="";
		leftShoulder="";
		leftHand[]={};
		leftArmPoints[]=
		{
			"",
			"",
			"",
			""
		};
		rightArmToElbow[]={};
		rightArmFromElbow[]={};
		rightWrist="";
		rightShoulder="";
		rightHand[]={};
		rightArmPoints[]=
		{
			"",
			"",
			"",
			""
		};
		leftLegToKnee[]={};
		leftLegFromKnee[]={};
		leftHeel="";
		leftHip="";
		leftFoot[]={};
		leftLegPoints[]=
		{
			"",
			"",
			"",
			""
		};
		rightLegToKnee[]={};
		rightLegFromKnee[]={};
		rightHeel="";
		rightHip="";
		rightFoot[]={};
		rightLegPoints[]=
		{
			"",
			"",
			"",
			""
		};
		weaponBone="";
		launcherBone="";
		handGunBone="";
		characterID=-1;
		primaryAmmoCoef=0.40000001;
		secondaryAmmoCoef=0.2;
		handgunAmmoCoef=0.1;
		allowedUniformSides[]={};
		allowedHeadgearSides[]={};
	};
	class Animal: Man
	{
		vehicleClass="Animals";
		simulation="animal";
		icon="iconAnimal";
		aiBrainType="DefaultAnimalBrain";
		isMan=0;
		isFish=0;
		hasGeometry=0;
		killMassLimit=200;
		killSpeedLimit=20;
		impactDamageMultiplier=3;
		displayName="$STR_DN_ANIMAL";
		nameSound="veh_animal";
		accuracy=0.050000001;
		weaponSlots=0;
		weapons[]={};
		magazines[]={};
		type=0;
		threat[]={0,0,0};
	};
	class Air: AllVehicles
	{
		icon="iconAir";
		displayName="$STR_DN_HELICOPTER";
		nameSound="veh_aircraft";
		accuracy=0.0049999999;
		formationX=50;
		formationZ=100;
		precision=100;
		brakeDistance=200;
		formationTime=10;
		class Components
		{
			class TransportCountermeasuresComponent
			{
			};
		};
		altFullForce=2000;
		altNoForce=6000;
		armor=20;
		cost=10000000;
		fuelCapacity=1000;
		maxSpeed=400;
		attenuationEffectType="";
		insideSoundCoef=0.031622775;
		outsideSoundFilter=1;
		occludeSoundsWhenIn=0.31622776;
		obstructSoundsWhenIn=0.31622776;
		weapons[]=
		{
			"FakeWeapon"
		};
		magazines[]=
		{
			"FakeWeapon"
		};
		type=2;
		irScanRangeMin=2000;
		irScanRangeMax=10000;
		irScanToEyeFactor=2;
		nightVision=0;
		audible=10;
		unitInfoType="RscUnitInfoAir";
		threat[]={0.30000001,1,0.69999999};
		driverAction="";
		driverCompartments=0;
		cargoCompartments[]={0};
		gunnerCanSee="31+32";
		driverCanSee="31+32";
		typicalCargo[]=
		{
			"Soldier"
		};
		getInRadius=5;
		transportMaxMagazines=20;
		transportMaxWeapons=3;
		enableGPS=1;
		class MarkerLights
		{
			class RedStill
			{
				name="cerveny pozicni";
				color[]={0.30000001,0.029999999,0.029999999,1};
				ambient[]={0.029999999,0.003,0.003,1};
				brightness=0.0099999998;
				blinking=0;
			};
			class GreenStill
			{
				name="zeleny pozicni";
				color[]={0.029999999,0.30000001,0.029999999,1};
				ambient[]={0.003,0.029999999,0.003,1};
				brightness=0.0099999998;
				blinking=0;
			};
			class WhiteStill
			{
				name="bily pozicni";
				color[]={0.30000001,0.30000001,0.30000001,1};
				ambient[]={0.029999999,0.029999999,0.029999999,1};
				brightness=0.0099999998;
				blinking=0;
			};
			class WhiteBlinking
			{
				name="bily pozicni blik";
				color[]={1,1,1,1};
				ambient[]={0.1,0.1,0.1,1};
				brightness=0.0099999998;
				blinking=1;
			};
			class RedBlinking
			{
				name="cerveny pozicni blik";
				color[]={0.5,0.050000001,0.050000001,1};
				ambient[]={0.050000001,0.0049999999,0.0049999999,1};
				brightness=0.0099999998;
				blinking=1;
			};
		};
	};
	class Helicopter: Air
	{
		vehicleClass="Air";
		icon="iconHelicopter";
		displayName="$STR_DN_HELICOPTER";
		nameSound="veh_helicopter";
		accuracy=0.079999998;
		simulation="helicopter";
		gearRetracting=0;
		dustEffect="HeliDust";
		waterEffect="HeliWater";
		washDownStrength=1;
		washDownDiameter=40;
		damageEffect="DamageSmokeHeli";
		gearUpTime=3.3299999;
		gearDownTime=2;
		gearMinAlt=0.5;
		class ViewPilot: ViewPilot
		{
			minFov=0.25;
			maxFov=1.25;
			initFov=0.75;
			initAngleX=10;
			minAngleX=-85;
			maxAngleX=85;
			initAngleY=0;
			minAngleY=-150;
			maxAngleY=150;
			minMoveX=-0.34999999;
			maxMoveX=0.34999999;
			minMoveY=-0.5;
			maxMoveY=0.2;
			minMoveZ=-0.30000001;
			maxMoveZ=0.5;
		};
		class CargoSpec
		{
			class Cargo1
			{
				showHeadPhones=1;
			};
			class Cargo2
			{
				showHeadPhones=0;
			};
		};
		mainRotorSpeed=1;
		backRotorSpeed=1.5;
		startDuration=20;
		mainBladeRadius=0;
		maxMainRotorDive=0;
		maxBackRotorDive=0;
		minMainRotorDive=0;
		minBackRotorDive=0;
		neutralBackRotorDive=0;
		neutralMainRotorDive=0;
		liftForceCoef=1;
		cyclicAsideForceCoef=1;
		cyclicForwardForceCoef=1;
		backRotorForceCoef=1;
		bodyFrictionCoef=1;
		selectionHRotorStill="velka vrtule staticka";
		selectionHRotorMove="velka vrtule blur";
		selectionVRotorStill="mala vrtule staticka";
		selectionVRotorMove="mala vrtule blur";
		memoryPointLMissile="L strela";
		memoryPointRMissile="P strela";
		memoryPointLRocket="L raketa";
		memoryPointRRocket="P raketa";
		memoryPointGun="";
		memoryPointPilot="pilot";
		_mainBladeCenter="rotor_center";
		selectionFireAnim="zasleh";
		class HitPoints
		{
			class HitHull
			{
				armor=0.5;
				material=50;
				name="trup";
				visual="trup";
				passThrough=1;
				explosionShielding=1;
			};
			class HitEngine
			{
				armor=0.60000002;
				material=60;
				name="motor";
				visual="motor";
				passThrough=1;
				explosionShielding=1;
			};
			class HitAvionics
			{
				armor=1.4;
				material=-1;
				name="elektronika";
				visual="elektronika";
				passThrough=1;
				explosionShielding=1;
			};
			class HitVRotor
			{
				armor=0.5;
				material=52;
				name="mala vrtule";
				visual="mala vrtule";
				passThrough=1;
				explosionShielding=1;
			};
			class HitHRotor
			{
				armor=0.69999999;
				material=51;
				name="velka vrtule";
				visual="velka vrtule";
				passThrough=1;
				explosionShielding=1;
			};
			class HitMissiles
			{
				armor=1.6;
				material=-1;
				name="munice";
				visual="";
				passThrough=1;
				explosionShielding=1;
			};
			class HitRGlass
			{
				armor=0.5;
				material=-1;
				name="sklo predni P";
				convexComponent="sklo predni P";
				visual="";
				passThrough=1;
				explosionShielding=1;
			};
			class HitLGlass
			{
				armor=0.5;
				material=-1;
				name="sklo predni L";
				convexComponent="sklo predni L";
				visual="";
				passThrough=1;
				explosionShielding=1;
			};
		};
		armorStructural=2;
		maxSpeed=300;
		enableSweep=1;
		envelope[]={0,0.2,0.89999998,2.0999999,2.5,3.3,3.5,3.5999999,3.7,3.8,3.8,3,0.89999998,0.69999999,0.5};
		unitInfoType="RscUnitInfoAir";
		minFireTime=20;
		steerAheadSimul=0.5;
		steerAheadPlan=0.69999999;
		class Turrets
		{
			class MainTurret: NewTurret
			{
				outGunnerMayFire=1;
				commanding=-1;
				startEngine=0;
				class TurretSpec: TurretSpec
				{
					showHeadPhones=1;
				};
			};
		};
		class ViewOptics: ViewOptics
		{
			initAngleX=0;
			minAngleX=-40;
			maxAngleX=17;
			initAngleY=0;
			minAngleY=-100;
			maxAngleY=100;
			initFov=0.5;
			minFov=0.30000001;
			maxFov=1.2;
		};
		class MFD
		{
			class HUD: AirplaneHUD
			{
			};
		};
		weapons[]=
		{
			"FakeWeapon"
		};
		magazines[]=
		{
			"FakeWeapon"
		};
		class Reflectors
		{
			class Reflector
			{
				color[]={0.80000001,0.80000001,1,1};
				ambient[]={0.07,0.07,0.07,1};
				position="L svetlo";
				direction="konec L svetla";
				hitpoint="L svetlo";
				selection="L svetlo";
				size=0.5;
				brightness=2;
			};
		};
		class Sounds: Sounds
		{
			class Engine: Engine
			{
				sound="soundEngine";
				frequency="(1-randomizer*0.05)*rotorSpeed*(1-rotorThrust*0.1)";
				volume="1";
			};
			class Movement: Movement
			{
				sound="soundEnviron";
				frequency="1";
				volume="speed * 0.03334";
			};
		};
		soundLandingGear[]=
		{
			"",
			1,
			1
		};
		class Exhausts
		{
		};
		minSmokeDamage=0.40000001;
		maxSmokeDamage=0.99000001;
		class RotorLibHelicopterProperties
		{
			RTDconfig="";
			hasAPU=0;
			maxTorque=10000;
			autoHoverCorrection[]={0,0,0};
			maxMainRotorStress=10000;
			maxTailRotorStress=10000;
			maxHorizontalStabilizerLeftStress=10000;
			maxHorizontalStabilizerRightStress=10000;
			maxVerticalStabilizerStress=10000;
			stressDamagePerSec=0.0099999998;
			retreatBladeStallWarningSpeed=69.400002;
			horizontalWingsAngleCollMin=0;
			horizontalWingsAngleCollMax=0;
			defaultCollective=0.69999999;
			vrsShakepowerCoef=1;
		};
		slingLoadMemoryPoint="slingLoad0";
		slingLoadMaxCargoMass=0;
		slingLoadMinCargoMass=0;
	};
	class Plane: Air
	{
		vehicleClass="Air";
		damageEffect="DamageSmokePlane";
		icon="iconPlane";
		displayName="$STR_DN_PLANE";
		nameSound="veh_airplane";
		accuracy=0.1;
		maxSpeed=450;
		landingSpeed=0;
		flapsFrictionCoef=0.5;
		formationX=200;
		formationZ=300;
		precision=200;
		brakeDistance=500;
		steerAheadSimul=1;
		steerAheadPlan=2;
		wheelSteeringSensitivity=1;
		unitInfoType="RscUnitInfoAir";
		gearRetracting=1;
		cabinOpening=1;
		durationGetIn=0.99000001;
		durationGetOut=0.99000001;
		flaps=1;
		airBrake=1;
		vtol=0;
		lightOnGear=1;
		gearUpTime=3.3299999;
		gearDownTime=2;
		ejectSpeed[]={0,40,0};
		ejectDamageLimit=0.44999999;
		minFireTime=60;
		cost=2000000;
		simulation="airplanex";
		minGunElev=0;
		maxGunElev=0;
		minGunTurn=0;
		maxGunTurn=0;
		gunAimDown=0;
		rudderInfluence=0.96194696;
		envelope[]={0,0.2,0.89999998,2.0999999,2.5,3.3,3.5,3.2,2.5,2,1.5,1};
		angleOfIndicence=0.052359872;
		draconicForceXCoef=7.5;
		draconicForceYCoef=1;
		draconicForceZCoef=1;
		draconicTorqueXCoef=0.15000001;
		draconicTorqueYCoef=1;
		thrustCoef[]={};
		elevatorCoef[]={};
		aileronCoef[]={};
		rudderCoef[]={};
		elevatorControlsSensitivityCoef=4;
		aileronControlsSensitivityCoef=4;
		rudderControlsSensitivityCoef=4;
		weapons[]=
		{
			"FakeWeapon"
		};
		magazines[]=
		{
			"FakeWeapon"
		};
		type=2;
		threat[]={0.1,1,0.5};
		aileronSensitivity=1;
		elevatorSensitivity=1;
		VTOLYawInfluence=2;
		VTOLPitchInfluence=2;
		VTOLRollInfluence=2;
		landingAoa="10*3.1415/180";
		stallWarningTreshold=0.2;
		class ViewPilot: ViewPilot
		{
			minFov=0.25;
			maxFov=1.25;
			initFov=0.75;
			initAngleX=6;
			minAngleX=-85;
			maxAngleX=85;
			initAngleY=0;
			minAngleY=-150;
			maxAngleY=150;
		};
		class ViewOptics: ViewOptics
		{
			initAngleX=0;
			minAngleX=0;
			maxAngleX=0;
			initAngleY=0;
			minAngleY=0;
			maxAngleY=0;
			initFov=0.5;
			minFov=0.5;
			maxFov=0.5;
		};
		extCameraPosition[]={0,1.4,-25};
		selectionRotorStill="vrtule staticka";
		selectionRotorMove="vrtule blur";
		memoryPointLRocket="L raketa";
		memoryPointRRocket="P raketa";
		memoryPointLDust="levy prach";
		memoryPointRDust="pravy prach";
		selectionFireAnim="zasleh";
		leftDustEffect="LDustEffects";
		rightDustEffect="RDustEffects";
		dustEffect="HeliDust";
		waterEffect="HeliWater";
		class WingVortices
		{
			class WingTipLeft
			{
				effectName="WingVortices";
				position="cerveny pozicni";
			};
			class WingTipRight
			{
				effectName="WingVortices";
				position="zeleny pozicni";
			};
		};
		class Reflectors
		{
			class Reflector
			{
				color[]={0.89999998,0.80000001,0.80000001,1};
				ambient[]={0.1,0.1,0.1,1};
				position="L svetlo";
				direction="konec L svetla";
				hitpoint="L svetlo";
				selection="L svetlo";
				size=0.5;
				brightness=2;
			};
		};
		class MFD
		{
			class HUD: AirplaneHUD
			{
				borderLeft=0.090000004;
				borderRight=0.02;
				borderTop=0.02;
				borderBottom=0.1;
			};
		};
		class GunFire: WeaponFireGun
		{
		};
		class GunClouds: WeaponCloudsGun
		{
		};
		class MGunFire: WeaponFireMGun
		{
		};
		class MGunClouds: WeaponCloudsMGun
		{
		};
		class Sounds: Sounds
		{
			class Engine: Engine
			{
				sound="soundEngine";
				frequency="(1-randomizer*0.05)*(thrust+0.5)*rpm";
				volume="thrust+0.5";
			};
			class Movement: Movement
			{
				sound="soundEnviron";
				frequency="1";
				volume="speed*0.03334";
			};
		};
		numberPhysicalWheels=3;
	};
	class Ship: AllVehicles
	{
		class Components
		{
			class TransportCountermeasuresComponent
			{
			};
		};
		unitInfoType="RscUnitInfo";
		vehicleClass="Ship";
		safeDepth=2;
		icon="iconShip";
		cost=10000000;
		armor=1000;
		displayName="$STR_DN_SHIP";
		nameSound="veh_ship";
		accuracy=0.0049999999;
		maxSpeed=30;
		waterAngularDampingCoef=0;
		simulation="ship";
		audible=6;
		fuelCapacity=100;
		formationX=50;
		formationZ=100;
		precision=10;
		brakeDistance=50;
		formationTime=20;
		steerAheadSimul=2;
		steerAheadPlan=2.4000001;
		predictTurnSimul=2;
		predictTurnPlan=2.4000001;
		verticalTurnCoef=0.2;
		ShipSteerCoef=0.5;
		periscopeDepth=2.8;
		type=1;
		threat[]={0.2,0.2,0.1};
		getInRadius=10;
		driverAction="";
		cargoAction[]=
		{
			""
		};
		getInAction="";
		getOutAction="";
		pointPilot="pilot";
		pointCommander="velitel";
		selectionFireAnim="zasleh";
		selectionBrakeLights="brzdove svetlo";
		memoryPointMissile[]=
		{
			"spice rakety",
			"usti hlavne"
		};
		memoryPointMissileDir[]=
		{
			"konec rakety",
			"konec hlavne"
		};
		canFloat=1;
		soundGear[]=
		{
			"",
			0.00017782791,
			1
		};
		occludeSoundsWhenIn=0.56234133;
		obstructSoundsWhenIn=0.31622776;
		class Exhausts
		{
			class Exhaust1
			{
				position="exhaust";
				direction="exhaust_dir";
				effect="ExhaustsEffect";
			};
		};
		leftDustEffect="LDustEffects";
		rightDustEffect="RDustEffects";
		leftWaterEffect="LWaterEffects";
		rightWaterEffect="RWaterEffects";
		leftEngineEffect="LEngEffects";
		rightEngineEffect="REngEffects";
		leftFastWaterEffect="LWaterEffects";
		rightFastWaterEffect="RWaterEffects";
		memoryPointsLeftEngineEffect="EngineEffectL";
		memoryPointsRightEngineEffect="EngineEffectR";
		class HitPoints
		{
			class HitEngine
			{
				armor=1.2;
				material=60;
				name="engine";
				visual="engine";
				passThrough=1;
				explosionShielding=1;
			};
		};
		class Turrets
		{
			class MainTurret: NewTurret
			{
				commanding=-1;
				startEngine=0;
			};
		};
		class ViewPilot: ViewPilot
		{
			minFov=0.25;
			maxFov=1.25;
			initFov=0.75;
			initAngleX=6;
			minAngleX=-85;
			maxAngleX=85;
			initAngleY=0;
			minAngleY=-150;
			maxAngleY=150;
		};
		class ViewOptics: ViewOptics
		{
			initFov=0.69999999;
			minFov=0.07;
			maxFov=0.34999999;
		};
		class MarkerLights
		{
			class RedStill
			{
				name="cerveny pozicni";
				color[]={0.30000001,0.029999999,0.029999999,1};
				ambient[]={0.029999999,0.003,0.003,1};
				brightness=0.0099999998;
				blinking=0;
			};
			class GreenStill
			{
				name="zeleny pozicni";
				color[]={0.029999999,0.30000001,0.029999999,1};
				ambient[]={0.003,0.029999999,0.003,1};
				brightness=0.0099999998;
				blinking=0;
			};
			class WhiteStill
			{
				name="bily pozicni";
				color[]={0.30000001,0.30000001,0.30000001,1};
				ambient[]={0.029999999,0.029999999,0.029999999,1};
				brightness=0.0099999998;
				blinking=0;
			};
		};
		class Sounds: Sounds
		{
			class Engine: Engine
			{
				sound="soundEngine";
				frequency="(1-randomizer*0.05)*1.2*(thrust*0.7+0.5)";
				volume="(thrust*0.5)+0.5";
			};
			class Movement: Movement
			{
				sound="soundEnviron";
				frequency="(speed*0.03334)*1.3+(1-(speed*0.03334))*0.7";
				volume="(speed*0.03334)+(1-(speed*0.03334))*0.1";
			};
		};
	};
	class SmallShip: Ship
	{
		cost=50000;
		armor=300;
		displayName="$STR_DN_SMALL_SHIP";
		accuracy=0.2;
		fuelCapacity=700;
		weapons[]=
		{
			"FakeWeapon"
		};
		magazines[]=
		{
			"FakeWeapon"
		};
		maxSpeed=60;
		precision=6;
		brakeDistance=20;
		class Reflectors
		{
			class Reflector
			{
				color[]={0.89999998,0.80000001,0.80000001,1};
				ambient[]={0.1,0.1,0.1,1};
				position="L svetlo";
				direction="konec L svetla";
				hitpoint="L svetlo";
				selection="L svetlo";
				size=0.5;
				brightness=2;
			};
		};
		transportMaxMagazines=100;
		transportMaxWeapons=20;
	};
	class BigShip: Ship
	{
		cost=10000000;
		displayName="$STR_DN_BIG_SHIP";
		accuracy=0.2;
		armor=1000;
		weapons[]=
		{
			"FakeWeapon"
		};
		magazines[]=
		{
			"FakeWeapon"
		};
		transportMaxMagazines=500;
		transportMaxWeapons=200;
	};
	class Truck: Car
	{
		nameSound="veh_truck";
		formationX=20;
		formationZ=30;
		getInAction="";
		getOutAction="";
		class HitPoints: HitPoints
		{
			class HitLFWheel: HitLFWheel
			{
				armor=0.30000001;
			};
			class HitRFWheel: HitRFWheel
			{
				armor=0.30000001;
			};
			class HitLF2Wheel: HitLF2Wheel
			{
				armor=0.30000001;
			};
			class HitRF2Wheel: HitRF2Wheel
			{
				armor=0.30000001;
			};
			class HitLMWheel: HitLMWheel
			{
				armor=0.30000001;
			};
			class HitRMWheel: HitRMWheel
			{
				armor=0.30000001;
			};
			class HitLBWheel: HitLBWheel
			{
				armor=0.30000001;
			};
			class HitRBWheel: HitRBWheel
			{
				armor=0.30000001;
			};
		};
		damperSize=0.2;
		outsideSoundFilter=1;
		minFov=0.25;
		maxFov=1.25;
		initFov=0.75;
		transportMaxMagazines=200;
		transportMaxWeapons=50;
		steerAheadSimul=0.2;
		steerAheadPlan=0.30000001;
	};
	class ParachuteBase: Helicopter
	{
		scope=0;
		destrType="DestructNo";
		simulation="parachute";
		weaponSlots="1	 + 	4	 + 10*		256	 + 2*	4096	 + 	2	 + 4*	16";
		autocenter=0;
		vehicleClass="Air";
		displayName="$STR_DN_PARACHUTE";
		nameSound="veh_parachute";
		model="para";
		picture="pictureParachute";
		icon="iconParachute";
		accuracy=0.1;
		fuelCapacity=0;
		unitInfoType="RscUnitInfoSoldier";
		hideUnitInfo=1;
		irTarget=0;
		driverCanSee="2+8+32";
		driverAction="";
		armor=10;
		memoryPointPilot="pilot";
		animationOpen="";
		animationDrop="";
		class ViewOptics: ViewOptics
		{
			initAngleX=0;
			minAngleX=-40;
			maxAngleX=17;
			initAngleY=0;
			minAngleY=-100;
			maxAngleY=100;
			initFov=0.5;
			minFov=0.30000001;
			maxFov=1.2;
		};
		type=0;
		threat[]={0,0,0};
		cost=100000;
		weapons[]={};
		magazines[]={};
		soundGetIn[]=
		{
			"",
			0.00031622773,
			1
		};
		soundGetOut[]=
		{
			"",
			0.00031622773,
			1
		};
	};
	class LaserTarget: All
	{
		reversed=0;
		hasDriver=0;
		icon="iconLaserTarget";
		displayName="$STR_DN_LASER_TARGET";
		nameSound="obj_LaserTarget";
		accuracy=9.9999997e-005;
		model="laserTgt.p3d";
		picture="pictureLaserTarget";
		weapons[]=
		{
			"FakeWeapon"
		};
		magazines[]=
		{
			"FakeWeapon"
		};
		type=1;
		threat[]={0.5,0.5,0.1};
		maxSpeed=0;
		simulation="laserTarget";
		laserTarget=1;
		irTarget=0;
		artilleryTarget=0;
		destrType="DestructNo";
		side=3;
		cost=9.9999999e+014;
		armor=500;
	};
	class NVTarget: All
	{
		reversed=0;
		hasDriver=0;
		icon="iconLaserTarget";
		displayName="$STR_DN_LASER_TARGET";
		nameSound="obj_LaserTarget";
		accuracy=9.9999997e-005;
		model="laserTgt.p3d";
		picture="pictureLaserTarget";
		weapons[]=
		{
			"FakeWeapon"
		};
		magazines[]=
		{
			"FakeWeapon"
		};
		type=1;
		threat[]={0.2,0.5,0.1};
		maxSpeed=0;
		simulation="nvmarker";
		laserTarget=0;
		irTarget=0;
		nvTarget=1;
		destrType="DestructEngine";
		side=3;
		cost=9.9999999e+014;
		armor=500;
	};
	class ArtilleryTarget: All
	{
		reversed=0;
		hasDriver=0;
		icon="iconLaserTarget";
		displayName="ArtilleryTarget";
		nameSound="";
		accuracy=9.9999997e-005;
		model="";
		picture="pictureLaserTarget";
		weapons[]=
		{
			"FakeWeapon"
		};
		magazines[]=
		{
			"FakeWeapon"
		};
		type=1;
		threat[]={0.5,0.5,0.1};
		maxSpeed=0;
		simulation="artillerymarker";
		laserTarget=0;
		irTarget=0;
		nvTarget=0;
		artilleryTarget=1;
		destrType="DestructNo";
		side=3;
		cost=9.9999999e+014;
		armor=500;
		scope=1;
	};
	class ArtilleryTargetW: ArtilleryTarget
	{
		side=1;
		scope=1;
	};
	class ArtilleryTargetE: ArtilleryTarget
	{
		side=0;
		scope=1;
	};
	class SuppressTarget: LaserTarget
	{
		icon="iconLaserTarget";
		displayName="suppressTarget";
		nameSound="";
		accuracy=9.9999997e-005;
		model="";
		weapons[]=
		{
			"FakeWeapon"
		};
		magazines[]=
		{
			"FakeWeapon"
		};
		type=1;
		threat[]={0.5,0.5,0.1};
		maxSpeed=0;
		simulation="suppresstarget";
		laserTarget=0;
		irTarget=0;
		nvTarget=0;
		artilleryTarget=0;
		side=3;
		cost=9.9999999e+014;
		armor=0;
		scope=1;
	};
	class PaperCar: Car
	{
		scope=1;
		scopeCurator=0;
		side=3;
		picture="picturePaperCar";
		icon="iconPaperCar";
		displayName="$STR_DN_PAPER_CAR";
		model="\core\default\default.p3d";
		class Reflectors
		{
		};
	};
	class FireSectorTarget: All
	{
		scope=1;
		scopeCurator=0;
		side=3;
		picture="";
		icon="";
		nameSound="";
		displayName="Internal: Fire Sector Target";
		vehicleClass="Objects";
		model="\core\default\default.p3d";
		weapons[]={};
		magazines[]={};
		transportMaxWeapons=0;
		transportMaxMagazines=0;
		transportAmmo=0;
		transportRepair=0;
		transportFuel=0;
		supplyRadius=0;
		type=0;
		threat[]={0,0,0};
		maxSpeed=0;
		armor=100;
		simulation="house";
		accuracy=0.0049999999;
		cost=100;
		destrType=0;
		mapSize=0.1;
		reversed=0;
		hasDriver=0;
		coefInside=0;
		coefInsideHeur=0;
		coefSpeedInside=1;
		windSockExist=0;
		animated=0;
		ladders[]={};
		typicalCargo[]={};
	};
	class Static: All
	{
		reversed=0;
		scopeCurator=0;
		hasDriver=0;
		icon="iconObject";
		displayName="$STR_DN_UNKNOWN";
		nameSound="obj_object";
		accuracy=0.0049999999;
		audible=0;
		simulation="house";
		class DestructionEffects
		{
		};
		cost=1000;
		picture="pictureStaticObject";
		weapons[]={};
		magazines[]={};
		irTarget=0;
		type=1;
		threat[]={0,0,0};
		maxSpeed=0;
		coefInside=2;
		coefInsideHeur=2;
		coefSpeedInside=2;
		windSockExist=0;
	};
	class Rope: All
	{
		access=0;
		scope=2;
		displayName="";
		simulation="rope";
		model="";
		side=8;
		maxRelLenght=1.1;
		maxExtraLenght=20;
		alwaysTarget=0;
		irTarget=0;
		irScanRangeMin=0;
		irScanRangeMax=0;
		irScanToEyeFactor=1;
		laserTarget=0;
		laserScanner=0;
		nvTarget=0;
		nvScanner=0;
		artilleryTarget=0;
		artilleryScanner=0;
	};
	class Fortress: Static
	{
		displayName="$STR_DN_BUNKER";
		nameSound="obj_Bunker";
		armor=1000;
		cost=1000000;
		accuracy=0.2;
	};
	class Building: Static
	{
		scope=1;
		displayName="$STR_DN_BUILDING";
		nameSound="obj_building";
		armor=150;
		accuracy=0.1;
	};
	class NonStrategic: Building
	{
		side=3;
		ladders[]={};
		class DestructionEffects
		{
			class Sound
			{
				simulation="sound";
				type="DestrHouse";
				position="destructionEffect1";
				intensity=1;
				interval=1;
				lifeTime=0.125;
			};
			class DestroyPhase1
			{
				simulation="destroy";
				type="DelayedDestruction";
				lifeTime=2.5;
				position="";
				intensity=1;
				interval=1;
			};
			class DamageAround1
			{
				simulation="damageAround";
				type="DamageAroundHouse";
				position="";
				intensity=1;
				interval=1;
				lifeTime=1;
			};
		};
	};
	class HeliH: NonStrategic
	{
	};
	class Strategic: Building
	{
		side=3;
		armor=250;
		cost=1000000;
		ladders[]={};
	};
	class FlagCarrierCore: Strategic
	{
		scope=1;
		animated=0;
		vehicleClass="Objects";
		icon="";
		displayName="$STR_DN_FLAG";
		simulation="flagcarrier";
		model="";
		placement="vertical";
		mapSize=5;
		animationFlag="";
	};
	class Land_VASICore: NonStrategic
	{
		scope=1;
		animated=0;
		reversed=0;
		vehicleClass="Objects";
		icon="";
		model="";
		displayName="VASI";
		accuracy=0.2;
		typicalCargo[]={};
		destrType="DestructBuilding";
		selectionWhiteLight="light-white";
		selectionRedLight="light-red";
		selectionOffLight="light-off";
		irTarget=0;
		transportAmmo=0;
		transportRepair=0;
		transportFuel=0;
		cost=0;
		armor=100;
		mapSize=6.4000001;
		simulation="vasi";
		vasiRed[]={1,0,0};
		vasiWhite[]={1,1,1};
		vasiSlope=0.079999998;
	};
	class Thing: All
	{
		reversed=0;
		animated=0;
		icon="iconThing";
		vehicleClass="Objects";
		displayName="$STR_DN_UNKNOWN";
		nameSound="obj_object";
		accuracy=0.0049999999;
		audible=0;
		simulation="thing";
		side=3;
		weight=0;
		class InventoryPlacements
		{
		};
		submerged=0;
		submergeSpeed=0;
		airFriction2[]={0.0099999998,0.0099999998,0.0099999998};
		airFriction1[]={0.0099999998,0.0099999998,0.0099999998};
		airFriction0[]={0.0099999998,0.0099999998,0.0099999998};
		airRotation=0;
		gravityFactor=1;
		timeToLive=1e+010;
		disappearAtContact=0;
		hasDriver=0;
		picture="pictureThing";
		weapons[]={};
		magazines[]={};
		minHeight=0.1;
		avgHeight=0.2;
		maxHeight=0.40000001;
		type=1;
		threat[]={0,0,0};
		maxSpeed=0;
		irTarget=0;
	};
	class ThingEffect: Thing
	{
		scope=1;
		simulation="thingeffect";
		irTarget=0;
		submerged=-0.5;
		submergeSpeed=0.25;
		timeToLive=20;
	};
	class ThingEffectLight: ThingEffect
	{
		scope=0;
		airFriction2[]={1,1,8};
		airFriction1[]={1,1,4};
		airFriction0[]={0.1,0.1,0.1};
		airRotation=0.1;
		submergeSpeed=0;
		minHeight=0.1;
		avgHeight=0.2;
		maxHeight=0.40000001;
	};
	class ThingEffectFeather: ThingEffectLight
	{
		airFriction2[]={16,16,16};
		airFriction1[]={16,16,16};
		airFriction0[]={0.1,0.1,0.1};
		gravityFactor=0.050000001;
		minHeight=0.5;
		avgHeight=1.8;
		maxHeight=3;
	};
	class FxExploArmor1: ThingEffect
	{
		access=0;
		model="";
		displayName="Internal: FxExploArmor1";
	};
	class FxExploArmor2: ThingEffect
	{
		access=0;
		model="";
		displayName="Internal: FxExploArmor2";
	};
	class FxExploArmor3: ThingEffect
	{
		access=0;
		model="";
		displayName="Internal: FxExploArmor3";
	};
	class FxExploArmor4: ThingEffect
	{
		access=0;
		model="";
		displayName="Internal: FxExploArmor4";
	};
	class FxCartridge: ThingEffect
	{
		access=0;
		model="";
		displayName="Internal: FX Cartridge";
		submerged=0;
		submergeSpeed=0;
		timeToLive=5;
		disappearAtContact=1;
	};
	class WindAnomaly: All
	{
		displayName="Wind anomaly";
		simulation="windAnomaly";
		innerRadius=1;
		outerRadius=20;
		windStrength=-20;
		windRotation=0;
		windWaveTimeCoef=5;
		windWaveOuterAmplitudeCoef=0.30000001;
		windWaveInnerAmplitudeCoef=0.02;
	};
};
class CfgNonAIVehicles
{
	access=0;
	class EmptyDetector
	{
		scope=2;
		displayName="$STR_DN_EMPTY";
		simulation="detector";
		model="";
		selectionFabric="latka";
	};
	class StreetLamp
	{
		model="";
		destrType="DestructTree";
		simulation="StreetLamp";
		animated=0;
		colorDiffuse[]={0.89999998,0.80000001,0.60000002};
		colorAmbient[]={0.1,0.1,0.1};
		brightness=0.2;
		class HitPoints
		{
			class HitBulb
			{
				armor=1;
				material=60;
				name="lampa";
				passThrough=1;
				explosionShielding=1;
			};
		};
		armorStructural=1;
		class Reflectors
		{
			class LampLight
			{
				color[]={0.89999998,0.80000001,0.60000002,1};
				ambient[]={0.1,0.1,0.1,1};
				position="Light";
				direction="";
				hitpoint="lampa";
				selection="";
				size=0.5;
				brightness=0.2;
			};
		};
		aggregateReflectors[]={};
		armorLights=1;
	};
	class EditCursor
	{
		model="\core\cursor\cursor.p3d";
		simulation="EditCursor";
	};
	class ObjView
	{
		scope=2;
		model="";
		simulation="ObjView";
	};
	class Temp
	{
		scope=2;
		model="";
		simulation="Temp";
	};
	class Bird
	{
		scope=0;
		model="";
		animated=0;
		simulation="SeaGull";
		reversed=0;
		minHeight=5;
		avgHeight=10;
		maxHeight=50;
		minSpeed=-0.5;
		maxSpeed=20;
		acceleration=7;
		turning=1;
		straightDistance=50;
		flySound[]=
		{
			"",
			0.031622775,
			1,
			1
		};
		singSound[]=
		{
			"",
			0.031622775,
			1,
			1
		};
		canBeShot=1;
		airFriction2[]={25,12,2.5};
		airFriction1[]={1500,700,100};
		airFriction0[]={40,20,60};
	};
	class Insect: Bird
	{
		animated=0;
		minHeight=-0.1;
		avgHeight=1.2;
		maxHeight=2;
		minSpeed=-0.1;
		maxSpeed=5;
		acceleration=25;
		straightDistance=2;
		turning=2;
		flySound[]=
		{
			"",
			0.031622775,
			1,
			1
		};
		singSound[]=
		{
			"",
			0.031622775,
			1,
			1
		};
		canBeShot=0;
		airFriction2[]={125,12,2.5};
		airFriction1[]={7500,700,100};
		airFriction0[]={200,20,60};
	};
	class SeaGull: Bird
	{
		scope=2;
		model="\core\default\default.p3d";
		reversed=0;
	};
	class RopeSegment
	{
		access=0;
		scope=2;
		displayName="";
		simulation="ropesegment";
		model="";
		autocenter=0;
		animated=0;
	};
	class RopeEnd: RopeSegment
	{
		access=0;
		scope=2;
		model="";
	};
	class Camera
	{
		scope=2;
		model="";
		simulation="Camera";
		crossHairs="#(argb,8,8,3)color(1,1,1,1)";
	};
	class CamConstruct
	{
		scope=2;
		model="";
		simulation="CamConstruct";
		radius=125;
		maxHAL=30;
		crossHairs="#(argb,8,8,3)color(1,1,1,1)";
	};
	class CamCurator
	{
		scope=2;
		model="";
		simulation="CamCurator";
		radius=125;
		maxHAL=30;
		crossHairs="#(argb,8,8,3)color(1,1,1,1)";
	};
	class ProxyWeapon
	{
		autocenter=0;
		scope=2;
		reversed=0;
		animated=0;
		shadow=1;
		model="";
		simulation="ProxyWeapon";
	};
	class ProxyPistol
	{
		autocenter=0;
		scope=2;
		animated=0;
		model="";
		shadow=1;
		simulation="ProxyInventoryOld";
		inventoryType="Handgun";
	};
	class ProxyLauncher
	{
		autocenter=0;
		scope=2;
		animated=0;
		shadow=1;
		model="";
		simulation="ProxySecWeapon";
	};
	class ProxyRightHand
	{
		autocenter=0;
		scope=2;
		animated=0;
		model="";
		shadow=1;
		simulation="ProxyInventoryOld";
		inventoryType="RightHand";
	};
	class ProxyLeftHand
	{
		autocenter=0;
		scope=2;
		animated=0;
		model="";
		shadow=1;
		simulation="ProxyInventoryOld";
		inventoryType="LeftHand";
	};
	class ProxyGoggles
	{
		autocenter=0;
		scope=2;
		animated=0;
		model="";
		shadow=1;
		simulation="ProxyInventoryOld";
		inventoryType="Goggles";
	};
	class ProxyEarPhones
	{
		autocenter=0;
		scope=2;
		animated=0;
		model="";
		shadow=1;
		simulation="ProxyInventoryOld";
		inventoryType="EarPhones";
	};
	class Proxyus_bag
	{
		reversed=1;
		autocenter=0;
		scope=2;
		animated=0;
		model="";
		shadow=1;
		simulation="ProxyInventoryOld";
		inventoryType="Backpack";
	};
	class ProxyHide
	{
		autocenter=0;
		scope=2;
		animated=0;
		model="";
		simulation="alwayshide";
	};
	class ProxyWreck
	{
		autocenter=0;
		scope=0;
		animated=0;
		model="";
		simulation="alwaysshow";
	};
	class ProxyRetex
	{
		autocenter=0;
		scope=0;
		animated=0;
		model="";
		simulation="proxyretex";
		hiddenSelections[]={};
	};
	class ProxyCrew
	{
		autocenter=0;
		scope=1;
		model="";
		shadow=1;
		simulation="proxycrew";
		crewPosition="CPDriver";
	};
	class ProxyCommander: ProxyCrew
	{
		crewPosition="CPCommander";
	};
	class ProxyDriver: ProxyCrew
	{
		crewPosition="CPDriver";
	};
	class ProxyGunner: ProxyCrew
	{
		crewPosition="CPGunner";
	};
	class ProxyCargo: ProxyCrew
	{
		crewPosition="CPCargo";
	};
	class ProxyFlag
	{
		autocenter=0;
		scope=2;
		reversed=0;
		model="";
		shadow=1;
		simulation="flag";
		selectionFabric="latka";
	};
	class RandomShape
	{
		models[]={};
		autocenter=0;
		scope=2;
		reversed=0;
		shadow=1;
		model="";
		simulation="randomshape";
	};
	class ProxyAmmoInTruck
	{
		autocenter=0;
		scope=2;
		reversed=0;
		animated=0;
		shadow=1;
		model="";
		simulation="alwaysshow";
	};
};
class CfgSimulationCosts
{
	tank=150;
	zsu=150;
	car=120;
	motorcycle=120;
	ship=140;
	soldierold=100;
	soldier=100;
	helicopter=300;
	parachute=120;
	airplane=200;
	lasertarget=100;
	nvmarker=100;
	house=10;
	thing=10;
	thingeffect=10;
	church=100;
	fire=50;
	fountain=100;
	seagull=10;
	camera=10;
	flagcarrier=50;
	invisible=10;
	mines=10;
	sounds=10;
};
class CfgMarkedTargets
{
	class Inf
	{
		type="man";
		importance=1;
		battleRadius=50;
		farRadius=150;
	};
	class MotorInf
	{
		type="car";
		importance=3;
		battleRadius=100;
		farRadius=400;
	};
	class MechInf
	{
		type="tank";
		transportSoldiers=1;
		importance=4;
		battleRadius=100;
		farRadius=400;
	};
	class Armored
	{
		type="tank";
		importance=5;
		battleRadius=100;
		farRadius=400;
	};
	class Air
	{
		type="helicopter";
		importance=7;
		battleRadius=400;
		farRadius=800;
	};
	class Plane
	{
		type="plane";
		importance=8;
		battleRadius=400;
		farRadius=800;
	};
	class UAV
	{
		type="uav";
		importance=9;
		battleRadius=100;
		farRadius=300;
	};
	class Art
	{
		type="staticcanon";
		importance=10;
		battleRadius=400;
		farRadius=800;
	};
	class Mortar
	{
		type="staticmortar";
		importance=11;
		battleRadius=400;
		farRadius=800;
	};
};
ReportTargetsChangeFactors[]={3,2.5,2,1.6,1.3};
ReportTargetsEmptyGroupCost=0.40000001;
class CfgFSMs
{
	access=1;
};
class PreloadVehicles
{
	access=1;
};
class CfgFatigue
{
	MinValue1=0.1;
	MinValue2=1;
	NormalRunSpeed=7.1999998;
	TiredRunSpeedLimit=0.80000001;
};
class CfgFirstAid
{
	access=1;
	MinCosSpeedAngle=0.60000002;
	SpeedReduction=0.242;
	CollisionFactor=0.001;
	MinCollisionSpeed=0.5;
	collisionHeigth=120;
	collisionAngle=0;
	valRangeMult=0.1;
	vehicleFireCoef=6;
	CriticalHeadHit=1;
	CriticalBodyHit=1;
	InjuredTreshold=0.1;
	UnconsiousTreshold=1.01;
	HeadHitLimit1Threshold=0.5;
	HeadHitLimitThreshold=1.01;
	HeadHitLimit2Threshold=1.01;
	HealingDuration=4;
	HealingLeaderDistance=20;
	HealSpeedMedic=1.5;
	HealSpeedSoldier=0.050000001;
	HealSpeedAutomatic=0.0040000002;
	MinHealingDistance=10;
	HealDiffMupliplier=1.2;
	BleedingInjuryMinProjectile=0.1;
	BleedingInjuryMinExplosion=0.2;
	BleedingInjuryMinImpulse=0.40000001;
	BleedingInjuryMax=1;
	BleedingFrequencyMin=0.25;
	BleedingFrequencyMiddle=1;
	BleedingFrequencyMax=2;
	StabilizeTime=5;
	BleedingFrequencyMinSound=0.5;
	BleedingFrequencyMaxSound=2;
	InjuredSoundIntervalMin=2;
	InjuredSoundIntervalMax=10;
	PulsationSoundInterval=1;
	UnconsciousPulsationSoundVolume=1;
	BurningSoundInterval=1;
	ConsumedOxygenThresholdSound=0.2;
	BreathingFade=0.2;
	UnconsciousPulsesNumber=10;
	UnconsciousPulsesOffset=0.30000001;
	DrowningInterval=1;
	DrowningDamage=0.0049999999;
	UnconsciousSoundIntervalMin=1;
	UnconsciousSoundIntervalMax=5;
	HandsHitLimit1Threshold=0.5;
	HandsHitLimit2Threshold=0.85000002;
	LegsHitLimit1Threshold=0.5;
	LegsHitLimit2TThreshold=0.85000002;
};
class CfgDiving
{
	verticalStep=0.80000001;
	relativeUp=-1;
	relativeDown=1;
	relativeUpSDV=-2;
	relativeDownSDV=2;
	WaterOperfieldRadiusCollision=1;
	WaterOperfieldRadiusLogical=5;
	PositionYThreshold=1.5;
	StandardDepthMajor=-40;
	StandardDepthMinor=-10;
	StandardTransfer=5;
	StandardDepthMajorSDV=-40;
	StandardDepthMinorSDV=-10;
	StandardTransferSDV=5;
	DiverSpeedCoef=1.5;
	WaterSlowdown1=0.69999999;
	WaterSlowdown2=0.69999999;
	waypointSwimRadius1=1.5;
	waypointSwimRadius2=5;
	MaxRangeCoef=0.5;
	ThresholdSwimmingWithNeopren=0;
	SwimDuration=1;
	WaveEffectDepth=5;
	SubmarineWaveEffectDepth=5;
	grenadeWaterWaveCoef=1.5;
	shotRandomAngle=0.1;
	MinAngle=49;
	MaxDistance=35;
	MaxDistance2=35;
	Haze=1;
};
class CfgBleeding
{
	damageMin=0.2;
	damageMax=1;
	timeMin=0.2;
	timeMax=1;
	percentMin=0.2;
	percentMax=1;
	timeToLive=60;
	bloodSlopeAlpha=0.69999999;
	bloodSlopeTimeToLiveMin=180;
	bloodSlopeTimeToLiveMax=600;
};
class CfgPriority
{
	priorityUnconsciousGain=0.5;
};
class CfgSkeletonParameters
{
};
class CfgImprecision
{
	class Small
	{
		horizontalRadius=0.60000002;
		verticalRadius=0.44999999;
		speed=0.60000002;
	};
	class Big
	{
		radius=4;
	};
	class Common
	{
		maxMultiplier=2.8;
		speedCoef=1.2;
		sizeCoef=0.40000001;
	};
	class Screen
	{
		screenToCursor=50;
	};
	class Multipliers
	{
		fatigue=1;
		damage=1;
	};
	class Primary
	{
		verticalRadius=1;
		horizontalRadius=0.30000001;
		fatigue=1;
		damage=1;
		breathing=0.1;
		speed=0.5;
		size=1.8;
		maxSpeed=2.5;
		maxSize=2;
	};
	class Secondary
	{
		verticalRadius=0.30000001;
		horizontalRadius=1;
		fatigue=1;
		damage=1;
		inertia=1;
		speed=0.25;
		size=0.40000001;
		maxSpeed=2.5;
		maxSize=10;
	};
};
class CfgBreathing
{
	maxHoldTime=5;
	coefSpeed=10;
	outOfBreathCoef=0.80000001;
	inhaleDuration=1;
};
class CfgWeaponHandling
{
	class SwayDistortion
	{
		rate=6;
		decay=0;
		maximum=5;
		gunnerCoef=1;
	};
	class SightAlignment
	{
		rate=6;
		decay=4;
		maximum=5;
		gunnerCoef=1;
	};
	class Stabilization
	{
		restingCoef=0.1;
		deployedCoef=0.1;
		deployedProneCoef=0.1;
		restingProneCoef=0.1;
		restingRecoil=0.30000001;
		restingRecoilPersistent=1;
		deployedRecoil=0.30000001;
		deployedRecoilPersistent=1;
		characterPoints[]=
		{
			"Spine3"
		};
		weaponPoints[]=
		{
			"usti hlavne"
		};
		weaponRadius=0.15000001;
		upperBodyRadius=0.64999998;
		groundLimits[]={0.13962634,0.31415927};
		objectLimits[]={0.34906584,0.83775806};
	};
	class Recoil
	{
		kickVisual=0.2;
		impulseCoef=1;
		prone=0.30000001;
	};
	class Camera
	{
		aimTransitionSpeed=6;
	};
};
class CfgPersonTurret
{
	inertiaStabilisationCoef=0.2;
	inertiaWeaponCoef=0.2;
	obstructionTestTimer=0.1;
};
class CfgMovesBasic
{
	class Default
	{
		minPlayTime=0;
		useIdles=1;
		canBlendStep=0;
		idle="idleDefault";
		weaponLowered=0;
		weaponObstructed=0;
		access=0;
		actions="NoActions";
		file="";
		looped=1;
		speed=0.5;
		disableWeapons=0;
		enableOptics=1;
		disableWeaponsLong=0;
		showWeaponAim=1;
		enableMissile=0;
		enableBinocular=0;
		showItemInHand=0;
		showItemInRightHand=0;
		showHandGun=0;
		onLandBeg=0;
		onLandEnd=0;
		onLadder=0;
		canPullTrigger=1;
		canReload=1;
		duty=-0.5;
		visibleSize=0.75011998;
		aimPrecision=1;
		camShakeFire=1;
		relSpeedMin=1;
		relSpeedMax=1;
		soundEnabled=1;
		soundOverride="";
		soundEdge[]={0.5,1};
		terminal=0;
		ragdoll=0;
		limitGunMovement=1;
		variantsPlayer[]={};
		variantsAI[]=
		{
			""
		};
		equivalentTo="";
		connectAs="";
		variantAfter[]={5,10,20};
		connectFrom[]={};
		connectTo[]={};
		interpolateWith[]={};
		interpolateTo[]={};
		interpolateFrom[]={};
		aiming="aimingDefault";
		aimingBody="aimingUpDefault";
		leaning="leaningDefault";
		legs="legsDefault";
		head="headDefault";
		leaningFactorBeg=0;
		leaningFactorEnd=0;
		leaningFactorZeroPoint=-1;
		interpolationSpeed=6;
		interpolationRestart=0;
		enableDirectControl=1;
		headBobMode=0;
		headBobStrength=0;
		collisionShape="";
		hasCollShapeSafe=0;
		collisionShapeSafe="";
		boundingSphere=1;
		enableAutoActions=0;
		leftHandIKBeg=0;
		leftHandIKEnd=0;
		rightHandIKBeg=0;
		rightHandIKEnd=0;
		leftHandIKCurve[]={};
		rightHandIKCurve[]={};
		weaponIK=0;
		preload=0;
		Walkcycles=1;
		forceAim=0;
		stamina=1;
	};
};
class CfgGesturesMale
{
	class Default
	{
		minPlayTime=0;
		actions="NoActions";
		file="";
		looped=1;
		speed=0.5;
		relSpeedMin=1;
		relSpeedMax=1;
		soundEnabled=0;
		soundOverride="";
		soundEdge[]={0.5,1};
		terminal=0;
		ragdoll=0;
		equivalentTo="";
		connectAs="";
		connectFrom[]={};
		connectTo[]={};
		interpolateWith[]={};
		interpolateTo[]={};
		interpolateFrom[]={};
		mask="empty";
		interpolationSpeed=6;
		interpolationRestart=0;
		preload=0;
		disableWeapons=1;
		enableOptics=1;
		showWeaponAim=1;
		enableMissile=1;
		enableBinocular=1;
		showItemInHand=0;
		showItemInRightHand=0;
		showHandGun=0;
		canPullTrigger=1;
		Walkcycles=1;
		headBobMode=0;
		headBobStrength=0;
		leftHandIKBeg=0;
		leftHandIKEnd=0;
		rightHandIKBeg=0;
		rightHandIKEnd=0;
		leftHandIKCurve[]={1};
		rightHandIKCurve[]={1};
		forceAim=0;
	};
};
class CfgSlopeLimits
{
	maxRun=0.40000001;
	minRun=-0.69999999;
	maxSprint=0.2;
	minSprint=-0.5;
	maxRunAI=0.40000001;
	minRunAI=-0.69999999;
	maxSprintAI=0.2;
	minSprintAI=-0.5;
	class Duty
	{
		maxSlope=0.83899999;
		minSlope=-1;
		optimalSlope=-0.26800001;
		maxDuty=15;
		minDuty=0.15000001;
	};
};
class CfgAnimation
{
	combatPaceDuration=1;
	ladderSpeed=0.5;
	preloadedClass="C_Soldier_VR_F";
};
class CfgCollisions
{
	access=2;
	minMassCollisionLimit=10;
};
class CfgSlingLoading
{
	ropeLength=10;
	hookMinRange=4;
	abortHeight=20;
	abortRange=15;
	unwindSpeed=2;
	slmMaxAltitude=40;
};
class CfgVoice
{
	access=0;
	voices[]=
	{
		"NoVoice"
	};
	femaleVoices[]={};
	voicePlayer="NoVoice";
	micOuts[]={};
	preview="";
	default="NoVoice";
	class NoVoice
	{
		protocol="RadioProtocolBase";
		variants[]={1};
		directories[]=
		{
			"",
			""
		};
		identityTypes[]=
		{
			"Default"
		};
		scope=2;
		voiceType="";
	};
};
class CfgVoiceTypes
{
	class NoVoice
	{
		name="No voice";
		voices[]=
		{
			"NoVoice"
		};
		preview="NoVoice";
		alternative="";
	};
};
class CfgCoreData
{
	access=0;
	textureDefault="#(argb,8,8,3)color(1,1,1,1)";
	textureBlack="#(argb,8,8,3)color(0,0,0,1)";
	textureHalf="#(argb,1,1,1)color(0.5,0.5,0.5,1,dt)";
	textureZero="#(argb,1,1,1)color(0,0,0,0)";
	textureLine="#(argb,8,8,3)color(1,1,1,1)";
	textureLine3D="#(argb,8,8,3)color(1,1,1,1)";
	textureTIConversion="core\data\ticonversion.tga";
	textureTIConversionDX11="core\data\ticonversion.png";
	textureTrack="#(argb,8,8,3)color(1,1,1,1)";
	textureTrackFour="#(argb,8,8,3)color(1,1,1,1)";
	maskTextureFlare="#(argb,1,1,1)color(1,1,1,0)";
	eyeFlare="#(argb,1,1,1)color(1,1,1,0)";
	eyeFlareSun="#(argb,1,1,1)color(1,1,1,0)";
	lodTransitionSpeed=0.125;
	craterShell="core\default\default.p3d";
	craterBullet="core\default\default.p3d";
	slopBlood="core\default\default.p3d";
	cloudletBasic="core\default\default.p3d";
	cloudletFire="core\default\default.p3d";
	cloudletFireD="core\default\default.p3d";
	cloudletWater="core\default\default.p3d";
	cloudletMissile="core\default\default.p3d";
	cobraLight="core\default\default.p3d";
	sphereLight="core\default\default.p3d";
	halfLight="core\default\default.p3d";
	marker="core\default\default.p3d";
	footStepL="core\default\default.p3d";
	footStepR="core\default\default.p3d";
	footStepBleeding0="core\default\default.p3d";
	footStepBleeding1="core\default\default.p3d";
	paperCarModel="core\default\default.p3d";
	forceArrowModel="core\cursor\forcearrowmodel.p3d";
	halfspaceModel="core\default\default.p3d";
	sphereModel="core\Sphere\sphere.p3d";
	rectangleModel="core\Rectangle\rect.p3d";
	horizontObject="core\default\default.p3d";
	collisionShape="core\default\default.p3d";
	rayModel="core\cursor\forcearrowmodel.p3d";
	gunLightModel="core\default\default.p3d";
	tetraHedronModel="core\tetrahedron\tetrahedron.p3d";
	gizmoModel="core\default\default.p3d";
};
class CfgVehicleIcons
{
	iconObject="#(argb,8,8,3)color(1,1,1,1)";
	iconLogic="#(argb,8,8,3)color(1,1,1,1)";
	iconVehicle="#(argb,8,8,3)color(1,1,1,1)";
	iconCar="#(argb,8,8,3)color(1,1,1,1)";
	iconMotorcycle="#(argb,8,8,3)color(1,1,1,1)";
	iconTank="#(argb,8,8,3)color(1,1,1,1)";
	iconAPC="#(argb,8,8,3)color(1,1,1,1)";
	iconMan="#(argb,8,8,3)color(1,1,1,1)";
	iconAnimal="#(argb,8,8,3)color(1,1,1,1)";
	iconAir="#(argb,8,8,3)color(1,1,1,1)";
	iconHelicopter="#(argb,8,8,3)color(1,1,1,1)";
	iconPlane="#(argb,8,8,3)color(1,1,1,1)";
	iconShip="#(argb,8,8,3)color(1,1,1,1)";
	iconParachute="#(argb,8,8,3)color(1,1,1,1)";
	iconStaticObject="#(argb,8,8,3)color(1,1,1,1)";
	iconThing="#(argb,8,8,3)color(1,1,1,1)";
	iconLaserTarget="#(argb,8,8,3)color(1,1,1,1)";
	iconPaperCar="#(argb,8,8,3)color(1,1,1,1)";
	pictureLogic="#(argb,8,8,3)color(1,1,1,1)";
	pictureParachute="#(argb,8,8,3)color(1,1,1,1)";
	pictureLaserTarget="#(argb,8,8,3)color(1,1,1,1)";
	picturePaperCar="#(argb,8,8,3)color(1,1,1,1)";
	pictureStaticObject="#(argb,8,8,3)color(1,1,1,1)";
	pictureThing="#(argb,8,8,3)color(1,1,1,1)";
};
class CfgCloudletShapes
{
	cloudletExplosion="\core\default\default.p3d";
	cloudletSmoke="\core\default\default.p3d";
	cloudletDust="\core\default\default.p3d";
	cloudletBlood="\core\default\default.p3d";
	cloudletWater="\core\default\default.p3d";
	cloudletMissile="\core\default\default.p3d";
	cloudletFire="\core\default\default.p3d";
	cloudletClouds="\core\default\default.p3d";
};
class CfgSaveThumbnails
{
	saveSingleMission="core\all\todo.png";
	saveMPMission="core\all\todo.png";
	saveCampaign="core\all\todo.png";
	userMissionSP="core\all\todo.png";
	userMissionMP="core\all\todo.png";
};
class cfgFormations
{
	class West
	{
		class formColumnFixed
		{
			class Fixed
			{
				FormationPositionInfo1[]={-1,0,0,0};
				FormationPositionInfo2[]={0,0,-1,0.78539819};
				FormationPositionInfo3[]={1,0,-1,-0.78539819};
				FormationPositionInfo4[]={2,0,-1,3.1415927};
			};
			class Pattern
			{
				FormationPositionInfo1[]={-1,0,-1,0};
				FormationPositionInfo2[]={0,0,-1,0.78539819};
				FormationPositionInfo3[]={1,0,-1,-0.78539819};
				FormationPositionInfo4[]={2,0,-1,3.1415927};
			};
		};
		class Staggered
		{
			class Fixed
			{
				FormationPositionInfo1[]={-1,0,0,0};
				FormationPositionInfo2[]={0,1,-1,0.78539819};
				FormationPositionInfo3[]={1,-1,-1,-0.78539819};
				FormationPositionInfo4[]={2,1,-1,3.1415927};
			};
			class Pattern
			{
				FormationPositionInfo1[]={-1,-1,-1,0};
				FormationPositionInfo2[]={0,1,-1,0.78539819};
				FormationPositionInfo3[]={1,-1,-1,-0.78539819};
				FormationPositionInfo4[]={2,1,-1,3.1415927};
			};
		};
		class Wedge
		{
			class Fixed
			{
				FormationPositionInfo1[]={-1,0,0,0};
				FormationPositionInfo2[]={0,1,-1,0.78539819};
			};
			class Pattern
			{
				FormationPositionInfo1[]={-2,-1,-1,-0.78539819};
				FormationPositionInfo2[]={-1,1,-1,0.78539819};
			};
		};
		class EchelonLeft
		{
			class Fixed
			{
				FormationPositionInfo1[]={-1,0,0,0};
				FormationPositionInfo2[]={0,-1,-1,-0.78539819};
				FormationPositionInfo3[]={1,-1,-1,-0.78539819};
				FormationPositionInfo4[]={2,-1,-1,-1.5707964};
			};
			class Pattern
			{
				FormationPositionInfo1[]={-1,-1,-1,0};
				FormationPositionInfo2[]={0,-1,-1,-0.78539819};
				FormationPositionInfo3[]={1,-1,-1,-0.78539819};
				FormationPositionInfo4[]={2,-1,-1,-1.5707964};
			};
		};
		class EcholonRight
		{
			class Fixed
			{
				FormationPositionInfo1[]={-1,0,0,0};
				FormationPositionInfo2[]={0,1,-1,0.78539819};
				FormationPositionInfo3[]={1,1,-1,0.78539819};
				FormationPositionInfo4[]={2,1,-1,1.5707964};
			};
			class Pattern
			{
				FormationPositionInfo1[]={-1,1,-1,0};
				FormationPositionInfo2[]={0,1,-1,0.78539819};
				FormationPositionInfo3[]={1,1,-1,0.78539819};
				FormationPositionInfo4[]={2,1,-1,1.5707964};
			};
		};
		class Vee
		{
			class Fixed
			{
				FormationPositionInfo1[]={-1,0,0,-0.78539819};
				FormationPositionInfo2[]={0,1,0,0.78539819};
			};
			class Pattern
			{
				FormationPositionInfo1[]={-2,-1,1,-0.78539819};
				FormationPositionInfo2[]={-1,1,1,0.78539819};
			};
		};
		class Line
		{
			class Fixed
			{
				FormationPositionInfo1[]={-1,0,0,0};
				FormationPositionInfo2[]={0,1,0,0};
			};
			class Pattern
			{
				FormationPositionInfo1[]={-2,-1,0,0};
				FormationPositionInfo2[]={-1,1,0,0};
			};
		};
		class Diamond
		{
			class Fixed
			{
				FormationPositionInfo1[]={-1,0,0,0};
			};
			class Pattern
			{
				FormationPositionInfo1[]={-1,0.5,-0.5,0.78539819,0};
				FormationPositionInfo2[]={0,-1,0,-0.78539819,0};
				FormationPositionInfo3[]={1,0.5,-0.5,0,0};
			};
		};
		class File
		{
			class Fixed
			{
				FormationPositionInfo1[]={-1,0,0,0};
			};
			class Pattern
			{
				FormationPositionInfo1[]={-1,0,-0.5,-0.78539819,0};
				FormationPositionInfo2[]={0,0,-0.5,0.78539819,0};
			};
		};
	};
	class East: West
	{
		class formColumnFixed: formColumnFixed
		{
		};
		class Staggered: Staggered
		{
		};
		class Wedge: Wedge
		{
		};
		class EchelonLeft: EchelonLeft
		{
		};
		class EcholonRight: EcholonRight
		{
		};
		class Vee: Vee
		{
		};
		class Line: Line
		{
		};
		class Diamond: Diamond
		{
		};
		class File: File
		{
		};
	};
	class Guer: West
	{
		class formColumnFixed: formColumnFixed
		{
		};
		class Staggered: Staggered
		{
		};
		class Wedge: Wedge
		{
		};
		class EchelonLeft: EchelonLeft
		{
		};
		class EcholonRight: EcholonRight
		{
		};
		class Vee: Vee
		{
		};
		class Line: Line
		{
		};
		class Diamond: Diamond
		{
		};
		class File: File
		{
		};
	};
	class Civ: West
	{
		class formColumnFixed: formColumnFixed
		{
		};
		class Staggered: Staggered
		{
		};
		class Wedge: Wedge
		{
		};
		class EchelonLeft: EchelonLeft
		{
		};
		class EcholonRight: EcholonRight
		{
		};
		class Vee: Vee
		{
		};
		class Line: Line
		{
		};
		class Diamond: Diamond
		{
		};
		class File: File
		{
		};
	};
};
class cfgWaypoints
{
};
class PhysXMaterials
{
	class PhysXMaterialBase
	{
		isDefault=0;
		restitution=0;
		staticFriction=1.5;
		dynamicFriction=1.5;
	};
	class Default: PhysXMaterialBase
	{
		isDefault=1;
		restitution=0;
		staticFriction=1;
		dynamicFriction=0.60000002;
	};
	class Terrain: PhysXMaterialBase
	{
		restitution=0.1;
		staticFriction=0.1;
		dynamicFriction=0.1;
	};
	class Wheel: PhysXMaterialBase
	{
		restitution=0;
		staticFriction=3.5;
		dynamicFriction=3.5;
	};
	class DriveOn: PhysXMaterialBase
	{
		restitution=0;
		staticFriction=0.30000001;
		dynamicFriction=0.30000001;
	};
	class WheelDestroyed: PhysXMaterialBase
	{
		restitution=0;
		staticFriction=2;
		dynamicFriction=2;
	};
	class Ragdoll: PhysXMaterialBase
	{
		restitution=0.30000001;
		staticFriction=3;
		dynamicFriction=3;
	};
	class Grenade: PhysXMaterialBase
	{
		restitution=0.1;
		staticFriction=3;
		dynamicFriction=1.5;
	};
};
class PhysXParams
{
	epeImpulseDamageCoef=30;
	impulseForceRagdollCoef=200;
	impulseTorqueRagdollCoef=100;
	maxRagdollImpulseForceMagnitude=500;
	maxRagdollImpulseTorqueMagnitude=150;
	ragdollUnderwaterBuoyancyCoef=9.6999998;
	ragdollUnderwaterResistanceCoef=0.0049999999;
	ragdollOnCollideSpeedLimit=4;
	ragdollOnCollideMassLimit=200;
	ragdollOnCollideForceCoef=20;
	ragdollOnCollideMaxForce=50;
	ragdollOnCollideMaxOffset=2;
	ragdollOnCollideMaxOffsetSpeed=50;
	ragdollOnCollideVehicleImpulseCoef=2;
	ragdollUnconsciousSleepCoef=1.2;
	ragdollHitTime=0.2;
	ragdollHitForceCoef=10;
	ragdollHitDmgLimit=0;
	ragdollVehicleCollision=0;
};
class RagDollDefaultLimit
{
	value=0;
	restitution=0.89999998;
	hardness=0.5;
};
class RagDollDefaultSpring
{
	enabled=0;
	value=0.5;
	damper=1;
	targetValue=0;
};
class RagDollSphericalJoint
{
	class TwistLimitLow: RagDollDefaultLimit
	{
	};
	class TwistLimitHigh: RagDollDefaultLimit
	{
	};
	class SwingLimit: RagDollDefaultLimit
	{
	};
	class TwistSpring: RagDollDefaultSpring
	{
		enabled=1;
	};
	class SwingSpring: RagDollDefaultSpring
	{
		enabled=1;
		damper=2;
	};
	class JointSpring: RagDollDefaultSpring
	{
		enabled=0;
	};
	type="spherical";
	enableCollision=0;
	projectionDistance=0.050000001;
	projectionMode="point";
};
class RagDollRevoluteJoint
{
	class LimitLow: RagDollDefaultLimit
	{
	};
	class LimitHigh: RagDollDefaultLimit
	{
	};
	class Spring: RagDollDefaultSpring
	{
		enabled=0;
	};
	type="revolute";
	enableCollision=0;
	projectionDistance=0.050000001;
	projectionMode="point";
};
class RagDollD6Joint_PX3
{
	type="D6";
	enableCollision=0;
	projectionDistance=0.050000001;
	projectionMode="point";
	swingLimitY=0;
	swingLimitZ=0;
	swingSpring=0;
	swingDamping=0;
	swingRestitution=0.60000002;
	swingContactDistance=0.050000001;
	twistLimitLower=0;
	twistLimitUpper=0;
	twistSpring=0;
	twistDamping=0;
	twistRestitution=0.60000002;
	twistContactDistance=0.050000001;
	driveSpring=20;
	driveDamping=20;
	driveMaxForce=1000000;
	driveUseAcceleration=1;
	driveLinearVelocity[]={0,0,0};
	driveAngularVelocity[]={0,0,0};
};
class CfgRagDollSkeletons
{
	class BaseRagdoll
	{
		idleAnim="";
		primaryWeaponBone="";
		secondaryWeaponBone="";
		networkBonePrimary="";
		networkBoneSecondary="";
		weaponSleepLinearVelocity=0.1;
		weaponSleepAngularVelocity=0.1;
		weaponDropMinTime=1;
		weaponDropMaxTime=100;
		weaponDistanceLimit=0.050000001;
		weaponDistanceLimitTime=5;
		sleepLinearVelocity=0.050000001;
		sleepAngularVelocity=0.050000001;
		simulateMinTime=1;
		simulateMaxTime=100;
		simulateDistanceLimit=0.050000001;
		simulateDistanceLimitTime=5;
		recoveryBlendTime=0.30000001;
		recoveryCosLimit=0.30000001;
		recoveryDistLimit=0.69999999;
		animBlendTime=0.050000001;
	};
	class Soldier: BaseRagdoll
	{
		primaryWeaponBone="weapon";
		secondaryWeaponBone="launcher";
		networkBonePrimary="chest";
		networkBoneSecondary="pelvis";
		draggingMask="dragging";
		hitMask="hit";
		hitMaskUnderwater="hitUnderwater";
		class WeaponLinkBones
		{
			class LinkBone1
			{
				bone="leftHand";
				canBeDropped=1;
				prefference=1;
			};
			class LinkBone2
			{
				bone="rightHand";
				canBeDropped=1;
				prefference=2;
			};
			class LinkBone3
			{
				bone="chest";
				canBeDropped=1;
				prefference=1;
			};
		};
		class Masks
		{
			class DraggingMask
			{
				name="dragging";
				mask[]=
				{
					
					{
						"pelvis",
						0,
						1
					},
					
					{
						"chest",
						0,
						1
					},
					
					{
						"head",
						0.60000002,
						0
					},
					
					{
						"leftArm",
						1,
						0
					},
					
					{
						"leftForeArm",
						1,
						0
					},
					
					{
						"leftHand",
						1,
						0
					},
					
					{
						"rightArm",
						1,
						0
					},
					
					{
						"rightForeArm",
						1,
						0
					},
					
					{
						"rightHand",
						1,
						0
					},
					
					{
						"leftUpLeg",
						1,
						0
					},
					
					{
						"leftLeg",
						1,
						0
					},
					
					{
						"leftFoot",
						1,
						0
					},
					
					{
						"rightUpLeg",
						1,
						0
					},
					
					{
						"rightLeg",
						1,
						0
					},
					
					{
						"rightFoot",
						1,
						0
					},
					
					{
						"weapon",
						0,
						1
					},
					
					{
						"launcher",
						0,
						1
					}
				};
			};
			class HitMask
			{
				name="hit";
				mask[]=
				{
					
					{
						"pelvis",
						1,
						0
					},
					
					{
						"chest",
						1,
						0
					},
					
					{
						"head",
						1,
						0
					},
					
					{
						"leftArm",
						1,
						0
					},
					
					{
						"leftForeArm",
						1,
						0
					},
					
					{
						"leftHand",
						1,
						0
					},
					
					{
						"rightArm",
						1,
						0
					},
					
					{
						"rightForeArm",
						1,
						0
					},
					
					{
						"rightHand",
						1,
						0
					},
					
					{
						"leftUpLeg",
						1,
						0
					},
					
					{
						"leftLeg",
						1,
						0
					},
					
					{
						"leftFoot",
						1,
						1
					},
					
					{
						"rightUpLeg",
						1,
						0
					},
					
					{
						"rightLeg",
						1,
						0
					},
					
					{
						"rightFoot",
						1,
						1
					},
					
					{
						"weapon",
						0,
						0
					},
					
					{
						"launcher",
						1,
						0
					}
				};
			};
			class HitMaskUnderwater
			{
				name="hitUnderwater";
				mask[]=
				{
					
					{
						"pelvis",
						1,
						1
					},
					
					{
						"chest",
						1,
						1
					},
					
					{
						"head",
						1,
						0
					},
					
					{
						"leftArm",
						1,
						0
					},
					
					{
						"leftForeArm",
						1,
						0
					},
					
					{
						"leftHand",
						1,
						0
					},
					
					{
						"rightArm",
						1,
						0
					},
					
					{
						"rightForeArm",
						1,
						0
					},
					
					{
						"rightHand",
						1,
						0
					},
					
					{
						"leftUpLeg",
						1,
						0
					},
					
					{
						"leftLeg",
						1,
						0
					},
					
					{
						"leftFoot",
						1,
						0
					},
					
					{
						"rightUpLeg",
						1,
						0
					},
					
					{
						"rightLeg",
						1,
						0
					},
					
					{
						"rightFoot",
						1,
						0
					},
					
					{
						"weapon",
						1,
						0
					},
					
					{
						"launcher",
						1,
						0
					}
				};
			};
		};
		class BaseRagdollBone
		{
			material="Ragdoll";
			childrenUseStartTrans=1;
			childrenUseIdleAnim=0;
		};
		class Bones
		{
			class Pelvis: BaseRagdollBone
			{
				name="pelvis";
				type="capsule";
				startBone="pelvis";
				endBone="spine2";
				mass=15;
				radius=0.12;
				networkType="root";
			};
			class Chest: BaseRagdollBone
			{
				name="chest";
				type="capsule";
				startBone="spine1";
				endBone="neck";
				radius=0.16;
				mass=15;
			};
			class Head: BaseRagdollBone
			{
				name="head";
				type="sphere";
				startBone="head";
				mass=8;
				radius=0.16;
			};
			class LeftArm: BaseRagdollBone
			{
				name="leftArm";
				type="capsule";
				startBone="leftArm";
				endBone="leftForeArm";
				mass=8;
			};
			class LeftForeArm: BaseRagdollBone
			{
				name="leftForeArm";
				type="capsule";
				startBone="leftForeArm";
				endBone="leftHand";
				mass=6;
			};
			class LeftHand: BaseRagdollBone
			{
				name="leftHand";
				type="sphere";
				startBone="leftHand";
				mass=6;
				radius=0.079999998;
				childrenUseStartTrans=0;
				childrenUseIdleAnim=1;
				networkType="leftHand";
			};
			class RightArm: BaseRagdollBone
			{
				name="rightArm";
				type="capsule";
				startBone="rightArm";
				endBone="rightForeArm";
				mass=8;
			};
			class RightForeArm: BaseRagdollBone
			{
				name="rightForeArm";
				type="capsule";
				startBone="rightForeArm";
				endBone="rightHand";
				mass=6;
			};
			class RightHand: BaseRagdollBone
			{
				name="rightHand";
				type="sphere";
				startBone="rightHand";
				mass=6;
				radius=0.079999998;
				childrenUseStartTrans=0;
				childrenUseIdleAnim=1;
				networkType="rightHand";
			};
			class LeftUpLeg: BaseRagdollBone
			{
				name="leftUpLeg";
				type="capsule";
				startBone="leftUpLeg";
				endBone="leftLeg";
				mass=15;
			};
			class LeftLeg: BaseRagdollBone
			{
				name="leftLeg";
				type="capsule";
				startBone="leftLeg";
				endBone="leftFoot";
				mass=10;
			};
			class LeftFoot: BaseRagdollBone
			{
				name="leftFoot";
				type="box";
				startBone="leftFoot";
				size[]={0.15000001,0.035,0.07};
				mass=8;
				networkType="leftFoot";
			};
			class RightUpLeg: BaseRagdollBone
			{
				name="rightUpLeg";
				type="capsule";
				startBone="rightUpLeg";
				endBone="rightLeg";
				mass=15;
			};
			class RightLeg: BaseRagdollBone
			{
				name="rightLeg";
				type="capsule";
				startBone="rightLeg";
				endBone="rightFoot";
				mass=10;
			};
			class RightFoot: BaseRagdollBone
			{
				name="rightFoot";
				type="box";
				startBone="rightFoot";
				size[]={0.15000001,0.035,0.07};
				mass=8;
				networkType="rightFoot";
			};
			class Weapon: BaseRagdollBone
			{
				name="weapon";
				type="weapon";
				startBone="weapon";
				endPosRelToStart[]={0,1,0};
				mass=3;
			};
			class Launcher: BaseRagdollBone
			{
				name="launcher";
				type="weapon";
				startBone="launcher";
				endPosRelToStart[]={1,0,0};
				mass=3;
			};
		};
		class JointsPX2
		{
			class Pelvis_Chest_PX2: RagDollSphericalJoint
			{
				name="pelvis_chest";
				bone1="pelvis";
				bone2="chest";
				axis[]={0,1,0.30000001};
				class SwingLimit: SwingLimit
				{
					value=25;
				};
				class TwistLimitLow: TwistLimitLow
				{
					value=-15;
				};
				class TwistLimitHigh: TwistLimitHigh
				{
					value=25;
				};
			};
			class Chest_Head_PX2: RagDollSphericalJoint
			{
				name="chest_head";
				bone1="chest";
				bone2="head";
				class SwingLimit: SwingLimit
				{
					value=20;
				};
				class TwistLimitLow: TwistLimitLow
				{
					value=-15;
				};
				class TwistLimitHigh: TwistLimitHigh
				{
					value=15;
				};
			};
			class Chest_LeftArm_PX2: RagDollSphericalJoint
			{
				name="chest_leftArm";
				bone1="chest";
				bone2="leftArm";
				axis[]={-1,-0,0.5};
				enableCollision=1;
				class SwingLimit: SwingLimit
				{
					value=60;
				};
				class TwistLimitLow: TwistLimitLow
				{
					value=-20;
				};
				class TwistLimitHigh: TwistLimitHigh
				{
					value=20;
				};
			};
			class LeftArm_LeftForeArm_PX2: RagDollRevoluteJoint
			{
				name="leftArm_leftForeArm";
				bone1="leftArm";
				bone2="leftForeArm";
				axis[]={1,-1,0.2};
				class LimitLow: LimitLow
				{
					value=-2;
				};
				class LimitHigh: LimitHigh
				{
					value=60;
				};
			};
			class LeftForeArm_LeftHand_PX2: RagDollSphericalJoint
			{
				name="leftForeArm_leftHand";
				bone1="leftForeArm";
				bone2="leftHand";
				class SwingLimit: SwingLimit
				{
					value=20;
				};
				class TwistLimitLow: TwistLimitLow
				{
					value=-5;
				};
				class TwistLimitHigh: TwistLimitHigh
				{
					value=5;
				};
			};
			class Chest_RightArm_PX2: RagDollSphericalJoint
			{
				name="chest_rightArm";
				bone1="chest";
				bone2="rightArm";
				axis[]={1,-0,0.5};
				enableCollision=1;
				class SwingLimit: SwingLimit
				{
					value=60;
				};
				class TwistLimitLow: TwistLimitLow
				{
					value=-20;
				};
				class TwistLimitHigh: TwistLimitHigh
				{
					value=20;
				};
			};
			class RightArm_RightForeArm_PX2: RagDollRevoluteJoint
			{
				name="rightArm_rightForeArm";
				bone1="rightArm";
				bone2="rightForeArm";
				axis[]={1,1,-0.2};
				class LimitLow: LimitLow
				{
					value=-2;
				};
				class LimitHigh: LimitHigh
				{
					value=60;
				};
			};
			class RightForeArm_RightHand_PX2: RagDollSphericalJoint
			{
				name="rightForeArm_rightHand";
				bone1="rightForeArm";
				bone2="rightHand";
				class SwingLimit: SwingLimit
				{
					value=20;
				};
				class TwistLimitLow: TwistLimitLow
				{
					value=-5;
				};
				class TwistLimitHigh: TwistLimitHigh
				{
					value=5;
				};
			};
			class Pelvis_LeftUpLeg_PX2: RagDollSphericalJoint
			{
				name="pelvis_leftUpLeg";
				bone1="pelvis";
				bone2="leftUpLeg";
				axis[]={-1.5,-1.1,2};
				enableCollision=1;
				class SwingLimit: SwingLimit
				{
					value=45;
				};
				class TwistLimitLow: TwistLimitLow
				{
					value=-10;
				};
				class TwistLimitHigh: TwistLimitHigh
				{
					value=20;
				};
			};
			class LeftUpLeg_LeftLeg_PX2: RagDollRevoluteJoint
			{
				name="leftUpLeg_leftLeg";
				bone1="leftUpLeg";
				bone2="leftLeg";
				axis[]={-1,0,0};
				class LimitLow: LimitLow
				{
					value=-5;
				};
				class LimitHigh: LimitHigh
				{
					value=110;
				};
			};
			class LeftLeg_LeftFoot_PX2: RagDollRevoluteJoint
			{
				name="leftLeg_leftFoot";
				bone1="leftLeg";
				bone2="leftFoot";
				axis[]={-1,0,0};
				class LimitLow: LimitLow
				{
					value=-15;
				};
				class LimitHigh: LimitHigh
				{
					value=45;
				};
			};
			class Pelvis_RightUpLeg_PX2: RagDollSphericalJoint
			{
				name="pelvis_rightUpLeg";
				bone1="pelvis";
				bone2="rightUpLeg";
				axis[]={1.5,-1.1,2};
				enableCollision=1;
				class SwingLimit: SwingLimit
				{
					value=45;
				};
				class TwistLimitLow: TwistLimitLow
				{
					value=-10;
				};
				class TwistLimitHigh: TwistLimitHigh
				{
					value=20;
				};
			};
			class RightUpLeg_RightLeg_PX2: RagDollRevoluteJoint
			{
				name="rightUpLeg_rightLeg";
				bone1="rightUpLeg";
				bone2="rightLeg";
				axis[]={-1,0,0};
				class LimitLow: LimitLow
				{
					value=-5;
				};
				class LimitHigh: LimitHigh
				{
					value=110;
				};
			};
			class RightLeg_RightFoot_PX2: RagDollRevoluteJoint
			{
				name="rightLeg_rightFoot";
				bone1="rightLeg";
				bone2="rightFoot";
				axis[]={-1,0,0};
				class LimitLow: LimitLow
				{
					value=-15;
				};
				class LimitHigh: LimitHigh
				{
					value=45;
				};
			};
		};
		class JointsPX3
		{
			class Pelvis_Chest_PX3: RagDollD6Joint_PX3
			{
				name="pelvis_chest";
				bone1="pelvis";
				bone2="chest";
				axis[]={0,1,0.30000001};
				enableCollision=0;
				swingLimitY=30;
				swingLimitZ=30;
				twistLimitLower=-25;
				twistLimitUpper=25;
				driveSpring=30;
				driveDamping=30;
				driveSpringWater=5;
				driveDampingWater=5;
			};
			class Chest_Head_PX3: RagDollD6Joint_PX3
			{
				name="chest_head";
				bone1="chest";
				bone2="head";
				swingLimitY=45;
				swingLimitZ=45;
				twistLimitLower=-40;
				twistLimitUpper=40;
				driveSpring=15;
				driveDamping=30;
				driveSpringWater=1.5;
				driveDampingWater=3;
				twistSpring=15;
				twistDamping=30;
			};
			class Chest_LeftArm_PX3: RagDollD6Joint_PX3
			{
				name="chest_leftArm";
				bone1="chest";
				bone2="leftArm";
				enableCollision=1;
				swingLimitY=85;
				swingLimitZ=85;
				twistLimitLower=-60;
				twistLimitUpper=60;
				driveSpring=30;
				driveDamping=30;
				driveSpringWater=3;
				driveDampingWater=3;
			};
			class LeftArm_LeftForeArm_PX3: RagDollD6Joint_PX3
			{
				name="leftArm_leftForeArm";
				bone1="leftArm";
				bone2="leftForeArm";
				axis[]={-1,1,-0.2};
				swingLimitY=10;
				swingLimitZ=10;
				twistLimitLower=-5;
				twistLimitUpper=150;
				driveSpring=10;
				driveDamping=10;
				driveSpringWater=1;
				driveDampingWater=1;
			};
			class LeftForeArm_LeftHand_PX3: RagDollD6Joint_PX3
			{
				name="leftForeArm_leftHand";
				bone1="leftForeArm";
				bone2="leftHand";
				swingLimitY=10;
				swingLimitZ=10;
				twistLimitLower=-20;
				twistLimitUpper=20;
				driveSpring=10;
				driveDamping=10;
				driveSpringWater=1;
				driveDampingWater=1;
			};
			class Chest_RightArm_PX3: RagDollD6Joint_PX3
			{
				name="chest_rightArm";
				bone1="chest";
				bone2="rightArm";
				enableCollision=1;
				swingLimitY=85;
				swingLimitZ=85;
				twistLimitLower=-60;
				twistLimitUpper=60;
				driveSpring=30;
				driveDamping=30;
				driveSpringWater=3;
				driveDampingWater=3;
			};
			class RightArm_RightForeArm_PX3: RagDollD6Joint_PX3
			{
				name="rightArm_rightForeArm";
				bone1="rightArm";
				bone2="rightForeArm";
				axis[]={-1,-1,0.2};
				swingLimitY=10;
				swingLimitZ=10;
				twistLimitLower=-5;
				twistLimitUpper=150;
				driveSpring=10;
				driveDamping=10;
				driveSpringWater=1;
				driveDampingWater=1;
			};
			class RightForeArm_RightHand_PX3: RagDollD6Joint_PX3
			{
				name="rightForeArm_rightHand";
				bone1="rightForeArm";
				bone2="rightHand";
				swingLimitY=10;
				swingLimitZ=10;
				twistLimitLower=-20;
				twistLimitUpper=20;
				driveSpring=10;
				driveDamping=10;
				driveSpringWater=1;
				driveDampingWater=1;
			};
			class Pelvis_LeftUpLeg_PX3: RagDollD6Joint_PX3
			{
				name="pelvis_leftUpLeg";
				bone1="pelvis";
				bone2="leftUpLeg";
				enableCollision=1;
				swingLimitY=35;
				swingLimitZ=35;
				twistLimitLower=-10;
				twistLimitUpper=60;
				driveSpring=30;
				driveDamping=30;
				driveSpringWater=3;
				driveDampingWater=3;
				twistDamping=30;
			};
			class LeftUpLeg_LeftLeg_PX3: RagDollD6Joint_PX3
			{
				name="leftUpLeg_leftLeg";
				bone1="leftUpLeg";
				bone2="leftLeg";
				axis[]={1,0,0};
				swingLimitY=10;
				swingLimitZ=10;
				twistLimitLower=-5;
				twistLimitUpper=120;
				driveSpring=20;
				driveDamping=20;
				driveSpringWater=2;
				driveDampingWater=2;
			};
			class LeftLeg_LeftFoot_PX3: RagDollD6Joint_PX3
			{
				name="leftLeg_leftFoot";
				bone1="leftLeg";
				bone2="leftFoot";
				axis[]={1,0,0};
				swingLimitY=10;
				swingLimitZ=10;
				twistLimitLower=-15;
				twistLimitUpper=45;
				driveSpring=20;
				driveDamping=20;
				driveSpringWater=2;
				driveDampingWater=2;
			};
			class Pelvis_RightUpLeg_PX3: RagDollD6Joint_PX3
			{
				name="pelvis_rightUpLeg";
				bone1="pelvis";
				bone2="rightUpLeg";
				enableCollision=1;
				swingLimitY=35;
				swingLimitZ=35;
				twistLimitLower=-10;
				twistLimitUpper=60;
				driveSpring=30;
				driveDamping=30;
				driveSpringWater=3;
				driveDampingWater=3;
				twistDamping=30;
			};
			class RightUpLeg_RightLeg_PX3: RagDollD6Joint_PX3
			{
				name="rightUpLeg_rightLeg";
				bone1="rightUpLeg";
				bone2="rightLeg";
				axis[]={1,0,0};
				swingLimitY=10;
				swingLimitZ=10;
				twistLimitLower=-5;
				twistLimitUpper=120;
				driveSpring=20;
				driveDamping=20;
				driveSpringWater=2;
				driveDampingWater=2;
			};
			class RightLeg_RightFoot_PX3: RagDollD6Joint_PX3
			{
				name="rightLeg_rightFoot";
				bone1="rightLeg";
				bone2="rightFoot";
				axis[]={1,0,0};
				swingLimitY=10;
				swingLimitZ=10;
				twistLimitLower=-15;
				twistLimitUpper=45;
				driveSpring=20;
				driveDamping=20;
				driveSpringWater=2;
				driveDampingWater=2;
			};
		};
	};
};
class CfgVideoOptions
{
	class Visibility
	{
		minValue=500;
		maxValue=12000;
	};
	class ObjectsVisibility
	{
		minValue=500;
		maxValue=12000;
	};
	class ShadowsVisibility
	{
		minValue=50;
		maxValue=200;
	};
	class HDR
	{
		class Low
		{
			text="$STR_A3_OPTIONS_LOW";
			value=8;
		};
		class Normal
		{
			text="$STR_A3_OPTIONS_STANDARD";
			value=16;
		};
	};
	class PPAA
	{
		class Disabled
		{
			textMethod="$STR_A3_OPTIONS_DISABLED";
			textQuality="";
			ppaaType=0;
			ppaaLevel=0;
			needsDX11=0;
		};
		class FXAALow
		{
			textMethod="$STR_A3_OPTIONS_FXAA";
			textQuality="$STR_A3_OPTIONS_STANDARD";
			ppaaType=1;
			ppaaLevel=0;
			needsDX11=0;
		};
		class FXAANormal
		{
			textMethod="$STR_A3_OPTIONS_FXAA";
			textQuality="$STR_A3_OPTIONS_HIGH";
			ppaaType=1;
			ppaaLevel=1;
			needsDX11=0;
		};
		class FXAAHigh
		{
			textMethod="$STR_A3_OPTIONS_FXAA";
			textQuality="$STR_A3_OPTIONS_VERYHIGH";
			ppaaType=1;
			ppaaLevel=2;
			needsDX11=0;
		};
		class FXAAVeryHigh
		{
			textMethod="$STR_A3_OPTIONS_FXAA";
			textQuality="$STR_A3_OPTIONS_ULTRA";
			ppaaType=1;
			ppaaLevel=3;
			needsDX11=0;
		};
		class SMAALow
		{
			textMethod="$STR_A3_OPTIONS_SMAA";
			textQuality="$STR_A3_OPTIONS_STANDARD";
			ppaaType=2;
			ppaaLevel=0;
			needsDX11=0;
		};
		class SMAANormal
		{
			textMethod="$STR_A3_OPTIONS_SMAA";
			textQuality="$STR_A3_OPTIONS_HIGH";
			ppaaType=2;
			ppaaLevel=1;
			needsDX11=0;
		};
		class SMAAHigh
		{
			textMethod="$STR_A3_OPTIONS_SMAA";
			textQuality="$STR_A3_OPTIONS_VERYHIGH";
			ppaaType=2;
			ppaaLevel=2;
			needsDX11=0;
		};
		class SMAAVeryHigh
		{
			textMethod="$STR_A3_OPTIONS_SMAA";
			textQuality="$STR_A3_OPTIONS_ULTRA";
			ppaaType=2;
			ppaaLevel=3;
			needsDX11=0;
		};
		class CMAANormal
		{
			textMethod="$STR_A3_OPTIONS_CMAA";
			textQuality="";
			ppaaType=3;
			ppaaLevel=0;
			needsDX11=1;
		};
	};
	class Particles
	{
		class Low
		{
			text="$STR_A3_OPTIONS_LOW";
			particlesSoftLimit=7000;
			particlesHardLimit=9000;
			smokeGenMinDist=50;
			smokeGenMaxDist=200;
			smokeSizeCoef=2;
			smokeIntervalCoef=4;
			smokeZoomCoef=1.42857;
			highQualityShader=0;
			numFullSizeParticles=20;
		};
		class Normal
		{
			text="$STR_A3_OPTIONS_STANDARD";
			particlesSoftLimit=10000;
			particlesHardLimit=12000;
			smokeGenMinDist=100;
			smokeGenMaxDist=400;
			smokeSizeCoef=2;
			smokeIntervalCoef=4;
			smokeZoomCoef=1.42857;
			highQualityShader=1;
			numFullSizeParticles=40;
		};
		class High
		{
			text="$STR_A3_OPTIONS_HIGH";
			particlesSoftLimit=13000;
			particlesHardLimit=15000;
			smokeGenMinDist=200;
			smokeGenMaxDist=800;
			smokeSizeCoef=2;
			smokeIntervalCoef=4;
			smokeZoomCoef=1.42857;
			highQualityShader=1;
			numFullSizeParticles=60;
		};
	};
	class DynamicLights
	{
		class VeryLow
		{
			text="$STR_A3_OPTIONS_LOW";
			value=4;
		};
		class Low
		{
			text="$STR_A3_OPTIONS_STANDARD";
			value=6;
		};
		class Normal
		{
			text="$STR_A3_OPTIONS_HIGH";
			value=8;
		};
		class High
		{
			text="$STR_A3_OPTIONS_VERYHIGH";
			value=12;
		};
		class VeryHigh
		{
			text="$STR_A3_OPTIONS_ULTRA";
			value=16;
		};
	};
	class AnisotropicFiltering
	{
		class Disabled
		{
			text="$STR_A3_OPTIONS_DISABLED";
			value=0;
		};
		class VeryLow
		{
			text="$STR_A3_OPTIONS_LOW";
			value=2;
		};
		class Low
		{
			text="$STR_A3_OPTIONS_STANDARD";
			value=4;
		};
		class Normal
		{
			text="$STR_A3_OPTIONS_HIGH";
			value=8;
		};
		class High
		{
			text="$STR_A3_OPTIONS_VERYHIGH";
			value=12;
		};
		class VeryHigh
		{
			text="$STR_A3_OPTIONS_ULTRA";
			value=16;
		};
	};
	class PiP
	{
		class Disabled
		{
			text="$STR_A3_OPTIONS_DISABLED";
			value=0;
		};
		class VeryLow
		{
			text="$STR_A3_OPTIONS_LOW";
			value=500;
		};
		class Low
		{
			text="$STR_A3_OPTIONS_STANDARD";
			value=800;
		};
		class Normal
		{
			text="$STR_A3_OPTIONS_HIGH";
			value=1000;
		};
		class High
		{
			text="$STR_A3_OPTIONS_VERYHIGH";
			value=1500;
		};
		class VeryHigh
		{
			text="$STR_A3_OPTIONS_ULTRA";
			value=2000;
		};
	};
	class TextureQuality
	{
		class VeryLow
		{
			text="$STR_A3_OPTIONS_LOW";
			mipBias=2;
			vramNeeded=0;
		};
		class Low
		{
			text="$STR_A3_OPTIONS_STANDARD";
			mipBias=1.5;
			vramNeeded=256;
		};
		class Normal
		{
			text="$STR_A3_OPTIONS_HIGH";
			mipBias=1;
			vramNeeded=384;
		};
		class High
		{
			text="$STR_A3_OPTIONS_VERYHIGH";
			mipBias=0.5;
			vramNeeded=512;
		};
		class VeryHigh
		{
			text="$STR_A3_OPTIONS_ULTRA";
			mipBias=0;
			vramNeeded=796;
		};
	};
	class ObjectsQuality
	{
		class VeryLow
		{
			text="$STR_A3_OPTIONS_LOW";
			value=400000;
		};
		class Low
		{
			text="$STR_A3_OPTIONS_STANDARD";
			value=600000;
		};
		class Normal
		{
			text="$STR_A3_OPTIONS_HIGH";
			value=900000;
		};
		class High
		{
			text="$STR_A3_OPTIONS_VERYHIGH";
			value=1300000;
		};
		class VeryHigh
		{
			text="$STR_A3_OPTIONS_ULTRA";
			value=1800000;
		};
	};
	class TerrainQuality
	{
		class VeryLow
		{
			text="$STR_A3_OPTIONS_LOW";
			terrainGrid=50;
		};
		class Low
		{
			text="$STR_A3_OPTIONS_STANDARD";
			terrainGrid=25;
		};
		class Normal
		{
			text="$STR_A3_OPTIONS_HIGH";
			terrainGrid=12.5;
		};
		class High
		{
			text="$STR_A3_OPTIONS_VERYHIGH";
			terrainGrid=6.25;
		};
		class VeryHigh
		{
			text="$STR_A3_OPTIONS_ULTRA";
			terrainGrid=3.125;
		};
	};
	class CloudQuality
	{
		class VeryLow
		{
			text="$STR_A3_OPTIONS_LOW";
			value=32;
		};
		class Low
		{
			text="$STR_A3_OPTIONS_STANDARD";
			value=48;
		};
		class Normal
		{
			text="$STR_A3_OPTIONS_HIGH";
			value=64;
		};
		class High
		{
			text="$STR_A3_OPTIONS_VERYHIGH";
			value=96;
		};
		class VeryHigh
		{
			text="$STR_A3_OPTIONS_ULTRA";
			value=128;
		};
	};
	class WaterSSReflectionsQuality
	{
		class Disabled
		{
			text="$STR_A3_OPTIONS_DISABLED";
			value=0;
		};
		class Low
		{
			text="$STR_A3_OPTIONS_STANDARD";
			value=0.30000001;
		};
		class Normal
		{
			text="$STR_A3_OPTIONS_HIGH";
			value=0.5;
		};
		class High
		{
			text="$STR_A3_OPTIONS_VERYHIGH";
			value=1;
		};
	};
	class ShadowQuality
	{
		class Disabled
		{
			text="$STR_A3_OPTIONS_DISABLED";
			shadowType=0;
			textureSize=0;
			shaderQuality=0;
			cascadeLayers=0;
		};
		class VeryLow
		{
			text="$STR_A3_OPTIONS_LOW";
			shadowType=2;
			textureSize=1024;
			shaderQuality=0;
			cascadeLayers=2;
		};
		class Low
		{
			text="$STR_A3_OPTIONS_STANDARD";
			shadowType=2;
			textureSize=1024;
			shaderQuality=1;
			cascadeLayers=3;
		};
		class Normal
		{
			text="$STR_A3_OPTIONS_HIGH";
			shadowType=2;
			textureSize=1024;
			shaderQuality=2;
			cascadeLayers=4;
		};
		class High
		{
			text="$STR_A3_OPTIONS_VERYHIGH";
			shadowType=2;
			textureSize=2048;
			shaderQuality=2;
			cascadeLayers=4;
		};
		class VeryHigh
		{
			text="$STR_A3_OPTIONS_ULTRA";
			shadowType=2;
			textureSize=2048;
			shaderQuality=3;
			cascadeLayers=4;
		};
	};
	class ATOCQuality
	{
		class Disabled
		{
			text="$STR_A3_OPTIONS_DISABLED";
			grass=0;
			oldTrees=0;
			newTrees=0;
			other=0;
		};
		class Grass: Disabled
		{
			text="$STR_ATOC_GRASS";
			grass=1;
			other=1;
		};
		class OldTree: Disabled
		{
			text="$STR_ATOC_TREEA2";
			oldTrees=1;
			other=1;
		};
		class OldTreeGrass: Disabled
		{
			text="$STR_ATOC_TREEA2_GRASS";
			grass=1;
			oldTrees=1;
			other=1;
		};
		class NewTree: Disabled
		{
			text="$STR_ATOC_TREEOA";
			newTrees=1;
			other=1;
		};
		class NewTreeGrass: Disabled
		{
			text="$STR_ATOC_TREEOA_GRASS";
			grass=1;
			newTrees=1;
			other=1;
		};
		class OldTreeNewTree: Disabled
		{
			text="$STR_ATOC_TREEOA_TREEA2";
			oldTrees=1;
			newTrees=1;
			other=1;
		};
		class All: Disabled
		{
			text="$STR_ATOC_TREEOA_TREEA2_GRASS";
			grass=1;
			oldTrees=1;
			newTrees=1;
			other=1;
		};
	};
	class PPSSAOQuality
	{
		class Disabled
		{
			textMethod="$STR_A3_OPTIONS_DISABLED";
			textQuality="";
			value=0;
			needsDX11=0;
		};
		class HDAOLow
		{
			textMethod="$STR_A3_OPTIONS_HDAO";
			textQuality="$STR_A3_OPTIONS_LOW";
			value=4;
			needsDX11=0;
		};
		class HDAOStandard
		{
			textMethod="$STR_A3_OPTIONS_HDAO";
			textQuality="$STR_A3_OPTIONS_STANDARD";
			value=5;
			needsDX11=0;
		};
		class HDAOHigh
		{
			textMethod="$STR_A3_OPTIONS_HDAO";
			textQuality="$STR_A3_OPTIONS_HIGH";
			value=6;
			needsDX11=0;
		};
		class HBAOPlusStandard
		{
			textMethod="$STR_A3_OPTIONS_HBAO_PLUS";
			textQuality="$STR_A3_OPTIONS_STANDARD";
			value=7;
			needsDX11=1;
		};
		class HBAOPlusHigh
		{
			textMethod="$STR_A3_OPTIONS_HBAO_PLUS";
			textQuality="$STR_A3_OPTIONS_HIGH";
			value=8;
			needsDX11=1;
		};
	};
	class PPCausticsQuality
	{
		class Disabled
		{
			text="$STR_A3_OPTIONS_DISABLED";
			value=0;
		};
		class Enabled
		{
			text="$STR_A3_OPTIONS_ENABLED";
			value=1;
		};
	};
	class PPBloom
	{
		minValue=0;
		maxValue=2;
	};
	class PPDOF
	{
		minValue=0;
		maxValue=2;
	};
	class PPRotBlur
	{
		minValue=0;
		maxValue=2;
	};
	class PPRadialBlur
	{
		minValue=0;
		maxValue=2;
	};
	class PPSharpen
	{
		minValue=0;
		maxValue=2;
	};
	class PPBrightness
	{
		minValue=0;
		maxValue=2;
	};
	class PPContrast
	{
		minValue=0;
		maxValue=2;
	};
	class PPSaturation
	{
		minValue=0;
		maxValue=2;
	};
	class PPColorPresets
	{
		class Default
		{
			text="$STR_DISP_DEFAULT";
			brightness=1;
			contrast=1;
			saturation=1;
		};
		class Custom
		{
			text="$STR_DISP_OPT_ASPECT_RATIO_CUSTOM";
			brightness=-10000;
			contrast=-10000;
			saturation=-10000;
		};
	};
	class DefaultSettings
	{
		text="Default";
		visibility=1600;
		objectVisibility=1200;
		shadowVisibility=100;
		hdr="Normal";
		ppaa="Disabled";
		ppaaAlternative="Disabled";
		ppSharpen=0;
		particles="Normal";
		dynamicLights="Normal";
		anisotropicFiltering="Normal";
		pip="Normal";
		textureQuality="Normal";
		objectsQuality="Normal";
		terrainQuality="Normal";
		cloudQuality="Normal";
		waterSSReflectionsQuality="Disabled";
		shadowQuality="Normal";
		atocQuality="All";
		ppSSAOQuality="HDAOLow";
		ppSSAOQualityAlternative="HDAOLow";
		ppCausticsQuality="Enabled";
		ppBloom=1;
		ppDOF=1;
		ppRotBlur=1;
		ppRadialBlur=1;
		postProcessQuality=3;
		multiSampleCount=4;
	};
	class OverallSettings
	{
		class VeryLow: DefaultSettings
		{
			text="$STR_A3_OPTIONS_LOW";
			visibility=1000;
			objectVisibility=800;
			shadowVisibility=100;
			hdr="Normal";
			ppaa="Disabled";
			ppaaAlternative="Disabled";
			particles="Low";
			dynamicLights="VeryLow";
			anisotropicFiltering="Disabled";
			pip="VeryLow";
			textureQuality="VeryLow";
			objectsQuality="VeryLow";
			terrainQuality="Low";
			cloudQuality="VeryLow";
			waterSSReflectionsQuality="Disabled";
			shadowQuality="Low";
			atocQuality="Disabled";
			ppSSAOQuality="Disabled";
			ppSSAOQualityAlternative="Disabled";
			ppCausticsQuality="Disabled";
			ppBloom=0;
			ppDOF=0;
			ppRotBlur=0;
			ppRadialBlur=0;
			ppSharpen=0;
			postProcessQuality=0;
			multiSampleCount=1;
		};
		class Low: DefaultSettings
		{
			text="$STR_A3_OPTIONS_STANDARD";
			visibility=1600;
			objectVisibility=1300;
			shadowVisibility=100;
			hdr="Normal";
			ppaa="Disabled";
			ppaaAlternative="Disabled";
			particles="Normal";
			dynamicLights="Low";
			anisotropicFiltering="Low";
			pip="Low";
			textureQuality="Low";
			objectsQuality="Low";
			terrainQuality="Low";
			cloudQuality="Low";
			waterSSReflectionsQuality="Disabled";
			shadowQuality="Normal";
			atocQuality="Disabled";
			ppSSAOQuality="Disabled";
			ppSSAOQualityAlternative="Disabled";
			ppCausticsQuality="Enabled";
			ppBloom=1;
			ppDOF=1;
			ppRotBlur=1;
			ppRadialBlur=1;
			ppSharpen=0;
			postProcessQuality=2;
			multiSampleCount=1;
		};
		class Normal: DefaultSettings
		{
			text="$STR_A3_OPTIONS_HIGH";
			visibility=2200;
			objectVisibility=1500;
			shadowVisibility=100;
			hdr="Normal";
			ppaa="CMAANormal";
			ppaaAlternative="FXAALow";
			particles="Normal";
			dynamicLights="Normal";
			anisotropicFiltering="Normal";
			pip="Low";
			textureQuality="Normal";
			objectsQuality="Normal";
			terrainQuality="Normal";
			cloudQuality="Normal";
			waterSSReflectionsQuality="Low";
			shadowQuality="Normal";
			atocQuality="All";
			ppSSAOQuality="HDAOLow";
			ppSSAOQualityAlternative="HDAOLow";
			ppCausticsQuality="Enabled";
			ppBloom=1;
			ppDOF=1;
			ppRotBlur=1;
			ppRadialBlur=1;
			ppSharpen=1;
			postProcessQuality=3;
			multiSampleCount=2;
		};
		class High: DefaultSettings
		{
			text="$STR_A3_OPTIONS_VERYHIGH";
			visibility=3000;
			objectVisibility=1900;
			shadowVisibility=100;
			hdr="Normal";
			ppaa="CMAANormal";
			ppaaAlternative="FXAANormal";
			particles="High";
			dynamicLights="High";
			anisotropicFiltering="High";
			pip="Normal";
			textureQuality="High";
			objectsQuality="High";
			terrainQuality="Normal";
			cloudQuality="High";
			waterSSReflectionsQuality="Normal";
			shadowQuality="High";
			atocQuality="All";
			ppSSAOQuality="HBAOPlusStandard";
			ppSSAOQualityAlternative="HDAOStandard";
			ppCausticsQuality="Enabled";
			ppBloom=1;
			ppDOF=1;
			ppRotBlur=1;
			ppRadialBlur=1;
			ppSharpen=1;
			postProcessQuality=4;
			multiSampleCount=4;
		};
		class VeryHigh: DefaultSettings
		{
			text="$STR_A3_OPTIONS_ULTRA";
			visibility=3800;
			objectVisibility=2300;
			shadowVisibility=100;
			hdr="Normal";
			ppaa="SMAAHigh";
			ppaaAlternative="SMAAHigh";
			particles="High";
			dynamicLights="VeryHigh";
			anisotropicFiltering="VeryHigh";
			pip="Normal";
			textureQuality="VeryHigh";
			objectsQuality="VeryHigh";
			terrainQuality="VeryHigh";
			cloudQuality="VeryHigh";
			waterSSReflectionsQuality="High";
			shadowQuality="VeryHigh";
			atocQuality="All";
			ppSSAOQuality="HBAOPlusHigh";
			ppSSAOQualityAlternative="HDAOHigh";
			ppCausticsQuality="Enabled";
			ppBloom=1;
			ppDOF=1;
			ppRotBlur=1;
			ppRadialBlur=1;
			ppSharpen=1;
			postProcessQuality=5;
			multiSampleCount=8;
		};
	};
	class Benchmark
	{
		gpuDefaultResult=1000;
		gpuResultLimits[]={300,150,100,45,0};
		cpuDefaultResult=1000;
		cpuResultLimits[]={250,180,130,100,0};
	};
};
class CfgSurfaceCharacters
{
	class Empty
	{
		probability[]={};
		names[]={};
	};
};
class CfgSurfaces
{
	class Default
	{
		files="default";
		rough=0.075000003;
		dust=0.1;
		lucidity=1;
		isWater=0;
		maxSpeedCoef=1;
		friction=0.89999998;
		restitution=0;
		soundEnviron="normalExt";
		character="Empty";
		impact="default_Mat";
		grassCover=0;
		surfaceFriction=2;
		tracksAlpha=1;
		transparency=-1;
		AIAvoidStance=0;
	};
	class Water
	{
		files="more_anim*";
		rough=0;
		dust=0;
		lucidity=1;
		maxSpeedCoef=1;
		soundEnviron="water";
		friction=0.89999998;
		restitution=0;
		isWater=1;
		character="Empty";
		impact="hitWater";
		grassCover=0;
	};
};
class CfgDefaultSettings
{
	defaultVisibility=1600;
	defaultTerrainGrid=10;
	defaultObjectViewDistance=1200;
	hazeDefaultDistance=10000;
	class UserInfo
	{
		version=1;
		blood=1;
		volumeCD=5;
		volumeFX=5;
		volumeSpeech=5;
		singleVoice=0;
		gamma=1;
		brightness=1;
	};
};
class CfgPatches
{
	class Core
	{
		requiredAddons[]={};
		requiredVersion=0.1;
		units[]=
		{
			"ArtilleryTarget",
			"ArtilleryTargetW",
			"ArtilleryTargetE",
			"SuppressTarget",
			"PaperCar",
			"FireSectorTarget",
			"HeliH",
			"Land_VASICore"
		};
		weapons[]=
		{
			"FakeWeapon"
		};
	};
};
class CfgFontFamilies
{
	access=0;
	class LucidaConsoleB
	{
		fonts[]=
		{
			"\core\data\fonts\lucidaConsoleB8",
			"\core\data\fonts\lucidaConsoleB11"
		};
	};
	class TahomaB
	{
		fonts[]=
		{
			"\core\data\fonts\tahomab16"
		};
	};
};
class CfgFonts
{
};
class UserActionsConflictGroups
{
	class ActionGroups
	{
		basic[]=
		{
			"ToggleWeapons",
			"SwitchWeapon",
			"DefaultAction",
			"ReloadMagazine",
			"LockTarget",
			"RevealTarget",
			"TacticalPing",
			"PrevAction",
			"NextAction",
			"Action",
			"ActionContext",
			"ActionFreeLook",
			"Headlights",
			"NightVision",
			"Binocular",
			"Compass",
			"CompassToggle",
			"uavView",
			"uavViewToggle",
			"Watch",
			"WatchToggle",
			"MiniMap",
			"MiniMapToggle",
			"ShowMap",
			"HideMap",
			"Help",
			"TimeInc",
			"TimeDec",
			"CopyVersion",
			"OpenDlcScreen",
			"Optics",
			"PersonView",
			"TacticalView",
			"ZoomIn",
			"ZoomInToggle",
			"ZoomOut",
			"zoomOutToggle",
			"ZoomContIn",
			"ZoomContOut",
			"ZeroingUp",
			"ZeroingDown",
			"LookAround",
			"LookAroundToggle",
			"LookLeftDown",
			"LookDown",
			"LookRightDown",
			"LookLeft",
			"LookCenter",
			"LookRight",
			"LookLeftUp",
			"LookUp",
			"LookRightUp",
			"LookLeftCont",
			"LookRightCont",
			"LookDownCont",
			"LookUpCont",
			"PrevChannel",
			"NextChannel",
			"Chat",
			"VoiceOverNet",
			"PushToTalk",
			"PushToTalkAll",
			"PushToTalkSide",
			"PushToTalkCommand",
			"PushToTalkGroup",
			"PushToTalkVehicle",
			"PushToTalkDirect",
			"CommandingMenu1",
			"CommandingMenu2",
			"CommandingMenu3",
			"CommandingMenu4",
			"CommandingMenu5",
			"CommandingMenu6",
			"CommandingMenu7",
			"CommandingMenu8",
			"CommandingMenu9",
			"CommandingMenu0",
			"SelectGroupUnit1",
			"SelectGroupUnit2",
			"SelectGroupUnit3",
			"SelectGroupUnit4",
			"SelectGroupUnit5",
			"SelectGroupUnit6",
			"SelectGroupUnit7",
			"SelectGroupUnit8",
			"SelectGroupUnit9",
			"SelectGroupUnit0",
			"GroupPagePrev",
			"GroupPageNext",
			"SelectTeamRed",
			"SelectTeamGreen",
			"SelectTeamBlue",
			"SelectTeamYellow",
			"SelectTeamWhite",
			"SetTeamRed",
			"SetTeamGreen",
			"SetTeamBlue",
			"SetTeamYellow",
			"SetTeamWhite",
			"NetworkStats",
			"SelectAll",
			"Turbo",
			"TurboToggle",
			"Slow",
			"HoldBreath",
			"IngamePause",
			"MenuSelect",
			"ForceCommandingMode",
			"SwitchCommand",
			"SwapGunner",
			"CancelAction",
			"CommandWatch",
			"TeamSwitch",
			"TeamSwitchPrev",
			"TeamSwitchNext",
			"Gear",
			"Cheat1",
			"Cheat2",
			"Diary",
			"Surrender",
			"GetOver",
			"TurretElevationUp",
			"TurretElevationDown"
		};
		ManBasic[]=
		{
			"TempRaiseWeapon",
			"ToggleRaiseWeapon",
			"Handgun",
			"Salute",
			"SitDown",
			"LockTargets",
			"LockEmptyTargets"
		};
		VehBasic[]=
		{
			"Fire",
			"VehicleTurbo",
			"HeliManualFire",
			"VehLockTargets",
			"VehLockEmptyTargets",
			"GetOut",
			"Eject",
			"GunElevUp",
			"GunElevDown",
			"GunElevSlow",
			"GunElevAuto"
		};
		ManMoveGround[]=
		{
			"AimUp",
			"AimDown",
			"AimLeft",
			"AimRight",
			"MoveForward",
			"MoveBack",
			"TurnLeft",
			"TurnRight",
			"MoveUp",
			"MoveDown",
			"MoveFastForward",
			"MoveSlowForward",
			"MoveLeft",
			"MoveRight",
			"EvasiveLeft",
			"EvasiveRight",
			"Stand",
			"Crouch",
			"Prone",
			"LeanLeft",
			"LeanRight",
			"LeanLeftToggle",
			"LeanRightToggle",
			"WalkRunToggle",
			"WalkRunTemp"
		};
		ManMoveUnderwater[]=
		{
			"SwimUp",
			"SwimDown",
			"AimUp",
			"AimDown",
			"AimLeft",
			"AimRight",
			"MoveForward",
			"MoveBack",
			"TurnLeft",
			"TurnRight",
			"MoveUp",
			"MoveDown",
			"MoveFastForward",
			"MoveSlowForward",
			"MoveLeft",
			"MoveRight"
		};
		AimingHead[]=
		{
			"AimHeadUp",
			"AimHeadDown",
			"AimHeadLeft",
			"AimHeadRight"
		};
		AirCraft[]=
		{
			"HeliUp",
			"HeliDown",
			"HeliThrottlePos",
			"HeliThrottleNeg",
			"HeliLeft",
			"HeliRight",
			"AirBankLeft",
			"AirBankRight",
			"HeliRudderLeft",
			"HeliRudderRight",
			"HeliForward",
			"HeliBack",
			"HeliFastForward",
			"AutoHover",
			"AutoHoverCancel",
			"LandGear",
			"LandGearUp",
			"FlapsDown",
			"FlapsUp"
		};
		Heli[]=
		{
			"HeliCollectiveRaise",
			"HeliCollectiveLower",
			"HeliCollectiveRaiseCont",
			"HeliCollectiveLowerCont",
			"HeliLeft",
			"HeliRight",
			"HeliCyclicLeft",
			"HeliCyclicRight",
			"HeliRudderLeft",
			"HeliRudderRight",
			"CyclicForward",
			"CyclicBack",
			"HeliFastForward",
			"AutoHover",
			"AutoHoverCancel",
			"LandGear",
			"LandGearUp",
			"FlapsDown",
			"FlapsUp",
			"HelicopterTrimOn",
			"HelicopterTrimOff",
			"HeliWheelsBrake",
			"HeliTrimLeft",
			"HeliTrimRight",
			"HeliTrimForward",
			"HeliTrimBackward",
			"HeliTrimRudderLeft",
			"HeliTrimRudderRight",
			"HeliRopeAction"
		};
		CarMovement[]=
		{
			"CarLeft",
			"CarRight",
			"CarLinearLeft",
			"CarLinearRight",
			"CarWheelLeft",
			"CarWheelRight",
			"CarForward",
			"CarBack",
			"CarHandBrake",
			"CarFastForward",
			"CarSlowForward"
		};
		CarFreelook[]=
		{
			"CarAimUp",
			"CarAimDown",
			"CarAimLeft",
			"CarAimRight"
		};
		Tank[]=
		{
			"TurnIn",
			"TurnOut"
		};
		SeaGull[]=
		{
			"SeagullUp",
			"SeagullDown",
			"SeagullForward",
			"SeagullBack",
			"SeagullFastForward"
		};
		FreeHeadMove[]=
		{
			"FreeHeadMove"
		};
		HeadMove[]=
		{
			"LookShiftLeftCont",
			"LookShiftRightCont",
			"LookShiftUpCont",
			"LookShiftDownCont",
			"LookShiftForwardCont",
			"LookShiftBackCont",
			"LookRollLeftCont",
			"LookRollRightCont",
			"LookShiftLeft",
			"LookShiftRight",
			"LookShiftUp",
			"LookShiftDown",
			"LookShiftForward",
			"LookRollLeft",
			"LookRollRight",
			"LookShiftBack",
			"LookShiftCenter"
		};
		Command[]=
		{
			"CommandLeft",
			"CommandRight",
			"CommandForward",
			"CommandBack",
			"CommandFast",
			"CommandSlow",
			"SwitchGunnerWeapon"
		};
		buldozer[]=
		{
			"BuldSwitchCamera",
			"BuldFreeLook",
			"BuldSelect",
			"BuldResetCamera",
			"BuldMagnetizePoints",
			"BuldMagnetizePlanes",
			"BuldMagnetizeYFixed",
			"BuldTerrainRaise1m",
			"buldTerrainRaise10cm",
			"BuldTerrainLower1m",
			"BuldTerrainLower10cm",
			"BuldTerrainRaise5m",
			"BuldTerrainRaise50cm",
			"BuldTerrainLower5m",
			"BuldTerrainLower50cm",
			"BuldTerrainShowNode",
			"BuldSelectionType",
			"BuldLeft",
			"BuldRight",
			"BuldForward",
			"BuldBack",
			"BuldMoveLeft",
			"BuldMoveRight",
			"BuldMoveForward",
			"BuldMoveBack",
			"BuldTurbo",
			"BuldUp",
			"BuldDown",
			"BuldLookLeft",
			"BuldLookRight",
			"BuldLookUp",
			"BuldLookDown",
			"BuldZoomIn",
			"BuldZoomOut",
			"BuldTextureInfo",
			"BuldBrushRatio",
			"BuldBrushStrength",
			"BuldBrushSmooth",
			"BuldBrushRandomize",
			"BuldBrushSetHeight",
			"BuldBrushOuter",
			"BuldUndo",
			"BuldRedo",
			"BuldCreateObj",
			"BuldDuplicateSel",
			"BuldRemoveSel",
			"BuldRotateSelX",
			"BuldRotateSelZ",
			"BuldScaleSel",
			"BuldElevateSel",
			"BuldKeepAbsoluteElevationSel",
			"BuldClearAllElevationLocks"
		};
	};
	class CollisionGroups
	{
		manMain[]=
		{
			"basic",
			"manBasic"
		};
		vehMain[]=
		{
			"basic",
			"vehBasic"
		};
		manMoveGround[]=
		{
			"manMoveGround",
			"manBasic",
			"basic"
		};
		seagull[]=
		{
			"seagull"
		};
		buldozer[]=
		{
			"buldozer"
		};
	};
	class Exceptions
	{
		leftAlt[]=
		{
			"lookAround",
			"commandWatch"
		};
		map[]=
		{
			"showMap",
			"hideMap"
		};
		lockRevealTarget[]=
		{
			"lockTarget",
			"revealTarget",
			"holdBreath"
		};
		rollLeft[]=
		{
			"EvasiveLeft",
			"LeanLeft"
		};
		rollRight[]=
		{
			"EvasiveRight",
			"LeanRight"
		};
		landGear[]=
		{
			"LandGear",
			"LandGearUp"
		};
		zoomIn[]=
		{
			"zoomIn",
			"zoomInToggle"
		};
		zoomOut[]=
		{
			"zoomOut",
			"zoomOutToggle"
		};
		mouseConfirm[]=
		{
			"DefaultAction",
			"ActionContext",
			"ActionFreeLook"
		};
		moveUp[]=
		{
			"GunElevUp",
			"zeroingUp",
			"heliUp",
			"seagullUp"
		};
		moveDown[]=
		{
			"GunElevDown",
			"zeroingDown",
			"heliDown",
			"seagullDown"
		};
		autoHover[]=
		{
			"AutoHover",
			"AutoHoverCancel"
		};
		speedModifier[]=
		{
			"VehicleTurbo",
			"GunElevSlow"
		};
	};
};
class UserActionGroups
{
	class All
	{
		name="$STR_USRACT_GROUP_ALL";
		group[]=
		{
			"MoveForward",
			"MoveBack",
			"TurnLeft",
			"TurnRight",
			"MoveUp",
			"MoveDown",
			"MoveFastForward",
			"MoveSlowForward",
			"MoveLeft",
			"MoveRight",
			"EvasiveLeft",
			"EvasiveRight",
			"Stand",
			"Crouch",
			"Prone",
			"LeanLeft",
			"LeanRight",
			"LeanLeftToggle",
			"LeanRightToggle",
			"WalkRunToggle",
			"WalkRunTemp",
			"ToggleWeapons",
			"SwitchWeapon",
			"Fire",
			"DefaultAction",
			"ReloadMagazine",
			"opticsMode",
			"LockTargets",
			"LockEmptyTargets",
			"LockTarget",
			"launchCM",
			"nextCM",
			"Throw",
			"CycleThrownItems",
			"RevealTarget",
			"TacticalPing",
			"TempRaiseWeapon",
			"ToggleRaiseWeapon",
			"PrevAction",
			"NextAction",
			"Action",
			"ActionContext",
			"ActionFreeLook",
			"Headlights",
			"NightVision",
			"Binocular",
			"Handgun",
			"Compass",
			"CompassToggle",
			"uavView",
			"uavViewToggle",
			"Watch",
			"WatchToggle",
			"MiniMap",
			"MiniMapToggle",
			"ShowMap",
			"HideMap",
			"Help",
			"TimeInc",
			"TimeDec",
			"CopyVersion",
			"OpenDlcScreen",
			"Optics",
			"PersonView",
			"TacticalView",
			"ZoomIn",
			"ZoomInToggle",
			"ZoomOut",
			"zoomOutToggle",
			"ZoomContIn",
			"ZoomContOut",
			"ZeroingUp",
			"ZeroingDown",
			"GunElevUp",
			"GunElevDown",
			"GunElevSlow",
			"GunElevAuto",
			"LookAround",
			"LookAroundToggle",
			"LookLeftDown",
			"LookDown",
			"LookRightDown",
			"LookLeft",
			"LookCenter",
			"LookRight",
			"LookLeftUp",
			"LookUp",
			"LookRightUp",
			"LookLeftCont",
			"LookRightCont",
			"LookDownCont",
			"LookUpCont",
			"LookShiftLeftCont",
			"LookShiftRightCont",
			"LookShiftUpCont",
			"LookShiftDownCont",
			"LookShiftForwardCont",
			"LookShiftBackCont",
			"LookRollLeftCont",
			"LookRollRightCont",
			"LookShiftLeft",
			"LookShiftRight",
			"LookShiftUp",
			"LookShiftDown",
			"LookShiftForward",
			"LookShiftBack",
			"LookRollLeft",
			"LookRollRight",
			"LookShiftCenter",
			"FreeHeadMove",
			"PrevChannel",
			"NextChannel",
			"Chat",
			"VoiceOverNet",
			"PushToTalk",
			"PushToTalkAll",
			"PushToTalkSide",
			"PushToTalkCommand",
			"PushToTalkGroup",
			"PushToTalkVehicle",
			"PushToTalkDirect",
			"CommandingMenu1",
			"CommandingMenu2",
			"CommandingMenu3",
			"CommandingMenu4",
			"CommandingMenu5",
			"CommandingMenu6",
			"CommandingMenu7",
			"CommandingMenu8",
			"CommandingMenu9",
			"CommandingMenu0",
			"SelectGroupUnit1",
			"SelectGroupUnit2",
			"SelectGroupUnit3",
			"SelectGroupUnit4",
			"SelectGroupUnit5",
			"SelectGroupUnit6",
			"SelectGroupUnit7",
			"SelectGroupUnit8",
			"SelectGroupUnit9",
			"SelectGroupUnit0",
			"GroupPagePrev",
			"GroupPageNext",
			"SelectTeamRed",
			"SelectTeamGreen",
			"SelectTeamBlue",
			"SelectTeamYellow",
			"SelectTeamWhite",
			"SetTeamRed",
			"SetTeamGreen",
			"SetTeamBlue",
			"SetTeamYellow",
			"SetTeamWhite",
			"NetworkStats",
			"SelectAll",
			"Turbo",
			"TurboToggle",
			"VehicleTurbo",
			"Slow",
			"HoldBreath",
			"Salute",
			"SitDown",
			"AimUp",
			"AimDown",
			"AimLeft",
			"AimRight",
			"AimHeadUp",
			"AimHeadDown",
			"AimHeadLeft",
			"AimHeadRight",
			"IngamePause",
			"MenuSelect",
			"NavigateMenu",
			"CloseContext",
			"ForceCommandingMode",
			"SwitchCommand",
			"HeliThrottlePos",
			"HeliThrottleNeg",
			"HeliUp",
			"HeliDown",
			"HeliLeft",
			"HeliRight",
			"AirBankLeft",
			"AirBankRight",
			"HeliRudderLeft",
			"HeliRudderRight",
			"HeliForward",
			"HeliBack",
			"HeliFastForward",
			"HeliCollectiveRaise",
			"HeliCollectiveLower",
			"HeliCollectiveRaiseCont",
			"HeliCollectiveLowerCont",
			"HeliCyclicLeft",
			"HeliCyclicRight",
			"CyclicForward",
			"CyclicBack",
			"AutoHover",
			"AutoHoverCancel",
			"LandGear",
			"LandGearUp",
			"FlapsDown",
			"FlapsUp",
			"HelicopterTrimOn",
			"HelicopterTrimOff",
			"heliWheelsBrake",
			"HeliTrimLeft",
			"HeliTrimRight",
			"HeliTrimForward",
			"HeliTrimBackward",
			"HeliTrimRudderLeft",
			"HeliTrimRudderRight",
			"HeliRopeAction",
			"SeagullUp",
			"SeagullDown",
			"SeagullForward",
			"SeagullBack",
			"SeagullFastForward",
			"CarLeft",
			"CarRight",
			"CarLinearLeft",
			"CarLinearRight",
			"CarWheelLeft",
			"CarWheelRight",
			"CarForward",
			"CarBack",
			"CarHandBrake",
			"CarFastForward",
			"CarSlowForward",
			"CarAimUp",
			"CarAimDown",
			"CarAimLeft",
			"CarAimRight",
			"CommandLeft",
			"CommandRight",
			"CommandForward",
			"CommandBack",
			"CommandFast",
			"CommandSlow",
			"SwitchGunnerWeapon",
			"VehLockTargets",
			"VehLockEmptyTargets",
			"SwapGunner",
			"HeliManualFire",
			"TurnIn",
			"TurnOut",
			"GetOut",
			"Eject",
			"CancelAction",
			"CommandWatch",
			"TeamSwitch",
			"TeamSwitchPrev",
			"TeamSwitchNext",
			"Gear",
			"Cheat1",
			"Cheat2",
			"Diary",
			"Surrender",
			"GetOver",
			"TurretElevationUp",
			"TurretElevationDown"
		};
	};
	class BasicInfantryControls
	{
		name="$STR_USRACT_GROUP_INFANTRY";
		group[]=
		{
			"SwimUp",
			"SwimDown",
			"AdjustUp",
			"AdjustLeft",
			"AdjustDown",
			"AdjustRight",
			"MoveForward",
			"MoveBack",
			"TurnLeft",
			"TurnRight",
			"MoveFastForward",
			"MoveSlowForward",
			"MoveLeft",
			"MoveRight",
			"EvasiveLeft",
			"EvasiveRight",
			"Stand",
			"Crouch",
			"Prone",
			"LeanLeft",
			"LeanRight",
			"LeanLeftToggle",
			"LeanRightToggle",
			"WalkRunToggle",
			"WalkRunTemp",
			"ToggleWeapons",
			"SwitchWeapon",
			"DefaultAction",
			"ReloadMagazine",
			"Throw",
			"CycleThrownItems",
			"LockTargets",
			"LockEmptyTargets",
			"LockTarget",
			"RevealTarget",
			"TacticalPing",
			"TempRaiseWeapon",
			"ToggleRaiseWeapon",
			"PrevAction",
			"NextAction",
			"NavigateMenu",
			"CloseContext",
			"Action",
			"ActionContext",
			"ActionFreeLook",
			"Optics",
			"LookAround",
			"LookAroundToggle",
			"TeamSwitch",
			"TeamSwitchPrev",
			"TeamSwitchNext",
			"Gear",
			"Compass",
			"CompassToggle",
			"uavView",
			"uavViewToggle",
			"Watch",
			"WatchToggle",
			"MiniMap",
			"MiniMapToggle",
			"ForceCommandingMode",
			"Diary",
			"Headlights",
			"NightVision",
			"Binocular",
			"Handgun",
			"ShowMap",
			"HideMap",
			"PersonView",
			"TacticalView",
			"ZoomIn",
			"ZoomInToggle",
			"ZoomOut",
			"zoomOutToggle",
			"ZeroingUp",
			"ZeroingDown",
			"GunElevUp",
			"GunElevDown",
			"GunElevSlow",
			"GunElevAuto",
			"HoldBreath",
			"Salute",
			"SitDown",
			"Surrender",
			"GetOver",
			"VoiceOverNet",
			"PrevChannel",
			"NextChannel",
			"Chat",
			"PushToTalk",
			"PushToTalkAll",
			"PushToTalkSide",
			"PushToTalkCommand",
			"PushToTalkGroup",
			"PushToTalkVehicle",
			"PushToTalkDirect",
			"CommandingMenu1",
			"CommandingMenu2",
			"CommandingMenu3",
			"CommandingMenu4",
			"CommandingMenu5",
			"CommandingMenu6",
			"CommandingMenu7",
			"CommandingMenu8",
			"CommandingMenu9",
			"CommandingMenu0",
			"SelectGroupUnit1",
			"SelectGroupUnit2",
			"SelectGroupUnit3",
			"SelectGroupUnit4",
			"SelectGroupUnit5",
			"SelectGroupUnit6",
			"SelectGroupUnit7",
			"SelectGroupUnit8",
			"SelectGroupUnit9",
			"SelectGroupUnit0",
			"GroupPagePrev",
			"GroupPageNext",
			"SelectTeamRed",
			"SelectTeamGreen",
			"SelectTeamBlue",
			"SelectTeamYellow",
			"SelectTeamWhite",
			"SetTeamRed",
			"SetTeamGreen",
			"SetTeamBlue",
			"SetTeamYellow",
			"SetTeamWhite",
			"AimUp",
			"AimDown",
			"AimLeft",
			"AimRight",
			"AimHeadUp",
			"AimHeadDown",
			"AimHeadLeft",
			"AimHeadRight",
			"LookLeftDown",
			"LookDown",
			"LookRightDown",
			"LookLeft",
			"LookCenter",
			"LookRight",
			"LookLeftUp",
			"LookUp",
			"LookRightUp",
			"LookLeftCont",
			"LookRightCont",
			"LookDownCont",
			"LookUpCont"
		};
	};
	class Car
	{
		name="$STR_USRACT_GROUP_VEHICLE";
		group[]=
		{
			"CarLeft",
			"CarRight",
			"CarLinearLeft",
			"CarLinearRight",
			"CarWheelLeft",
			"CarWheelRight",
			"CarForward",
			"CarBack",
			"CarHandBrake",
			"CarFastForward",
			"CarSlowForward",
			"CarAimUp",
			"CarAimDown",
			"CarAimLeft",
			"CarAimRight",
			"TurnIn",
			"TurnOut",
			"GetOut",
			"Eject",
			"Fire",
			"SwitchGunnerWeapon"
		};
	};
	class Air
	{
		name="$STR_USRACT_GROUP_FLYING";
		group[]=
		{
			"HeliUp",
			"HeliDown",
			"HeliThrottlePos",
			"HeliThrottleNeg",
			"HeliLeft",
			"HeliRight",
			"AirBankLeft",
			"AirBankRight",
			"HeliRudderLeft",
			"HeliRudderRight",
			"HeliForward",
			"HeliBack",
			"HeliFastForward",
			"HeliManualFire",
			"VTOLVectoring",
			"VTOLVectoringCancel",
			"LandGear",
			"LandGearUp",
			"FlapsDown",
			"FlapsUp",
			"GetOut",
			"Eject",
			"SeagullUp",
			"SeagullDown",
			"SeagullForward",
			"SeagullBack",
			"SeagullFastForward",
			"Fire",
			"SwitchGunnerWeapon",
			"LookShiftLeftCont",
			"LookShiftRightCont",
			"LookShiftUpCont",
			"LookShiftDownCont",
			"LookShiftForwardCont",
			"LookShiftBackCont",
			"LookRollLeftCont",
			"LookRollRightCont",
			"LookShiftLeft",
			"LookShiftRight",
			"LookShiftUp",
			"LookShiftDown",
			"LookShiftForward",
			"LookShiftBack",
			"LookRollLeft",
			"LookRollRight",
			"LookShiftCenter",
			"FreeHeadMove"
		};
	};
	class Helicopter
	{
		name="$STR_USRACT_GROUP_HELI";
		group[]=
		{
			"HeliCyclicForward",
			"HeliCyclicBack",
			"HeliCyclicLeft",
			"HeliCyclicRight",
			"HeliCollectiveRaiseCont",
			"HeliCollectiveLowerCont",
			"HeliCollectiveRaise",
			"HeliCollectiveLower",
			"HeliRudderLeft",
			"HeliRudderRight",
			"HeliLeft",
			"HeliRight",
			"AutoHover",
			"AutoHoverCancel",
			"heliWheelsBrake",
			"LandGear",
			"LandGearUp",
			"HelicopterTrimOn",
			"HelicopterTrimOff",
			"HeliTrimLeft",
			"HeliTrimRight",
			"HeliTrimForward",
			"HeliTrimBackward",
			"HeliTrimRudderLeft",
			"HeliTrimRudderRight",
			"HeliRopeAction",
			"minimap",
			"minimapToggle",
			"uavView",
			"uavViewToggle",
			"GetOut",
			"Eject",
			"LockTarget",
			"VehLockTargets",
			"VehLockEmptyTargets",
			"DefaultAction",
			"Fire",
			"SwitchGunnerWeapon",
			"launchCM",
			"FreeHeadMove",
			"LookShiftLeftCont",
			"LookShiftRightCont",
			"LookShiftUpCont",
			"LookShiftDownCont",
			"LookShiftForwardCont",
			"LookShiftBackCont",
			"LookRollLeftCont",
			"LookRollRightCont",
			"LookShiftLeft",
			"LookShiftRight",
			"LookShiftUp",
			"LookShiftDown",
			"LookShiftForward",
			"LookShiftBack",
			"LookRollLeft",
			"LookRollRight",
			"LookShiftCenter"
		};
	};
	class Submarine
	{
		name="$STR_USRACT_GROUP_SUBMARINE";
		group[]=
		{
			"submarineUp",
			"submarineDown",
			"submarineLeft",
			"submarineRight",
			"submarineForward",
			"submarineBack",
			"submarineCyclicForward",
			"submarineCyclicBack",
			"GetOut",
			"Eject",
			"FreeHeadMove",
			"LookShiftLeftCont",
			"LookShiftRightCont",
			"LookShiftUpCont",
			"LookShiftDownCont",
			"LookShiftForwardCont",
			"LookShiftBackCont",
			"LookRollLeftCont",
			"LookRollRightCont",
			"LookShiftLeft",
			"LookShiftRight",
			"LookShiftUp",
			"LookShiftDown",
			"LookShiftForward",
			"LookShiftBack",
			"LookRollLeft",
			"LookRollRight",
			"LookShiftCenter"
		};
	};
	class Buldozer
	{
		name="$STR_USRACT_GROUP_BULDOZER";
		group[]=
		{
			"BuldSwitchCamera",
			"BuldFreeLook",
			"BuldSelect",
			"BuldResetCamera",
			"BuldMagnetizePoints",
			"BuldMagnetizePlanes",
			"BuldMagnetizeYFixed",
			"BuldTerrainRaise1m",
			"BuldTerrainRaise10cm",
			"BuldTerrainLower1m",
			"BuldTerrainLower10cm",
			"BuldTerrainRaise5m",
			"BuldTerrainRaise50cm",
			"BuldTerrainLower5m",
			"BuldTerrainLower50cm",
			"BuldTerrainShowNode",
			"BuldSelectionType",
			"BuldLeft",
			"BuldRight",
			"BuldForward",
			"BuldBack",
			"BuldMoveLeft",
			"BuldMoveRight",
			"BuldMoveForward",
			"BuldMoveBack",
			"BuldTurbo",
			"BuldUp",
			"BuldDown",
			"BuldLookLeft",
			"BuldLookRight",
			"BuldLookUp",
			"BuldLookDown",
			"BuldZoomIn",
			"BuldZoomOut",
			"BuldTextureInfo",
			"BuldBrushRatio",
			"BuldBrushStrength",
			"BuldBrushSmooth",
			"BuldBrushRandomize",
			"BuldBrushSetHeight",
			"BuldBrushOuter",
			"BuldUndo",
			"BuldRedo",
			"BuldCreateObj",
			"BuldDuplicateSel",
			"BuldRemoveSel",
			"BuldRotateSelX",
			"BuldRotateSelZ",
			"BuldScaleSel",
			"BuldElevateSel",
			"BuldKeepAbsoluteElevationSel",
			"BuldClearAllElevationLocks"
		};
	};
	class UserActions
	{
		name="$STR_USRACT_GROUP_USER";
		group[]=
		{
			"User1",
			"User2",
			"User3",
			"User4",
			"User5",
			"User6",
			"User7",
			"User8",
			"User9",
			"User10",
			"User11",
			"User12",
			"User13",
			"User14",
			"User15",
			"User16",
			"User17",
			"User18",
			"User19",
			"User20"
		};
	};
};
TrackIR_Developer_ID=0;
TrackIR_Developer_AppKeyHigh=0;
TrackIR_Developer_AppKeyLow=0;
overviewLockedMission="dtaext\lockedmission";
overviewMyMissions="dtaext\mymissions";
overviewNewMission="dtaext\newmission";
uiScaleFactor=4;
uiScaleMaxGrids=60;
IGUIForcedScale=-1;
fontPlate="TahomaB";
fontHelicopterHUD="TahomaB";
fontClanName="TahomaB";
class CfgEditCamera
{
	speedFwdBack=1;
	speedLeftRight=1;
	speedUpDown=1;
	speedRotate=1;
	speedElevation=1;
	speedTurboMultiplier=4;
	iconSelect="";
	iconSelectColor[]={1,1,0,1};
	iconSelectSizeX=0.75;
	iconSelectSizeY=1;
};
class CfgWrapperUI
{
	access=0;
	class Colors
	{
		color1[]={0,0,0,1};
		color2[]={0.2,0.2,0.2,1};
		color3[]={0.5,0.5,0.5,1};
		color4[]={0.60000002,0.60000002,0.60000002,1};
		color5[]={0.80000001,0.80000001,0.80000001,1};
	};
	class Background
	{
		alpha=0.75;
		texture="#(argb,8,8,3)color(1,1,1,1)";
	};
	class TitleBar
	{
		alpha=0.30000001;
		texture="#(argb,8,8,3)color(1,1,1,1)";
	};
	class GroupBox
	{
		alpha=0.2;
	};
	class GroupBox2
	{
		alpha=0.5;
		texture="#(argb,8,8,3)color(1,1,1,1)";
	};
	class Button
	{
		color1[]={0,0,0,0.30000001};
		color2[]={0.2,0.2,0.2,0.30000001};
		color3[]={0.5,0.5,0.5,0.30000001};
		color4[]={0.60000002,0.60000002,0.60000002,0.30000001};
		color5[]={0.80000001,0.80000001,0.80000001,0.30000001};
	};
	class ListBox
	{
		line="#(argb,8,8,3)color(1,1,1,1)";
		thumb="#(argb,8,8,3)color(1,1,1,1)";
		arrowEmpty="#(argb,8,8,3)color(1,1,1,1)";
		arrowFull="#(argb,8,8,3)color(1,1,1,1)";
		border="#(argb,8,8,3)color(1,1,1,1)";
		boxLeft="#(argb,8,8,3)color(1,1,1,1)";
		boxRight="#(argb,8,8,3)color(1,1,1,1)";
		boxHorz="#(argb,8,8,3)color(1,1,1,1)";
	};
	class Slider
	{
		arrowEmpty="#(argb,8,8,3)color(1,1,1,1)";
		arrowFull="#(argb,8,8,3)color(1,1,1,1)";
		border="#(argb,8,8,3)color(1,1,1,1)";
		thumb="#(argb,8,8,3)color(1,1,1,1)";
	};
	class Cursors
	{
		class Arrow
		{
			texture="\core\arrow_gs.paa";
			width=16;
			height=16;
			hotspotX=0;
			hotspotY=0;
			color[]={0.80000001,0.80000001,0.80000001,1};
			shadow=0;
		};
		class Debug: Arrow
		{
			color[]={1,1,0.69999999,1};
			shadow=0;
		};
		class Track
		{
			texture="#(argb,32,32,1)color(1,1,1,1)";
			width=24;
			height=24;
			hotspotX=0.5;
			hotspotY=0.5;
			color[]={0.69999999,0.1,0,1};
			shadow=0;
		};
		class Move
		{
			texture="#(argb,32,32,1)color(1,1,1,1)";
			width=24;
			height=24;
			hotspotX=0.5;
			hotspotY=0.5;
			color[]={0,0.60000002,0,1};
			shadow=0;
		};
		class Scroll
		{
			texture="#(argb,32,32,1)color(1,1,1,1)";
			width=24;
			height=24;
			hotspotX=0.5;
			hotspotY=0.5;
			color[]={0.80000001,0.60000002,0,1};
			shadow=0;
		};
		class Rotate
		{
			texture="#(argb,32,32,1)color(1,1,1,1)";
			width=24;
			height=24;
			hotspotX=0.5;
			hotspotY=0.5;
			color[]={0.1,0.1,0.89999998,1};
			shadow=0;
		};
		class Track3D
		{
			texture="#(argb,32,32,1)color(1,1,1,1)";
			width=24;
			height=24;
			hotspotX=0.5;
			hotspotY=0.5;
			color[]={0.69999999,0.1,0,1};
			shadow=0;
		};
		class Move3D
		{
			texture="#(argb,32,32,1)color(1,1,1,1)";
			width=24;
			height=24;
			hotspotX=0.5;
			hotspotY=0.5;
			color[]={0,0.60000002,0,1};
			shadow=0;
		};
		class Rotate3D
		{
			texture="#(argb,32,32,1)color(1,1,1,1)";
			width=24;
			height=24;
			hotspotX=0.5;
			hotspotY=0.5;
			color[]={0.1,0.1,0.89999998,1};
			shadow=0;
		};
		class Raise3D
		{
			texture="#(argb,32,32,1)color(1,1,1,1)";
			width=24;
			height=24;
			hotspotX=0.5;
			hotspotY=0.5;
			color[]={0,0.80000001,1,1};
			shadow=0;
		};
		class Wait
		{
			texture="#(argb,32,32,1)color(1,1,1,1)";
			width=24;
			height=24;
			hotspotX=0.5;
			hotspotY=0.5;
			color[]={0.1,0.1,0.89999998,1};
			shadow=0;
		};
	};
};
class CfgInGameUI
{
	access=0;
	imageCornerElement="#(argb,8,8,3)color(1,1,1,1)";
	xboxStyle=1;
	colorBackground[]={0.2,0.15000001,0.1,0.80000001};
	colorBackgroundCommand[]={0,0,0,0.30000001};
	colorBackgroundHelp[]={0.2,0.15000001,0.1,0.80000001};
	colorText[]={0.80000001,0.80000001,0.80000001,1};
	unfocusMenuAlpha=0.64999998;
	shadow=0;
	class CfgWeaponModeTextures
	{
		default="#(argb,8,8,3)color(0,0,0,0)";
	};
	class PlayerColors
	{
		class ColNone
		{
			texture="#(argb,8,8,3)color(0,0,0,0)";
			text="None";
		};
		class ColWhite
		{
			texture="#(argb,8,8,3)color(1,1,1,1)";
			text="White";
		};
		class ColRed
		{
			texture="#(argb,8,8,3)color(1,0,0,1)";
			text="Red";
		};
		class ColOrange
		{
			texture="#(argb,8,8,3)color(1,0.5,0,1)";
			text="Orange";
		};
		class ColYellow
		{
			texture="#(argb,8,8,3)color(1,1,0,1)";
			text="Yellow";
		};
		class ColGreen
		{
			texture="#(argb,8,8,3)color(0,1,0,1)";
			text="Green";
		};
		class ColAqua
		{
			texture="#(argb,8,8,3)color(0,1,1,1)";
			text="Aqua";
		};
		class ColBlue
		{
			texture="#(argb,8,8,3)color(0,0,1,1)";
			text="Blue";
		};
		class ColPurple
		{
			texture="#(argb,8,8,3)color(0.75,0,0.75,1)";
			text="Purple";
		};
		class ColGrey
		{
			texture="#(argb,8,8,3)color(0.3,0.3,0.3,1)";
			text="Grey";
		};
		class ColBlack
		{
			texture="#(argb,8,8,3)color(0,0,0,1)";
			text="Black";
		};
	};
	class SideColors
	{
		colorFriendly[]={0,0.60000002,0,1};
		colorEnemy[]={0.69999999,0.1,0,1};
		colorNeutral[]={0.80000001,0.80000001,0.80000001,1};
		colorCivilian[]={0.80000001,0.80000001,0.80000001,1};
		colorUnknown[]={0.80000001,0.60000002,0,1};
	};
	class IslandMap
	{
		colorFriendly[]={0,0.5,0,1};
		colorEnemy[]={0.5,0,0,1};
		colorNeutral[]={0.5,0.5,0.5,1};
		colorCivilian[]={0,0,1,1};
		colorUnknown[]={0.5,0.5,0,1};
		colorExplosive[]={1,0,0,1};
		shadow=0;
		iconPlayer="#(argb,8,8,3)color(1,1,1,1)";
		iconCheckpoint="#(argb,8,8,3)color(1,1,1,1)";
		iconCamera="#(argb,8,8,3)color(1,1,1,1)";
		iconSelect="#(argb,8,8,3)color(1,1,1,1)";
		iconSensor="#(argb,8,8,3)color(1,1,1,1)";
		sizeLeader=24;
		size=20;
		sizePlayer=16;
		colorNonPlayable[]={0.25,0.25,0.25,1};
		colorMe[]={0.69999999,0.1,0,1};
		colorPlayable[]={0.69999999,0,0.69999999,1};
		colorSelect[]={0,0.60000002,0,0.5};
		colorCamera[]={0.1,0.1,0.89999998,1};
		colorSensor[]={0.1,0.1,0.89999998,1};
		colorDragging[]={0.80000001,0.80000001,0.80000001,1};
		colorInactive[]={1,1,1,0.60000002};
		colorExposureEnemy[]={1,0.2,0.2,0.5};
		colorExposureUnknown[]={0.80000001,0.80000001,0.2,0.5};
		colorCheckpoints[]={0.2,0.2,0.2,1};
		colorMissions[]={0.5,0.5,0,0.5};
		colorActiveMission[]={0,0,0,1};
		lockedWaypoint="#(argb,8,8,3)color(1,0,0,1)";
		colorPath[]={0,1,1,1};
		colorPathDone[]={0,1,0,0.80000001};
		texturePath="#(argb,8,8,3)color(1,1,1,1)";
		texturePathDone="#(argb,8,8,3)color(1,1,1,1)";
		sizePath=10;
		sizePathDone=2;
		colorInfoMove[]={1,1,1,1};
		colorGroups[]={0,0.5,0.5,0.5};
		colorActiveGroup[]={0,1,1,1};
		colorSync[]={0,0,1,1};
		colorDetectorSync[]={0,1,0,1};
		colorLabelBackground[]={0,0,0,1};
		cursorLineWidth=3;
		scaleMin=0.001;
		scaleMax=1;
		scaleDefault=0.16;
		assault="#(argb,8,8,3)color(1,1,1,1)";
		assaultNoLOS="#(argb,8,8,3)color(1,1,1,1)";
		assaultColor[]={0,0,0,1};
		assaultNoLOSColor[]={0,0,0,0.5};
	};
	class MPTable
	{
		x=0.037;
		y=0.1;
		w=0.926;
		h=0.80000001;
		color[]={0.69999999,0.69999999,0.69999999,1};
		colorCaptionBg[]={0.1,0.15000001,0.15000001,1};
		colorTitleBg[]={0.1,0.15000001,0.15000001,1};
		colorBg[]={0.1,0.15000001,0.1,0.80000001};
		colorBgAlt[]={0.1,0.15000001,0.1,0.89999998};
		colorSelected[]={0.69999999,0.69999999,0.69999999,0.40000001};
		colorWest[]={0.69999999,0.94999999,0.69999999,1};
		colorEast[]={0.94999999,0.69999999,0.69999999,1};
		colorCiv[]={0.80000001,0.80000001,0.80000001,1};
		colorRes[]={0.69999999,0.69999999,0.94999999,1};
		font="TahomaB";
		size="( 21 / 408 )";
		shadow=0;
		captionSpace=0;
		class Columns
		{
			class Order
			{
				width=0.048999999;
				space=0;
				colorBg[]={0.1,0.27000001,0.1,0.80000001};
			};
			class Player
			{
				width=0.27000001;
				space=0;
				colorBg[]={0.1,0.23,0.1,0.80000001};
			};
			class KillsInfantry
			{
				width=0.11;
				space=0;
				picture="#(argb,8,8,3)color(1,1,1,1)";
			};
			class KillsSoft
			{
				width=0.1;
				space=0;
				picture="#(argb,8,8,3)color(1,1,1,1)";
			};
			class KillsArmor
			{
				width=0.11;
				space=0;
				picture="#(argb,8,8,3)color(1,1,1,1)";
			};
			class KillsAir
			{
				width=0.1;
				space=0;
				picture="#(argb,8,8,3)color(1,1,1,1)";
			};
			class Killed
			{
				width=0.1;
				space=0;
				picture="#(argb,8,8,3)color(1,1,1,1)";
			};
			class KillsTotal
			{
				width=0.1;
				space=0;
				picture="#(argb,8,8,3)color(1,1,1,1)";
			};
		};
		class RespawnMessage
		{
			x=0.050000001;
			y=0.050000001;
			font="TahomaB";
			size="( 29 / 408 )";
			color[]={0.60000002,0.80000001,0.5,1};
			xBg=-0.1;
			yBg=-0.1;
			wBg=1.2;
			hBg=0.23;
			colorBg[]={0,0,0,0.69999999};
			shadow=0;
		};
	};
	class TankDirection
	{
		left=0.035;
		top=0.16;
		width=0.18000001;
		height=0.25999999;
		color[]={0.80000001,0.80000001,0.80000001,1};
		colorHalfDammage[]={0.80000001,0.60000002,0,1};
		colorFullDammage[]={0.69999999,0.1,0,1};
		imageTower="#(argb,8,8,3)color(1,1,1,1)";
		imageTurret="#(argb,8,8,3)color(0,0,0,1)";
		imageGun="#(argb,8,8,3)color(0.3,0.3,0.3,1)";
		imageObsTurret="#(argb,8,8,3)color(1,0,0,1)";
		imageEngine="#(argb,8,8,3)color(0,1,0,1)";
		imageHull="#(argb,8,8,3)color(0,0,1,1)";
		imageLTrack="#(argb,8,8,3)color(1,0.5,0,1)";
		imageRTrack="#(argb,8,8,3)color(0,0,0,1)";
		imageMoveStop="#(argb,8,8,3)color(0.3,0.3,0.3,1)";
		imageMoveBack="#(argb,8,8,3)color(1,0,0,1)";
		imageMoveForward="#(argb,8,8,3)color(0,1,0,1)";
		imageMoveFast="#(argb,8,8,3)color(0,0,1,1)";
		imageMoveLeft="#(argb,8,8,3)color(1,0.5,0,1)";
		imageMoveRight="#(argb,8,8,3)color(0,0,0,1)";
		imageMoveAuto="#(argb,8,8,3)color(1,0.5,0,1)";
		shadow=0;
	};
	class HelicopterHUD
	{
		shadow=0;
		font="FontNormal";
		SizeExNormal=0.035;
		SizeExSmall=0.02;
		attitudeElemmentsSize=0.1;
		attitudeFOV=1.04719;
		analogueSpeedAngleOffset=2.0943949;
		analogueAltitudeAngleOffset=2.0943949;
		analogueSpeedAngleRange=5.9341192;
		analogueAltitudeAngleRange=5.9341192;
		HUDLimitsColor[]={0,0.60000002,0,1};
		color[]={0,0.60000002,0,1};
		windDirection="#(argb,8,8,3)color(0,1,0,1)";
		stabilityVector="#(argb,8,8,3)color(0,1,0,1)";
		stabilityGrid="#(argb,8,8,3)color(0,1,0,1)";
		axis="#(argb,8,8,3)color(0,1,0,1)";
		indicator="#(argb,8,8,3)color(0,1,0,1)";
		horizonAxes="#(argb,8,8,3)color(0,1,0,1)";
		horizonVector="#(argb,8,8,3)color(0,1,0,1)";
		horizonAircraft="#(argb,8,8,3)color(0,1,0,1)";
		statusOff[]={0.80000001,0.80000001,0.80000001,1};
		statusOn[]={0,0.60000002,0,1};
		statusDamaged[]={0.80000001,0.60000002,0,1};
		statusDestroyed[]={0.69999999,0.1,0,1};
		statusEnabled[]={0,0.60000002,0,1};
	};
	class FLIRModeNames
	{
		FLIRModeName[]=
		{
			"WHOT",
			"BHOT",
			"HOT",
			"HOT",
			"RBHOT",
			"BRHOT"
		};
	};
	class Capture
	{
		colorBackground[]={0,0,0,0.93000001};
		colorText[]={0.80000001,0.60000002,0,1};
		colorLine[]={0.80000001,0.80000001,0.80000001,1};
		shadow=0;
	};
	class Picture
	{
		color[]={0.80000001,0.80000001,0.80000001,1};
		colorProblems[]={0.69999999,0.1,0,1};
		imageBusy="#(argb,8,8,3)color(1,1,1,1)";
		imageWaiting="#(argb,8,8,3)color(1,1,1,1)";
		imageCommand="#(argb,8,8,3)color(1,1,1,1)";
		shadow=0;
	};
	class Bar
	{
		imageBar="#(argb,8,8,3)color(1,1,1,1)";
		colorBackground[]={0.1,0.40000001,0.1,0.69999999};
		colorGreen[]={0,0.60000002,0,1};
		colorYellow[]={0.80000001,0.60000002,0,1};
		colorRed[]={0.69999999,0.1,0,0.89999998};
		colorBlinkOn[]={1,0.2,0.2,1};
		colorBlinkOff[]={0.69999999,0.1,0,0.89999998};
		height=0.0099999998;
		shadow=0;
	};
	class Messages
	{
		color1[]={0.80000001,0.60000002,0,0.89999998};
		color2[]={0,0.60000002,0,0.89999998};
		color3[]={0.80000001,0.80000001,0.80000001,0.89999998};
		shadow=0;
	};
	class TacticalDisplay: SideColors
	{
		left=0;
		top=0.041999999;
		width=1;
		height=0.1;
		colorCamera[]={0.40000001,0.40000001,0.40000001,0.40000001};
		targetTexture="#(argb,8,8,3)color(1,1,1,1)";
		targetAirTexture="#(argb,8,8,3)color(1,1,1,1)";
		targetLaserTexture="#(argb,8,8,3)color(1,1,1,1)";
		targetNVTexture="#(argb,8,8,3)color(1,1,1,1)";
		shadow=0;
		class Cursor
		{
			width=0.015;
			height=0.02;
			color[]={0.80000001,0.80000001,0.80000001,1};
			shadow=0;
		};
	};
	class Radar
	{
		left=0.1;
		top=0.1;
		width=0.30000001;
		height=0.30000001;
		radarAirBackgroundTexture="#(argb,8,8,3)color(0,1,0,1)";
		radarTankBackgroundTexture="#(argb,8,8,3)color(1,1,0,1)";
		radarCompassOnlyBackgroundTexture="#(argb,8,8,3)color(1,1,1,1)";
		radarIncommingMissile="#(argb,8,8,3)color(1,0,0,1)";
		radarAirDangerSector="#(argb,8,8,3)color(0,0,1,1)";
		radarLockDangerColor[]={0.80000001,0.60000002,0,0.75};
		radarIncommingDangerColor[]={0.69999999,0.1,0,0.75};
		radarVehicleTarget="#(argb,8,8,3)color(0,1,0,1)";
		radarTargetingEnemy="#(argb,8,8,3)color(1,1,0,1)";
		radarFOV="#(argb,8,8,3)color(1,0.5,0,1)";
		radarFOVPlayer[]={0,0.60000002,0,0.75};
		radarFOVCrew[]={0.80000001,0.80000001,0.80000001,0.75};
		radarColor[]={0.80000001,0.80000001,0.80000001,0.75};
		radarWaypoint="#(argb,1,1,1)color(1,1,1,0)";
		radarWaypointColor[]={1,0,1,1};
		radarCustomWaypoint="#(argb,1,1,1)color(1,1,1,0)";
		radarCustomWaypointColor[]={0,1,1,1};
		radarAssault="#(argb,1,1,1)color(1,1,1,0)";
		radarAssaultColor[]={1,0,0,1};
		radarOut="#(argb,1,1,1)color(1,1,1,0)";
		shadow=0;
	};
	class SquadRadar
	{
		x=0.1;
		y=0.1;
		w=0;
		h=0;
		xList1=0.1;
		yList1=0.1;
		wList1=0;
		hList1=0;
		xList2=0.1;
		yList2=0.1;
		wList2=0;
		hList2=0;
		colorBackground[]={0.80000001,0.80000001,0.80000001,0};
		backgroundTexture="#(argb,8,8,3)color(1,1,1,1)";
		compassBackgroundTexture="#(argb,8,8,3)color(1,1,1,1)";
		limitsDist[]={15,30,50};
		textureDist[]={0.27000001,0.54000002,0.89999998};
		iconSize=0.015;
		iconAlpha=0;
		iconDesaturation=0;
		taskIconColor[]={0.80000001,0.60000002,0,0};
		taskArrowWidth=0.0099999998;
		taskArrowHeight=0.0099999998;
		taskIconNear="#(argb,8,8,3)color(1,1,1,1)";
		taskIconSize=0.0099999998;
		otherUnitsIcon="#(argb,8,8,3)color(1,1,1,1)";
		friendlyUnitColor[]={0.80000001,0.80000001,0.80000001,0};
		enemyUnitColor[]={0.69999999,0.1,0,0};
		unconsciousUnitIcon="#(argb,8,8,3)color(1,1,1,1)";
		unconsciousUnitMinAlpha=0.2;
		unconsciousUnitTimePeriod=4;
		numberOfRows=6;
		scrollNumber=6;
		textHeight=0.40000001;
		font="TahomaB";
		shadow=0;
	};
	class TacticalPing
	{
		texture="#(argb,8,8,3)color(1,1,1,1)";
		color[]={1,0,0,0};
		minSize=0.5;
		farDistance=100;
		maxSize=2;
		nearDistance=0;
		iconSizePowExponent=2;
		soundDelay=1;
		soundDelayOnePlayer=5;
		sounds[]={};
		pulseMinAlpha=0.2;
		pulseSizeCoef=1.5;
		pulseTimePeriod=1;
		pulseCount=3;
		shadow=0;
	};
	class ProgressFont
	{
		font="TahomaB";
		size="( 21 / 408 )";
		shadow=0;
	};
	class DebugFont
	{
		font="LucidaConsoleB";
		size=0.02;
	};
	class CheatXFont
	{
		font="LucidaConsoleB";
		size=0.037799999;
	};
	class FadeFont
	{
		font="LucidaConsoleB";
		size=0.037799999;
		shadow=0;
	};
	class DragAndDropFont
	{
		font="TahomaB";
		size="( 16 / 408 )";
		colorEnabled[]={0.80000001,0.80000001,0.80000001,0.75};
		colorDisabled[]={0.69999999,0.1,0,0.75};
		hideCursor=0;
		shadow=0;
	};
	class TooltipFont
	{
		font="TahomaB";
		size="( 16 / 408 )";
		shadow=0;
	};
	class Compass
	{
		left=0;
		top=0;
		width=1;
		height=0.039999999;
		color[]={0.80000001,0.80000001,0.80000001,1};
		colorBackground[]={0.80000001,0.80000001,0.80000001,1};
		dirColor[]={0.80000001,0.80000001,0.80000001,1};
		turretDirColor[]={0.80000001,0.60000002,0,1};
		texture0="#(argb,8,8,3)color(1,1,1,1)";
		texture90="#(argb,8,8,3)color(1,1,1,1)";
		texture180="#(argb,8,8,3)color(1,1,1,1)";
		texture270="#(argb,8,8,3)color(1,1,1,1)";
		shadow=0;
	};
	class Menu
	{
		hide="HTNone";
		align=1;
		x=0.98000002;
		widthMin=0.2;
		widthMax=0.30000001;
		top=0.02;
		height=0.5;
		left2=0.28;
		top2=0.02;
		width2=0.25;
		height2=0.5;
		colorChecked[]={0.80000001,0.60000002,0,1};
		colorEnabled[]={0.80000001,0.80000001,0.80000001,1};
		colorDisabled[]={0.40000001,0.40000001,0.40000001,1};
		colorSelected[]={0.38999999,0.68000001,0.44,0.60000002};
		colorSelectedText[]={0.80000001,0.80000001,0.80000001,1};
		hideTime=60;
		font="TahomaB";
		size="( 16 / 408 )";
		shadow=0;
		quickMenuDelay=0;
	};
	class GameInfo
	{
		left=0.77999997;
		top=0.89999998;
		width=0.2;
		height=0.079999998;
	};
	class PlayerInfo
	{
		colorTime[]={0.80000001,0.80000001,0.80000001,1};
		left=0.02;
		top=0.02;
		width=0.2;
		height=0.28;
		class UnitPicture
		{
			width=0.15000001;
			height=0.16;
		};
		class Sign
		{
			height=0.029999999;
			widthSector=0.039999999;
			widthGroup=0.02;
			widthUnit=0.02;
		};
		class Side
		{
			height=0.071999997;
			width=0.059999999;
		};
		class HealthBar
		{
			width=0.12;
			stallWarning=0.2;
		};
		class ArmorBar
		{
			width=0.12;
		};
		class FuelBar
		{
			width=0.12;
		};
		class ExperienceBar
		{
			width=0.12;
			color[]={0.80000001,0.80000001,0.80000001,1};
		};
		dimmStartTime=5;
		dimmEndTime=10;
	};
	class Hint
	{
		dimmStartTime=30;
		dimmEndTime=35;
		sound[]=
		{
			"",
			0.31622776,
			1
		};
	};
	class TaskHint
	{
		dimmStartTime=0.30000001;
		dimShowTime=4.6999998;
		dimmEndTime=5;
	};
	class Chat
	{
		sound[]=
		{
			"",
			0.31622776,
			1
		};
	};
	class Actions
	{
		font="TahomaB";
		size="( 16 / 408 )";
		right=1;
		bottom=0.81;
		rows=4;
		arrowWidth=0.022500001;
		arrowHeight=0.029999999;
		iconArrowUp="#(argb,8,8,3)color(1,1,1,1)";
		iconArrowDown="#(argb,8,8,3)color(1,1,1,1)";
		colorBackground[]={0.2,0.15000001,0.1,0.80000001};
		colorBackgroundSelected[]={0,0,0,0};
		colorText[]={0.80000001,0.80000001,0.80000001,1};
		colorSelect[]={0.2,0.80000001,0.2,1};
		background="#(argb,8,8,3)color(0,0,0,1)";
		underlineSelected=1;
		shadow=0;
	};
	class DefaultAction
	{
		showHint=1;
		showNext=1;
		showLine=1;
		font="TahomaB";
		size="( 21 / 408 )";
		fontNext="TahomaB";
		sizeNext="( 16 / 408 )";
		offsetX=0;
		offsetY=0;
		relativeToCursor=1;
		hotspotX=0;
		hotspotY=0;
		colorText[]={1,1,1,1};
		background="#(argb,8,8,3)color(0,0,0,0)";
		shadow=0;
		textTipFade=1;
		textTipDelay=1.5;
	};
	class GroupInfo
	{
		left=0.02;
		top=0.89999998;
		width=0.95999998;
		height=0.079999998;
		colorIDNone[]={0,0,0,1};
		colorIDNormal[]={0.80000001,0.80000001,0.80000001,1};
		colorIDSelected[]={0,0.60000002,0,1};
		colorIDSelecting[]={0.80000001,0.80000001,0.80000001,1};
		colorIDPlayer[]={0.80000001,0.60000002,0,1};
		class Semaphore
		{
			imageSemaphore="#(argb,8,8,3)color(1,1,1,1)";
			width=0.0074999998;
			height=0.0099999998;
			colorHoldFire[]={0.69999999,0.1,0,1};
		};
		imageDefaultWeapons="#(argb,8,8,3)color(1,1,1,1)";
		imageNoWeapons="#(argb,8,8,3)color(1,1,1,1)";
		imageCommander="#(argb,8,8,3)color(0,1,0,1)";
		imageDriver="#(argb,8,8,3)color(1,0,0,1)";
		imageGunner="#(argb,8,8,3)color(0,0,1,1)";
		imageCargo="#(argb,8,8,3)color(0,0,0,0)";
		imagePrevPage="#(argb,8,8,3)color(1,0,0,1)";
		imageNextPage="#(argb,8,8,3)color(1,0,0,1)";
		fontUnitID="TahomaB";
		sizeUnitID="( 16 / 408 )";
		fontCommand="TahomaB";
		sizeCommand="( 16 / 408 )";
		dimm=0.30000001;
	};
	class CommandBar
	{
		left=0;
		top=0.80000001;
		width=0.1;
		height=0.1;
		elementSpacing=0.050000001;
		dimm=0.30000001;
		imageDefaultWeapons="#(argb,8,8,3)color(1,1,1,1)";
		imageNoWeapons="#(argb,8,8,3)color(1,1,1,1)";
		imageCommander="#(argb,8,8,3)color(0,1,0,1)";
		imageDriver="#(argb,8,8,3)color(1,0,0,1)";
		imageGunner="#(argb,8,8,3)color(0,0,1,1)";
		imageCargo="#(argb,8,8,3)color(0,0,0,0)";
		colorRedTeam[]={0.5,0,0,0.5};
		colorBlueTeam[]={0,0.5,0,0.5};
		colorGreenTeam[]={0,0,0.5,0.5};
		colorYellowTeam[]={0.5,0.5,0,0.5};
		colorWhiteTeam[]={1,1,1,0.5};
		colorText[]={1,1,1,1};
		colorIDNone[]={0,0,0,1};
		colorIDNormal[]={0.80000001,0.80000001,0.80000001,1};
		colorIDSelected[]={0,0.60000002,0,1};
		colorIDSelecting[]={0.80000001,0.80000001,0.80000001,1};
		colorIDPlayer[]={0.80000001,0.60000002,0,1};
		class prevPage
		{
			x=0;
			y=0;
			w=0.028000001;
			h=0.039999999;
			color[]={1,1,1,1};
			texture="#(argb,8,8,3)color(1,1,1,1)";
			shadow=0;
		};
		class nextPage
		{
			x=0;
			y=0;
			w=0.028000001;
			h=0.039999999;
			color[]={1,1,1,1};
			texture="#(argb,8,8,3)color(1,1,1,1)";
			shadow=0;
		};
		class UnitInfo
		{
			w=0.97600001;
			h=0.105;
			font="Zeppelin32";
			class GroupIcon
			{
				x=0.016000001;
				y=0.012;
				w=0.057330001;
				h=0.076229997;
				shadow=0;
			};
			class UnitBackground
			{
				x=0;
				y=0;
				w=0.028000001;
				h=0.039999999;
				textureNormal="#(argb,8,8,3)color(1,1,1,1)";
				textureSelected="#(argb,8,8,3)color(1,1,1,1)";
				texturePlayer="#(argb,8,8,3)color(1,1,1,1)";
				textureFocus="#(argb,8,8,3)color(1,1,1,1)";
				shadow=0;
			};
			class UnitFocus
			{
				x=0;
				y=0;
				w=0.028000001;
				h=0.039999999;
				texture="#(argb,8,8,3)color(1,1,1,1)";
				shadow=0;
			};
			class UnitIcon
			{
				x=0;
				y=0;
				w=0.028000001;
				h=0.039999999;
				color[]={1,1,1,1};
				colorPlayer[]={1,1,1,1};
				colorNoAmmo[]={0.80000001,0.40000001,0.5,1};
				colorWounded[]={0.80000001,0,0,1};
				colorNoFuel[]={0.80000001,0.69999999,0,1};
				colorWoundedFade[]={0,0,0,1};
				colorFocus[]={0,0,0,1};
				colorSelected[]={0,0,0,1};
				colorNormal[]={0,0,0,1};
				colorDamaged[]={1,0,0,1};
				shadow=0;
			};
			class UnitVehicleStatus
			{
				x=0;
				y=0;
				w=0.028000001;
				h=0.039999999;
				texture="#(argb,8,8,3)color(0,0,0,1)";
			};
			class Semaphore
			{
				x=0;
				y=0;
				w=0.039999999;
				h=0.029999999;
				color[]={0.80000001,0,0,1};
				texture="#(argb,8,8,3)color(1,1,1,1)";
				shadow=0;
			};
			class CommandBackground
			{
				x=0;
				y=0;
				w=0.039999999;
				h=0.029999999;
				color[]={1,1,1,1};
				texture="#(argb,8,8,3)color(1,1,1,1)";
				shadow=0;
			};
			class HoldFire
			{
				x=0;
				y=0;
				w=0.028000001;
				h=0.039999999;
				color[]={1,1,1,1};
				texture="#(argb,8,8,3)color(1,1,1,1)";
				shadow=0;
			};
			class OrderBackground
			{
				x=0.1;
				y=0.1;
				w=0.039999999;
				h=0.029999999;
				color[]={1,1,1,1};
				texture="#(argb,8,8,3)color(1,1,1,1)";
				shadow=0;
			};
			class OrderText
			{
				x=0.1;
				y=0.1;
				w=0.039999999;
				h=0.029999999;
				colorText[]={1,1,1,1};
				font="TahomaB";
				SizeEx=0.050000001;
				shadow=0;
			};
			class VehicleBackground
			{
				x=0.1;
				y=0.1;
				w=0.039999999;
				h=0.029999999;
				color[]={1,1,1,1};
				texture="#(argb,8,8,3)color(1,1,1,1)";
				shadow=0;
			};
			class VehicleText
			{
				x=0.1;
				y=0.1;
				w=0.039999999;
				h=0.029999999;
				colorText[]={1,1,1,1};
				font="TahomaB";
				SizeEx=0.050000001;
				shadow=0;
			};
			class UnitSpecialRole
			{
				x=0.1;
				y=0.1;
				w=0.039999999;
				h=0.029999999;
				color[]={1,1,1,1};
				texture="#(argb,8,8,3)color(1,1,1,1)";
				shadow=0;
			};
			class UnitRole
			{
				x=0.1;
				y=0.1;
				w=0.039999999;
				h=0.029999999;
				color[]={1,1,1,1};
				texture="#(argb,8,8,3)color(1,1,1,1)";
				shadow=0;
			};
			class UnitNumberBackground
			{
				x=0.1;
				y=0.1;
				w=0.039999999;
				h=0.029999999;
				color[]={0.5,0.5,0.5,0.5};
				texture="#(argb,8,8,3)color(1,1,1,1)";
				shadow=0;
			};
			class UnitNumberText
			{
				x=0.1;
				y=0.1;
				w=0.039999999;
				h=0.029999999;
				font="TahomaB";
				SizeEx=0.050000001;
				text="";
				shadow=0;
			};
			class CommandText
			{
				x=0.045000002;
				y=0;
				w=0.090999998;
				h=0.033;
				color[]={1,1,1,1};
				font="TahomaB";
				SizeEx=0.050000001;
				shadow=0;
			};
			class VehicleNumberText
			{
				x=0.045000002;
				y=0;
				w=0.090999998;
				h=0.033;
				color[]={1,1,1,1};
				font="TahomaB";
				SizeEx=0.050000001;
				shadow=0;
			};
			class VehicleNumberBackground
			{
				x=0.1;
				y=0.1;
				w=0.039999999;
				h=0.029999999;
				color[]={0.5,0.5,0.5,0.5};
				texture="#(argb,8,8,3)color(1,1,1,1)";
				shadow=0;
			};
			class CombatMode
			{
				x=0.017000001;
				y=0.064000003;
				w=0.029999999;
				h=0.029999999;
				textureMCareless="#(argb,8,8,3)color(1,1,1,1)";
				textureMSafe="#(argb,8,8,3)color(0,1,0,1)";
				textureMAware="#(argb,8,8,3)color(1,1,0,1)";
				textureMCombat="#(argb,8,8,3)color(1,0,0,1)";
				textureMStealth="#(argb,8,8,3)color(0,0,0,1)";
				shadow=0;
			};
			class VehicleStatus
			{
				x=0;
				y=0;
				w=0;
				h=0;
				color[]={0.5,0.5,0.5,0.5};
				shadow=0;
			};
			class UnitCombatMode
			{
				x=0.017000001;
				y=0.064000003;
				w=0.029999999;
				h=0.029999999;
				textureMCareless="#(argb,8,8,3)color(1,1,1,1)";
				textureMSafe="#(argb,8,8,3)color(0,1,0,1)";
				textureMAware="#(argb,8,8,3)color(1,1,0,1)";
				textureMCombat="#(argb,8,8,3)color(1,0,0,1)";
				textureMStealth="#(argb,8,8,3)color(0,0,0,1)";
				texture="#(argb,8,8,3)color(0,0,0,1)";
				textureBlue="#(argb,8,8,3)color(0,0,1,1)";
				textureWhite="#(argb,8,8,3)color(1,1,1,1)";
				textureYellow="#(argb,8,8,3)color(1,1,0,1)";
				textureRed="#(argb,8,8,3)color(1,0,0,1)";
				textureGreen="#(argb,8,8,3)color(0,1,0,1)";
				colorBlue[]={0,0,0,0};
				colorGreen[]={0,0,0,0};
				colorWhite[]={0,0,0,0};
				colorYellow[]={0,0,0,0};
				colorRed[]={0,0,0,0};
				shadow=0;
				class UnitCombatMode
				{
					textureBlue="#(argb,8,8,3)color(0,0,1,1)";
					textureWhite="#(argb,8,8,3)color(1,1,1,1)";
					textureYellow="#(argb,8,8,3)color(1,1,0,1)";
					textureRed="#(argb,8,8,3)color(1,0,0,1)";
					textureGreen="#(argb,8,8,3)color(0,1,0,1)";
				};
			};
			class UnitNameBackground
			{
				x=0.017000001;
				y=0.064000003;
				w=0.029999999;
				h=0.029999999;
				textureNormal="#(argb,8,8,3)color(1,1,1,1)";
				texturePlayer="#(argb,8,8,3)color(0,1,0,1)";
				textureSelected="#(argb,8,8,3)color(1,1,0,1)";
				textureFocus="#(argb,8,8,3)color(1,0,0,1)";
				colorBlue[]={0,0,0,0};
				colorGreen[]={0,0,0,0};
				colorWhite[]={0,0,0,0};
				colorYellow[]={0,0,0,0};
				colorRed[]={0,0,0,0};
				shadow=0;
			};
			class UnitName
			{
				x=0.017000001;
				y=0.064000003;
				w=0.029999999;
				h=0.029999999;
				colorText[]={0,0,0,0};
				font="TahomaB";
				SizeEx=0.050000001;
				shadow=0;
			};
			class UnitBehavior
			{
				x=0.017000001;
				y=0.064000003;
				w=0.029999999;
				h=0.029999999;
				textureMCareless="#(argb,8,8,3)color(1,1,1,1)";
				textureMSafe="#(argb,8,8,3)color(0,1,0,1)";
				textureMAware="#(argb,8,8,3)color(1,1,0,1)";
				textureMCombat="#(argb,8,8,3)color(1,0,0,1)";
				textureMStealth="#(argb,8,8,3)color(0,0,0,1)";
				colorCareless[]={0,0,0,0};
				colorSafe[]={0,0,0,0};
				colorAware[]={0,0,0,0};
				colorCombat[]={0,0,0,0};
				colorStealth[]={0,0,0,0};
				shadow=0;
			};
			class VehicleRole
			{
				x=0;
				y=0;
				w=0;
				h=0;
				color[]={0.5,0.5,0.5,0.5};
				shadow=0;
			};
			class VehicleIcon
			{
				x=0;
				y=0;
				w=0;
				h=0;
				color[]={0.5,0.5,0.5,0.5};
				shadow=0;
			};
			class UnitRank
			{
				x=0;
				y=0;
				w=0;
				h=0;
				color[]={0.5,0.5,0.5,0.5};
				shadow=0;
			};
			class UnitStatus
			{
				x=0;
				y=0;
				w=0;
				h=0;
				color[]={0.5,0.5,0.5,0.5};
				shadow=0;
				texture="#(argb,8,8,3)color(0,0,0,1)";
			};
		};
	};
	class ConnectionLost
	{
		left=0;
		top=0.44999999;
		width=1;
		height=0.1;
		font="TahomaB";
		size="( 16 / 408 )";
		color[]={1,0.5,0.25,1};
		shadow=0;
	};
	class Cursor
	{
		aim="#(argb,8,8,3)color(1,1,1,1)";
		weapon="#(argb,8,8,3)color(1,1,1,1)";
		freelook="#(argb,8,8,3)color(1,1,1,1)";
		outArrow="#(argb,8,8,3)color(1,1,1,1)";
		select_target="#(argb,8,8,3)color(1,1,1,1)";
		known_target="#(argb,8,8,3)color(1,1,1,1)";
		lock_target="#(argb,8,8,3)color(1,1,1,1)";
		gunner_lock="#(argb,8,8,3)color(1,1,1,1)";
		me="#(argb,8,8,3)color(1,1,1,1)";
		meColor[]={0.80000001,0.80000001,0.80000001,0.64999998};
		dimmMe=0;
		dimmMeStartTime=5;
		dimmMeEndTime=10;
		dimmCmdStartTime=5;
		dimmCmdEndTime=10;
		dimmTactPingStartTime=10;
		dimmTactPingEndTime=20;
		select="#(argb,8,8,3)color(1,1,1,1)";
		selectDead="";
		selectDeadDimStartTime=5;
		selectDeadDimEndTime=5.5;
		selectColor[]={0,0.60000002,0,0.64999998};
		leader="#(argb,8,8,3)color(1,1,1,1)";
		leaderColor[]={0,0.60000002,0,0.64999998};
		mission="#(argb,8,8,3)color(1,1,1,1)";
		missionFade=0.30000001;
		missionColor1[]={0.80000001,0.60000002,0,0.5};
		missionColor2[]={0.80000001,0.60000002,0,1};
		textOffsetDefault=-0.044;
		textOffsetFormation=-0.050000001;
		textOffsetCustom=-0.050000001;
		textOffsetWaypoint=-0.050000001;
		customMark="#(argb,8,8,3)color(1,0.5,0,1)";
		customMarkColor[]={0.80000001,0.80000001,0.80000001,1};
		formationMark="#(argb,8,8,3)color(0.75,0,0.75,1)";
		waypointMark="#(argb,8,8,3)color(0,1,1,1)";
		waypointColor[]={0.80000001,0.80000001,0.80000001,1};
		blinkingPeriod=2;
		unitUnconscious="#(argb,8,8,3)color(1,0,0,1)";
		unitBleeding="#(argb,8,8,3)color(1,0,0,1)";
		iconBoardOut="#(argb,8,8,3)color(1,1,1,1)";
		selectOver="#(argb,8,8,3)color(1,1,1,1)";
		unitUnconsciousColor[]={0.69999999,0.1,0,0.64999998};
		iconComplex="#(argb,8,8,3)color(1,1,1,1)";
		iconCursorSupport="#(argb,8,8,3)color(0,0,0,0)";
		iconRepairVehicle="#(argb,8,8,3)color(1,1,0,1)";
		iconTakeBackpack="#(argb,8,8,3)color(1,1,0,1)";
		iconAssemble="#(argb,8,8,3)color(1,1,0,1)";
		iconDisassemble="#(argb,8,8,3)color(1,1,0,1)";
		freeLookActionColor[]={0.69999999,0.1,0,1};
		freeLookActionColorSelected[]={0,0.60000002,0,1};
		freeLookActionColorAvailable[]={0.1,0.1,0.89999998,1};
		explosive="#(argb,8,8,3)color(1,0,0,1)";
		explosiveColor[]={0.69999999,0.1,0,1};
		shadow=0;
		infoTextShadow=0;
		font="TahomaB";
		size="( 16 / 408 )";
		tactical="#(argb,8,8,3)color(1,1,1,1)";
		move="#(argb,8,8,3)color(1,1,1,1)";
		selected="#(argb,8,8,3)color(1,1,1,1)";
		attack="#(argb,8,8,3)color(1,1,1,1)";
		getIn="#(argb,8,8,3)color(1,1,1,1)";
		watch="#(argb,8,8,3)color(1,1,1,1)";
		color[]={0.80000001,0.80000001,0.80000001,1};
		colorBackground[]={0,0,0,0.64999998};
		colorLocked[]={0.69999999,0.1,0,1};
		dimm=0.15000001;
		assault="#(argb,8,8,3)color(1,1,1,1)";
		assaultNoLOS="#(argb,8,8,3)color(1,1,1,1)";
		iconBoardIn="#(argb,8,8,3)color(1,1,1,1)";
		iconMove="#(argb,8,8,3)color(1,1,1,1)";
		iconJoin="#(argb,8,8,3)color(1,1,1,1)";
		iconRepairAt="#(argb,8,8,3)color(1,1,1,1)";
		iconHealAt="#(argb,8,8,3)color(0,0,0,0)";
		iconRearmAt="#(argb,8,8,3)color(1,1,1,1)";
		iconRefuelAt="#(argb,8,8,3)color(1,1,1,1)";
		iconSupport="#(argb,8,8,3)color(0,0,0,0)";
		iconInFormation="#(argb,8,8,3)color(0,0,0,0)";
		board="#(argb,8,8,3)color(0,0,0,0)";
		assaultColor[]={0,0,0,1};
		assaultNoLOSColor[]={0,0,0,0.5};
		boardColor[]={0,0,0,1};
		iconMoveColor[]={0,0,0,1};
		iconJoinColor[]={0,0,0,1};
		iconHealAtColor[]={0,0,0,1};
		iconRepairAtColor[]={0,0,0,1};
		iconRearmAtColor[]={0,0,0,1};
		iconRefuelAtColor[]={0,0,0,1};
		iconSupportColor[]={0,0,0,1};
		iconInFormationColor[]={0,0,0,1};
		class Sign
		{
			height=0.015;
			widthSector=0.02;
			widthGroup=0.0099999998;
			widthUnit=0.0099999998;
		};
		activeWidth=0.1875;
		activeHeight=0.25;
		activeMinimum=0.07;
		activeMaximum=0.12;
		enemyActiveColor[]={0.69999999,0.1,0,0.5};
		throwCursorMinScale=1;
		throwCursorMaxScale=2;
		throwCursorFadeSpeed=4;
		class Targeting
		{
			class MarkedTarget
			{
				scale=1;
				texture="#(argb,8,8,3)color(1,1,1,1)";
				color[]={0.94999999,0.050000001,0.25,0.25};
				textureLockable="#(argb,8,8,3)color(1,1,1,1)";
				colorLockable[]={0.94999999,0.94999999,0.94999999,0.75};
				textureFriendly="#(argb,8,8,3)color(1,1,1,1)";
				colorFriendly[]={0.94999999,0.94999999,0.94999999,0.75};
				shadow=0;
			};
			class MarkedTargetNoLos: MarkedTarget
			{
				texture="#(argb,8,8,3)color(1,1,1,1)";
				color[]={0.55000001,0.55000001,0.55000001,0.15000001};
				colorLockable[]={0.94999999,0.94999999,0.94999999,0.15000001};
				colorFriendly[]={0.94999999,0.94999999,0.94999999,0.15000001};
			};
			class Seeker
			{
				texture="#(argb,8,8,3)color(1,1,1,1)";
				color[]={0.55000001,0.34999999,0.94999999,0.5};
				scale=1;
				shadow=0;
			};
			class SeekerLocked: Seeker
			{
				texture="#(argb,8,8,3)color(1,1,1,1)";
				color[]={0.15000001,0.55000001,0.15000001,0.5};
			};
			class SeekerNoLOS: Seeker
			{
				texture="#(argb,8,8,3)color(1,1,1,1)";
				color[]={0.15000001,0.55000001,0.15000001,0.5};
			};
			class ImpactPoint: Seeker
			{
				texture="#(argb,8,8,3)color(1,1,1,1)";
				color[]={0.55000001,0.55000001,0.55000001,0.5};
			};
			class ImpactPointNoLOS: ImpactPoint
			{
				color[]={0.55000001,0,0,0.5};
			};
			class HitPrediction: Seeker
			{
				color[]={0.55000001,0,0,0.5};
			};
			class HitConfirm: Seeker
			{
				color[]={0,0.55000001,0,0.5};
			};
			class KnownTarget: Seeker
			{
				texture="#(argb,8,8,3)color(1,1,1,1)";
				color[]={0.050000001,0.050000001,0.55000001,0.5};
			};
			class LaserTarget: KnownTarget
			{
				texture="#(argb,8,8,3)color(1,1,1,1)";
				color[]={0.050000001,0.050000001,0.55000001,0.5};
			};
		};
		class AssignedTarget
		{
			class Icon
			{
				size=0.022;
				texture="#(argb,8,8,3)color(1,1,1,1)";
				color[]={0.80000001,0,0,1};
				shadow=0;
				textureNoLoS="#(argb,8,8,3)color(1,1,1,1)";
				colorNoLoS[]={0.80000001,0,0,0.5};
				shadowNoLoS=0;
				timeNoLoS=15;
			};
			class Icon3D: Icon
			{
				scale=1;
				texture="#(argb,8,8,3)color(1,1,1,1)";
				color[]={0.80000001,0,0,1};
				shadow=0;
				textureNoLoS="#(argb,8,8,3)color(1,1,1,1)";
				colorNoLoS[]={0.80000001,0,0,0.5};
				shadowNoLoS=0;
				timeNoLoS=15;
				font="GUI_FONT_NORMAL";
				sizeEx="IGUI_TEXT_SIZE_MEDIUM";
			};
		};
		class CrewAimIndicator
		{
			class Commander
			{
				scale=1;
				texture="#(argb,8,8,3)color(1,1,1,1)";
				color[]={0.80000001,0.5,0,1};
				shadow=0;
			};
			class Gunner: Commander
			{
				texture="#(argb,8,8,3)color(1,1,1,1)";
				color[]={0.80000001,0.5,0,1};
			};
			class GunnerReady: Commander
			{
				texture="#(argb,8,8,3)color(1,1,1,1)";
				color[]={0,0.5,0,1};
			};
			class GunnerAuto: Commander
			{
				texture="#(argb,8,8,3)color(1,1,1,1)";
				color[]={0.80000001,0.5,1,1};
			};
		};
	};
	class PeripheralVision
	{
		cueTexture="#(argb,8,8,3)color(1,1,1,1)";
		bloodTexture="#(argb,8,8,3)color(1,1,1,1)";
		bloodColor[]={0.80000001,0.1,0.15000001,1};
		cueColor[]={1,1,1,0.69999999};
		cueEnemyColor[]={1,0.30000001,0.30000001,1};
		cueFriendlyColor[]={0.5,1,0.5,0.69999999};
		shadow=0;
	};
	class HitZones
	{
		colorEmpty[]={1,1,1,0.1};
	};
	class CfgStaminaBar
	{
		textureEncumbranceBar="#(argb,8,8,3)color(0.3,0.3,0.3,1)";
		textureStaminaBar="#(argb,8,8,3)color(1,1,1,1)";
		textureArrowLeft="#(argb,8,8,3)color(0,0,0,0)";
		textureArrowRight="#(argb,8,8,3)color(0,0,0,0)";
		textureIconTerrain="#(argb,8,8,3)color(1,1,1,1)";
		textureIconInjury="#(argb,8,8,3)color(1,0,0,1)";
		warningRate=-0.89999998;
	};
};
class cfgGroupIcons
{
	class hc_selectable
	{
		name="$STR_A3_cfgGroupIcons_hc_selectable0";
		icon="#(argb,8,8,3)color(1,1,1,1)";
		size=48;
		side=1;
		color[]={0,0,1,1};
		shadow=0;
	};
	class hc_selected
	{
		name="$STR_A3_cfgGroupIcons_hc_selected0";
		icon="#(argb,8,8,3)color(1,1,1,1)";
		size=48;
		side=1;
		color[]={0,0,1,1};
		shadow=0;
	};
	class hc_selectedEnemy
	{
		name="$STR_A3_cfgGroupIcons_hc_selectedEnemy0";
		icon="#(argb,8,8,3)color(1,1,1,1)";
		size=48;
		side=1;
		color[]={0,0,1,1};
		shadow=0;
	};
	class waypoint
	{
		name="$STR_A3_cfgGroupIcons_waypoint0";
		icon="#(argb,8,8,3)color(1,1,1,1)";
		size=48;
		side=1;
		color[]={0,0,1,1};
		shadow=0;
	};
	maxHCDistanceAlphaEnd=1500;
	maxHCDistanceAlphaStart=1000;
	HC3DGroupAlpha=0.40000001;
};
class CfgTaskTypes
{
	class Default
	{
		icon="#(argb,8,8,3)color(1,1,1,1)";
	};
};
class CfgSimpleTasks
{
	class TaskOverview
	{
		dimmStartTime=0;
		dimmEndTime=0.30000001;
	};
	class Icon
	{
		colorText[]={0.80000001,0.80000001,0.80000001,1};
		colorTextAssigned[]={0.80000001,0.60000002,0,1};
		colorTextCustom[]={0.1,0.1,0.89999998,1};
		colorIcon[]={0.80000001,0.80000001,0.80000001,1};
		colorIconAssigned[]={0.80000001,0.60000002,0,1};
		colorIconCustom[]={0.1,0.1,0.89999998,1};
		colorBackground[]={0,0,0,0.5};
		colorBackgroundAssigned[]={0,0,0,0.5};
		colorBackgroundCustom[]={0,0,0,0.5};
		sizeBackground=0.022;
		sizeIcon=0.016000001;
	};
	class Icon3D: Icon
	{
		font="TahomaB";
		sizeEx="( 21 / 408 )";
		textureBackground="#(argb,8,8,3)color(1,1,1,1)";
		iconOffset=-0.0040000002;
		yOffsetExact=0.2;
		yOffsetNonExact=0;
		shadowForeground=2;
		shadowBackground=0;
		shadowText=2;
		maxVisible=0;
		class DistanceClose
		{
			range[]={0,300};
			scale=1;
			alphaMultiplier=1;
			showDistance=1;
			textOffset=0;
		};
		class DistanceMid
		{
			range[]={300,1000};
			scale=0.75;
			alphaMultiplier=0.80000001;
			showDistance=1;
			textOffset=0;
		};
		class DistanceLong
		{
			range[]={1000,20000};
			scale=0.5;
			alphaMultiplier=0.60000002;
			showDistance=0;
			textOffset=0;
		};
	};
	class Icon2D: Icon
	{
		colorText[]={0.80000001,0.80000001,0.80000001,1};
		colorTextAssigned[]={0.80000001,0.60000002,0,1};
		colorTextCustom[]={0.1,0.1,0.89999998,1};
		colorIcon[]={0.80000001,0.80000001,0.80000001,1};
		colorIconAssigned[]={0.80000001,0.60000002,0,1};
		colorIconCustom[]={0.1,0.1,0.89999998,1};
		colorBackground[]={0,0,0,0.5};
		colorBackgroundAssigned[]={0,0,0,0.5};
		colorBackgroundCustom[]={0,0,0,0.5};
		mouseoverZoom=1.5;
		selectedAlpha=1;
		sizeInverted=0.028999999;
		sizeBackground=0.033;
		sizeIcon=0.027000001;
	};
	class Tooltip: Icon
	{
		textAssigned="Assigned";
		textUnAssigned="Unassigned";
		textClkAssign="Click to assign";
		textClkUnAssign="Click to unassign";
		selectedAlpha=1;
		widthMin=0.23999999;
		widthMax=0.47999999;
		class Title
		{
			font="GUI_FONT_NORMAL";
			sizeEx="GUI_TEXT_SIZE_SMALL * 1.2";
			left="GUI_TEXT_SIZE_SMALL / 2";
			top="GUI_TEXT_SIZE_SMALL * 0.03";
		};
		class SubTitle
		{
			font="GUI_FONT_THIN";
			sizeEx="GUI_TEXT_SIZE_SMALL * 0.9";
			left="GUI_TEXT_SIZE_SMALL / 2";
			top="GUI_TEXT_SIZE_SMALL * 1.05";
		};
		class CustomText
		{
			font="GUI_FONT_THIN";
			sizeEx="GUI_TEXT_SIZE_SMALL * 0.9";
			right="GUI_TEXT_SIZE_SMALL * 0.9";
			top="GUI_TEXT_SIZE_SMALL * 1.05";
		};
		class CustomIcon
		{
			sizeEx="GUI_TEXT_SIZE_SMALL * 0.6";
			right="GUI_TEXT_SIZE_SMALL * 0.8";
			top="GUI_TEXT_SIZE_SMALL * 1.09";
		};
	};
};
class CfgDiary
{
	class FixedPages
	{
		class Tasks
		{
			type="DiaryPageTasks";
			displayName="$STR_LOGSUBJECT_BRIEFING";
			picture="#(argb,8,8,3)color(1,1,1,1)";
			shortcuts[]={};
			showEmpty=0;
			indexTitle="%TASK_DESCRIPTION_SHORT";
			indexIcon="%ICON_TASK_STATE";
			recordTitle="%DATE, %TIME";
			text="<font color='#ffffffff' size='14' face='RobotoCondensedLight'>%TASK_BUTTON_ASSIGN_ICON%TASK_BUTTON_ASSIGN_TEXT  %TASK_BUTTON_LOCATE_ICON %TASK_BUTTON_LOCATE_TEXT</font><br/><br/>%TASK_DESCRIPTION";
			text3D="<font color='#ffffffff' size='14' face='RobotoCondensedLight'>%TASK_BUTTON_ASSIGN_ICON%TASK_BUTTON_ASSIGN_TEXT</font><br/><br/>%TASK_DESCRIPTION";
			iconSize=14;
			iconButtonLocate="#(argb,8,8,3)color(1,1,1,1)";
			iconButtonAssign="#(argb,8,8,3)color(1,1,1,1)";
			iconButtonUnassign="#(argb,8,8,3)color(1,1,1,1)";
			textButtonAssign="Assign";
			textButtonUnassign="Unassign";
			textButtonLocate="Locate";
			textButtonLocateDistance="%1";
			colorTokenDisabled="#80ffffff";
		};
		class Diary
		{
			type="DiaryPageDiary";
			displayName="$STR_LOGSUBJECT_DIARY";
			picture="#(argb,8,8,3)color(1,1,1,1)";
			shortcuts[]={};
			showEmpty=0;
			indexTitle="%TITLE";
			indexIcon="";
			recordTitle="%DATE, %TIME";
			text="%TEXT";
		};
		class Conversation
		{
			type="DiaryPageConversation";
			displayName="$STR_LOGSUBJECT_CONVERSATION";
			picture="#(argb,8,8,3)color(1,1,1,1)";
			shortcuts[]={};
			showEmpty=0;
			indexTitle="%UNIT_NAME";
			indexIcon="";
			recordTitle="%TARGET_NAME";
			text="%TEXT";
		};
		class Units
		{
			type="DiaryPageUnits";
			displayName="$STR_DISP_SRVSETUP_UNITS";
			picture="#(argb,8,8,3)color(1,1,1,1)";
			shortcuts[]={};
			showEmpty=0;
			indexTitle="%UNIT_NAME";
			indexIcon="%ICON_UNIT_TYPE";
			recordTitle="%UNIT_NAME";
			text="%UNIT_GRP_NAME %UNIT_ID%UNIT_GRP_LEADER<br/>%$STR_GEAR_VEHICLE %UNIT_VEH_NAME %UNIT_VEH_POSITION<br/><br/>%LINK_UNIT_GEAR%LINK_UNIT_TEAMSWITCH%LINK_UNIT_CONVERSATION";
			skill=" - %SKILL_NAME ... %SKILL_LEVEL<br/>";
		};
		class Players
		{
			type="DiaryPagePlayers";
			displayName="$STR_LOGSUBJECT_PLAYERS";
			picture="#(argb,8,8,3)color(1,1,1,1)";
			shortcuts[]={};
			showEmpty=0;
			indexTitle="%PLAYER_NAME";
			indexIcon="%ICON_PLAYERS_STATE";
			recordTitle="%PLAYER_NAME";
			text="%$STR_DISP_MP_PING %PLAYER_PING_MIN %PLAYER_PING_AVG %PLAYER_PING_MAX<br/>%$STR_DISP_MP_BANDWIDTH %PLAYER_BANDWIDTH_MIN %PLAYER_BANDWIDTH_AVG %PLAYER_BANDWIDTH_MAX<br/>%$STR_DISP_MP_DESYNC %PLAYER_DESYNC<br/><br/>%PLAYER_SQUAD<br/>%LINK_PLAYER_KICK%LINK_PLAYER_BAN%LINK_PLAYER_VOTEKICK%LINK_PLAYER_VOTEADMIN%LINK_PLAYER_MUTE";
			textSquad="%$STR_DISP_MP_PL_NAME %PLAYER_FULLNAME<br/>%$STR_DISP_MP_PL_MAIL %PLAYER_EMAIL<br/>%$STR_DISP_MP_PL_ICQ %PLAYER_ICQ<br/>%$STR_DISP_MP_PL_REMARK %PLAYER_REMARK<br/><br/>%$STR_DISP_MP_PING %PLAYER_PING_MIN %PLAYER_PING_AVG %PLAYER_PING_MAX<br/>%$STR_DISP_MP_BANDWIDTH %PLAYER_BANDWIDTH_MIN %PLAYER_BANDWIDTH_AVG %PLAYER_BANDWIDTH_MAX<br/>%$STR_DISP_MP_DESYNC %PLAYER_DESYNC<br/><br/>%PLAYER_SQUAD<br/>%LINK_PLAYER_KICK%LINK_PLAYER_BAN%LINK_PLAYER_VOTEKICK%LINK_PLAYER_VOTEADMIN%LINK_PLAYER_MUTE";
			textUnit="<br/>%$STR_DISP_MP_PING %PLAYER_PING_MIN %PLAYER_PING_AVG %PLAYER_PING_MAX<br/>%$STR_DISP_MP_BANDWIDTH %PLAYER_BANDWIDTH_MIN %PLAYER_BANDWIDTH_AVG %PLAYER_BANDWIDTH_MAX<br/>%$STR_DISP_MP_DESYNC %PLAYER_DESYNC<br/><br/>%PLAYER_SQUAD<br/>%LINK_PLAYER_KICK%LINK_PLAYER_BAN%LINK_PLAYER_VOTEKICK%LINK_PLAYER_VOTEADMIN%LINK_PLAYER_MUTE";
			squad="%$STR_DISP_MP_SQ<br/>  %$STR_DISP_MP_SQ_NAME %SQUAD_NAME<br/>  %$STR_DISP_MP_SQ_ID %SQUAD_ID<br/>  %$STR_DISP_MP_SQ_MAIL %SQUAD_EMAIL<br/>  %$STR_DISP_MP_SQ_WEB %SQUAD_WEB<br/>  <img image width=80 height=80 image='%SQUAD_PICTURE'><br/>%SQUAD_TITLE";
			unit="%$STR_DISP_MP_SQ<br/>  %$STR_DISP_MP_SQ_NAME %SQUAD_NAME<br/>  %$STR_DISP_MP_SQ_ID %SQUAD_ID<br/>  %$STR_DISP_MP_SQ_MAIL %SQUAD_EMAIL<br/>  %$STR_DISP_MP_SQ_WEB %SQUAD_WEB<br/>  <img image width=80 height=80 image='%SQUAD_PICTURE'><br/>%SQUAD_TITLE";
		};
		class Statistics
		{
			type="DiaryPageStatistics";
			displayName="$STR_LOGSUBJECT_STATISTICS";
			picture="#(argb,8,8,3)color(1,1,1,1)";
			shortcuts[]={};
			showEmpty=0;
			indexTitle="%$STR_LOGSUBJECT_STATISTICS";
			indexIcon="";
			recordTitle="%$STR_STAT_MISSION";
			text="%$STR_BRIEF_YOURKILLS<br/>%STAT_KILLS_ENEMY<br/>%$STR_BRIEF_YOURKILLS_FRIENDLY<br/>%STAT_KILLS_FRIENDLY<br/>%$STR_BRIEF_YOURKILLS_CIVIL<br/>%STAT_KILLS_CIVIL%<br/>%$STR_BRIEF_CASUALTIES<br/>%STAT_CASUALTIES";
			killsOnce="  %NAME<br/>";
			kills="  %COUNT x %NAME<br/>";
			casualtiesPlayerTotalOnce="  You (%NAME)<br/>";
			casualtiesPlayerTotal="  %COUNT x you (%NAME)<br/>";
			casualtiesPlayerOnce="  - by %NAME<br/>";
			casualtiesPlayer="  - %COUNT x by %NAME<br/>";
			casualtiesOnce="  %NAME<br/>";
			casualties="  %COUNT x %NAME<br/>";
		};
	};
	class Icons
	{
		unitNone="#(argb,8,8,3)color(0,0,0,0)";
		unitGroup="#(argb,8,8,3)color(0,1,0,1)";
		unitPlayable="#(argb,8,8,3)color(1,0,0,1)";
		unitGroupPlayable="#(argb,8,8,3)color(1,0.5,0,1)";
		taskNone="#(argb,8,8,3)color(0,0,0,0)";
		taskCreated="#(argb,8,8,3)color(0,0,0,1)";
		taskAssigned="#(argb,8,8,3)color(1,1,1,1)";
		taskSucceeded="#(argb,8,8,3)color(0,1,0,1)";
		taskFailed="#(argb,8,8,3)color(1,0,0,1)";
		taskCanceled="#(argb,8,8,3)color(1,0.5,0,1)";
		playerWest="#(argb,8,8,3)color(0,0,1,1)";
		playerEast="#(argb,8,8,3)color(1,0,0,1)";
		playerCiv="#(argb,8,8,3)color(1,1,1,1)";
		playerGuer="#(argb,8,8,3)color(0,1,0,1)";
		playerUnknown="#(argb,8,8,3)color(0,0,0,1)";
		playerBriefWest="#(argb,8,8,3)color(0,0,1,1)";
		playerBriefEast="#(argb,8,8,3)color(1,0,0,1)";
		playerBriefGuer="#(argb,8,8,3)color(0,1,0,1)";
		playerBriefCiv="#(argb,8,8,3)color(1,1,1,1)";
		playerBriefUnknown="#(argb,8,8,3)color(0,0,0,1)";
		playerConnecting="#(argb,8,8,3)color(0,0,0,1)";
	};
	class TaskIndex
	{
		taskSucceeded="#(argb,8,8,3)color(0,1,0,1)";
		taskFailed="#(argb,8,8,3)color(1,0,0,1)";
		taskCanceled="#(argb,8,8,3)color(1,0.5,0,1)";
		colorAssigned[]={0.80000001,0.60000002,0,1};
		colorCustom[]={0.1,0.1,0.89999998,1};
		colorCreated[]={0.80000001,0.80000001,0.80000001,1};
		colorDone[]={0.2,0.2,0.2,0.5};
		colorCanceled[]={0.2,0.2,0.2,0.5};
		colorFailed[]={0.2,0.2,0.2,0.5};
	};
	class Debriefing
	{
		taskSucceeded="#(argb,8,8,3)color(0,1,0,1)";
		taskFailed="#(argb,8,8,3)color(1,0,0,1)";
		taskCanceled="#(argb,8,8,3)color(1,0.5,0,1)";
		colorCreated[]={0.80000001,0.80000001,0.80000001,1};
		colorDone[]={0.2,0.2,0.2,0.5};
		colorCanceled[]={0.2,0.2,0.2,0.5};
		colorFailed[]={0.2,0.2,0.2,0.5};
	};
};
class CfgActions
{
	class None
	{
		priority=0;
		show=1;
		showWindow=0;
		hideOnUse=1;
		shortcut="";
		text="";
		textDefault="";
		textSimple="";
	};
	class HookCargo: None
	{
		priority=3;
		text="$STR_ACTION_HOOK";
	};
	class UnhookCargo: None
	{
		priority=3;
		text="$STR_ACTION_UNHOOK";
	};
	class LoadVehicle: None
	{
		priority=3;
		text="$STR_A3_ACTION_LOAD_VEHICLE";
	};
	class UnloadVehicle: None
	{
		priority=3;
		text="$STR_A3_ACTION_UNLOAD_VEHICLE";
	};
	class UnloadAllVehicles: None
	{
		priority=3;
		text="$STR_A3_ACTION_UNLOAD_ALL_VEHICLES";
	};
	class GetInCommander: None
	{
		priority=0.89899999;
		showWindow=1;
		text="$STR_ACTION_GETIN_COMMANDER";
		textDefault="$STR_ACTION_GETIN_COMMANDER";
	};
	class GetInDriver: None
	{
		priority=0.89999998;
		showWindow=1;
		text="$STR_ACTION_GETIN_DRIVER";
		textDefault="$STR_ACTION_GETIN_DRIVER";
	};
	class GetInPilot: None
	{
		priority=0.90100002;
		showWindow=1;
		text="$STR_ACTION_GETIN_PILOT";
		textDefault="$STR_ACTION_GETIN_PILOT";
	};
	class GetInGunner: None
	{
		priority=0.898;
		showWindow=1;
		text="$STR_ACTION_GETIN_GUNNER";
		textDefault="$STR_ACTION_GETIN_GUNNER";
	};
	class GetInCargo: None
	{
		priority=0.89700001;
		showWindow=1;
		text="$STR_ACTION_GETIN_CARGO";
		textDefault="$STR_ACTION_GETIN_CARGO";
	};
	class GetInTurret: None
	{
		priority=0.898;
		showWindow=1;
		text="$STR_ACTION_GETIN_TURRET";
		textDefault="$STR_ACTION_GETIN_TURRET";
	};
	class PutInPilot: None
	{
		priority=0.90499997;
		showWindow=1;
		text="$STR_ACTION_PUTIN_PILOT";
		textDefault="$STR_ACTION_PUTIN_PILOT";
	};
	class PutInDriver: None
	{
		priority=0.90600002;
		showWindow=1;
		text="$STR_ACTION_PUTIN_DRIVER";
		textDefault="$STR_ACTION_PUTIN_DRIVER";
	};
	class PutInCargo: None
	{
		priority=0.90700001;
		showWindow=1;
		text="$STR_ACTION_PUTIN_CARGO";
		textDefault="$STR_ACTION_PUTIN_CARGO";
	};
	class Heal: None
	{
		priority=0.60000002;
		showWindow=1;
		text="$STR_ACTION_HEAL";
		textDefault="$STR_ACTION_HEAL";
	};
	class HealSoldier: None
	{
		priority=0.60000002;
		showWindow=1;
		text="$STR_ACTION_HEAL_SOLDIER";
		textDefault="$STR_ACTION_HEAL_SOLDIER";
	};
	class RepairVehicle: None
	{
		priority=0.60000002;
		showWindow=1;
		text="$STR_ACTION_REPAIR_VEHICLE";
		textDefault="$STR_ACTION_REPAIR_VEHICLE";
	};
	class FirstAid: None
	{
		priority=0.60000002;
		showWindow=1;
		text="$STR_ACTION_FIRST_AID";
		textDefault="$STR_ACTION_FIRST_AID";
	};
	class DragSoldier: None
	{
		priority=0.60000002;
		text="Drag %1";
	};
	class DragSoldierInterrupt: None
	{
		priority=0.60000002;
		text="Drop Draged";
	};
	class CarrySoldier: None
	{
		priority=0.60000002;
		text="Carry %1";
	};
	class CarrySoldierInterrupt: None
	{
		priority=0.60000002;
		text="Drop Body";
	};
	class DropCarried: None
	{
		priority=0.60000002;
		text="Drop Carried";
	};
	class Repair: None
	{
		priority=0.5;
		showWindow=1;
		text="$STR_ACTION_REPAIR";
		textDefault="$STR_ACTION_REPAIR";
	};
	class Refuel: None
	{
		priority=0.5;
		showWindow=1;
		text="$STR_ACTION_REFUEL";
		textDefault="$STR_ACTION_REFUEL";
	};
	class Rearm: None
	{
		priority=0.5;
		showWindow=1;
		text="$STR_ACTION_REARM";
		textDefault="$STR_ACTION_REARM";
	};
	class GetOut: None
	{
		priority=0.89999998;
		showWindow=1;
		shortcut="GetOut";
		text="$STR_ACTION_GETOUT";
		textDefault="$STR_ACTION_GETOUT";
	};
	class LightOn: None
	{
		shortcut="Headlights";
		priority=0.30000001;
		text="$STR_ACTION_LIGHTON";
		textDefault="$STR_ACTION_LIGHTON";
	};
	class LightOff: LightOn
	{
		shortcut="Headlights";
		text="$STR_ACTION_LIGHTOFF";
		textDefault="$STR_ACTION_LIGHTOFF";
	};
	class SearchLightOn: None
	{
		priority=0.30000001;
		show=1;
		text="$STR_ACTION_SEARCHLIGHTS_ON";
		textDefault="$STR_ACTION_SEARCHLIGHTS_ON";
	};
	class SearchLightOff: SearchLightOn
	{
		text="$STR_ACTION_SEARCHLIGHTS_OFF";
		textDefault="$STR_ACTION_SEARCHLIGHTS_OFF";
	};
	class CollisionLightOn: None
	{
		priority=0.30000001;
		show=1;
		text="$STR_ACTION_COLLISIONLIGHTS_ON";
		textDefault="$STR_ACTION_COLLISIONLIGHTS_ON";
	};
	class CollisionLightOff: CollisionLightOn
	{
		text="$STR_ACTION_COLLISIONLIGHTS_OFF";
		textDefault="$STR_ACTION_COLLISIONLIGHTS_OFF";
	};
	class GunLightOn: None
	{
		priority=0.1;
		show=0;
		text="$STR_ACTION_LIGHTON";
		textDefault="$STR_ACTION_LIGHTON";
	};
	class GunLightOff: None
	{
		priority=0.1;
		show=0;
		text="$STR_ACTION_LIGHTOFF";
		textDefault="$STR_ACTION_LIGHTOFF";
	};
	class ArtilleryComputer: None
	{
		priority=0.1;
		show=1;
		text="$STR_artillery_computer";
		textDefault="$STR_artillery_computer";
	};
	class EngineOn: None
	{
		shortcut="EngineToggle";
		priority=0.1;
		text="$STR_ACTION_ENGINEON";
		textDefault="$STR_ACTION_ENGINEON";
	};
	class EngineOff: None
	{
		shortcut="EngineToggle";
		priority=0.1;
		text="$STR_ACTION_ENGINEOFF";
		textDefault="$STR_ACTION_ENGINEOFF";
	};
	class ActiveSensorsOn: None
	{
		shortcut="ActiveSensorsToggle";
		priority=25;
		text="LOC - Radar on";
		textDefault="LOC - Radar on";
		showWindow=0;
	};
	class ActiveSensorsOff: None
	{
		shortcut="ActiveSensorsToggle";
		priority=25;
		text="LOC - Radar off";
		textDefault="LOC - Radar off";
		showWindow=0;
	};
	class TakeVehicleControl: None
	{
		priority=10.1;
		text="$STR_ACTION_TAKE_CONTROL";
		textDefault="$STR_ACTION_TAKE_CONTROL";
	};
	class SuspendVehicleControl: None
	{
		priority=10.1;
		text="$STR_ACTION_SUSPEND_CONTROL";
		textDefault="$STR_ACTION_SUSPEND_CONTROL";
	};
	class LockVehicleControl: None
	{
		priority=10.1;
		text="$STR_ACTION_LOCK_CONTROL";
		textDefault="$STR_ACTION_LOCK_CONTROL";
	};
	class UnlockVehicleControl: None
	{
		priority=10.1;
		text="$STR_ACTION_UNLOCK_CONTROL";
		textDefault="$STR_ACTION_UNLOCK_CONTROL";
	};
	class SwitchWeapon: None
	{
		priority=0.5;
		shortcut="SwitchWeapon";
		text="$STR_ACTION_WEAPON";
		textDefault="$STR_ACTION_WEAPON";
		hideActions[]={};
	};
	class SwitchMagazine: SwitchWeapon
	{
		shortcut="ReloadMagazine";
	};
	class HideWeapon: SwitchWeapon
	{
		text="$STR_ACTION_HIDE_WEAPON";
		textDefault="$STR_ACTION_HIDE_WEAPON";
	};
	class UseWeapon: None
	{
		priority=0.5;
		text="%1";
		textDefault="%1";
	};
	class LoadMagazine: None
	{
		priority=0.34999999;
		shortcut="ReloadMagazine";
		text="$STR_ACTION_MAGAZINE";
		textDefault="$STR_ACTION_MAGAZINE";
	};
	class LoadOtherMagazine: LoadMagazine
	{
	};
	class LoadEmptyMagazine: LoadMagazine
	{
		priority=1.5;
		showWindow=1;
	};
	class TakeWeapon: None
	{
		priority=0.51999998;
		showWindow=1;
		text="$STR_ACTION_TAKEWEAPON";
		textDefault="$STR_ACTION_TAKEWEAPON";
	};
	class TakeDropWeapon: TakeWeapon
	{
		text="$STR_ACTION_DROPTAKEWEAPON";
		textDefault="$STR_ACTION_DROPTAKEWEAPON";
	};
	class TakeMagazine: None
	{
		priority=0.52999997;
		showWindow=1;
		text="$STR_ACTION_TAKEMAGAZINE";
		textDefault="$STR_ACTION_TAKEMAGAZINE";
	};
	class TakeDropMagazine: TakeMagazine
	{
		text="$STR_ACTION_DROPTAKEMAGAZINE";
		textDefault="$STR_ACTION_DROPTAKEMAGAZINE";
	};
	class TakeFlag: None
	{
		priority=0.99000001;
		showWindow=1;
		text="$STR_ACTION_TAKEFLAG";
		textDefault="$STR_ACTION_TAKEFLAG";
	};
	class ReturnFlag: None
	{
		priority=0.99000001;
		showWindow=1;
		text="$STR_ACTION_RETURNFLAG";
		textDefault="$STR_ACTION_RETURNFLAG";
	};
	class TurnIn: None
	{
		priority=0.94999999;
		shortcut="TurnIn";
		text="$STR_ACTION_TURNIN";
		textDefault="$STR_ACTION_TURNIN";
	};
	class TurnOut: None
	{
		priority=0.60000002;
		shortcut="TurnOut";
		text="$STR_ACTION_TURNOUT";
		textDefault="$STR_ACTION_TURNOUT";
	};
	class WeaponInHand: None
	{
		show=0;
		priority=2;
		text="$STR_ACTION_WEAPONINHAND";
		textDefault="$STR_ACTION_WEAPONINHAND";
	};
	class WeaponOnBack: None
	{
		show=0;
		priority=0.30000001;
		text="$STR_ACTION_WEAPONONBACK";
		textDefault="$STR_ACTION_WEAPONONBACK";
	};
	class SitDown: None
	{
		priority=0.1;
		shortcut="SitDown";
		show=0;
		text="$STR_ACTION_SITDOWN";
		textDefault="$STR_ACTION_SITDOWN";
	};
	class Land: None
	{
		priority=0.89999998;
		text="$STR_ACTION_LAND";
		textDefault="$STR_ACTION_LAND";
	};
	class CancelLand: None
	{
		priority=0.89999998;
		text="$STR_ACTION_CANCEL_LAND";
		textDefault="$STR_ACTION_CANCEL_LAND";
	};
	class Eject: None
	{
		priority=0.050000001;
		shortcut="Eject";
		text="$STR_ACTION_EJECT";
		textDefault="$STR_ACTION_EJECT";
	};
	class MoveToDriver: None
	{
		priority=0.039999999;
		shortcut="SwapGunner";
		text="$STR_ACTION_TO_DRIVER";
		textDefault="$STR_ACTION_TO_DRIVER";
	};
	class MoveToPilot: MoveToDriver
	{
		text="$STR_ACTION_TO_PILOT";
		textDefault="$STR_ACTION_TO_PILOT";
	};
	class MoveToGunner: None
	{
		priority=0.039999999;
		shortcut="SwapGunner";
		text="$STR_ACTION_TO_GUNNER";
		textDefault="$STR_ACTION_TO_GUNNER";
	};
	class MoveToCommander: None
	{
		priority=0.039999999;
		shortcut="SwapGunner";
		text="$STR_ACTION_TO_COMMANDER";
		textDefault="$STR_ACTION_TO_COMMANDER";
	};
	class MoveToCargo: None
	{
		priority=0.0099999998;
		text="$STR_UI_PASSENGER_SEAT";
		textDefault="$STR_UI_PASSENGER_SEAT";
	};
	class MoveToTurret: None
	{
		priority=0.02;
		shortcut="SwapGunner";
		text="$STR_ACTION_TO_TURRET";
		textDefault="$STR_ACTION_TO_TURRET";
	};
	class HideBody: None
	{
		priority=0.50999999;
		text="$STR_ACTION_HIDE_BODY";
		textDefault="$STR_ACTION_HIDE_BODY";
	};
	class TouchOff: None
	{
		priority=0.51499999;
		text="$STR_ACTION_TOUCH_OFF";
		textDefault="$STR_ACTION_TOUCH_OFF";
	};
	class TouchOffMines: None
	{
		priority=0.51499999;
		text="$STR_ACTION_TOUCH_OFF";
		textDefault="$STR_ACTION_TOUCH_OFF";
	};
	class SetTimer: None
	{
		priority=0.51599997;
		showWindow=1;
		text="$STR_ACTION_SET_TIMER";
		textDefault="$STR_ACTION_SET_TIMER";
	};
	class StartTimer: SetTimer
	{
		text="$STR_ACTION_START_TIMER";
		textDefault="$STR_ACTION_START_TIMER";
	};
	class Deactivate: None
	{
		priority=0.514;
		showWindow=1;
		text="$STR_ACTION_DEACTIVATE";
		textDefault="$STR_ACTION_DEACTIVATE";
	};
	class NVGoggles: None
	{
		priority=0.51099998;
		text="$STR_ACTION_TAKEON_GOGGLES";
		textDefault="$STR_ACTION_TAKEON_GOGGLES";
	};
	class NVGogglesOff: NVGoggles
	{
		text="$STR_ACTION_TAKEOFF_GOGGLES";
		textDefault="$STR_ACTION_TAKEOFF_GOGGLES";
	};
	class ManualFire: None
	{
		priority=0.58999997;
		shortcut="HeliManualFire";
		text="$STR_ACTION_MANUAL_FIRE";
		textDefault="$STR_ACTION_MANUAL_FIRE";
	};
	class ManualFireCancel: ManualFire
	{
		text="$STR_ACTION_MANUAL_FIRE_CANCEL";
		textDefault="$STR_ACTION_MANUAL_FIRE_CANCEL";
	};
	class AutoHover: None
	{
		shortcut="AutoHover";
		priority=0.89999998;
		text="$STR_ACTION_HOVER";
		textDefault="$STR_ACTION_HOVER";
		showWindow=0;
	};
	class AutoHoverCancel: AutoHover
	{
		shortcut="AutoHoverCancel";
		text="$STR_ACTION_HOVER_CANCEL";
		textDefault="$STR_ACTION_HOVER_CANCEL";
		showWindow=0;
		priority=1.9;
	};
	class VTOLVectoring: AutoHover
	{
		shortcut="VTOLVectoring";
		priority=0.89999998;
		text="$STR_VECTORING_ON";
		textDefault="$STR_VECTORING_ON";
		showWindow=0;
	};
	class VTOLVectoringCancel: AutoHover
	{
		shortcut="VTOLVectoringCancel";
		text="$STR_VECTORING_OFF";
		textDefault="$STR_VECTORING_OFF";
		showWindow=0;
		priority=1.9;
	};
	class StrokeFist: None
	{
		priority=0.1;
		text="$STR_ACTION_STROKEFIST";
		textDefault="$STR_ACTION_STROKEFIST";
	};
	class StrokeGun: None
	{
		priority=0.1;
		text="$STR_ACTION_STROKEGUN";
		textDefault="$STR_ACTION_STROKEGUN";
	};
	class LadderUp: None
	{
		text="$STR_ACTION_LADDERUP";
		textDefault="$STR_ACTION_LADDERUP";
	};
	class LadderDown: None
	{
		text="$STR_ACTION_LADDERDOWN";
		textDefault="$STR_ACTION_LADDERDOWN";
	};
	class LadderOnDown: None
	{
		priority=10;
		showWindow=1;
		text="$STR_ACTION_LADDERDOWN";
		textDefault="$STR_ACTION_LADDERDOWN";
	};
	class LadderOnUp: None
	{
		priority=10;
		showWindow=1;
		text="$STR_ACTION_LADDERUP";
		textDefault="$STR_ACTION_LADDERUP";
	};
	class LadderOff: None
	{
		priority=10;
		text="$STR_ACTION_LADDEROFF";
		textDefault="$STR_ACTION_LADDEROFF";
	};
	class FireInflame: None
	{
		priority=0.99000001;
		showWindow=1;
		text="$STR_ACTION_FIRE_INFLAME";
		textDefault="$STR_ACTION_FIRE_INFLAME";
	};
	class FirePutDown: None
	{
		priority=0.99000001;
		showWindow=1;
		text="$STR_ACTION_FIRE_PUT_DOWN";
		textDefault="$STR_ACTION_FIRE_PUT_DOWN";
	};
	class LandGear: None
	{
		priority=0.80000001;
		hideOnUse=0;
		shortcut="LandGear";
		text="$STR_ACTION_GEAR_DOWN";
		textDefault="$STR_ACTION_GEAR_DOWN";
	};
	class LandGearUp: LandGear
	{
		shortcut="LandGearUp";
		text="$STR_ACTION_GEAR_UP";
		textDefault="$STR_ACTION_GEAR_UP";
	};
	class FlapsDown: None
	{
		priority=0.69999999;
		hideOnUse=0;
		shortcut="FlapsDown";
		text="$STR_ACTION_FLAPS_DOWN";
		textDefault="$STR_ACTION_FLAPS_DOWN";
	};
	class FlapsUp: None
	{
		priority=0.69999999;
		hideOnUse=0;
		shortcut="FlapsUp";
		text="$STR_ACTION_FLAPS_UP";
		textDefault="$STR_ACTION_FLAPS_UP";
	};
	class Salute: None
	{
		priority=0.11;
		shortcut="Salute";
		show=0;
		text="$STR_ACTION_SALUTE";
		textDefault="$STR_ACTION_SALUTE";
	};
	class ScudLaunch: None
	{
		priority=0.039999999;
		text="$STR_ACTION_SCUDLAUNCH";
		textDefault="$STR_ACTION_SCUDLAUNCH";
	};
	class ScudStart: None
	{
		priority=0.039999999;
		text="$STR_ACTION_SCUDSTART";
		textDefault="$STR_ACTION_SCUDSTART";
	};
	class ScudCancel: None
	{
		priority=0.039000001;
		text="$STR_ACTION_SCUDCANCEL";
		textDefault="$STR_ACTION_SCUDCANCEL";
	};
	class User: None
	{
		priority=1.5;
		showWindow=1;
		text="%1";
		textDefault="%2";
		textToolTip="%3";
	};
	class DropWeapon: None
	{
		text="$STR_ACTION_DROP_WEAPON";
		textDefault="$STR_ACTION_DROP_WEAPON";
	};
	class PutWeapon: DropWeapon
	{
		text="$STR_ACTION_PUT_WEAPON";
		textDefault="$STR_ACTION_PUT_WEAPON";
	};
	class DropMagazine: None
	{
		text="$STR_ACTION_DROP_MAGAZINE";
		textDefault="$STR_ACTION_DROP_MAGAZINE";
	};
	class PutMagazine: DropMagazine
	{
		text="$STR_ACTION_PUT_MAGAZINE";
		textDefault="$STR_ACTION_PUT_MAGAZINE";
	};
	class UserType: None
	{
		priority=1.4;
		showWindow=1;
		text="%1";
		textDefault="%2";
		textToolTip="%3";
	};
	class HandGunOn: None
	{
		priority=0.40000001;
		text="$STR_ACTION_WEAPON";
		textDefault="$STR_ACTION_WEAPON";
	};
	class HandGunOnStand: HandGunOn
	{
		text="$STR_ACTION_WEAPONINHAND";
		textDefault="$STR_ACTION_WEAPONINHAND";
	};
	class HandGunOff: None
	{
		priority=0.40000001;
		text="$STR_ACTION_WEAPON";
		textDefault="$STR_ACTION_WEAPON";
	};
	class HandGunOffStand: HandGunOff
	{
		text="$STR_ACTION_WEAPONINHAND";
		textDefault="$STR_ACTION_WEAPONINHAND";
	};
	class TakeMine: None
	{
		priority=0.51200002;
		showWindow=1;
		text="$STR_ACTION_TAKE_MINE";
		textDefault="$STR_ACTION_TAKE_MINE";
	};
	class DeactivateMine: None
	{
		priority=0.51300001;
		showWindow=1;
		text="$STR_ACTION_DEACTIVATE_MINE";
		textDefault="$STR_ACTION_DEACTIVATE_MINE";
	};
	class UseMagazine: None
	{
		priority=0.51899999;
		text="%1";
		textDefault="%1";
	};
	class IngameMenu: None
	{
		priority=-1;
		shortcut="MenuSelect";
		text="$STR_ACTION_INGAME_MENU";
		textDefault="$STR_ACTION_INGAME_MENU";
	};
	class CancelTakeFlag: None
	{
		priority=21;
		showWindow=1;
		text="$STR_ACTION_CANCEL_ACTION";
		textDefault="$STR_ACTION_CANCEL_ACTION";
	};
	class CancelAction: None
	{
		priority=20;
		showWindow=1;
		shortcut="CancelAction";
		text="$STR_ACTION_CANCEL_ACTION";
		textDefault="$STR_ACTION_CANCEL_ACTION";
	};
	class MarkEntity: None
	{
		priority=0.51990002;
		showWindow=1;
		text="$STR_ACTION_MARK_ENTITY";
		textDefault="$STR_ACTION_MARK_ENTITY";
	};
	class MarkWeapon: MarkEntity
	{
		text="$STR_ACTION_MARK_WEAPON";
		textDefault="$STR_ACTION_MARK_WEAPON";
	};
	class TeamSwitch: None
	{
		priority=0.11;
		shortcut="TeamSwitch";
		show=0;
		text="$STR_ACTION_TEAM_SWITCH";
		textDefault="$STR_ACTION_TEAM_SWITCH";
	};
	class Gear: None
	{
		priority=0.51980001;
		showWindow=1;
		shortcut="Gear";
		text="$STR_ACTION_GEAR";
		textDefault="$STR_ACTION_GEAR";
	};
	class GearOpen: None
	{
		priority=0.51980001;
		showWindow=1;
		text="$STR_ACTION_GEAR";
		textDefault="$STR_ACTION_GEAR";
	};
	class OpenBag: None
	{
		priority=1.6198;
		showWindow=1;
		text="$STR_ACTION_OPEN_BAG";
		textDefault="$STR_ACTION_OPEN_BAG";
	};
	class TakeBag: None
	{
		priority=1.5197999;
		text="$STR_ACTION_TAKE_BAG";
		textDefault="$STR_ACTION_TAKE_BAG";
		showWindow=1;
	};
	class PutBag: None
	{
		priority=1.5197999;
		showWindow=0;
		text="$STR_ACTION_DROP_BAG";
		textDefault="$STR_ACTION_DROP_BAG";
	};
	class DropBag: None
	{
		priority=1.5197999;
		showWindow=0;
		text="$STR_ACTION_DROP_BAG";
		textDefault="$STR_ACTION_DROP_BAG";
	};
	class AddBag: None
	{
		priority=1.5197999;
		showWindow=0;
		text="$STR_ACTION_TAKE_BAG";
		textDefault="$STR_ACTION_TAKE_BAG";
	};
	class IRLaserOn: None
	{
		priority=0.1;
		show=0;
		text="Laser Enable";
		textDefault="Laser Enable";
	};
	class IRLaserOff: None
	{
		priority=0.1;
		show=0;
		text="Laser Disable";
		textDefault="Laser Disable";
	};
	class Assemble: None
	{
		priority=1.5197999;
		showWindow=0;
		text="$STR_ACTION_ASSEMBLE";
		textDefault="$STR_ACTION_ASSEMBLE";
	};
	class DisAssemble: None
	{
		priority=1.5197999;
		showWindow=0;
		text="$STR_ACTION_DISASSEMBLE";
		textDefault="$STR_ACTION_DISASSEMBLE";
	};
	class Talk: None
	{
		priority=2;
		showWindow=1;
		text="$STR_ACTION_ASK";
		textDefault="$STR_ACTION_ASK";
	};
	class Tell: None
	{
		priority=2;
		showWindow=1;
		text="""%1""";
		textDefault="""%1""";
	};
	class Surrender: None
	{
		priority=0.11;
		shortcut="Surrender";
		show=0;
		text="$STR_ACTION_SURRENDER";
		textDefault="$STR_ACTION_SURRENDER";
	};
	class GetOver: None
	{
		priority=0.11;
		shortcut="GetOver";
		show=0;
		text="$STR_ACTION_GET_OVER";
		textDefault="$STR_ACTION_GET_OVER";
	};
	class OpenParachute: None
	{
		priority=9.1000004;
		text="$STR_A3_RSCGROUPROOTMENU_ITEMS_OPENPARACHUTE0";
	};
	class HelicopterAutoTrimOn: None
	{
		text="$STR_ACTION_AUTOTRIM_ON";
		textDefault="$STR_ACTION_AUTOTRIM_ON";
		priority=3;
		show=1;
	};
	class HelicopterAutoTrimOff: None
	{
		text="$STR_ACTION_AUTOTRIM_OFF";
		textDefault="$STR_ACTION_AUTOTRIM_OFF";
		priority=3;
		show=1;
	};
	class HelicopterTrimOn: None
	{
		text="$STR_ACTION_TRIM_ON";
		textDefault="$STR_ACTION_TRIM_ON";
		priority=3;
		show=1;
	};
	class HelicopterTrimOff: None
	{
		text="$STR_ACTION_TRIM_OFF";
		textDefault="$STR_ACTION_TRIM_OFF";
		priority=3;
		show=1;
	};
	class WheelsBrakeOn: None
	{
		text="$STR_ACTION_BRAKE_ON";
		textDefault="$STR_ACTION_BRAKE_ON";
		priority=3;
		show=1;
	};
	class WheelsBrakeOff: WheelsBrakeOn
	{
		text="$STR_ACTION_BRAKE_OFF";
		textDefault="$STR_ACTION_BRAKE_OFF";
	};
	class PeriscopeDepthOn: None
	{
		text="$STR_A3_LOC_PeriscopeDepthOn";
		textDefault="$STR_A3_LOC_PeriscopeDepthOn";
	};
	class PeriscopeDepthOff: None
	{
		text="$STR_A3_LOC_PeriscopeDepthOff";
		textDefault="$STR_A3_LOC_PeriscopeDepthOff";
	};
	class UAVTerminalOpen: None
	{
		text="$STR_useract_uav_openuavterminal";
		textDefault="$STR_useract_uav_openuavterminal";
	};
	class UAVTerminalMakeConnection: None
	{
		text="$STR_useract_uav_uavterminalmakeconnection";
		textDefault="$STR_useract_uav_uavterminalmakeconnection";
	};
	class UAVTerminalReleaseConnection: None
	{
		text="$STR_useract_uav_uavterminalreleaseconnection";
		textDefault="$STR_useract_uav_uavterminalreleaseconnection";
	};
	class UAVTerminalHackConnection: None
	{
		text="$STR_useract_uav_uavterminalhackconnection";
		textDefault="$STR_useract_uav_uavterminalhackconnection";
	};
	class BackFromUAV: None
	{
		text="$STR_useract_uav_releasecontrols";
		textDefault="$STR_useract_uav_releasecontrols";
	};
	class SwitchToUAVDriver: None
	{
		text="$STR_useract_uav_takecontrols";
		textDefault="$STR_useract_uav_takecontrols";
	};
	class SwitchToUAVGunner: None
	{
		text="$STR_useract_uav_takegunnercontrols";
		textDefault="$STR_useract_uav_takegunnercontrols";
	};
	class Sleep: None
	{
		text="Sleep";
	};
	class WakeUp: None
	{
		text="WakeUp";
	};
	class UnmountItem: None
	{
		showWindow=1;
		priority=0.69999999;
		text="Unmount %1 from %2";
		textDefault="";
	};
	class MountItem: None
	{
		showWindow=1;
		priority=0.69999999;
		text="Mount %1 to %2";
		textDefault="";
	};
	class DropItem: None
	{
		showWindow=1;
		priority=0.69999999;
		text="Drop %1";
		textDefault="";
	};
	class TakeItem: None
	{
		showWindow=1;
		priority=0.69999999;
		text="Take %1 %2";
		textDefault="";
	};
	class UnloadMagazine: None
	{
		showWindow=1;
		priority=0.69999999;
		text="Unload Magazine";
		textDefault="";
	};
	class ChangeUniformWithBody: None
	{
		showWindow=0;
		priority=0.69999999;
		text="ChangeUniformWithBody %1";
		textDefault="";
	};
	class DropItemFromBody: None
	{
		showWindow=0;
		priority=0.69999999;
		text="DropItemFromBody %1";
		textDefault="";
	};
	class TakeItemFromBody: None
	{
		showWindow=0;
		priority=0.69999999;
		text="TakeItemFromBody %1";
		textDefault="";
	};
	class ChangeBackpackFromBackpack: None
	{
		showWindow=0;
		priority=0.69999999;
		text="ChangeBackpackFromBackpack %1";
		textDefault="";
	};
	class TakeWeaponFromBody: None
	{
		showWindow=0;
		priority=0.69999999;
		text="TakeWeaponFromBody %1";
		textDefault="";
	};
	class TakeBackpackFromBody: None
	{
		showWindow=0;
		priority=0.69999999;
		text="TakeBackpackFromBody %1";
		textDefault="";
	};
	class UnmountUniformItem: None
	{
		showWindow=0;
		priority=0.69999999;
		text="Unmount %1 from uniform";
		textDefault="";
	};
	class MountUniformItem: None
	{
		showWindow=0;
		priority=0.69999999;
		text="Mount %1 on uniform";
		textDefault="";
	};
	class MountWeaponFromInv: None
	{
		showWindow=1;
		priority=0.69999999;
		text="Mount %1 from inventory";
		extDefault="";
	};
	class UnmountWeaponToInv: None
	{
		showWindow=1;
		priority=0.69999999;
		text="Unmount %1 to inventory";
		extDefault="";
	};
	class OpenParachuteSteerable: None
	{
		priority=9.1000004;
		text="Open steerable parachute";
	};
	class OpenParachuteNonSteerable: None
	{
		priority=9.1999998;
		text="Open nonsteerable parachute";
	};
	class ActivateBreathingBomb: None
	{
		priority=9.3000002;
		text="Activate oxygen tube";
	};
	class DeactivateBreathingBomb: None
	{
		priority=9.3999996;
		text="Deactivate oxygen tube";
	};
	class PatchSoldier: None
	{
		text="Help %1";
		priority=9.8999996;
		showWindow=1;
		textDefault="";
	};
	class HealSoldierSelf: None
	{
		text="Treat self %1";
		priority=9.8999996;
		showWindow=1;
		textDefault="";
	};
};
class PreloadTextures
{
	class CfgInGameUI
	{
		imageCornerElement="*";
		class PeripheralVision
		{
			cueTexture="\*";
			bloodTexture="\*";
		};
		class Cursor
		{
			me="*";
			aim="*";
			weapon="*";
			select_target="*";
			lock_target="*";
			leader="*";
			mission="*";
			tactical="*";
			move="*";
			selected="*";
			attack="*";
			getIn="*";
			watch="*";
			outArrow="*";
		};
	};
	class CfgCloudletShapes
	{
		cloudletSmoke="@*";
		cloudletWater="@*";
		cloudletFire="@*";
	};
};
class CfgMissions
{
	class Cutscenes
	{
	};
	class Campaigns
	{
	};
	class Missions
	{
	};
	class MPMissions
	{
	};
	class Templates
	{
	};
	class MPTemplates
	{
	};
	class Tutorial
	{
	};
};
class CfgRanks
{
	class 0
	{
		rank="Private";
		displayName="$STR_PRIVATE";
		displayNameShort="$STR_SHORT_PRIVATE";
		texture="#(argb,8,8,3)color(1,1,1,1)";
	};
	class 1
	{
		rank="Corporal";
		displayName="$STR_CORPORAL";
		displayNameShort="$STR_SHORT_CORPORAL";
		texture="#(argb,8,8,3)color(1,1,1,1)";
	};
	class 2
	{
		rank="Sergeant";
		displayName="$STR_SERGEANT";
		displayNameShort="$STR_SHORT_SERGEANT";
		texture="#(argb,8,8,3)color(1,1,1,1)";
	};
	class 3
	{
		rank="Lieutenant";
		displayName="$STR_LIEUTENANT";
		displayNameShort="$STR_SHORT_LIEUTENANT";
		texture="#(argb,8,8,3)color(1,1,1,1)";
	};
	class 4
	{
		rank="Captain";
		displayName="$STR_CAPTAIN";
		displayNameShort="$STR_SHORT_CAPTAIN";
		texture="#(argb,8,8,3)color(1,1,1,1)";
	};
	class 5
	{
		rank="Major";
		displayName="$STR_MAJOR";
		displayNameShort="$STR_SHORT_MAJOR";
		texture="#(argb,8,8,3)color(1,1,1,1)";
	};
	class 6
	{
		rank="Colonel";
		displayName="$STR_COLONEL";
		displayNameShort="$STR_SHORT_COLONEL";
		texture="#(argb,8,8,3)color(1,1,1,1)";
	};
	class 7
	{
		rank="General";
		displayName="$STR_GENERAL";
		displayNameShort="$STR_SHORT_GENERAL";
		texture="#(argb,8,8,3)color(1,1,1,1)";
	};
};
pboTryEntity="textLog ""%1""";
pboTryWeapon="textLog ""%1""";
pboIsEntityLocked="false";
pboIsWeaponLocked="false";
class CfgDefaultKeysPresets
{
	class Default
	{
		displayName="$STR_DISP_DEFAULT";
		default=1;
		class Mappings
		{
			swimUp[]={16};
			swimDown[]={44};
			adjustUp[]=
			{
				{29,17}
			};
			adjustLeft[]=
			{
				{29,30}
			};
			adjustDown[]=
			{
				{29,31}
			};
			adjustRight[]=
			{
				{29,32}
			};
			moveForward[]={17,200};
			moveBack[]={31,208};
			turnLeft[]={30,203};
			turnRight[]={32,205};
			moveUp[]={};
			moveDown[]={};
			moveFastForward[]=
			{
				"256+0x11"
			};
			moveSlowForward[]={};
			moveLeft[]={211};
			moveRight[]={207};
			evasiveForward[]={};
			evasiveLeft[]={16};
			evasiveRight[]={18};
			evasiveBack[]={};
			stand[]={46};
			crouch[]={45};
			prone[]={44};
			nextWeapon[]={33};
			prevWeapon[]={};
			switchWeapon[]={};
			switchPrimary[]={};
			switchHandgun[]={};
			switchSecondary[]={};
			fire[]=
			{
				{29,65536}
			};
			defaultAction[]={65536};
			actionInMap[]={65536};
			reloadMagazine[]={19};
			lockTargets[]={15};
			lockEmptyTargets[]=
			{
				{29,15}
			};
			lockTarget[]=
			{
				"0x00010000  + 1"
			};
			revealTarget[]=
			{
				"0x00010000  + 1"
			};
			tacticalPing[]=
			{
				{29,20}
			};
			zoomTemp[]={};
			tempRaiseWeapon[]={};
			toggleRaiseWeapon[]=
			{
				{157,19},
				"256+0x1D"
			};
			launchCM[]={19};
			nextCM[]=
			{
				{29,19}
			};
			throw[]={};
			cycleThrownItems[]={};
			prevAction[]=
			{
				26,
				"(0x00100000  + 4)"
			};
			nextAction[]=
			{
				27,
				"(0x00100000  + 5)"
			};
			action[]=
			{
				28,
				"0x00010000  + 2"
			};
			actionContext[]={65536};
			actionFreeLook[]={65536};
			headlights[]={38};
			nightVision[]={49};
			binocular[]={48};
			handgun[]={39};
			compass[]={37};
			watch[]={24};
			minimap[]={};
			uavView[]={};
			compassToggle[]=
			{
				"256+0x25"
			};
			watchToggle[]=
			{
				"256+0x18"
			};
			minimapToggle[]=
			{
				{157,50}
			};
			uavViewToggle[]={};
			deployWeaponAuto[]={};
			deployWeaponManual[]={};
			showMap[]={50};
			hideMap[]={50};
			help[]={35};
			timeInc[]={13};
			timeDec[]={12};
			copyVersion[]=
			{
				{29,53}
			};
			openDlcScreen[]=
			{
				{29,48}
			};
			optics[]=
			{
				82,
				"0x00010000 +128+1"
			};
			OpticsTemp[]={};
			opticsMode[]={181};
			personView[]={156};
			tacticalView[]={83};
			zoomIn[]={78};
			zoomInToggle[]=
			{
				"256+0x4E"
			};
			zoomOut[]={74};
			zoomOutToggle[]=
			{
				"256+0x4A"
			};
			zoomContIn[]={};
			zoomContOut[]={};
			gunElevUp[]={201};
			gunElevDown[]={209};
			gunElevSlow[]={42,54};
			gunElevAuto[]={43};
			zeroingUp[]={201};
			zeroingDown[]={209};
			lookAround[]={56};
			lookAroundToggle[]=
			{
				55,
				"256+0x38"
			};
			lookLeftDown[]={79};
			lookDown[]={80};
			lookRightDown[]={81};
			lookLeft[]={75};
			lookCenter[]={76};
			lookRight[]={77};
			lookLeftUp[]={71};
			lookUp[]={72};
			lookRightUp[]={73};
			lookLeftCont[]=
			{
				"0x00080000  + 1"
			};
			lookRightCont[]=
			{
				"0x00080000  + 7"
			};
			lookDownCont[]=
			{
				"0x00080000  + 0"
			};
			lookUpCont[]=
			{
				"0x00080000  + 6"
			};
			lookShiftLeftCont[]=
			{
				"0x00080000  + 3"
			};
			lookShiftRightCont[]=
			{
				"0x00080000  + 9"
			};
			lookShiftUpCont[]=
			{
				"0x00080000  + 4"
			};
			lookShiftDownCont[]={};
			lookShiftForwardCont[]=
			{
				"0x00080000  + 11"
			};
			lookShiftBackCont[]={};
			lookRollLeftCont[]=
			{
				"0x00080000  + 2"
			};
			lookRollRightCont[]=
			{
				"0x00080000  + 8"
			};
			lookShiftLeft[]={};
			lookShiftRight[]={};
			lookShiftUp[]=
			{
				{29,201}
			};
			lookShiftDown[]=
			{
				{29,209}
			};
			lookShiftForward[]={};
			lookShiftBack[]={};
			lookRollLeft[]=
			{
				{29,16}
			};
			lookRollRight[]=
			{
				{29,18}
			};
			lookShiftCenter[]=
			{
				{29,76}
			};
			freeHeadMove[]={29};
			leanLeft[]=
			{
				16,
				"0x00080000  + 3"
			};
			leanRight[]=
			{
				18,
				"0x00080000  + 9"
			};
			leanLeftToggle[]=
			{
				"256+0x10"
			};
			leanRightToggle[]=
			{
				"256+0x12"
			};
			prevChannel[]={51};
			nextChannel[]={52};
			chat[]={53};
			voiceOverNet[]=
			{
				"256+0x3A"
			};
			pushToTalk[]={58};
			commandingmenu1[]={2};
			commandingmenu2[]={3};
			commandingmenu3[]={4};
			commandingmenu4[]={5};
			commandingmenu5[]={6};
			commandingmenu6[]={7};
			commandingmenu7[]={8};
			commandingmenu8[]={9};
			commandingmenu9[]={10};
			commandingmenu0[]={11};
			selectgroupunit1[]={59};
			selectgroupunit2[]={60};
			selectgroupunit3[]={61};
			selectgroupunit4[]={62};
			selectgroupunit5[]={63};
			selectgroupunit6[]={64};
			selectgroupunit7[]={65};
			selectgroupunit8[]={66};
			selectgroupunit9[]={67};
			selectgroupunit0[]={68};
			grouppageprev[]={87};
			grouppageNext[]={88};
			selectteamred[]=
			{
				{42,59},
				{54,59}
			};
			selectteamgreen[]=
			{
				{42,60},
				{54,60}
			};
			selectteamblue[]=
			{
				{42,61},
				{54,61}
			};
			selectteamyellow[]=
			{
				{42,62},
				{54,62}
			};
			selectteamwhite[]=
			{
				{42,63},
				{54,63}
			};
			setteamred[]=
			{
				{29,59},
				{157,59}
			};
			setteamgreen[]=
			{
				{29,60},
				{157,60}
			};
			setteamblue[]=
			{
				{29,61},
				{157,61}
			};
			setteamyellow[]=
			{
				{29,62},
				{157,62}
			};
			setteamwhite[]=
			{
				{29,63},
				{157,63}
			};
			networkStats[]={23};
			networkPlayers[]={25};
			selectAll[]={41};
			turbo[]={};
			turboToggle[]={};
			vehicleTurbo[]={42};
			holdBreath[]=
			{
				"0x00010000  + 1"
			};
			salute[]={43};
			sitDown[]={40};
			walk[]={};
			walkRunToggle[]=
			{
				"256+0x2A"
			};
			walkRunTemp[]={42};
			tactToggle[]={};
			tactTemp[]={};
			TactShort[]={};
			EngineToggle[]=
			{
				{157,18}
			};
			ActiveSensorsToggle[]={};
			getOver[]={47};
			aimUp[]=
			{
				"(0x00100000  + 2)"
			};
			aimDown[]=
			{
				"(0x00100000  + 3)"
			};
			aimLeft[]=
			{
				"(0x00100000  + 0)"
			};
			aimRight[]=
			{
				"(0x00100000  + 1)"
			};
			aimHeadUp[]=
			{
				"(0x00100000  + 2)"
			};
			aimHeadDown[]=
			{
				"(0x00100000  + 3)"
			};
			aimHeadLeft[]=
			{
				"(0x00100000  + 0)"
			};
			aimHeadRight[]=
			{
				"(0x00100000  + 1)"
			};
			ingamePause[]={1};
			menuSelect[]={};
			navigateMenu[]={14};
			closeContext[]=
			{
				"0x00010000  + 128 + 1"
			};
			forceCommandingMode[]={57};
			heliUp[]={16};
			heliDown[]={44};
			heliLeft[]=
			{
				"(0x00100000  + 0)"
			};
			heliRight[]=
			{
				"(0x00100000  + 1)"
			};
			airBankLeft[]={30,203};
			airBankRight[]={32,205};
			heliRudderLeft[]={45,211};
			heliRudderRight[]={46,207};
			heliForward[]=
			{
				17,
				200,
				"(0x00100000  + 3)"
			};
			heliBack[]=
			{
				31,
				208,
				"(0x00100000  + 2)"
			};
			heliFastForward[]={18};
			landGear[]=
			{
				{157,34}
			};
			landGearUp[]=
			{
				{157,34}
			};
			flapsDown[]=
			{
				{157,37}
			};
			flapsUp[]=
			{
				{157,38}
			};
			heliCyclicLeft[]={30,203};
			heliCyclicRight[]={32,205};
			heliCyclicForward[]=
			{
				17,
				200,
				"(0x00100000  + 3)"
			};
			heliCyclicBack[]=
			{
				31,
				208,
				"(0x00100000  + 2)"
			};
			heliCollectiveRaise[]={16};
			heliCollectiveLower[]={44};
			heliWheelsBrake[]=
			{
				{157,17}
			};
			helicopterTrimOn[]=
			{
				{157,76}
			};
			helicopterTrimOff[]=
			{
				{157,83}
			};
			HeliTrimLeft[]=
			{
				{157,75}
			};
			HeliTrimRight[]=
			{
				{157,77}
			};
			HeliTrimForward[]=
			{
				{157,72}
			};
			HeliTrimBackward[]=
			{
				{157,80}
			};
			HeliTrimRudderLeft[]=
			{
				{157,79}
			};
			HeliTrimRudderRight[]=
			{
				{157,81}
			};
			HeliRopeAction[]=
			{
				"256+0x13"
			};
			autoHover[]=
			{
				"256+0x2B"
			};
			autoHoverCancel[]={43};
			VTOLVectoring[]=
			{
				"256 + 0x2B"
			};
			VTOLVectoringCancel[]={43};
			submarineUp[]={16};
			submarineDown[]={44};
			submarineLeft[]=
			{
				30,
				203,
				"(0x00100000  + 0)"
			};
			submarineRight[]=
			{
				32,
				205,
				"(0x00100000  + 1)"
			};
			submarineForward[]={17,200};
			submarineBack[]={31,208};
			submarineCyclicForward[]=
			{
				"(0x00100000  + 2)"
			};
			submarineCyclicBack[]=
			{
				"(0x00100000  + 3)"
			};
			seagullUp[]=
			{
				16,
				"(0x00100000  + 3)"
			};
			seagullDown[]=
			{
				44,
				"(0x00100000  + 2)"
			};
			seagullForward[]={17,200};
			seagullBack[]={31,208};
			seagullFastForward[]={18};
			carLeft[]={30,203};
			carRight[]={32,205};
			carLinearLeft[]=
			{
				"STICK_AXIS+8+0"
			};
			carLinearRight[]=
			{
				"STICK_AXIS+8+1"
			};
			carWheelLeft[]=
			{
				"(0x00100000  + 0)"
			};
			carWheelRight[]=
			{
				"(0x00100000  + 1)"
			};
			carForward[]={17,200};
			carBack[]={31,208};
			carHandBrake[]={};
			carFastForward[]={18};
			carSlowForward[]={16};
			carAimUp[]=
			{
				"(0x00100000  + 2)"
			};
			carAimDown[]=
			{
				"(0x00100000  + 3)"
			};
			carAimLeft[]=
			{
				"(0x00100000  + 0)"
			};
			carAimRight[]=
			{
				"(0x00100000  + 1)"
			};
			commandLeft[]={30,203};
			commandRight[]={32,205};
			commandForward[]={17,200};
			commandBack[]={31,208};
			commandFast[]={18};
			commandSlow[]={16};
			switchGunnerWeapon[]=
			{
				{29,33}
			};
			vehLockTargets[]={15};
			vehLockEmptyTargets[]=
			{
				{29,15}
			};
			vehLockTurretView[]=
			{
				{29,20}
			};
			swapGunner[]={};
			heliManualFire[]={40};
			turnIn[]={45,46};
			turnOut[]={44};
			cancelAction[]={};
			commandWatch[]={56};
			teamSwitch[]={20};
			teamSwitchPrev[]={21};
			teamSwitchNext[]={22};
			gear[]={34};
			CuratorInterface[]=
			{
				{42,22}
			};
			CuratorDelete[]={211};
			CuratorDestroy[]={207};
			CuratorMoveCamTo[]={33};
			CuratorLockCameraTo[]=
			{
				{29,33}
			};
			CuratorLevelObject[]={45};
			CuratorRotateMod[]={42};
			CuratorGroupMod[]={29};
			CuratorMultipleMod[]={29};
			CuratorMoveY[]={56};
			CuratorContentWaypoint[]={56};
			CuratorGetOut[]={34};
			CuratorCameraLook[]=
			{
				"0x00010000 +3"
			};
			CuratorCollapseParent[]={46};
			TurretElevationUp[]={};
			TurretElevationDown[]={};
			cheat1[]={220,219};
			cheat2[]={184};
			buldSwitchCamera[]={210};
			buldFreeLook[]={76};
			buldSelect[]={57};
			buldResetCamera[]={82};
			buldMagnetizePoints[]={63};
			buldMagnetizePlanes[]={64};
			buldMagnetizeYFixed[]={65};
			buldTerrainRaise1m[]={24};
			buldTerrainRaise10cm[]={22};
			buldTerrainLower1m[]={38};
			buldTerrainLower10cm[]={36};
			buldTerrainRaise5m[]={25};
			buldTerrainRaise50cm[]={23};
			buldTerrainLower5m[]={39};
			buldTerrainLower50cm[]={37};
			buldTerrainShowNode[]={35};
			buldSelectionType[]={31};
			buldLeft[]={203};
			buldRight[]={205};
			buldForward[]={200};
			buldBack[]={208};
			buldMoveLeft[]=
			{
				"(0x00100000  + 0)"
			};
			buldMoveRight[]=
			{
				"(0x00100000  + 1)"
			};
			buldMoveForward[]=
			{
				"(0x00100000  + 2)"
			};
			buldMoveBack[]=
			{
				"(0x00100000  + 3)"
			};
			buldTurbo[]={42};
			buldBrushRatio[]={48};
			buldBrushStrength[]={50};
			buldBrushSmooth[]={42};
			buldBrushRandomize[]={19};
			BuldBrushSetHeight[]={46};
			buldBrushOuter[]={49};
			buldUndo[]=
			{
				{29,44}
			};
			buldRedo[]=
			{
				{29,19}
			};
			BuldCreateObj[]={47};
			BuldDuplicateSel[]={46};
			BuldRemoveSel[]={32};
			BuldRotateSelX[]={45};
			BuldRotateSelZ[]={44};
			BuldScaleSel[]={18};
			BuldElevateSel[]={17};
			BuldKeepAbsoluteElevationSel[]={50};
			BuldClearAllElevationLocks[]=
			{
				{42,50}
			};
			buldUp[]={201,16};
			buldDown[]={209,44};
			buldLookLeft[]={75};
			buldLookRight[]={77};
			buldLookUp[]={72};
			buldLookDown[]={80};
			buldZoomIn[]={78};
			buldZoomOut[]={74};
			buldTextureInfo[]={20};
			diaryFull[]=
			{
				{29,36}
			};
			diary[]={36};
			diaryToggle[]=
			{
				"256 + 0x24"
			};
			switchCommand[]=
			{
				{29,57},
				221
			};
			cameraMoveForward[]={17};
			cameraMoveBackward[]={31};
			cameraMoveLeft[]={30};
			cameraMoveRight[]={32};
			cameraMoveUp[]={16};
			cameraMoveDown[]={44};
			cameraMoveTurbo1[]={42,54};
			cameraMoveTurbo2[]={56,184};
			cameraZoomIn[]={78};
			cameraZoomOut[]={74};
			cameraLookUp[]={72};
			cameraLookDown[]={80};
			cameraLookLeft[]={75};
			cameraLookRight[]={77};
			cameraReset[]={76};
			cameraTarget[]={33};
			cameraVisionMode[]={49};
			cameraFlashlight[]={38};
			cameraInterface[]={14};
			editorCameraMoveForward[]={17};
			editorCameraMoveBackward[]={31};
			editorCameraMoveLeft[]={30};
			editorCameraMoveRight[]={32};
			editorCameraMoveUp[]={16};
			editorCameraMoveDown[]={44};
			editorCameraMoveTurbo[]={42,54};
			editorCameraLookUp[]={72};
			editorCameraLookDown[]={80};
			editorCameraLookLeft[]={75};
			editorCameraLookRight[]={77};
			editorCameraReset[]={76};
		};
	};
};
class JoystickSchemes
{
	class Joystick1
	{
		name="$STR_CONTROLLER_SCHEME_GENERIC_STICK";
		class ActionsMapping
		{
			keyHeliCyclicForward[]=
			{
				"0x00030000 +8+1"
			};
			keyHeliCyclicBack[]=
			{
				"0x00030000 +1"
			};
			keyHeliCyclicLeft[]=
			{
				"0x00030000 +8+0"
			};
			keyHeliCyclicRight[]=
			{
				"0x00030000 +0"
			};
			keyHeliCollectiveRaiseCont[]=
			{
				"0x00030000 +8+6"
			};
			keyHeliCollectiveLowerCont[]=
			{
				"0x00030000 +6"
			};
			keyAirBankLeft[]=
			{
				"0x00030000 +8+0"
			};
			keyAirBankRight[]=
			{
				"0x00030000 +0"
			};
			keyHeliForward[]=
			{
				"0x00030000 +8+1"
			};
			keyHeliBack[]=
			{
				"0x00030000 +1"
			};
			keySeagullUp[]=
			{
				"0x00030000 +1"
			};
			keySeagullDown[]=
			{
				"0x00030000 +8+1"
			};
			keyCarLeft[]=
			{
				"0x00030000 +8+0"
			};
			keyCarRight[]=
			{
				"0x00030000 +8+1"
			};
			keyCarForward[]=
			{
				"0x00030000 +1"
			};
			keyCarBack[]=
			{
				"0x00030000 +1"
			};
			keyVehLockTargets[]=
			{
				"0x00020000 +1"
			};
			keyToggleWeapons[]=
			{
				"0x00020000 +2"
			};
			keyDefaultAction[]=
			{
				"0x00020000 +0"
			};
			keyLockTargets[]=
			{
				"0x00020000 +1"
			};
			keyPrevAction[]=
			{
				"0x00020000 +6"
			};
			keyNextAction[]=
			{
				"0x00020000 +4"
			};
			keyAction[]=
			{
				"0x00020000 +5"
			};
			keyActionContext[]=
			{
				"0x00020000 +0"
			};
			keyActionFreeLook[]=
			{
				"0x00020000 +0"
			};
			keyZoomIn[]=
			{
				"0x00020000 +3"
			};
			keyLookLeftDown[]=
			{
				"0x00040000 +5"
			};
			keyLookDown[]=
			{
				"0x00040000 +4"
			};
			keyLookRightDown[]=
			{
				"0x00040000 +3"
			};
			keyLookLeft[]=
			{
				"0x00040000 +6"
			};
			keyLookRight[]=
			{
				"0x00040000 +2"
			};
			keyLookLeftUp[]=
			{
				"0x00040000 +7"
			};
			keyLookUp[]=
			{
				"0x00040000 +0"
			};
			keyLookRightUp[]=
			{
				"0x00040000 +1"
			};
		};
	};
	class Joystick2
	{
		name="$STR_CONTROLLER_SCHEME_GENERIC_THROTTLE";
		class ActionsMapping
		{
			keyHeliCollectiveRaiseCont[]=
			{
				"0x00030000 +2"
			};
			keyHeliCollectiveLowerCont[]=
			{
				"0x00030000 +8+2"
			};
			keyLookLeftDown[]=
			{
				"0x00040000 +5"
			};
			keyLookDown[]=
			{
				"0x00040000 +4"
			};
			keyLookRightDown[]=
			{
				"0x00040000 +3"
			};
			keyLookLeft[]=
			{
				"0x00040000 +6"
			};
			keyLookRight[]=
			{
				"0x00040000 +2"
			};
			keyLookLeftUp[]=
			{
				"0x00040000 +7"
			};
			keyLookUp[]=
			{
				"0x00040000 +0"
			};
			keyLookRightUp[]=
			{
				"0x00040000 +1"
			};
		};
	};
	class Joystick3
	{
		name="$STR_CONTROLLER_SCHEME_GENERIC_PEDALS";
		class ActionsMapping
		{
			keyHeliRudderLeft[]=
			{
				"0x00030000 +8+2"
			};
			keyHeliRudderRight[]=
			{
				"0x00030000 +2"
			};
		};
	};
	class Joystick4
	{
		name="$STR_CONTROLLER_SCHEME_GENERIC_TRACKIR";
		class ActionsMapping
		{
			keyLeanLeft[]=
			{
				"0x00080000 +3"
			};
			keyLeanRight[]=
			{
				"0x00080000 +9"
			};
			keyZoomContIn[]=
			{
				"0x00080000 +11"
			};
			keyZoomContOut[]=
			{
				"0x00080000 +5"
			};
			keyLookLeftCont[]=
			{
				"0x00080000 +1"
			};
			keyLookRightCont[]=
			{
				"0x00080000 +7"
			};
			keyLookDownCont[]=
			{
				"0x00080000 +0"
			};
			keyLookUpCont[]=
			{
				"0x00080000 +6"
			};
			keyLookShiftLeftCont[]=
			{
				"0x00080000 +3"
			};
			keyLookShiftRightCont[]=
			{
				"0x00080000 +9"
			};
			keyLookRollLeftCont[]=
			{
				"0x00080000 +2"
			};
			keyLookRollRightCont[]=
			{
				"0x00080000 +8"
			};
		};
	};
};
DoubleTapAndHoldActions[]=
{
	"moveForward",
	"moveBack",
	"turnLeft",
	"turnRight",
	"moveFastForward",
	"moveSlowForward",
	"moveLeft",
	"moveRight",
	"defaultAction",
	"tempRaiseWeapon",
	"compass",
	"watch",
	"lookAround",
	"minimap",
	"zoomIn",
	"zoomOut"
};
class DefaultAnalogCurveDefs
{
	class MoveBack
	{
		deadZone=0.1;
		curve[]=
		{
			"Gamma",
			1,
			4
		};
	};
	class MoveFastForward
	{
		deadZone=0.1;
		curve[]=
		{
			"Gamma",
			1,
			4
		};
	};
	class TurnLeft
	{
		deadZone=0.1;
		curve[]=
		{
			"Gamma",
			1,
			2
		};
	};
	class TurnRight
	{
		deadZone=0.1;
		curve[]=
		{
			"Gamma",
			1,
			2
		};
	};
	class AimUp
	{
		deadZone=0;
		curve[]=
		{
			"LinRampZoom",
			{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
			{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
			{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
		};
	};
	class AimDown
	{
		deadZone=0;
		curve[]=
		{
			"LinRampZoom",
			{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
			{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
			{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
		};
	};
	class AimLeft
	{
		deadZone=0;
		curve[]=
		{
			"LinRampZoom",
			{1,0.40000001,0.1,0.89999998,0.89999998,0.99000001,1.8,1,3},
			{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,1.5,1,2.5},
			{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,0.89999998,1,1.2}
		};
	};
	class AimRight
	{
		deadZone=0;
		curve[]=
		{
			"LinRampZoom",
			{1,0.40000001,0.1,0.89999998,0.89999998,0.99000001,1.8,1,3},
			{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,1.5,1,2.5},
			{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,0.89999998,1,1.2}
		};
	};
	class AimHeadUp
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			1,
			2.5
		};
	};
	class AimHeadDown
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			1,
			2.5
		};
	};
	class AimHeadLeft
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			2,
			4
		};
	};
	class AimHeadRight
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			2,
			4
		};
	};
	class CarLeft
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			2,
			3
		};
	};
	class CarRight
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			2,
			3
		};
	};
	class CarBack
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			1,
			1.5
		};
	};
	class CarFastForward
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			1,
			1.5
		};
	};
	class CarAimUp
	{
		deadZone=0;
		curve[]=
		{
			"LinRampZoom",
			{1,0.2,0.050000001,0.99000001,1.8,1,5.4000001},
			{0.69999999,0.2,0.029999999,0.99000001,1.2,1,4.8000002},
			{0.30000001,0.2,0.02,0.99000001,1.8,1,3}
		};
	};
	class CarAimDown
	{
		deadZone=0;
		curve[]=
		{
			"LinRampZoom",
			{1,0.2,0.050000001,0.99000001,1.8,1,5.4000001},
			{0.69999999,0.2,0.029999999,0.99000001,1.2,1,4.8000002},
			{0.30000001,0.2,0.02,0.99000001,1.8,1,3}
		};
	};
	class CarAimLeft
	{
		deadZone=0;
		curve[]=
		{
			"LinRampZoom",
			{1,0.40000001,0.1,0.89999998,0.89999998,0.99000001,3.5999999,1,9},
			{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
			{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
		};
	};
	class CarAimRight
	{
		deadZone=0;
		curve[]=
		{
			"LinRampZoom",
			{1,0.40000001,0.1,0.89999998,0.89999998,0.99000001,3.5999999,1,9},
			{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
			{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
		};
	};
	class HeliUp
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			1,
			1.5
		};
	};
	class HeliDown
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			1,
			1.5
		};
	};
	class HeliCyclicLeft
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			1,
			1.5
		};
	};
	class HeliCyclicRight
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			1,
			1.5
		};
	};
	class HeliRudderLeft
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			1,
			1.5
		};
	};
	class HeliRudderRight
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			1,
			1.5
		};
	};
	class HeliBack
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			1,
			1.5
		};
	};
	class HeliFastForward
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			1,
			1.5
		};
	};
	class SeagullUp
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			1,
			1.5
		};
	};
	class SeagullDown
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			1,
			1.5
		};
	};
	class SeagullBack
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			1,
			1.5
		};
	};
	class SeagullFastForward
	{
		deadZone=0;
		curve[]=
		{
			"Gamma",
			1,
			1.5
		};
	};
};
class DefaultMouseCurveDefs
{
};
class CfgDetectors
{
	objects[]=
	{
		"EmptyDetector"
	};
};
class CfgFaceWounds
{
	wounds[]={};
};
class CfgGlasses
{
	class None
	{
		scope=2;
		name="$STR_A3_CfgGlasses_None0";
		model="";
		identityTypes[]={};
	};
};
class CfgFaces
{
	class Default
	{
		class Default
		{
			name="";
			head="";
			material="";
			texture="#(rgb,8,8,3)color(0.5,0.5,1,1)";
			textureHL="#(rgb,8,8,3)color(0.5,0.5,1,1)";
			materialHL="";
			identityTypes[]=
			{
				"Default"
			};
		};
		class Custom
		{
			name="";
			head="";
			material="";
			texture="#(rgb,8,8,3)color(1,1,1,1)";
			textureHL="#(rgb,8,8,3)color(0.5,0.5,1,1)";
			materialHL="";
			front="#(rgb,8,8,3)color(1,1,1,1)";
			side="#(rgb,8,8,3)color(1,1,1,1)";
			back="#(rgb,8,8,3)color(1,1,1,1)";
			identityTypes[]={};
		};
	};
};
class CfgMimics
{
	class HeadPreview
	{
		microMimics="Micro";
		boneHead="head";
	};
	class Micro
	{
		lBrow[]={0.0020000001,0.0020000001,0.001,0.60000002,3};
		mBrow[]={0.0020000001,0.0020000001,0.001,0.60000002,2.5};
		rBrow[]={0.0020000001,0.0020000001,0.001,0.60000002,3};
		lMouth[]={0.001,0.0020000001,0.001,0.60000002,2};
		mMouth[]={0,0,0,0.60000002,3};
		rMouth[]={0.001,0.0020000001,0.001,0.60000002,2};
	};
	class NoMicro
	{
		lBrow[]={0,0,0,0.60000002,3};
		mBrow[]={0,0,0,0.60000002,2.5};
		rBrow[]={0,0,0,0.60000002,3};
		lMouth[]={0,0,0,0.60000002,2};
		mMouth[]={0,0,0,0.60000002,3};
		rMouth[]={0,0,0,0.60000002,2};
	};
	class States
	{
		class Default
		{
			lBrow[]={0,0};
			mBrow[]={0,0};
			rBrow[]={0,0};
			lMouth[]={0,0};
			mMouth[]={0,0};
			rMouth[]={0,0};
		};
		class Normal
		{
			lBrow[]={0,0};
			mBrow[]={0,0};
			rBrow[]={0,0};
			lMouth[]={0,0};
			mMouth[]={0,0};
			rMouth[]={0,0};
		};
		class Smile
		{
			lBrow[]={0,0.25};
			mBrow[]={0,0.25};
			rBrow[]={0,0.25};
			lMouth[]={-0.5,0.60000002};
			mMouth[]={0,0};
			rMouth[]={0.5,0.60000002};
		};
		class Hurt
		{
			lBrow[]={0,-0.34999999};
			mBrow[]={0,-0.5};
			rBrow[]={0,-0.60000002};
			lMouth[]={0.5,-0.30000001};
			mMouth[]={0,0.30000001};
			rMouth[]={-0.5,-0.60000002};
		};
		class Ironic
		{
			lBrow[]={0,-0.34999999};
			mBrow[]={0,-0.34999999};
			rBrow[]={0,-0.34999999};
			lMouth[]={0.1,0.30000001};
			mMouth[]={0,0.89999998};
			rMouth[]={-0.1,0.30000001};
		};
		class Sad
		{
			lBrow[]={0,0.2};
			mBrow[]={0,0.2};
			rBrow[]={0,0.2};
			lMouth[]={0.1,-0.5};
			mMouth[]={0,-0.5};
			rMouth[]={-0.1,-0.5};
		};
		class Cynic
		{
			lBrow[]={0,-0.34999999};
			mBrow[]={0,0};
			rBrow[]={0,0.050000001};
			lMouth[]={0.2,-0.89999998};
			mMouth[]={0,-0.2};
			rMouth[]={0,0};
		};
		class Surprised
		{
			lBrow[]={0,0.5};
			mBrow[]={0,0.5};
			rBrow[]={0,0.5};
			lMouth[]={0,-0.30000001};
			mMouth[]={0,0.30000001};
			rMouth[]={0,-0.2};
		};
		class Agresive
		{
			lBrow[]={0,-0.25};
			mBrow[]={0,-0.40000001};
			rBrow[]={0,-0.30000001};
			lMouth[]={0.40000001,0.5};
			mMouth[]={0,0.5};
			rMouth[]={-0.40000001,-0.5};
		};
		class Angry
		{
			lBrow[]={0.40000001,-0.5};
			mBrow[]={0.1,-0.40000001};
			rBrow[]={-0.40000001,-0.5};
			lMouth[]={0.40000001,-0.89999998};
			mMouth[]={0,-0.2};
			rMouth[]={-0.40000001,-0.80000001};
		};
	};
	combat[]=
	{
		"Sad",
		0.1,
		"Surprised",
		0.1,
		"Cynic",
		0.30000001,
		"Angry",
		0.1,
		"Normal"
	};
	aware[]=
	{
		"Angry",
		0.2,
		"Normal"
	};
	safe[]=
	{
		"Smile",
		0.1,
		"Surprised",
		0.1,
		"Normal"
	};
	neutral[]=
	{
		"Surprised",
		0.1,
		"Sad",
		0.1,
		"Normal"
	};
	danger[]=
	{
		"Surprised",
		0.40000001,
		"Sad"
	};
	dead[]=
	{
		"Hurt"
	};
	hurt[]=
	{
		"Hurt"
	};
};
class CfgEnvSounds
{
	class Default
	{
		name="$STR_CFG_ENVSOUNDS_DEFAULT";
		sound[]=
		{
			"$DEFAULT$",
			0,
			1
		};
		soundNight[]=
		{
			"$DEFAULT$",
			0,
			1
		};
	};
	class Rain
	{
		name="$STR_A3_CfgEnvSounds_Rain0";
		sound[]=
		{
			"",
			0.0017782792,
			1
		};
		volume="rain";
	};
	class Sea
	{
		name="$STR_A3_CfgEnvSounds_Sea0";
		sound[]=
		{
			"",
			0.00031622773,
			1
		};
		volume="coast";
	};
	class Meadows
	{
		name="Meadows";
		sound[]=
		{
			"",
			5.6234123e-005,
			1
		};
		volume="meadow*(1-rain)*(1-night)";
	};
	class Trees
	{
		name="$STR_A3_CfgEnvSounds_Trees0";
		sound[]=
		{
			"",
			0.00017782791,
			1
		};
		volume="trees*(1-rain)*(1-night)";
	};
	class MeadowsNight
	{
		name="Meadows (relaxing in night)";
		sound[]=
		{
			"",
			5.6234123e-005,
			1
		};
		volume="meadow*(1-rain)*night";
	};
	class TreesNight
	{
		name="$STR_A3_CfgEnvSounds_TreesNight0";
		sound[]=
		{
			"",
			0.00017782791,
			1
		};
		volume="trees*(1-rain)*night";
	};
	class Hills
	{
		name="$STR_A3_CfgEnvSounds_Hills0";
		sound[]=
		{
			"",
			0.00017782791,
			1
		};
		volume="hills";
	};
	class Wind
	{
		name="$STR_A3_CfgEnvSounds_Wind0";
		sound[]=
		{
			"",
			0.00017782791,
			1
		};
		volume="(1-hills)*windy*0.5";
	};
};
class CfgHQIdentities
{
	class Base
	{
		name="$STR_CFG_PAPABEAR";
		speaker="NoVoice";
		pitch=0.94999999;
	};
	class HQ
	{
		name="$STR_CFG_PAPABEAR";
		speaker="NoVoice";
		pitch=1.05;
	};
	class PAPA_BEAR
	{
		name="$STR_CFG_PAPABEAR";
		speaker="NoVoice";
		pitch=1.05;
	};
	class AirBase
	{
		name="$STR_CFG_FIREFLYBASE";
		speaker="NoVoice";
		pitch=1.05;
	};
};
class CfgHeads
{
	class Air
	{
		friction=10;
		movement=160;
		maxAmp=0.050000001;
		maxSpeed=3;
		radius=0.2;
	};
	class Land
	{
		friction=20;
		movement=260;
		maxAmp=0.1;
		maxSpeed=4;
		radius=0.30000001;
	};
};
class CfgMusic
{
};
class CfgSounds
{
};
class CfgWhistleSound
{
	sound[]=
	{
		"",
		1,
		1
	};
	downTime=0.5;
	silentTime=1;
	upTime=4;
};
class CfgTitles
{
	defaultSpeed=1;
	defaultIn=0.5;
	defaultTime=10;
	defaultOut=0.5;
	titles[]={};
};
class CfgIntro
{
	firstCampaign="";
};
class CfgCredits
{
	cutscene="";
};
class CfgCutScenes
{
	class Refuel
	{
		sound[]=
		{
			"",
			0.5,
			0.2
		};
		titleType=1;
		title="$STR_CFG_CUTSCENES_REFUEL";
	};
	class Rearm
	{
		sound[]=
		{
			"",
			0.30000001,
			1
		};
		titleType=1;
		title="$STR_CFG_CUTSCENES_REARM";
	};
	class Repair
	{
		sound[]=
		{
			"",
			0.1,
			1
		};
		titleType=1;
		title="$STR_CFG_CUTSCENES_REPAIR";
	};
};
class CfgCameraEffects
{
	class Interpolated
	{
		type=0;
		scale=0.1;
		duration=5;
		spline=1;
		show=2;
	};
	class Exact: Interpolated
	{
		scale=-1;
	};
	class Chain
	{
		type=3;
		show=2;
	};
	class Array
	{
		class Terminate
		{
			name="$STR_CFG_CAMEFFECTS_TERMINATE";
			type=4;
			show=0;
		};
		class Internal
		{
			name="$STR_CFG_CAMEFFECTS_INTERNAL";
			type=5;
			show=2;
		};
		class Fixed: Interpolated
		{
			name="$STR_CFG_CAMEFFECTS_FIXED";
			type=1;
			duration=10;
		};
		class FixedWithZoom: Fixed
		{
			name="$STR_CFG_CAMEFFECTS_FIXEDZOOM";
			type=2;
			duration=10;
		};
		class External: Fixed
		{
			name="$STR_CFG_CAMEFFECTS_EXTERNAL";
			type=0;
			duration=5;
			file="";
		};
	};
};
class CfgMarkers
{
	class Empty
	{
		name="$STR_A3_CfgMarkers_Empty0";
		icon="#(argb,8,8,3)color(1,1,1,1)";
		color[]={0.2,0.1,0.40000001,1};
		size=0;
		scope=2;
	};
};
class CfgMarkerColors
{
};
class CfgMarkerBrushes
{
	class Solid
	{
		name="$STR_CFG_MARKERBR_SOLID";
		texture="#(argb,8,8,3)color(1,1,1,1)";
		drawBorder=0;
		scope=1;
	};
};
class CfgLocationTypes
{
	class Mount
	{
		name="$STR_GETIN";
		drawStyle="mount";
		texture="";
		color[]={0,0,0,1};
		size=0;
		font="TahomaB";
		textSize=0.039999999;
		shadow=1;
	};
	class Name
	{
		name="$STR_NAME";
		drawStyle="name";
		texture="";
		color[]={0,0,0,1};
		size=0;
		font="TahomaB";
		textSize=0.039999999;
		shadow=1;
	};
	class Strategic: Name
	{
		name="$STR_A3_CfgLocationTypes_Strategic0";
		texture="#(argb,8,8,3)color(1,1,1,1)";
		color[]={0.25,0.40000001,0.2,1};
		size=16;
		textSize=0.050000001;
	};
	class StrongpointArea: Strategic
	{
		name="$STR_A3_CfgLocationTypes_StrongpointArea0";
	};
	class FlatArea: Strategic
	{
		name="$STR_A3_CfgLocationTypes_FlatArea0";
	};
	class FlatAreaCity: FlatArea
	{
		name="$STR_A3_CfgLocationTypes_FlatAreaCity0";
	};
	class FlatAreaCitySmall: FlatAreaCity
	{
		name="$STR_A3_CfgLocationTypes_FlatAreaCitySmall0";
	};
	class CityCenter: Strategic
	{
		name="$STR_A3_CfgLocationTypes_CityCenter0";
	};
	class Airport: Strategic
	{
		name="$STR_A3_CfgLocationTypes_Airport0";
		texture="#(argb,8,8,3)color(1,1,1,1)";
		importance=20;
	};
	class NameMarine: Name
	{
		name="$STR_NAME_MARINE";
		color[]={0,0.5,0.94999999,0.5};
		textSize=0.050000001;
		importance=3;
	};
	class NameCityCapital: Name
	{
		name="$STR_NAME_CAPITAL";
		textSize=0.07;
		importance=7;
	};
	class NameCity: Name
	{
		name="$STR_NAME_CITY";
		textSize=0.059999999;
		importance=6;
	};
	class NameVillage: Name
	{
		name="$STR_NAME_VILLAGE";
		textSize=0.050000001;
		importance=5;
	};
	class NameLocal: Name
	{
		name="$STR_NAME_LOCALNAME";
		color[]={0,0,0,0.5};
		textSize=0.050000001;
		importance=4;
	};
	class Hill: Name
	{
		name="$STR_NAME_HILL";
		drawStyle="icon";
		texture="#(argb,8,8,3)color(1,1,1,1)";
		color[]={0,0,0,1};
		size=14;
		textSize=0.039999999;
		shadow=0;
		importance=2;
	};
	class ViewPoint: Hill
	{
		name="$STR_NAME_VIEWPOINT";
		drawStyle="icon";
		texture="#(argb,8,8,3)color(1,1,1,1)";
		color[]={0.77999997,0,0.050000001,1};
		size=12;
		textSize=0.039999999;
		shadow=0;
		importance=1;
	};
	class RockArea: Hill
	{
		name="$STR_NAME_ROCKAREA";
		texture="#(argb,8,8,3)color(1,1,1,1)";
		color[]={0,0,0,1};
		size=12;
		shadow=0;
		importance=2;
	};
	class BorderCrossing: Hill
	{
		name="$STR_NAME_BCROSS";
		texture="#(argb,8,8,3)color(1,1,1,1)";
		color[]={0.77999997,0,0.050000001,1};
		size=16;
		shadow=0;
		importance=1;
	};
	class VegetationBroadleaf: Hill
	{
		name="$STR_NAME_VEGB";
		texture="#(argb,8,8,3)color(1,1,1,1)";
		color[]={0.25,0.40000001,0.2,1};
		size=18;
		shadow=0;
		importance=2;
	};
	class VegetationFir: Hill
	{
		name="$STR_NAME_VEGF";
		texture="#(argb,8,8,3)color(1,1,1,1)";
		color[]={0.25,0.40000001,0.2,1};
		size=18;
		shadow=0;
		importance=2;
	};
	class VegetationPalm: Hill
	{
		name="$STR_NAME_VEGP";
		texture="#(argb,8,8,3)color(1,1,1,1)";
		color[]={0.25,0.40000001,0.2,1};
		size=18;
		shadow=0;
		importance=2;
	};
	class VegetationVineyard: Hill
	{
		name="$STR_NAME_VEGV";
		texture="#(argb,8,8,3)color(1,1,1,1)";
		color[]={0.25,0.40000001,0.2,1};
		size=16;
		shadow=0;
		importance=2;
	};
};
class CfgWorlds
{
	access=0;
	eastSign="\core\default_co.paa";
	westSign="\core\default_co.paa";
	eastFlag="\core\default_co.paa";
	westFlag="\core\default_co.paa";
	guerrilaSign="\core\default_co.paa";
	guerrilaFlag="\core\default_co.paa";
	groupNameFormat="%GroupCompany %GroupPlatoon-%GroupSquad";
	class GroupSquad
	{
		class Squad1
		{
			name="$STR_A3_CfgWorlds_GroupSquad_Squad10";
		};
		class Squad2
		{
			name="$STR_A3_CfgWorlds_GroupSquad_Squad20";
		};
		class Squad3
		{
			name="$STR_A3_CfgWorlds_GroupSquad_Squad30";
		};
	};
	class GroupPlatoon
	{
		class Platoon1
		{
			name="$STR_A3_CfgWorlds_GroupPlatoon_Platoon10";
		};
		class Platoon2
		{
			name="$STR_A3_CfgWorlds_GroupPlatoon_Platoon20";
		};
		class Platoon3
		{
			name="$STR_A3_CfgWorlds_GroupPlatoon_Platoon30";
		};
		class Platoon4
		{
			name="$STR_A3_CfgWorlds_GroupPlatoon_Platoon40";
		};
	};
	class GroupCompany
	{
		class CompanyAlpha
		{
			name="$STR_A3_CfgWorlds_GroupCompany_CompanyAlpha0";
		};
		class CompanyBravo
		{
			name="$STR_A3_CfgWorlds_GroupCompany_CompanyBravo0";
		};
		class CompanyCharlie
		{
			name="$STR_A3_CfgWorlds_GroupCompany_CompanyCharlie0";
		};
		class CompanyDelta
		{
			name="$STR_A3_CfgWorlds_GroupCompany_CompanyDelta0";
		};
		class CompanyEcho
		{
			name="$STR_A3_CfgWorlds_GroupCompany_CompanyEcho0";
		};
		class CompanyFoxtrot
		{
			name="$STR_A3_CfgWorlds_GroupCompany_CompanyFoxtrot0";
		};
		class CompanyGolf
		{
			name="$STR_A3_CfgWorlds_GroupCompany_CompanyGolf0";
		};
		class CompanyHotel
		{
			name="$STR_A3_CfgWorlds_GroupCompany_CompanyHotel0";
		};
		class CompanyIndia
		{
			name="$STR_A3_CfgWorlds_GroupCompany_CompanyIndia0";
		};
		class CompanyKilo
		{
			name="$STR_A3_CfgWorlds_GroupCompany_CompanyKilo0";
		};
		class CompanyLima
		{
			name="$STR_A3_CfgWorlds_GroupCompany_CompanyLima0";
		};
		class CompanyMike
		{
			name="$STR_A3_CfgWorlds_GroupCompany_CompanyMike0";
		};
	};
	class GroupNames
	{
		class Alpha
		{
			name="$STR_CFG_GRPNAMES_ALPHA";
			image="\core\default_co.paa";
		};
		class Bravo
		{
			name="$STR_CFG_GRPNAMES_BRAVO";
			image="\core\default_co.paa";
		};
		class Charlie
		{
			name="$STR_CFG_GRPNAMES_CHARLIE";
			image="\core\default_co.paa";
		};
		class Delta
		{
			name="$STR_CFG_GRPNAMES_DELTA";
			image="\core\default_co.paa";
		};
		class Echo
		{
			name="$STR_CFG_GRPNAMES_ECHO";
			image="\core\default_co.paa";
		};
		class Foxtrot
		{
			name="$STR_CFG_GRPNAMES_FOXTROT";
			image="\core\default_co.paa";
		};
		class Golf
		{
			name="$STR_CFG_GRPNAMES_GOLF";
			image="\core\default_co.paa";
		};
		class Hotel
		{
			name="$STR_CFG_GRPNAMES_HOTEL";
			image="\core\default_co.paa";
		};
		class November
		{
			name="$STR_CFG_GRPNAMES_NOVEMBER";
			image="\core\default_co.paa";
		};
		class Kilo
		{
			name="$STR_CFG_GRPNAMES_KILO";
			image="\core\default_co.paa";
		};
		class Yankee
		{
			name="$STR_CFG_GRPNAMES_YANKEE";
			image="\core\default_co.paa";
		};
		class Zulu
		{
			name="$STR_CFG_GRPNAMES_ZULU";
			image="\core\default_co.paa";
		};
		class Two
		{
			name="$STR_CFG_GRPNAMES_TWO";
			image="\core\default_co.paa";
		};
		class Three
		{
			name="$STR_CFG_GRPNAMES_THREE";
			image="\core\default_co.paa";
		};
		class Buffalo
		{
			name="$STR_CFG_GRPNAMES_BUFFALO";
			image="\core\default_co.paa";
		};
		class Guardian
		{
			name="$STR_CFG_GRPNAMES_GUARDIAN";
			image="\core\default_co.paa";
		};
		class Convoy
		{
			name="$STR_CFG_GRPNAMES_CONVOY";
			image="\core\default_co.paa";
		};
		class Fox
		{
			name="$STR_CFG_GRPNAMES_FOX";
			image="\core\default_co.paa";
		};
	};
	class GroupColors
	{
		class GroupColor1
		{
			name="$STR_CFG_GRPCOL_BLACK";
			image="\core\default_co.paa";
		};
		class GroupColor2
		{
			name="$STR_CFG_GRPCOL_RED";
			image="\core\default_co.paa";
		};
		class GroupColor3
		{
			name="$STR_CFG_GRPCOL_GREEN";
			image="\core\default_co.paa";
		};
		class GroupColor4
		{
			name="$STR_CFG_GRPCOL_BLUE";
			image="\core\default_co.paa";
		};
		class GroupColor5
		{
			name="$STR_CFG_GRPCOL_YELLOW";
			image="\core\default_co.paa";
		};
		class GroupColor6
		{
			name="$STR_CFG_GRPCOL_ORANGE";
			image="\core\default_co.paa";
		};
		class GroupColor7
		{
			name="$STR_CFG_GRPCOL_PINK";
			image="\core\default_co.paa";
		};
		class GroupColor0
		{
			name="";
			image="";
		};
		class Six
		{
			name="$STR_CFG_GRPNAMES_SIX";
			image="\core\default_co.paa";
		};
	};
	class GenericNames
	{
		access=0;
		class Default
		{
			class FirstNames
			{
				default="Unknown";
			};
			class LastNames
			{
				default="Entity";
			};
		};
		class RussianMen
		{
			class FirstNames
			{
				ivan="Ivan";
				mikhail="Mikhail";
				vasili="Vasili";
				boris="Boris";
				pavel="Pavel";
				vladimir="Vladimir";
				oleg="Oleg";
				daniil="Daniil";
				fedor="Fedor";
				kiril="Kiril";
				pyotr="Pyotr";
				filip="Filip";
				fyodor="Fyodor";
				andrey="Andrey";
				igor="Igor";
				aleksander="Aleksander";
				lev="Lev";
				dimitri="Dimitri";
				viktor="Viktor";
				vasil="Vasil";
				ruslan="Ruslan";
				vadim="Vadim";
				stepan="Stepan";
				roman="Roman";
				nikolay="Nikolay";
				yuri="Yuri";
				aleksei="Aleksei";
				maksim="Maksim";
				valery="Valery";
				vyacheslav="Vyacheslav";
				egor="Egor";
				vitaly="Vitaly";
				nikita="Nikita";
				konstantin="Konstantin";
				timofey="Timofey";
				valentin="Valentin";
				leonid="Leonid";
				ilya="Ilya";
				grigoriy="Grigoriy";
				abram="Abram";
				alyosha="Alyosha";
				arkadiy="Arkadiy";
				german="German";
				kuzma="Kuzma";
				semyon="Semyon";
				yevgeniy="Yevgeniy";
			};
			class LastNames
			{
				produnov="Produnov";
				zubov="Zubov";
				blagonravov="Blagonravov";
				davidov="Davidov";
				gusakov="Gusakov";
				nikolayev="Nikolayev";
				ivanov="Ivanov";
				maksimov="Maksimov";
				fisenko="Fisenko";
				shcherbakov="Shcherbakov";
				zverev="Zverev";
				zykov="Zykov";
				doronin="Doronin";
				turchinsky="Turchinsky";
				malyukov="Malyukov";
				rogozhkin="Rogozhkin";
				bychkov="Bychkov";
				zhegalov="Zhegalov";
				soloveychik="Soloveychik";
				strugackiy="Strugackiy";
				bulgakov="Bulgakov";
				tolstoy="Tolstoy";
				pushkin="Pushkin";
				dobryakov="Dobryakov";
				timoshenko="Timoshenko";
				alekseev="Alekseev";
				zhitkov="Zhitkov";
				potapenko="Potapenko";
				yefremov="Yefremov";
				krasko="Krasko";
				pashinin="Pashinin";
				yeltsin="Yeltsin";
				medvedev="Medvedev";
				putin="Putin";
				smirnov="Smirnov";
				kuznetsov="Kuznetsov";
				vasilyev="Vasilyev";
				petrov="Petrov";
				golovko="Golovko";
				chapayev="Chapayev";
				mamayev="Mamayev";
				baranov="Baranov";
				beregovoi="Beregovoi";
				derevenko="Derevenko";
				glebov="Glebov";
				gorbunov="Gorbunov";
				pecharov="Pecharov";
				kirygin="Kirygin";
				lermontov="Lermontov";
				litvinov="Litvinov";
				maryshkin="Naryshkin";
				morozov="Morozov";
				molotov="Molotov";
				popov="Popov";
				privalov="Privalov";
				titov="Titov";
				sudakov="Sudakov";
				kamenev="Kamenev";
				yakushkin="Yakushkin";
				yagudin="Yagudin";
			};
		};
		class RussianWomen
		{
			class FirstNames
			{
				alena="Alena";
				galina="Galina";
				ekaterina="Ekaterina";
				irina="Irina";
				ksenia="Ksenia";
				natasha="Natasha";
				ludmila="Ludmila";
				marina="Marina";
				yelena="Yelena";
				nadezhda="Nadezhda";
				olga="Olga";
				oksana="Oksana";
				raisa="Raisa";
				svetlana="Svetlana";
				tamara="Tamara";
				tatyana="Tatyana";
				vera="Vera";
				zoya="Zoya";
				zhenya="Zhenya";
				katya="Katya";
				nadya="Nadya";
				sasha="Sasha";
				yulya="Yulya";
				lena="Lena";
				karina="Karina";
				nina="Nina";
				natalia="Natalia";
			};
			class LastNames
			{
				produnova="Produnova";
				zubova="Zubova";
				blagonravova="Blagonravova";
				davidova="Davidova";
				gusakova="Gusakova";
				nikolayeva="Nikolayeva";
				ivanova="Ivanova";
				maksimova="Maksimova";
				fisenkova="Fisenkova";
				shcherbakova="Shcherbakova";
				zvereva="Zvereva";
				zykova="Zykova";
				doronina="Doronina";
				turchinskaya="Turchinskaya";
				malyukova="Malyukova";
				rogozhkina="Rogozhkina";
				bychkova="Bychkova";
				zhegalova="Zhegalova";
				soloveychika="Soloveychika";
				strugackaya="Strugackaya";
				bulgakova="Bulgakova";
				tolstoyeva="Tolstoyeva";
				pushkina="Pushkina";
				dobryakova="Dobryakova";
				timoshenkoa="Timoshenkoa";
				alekseeva="Alekseeva";
				zhitkova="Zhitkova";
				potapenkova="Potapenkova";
				yefremova="Yefremova";
				kraskova="Kraskova";
				pashinina="Pashinina";
				yeltsina="Yeltsina";
				medvedeva="Medvedeva";
				putina="Putina";
				smirnova="Smirnova";
				kuznetsova="Kuznetsova";
				vasilyeva="Vasilyeva";
				petrova="Petrova";
				golovkoa="Golovkoa";
				chapayeva="Chapayeva";
				mamayeva="Mamayeva";
				baranova="Baranova";
				beregovoia="Beregovoia";
				derevenkova="Derevenkova";
				glebova="Glebova";
				gorbunova="Gorbunova";
				kirygina="Kirygina";
				lermontova="Lermontova";
				litvinova="Litvinova";
				maryshkina="Naryshkina";
				morozova="Morozova";
				molotova="Molotova";
				popova="Popova";
				privalova="Privalova";
				titova="Titova";
				sudakova="Sudakova";
				kameneva="Kameneva";
				yakushkina="Yakushkina";
				yagudina="Yagudina";
			};
		};
		class EnglishMen
		{
			class FirstNames
			{
				michael="Michael";
				jacob="Jacob";
				matthew="Matthew";
				joseph="Joseph";
				christopher="Christopher";
				nicholas="Nicholas";
				andrew="Andrew";
				william="William";
				joshua="Joshua";
				daniel="Daniel";
				tyler="Tyler";
				ryan="Ryan";
				anthony="Anthony";
				alexander="Alexander";
				zachary="Zachary";
				david="David";
				james="James";
				john="John";
				christian="Christian";
				justin="Justin";
				benjamin="Benjamin";
				austin="Austin";
				brandon="Brandon";
				samuel="Samuel";
				dylan="Dylan";
				noah="Noah";
				bobby="Bobby";
				nathan="Nathan";
				ethan="Ethan";
				jonathan="Jonathan";
				harry="Harry";
				sean="Sean";
				jeremy="Jeremy";
				cameron="Cameron";
				edgar="Edgar";
				carlos="Carlos";
				eric="Eric";
				miguel="Miguel";
				ian="Ian";
				chad="Chad";
				bryan="Bryan";
				travis="Travis";
				peter="Peter";
				jesse="Jesse";
				mark="Mark";
				jared="Jared";
				richard="Richard";
				mario="Mario";
				george="George";
				edward="Edward";
				steven="Steven";
				mike="Mike";
				evan="Evan";
				simon="Simon";
				alan="Alan";
			};
			class LastNames
			{
				smith="Smith";
				johnson="Johnson";
				williams="Williams";
				jones="Jones";
				brown="Brown";
				davis="Davis";
				miller="Miller";
				wilson="Wilson";
				moore="Moore";
				taylor="Taylor";
				anderson="Anderson";
				thomas="Thomas";
				jackson="Jackson";
				white="White";
				harris="Harris";
				martin="Martin";
				thompson="Thompson";
				garcia="Garcia";
				martinez="Martinez";
				robinson="Robinson";
				clark="Clark";
				lewis="Lewis";
				lee="Lee";
				walker="Walker";
				hall="Hall";
				allen="Allen";
				young="Young";
				king="King";
				wright="Wright";
				hill="Hill";
				scott="Scott";
				doe="Doe";
				vomacka="Vomacka";
				carey="Carey";
				melvin="Melvin";
				gluck="Gluck";
				eady="Eady";
				richardson="Richardson";
				shannon="Shannon";
				mcgregor="McGregor";
				hoffman="Hoffman";
				killoran="Killoran";
				rochelle="Rochelle";
				goben="Goben";
				hanau="Hanau";
				bircsak="Bircsak";
				wagner="Wagner";
				green="Green";
				adams="Adams";
				gonzales="Gonzales";
				carter="Carter";
				campbell="Campbell";
				collins="Collins";
				rodriguez="Rodriguez";
				mitchell="Mitchell";
				lopez="Lopez";
				pound="Pound";
				self="Self";
				bruning="Bruning";
				hirasaki="Hirasaki";
				byrd="Byrd";
				sissman="Sissman";
				hutchinson="Hutchinson";
				nielsen="Nielsen";
			};
		};
		class EnglishWomen
		{
			class FirstNames
			{
				hannah="Hannah";
				emily="Emily";
				madison="Madison";
				elizabeth="Elizabeth";
				alexis="Alexis";
				sarah="Sarah";
				taylor="Taylor";
				lauren="Lauren";
				jessica="Jessica";
				ashley="Ashley";
				samantha="Samantha";
				brianna="Brianna";
				kayla="Kayla";
				olivia="Olivia";
				abigail="Abigail";
				anna="Anna";
				alyssa="Alyssa";
				emma="Emma";
				jennifer="Jennifer";
				nicole="Nicole";
				grace="Grace";
				alexandra="Alexandra";
				sydney="Sydney";
				rachel="Rachel";
				victoria="Victoria";
				morgan="Morgan";
				haley="Haley";
				katherine="Katherine";
				amanda="Amanda";
				megan="Megan";
			};
			class LastNames
			{
				smith="Smith";
				johnson="Johnson";
				williams="Williams";
				jones="Jones";
				brown="Brown";
				davis="Davis";
				miller="Miller";
				wilson="Wilson";
				moore="Moore";
				taylor="Taylor";
				anderson="Anderson";
				thomas="Thomas";
				jackson="Jackson";
				white="White";
				harris="Harris";
				martin="Martin";
				thompson="Thompson";
				garcia="Garcia";
				martinez="Martinez";
				robinson="Robinson";
				clark="Clark";
				lewis="Lewis";
				lee="Lee";
				walker="Walker";
				hall="Hall";
				allen="Allen";
				young="Young";
				king="King";
				wright="Wright";
				hill="Hill";
				doe="Doe";
				green="Green";
				adams="Adams";
				gonzales="Gonzales";
				carter="Carter";
				campbell="Campbell";
				collins="Collins";
				rodriguez="Rodriguez";
				scott="Scott";
				mitchell="Mitchell";
				lopez="Lopez";
				pound="Pound";
				self="Self";
				bruning="Bruning";
				hirasaki="Hirasaki";
				byrd="Byrd";
				sissman="Sissman";
				hutchinson="Hutchinson";
				nielsen="Nielsen";
			};
		};
		class CzechMen
		{
			class FirstNames
			{
				rostislav="Rostislav";
				matous="Matous";
				ivan="Ivan";
				jakub="Jakub";
				josef="Josef";
				zdislav="Zdislav";
				lukas="Lukas";
				vilem="Vilem";
				michal="Michal";
				martin="Martin";
				jiri="Jiri";
				vasil="Vasil";
				bohuslav="Bohuslav";
				boris="Boris";
				pavel="Pavel";
				vladimir="Vladimir";
				oleg="Oleg";
				daniel="Daniel";
				marek="Marek";
				fedor="Fedor";
				vlastimil="Vlastimil";
				frantisek="Frantisek";
				jan="Jan";
				radim="Radim";
				kiril="Kiril";
				petr="Petr";
				filip="Filip";
				miro="Miro";
				bronislav="Bronislav";
				marian="Marian";
				libor="Libor";
				ctibor="Ctibor";
				karel="Karel";
				jaroslav="Jaroslav";
				dalibor="Dalibor";
				jaromir="Jaromir";
				otakar="Otakar";
				slavomir="Slavomir";
				vojtech="Vojtech";
				dobromil="Dobromil";
				ladislav="Ladislav";
				taras="Taras";
				miroslav="Miroslav";
				ctirad="Ctirad";
				andrej="Andrej";
				igor="Igor";
				alexandr="Alexandr";
				lev="Lev";
				dmytro="Dmytro";
				bogdan="Bogdan";
				viktor="Viktor";
				stanislav="Stanislav";
				ruslan="Ruslan";
				vadim="Vadim";
				semen="Semen";
				stepan="Stepan";
				roman="Roman";
				nikol="Nikola";
			};
			class LastNames
			{
				novak="Novak";
				masin="Masin";
				jiroutek="Jiroutek";
				benes="Benes";
				zemanek="Zemanek";
				vosahlo="Vosahlo";
				svoboda="Svoboda";
				hajek="Hajek";
				kral="Kral";
				novotny="Novotny";
				dvorak="Dvorak";
				moravec="Moravec";
				valenta="Valenta";
				hruby="Hruby";
				mach="Mach";
				liska="Liska";
				klima="Klima";
				kulhanek="Kulhanek";
				jelinek="Jelinek";
				zapletal="Zapletal";
				hanak="Hanak";
				slama="Slama";
				korinek="Korinek";
				martinek="Martinek";
				zelenka="Zelenka";
				kalina="Kalina";
				kvapil="Kvapil";
				skala="Skala";
				hujer="Hujer";
				peterka="Peterka";
				kozal="Kozel";
				smolik="Smolik";
				mucha="Mucha";
				smetana="Smetana";
				sejkora="Sejkora";
				nejedly="Nejedly";
				homolka="Homolka";
				hron="Hron";
				spanel="Spanel";
				vymazal="Vymazal";
				duda="Duda";
				vrzal="Vrzal";
				skopek="Skopek";
				horvat="Horvat";
				vitek="Vitek";
				nedbal="Nedbal";
				jelen="Jelen";
				starecek="Starecek";
				planicka="Planicka";
				konopnik="Konopnik";
				troska="Troska";
				bobek="Bobek";
				zajic="Zajic";
				nohavica="Nohavica";
				janda="Janda";
				koukal="Koukal";
				beran="Beran";
				beranek="Beranek";
				jary="Jary";
				lebeda="Lebeda";
				kropacek="Kropacek";
				horacek="Horacek";
				pazout="Pazout";
				pernica="Pernica";
				kana="Kana";
				macecek="Macecek";
				chlup="Chlup";
				brazda="Brazda";
				tuma="Tuma";
				matejka="Matejka";
				havel="Havel";
				prutko="Prutko";
				kravchuk="Kravchuk";
				guglava="Guglava";
				bulba="Bulba";
				horyna="Horyna";
				vanek="Vanek";
				grygar="Grygar";
				macura="Macura";
				kubik="Kubik";
				bednar="Bednar";
				hlinik="Hlinik";
				jurcik="Jurcik";
				janko="Janko";
				mazur="Mazur";
				ledvina="Ledvina";
				fojt="Fojt";
				gazda="Gazda";
				mironov="Mironov";
				antonov="Antonov";
				tkachuk="Tkachuk";
				petrenko="Petrenko";
				vandrovec="Vandrovec";
				korolenko="Korolenko";
				brodsky="Brodsky";
				rybski="Rybski";
				trachnikov="Trachnikov";
				nobski="Nobski";
				cerny="Cerny";
				suhaj="Suhaj";
			};
		};
		class CzechWomen
		{
			class FirstNames
			{
				ludmila="Ludmila";
				ivana="Ivana";
				anna="Anna";
				petra="Petra";
				katerina="Katerina";
				vera="Vera";
				hana="Hana";
				daniela="Daniela";
				eva="Eva";
				magda="Magda";
				bozena="Bozena";
				darja="Darja";
				natalia="Natalia";
				natasha="Natasha";
				irina="Irina";
				olga="Olga";
				zuzana="Zuzana";
				marie="Marie";
				martina="Martina";
				pavla="Pavla";
				marta="Marta";
				zlata="Zlata";
				kazi="Kazi";
				libuse="Libuse";
				teta="Teta";
				linda="Linda";
				marketa="Marketa";
				eliska="Eliska";
				apolena="Apolena";
				vladimira="Vladimira";
				jana="Jana";
				dagmar="Dagmar";
				jaroslava="Jaroslava";
				nela="Nela";
				sara="Sara";
				karolina="Karolina";
				nikola="Nikola";
				gabriela="Gabriela";
			};
			class LastNames
			{
				novakova="Novakova";
				kubikova="Kubikova";
				masinova="Masinova";
				jiroutkova="Jiroutkova";
				benesova="Benesova";
				zemankova="Zemankova";
				vosahlova="Vosahlova";
				svobodova="Svobodova";
				hajkova="Hajkova";
				kralova="Kralova";
				novotna="Novotna";
				dvorakova="Dvorakova";
				moravcova="Moravcova";
				valentova="Valentova";
				hruba="Hruba";
				machova="Machova";
				liskova="Liskova";
				klimova="Klimova";
				kulhankova="Kulhankova";
				jelinkova="Jelinkova";
				zapletalova="Zapletalova";
				hanakova="Hanakova";
				slamova="Slamova";
				korinkova="Korinkova";
				martinkova="Martinkova";
				zelenkova="Zelenkova";
				kalinova="Kalinova";
				kvapilova="Kvapilova";
				skalova="Skalova";
				hujerova="Hujerova";
				peterkova="Peterkova";
				kozlova="Kozlova";
				smolikova="Smolikova";
				muchova="Muchova";
				smetanova="Smetanova";
				sejkorova="Sejkorova";
				nejedla="Nejedla";
				homolkova="Homolkova";
				hronova="Hronova";
				spanelova="Spanelova";
				vymazalova="Vymazalova";
				dudova="Dudova";
				vrzalova="Vrzalova";
				skopkova="Skopkova";
				horvatova="Horvatova";
				vitkova="Vitkova";
				nedbalova="Nedbalova";
				jelenova="Jelenova";
				planickova="Planickova";
				konopnikova="Konopnikova";
				troskova="Troskova";
				bobkova="Bobkova";
				zajicova="Zajicova";
				nohavicova="Nohavicova";
				jandova="Jandova";
				koukalova="Koukalova";
				beranova="Beranova";
				berankova="Berankova";
				jara="Jara";
				lebedova="Lebedova";
				kropackova="Kropackova";
				horackova="Horackova";
				pazoutova="Pazoutova";
				pernicova="Perniaova";
				kanava="Kanava";
				maceckova="Maceckova";
				chlupova="Chlupova";
				brazdaova="Brazdaova";
				tumova="Tumova";
				matejkova="Matejkova";
				havlova="Havlova";
				prutkova="Prutkova";
				kravchukova="Kravchukova";
				guglavova="Guglavova";
				bulbova="Bulbova";
				horynova="Horynova";
				vankova="Vankova";
				grygarova="Grygarova";
				macuraova="Macuraova";
				bednarova="Bednarova";
				hlinikova="Hlinikova";
				jurcikova="Jurcikova";
				jankova="Jankova";
				mazurova="Mazurova";
				ledvinova="Ledvinova";
				stareckova="Stareckova";
				fojtova="Fojtova";
				gazdova="Gazdova";
				mironovova="Mironovova";
				antonovova="Antonovova";
				tkachukova="Tkachukova";
				petrenkova="Petrenkova";
				vandrovcova="Vandrovcova";
				korolenkova="Korolenkova";
				brodska="Brodska";
				rybska="Rybska";
				trachnikovova="Trachnikovova";
				nobska="Nobska";
				cerna="Cerna";
				suhajova="Suhajova";
			};
		};
		class CivilianMen
		{
			class FirstNames
			{
				rostislav="Rostislav";
				matous="Matous";
				ivan="Ivan";
				jakub="Jakub";
				josef="Josef";
				zdislav="Zdislav";
				lukas="Lukas";
				vilem="Vilem";
				michal="Michal";
				martin="Martin";
				jiri="Jiri";
				vasil="Vasil";
				bohuslav="Bohuslav";
				boris="Boris";
				pavel="Pavel";
				vladimir="Vladimir";
				oleg="Oleg";
				daniel="Daniel";
				marek="Marek";
				fedor="Fedor";
				vlastimil="Vlastimil";
				frantisek="Frantisek";
				jan="Jan";
				radim="Radim";
				kiril="Kiril";
				petr="Petr";
				filip="Filip";
				miro="Miro";
				bronislav="Bronislav";
				marian="Marian";
				libor="Libor";
				ctibor="Ctibor";
				karel="Karel";
				jaroslav="Jaroslav";
				dalibor="Dalibor";
				jaromir="Jaromir";
				otakar="Otakar";
				slavomir="Slavomir";
				vojtech="Vojtech";
				dobromil="Dobromil";
				ladislav="Ladislav";
				taras="Taras";
				miroslav="Miroslav";
				ctirad="Ctirad";
				andrej="Andrej";
				igor="Igor";
				alexandr="Alexandr";
				lev="Lev";
				dmytro="Dmytro";
				bogdan="Bogdan";
				viktor="Viktor";
				stanislav="Stanislav";
				ruslan="Ruslan";
				vadim="Vadim";
				semen="Semen";
				stepan="Stepan";
				roman="Roman";
				nikol="Nikola";
				yuri="Yuri";
				aleksei="Aleksei";
				maksim="Maksim";
				valery="Valery";
				vyacheslav="Vyacheslav";
				vitaly="Vitaly";
				nikita="Nikita";
				timofey="Timofey";
				valentin="Valentin";
				leonid="Leonid";
				ilya="Ilya";
				grigoriy="Grigoriy";
				abram="Abram";
				arkadiy="Arkadiy";
				german="German";
				kuzma="Kuzma";
				semyon="Semyon";
				yevgeniy="Yevgeniy";
			};
			class LastNames
			{
				novak="Novak";
				masin="Masin";
				jiroutek="Jiroutek";
				benes="Benes";
				zemanek="Zemanek";
				vosahlo="Vosahlo";
				svoboda="Svoboda";
				hajek="Hajek";
				kral="Kral";
				novotny="Novotny";
				dvorak="Dvorak";
				moravec="Moravec";
				valenta="Valenta";
				hruby="Hruby";
				mach="Mach";
				liska="Liska";
				klima="Klima";
				kulhanek="Kulhanek";
				jelinek="Jelinek";
				zapletal="Zapletal";
				hanak="Hanak";
				slama="Slama";
				korinek="Korinek";
				martinek="Martinek";
				zelenka="Zelenka";
				kalina="Kalina";
				kvapil="Kvapil";
				skala="Skala";
				hujer="Hujer";
				peterka="Peterka";
				kozal="Kozel";
				smolik="Smolik";
				mucha="Mucha";
				smetana="Smetana";
				sejkora="Sejkora";
				nejedly="Nejedly";
				homolka="Homolka";
				hron="Hron";
				spanel="Spanel";
				vymazal="Vymazal";
				duda="Duda";
				vrzal="Vrzal";
				skopek="Skopek";
				horvat="Horvat";
				vitek="Vitek";
				nedbal="Nedbal";
				jelen="Jelen";
				planicka="Planicka";
				konopnik="Konopnik";
				troska="Troska";
				bobek="Bobek";
				zajic="Zajic";
				nohavica="Nohavica";
				janda="Janda";
				koukal="Koukal";
				beran="Beran";
				beranek="Beranek";
				jary="Jary";
				lebeda="Lebeda";
				kropacek="Kropacek";
				horacek="Horacek";
				pazout="Pazout";
				pernica="Pernica";
				kana="Kana";
				macecek="Macecek";
				chlup="Chlup";
				brazda="Brazda";
				tuma="Tuma";
				matejka="Matejka";
				havel="Havel";
				prutko="Prutko";
				kravchuk="Kravchuk";
				guglava="Guglava";
				bulba="Bulba";
				horyna="Horyna";
				vanek="Vanek";
				grygar="Grygar";
				macura="Macura";
				bednar="Bednar";
				hlinik="Hlinik";
				jurcik="Jurcik";
				janko="Janko";
				mazur="Mazur";
				ledvina="Ledvina";
				fojt="Fojt";
				gazda="Gazda";
				mironov="Mironov";
				antonov="Antonov";
				tkachuk="Tkachuk";
				petrenko="Petrenko";
				vandrovec="Vandrovec";
				korolenko="Korolenko";
				brodsky="Brodsky";
				rybski="Rybski";
				trachnikov="Trachnikov";
				nobski="Nobski";
				cerny="Cerny";
				suhaj="Suhaj";
				moricky="Moricky";
				maksimov="Maksimov";
				fisenko="Fisenko";
				shcherbakov="Shcherbakov";
				zverev="Zverev";
				turchinsky="Turchinsky";
				malyukov="Malyukov";
				bychkov="Bychkov";
				zhegalov="Zhegalov";
				dobryakov="Dobryakov";
				timoshenko="Timoshenko";
				alekseev="Alekseev";
				zhitkov="Zhitkov";
				potapenko="Potapenko";
				yefremov="Yefremov";
				krasko="Krasko";
				pashinin="Pashinin";
				smirnov="Smirnov";
				kuznetsov="Kuznetsov";
				vasilyev="Vasilyev";
				jagos="Jagos";
				pravda="Pravda";
			};
		};
		class CivilianWomen
		{
			class FirstNames
			{
				ludmila="Ludmila";
				ivana="Ivana";
				anna="Anna";
				petra="Petra";
				katerina="Katerina";
				vera="Vera";
				hana="Hana";
				daniela="Daniela";
				eva="Eva";
				magda="Magda";
				bozena="Bozena";
				darja="Darja";
				natalia="Natalia";
				natasha="Natasha";
				irina="Irina";
				olga="Olga";
				marie="Marie";
				martina="Martina";
				pavla="Pavla";
				marta="Marta";
				zlata="Zlata";
				kazi="Kazi";
				libuse="Libuse";
				teta="Teta";
				linda="Linda";
				marketa="Marketa";
				eliska="Eliska";
				apolena="Apolena";
				vladimira="Vladimira";
				jana="Jana";
				dagmar="Dagmar";
				jaroslava="Jaroslava";
				nela="Nela";
				sara="Sara";
				karolina="Karolina";
				nikola="Nikola";
				oksana="Oksana";
				raisa="Raisa";
				svetlana="Svetlana";
				tamara="Tamara";
				tatyana="Tatyana";
				zoya="Zoya";
				zhenya="Zhenya";
				katya="Katya";
				nadya="Nadya";
				sasha="Sasha";
				yulya="Yulya";
				lena="Lena";
				karina="Karina";
				nina="Nina";
				yelena="Yelena";
				viktorie="Viktorie";
				gabriela="Gabriela";
			};
			class LastNames
			{
				novakova="Novakova";
				masinova="Masinova";
				jiroutkova="Jiroutkova";
				benesova="Benesova";
				zemankova="Zemankova";
				vosahlova="Vosahlova";
				svobodova="Svobodova";
				hajkova="Hajkova";
				kralova="Kralova";
				novotna="Novotna";
				dvorakova="Dvorakova";
				moravcova="Moravcova";
				valentova="Valentova";
				hruba="Hruba";
				machova="Machova";
				liskova="Liskova";
				klimova="Klimova";
				kulhankova="Kulhankova";
				jelinkova="Jelinkova";
				zapletalova="Zapletalova";
				hanakova="Hanakova";
				slamova="Slamova";
				korinkova="Korinkova";
				martinkova="Martinkova";
				zelenkova="Zelenkova";
				kalinova="Kalinova";
				kvapilova="Kvapilova";
				skalova="Skalova";
				hujerova="Hujerova";
				peterkova="Peterkova";
				kozlova="Kozlova";
				smolikova="Smolikova";
				muchova="Muchova";
				smetanova="Smetanova";
				sejkorova="Sejkorova";
				nejedla="Nejedla";
				homolkova="Homolkova";
				hronova="Hronova";
				spanelova="Spanelova";
				vymazalova="Vymazalova";
				dudova="Dudova";
				vrzalova="Vrzalova";
				skopkova="Skopkova";
				horvatova="Horvatova";
				vitkova="Vitkova";
				nedbalova="Nedbalova";
				jelenova="Jelenova";
				planickova="Planickova";
				konopnikova="Konopnikova";
				troskova="Troskova";
				bobkova="Bobkova";
				zajicova="Zajicova";
				nohavicova="Nohavicova";
				jandova="Jandova";
				koukalova="Koukalova";
				beranova="Beranova";
				berankova="Berankova";
				jara="Jara";
				lebedova="Lebedova";
				kropackova="Kropackova";
				horackova="Horackova";
				pazoutova="Pazoutova";
				pernicova="Perniaova";
				kanova="Kanova";
				maceckova="Maceckova";
				chlupova="Chlupova";
				brazdaova="Brazdaova";
				tumova="Tumova";
				matejkova="Matejkova";
				havlova="Havlova";
				prutkova="Prutkova";
				kravchukova="Kravchukova";
				guglavova="Guglavova";
				bulbova="Bulbova";
				horynova="Horynova";
				vankova="Vankova";
				grygarova="Grygarova";
				macuraova="Macuraova";
				bednarova="Bednarova";
				hlinikova="Hlinikova";
				jurcikova="Jurcikova";
				jankova="Jankova";
				mazurova="Mazurova";
				ledvinova="Ledvinova";
				fojtova="Fojtova";
				gazdova="Gazdova";
				mironovova="Mironovova";
				antonovova="Antonovova";
				tkachukova="Tkachukova";
				petrenkova="Petrenkova";
				vandrovcova="Vandrovcova";
				korolenkova="Korolenkova";
				brodska="Brodska";
				rybska="Rybska";
				trachnikovova="Trachnikovova";
				nobska="Nobska";
				cerna="Cerna";
				suhajova="Suhajova";
				produnova="Produnova";
				zubova="Zubova";
				blagonravova="Blagonravova";
				davidova="Davidova";
				gusakova="Gusakova";
				nikolayeva="Nikolayeva";
				ivanova="Ivanova";
				maksimova="Maksimova";
				fisenkova="Fisenkova";
				shcherbakova="Shcherbakova";
				zvereva="Zvereva";
				zykova="Zykova";
				doronina="Doronina";
				turchinskaya="Turchinskaya";
				malyukova="Malyukova";
				rogozhkina="Rogozhkina";
				bychkova="Bychkova";
				zhegalova="Zhegalova";
				soloveychika="Soloveychika";
				strugackaya="Strugackaya";
				bulgakova="Bulgakova";
				tolstoyeva="Tolstoyeva";
				pushkina="Pushkina";
				dobryakova="Dobryakova";
				timoshenkova="Timoshenkova";
				alekseeva="Alekseeva";
				kanalosova="Kanalosova";
				moricka="Moricka";
			};
		};
	};
	class DefaultLighting
	{
		access=3;
		groundReflection[]={0.085000001,0.068000004,0.034000002};
		moonObjectColorFull[]={0.89999998,0.89999998,1,0.69999999};
		moonHaloObjectColorFull[]={0.89999998,0.89999998,1,0.0099999998};
		moonsetObjectColor[]={0.89999998,0.75,0.40000001};
		moonsetHaloObjectColor[]={0.89999998,0.5,0.2};
		starEmissivity=0.30000001;
		class ThunderBoltLight
		{
			diffuse[]={1,1,2};
			ambient[]={0.5,0.5,1};
			intensity=1000000;
			class Attenuation
			{
				start=0;
				constant=0;
				linear=0;
				quadratic=1;
			};
		};
		nightAngle=5;
		sunSunset=20;
		endSunset=10;
	};
	class DefaultWorld
	{
		access=0;
		worldId=0;
		plateFormat="$$$  ## - ##";
		plateLetters="ABCDEFHIKLMOPRSTVXYZ";
		centerPosition[]={6400,6400,0};
		latitude=-40;
		longitude=15;
		class Music: CfgMusic
		{
		};
		class EnvSounds: CfgEnvSounds
		{
		};
		cutscenes[]=
		{
			"intro"
		};
		class ReplaceObjects
		{
		};
		landGrid=50;
		gridNumbersOverLines=0;
		class Grid
		{
			offsetX=0;
			offsetY=0;
			class Zoom1
			{
				zoomMax=0.1;
				format="XY";
				formatX="Aa";
				formatY="00";
				stepX=128;
				stepY=128;
			};
			class Zoom2
			{
				zoomMax=1e+030;
				format="XY";
				formatX="A";
				formatY="0";
				stepX=1280;
				stepY=1280;
			};
		};
		startTime="16:45";
		startDate="17/11/2006";
		startWeather=0.12;
		startFog=0;
		startFogBase=0;
		forecastFogBase=0;
		startFogDecay=0.0049999999;
		forecastFogDecay=0.0049999999;
		fogBeta0Min=9.9999997e-005;
		fogBeta0Max=0.02;
		hazeBaseHeight=0;
		hazeBaseBeta0=0;
		hazeDensityDecay=0.0049999999;
		startWind=0.1;
		startWindDir=0;
		startWaves=0.1;
		startRain=0;
		startLightnings=0;
		startGusts=0;
		forecastWeather=0.30000001;
		forecastFog=0;
		forecastWind=0.1;
		forecastWaves=0.1;
		forecastRain=0;
		forecastLightnings=0;
		forecastGusts=0;
		forecastWindDir=0;
		timeOfChanges=1800;
		rainForced=0;
		lightningsForced=0;
		wavesForced=0;
		windForced=0;
		class Lighting: DefaultLighting
		{
		};
		class DayLightingBrightAlmost
		{
			deepNight[]=
			{
				-15,
				{0.050000001,0.050000001,0.059999999},
				{0.001,0.001,0.0020000001},
				{0.02,0.02,0.050000001},
				{0.003,0.003,0.003},
				{0.003,0.003,0.0060000001},
				{0.003,0.003,0.0060000001},
				0
			};
			fullNight[]=
			{
				-5,
				{0.050000001,0.050000001,0.059999999},
				{0.02,0.02,0.02},
				{0.039999999,0.039999999,0.039999999},
				{0.039999999,0.039999999,0.039999999},
				{0.0099999998,0.0099999998,0.02},
				{0.079999998,0.059999999,0.059999999},
				0
			};
			sunMoon[]=
			{
				-3.75,
				{0.039999999,0.039999999,0.050000001},
				{0.039999999,0.039999999,0.050000001},
				{0.039999999,0.039999999,0.050000001},
				{0.039999999,0.039999999,0.050000001},
				{0.039999999,0.035,0.039999999},
				{0.11,0.079999998,0.090000004},
				0.5
			};
			earlySun[]=
			{
				-2.5,
				{0.31999999,0.23999999,0.28},
				{0.079999998,0.059999999,0.07},
				{0.31999999,0.23999999,0.28},
				{0.079999998,0.059999999,0.07},
				{0.079999998,0.07,0.079999998},
				{0.14,0.1,0.12},
				1
			};
			sunrise[]=
			{
				0,
				
				{
					{0.69999999,0.44999999,0.44999999},
					"5.5+(-4)"
				},
				
				{
					{0.07,0.090000004,0.12},
					"4.5+(-4)"
				},
				
				{
					{0.60000002,0.47,0.25},
					"4.7+(-4)"
				},
				
				{
					{0.1,0.090000004,0.1},
					"4.4+(-4)"
				},
				
				{
					{0.5,0.40000001,0.40000001},
					"4.5+(-4)"
				},
				
				{
					{0.88,0.50999999,0.23999999},
					"6+(-4)"
				},
				1
			};
			earlyMorning[]=
			{
				5,
				
				{
					{0.64999998,0.55000001,0.55000001},
					"6+(-4)"
				},
				
				{
					{0.079999998,0.090000004,0.11},
					"5+(-4)"
				},
				
				{
					{0.55000001,0.47,0.25},
					"5.75+(-4)"
				},
				
				{
					{0.1,0.090000004,0.1},
					"4.75+(-4)"
				},
				
				{
					{0.5,0.40000001,0.40000001},
					"7.5+(-4)"
				},
				
				{
					{0.88,0.50999999,0.23999999},
					"8.75+(-4)"
				},
				1
			};
			midMorning[]=
			{
				15,
				
				{
					{0.98000002,0.85000002,0.80000001},
					"10.5+(-4)"
				},
				
				{
					{0.079999998,0.090000004,0.11},
					"6.5+(-4)"
				},
				
				{
					{0.87,0.47,0.25},
					"9.5+(-4)"
				},
				
				{
					{0.090000004,0.090000004,0.1},
					"7.5+(-4)"
				},
				
				{
					{0.5,0.40000001,0.40000001},
					"9.5+(-4)"
				},
				
				{
					{0.88,0.50999999,0.23999999},
					"9.75+(-4)"
				},
				1
			};
			morning[]=
			{
				25,
				
				{
					{1,1,0.89999998},
					"15.5+(-4)"
				},
				
				{
					{0.17,0.18000001,0.19},
					"12.5+(-4)"
				},
				
				{
					{1,1,0.89999998},
					"14.5+(-4)"
				},
				
				{
					{0.17,0.18000001,0.19},
					"13+(-4)"
				},
				
				{
					{0.15000001,0.15000001,0.15000001},
					"14.5+(-4)"
				},
				
				{
					{0.17,0.17,0.15000001},
					"15.5+(-4)"
				},
				1
			};
			noon[]=
			{
				70,
				
				{
					{0.95999998,0.98000002,1},
					"15.75+(-4)"
				},
				
				{
					{0.36000001,0.49000001,0.61000001},
					"13+(-4)"
				},
				
				{
					{1,1,1},
					"15+(-4)"
				},
				
				{
					{0.36000001,0.37,0.38},
					"13.5+(-4)"
				},
				
				{
					{0.89999998,0.89999998,0.89999998},
					"15+(-4)"
				},
				
				{
					{1,1,0.89999998},
					"16+(-4)"
				},
				1
			};
		};
		class DayLightingRainy
		{
			deepNight[]=
			{
				-15,
				{0.0034,0.0034,0.0040000002},
				{0.003,0.003,0.003},
				{0.0034,0.0034,0.0040000002},
				{0.003,0.003,0.003},
				{0.003,0.003,0.0060000001},
				{0.003,0.003,0.0060000001},
				0
			};
			fullNight[]=
			{
				-5,
				{0.023,0.023,0.023},
				{0.02,0.02,0.02},
				{0.023,0.023,0.023},
				{0.02,0.02,0.02},
				{0.0099999998,0.0099999998,0.02},
				{0.079999998,0.059999999,0.059999999},
				0
			};
			sunMoon[]=
			{
				-3.75,
				{0.039999999,0.039999999,0.050000001},
				{0.039999999,0.039999999,0.050000001},
				{0.039999999,0.039999999,0.050000001},
				{0.039999999,0.039999999,0.050000001},
				{0.039999999,0.035,0.039999999},
				{0.11,0.079999998,0.090000004},
				0.5
			};
			earlySun[]=
			{
				-2.5,
				{0.068899997,0.068899997,0.080399998},
				{0.059999999,0.059999999,0.07},
				{0.068899997,0.068899997,0.080399998},
				{0.059999999,0.059999999,0.07},
				{0.079999998,0.07,0.079999998},
				{0.14,0.1,0.12},
				0.5
			};
			earlyMorning[]=
			{
				0,
				
				{
					{1,1,1},
					"(-4)+3.95"
				},
				
				{
					{1,1,1},
					"(-4)+3.75"
				},
				
				{
					{1,1,1},
					"(-4)+3.95"
				},
				
				{
					{1,1,1},
					"(-4)+3.75"
				},
				
				{
					{1,1,1},
					"(-4)+4"
				},
				
				{
					{1,1,1},
					"(-4)+4.5"
				},
				1
			};
			morning[]=
			{
				5,
				
				{
					{1,1,1},
					"(-4)+5.7"
				},
				
				{
					{1,1,1},
					"(-4)+5.5"
				},
				
				{
					{1,1,1},
					"(-4)+5.7"
				},
				
				{
					{1,1,1},
					"(-4)+5.5"
				},
				
				{
					{1,1,1},
					"(-4)+7"
				},
				
				{
					{1,1,1},
					"(-4)+7.5"
				},
				1
			};
			lateMorning[]=
			{
				25,
				
				{
					{1,1,1},
					"(-4)+10.45"
				},
				
				{
					{1,1,1},
					"(-4)+10.25"
				},
				
				{
					{1,1,1},
					"(-4)+10.45"
				},
				
				{
					{1,1,1},
					"(-4)+10.25"
				},
				
				{
					{1,1,1},
					"(-4)+12"
				},
				
				{
					{1,1,1},
					"(-4)+12.5"
				},
				1
			};
			noon[]=
			{
				70,
				
				{
					{1,1,1},
					"(-4)+10.7"
				},
				
				{
					{1,1,1},
					"(-4)+10.5"
				},
				
				{
					{1,1,1},
					"(-4)+10.7"
				},
				
				{
					{1,1,1},
					"(-4)+10.5"
				},
				
				{
					{1,1,1},
					"(-4)+12.25"
				},
				
				{
					{1,1,1},
					"(-4)+12.75"
				},
				1
			};
		};
		class Weather
		{
			rainEnabled=1;
			class RainConfig
			{
				minCloudiness=0.5;
				averageCloudLimit=0.60000002;
				minProbability=0.02;
				maxProbability=0.89999998;
				minRainDensity=0.2;
				maxRainDensity=1;
				rainChange=60;
				rainFading=30;
				squareLength=0.5;
			};
			class LightningsConfig
			{
				minCloudiness=0.85000002;
				minProbability=0;
				maxProbability=0.25;
				minCount=3;
				maxCount=6;
				scatter=120;
			};
			class WindConfig
			{
				windChange=5;
				minForce=0;
				maxForce=10;
				minForceScatter=2;
				maxForceScatter=5;
				minGustCount=0;
				maxGustCount=10;
				gustTimeScatter=120;
				minGustScatter=10;
				maxGustScatter=20;
				gustInfluenceMin=0.2;
				gustInfluenceMax=0.40000001;
				speedOfWindChange=2;
				minGustValue=0;
				maxGustValue=0.69999999;
			};
			class RainbowConfig
			{
				distance=10;
				intensityCoef=0.34999999;
				maxCloudiness=0.55000001;
			};
			class Overcast
			{
				class Weather1
				{
					overcast=0;
					sky="#(argb,8,8,3)color(0.46,0.51,0.67,1)";
					skyR="#(argb,8,8,3)color(0.46,0.51,0.67,1)";
					horizon="#(argb,8,8,3)color(0.46,0.51,0.67,1)";
					alpha=0;
					bright=0.5;
					speed=0.2;
					size=0.2;
					height=1;
					through=1;
					lightingOvercast=0;
					diffuse=1;
					cloudDiffuse=1;
					waves=0.15000001;
				};
				class Weather2
				{
					overcast=0.1;
					sky="#(argb,8,8,3)color(0.46,0.51,0.67,1)";
					skyR="#(argb,8,8,3)color(0.46,0.51,0.67,1)";
					horizon="#(argb,8,8,3)color(0.46,0.51,0.67,1)";
					alpha=0.30000001;
					size=0.30000001;
					height=0.89999998;
					bright=0.5;
					speed=0.25;
					through=1;
					lightingOvercast=0.1;
					diffuse=1;
					cloudDiffuse=0.89999998;
					waves=0.22;
				};
				class Weather3
				{
					overcast=0.40000001;
					sky="#(argb,8,8,3)color(0.51,0.57,0.79,1)";
					skyR="#(argb,8,8,3)color(0.51,0.57,0.79,1)";
					horizon="#(argb,8,8,3)color(0.46,0.51,0.67,1)";
					alpha=0.98000002;
					size=0.5;
					height=0.80000001;
					bright=0.44999999;
					speed=0.40000001;
					through=0.80000001;
					lightingOvercast=0.60000002;
					diffuse=0.69999999;
					cloudDiffuse=0.40000001;
					waves=0.5;
				};
				class Weather4
				{
					overcast=0.69999999;
					sky="#(argb,8,8,3)color(0.56,0.6,0.76,1)";
					skyR="#(argb,8,8,3)color(0.56,0.6,0.76,1)";
					horizon="#(argb,8,8,3)color(0.46,0.51,0.67,1)";
					alpha=0.97000003;
					size=0.75;
					height=0.75;
					bright=0.44999999;
					speed=0.69999999;
					through=0.2;
					diffuse=0.40000001;
					lightingOvercast=0.89999998;
					cloudDiffuse=0.75;
					waves=0.60000002;
				};
				class Weather5
				{
					overcast=1;
					sky="#(argb,8,8,3)color(0.39,0.39,0.4,1)";
					skyR="#(argb,8,8,3)color(0.39,0.39,0.4,1)";
					horizon="#(argb,8,8,3)color(0.46,0.51,0.67,1)";
					alpha=0.98000002;
					size=0.89999998;
					height=0.69999999;
					bright=0.44999999;
					speed=1;
					through=0;
					diffuse=0.2;
					cloudDiffuse=0.94999999;
					waves=0.69999999;
					lightingOvercast=1;
				};
			};
			class Lighting
			{
				class BrightAlmost: DayLightingBrightAlmost
				{
					overcast=0;
				};
				class Rainy: DayLightingRainy
				{
					overcast=1;
				};
			};
			class ThunderboltNorm
			{
				model="\core\default\default.p3d";
				soundNear[]=
				{
					"",
					0.31622776,
					1
				};
				soundFar[]=
				{
					"",
					0.31622776,
					1
				};
			};
			class ThunderboltHeavy
			{
				model="\core\default\default.p3d";
				soundNear[]=
				{
					"",
					0.31622776,
					1
				};
				soundFar[]=
				{
					"",
					0.31622776,
					1
				};
			};
			temperatureDayMax[]={10,12,15,20,25,35,35,35,25,20,10,10};
			temperatureDayMin[]={-10,-6,-5,-1,5,6,7,10,5,2,-5,-10};
			temperatureNightMax[]={5,6,8,10,13,18,26,25,15,13,8,4};
			temperatureNightMin[]={-10,-10,-10,-5,0,4,5,6,5,0,-5,-10};
			overcastTemperatureFactor=0.40000001;
			blackSurfaceTemperatureDelta=5;
			whiteSurfaceTemperatureDelta=-2;
		};
		class Rain
		{
			texture="core\default_co.paa";
			speed=1;
			levels[]={8,2};
			raindrop="\core\default\default.p3d";
		};
		class RainParticles
		{
			rainDropTexture="core\default_co.paa";
			texDropCount=4;
			minRainDensity=0.0099999998;
			effectRadius=15;
			windCoef=0.050000001;
			dropSpeed=15;
			rndSpeed=0.2;
			rndDir=0.1;
			dropWidth=0.039999999;
			dropHeight=0.80000001;
			dropColor[]={0.1,0.1,0.1,0.1};
			lumSunFront=0.30000001;
			lumSunBack=0.1;
			refractCoef=0.30000001;
			refractSaturation=0.30000001;
		};
		humidityUpCoef=0.1;
		humidityDownCoef=0.050000001;
		class SimulWeather
		{
			noiseTexture="";
			numKeyframesPerDay=48;
			windSpeedCoef=10;
			moonIrradianceCoef=10;
			fadeMaxDistanceKm=300;
			fadeMaxAltitudeKm=15;
			fadeNumAltitudes=4;
			fadeNumElevations=8;
			fadeNumDistances=8;
			fadeEarthTest=0;
			autoBrightness=1;
			autoBrightnessStrength=0.1;
			cloudGridWidth=128;
			cloudGridLength=128;
			cloudGridHeight=16;
			helperGridElevationSteps=24;
			helperGridAzimuthSteps=15;
			helperEffectiveEarthRadius=6378000;
			helperCurvedEarth=1;
			helperAdjustCurvature=0;
			helperNumLayers=100;
			helperMaxDistance=200000;
			helperNearCloudFade=0.5;
			helperChurn=10;
			cloudWidth=60000;
			cloudLength=60000;
			wrapClouds=1;
			noiseResolution=8;
			noisePeriod=4;
			opticalDensity=1.8;
			alphaSharpness=0.15000001;
			selfShadowScale=0.001;
			mieAsymmetry=0.87;
			minimumLightElevationDegrees=3;
			directLightCoef=0.25;
			indirectLightCoef=0.0099999998;
			fogStart=10000;
			fogEnd=30000;
			fogHeight=1000;
			class DefaultKeyframe
			{
				rayleigh[]={0.0074900002,0.01388,0.02878};
				mie[]={0.0046000001,0.0046000001,0.0046000001};
				haze=1;
				hazeBaseKm=1;
				hazeScaleKm=0.5;
				hazeEccentricity=0.81999999;
				brightnessAdjustment=1;
				cloudiness=0.5;
				cloudBaseKm=3.2;
				cloudHeightKm=6;
				directLight=1;
				indirectLight=1;
				ambientLight=1;
				noiseOctaves=3;
				noisePersistence=0.55000001;
				fractalAmplitude=2.2;
				fractalWavelength=220;
				extinction=1.8;
				diffusivity=0.0099999998;
			};
			class Overcast
			{
				class Weather1: DefaultKeyframe
				{
					overcast=0;
					cloudiness=0;
				};
				class Weather2: DefaultKeyframe
				{
					overcast=0.2;
					cloudiness=0.1;
				};
				class Weather3: DefaultKeyframe
				{
					overcast=0.40000001;
					cloudiness=0.2;
				};
				class Weather4: DefaultKeyframe
				{
					overcast=0.60000002;
					cloudiness=0.40000001;
				};
				class Weather5: DefaultKeyframe
				{
					overcast=0.80000001;
					cloudiness=0.5;
				};
				class Weather6: DefaultKeyframe
				{
					overcast=1;
					cloudiness=0.60000002;
				};
			};
		};
		skyTexture="#(argb,8,8,3)color(0.35,0.47,0.66,1)";
		skyTextureR="#(argb,8,8,3)color(0.35,0.47,0.66,1)";
		seaTexture="#(rgb,8,8,3)color(0,0,0,1)";
		midDetailTexture="#(rgb,1,1,1)color(0.5,0.5,0.5,1,cdt)";
		outsideMaterial="";
		outsideHeight=-10;
		minHeight=-10;
		shoreTop=0;
		peakWaveTop=-1;
		peakWaveBottom=-5;
		clouds[]=
		{
			"core\default\default.p3d",
			"core\default\default.p3d",
			"core\default\default.p3d",
			"core\default\default.p3d"
		};
		noDetailDist=50;
		fullDetailDist=20;
		soundMapSizeCoef=1;
		satelliteNormalBlendStart=80;
		satelliteNormalBlendEnd=100;
		satelliteNormalOnDetail=1;
		terrainBlendMaxDarkenCoef=0;
		terrainBlendMaxBrightenCoef=1;
		interpolateClutterColoring=0;
		clutterColoringFarCoef=5;
		clutterColoringFarStart="15.0f";
		clutterColoringFarSpeed="1.0f";
		clutterRoadwayCheckRadiusCoef="0.0f";
		hazeDistCoef=-1;
		hazeFogCoef=-1;
		aroundSunCoefMultiplier=1;
		aroundSunCoefExponent=4;
		horizonParallaxCoef=0.045000002;
		horizonFogColorationStart=0.80000001;
		skyFogColorationStart=0.69999999;
		skyColorInfluencesFogColor=1;
		horizonSunColorationScale=10;
		horizonSunColorationIntensity=1;
		mapDrawingBrightnessModifier="1.0f";
		seaBedUnderwaterDepth="-1.0f";
		clutterGrid=2;
		clutterDist=50;
		clutterRadius=1;
		class DefaultClutter
		{
			affectedByWind=0;
			relativeColor[]={1,1,1,1};
			scaleMin=0.5;
			scaleMax=1;
			swLighting=1;
		};
		class Clutter
		{
		};
		skyObject="core\skyobject\skyobject.p3d";
		starsObject="core\default\default.p3d";
		pointObject="core\default\default.p3d";
		horizontObject="core\default\default.p3d";
		haloObject="core\default\default.p3d";
		sunObject="core\default\default.p3d";
		rainbowObject="core\default\default.p3d";
		moonObject="core\default\default.p3d";
		waterTexture="#(argb,8,8,3)color(0.35,0.47,0.66,1)";
		underwaterOcclusionObject="";
		causticsEnabled=1;
		causticsTexture="";
		causticsTextureNumRows=4;
		causticsTextureMask="";
		causticsTextureCount=32;
		causticsTextureArea=4;
		causticsTextureAreaDeep=150;
		causticsTextureChangeInterval=0.090000004;
		causticsDistanceLimit=200;
		causticsDepthLimit=50;
		causticsDepthFadeCoef=1;
		causticsTextureDepthGranularity=3;
		causticsBrightnessCoef=4;
		dynLightMinBrightnessAmbientCoef=0.1;
		dynLightMinBrightnessAbsolute=0.001;
		envTexture="";
		satelliteMap="";
		layerMask="";
		seaMaterial="#water";
		shoreMaterial="#shore";
		shoreFoamMaterial="#shoreFoam";
		shoreWetMaterial="#shoreWet";
		terrainMaterial="#terrain";
		class AnomalyPars
		{
			outerModel="";
			innerModel="";
			refractScale[]={0.039999999,0.029999999,0.050000001};
			timeScale[]={0.029999999,0.029999999,0};
			postProcessDistance=3;
		};
		class SpriteRefractionPars
		{
			refractScale[]={0.02,0.02,0.02};
			timeScale[]={0.029999999,0.029999999,0};
		};
		class Underwater
		{
			noWaterFog=-0.30000001;
			fullWaterFog=0.1;
			deepWaterFog=10;
			waterFogDistance=20;
			waterFogDistanceNear=0;
			waterColor[]={0.02,0.079999998,0.12};
			deepWaterColor[]={0.0099999998,0.059999999,0.14};
			surfaceColor[]={0.2,0.30000001,0.25};
			deepSurfaceColor[]={0.1,0.18000001,0.22};
		};
		class SeaWaterShaderPars
		{
			refractionMoveCoef=0.0099999998;
			minWaterOpacity=0.64999998;
			waterOpacityDistCoef=0.07;
			underwaterOpacity=0.2;
			waterOpacityFadeStart=100;
			waterOpacityFadeLength=20;
		};
		class WaterExPars
		{
			fogDensity=0.039999999;
			fogColor[]={0.003,0.0049999999,0.0099999998};
			fogColorExtinctionSpeed[]={0.2,0.1,0.039999999};
			fogColorLightInfluence[]={0.60000002,0.15000001,0.5};
			fogGradientCoefs[]={0.40000001,1,1.5};
			ligtExtinctionSpeed[]={0.30000001,0.1,0.050000001};
			diffuseLigtExtinctionSpeed[]={0.30000001,0.1,0.050000001};
			ssReflectionStrength=0.85000002;
			ssReflectionMaxJitter=1;
			ssReflectionRippleInfluence=0.15000001;
			ssReflectionEdgeFadingCoef=10;
			ssReflectionDistFadingCoef=4;
			refractionMinCoef=0.02;
			refractionMaxCoef=0.07;
			refractionMaxDist=20;
			surfaceOpacity=0;
			shadowIntensity=0.5;
			specularMaxIntensity=25;
			specularPowerOvercast0=200;
			specularPowerOvercast1=50;
			specularNormalModifyCoef=1;
			foamAroundObjectsIntensity=0.25;
			foamAroundObjectsFadeCoef=8;
			foamColorCoef=2;
			foamDeformationCoef=0.02;
			foamTextureCoef=0.2;
			foamTimeMoveSpeed=0.2;
			foamTimeMoveAmount=0.1;
			shoreDarkeningMaxCoef=0.5;
			shoreDarkeningOffset=0.2;
			shoreDarkeningGradient=0.2;
			shoreWaveTimeScale=0.80000001;
			shoreWaveShifDerivativeOffset=-0.80000001;
			shoreFoamIntensity=0.5;
			shoreMaxWaveHeight=0.15000001;
			shoreWetLayerReflectionIntensity=1;
		};
		class HDRNewPars
		{
			minAperture=9.9999997e-006;
			maxAperture=256;
			apertureRatioMax=4;
			apertureRatioMin=10;
			bloomImageScale=1;
			bloomScale=0.30000001;
			bloomExponent=1;
			bloomLuminanceOffset=0.80000001;
			bloomLuminanceScale=1;
			bloomLuminanceExponent=1.2;
			tonemapMethod=2;
			tonemapShoulderStrength=0.22;
			tonemapLinearStrength=0.30000001;
			tonemapLinearAngle=0.1;
			tonemapToeStrength=0.2;
			tonemapToeNumerator=0.0099999998;
			tonemapToeDenominator=0.30000001;
			tonemapLinearWhite=11.2;
			tonemapExposureBias=2;
			tonemapLinearWhiteReinhard=2.5;
			nvgApertureMin=1;
			nvgApertureStandard=7;
			nvgApertureMax=15;
			nvgStandardAvgLum=3;
			nvgLightGain=100;
			nvgTransition=1;
			nvgTransitionCoefOn=40;
			nvgTransitionCoefOff=0.0099999998;
			nightShiftMinAperture=0;
			nightShiftMaxAperture=0.0020000001;
			nightShiftMaxEffect=0.60000002;
			nightShiftLuminanceScale=600;
			eyeAdaptFactorLight=0.60000002;
			eyeAdaptFactorDark=0.2;
		};
		class NVGPars
		{
			filmGrainEnabled=1;
			filmGrainPars[]={0.40000001,2.75,1,3,1,0};
		};
		class DOFPars
		{
			focusDistance=25;
			blur=1;
			farOnly=1;
			focusDistanceWater=1;
			blurWater=1.3;
			farOnlyWater=1;
			focusDistanceWaterGoggles=4;
			blurWaterGoggles=1;
			farOnlyWaterGoggles=1;
		};
		class LODDiagColors
		{
			defaultColor[]={1,1,1};
			lod0[]={1,0,0};
			lod1[]={0,1,0};
			lod2[]={0,0,1};
			lod3[]={1,1,0};
			lod4[]={0,1,1};
			lod5[]={1,0,1};
			terrainCoef=0.40000001;
			waterCoef=0.69999999;
			waterAlpha=0.5;
		};
		enableTracks=1;
		enableFootsteps=1;
		enableBloodSplashes=1;
		class Subdivision
		{
			class Fractal
			{
				rougness=10;
				maxRoad=0.2;
				maxTrack=1;
				maxSlopeFactor=0.050000001;
			};
			class WhiteNoise
			{
				rougness=5;
				maxRoad=0.1;
				maxTrack=0.5;
				maxSlopeFactor=0.025;
			};
			minY=-0;
			minSlope=0.02;
		};
		class Ambient
		{
		};
	};
	initWorld="";
	demoWorld="";
};
class CfgWorldList
{
	access=1;
};
class CfgGroups
{
};
class CfgAddons
{
	class PreloadBanks
	{
	};
	class PreloadAddons
	{
	};
};
class CfgEditorObjects
{
};
class CfgMPGameTypes
{
	class Unknown
	{
		name="$STR_XBOX_MPTYPE_UNKNOWN";
		shortcut="$STR_XBOX_MPTYPE_UNKNOWN_SHORT";
		statsStandard="StandardUnknown";
		statsRanked="RankedUnknown";
		id=0;
	};
	class DM
	{
		name="$STR_XBOX_MPTYPE_DM";
		shortcut="$STR_XBOX_MPTYPE_DM_SHORT";
		statsStandard="StandardDM";
		statsRanked="RankedDM";
		id=1;
	};
	class CTF
	{
		name="$STR_XBOX_MPTYPE_CTF";
		shortcut="$STR_XBOX_MPTYPE_CTF_SHORT";
		statsStandard="StandardCTF";
		statsRanked="RankedCTF";
		id=2;
	};
	class FF
	{
		name="$STR_XBOX_MPTYPE_FF";
		shortcut="$STR_XBOX_MPTYPE_FF_SHORT";
		statsStandard="StandardFF";
		statsRanked="RankedFF";
		id=3;
	};
	class Coop
	{
		name="$STR_XBOX_MPTYPE_COOP";
		shortcut="$STR_XBOX_MPTYPE_COOP_SHORT";
		statsStandard="";
		statsRanked="";
		id=4;
	};
	class Team
	{
		name="$STR_XBOX_MPTYPE_TEAM";
		shortcut="$STR_XBOX_MPTYPE_TEAM_SHORT";
		statsStandard="StandardTeam";
		statsRanked="RankedTeam";
		id=5;
	};
	class SCont
	{
		name="$STR_XBOX_MPTYPE_SCONTROL";
		shortcut="$STR_XBOX_MPTYPE_SCONTROL_SHORT";
		statsStandard="StandardSControl";
		statsRanked="RankedSControl";
		id=6;
	};
	class Hold
	{
		name="$STR_XBOX_MPTYPE_HOLDLOCATION";
		shortcut="$STR_XBOX_MPTYPE_HOLDLOCATION_SHORT";
		statsStandard="StandardHold";
		statsRanked="RankedHold";
		id=7;
	};
	class CTI
	{
		name="$STR_XBOX_MPTYPE_CTI";
		shortcut="$STR_XBOX_MPTYPE_CTI_SHORT";
		statsStandard="StandardCTI";
		statsRanked="RankedCTI";
		id=8;
	};
};
class CfgLiveStats
{
	class TrueSkill
	{
		name="TrueSkill™ rankings";
		board=-65535;
		class Columns
		{
			class Rank
			{
				id=-1;
				name="$STR_LIVE_STATS_RANK";
				width=0.1;
				format="%d.";
				align=1;
			};
			class Gamertag
			{
				id=-2;
				name="$STR_LIVE_STATS_NAME";
				width=0.5;
				format="%s";
				align=0;
			};
			class Skill
			{
				id=61;
				name="TrueSkill™ rank";
				width=0.2;
				format="%d";
				align=1;
			};
			class GamesPlayed
			{
				id=62;
				name="Games played";
				width=0.2;
				format="%d";
				align=1;
			};
		};
	};
	class StandardDM
	{
		name="Standard - Death Match";
		board=1;
		algorithm=2;
		dropouts=1;
		coefWin=10;
		coefLoose=-10;
		coefM1=1;
		coefS1=100;
		coefM2=1;
		coefS2=100;
		coefMin=0.1;
		coefMax=10;
		class Columns
		{
			class Rank
			{
				id=-1;
				name="$STR_LIVE_STATS_RANK";
				width=0.1;
				format="%d.";
				align=1;
			};
			class Gamertag
			{
				id=-2;
				name="$STR_LIVE_STATS_NAME";
				width=0.5;
				format="%s";
				align=0;
			};
			class Score
			{
				id=-3;
				name="Score";
				width=0.2;
				format="%I64d";
				align=1;
			};
			class GamesPlayed
			{
				id=1;
				name="Games played";
				width=0.2;
				format="%d";
				align=1;
			};
		};
	};
	class StandardCTF
	{
		name="Standard - Capture The Flag";
		board=2;
		algorithm=3;
		dropouts=1;
		coefWin=10;
		coefLoose=-10;
		coefM1=1;
		coefS1=100;
		coefM2=1;
		coefS2=100;
		coefMin=0.1;
		coefMax=10;
		coefAI=0.5;
		class Columns
		{
			class Rank
			{
				id=-1;
				name="$STR_LIVE_STATS_RANK";
				width=0.1;
				format="%d.";
				align=1;
			};
			class Gamertag
			{
				id=-2;
				name="$STR_LIVE_STATS_NAME";
				width=0.5;
				format="%s";
				align=0;
			};
			class Score
			{
				id=-3;
				name="Score";
				width=0.2;
				format="%I64d";
				align=1;
			};
			class GamesPlayed
			{
				id=1;
				name="Games played";
				width=0.2;
				format="%d";
				align=1;
			};
		};
	};
	class StandardFF: StandardDM
	{
		name="Standard - Flag Fight";
		board=3;
	};
	class StandardTeam: StandardCTF
	{
		name="Standard - Team Mission";
		board=4;
	};
	class StandardSControl: StandardCTF
	{
		name="Standard - Sector Control";
		board=5;
	};
	class StandardHold: StandardCTF
	{
		name="Standard - Hold Location";
		board=6;
	};
	class StandardUnknown: StandardDM
	{
		name="Standard - Unknown";
		board=7;
	};
	class RankedDM: StandardDM
	{
		name="Ranked - Death Match";
		board=8;
	};
	class RankedCTF: StandardCTF
	{
		name="Ranked - Capture The Flag";
		board=9;
	};
	class RankedFF: StandardFF
	{
		name="Ranked - Flag Fight";
		board=10;
	};
	class RankedTeam: StandardTeam
	{
		name="Ranked - Team Mission";
		board=11;
	};
	class RankedSControl: StandardSControl
	{
		name="Ranked - Sector Control";
		board=12;
	};
	class RankedHold: StandardHold
	{
		name="Ranked - Hold Location";
		board=13;
	};
	class RankedUnknown: StandardUnknown
	{
		name="Ranked - Unknown";
		board=14;
	};
};
class CfgAchievements
{
	class Quartermaster
	{
		id=1;
		name="Quartermaster";
		description="Unlock all Armory items.";
		descriptionUnachieved="Unlock all Armory items.";
		picture="#(argb,8,8,3)color(1,1,1,1)";
	};
	class Marksman
	{
		id=2;
		name="Marksman";
		description="Complete the Firing Range with 100% accuracy and at least 20 shots fired.";
		descriptionUnachieved="Complete the Firing Range with 100% accuracy and at least 20 shots fired.";
		picture="#(argb,8,8,3)color(1,1,1,1)";
	};
	class Speedfreak
	{
		id=3;
		name="Speedfreak";
		description="Complete the Mobility Range in under 1:00.";
		descriptionUnachieved="Complete the Mobility Range in under 1:00.";
		picture="#(argb,8,8,3)color(1,1,1,1)";
	};
	class SkyHigh
	{
		id=4;
		name="Sky High";
		description="Get to 2000 meters altitude.";
		descriptionUnachieved="Get to 2000 meters altitude.";
		picture="#(argb,8,8,3)color(1,1,1,1)";
	};
	class Hunter
	{
		id=5;
		name="Hunter";
		description="Shoot down 100 seagulls.";
		descriptionUnachieved="Shoot down 100 seagulls.";
		picture="#(argb,8,8,3)color(1,1,1,1)";
	};
};
class CfgVoiceMask
{
	class None
	{
		name="$STR_VOICE_MASK_NONE";
		specEnergyWeight=-1;
		pitchScale=-1;
		whisperValue=-1;
		roboticValue=-1;
	};
	class Anonymous
	{
		name="$STR_VOICE_MASK_ANONYMOUS";
		specEnergyWeight=0.94999999;
		pitchScale=0.5;
		whisperValue=0.34999999;
		roboticValue=-1;
	};
	class Cartoon
	{
		name="$STR_VOICE_MASK_CARTOON";
		specEnergyWeight=0.1;
		pitchScale=-1;
		whisperValue=-1;
		roboticValue=-1;
	};
	class BigGuy
	{
		name="$STR_VOICE_MASK_BIGGUY";
		specEnergyWeight=0.89999998;
		pitchScale=0.050000001;
		whisperValue=-1;
		roboticValue=-1;
	};
	class Child
	{
		name="$STR_VOICE_MASK_CHILD";
		specEnergyWeight=0.1;
		pitchScale=0.69999999;
		whisperValue=-1;
		roboticValue=-1;
	};
	class Robot
	{
		name="$STR_VOICE_MASK_ROBOT";
		specEnergyWeight=0.5;
		pitchScale=-1;
		whisperValue=-1;
		roboticValue=0.050000001;
	};
	class DarkMaster
	{
		name="$STR_VOICE_MASK_DARKMASTER";
		specEnergyWeight=1;
		pitchScale=0;
		whisperValue=-1;
		roboticValue=-1;
	};
	class Whisper
	{
		name="$STR_VOICE_MASK_WHISPER";
		specEnergyWeight=0.5;
		pitchScale=-1;
		whisperValue=0.0099999998;
		roboticValue=-1;
	};
};
class CfgRumble
{
	coefEngineToLeft="1.5*0.9";
	coefEngineToRight="1.2*0.9";
	coefSurfaceToLeft=0.25;
	coefSurfaceToRight=0.44999999;
	coefWeaponToLeft=4;
	coefWeaponToRight=4;
};
class ButtonDeadZonesDefault
{
	deadZone_A[]={64,48};
	deadZone_B[]={64,48};
	deadZone_X[]={64,48};
	deadZone_Y[]={64,48};
	deadZone_Up[]={64,48};
	deadZone_Down[]={64,48};
	deadZone_Left[]={64,48};
	deadZone_Right[]={64,48};
	deadZone_Start[]={64,48};
	deadZone_Back[]={64,48};
	deadZone_LeftBumper[]={64,48};
	deadZone_RightBumper[]={64,48};
	deadZone_LeftThumb[]={64,48};
	deadZone_RightThumb[]={64,48};
};
class ControllerTypes
{
	class Gamepad
	{
		resource="RscDisplayProfileController";
		hint="$STR_XBOX_GAMEPAD";
		imageRightA=0;
		imageRightB=0;
		imageRightY=0;
		imageRightX=0;
		imageRightWhite=0;
		imageRightBlack=0;
		imageRightLeft=1;
		imageRightRight=1;
		imageRightUp=1;
		imageRightDown=1;
		imageRightBack=1;
		imageRightStart=1;
	};
	class Joystick
	{
		resource="RscDisplayProfileControllerJoystick";
		hint="$STR_XBOX_JOYSTICK";
		imageRightA=0;
		imageRightB=0;
		imageRightY=1;
		imageRightX=1;
		imageRightWhite=1;
		imageRightBlack=1;
		imageRightLeft=1;
		imageRightRight=1;
		imageRightUp=1;
		imageRightDown=1;
		imageRightBack=0;
		imageRightStart=0;
	};
	class Wheel
	{
		resource="RscDisplayProfileControllerWheel";
		hint="$STR_XBOX_WHEEL";
		imageRightA=0;
		imageRightB=0;
		imageRightY=0;
		imageRightX=0;
		imageRightWhite=0;
		imageRightBlack=0;
		imageRightLeft=1;
		imageRightRight=1;
		imageRightUp=1;
		imageRightDown=1;
		imageRightBack=1;
		imageRightStart=1;
	};
};
class ControllerSchemes
{
	defaultScheme="Default";
	defaultSchemeMovementLeftBrakeTriggerAccTrigger="Default";
	defaultSchemeMovementLeftBrakeTriggerAccButton="Default";
	defaultSchemeMovementLeftBrakeButtonAccTrigger="Default";
	defaultSchemeMovementLeftBrakeButtonAccButton="Default";
	defaultSchemeMovementRightBrakeTriggerAccTrigger="Default";
	defaultSchemeMovementRightBrakeTriggerAccButton="Default";
	defaultSchemeMovementRightBrakeButtonAccTrigger="Default";
	defaultSchemeMovementRightBrakeButtonAccButton="Default";
	class Default
	{
		name="$STR_XBOX_CONTROLER_SCHEME_DEFAULT";
		class Gamepad
		{
			class ButtonDeadZones: ButtonDeadZonesDefault
			{
				deadZone_LeftTrigger[]={192,128};
				deadZone_RightTrigger[]={80,64};
			};
			class ThumbStickDeadZones
			{
				leftX=0.20999999;
				leftY=0.23;
				rightX=0.20999999;
				rightY=0.23;
			};
			class Actions
			{
				ToggleWeapons[]=
				{
					"0x00050000 + 3"
				};
				DefaultAction[]=
				{
					"0x00050000 + 13"
				};
				ReloadMagazine[]=
				{
					"0x00050000 + 2"
				};
				LockTarget[]={};
				RevealTarget[]=
				{
					"0x00050000 + 12"
				};
				VehLockTargets[]=
				{
					"0x00050000 + 14"
				};
				PrevAction[]=
				{
					"0x00050000 + 4"
				};
				NextAction[]=
				{
					"0x00050000 + 5"
				};
				Action[]=
				{
					"0x00050000 + 0"
				};
				MenuSelect[]=
				{
					"0x00050000 + 7"
				};
				navigateMenu[]=
				{
					"0x00050000 + 6"
				};
				CancelAction[]=
				{
					"0x00050000 + 2"
				};
				ForceCommandingMode[]=
				{
					"0x00050000 + 10"
				};
				Compass[]={};
				Diary[]={};
				ShowMap[]=
				{
					"0x00050000 + 11"
				};
				HideMap[]={};
				ZoomContIn[]=
				{
					"0x00050000 + 12"
				};
				PersonView[]=
				{
					"0x00050000 + 9"
				};
				IngamePause[]=
				{
					"0x00050000 + 8"
				};
				Optics[]=
				{
					"0x00050000 + 15"
				};
				class CommandLeft
				{
					keys[]=
					{
						"0x00050000 + 20"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						2,
						3
					};
					curveMedium[]=
					{
						"Gamma",
						2,
						3
					};
					curveHigh[]=
					{
						"Gamma",
						2,
						3
					};
				};
				class CommandRight
				{
					keys[]=
					{
						"0x00050000 + 16"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						2,
						3
					};
					curveMedium[]=
					{
						"Gamma",
						2,
						3
					};
					curveHigh[]=
					{
						"Gamma",
						2,
						3
					};
				};
				class CommandForward
				{
					keys[]=
					{
						"0x00050000 + 17"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveMedium[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveHigh[]=
					{
						"Gamma",
						1,
						1.5
					};
				};
				class CommandBack
				{
					keys[]=
					{
						"0x00050000 + 21"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveMedium[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveHigh[]=
					{
						"Gamma",
						1,
						1.5
					};
				};
				CommandFast[]={};
				CommandSlow[]={};
			};
		};
		class Joystick
		{
			class ButtonDeadZones: ButtonDeadZonesDefault
			{
				deadZone_LeftTrigger[]={192,128};
				deadZone_RightTrigger[]={80,64};
			};
			class ThumbStickDeadZones
			{
				leftX=0.20999999;
				leftY=0.23;
				rightX=0.20999999;
				rightY=0.23;
			};
			class Actions
			{
				ToggleWeapons[]=
				{
					"0x00050000 + 3"
				};
				DefaultAction[]=
				{
					"0x00050000 + 0"
				};
				ReloadMagazine[]=
				{
					"0x00050000 + 2"
				};
				LookAround[]=
				{
					"0x00050000 + 15"
				};
				LockTarget[]={};
				RevealTarget[]=
				{
					"0x00050000 + 15"
				};
				VehLockTargets[]=
				{
					"0x00050000 + 11"
				};
				PrevAction[]=
				{
					"0x00050000 + 4"
				};
				NextAction[]=
				{
					"0x00050000 + 5"
				};
				Action[]=
				{
					"0x00050000 + 14"
				};
				MenuSelect[]=
				{
					"0x00050000 + 7"
				};
				navigateMenu[]=
				{
					"0x00050000 + 6"
				};
				CancelAction[]=
				{
					"0x00050000 + 2"
				};
				Compass[]={};
				Diary[]=
				{
					"0x00050000 + 11"
				};
				ShowMap[]={};
				HideMap[]={};
				ZoomContIn[]=
				{
					"0x00050000 + 15"
				};
				PersonView[]=
				{
					"0x00050000 + 9"
				};
				IngamePause[]=
				{
					"0x00050000 + 8"
				};
				Optics[]={};
				class CommandLeft
				{
					keys[]=
					{
						"0x00050000 + 22"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						2,
						3
					};
					curveMedium[]=
					{
						"Gamma",
						2,
						3
					};
					curveHigh[]=
					{
						"Gamma",
						2,
						3
					};
				};
				class CommandRight
				{
					keys[]=
					{
						"0x00050000 + 18"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						2,
						3
					};
					curveMedium[]=
					{
						"Gamma",
						2,
						3
					};
					curveHigh[]=
					{
						"Gamma",
						2,
						3
					};
				};
				class CommandForward
				{
					keys[]=
					{
						"0x00050000 + 13"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveMedium[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveHigh[]=
					{
						"Gamma",
						1,
						1.5
					};
				};
				class CommandBack
				{
					keys[]=
					{
						"0x00050000 + 12"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveMedium[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveHigh[]=
					{
						"Gamma",
						1,
						1.5
					};
				};
				CommandFast[]={};
				CommandSlow[]={};
			};
		};
		class Wheel
		{
			class ButtonDeadZones: ButtonDeadZonesDefault
			{
				deadZone_LeftTrigger[]={192,128};
				deadZone_RightTrigger[]={80,64};
			};
			class ThumbStickDeadZones
			{
				leftX=0.20999999;
				leftY=0.23;
				rightX=0.20999999;
				rightY=0.23;
			};
			class Actions
			{
				ToggleWeapons[]=
				{
					"0x00050000 + 3"
				};
				DefaultAction[]=
				{
					"0x00050000 + 10"
				};
				ReloadMagazine[]=
				{
					"0x00050000 + 2"
				};
				LookAround[]=
				{
					"0x00050000 + 11"
				};
				LockTarget[]={};
				RevealTarget[]=
				{
					"0x00050000 + 12"
				};
				VehLockTargets[]={};
				PrevAction[]=
				{
					"0x00050000 + 4"
				};
				NextAction[]=
				{
					"0x00050000 + 5"
				};
				Action[]=
				{
					"0x00050000 + 0"
				};
				MenuSelect[]=
				{
					"0x00050000 + 7"
				};
				navigateMenu[]=
				{
					"0x00050000 + 6"
				};
				CancelAction[]=
				{
					"0x00050000 + 2"
				};
				Compass[]={};
				Diary[]=
				{
					"0x00050000 + 11"
				};
				ShowMap[]={};
				HideMap[]={};
				ZoomContIn[]=
				{
					"0x00050000 + 11"
				};
				PersonView[]=
				{
					"0x00050000 + 9"
				};
				Optics[]={};
				IngamePause[]=
				{
					"0x00050000 + 8"
				};
				class CommandLeft
				{
					keys[]=
					{
						"0x00050000 + 20"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						2,
						3
					};
					curveMedium[]=
					{
						"Gamma",
						2,
						3
					};
					curveHigh[]=
					{
						"Gamma",
						2,
						3
					};
				};
				class CommandRight
				{
					keys[]=
					{
						"0x00050000 + 16"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						2,
						3
					};
					curveMedium[]=
					{
						"Gamma",
						2,
						3
					};
					curveHigh[]=
					{
						"Gamma",
						2,
						3
					};
				};
				class CommandForward
				{
					keys[]=
					{
						"0x00050000 + 17"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveMedium[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveHigh[]=
					{
						"Gamma",
						1,
						1.5
					};
				};
				class CommandBack
				{
					keys[]=
					{
						"0x00050000 + 21"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveMedium[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveHigh[]=
					{
						"Gamma",
						1,
						1.5
					};
				};
				CommandFast[]={};
				CommandSlow[]={};
			};
		};
		class Vehicles
		{
			class Characters
			{
				name="$STR_XBOX_CONTROLER_CHARACTERS";
				axisY=0;
				class Gamepad
				{
					textDPad="$STR_XBOX_CONTROLER_DP_MENU";
					textLThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textLThumbUD="$STR_XBOX_CONTROLER_LS_MOVE";
					textLThumbLR="$STR_XBOX_CONTROLER_LS_STRAFE";
					textLThumbPS="$STR_XBOX_CONTROLER_LS_UP";
					textRThumb="$STR_XBOX_CONTROLER_AIM";
					textRThumbUD="$STR_XBOX_CONTROLER_RS_UD_AIM";
					textRThumbLR="$STR_XBOX_CONTROLER_RS_LR_AIM";
					textRThumbPS="$STR_XBOX_CONTROLER_RS_OPTICS";
					class Actions
					{
						class MoveBack
						{
							keys[]=
							{
								"0x00050000 + 21"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								4
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								4
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								4
							};
						};
						class MoveFastForward
						{
							keys[]=
							{
								"0x00050000 + 17"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								4
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								4
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								4
							};
						};
						class TurnLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								2
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								2
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								2
							};
						};
						class TurnRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								2
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								2
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								2
							};
						};
						MoveUp[]=
						{
							"0x00050000 + 14"
						};
						MoveDown[]=
						{
							"0x00050000 + 1"
						};
						class AimUp
						{
							actionNameYAxis="AimDown";
							keys[]=
							{
								"0x00050000 + 19"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
						};
						class AimDown
						{
							actionNameYAxis="AimUp";
							keys[]=
							{
								"0x00050000 + 23"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
						};
						class AimLeft
						{
							keys[]=
							{
								"0x00050000 + 22"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
						};
						class AimRight
						{
							keys[]=
							{
								"0x00050000 + 18"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
						};
						class AimHeadUp
						{
							actionNameYAxis="AimHeadDown";
							keys[]=
							{
								"0x00050000 + 19"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								6,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								6,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								6,
								3
							};
						};
						class AimHeadDown
						{
							actionNameYAxis="AimHeadUp";
							keys[]=
							{
								"0x00050000 + 23"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								6,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								6,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								6,
								3
							};
						};
						class AimHeadLeft
						{
							keys[]=
							{
								"0x00050000 + 22"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
						class AimHeadRight
						{
							keys[]=
							{
								"0x00050000 + 18"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
					};
				};
				class Joystick
				{
					textDPad="$STR_XBOX_CONTROLER_DP_MENU";
					textLThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textLThumbUD="$STR_XBOX_CONTROLER_LS_MOVE";
					textLThumbLR="$STR_XBOX_CONTROLER_RS_STRAFE";
					textLThumbPS="$STR_XBOX_CONTROLER_RS_KNEEL";
					textRThumb="$STR_XBOX_CONTROLER_AIM";
					textRThumbUD="$STR_XBOX_CONTROLER_RS_UD_AIM";
					textRThumbLR="$STR_XBOX_CONTROLER_RS_LR_AIM";
					textRThumbPS="$STR_XBOX_CONTROLER_LS_ZOOM";
					class Actions
					{
						class MoveBack
						{
							keys[]=
							{
								"0x00050000 + 12"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								4
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								4
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								4
							};
						};
						class MoveFastForward
						{
							keys[]=
							{
								"0x00050000 + 13"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								4
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								4
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								4
							};
						};
						class TurnLeft
						{
							keys[]=
							{
								"0x00050000 + 22"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								2
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								2
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								2
							};
						};
						class TurnRight
						{
							keys[]=
							{
								"0x00050000 + 18"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								2
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								2
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								2
							};
						};
						MoveUp[]={};
						MoveDown[]=
						{
							"0x00050000 + 1"
						};
						class AimUp
						{
							actionNameYAxis="AimDown";
							keys[]=
							{
								"0x00050000 + 17"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
						};
						class AimDown
						{
							actionNameYAxis="AimUp";
							keys[]=
							{
								"0x00050000 + 21"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
						};
						class AimLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
						};
						class AimRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
						};
						class AimHeadUp
						{
							actionNameYAxis="AimHeadDown";
							keys[]=
							{
								"0x00050000 + 17"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								6,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								6,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								6,
								3
							};
						};
						class AimHeadDown
						{
							actionNameYAxis="AimHeadUp";
							keys[]=
							{
								"0x00050000 + 21"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								6,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								6,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								6,
								3
							};
						};
						class AimHeadLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
						class AimHeadRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
					};
				};
				class Wheel
				{
					textDPad="$STR_XBOX_CONTROLER_DP_MENU";
					textLThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textLThumbUD="$STR_XBOX_CONTROLER_LS_MOVE";
					textLThumbLR="$STR_XBOX_CONTROLER_LS_STRAFE";
					textLThumbPS="";
					textRThumb="";
					textRThumbLR="";
					textRThumbUD="";
					textRThumbPS="";
					class Actions
					{
						class MoveBack
						{
							keys[]=
							{
								"0x00050000 + 12"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								4
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								4
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								4
							};
						};
						class MoveFastForward
						{
							keys[]=
							{
								"0x00050000 + 13"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								4
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								4
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								4
							};
						};
						class TurnLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1.5,
								4
							};
							curveMedium[]=
							{
								"Gamma",
								1.5,
								4
							};
							curveHigh[]=
							{
								"Gamma",
								1.5,
								4
							};
						};
						class TurnRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1.5,
								4
							};
							curveMedium[]=
							{
								"Gamma",
								1.5,
								4
							};
							curveHigh[]=
							{
								"Gamma",
								1.5,
								4
							};
						};
						MoveUp[]={};
						MoveDown[]={};
						AimUp[]={};
						AimDown[]={};
						AimLeft[]={};
						AimRight[]={};
						AimHeadUp[]={};
						AimHeadDown[]={};
						class AimHeadLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
						class AimHeadRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
					};
				};
			};
			class Ground
			{
				name="$STR_XBOX_CONTROLER_VEHICLE_GROUND";
				axisY=0;
				class Gamepad
				{
					textDPad="$STR_XBOX_CONTROLER_DP_MENU";
					textLThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textLThumbUD="$STR_XBOX_CONTROLER_LS_MOVE";
					textLThumbLR="";
					textLThumbPS="";
					textRThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textRThumbUD="";
					textRThumbLR="$STR_XBOX_CONTROLER_RS_TURN";
					textRThumbPS="";
					class Actions
					{
						class CarLeft
						{
							keys[]=
							{
								"0x00050000 + 22"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								2,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								2,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								2,
								3
							};
						};
						class CarRight
						{
							keys[]=
							{
								"0x00050000 + 18"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								2,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								2,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								2,
								3
							};
						};
						CarForward[]={};
						class CarBack
						{
							keys[]=
							{
								"0x00050000 + 21"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class CarFastForward
						{
							keys[]=
							{
								"0x00050000 + 17"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						CarSlowForward[]={};
						class CarAimUp
						{
							actionNameYAxis="CarAimDown";
							keys[]=
							{
								"0x00050000 + 19"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
						};
						class CarAimDown
						{
							actionNameYAxis="CarAimUp";
							keys[]=
							{
								"0x00050000 + 23"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
						};
						class CarAimLeft
						{
							keys[]=
							{
								"0x00050000 + 22"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
						};
						class CarAimRight
						{
							keys[]=
							{
								"0x00050000 + 18"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
						};
						class AimHeadUp
						{
							actionNameYAxis="AimHeadDown";
							keys[]=
							{
								"0x00050000 + 19"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								6,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								6,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								6,
								3
							};
						};
						class AimHeadDown
						{
							actionNameYAxis="AimHeadUp";
							keys[]=
							{
								"0x00050000 + 23"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								6,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								6,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								6,
								3
							};
						};
						class AimHeadLeft
						{
							keys[]=
							{
								"0x00050000 + 22"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
						class AimHeadRight
						{
							keys[]=
							{
								"0x00050000 + 18"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
						SwapGunner[]=
						{
							"0x00050000 + 1"
						};
					};
				};
				class Joystick
				{
					textDPad="$STR_XBOX_CONTROLER_DP_MENU";
					textLThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textLThumbUD="$STR_XBOX_CONTROLER_LS_MOVE";
					textLThumbLR="";
					textLThumbPS="";
					textRThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textRThumbUD="";
					textRThumbLR="$STR_XBOX_CONTROLER_RS_TURN";
					textRThumbPS="";
					class Actions
					{
						class CarLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								2,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								2,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								2,
								3
							};
						};
						class CarRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								2,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								2,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								2,
								3
							};
						};
						CarForward[]={};
						class CarBack
						{
							keys[]=
							{
								"0x00050000 + 12"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class CarFastForward
						{
							keys[]=
							{
								"0x00050000 + 13"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						CarSlowForward[]={};
						class CarAimUp
						{
							actionNameYAxis="CarAimDown";
							keys[]=
							{
								"0x00050000 + 17"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
						};
						class CarAimDown
						{
							actionNameYAxis="CarAimUp";
							keys[]=
							{
								"0x00050000 + 21"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
						};
						class CarAimLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
						};
						class CarAimRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
						};
						SwapGunner[]=
						{
							"0x00050000 + 1"
						};
					};
				};
				class Wheel
				{
					textDPad="$STR_XBOX_CONTROLER_DP_MENU";
					textLThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textLThumbLR="$STR_XBOX_CONTROLER_LS_STRAFE";
					textLThumbUD="$STR_XBOX_CONTROLER_LS_MOVE";
					textLThumbPS="";
					textRThumb="";
					textRThumbLR="";
					textRThumbUD="";
					textRThumbPS="";
					class Actions
					{
						class CarLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								2,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								2,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								2,
								3
							};
						};
						class CarRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								2,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								2,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								2,
								3
							};
						};
						CarForward[]={};
						class CarBack
						{
							keys[]=
							{
								"0x00050000 + 12"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class CarFastForward
						{
							keys[]=
							{
								"0x00050000 + 13"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						CarSlowForward[]={};
						CarAimUp[]={};
						CarAimDown[]={};
						class CarAimLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
						class CarAimRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
						SwapGunner[]=
						{
							"0x00050000 + 0"
						};
					};
				};
			};
			class Aircraft
			{
				name="$STR_XBOX_CONTROLER_AIR";
				axisY=1;
				class Gamepad
				{
					textDPad="$STR_XBOX_CONTROLER_DP_MENU";
					textLThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textLThumbUD="$STR_XBOX_CONTROLER_LS_FLY";
					textLThumbLR="$STR_XBOX_CONTROLER_LS_RUDDER";
					textLThumbPS="$STR_XBOX_CONTROLER_LS_LOCK";
					textRThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textRThumbUD="$STR_XBOX_CONTROLER_RS_TILT_MOVE";
					textRThumbLR="$STR_XBOX_CONTROLER_RS_TILT";
					textRThumbPS="";
					class Actions
					{
						class HeliCyclicBack
						{
							actionNameYAxis="HeliCyclicForward";
							keys[]=
							{
								"0x00050000 + 17"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliCyclicForward
						{
							actionNameYAxis="HeliCyclicBack";
							keys[]=
							{
								"0x00050000 + 21"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliCyclicLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliCyclicRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliRudderLeft
						{
							keys[]=
							{
								"0x00050000 + 12"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliRudderRight
						{
							keys[]=
							{
								"0x00050000 + 13"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliCollectiveRaise
						{
							keys[]=
							{
								"0x00050000 + 11"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliCollectiveLower
						{
							keys[]=
							{
								"0x00050000 + 10"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						HeliBack[]={};
						HeliFastForward[]={};
						HeliForward[]={};
						class SeagullUp
						{
							keys[]=
							{
								"0x00050000 + 17"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class SeagullDown
						{
							keys[]=
							{
								"0x00050000 + 21"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class SeagullBack
						{
							actionNameYAxis="SeagullFastForward";
							keys[]=
							{
								"0x00050000 + 19"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class SeagullFastForward
						{
							actionNameYAxis="SeagullBack";
							keys[]=
							{
								"0x00050000 + 23"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class AimHeadUp
						{
							actionNameYAxis="AimHeadDown";
							keys[]=
							{
								"0x00050000 + 19"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								6,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								6,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								6,
								3
							};
						};
						class AimHeadDown
						{
							actionNameYAxis="AimHeadUp";
							keys[]=
							{
								"0x00050000 + 23"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								6,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								6,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								6,
								3
							};
						};
						class AimHeadLeft
						{
							keys[]=
							{
								"0x00050000 + 22"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
						class AimHeadRight
						{
							keys[]=
							{
								"0x00050000 + 18"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
						class AimDown
						{
							actionNameYAxis="AimUp";
							keys[]=
							{
								"0x00050000 + 19"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								6,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								6,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								6,
								3
							};
						};
						class AimUp
						{
							actionNameYAxis="AimDown";
							keys[]=
							{
								"0x00050000 + 23"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								6,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								6,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								6,
								3
							};
						};
						class AimLeft
						{
							keys[]=
							{
								"0x00050000 + 22"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
						class AimRight
						{
							keys[]=
							{
								"0x00050000 + 18"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
						SeagullForward[]={};
						HeliManualFire[]=
						{
							"0x00050000 + 1"
						};
						Diary[]={};
						ZoomContIn[]={};
						LookAround[]={};
						ForceCommandingMode[]={};
						ShowMap[]={};
						keyLookCenter[]=
						{
							"0x00050000 + 15"
						};
						AutoHover[]=
						{
							"0x00050000 + 2"
						};
						AutoHoverCancel[]=
						{
							"0x00050000 + 2"
						};
						LookAroundToggle[]=
						{
							"0x00050000 + 1"
						};
					};
				};
				class Joystick
				{
					textDPad="$STR_XBOX_CONTROLER_DP_MENU";
					textLThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textLThumbUD="$STR_XBOX_CONTROLER_LS_FLY";
					textLThumbLR="$STR_XBOX_CONTROLER_LS_RUDDER";
					textLThumbPS="$STR_XBOX_CONTROLER_LS_LOCK";
					textRThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textRThumbUD="$STR_XBOX_CONTROLER_RS_TILT_MOVE";
					textRThumbLR="$STR_XBOX_CONTROLER_RS_TILT";
					textRThumbPS="";
					class Actions
					{
						class HeliUp
						{
							keys[]=
							{
								"0x00050000 + 13"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliDown
						{
							keys[]=
							{
								"0x00050000 + 12"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliCyclicLeft
						{
							keys[]=
							{
								"0x00050000 + 22"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliCyclicRight
						{
							keys[]=
							{
								"0x00050000 + 18"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliRudderLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliRudderRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliBack
						{
							actionNameYAxis="HeliFastForward";
							keys[]=
							{
								"0x00050000 + 17"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliFastForward
						{
							actionNameYAxis="HeliBack";
							keys[]=
							{
								"0x00050000 + 21"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						HeliForward[]={};
						HeliManualFire[]=
						{
							"0x00050000 + 1"
						};
						class SeagullUp
						{
							keys[]=
							{
								"0x00050000 + 13"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class SeagullDown
						{
							keys[]=
							{
								"0x00050000 + 12"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class SeagullBack
						{
							actionNameYAxis="SeagullFastForward";
							keys[]=
							{
								"0x00050000 + 17"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class SeagullFastForward
						{
							actionNameYAxis="SeagullBack";
							keys[]=
							{
								"0x00050000 + 21"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						SeagullForward[]={};
					};
				};
				class Wheel
				{
					textDPad="$STR_XBOX_CONTROLER_DP_MENU";
					textLThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textLThumbLR="$STR_XBOX_CONTROLER_LS_TURN";
					textLThumbUD="";
					textLThumbPS="";
					textRThumb="";
					textRThumbLR="";
					textRThumbUD="";
					textRThumbPS="";
					class Actions
					{
						HeliUp[]={};
						HeliDown[]={};
						HeliCyclicLeft[]={};
						HeliCyclicRight[]={};
						class HeliRudderLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliRudderRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliBack
						{
							actionNameYAxis="HeliFastForward";
							keys[]=
							{
								"0x00050000 + 12"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliFastForward
						{
							actionNameYAxis="HeliBack";
							keys[]=
							{
								"0x00050000 + 13"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						HeliForward[]={};
						HeliManualFire[]=
						{
							"0x00050000 + 0"
						};
						SeagullUp[]={};
						SeagullDown[]={};
						class SeagullBack
						{
							actionNameYAxis="SeagullFastForward";
							keys[]=
							{
								"0x00050000 + 12"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class SeagullFastForward
						{
							actionNameYAxis="SeagullBack";
							keys[]=
							{
								"0x00050000 + 13"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						SeagullForward[]={};
					};
				};
			};
		};
	};
	class LeftHanded: Default
	{
		name="Left Handed";
		class Gamepad
		{
			class ButtonDeadZones: ButtonDeadZonesDefault
			{
				deadZone_LeftTrigger[]={192,128};
				deadZone_RightTrigger[]={80,64};
			};
			class ThumbStickDeadZones
			{
				leftX=0.20999999;
				leftY=0.23;
				rightX=0.20999999;
				rightY=0.23;
			};
			class Actions
			{
				ToggleWeapons[]=
				{
					"0x00050000 + 3"
				};
				DefaultAction[]=
				{
					"0x00050000 + 12"
				};
				ReloadMagazine[]=
				{
					"0x00050000 + 2"
				};
				LookAround[]=
				{
					"0x00050000 + 13"
				};
				LockTarget[]={};
				RevealTarget[]=
				{
					"0x00050000 + 13"
				};
				VehLockTargets[]=
				{
					"0x00050000 + 15"
				};
				PrevAction[]=
				{
					"0x00050000 + 4"
				};
				NextAction[]=
				{
					"0x00050000 + 5"
				};
				Action[]=
				{
					"0x00050000 + 0"
				};
				MenuSelect[]=
				{
					"0x00050000 + 7"
				};
				navigateMenu[]=
				{
					"0x00050000 + 6"
				};
				CancelAction[]=
				{
					"0x00050000 + 2"
				};
				ForceCommandingMode[]=
				{
					"0x00050000 + 11"
				};
				Compass[]={};
				Diary[]=
				{
					"0x00050000 + 11"
				};
				ShowMap[]={};
				HideMap[]={};
				ZoomContIn[]=
				{
					"0x00050000 + 13"
				};
				PersonView[]=
				{
					"0x00050000 + 9"
				};
				IngamePause[]=
				{
					"0x00050000 + 8"
				};
				Optics[]=
				{
					"0x00050000 + 14"
				};
				class CommandLeft
				{
					keys[]=
					{
						"0x00050000 + 22"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						2,
						3
					};
					curveMedium[]=
					{
						"Gamma",
						2,
						3
					};
					curveHigh[]=
					{
						"Gamma",
						2,
						3
					};
				};
				class CommandRight
				{
					keys[]=
					{
						"0x00050000 + 18"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						2,
						3
					};
					curveMedium[]=
					{
						"Gamma",
						2,
						3
					};
					curveHigh[]=
					{
						"Gamma",
						2,
						3
					};
				};
				class CommandForward
				{
					keys[]=
					{
						"0x00050000 + 19"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveMedium[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveHigh[]=
					{
						"Gamma",
						1,
						1.5
					};
				};
				class CommandBack
				{
					keys[]=
					{
						"0x00050000 + 23"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveMedium[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveHigh[]=
					{
						"Gamma",
						1,
						1.5
					};
				};
				CommandFast[]={};
				CommandSlow[]={};
			};
		};
		class Joystick
		{
			class ButtonDeadZones: ButtonDeadZonesDefault
			{
				deadZone_LeftTrigger[]={192,128};
				deadZone_RightTrigger[]={80,64};
			};
			class ThumbStickDeadZones
			{
				leftX=0.20999999;
				leftY=0.23;
				rightX=0.20999999;
				rightY=0.23;
			};
			class Actions
			{
				ToggleWeapons[]=
				{
					"0x00050000 + 3"
				};
				DefaultAction[]=
				{
					"0x00050000 + 3"
				};
				ReloadMagazine[]=
				{
					"0x00050000 + 2"
				};
				LookAround[]=
				{
					"0x00050000 + 12"
				};
				LockTarget[]={};
				RevealTarget[]={};
				VehLockTargets[]={};
				PrevAction[]=
				{
					"0x00050000 + 4"
				};
				NextAction[]=
				{
					"0x00050000 + 5"
				};
				Action[]=
				{
					"0x00050000 + 0"
				};
				MenuSelect[]=
				{
					"0x00050000 + 7"
				};
				navigateMenu[]=
				{
					"0x00050000 + 6"
				};
				CancelAction[]=
				{
					"0x00050000 + 2"
				};
				Compass[]={};
				Diary[]=
				{
					"0x00050000 + 11"
				};
				ShowMap[]={};
				HideMap[]={};
				ZoomContIn[]={};
				PersonView[]=
				{
					"0x00050000 + 9"
				};
				Optics[]=
				{
					"0x00050000 + 10"
				};
				IngamePause[]=
				{
					"0x00050000 + 8"
				};
				class CommandLeft
				{
					keys[]=
					{
						"0x00050000 + 20"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						2,
						3
					};
					curveMedium[]=
					{
						"Gamma",
						2,
						3
					};
					curveHigh[]=
					{
						"Gamma",
						2,
						3
					};
				};
				class CommandRight
				{
					keys[]=
					{
						"0x00050000 + 16"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						2,
						3
					};
					curveMedium[]=
					{
						"Gamma",
						2,
						3
					};
					curveHigh[]=
					{
						"Gamma",
						2,
						3
					};
				};
				class CommandForward
				{
					keys[]=
					{
						"0x00050000 + 17"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveMedium[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveHigh[]=
					{
						"Gamma",
						1,
						1.5
					};
				};
				class CommandBack
				{
					keys[]=
					{
						"0x00050000 + 21"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveMedium[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveHigh[]=
					{
						"Gamma",
						1,
						1.5
					};
				};
				CommandFast[]={};
				CommandSlow[]={};
			};
		};
		class Wheel
		{
			class ButtonDeadZones: ButtonDeadZonesDefault
			{
				deadZone_LeftTrigger[]={192,128};
				deadZone_RightTrigger[]={80,64};
			};
			class ThumbStickDeadZones
			{
				leftX=0.20999999;
				leftY=0.23;
				rightX=0.20999999;
				rightY=0.23;
			};
			class Actions
			{
				ToggleWeapons[]=
				{
					"0x00050000 + 3"
				};
				DefaultAction[]=
				{
					"0x00050000 + 10"
				};
				ReloadMagazine[]=
				{
					"0x00050000 + 2"
				};
				LookAround[]=
				{
					"0x00050000 + 11"
				};
				LockTarget[]={};
				RevealTarget[]=
				{
					"0x00050000 + 12"
				};
				VehLockTargets[]={};
				PrevAction[]=
				{
					"0x00050000 + 4"
				};
				NextAction[]=
				{
					"0x00050000 + 5"
				};
				Action[]=
				{
					"0x00050000 + 0"
				};
				MenuSelect[]=
				{
					"0x00050000 + 7"
				};
				navigateMenu[]=
				{
					"0x00050000 + 6"
				};
				CancelAction[]=
				{
					"0x00050000 + 2"
				};
				Compass[]={};
				Diary[]=
				{
					"0x00050000 + 11"
				};
				ShowMap[]={};
				HideMap[]={};
				ZoomContIn[]=
				{
					"0x00050000 + 11"
				};
				PersonView[]=
				{
					"0x00050000 + 9"
				};
				Optics[]={};
				IngamePause[]=
				{
					"0x00050000 + 8"
				};
				class CommandLeft
				{
					keys[]=
					{
						"0x00050000 + 20"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						2,
						3
					};
					curveMedium[]=
					{
						"Gamma",
						2,
						3
					};
					curveHigh[]=
					{
						"Gamma",
						2,
						3
					};
				};
				class CommandRight
				{
					keys[]=
					{
						"0x00050000 + 16"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						2,
						3
					};
					curveMedium[]=
					{
						"Gamma",
						2,
						3
					};
					curveHigh[]=
					{
						"Gamma",
						2,
						3
					};
				};
				class CommandForward
				{
					keys[]=
					{
						"0x00050000 + 17"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveMedium[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveHigh[]=
					{
						"Gamma",
						1,
						1.5
					};
				};
				class CommandBack
				{
					keys[]=
					{
						"0x00050000 + 21"
					};
					deadZone=0;
					curveLow[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveMedium[]=
					{
						"Gamma",
						1,
						1.5
					};
					curveHigh[]=
					{
						"Gamma",
						1,
						1.5
					};
				};
				CommandFast[]={};
				CommandSlow[]={};
			};
		};
		class Vehicles: Vehicles
		{
			class Characters: Characters
			{
				name="characTers";
				axisY=0;
				class Gamepad
				{
					textDPad="$STR_XBOX_CONTROLER_DP_MENU";
					textLThumb="$STR_XBOX_CONTROLER_AIM";
					textLThumbLR="$STR_XBOX_CONTROLER_LS_LR_AIM";
					textLThumbUD="$STR_XBOX_CONTROLER_LS_UD_AIM";
					textLThumbPS="$STR_XBOX_CONTROLER_LS_OPTICS";
					textRThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textRThumbLR="$STR_XBOX_CONTROLER_RS_STRAFE";
					textRThumbUD="$STR_XBOX_CONTROLER_RS_MOVE";
					textRThumbPS="$STR_XBOX_CONTROLER_RS_UP";
					class Actions
					{
						class MoveBack
						{
							keys[]=
							{
								"0x00050000 + 23"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								4
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								4
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								4
							};
						};
						class MoveFastForward
						{
							keys[]=
							{
								"0x00050000 + 19"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								4
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								4
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								4
							};
						};
						class TurnLeft
						{
							keys[]=
							{
								"0x00050000 + 22"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								2
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								2
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								2
							};
						};
						class TurnRight
						{
							keys[]=
							{
								"0x00050000 + 18"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								2
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								2
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								2
							};
						};
						MoveUp[]=
						{
							"0x00050000 + 15"
						};
						MoveDown[]=
						{
							"0x00050000 + 1"
						};
						class AimUp
						{
							actionNameYAxis="AimDown";
							keys[]=
							{
								"0x00050000 + 17"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
						};
						class AimDown
						{
							actionNameYAxis="AimUp";
							keys[]=
							{
								"0x00050000 + 21"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
						};
						class AimLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
						};
						class AimRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
						};
						class AimHeadUp
						{
							actionNameYAxis="AimHeadDown";
							keys[]=
							{
								"0x00050000 + 17"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								6,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								6,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								6,
								3
							};
						};
						class AimHeadDown
						{
							actionNameYAxis="AimHeadUp";
							keys[]=
							{
								"0x00050000 + 21"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								6,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								6,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								6,
								3
							};
						};
						class AimHeadLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
						class AimHeadRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
					};
				};
				class Joystick: Joystick
				{
				};
				class Wheel: Wheel
				{
				};
			};
			class Ground: Ground
			{
				name="groUnd";
				axisY=0;
				class Gamepad
				{
					textDPad="$STR_XBOX_CONTROLER_DP_MENU";
					textLThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textLThumbLR="$STR_XBOX_CONTROLER_LS_TURN";
					textLThumbUD="";
					textLThumbPS="";
					textRThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textRThumbLR="";
					textRThumbUD="$STR_XBOX_CONTROLER_RS_MOVE";
					textRThumbPS="";
					class Actions
					{
						class CarLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								2,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								2,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								2,
								3
							};
						};
						class CarRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								2,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								2,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								2,
								3
							};
						};
						CarForward[]={};
						class CarBack
						{
							keys[]=
							{
								"0x00050000 + 23"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class CarFastForward
						{
							keys[]=
							{
								"0x00050000 + 19"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						CarSlowForward[]={};
						class CarAimUp
						{
							actionNameYAxis="CarAimDown";
							keys[]=
							{
								"0x00050000 + 17"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
						};
						class CarAimDown
						{
							actionNameYAxis="CarAimUp";
							keys[]=
							{
								"0x00050000 + 21"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.80000001,0.1,0.89999998,0.14,1,1},
								{0.69999999,0.80000001,0.079999998,0.89999998,0.12,1,0.80000001},
								{0.30000001,0.80000001,0.059999999,0.89999998,0.090000004,1,0.60000002}
							};
						};
						class CarAimLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
						};
						class CarAimRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								
								{
									1,
									0.40000001,
									0.1,
									0.89999998,
									"0.90 0.99",
									3.5999999,
									1,
									9
								},
								{0.69999999,0.40000001,0.1,0.89999998,0.75,0.99000001,3,1,8},
								{0.30000001,0.40000001,0.1,0.89999998,0.60000002,0.99000001,1.8,1,5}
							};
						};
						SwapGunner[]=
						{
							"0x00050000 + 1"
						};
					};
				};
				class Joystick: Joystick
				{
				};
				class Wheel: Wheel
				{
				};
			};
			class Aircraft: Aircraft
			{
				name="aIr";
				axisY=1;
				class Gamepad
				{
					textDPad="$STR_XBOX_CONTROLER_DP_MENU";
					textLThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textLThumbLR="$STR_XBOX_CONTROLER_LS_TILT";
					textLThumbUD="$STR_XBOX_CONTROLER_LS_TILT_MOVE";
					textLThumbPS="";
					textRThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textRThumbLR="$STR_XBOX_CONTROLER_RS_FLY";
					textRThumbUD="$STR_XBOX_CONTROLER_RS_RUDDER";
					textRThumbPS="$STR_XBOX_CONTROLER_RS_LOCK";
					class Actions
					{
						class HeliUp
						{
							keys[]=
							{
								"0x00050000 + 19"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliDown
						{
							keys[]=
							{
								"0x00050000 + 23"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliCyclicLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliCyclicRight
						{
							keys[]=
							{
								"0x00050000 + 18"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliRudderLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliRudderRight
						{
							keys[]=
							{
								"0x00050000 + 18"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliBack
						{
							actionNameYAxis="HeliFastForward";
							keys[]=
							{
								"0x00050000 + 17"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class HeliFastForward
						{
							actionNameYAxis="HeliBack";
							keys[]=
							{
								"0x00050000 + 21"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						HeliForward[]={};
						HeliManualFire[]=
						{
							"0x00050000 + 1"
						};
						class SeagullUp
						{
							keys[]=
							{
								"0x00050000 + 19"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class SeagullDown
						{
							keys[]=
							{
								"0x00050000 + 23"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class SeagullBack
						{
							actionNameYAxis="SeagullFastForward";
							keys[]=
							{
								"0x00050000 + 17"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						class SeagullFastForward
						{
							actionNameYAxis="SeagullBack";
							keys[]=
							{
								"0x00050000 + 21"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								1.5
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								1.5
							};
						};
						SeagullForward[]={};
					};
				};
				class Joystick: Joystick
				{
				};
				class Wheel: Wheel
				{
				};
			};
		};
	};
	class SpecialSoldier: Default
	{
		name="Special Soldier";
		class Gamepad: Gamepad
		{
		};
		class Joystick: Joystick
		{
		};
		class Wheel: Wheel
		{
		};
		class Vehicles: Vehicles
		{
			class Characters: Characters
			{
				class Gamepad
				{
					textDPad="$STR_XBOX_CONTROLER_DP_MENU";
					textLThumb="$STR_XBOX_CONTROLER_AIM";
					textLThumbLR="$STR_XBOX_CONTROLER_LS_LR_AIM";
					textLThumbUD="$STR_XBOX_CONTROLER_LS_UD_AIM";
					textLThumbPS="$STR_XBOX_CONTROLER_LS_UP";
					textRThumb="$STR_XBOX_CONTROLER_MOVEMENT";
					textRThumbLR="$STR_XBOX_CONTROLER_RS_STRAFE";
					textRThumbUD="$STR_XBOX_CONTROLER_RS_MOVE";
					textRThumbPS="$STR_XBOX_CONTROLER_RS_OPTICS";
					class Actions
					{
						class MoveBack
						{
							keys[]=
							{
								"0x00050000 + 23"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								4
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								4
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								4
							};
						};
						class MoveFastForward
						{
							keys[]=
							{
								"0x00050000 + 19"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								4
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								4
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								4
							};
						};
						class TurnLeft
						{
							keys[]=
							{
								"0x00050000 + 22"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								2
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								2
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								2
							};
						};
						class TurnRight
						{
							keys[]=
							{
								"0x00050000 + 18"
							};
							deadZone=0.1;
							curveLow[]=
							{
								"Gamma",
								1,
								2
							};
							curveMedium[]=
							{
								"Gamma",
								1,
								2
							};
							curveHigh[]=
							{
								"Gamma",
								1,
								2
							};
						};
						MoveUp[]=
						{
							"0x00050000 + 14"
						};
						MoveDown[]=
						{
							"0x00050000 + 1"
						};
						class AimUp
						{
							actionNameYAxis="AimDown";
							keys[]=
							{
								"0x00050000 + 17"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
						};
						class AimDown
						{
							actionNameYAxis="AimUp";
							keys[]=
							{
								"0x00050000 + 21"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.2,0.050000001,0.99000001,0.80000001,1,1.8},
								{0.69999999,0.2,0.029999999,0.99000001,0.60000002,1,1.6},
								{0.30000001,0.2,0.02,0.99000001,0.40000001,1,1}
							};
						};
						class AimLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
						};
						class AimRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
							curveMedium[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
							curveHigh[]=
							{
								"LinRampZoom",
								{1,0.40000001,0.1,0.80000001,1.4400001,0.99000001,2.8800001,1,3.9000001},
								{0.69999999,0.40000001,0.1,0.80000001,1.2,0.99000001,2.4000001,1,3.25},
								{0.30000001,0.40000001,0.1,0.80000001,0.95999998,0.99000001,1.4400001,1,1.5599999}
							};
						};
						class AimHeadUp
						{
							actionNameYAxis="AimHeadDown";
							keys[]=
							{
								"0x00050000 + 17"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								6,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								6,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								6,
								3
							};
						};
						class AimHeadDown
						{
							actionNameYAxis="AimHeadUp";
							keys[]=
							{
								"0x00050000 + 21"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								6,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								6,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								6,
								3
							};
						};
						class AimHeadLeft
						{
							keys[]=
							{
								"0x00050000 + 20"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
						class AimHeadRight
						{
							keys[]=
							{
								"0x00050000 + 16"
							};
							deadZone=0;
							curveLow[]=
							{
								"Gamma",
								8,
								3
							};
							curveMedium[]=
							{
								"Gamma",
								8,
								3
							};
							curveHigh[]=
							{
								"Gamma",
								8,
								3
							};
						};
					};
				};
				class Joystick: Joystick
				{
				};
				class Wheel: Wheel
				{
				};
			};
			class Ground: Ground
			{
				class Gamepad: Gamepad
				{
				};
				class Joystick: Joystick
				{
				};
				class Wheel: Wheel
				{
				};
			};
			class Aircraft: Aircraft
			{
				class Gamepad: Gamepad
				{
				};
				class Joystick: Joystick
				{
				};
				class Wheel: Wheel
				{
				};
			};
		};
	};
};
class DefaultTextAttributes
{
	font="TahomaB";
	color="#ffffff";
	size=1;
	align="left";
	valign="middle";
	shadow=1;
	shadowOffset=0.1;
	shadowColor="#000000";
	underline=0;
};
class DefaultSounds
{
	soundOK[]=
	{
		"",
		0.1,
		1
	};
	soundCancel[]=
	{
		"",
		0.1,
		1
	};
	soundChangeFocus[]=
	{
		"",
		0.1,
		1
	};
	soundFail[]=
	{
		"",
		0.1,
		1
	};
};
class RscText
{
	deletable=0;
	fade=0;
	access=0;
	type=0;
	idc=-1;
	style=0;
	w=0.1;
	h=0.050000001;
	font="TahomaB";
	sizeEx=0.039999999;
	colorBackground[]={0,0,0,0};
	colorText[]={1,1,1,1};
	text="";
	fixedWidth=0;
	shadow=0;
};
class RscTextSmall: RscText
{
	h=0.029999999;
	sizeEx=0.027000001;
};
class RscTitle: RscText
{
	style=2;
	x=0.15000001;
	y=0.059999999;
	w=0.69999999;
	shadow=0;
};
class RscProgress
{
	deletable=0;
	fade=0;
	access=0;
	type=8;
	style=0;
	colorFrame[]={1,1,1,1};
	colorBar[]={1,1,1,1};
	texture="#(argb,8,8,3)color(1,1,1,1)";
	w=1.2;
	h=0.029999999;
	shadow=0;
};
class RscProgressNotFreeze
{
	deletable=0;
	fade=0;
	idc=-1;
	type=45;
	style=0;
	shadow=0;
	x=0;
	y=0;
	w=0.5;
	h=0.1;
	texture="#(argb,8,8,3)color(0,0,0,0)";
};
class RscPicture
{
	deletable=0;
	fade=0;
	access=0;
	type=0;
	idc=-1;
	style=48;
	colorBackground[]={0,0,0,0};
	colorText[]={1,1,1,1};
	font="TahomaB";
	sizeEx=0;
	lineSpacing=0;
	text="";
	fixedWidth=0;
	shadow=0;
};
class RscLadderPicture: RscPicture
{
	topValue=100;
	bottomValue=0;
	visibleRange=-1;
};
class RscPictureKeepAspect: RscPicture
{
	style="0x30 + 0x800";
};
class RscHTML
{
	deletable=0;
	fade=0;
	access=0;
	type=9;
	idc=-1;
	style=0;
	filename="";
	colorBackground[]={0,0,0,0};
	colorText[]={1,1,1,1};
	colorBold[]={0,0,0.2,1};
	colorLink[]={1,0.5,0,1};
	colorLinkActive[]={1,0.5,0,1};
	colorPicture[]={1,1,1,1};
	colorPictureLink[]={1,1,1,1};
	colorPictureSelected[]={1,1,1,1};
	colorPictureBorder[]={0,0,0,0};
	tooltipColorText[]={0,0,0,1};
	tooltipColorBox[]={0,0,0,0.5};
	tooltipColorShade[]={1,1,0.69999999,1};
	shadow=0;
	prevPage="#(argb,8,8,3)color(1,1,1,1)";
	nextPage="#(argb,8,8,3)color(1,1,1,1)";
	class H1
	{
		font="TahomaB";
		fontBold="TahomaB";
		sizeEx=0.039999999;
	};
	class H2
	{
		font="TahomaB";
		fontBold="TahomaB";
		sizeEx=0.039999999;
	};
	class H3
	{
		font="TahomaB";
		fontBold="TahomaB";
		sizeEx=0.039999999;
	};
	class H4
	{
		font="TahomaB";
		fontBold="TahomaB";
		sizeEx=0.039999999;
	};
	class H5
	{
		font="TahomaB";
		fontBold="TahomaB";
		sizeEx=0.039999999;
	};
	class H6
	{
		font="TahomaB";
		fontBold="TahomaB";
		sizeEx=0.039999999;
	};
	class P
	{
		font="TahomaB";
		fontBold="TahomaB";
		sizeEx=0.039999999;
	};
};
class RscButton
{
	deletable=0;
	fade=0;
	access=0;
	type=1;
	style=0;
	x=0;
	y=0;
	w=0.30000001;
	h=0.1;
	text="";
	font="TahomaB";
	sizeEx=0.039999999;
	colorText[]={0,0,0,1};
	colorDisabled[]={0.30000001,0.30000001,0.30000001,1};
	colorBackground[]={0.60000002,0.60000002,0.60000002,1};
	colorBackgroundDisabled[]={0.60000002,0.60000002,0.60000002,1};
	colorBackgroundActive[]={1,0.5,0,1};
	offsetX=0.0040000002;
	offsetY=0.0040000002;
	offsetPressedX=0.0020000001;
	offsetPressedY=0.0020000001;
	colorFocused[]={0,0,0,1};
	colorShadow[]={0,0,0,1};
	shadow=0;
	colorBorder[]={0,0,0,1};
	borderSize=0.0080000004;
	soundEnter[]=
	{
		"",
		0.1,
		1
	};
	soundPush[]=
	{
		"",
		0.1,
		1
	};
	soundClick[]=
	{
		"",
		0.1,
		1
	};
	soundEscape[]=
	{
		"",
		0.1,
		1
	};
};
class RscShortcutButton
{
	deletable=0;
	fade=0;
	type=16;
	style=0;
	x=0.1;
	y=0.1;
	w=0.30000001;
	h=0.050000001;
	shadow=0;
	class HitZone
	{
		left=0;
		top=0;
		right=1;
		bottom=1;
	};
	class ShortcutPos
	{
		left=0.0049999999;
		top=0.0049999999;
		w=0.022500001;
		h=0.029999999;
	};
	class TextPos
	{
		left=0.02;
		top=0.0049999999;
		right=0.0049999999;
		bottom=0.0049999999;
	};
	animTextureNormal="#(argb,8,8,3)color(1,1,1,1)";
	animTextureDisabled="#(argb,8,8,3)color(0.3,0.3,0.3,1)";
	animTextureOver="#(argb,8,8,3)color(0.8,0.3,0,1)";
	animTextureFocused="#(argb,8,8,3)color(1,0.5,0,1)";
	animTexturePressed="#(argb,8,8,3)color(1,0,0,1)";
	animTextureDefault="#(argb,8,8,3)color(0,1,0,1)";
	period=0.1;
	periodFocus=0.40000001;
	periodOver=0.40000001;
	shortcuts[]={};
	textureNoShortcut="#(argb,8,8,3)color(0,0,0,0)";
	color[]={0,0,0,0.60000002};
	colorFocused[]={0,0,0,1};
	color2[]={0,0,0,1};
	colorDisabled[]={0,0,0,0.30000001};
	colorBackground[]={1,1,1,1};
	colorBackgroundFocused[]={1,1,1,1};
	colorBackground2[]={1,1,1,0.5};
	text="";
	size=0.039999999;
	soundEnter[]=
	{
		"",
		0.1,
		1
	};
	soundPush[]=
	{
		"",
		0.1,
		1
	};
	soundClick[]=
	{
		"",
		0.1,
		1
	};
	soundEscape[]=
	{
		"",
		0.1,
		1
	};
	class Attributes
	{
		font="TahomaB";
		color="#000000";
		align="left";
		shadow=0;
	};
};
class RscButtonSmall: RscButton
{
	w=0.12;
};
class RscEdit
{
	deletable=0;
	fade=0;
	access=0;
	type=2;
	style=0;
	x=0;
	y=0;
	h=0.039999999;
	w=0.2;
	colorBackground[]={0,0,0,0};
	colorText[]={1,1,1,1};
	colorDisabled[]={1,1,1,0.25};
	colorSelection[]={1,1,1,0.25};
	font="TahomaB";
	sizeEx=0.039999999;
	autocomplete="";
	text="";
	size=0.2;
	shadow=0;
	canModify=1;
};
class RscCombo
{
	deletable=0;
	fade=0;
	access=0;
	type=4;
	style=0;
	h=0.050000001;
	arrowEmpty="#(argb,8,8,3)color(0.3,0.3,0.3,1)";
	arrowFull="#(argb,8,8,3)color(0.3,0.3,0.3,1)";
	wholeHeight=0.25;
	colorSelect[]={0.60000002,0.60000002,0.60000002,1};
	colorText[]={1,1,1,1};
	colorBackground[]={0.2,0.2,0.2,1};
	colorScrollbar[]={1,1,1,1};
	colorDisabled[]={1,1,1,0.25};
	font="TahomaB";
	sizeEx=0.039999999;
	colorPicture[]={1,1,1,1};
	colorPictureSelected[]={0,0,0,1};
	colorPictureDisabled[]={1,1,1,0.25};
	colorPictureRight[]={1,1,1,1};
	colorPictureRightSelected[]={1,1,1,1};
	colorPictureRightDisabled[]={1,1,1,0.25};
	colorTextRight[]={1,1,1,1};
	colorSelectRight[]={0,0,0,1};
	colorSelect2Right[]={0,0,0,1};
	tooltipColorText[]={1,1,1,1};
	tooltipColorBox[]={1,1,1,1};
	tooltipColorShade[]={0,0,0,0.64999998};
	soundSelect[]=
	{
		"",
		0.1,
		1
	};
	soundExpand[]=
	{
		"",
		0.1,
		1
	};
	soundCollapse[]=
	{
		"",
		0.1,
		1
	};
	maxHistoryDelay=1;
	shadow=0;
	class ComboScrollBar: ScrollBar
	{
	};
};
class RscListBox
{
	deletable=0;
	fade=0;
	access=0;
	type=5;
	style=0;
	x=0;
	y=0;
	w=0.40000001;
	h=0.40000001;
	font="TahomaB";
	sizeEx=0.039999999;
	rowHeight=0;
	colorText[]={1,1,1,1};
	colorDisabled[]={1,1,1,0.25};
	colorScrollbar[]={1,1,1,1};
	colorSelect[]={0,0,0,1};
	colorSelect2[]={1,0.5,0,1};
	colorSelectBackground[]={0.60000002,0.60000002,0.60000002,1};
	colorSelectBackground2[]={0.2,0.2,0.2,1};
	colorBackground[]={0,0,0,1};
	maxHistoryDelay=1;
	soundSelect[]=
	{
		"",
		0.1,
		1
	};
	period=1;
	autoScrollSpeed=-1;
	autoScrollDelay=5;
	autoScrollRewind=0;
	arrowEmpty="#(argb,8,8,3)color(1,1,1,1)";
	arrowFull="#(argb,8,8,3)color(1,1,1,1)";
	shadow=0;
	colorPicture[]={1,1,1,1};
	colorPictureSelected[]={0,0,0,1};
	colorPictureDisabled[]={1,1,1,0.25};
	colorPictureRight[]={1,1,1,1};
	colorPictureRightSelected[]={1,1,1,1};
	colorPictureRightDisabled[]={1,1,1,0.25};
	colorTextRight[]={1,1,1,1};
	colorSelectRight[]={0,0,0,1};
	colorSelect2Right[]={0,0,0,1};
	tooltipColorText[]={1,1,1,1};
	tooltipColorBox[]={1,1,1,1};
	tooltipColorShade[]={0,0,0,0.64999998};
	class ListScrollBar: ScrollBar
	{
	};
};
class RscListNBox
{
	deletable=0;
	fade=0;
	access=0;
	type=102;
	style=0;
	w=0.40000001;
	h=0.40000001;
	font="TahomaB";
	sizeEx=0.039999999;
	rowHeight=0;
	colorText[]={1,1,1,1};
	colorScrollbar[]={1,1,1,1};
	colorSelect[]={0,0,0,1};
	colorSelect2[]={1,0.5,0,1};
	colorSelectBackground[]={0.60000002,0.60000002,0.60000002,1};
	colorSelectBackground2[]={0.2,0.2,0.2,1};
	colorBackground[]={0,0,0,1};
	maxHistoryDelay=1;
	soundSelect[]=
	{
		"",
		0.1,
		1
	};
	period=1;
	autoScrollSpeed=-1;
	autoScrollDelay=5;
	autoScrollRewind=0;
	arrowEmpty="#(argb,8,8,3)color(1,1,1,1)";
	arrowFull="#(argb,8,8,3)color(1,1,1,1)";
	drawSideArrows=0;
	columns[]={0.30000001,0.60000002,0.69999999};
	idcLeft=-1;
	idcRight=-1;
	shadow=0;
	class ListScrollBar: ScrollBar
	{
	};
};
class RscXListBox
{
	deletable=0;
	fade=0;
	idc=-1;
	style=0;
	type=42;
	x=0.1;
	y=0.1;
	w=0.30000001;
	h=0.050000001;
	shadow=0;
	color[]={1,1,1,0.60000002};
	colorActive[]={1,1,1,1};
	colorDisabled[]={1,1,1,0.30000001};
	arrowEmpty="#(argb,8,8,3)color(1,1,1,1)";
	arrowFull="#(argb,8,8,3)color(1,0.5,0,1)";
	border="#(argb,8,8,3)color(0,0,0,1)";
	colorSelect[]={1,1,1,1};
	colorText[]={1,1,1,0.80000001};
	font="TahomaB";
	sizeEx=0.039999999;
	soundSelect[]=
	{
		"",
		0.1,
		1
	};
	colorPicture[]={1,1,1,1};
	colorPictureSelected[]={0,0,0,1};
	colorPictureDisabled[]={1,1,1,0.25};
	colorPictureRight[]={1,1,1,1};
	colorPictureRightSelected[]={1,1,1,1};
	colorPictureRightDisabled[]={1,1,1,0.25};
	tooltipColorText[]={1,1,1,1};
	tooltipColorBox[]={1,1,1,1};
	tooltipColorShade[]={0,0,0,0.64999998};
};
class RscTree
{
	deletable=0;
	fade=0;
	access=0;
	type=12;
	style=0;
	colorBackground[]={0.34999999,0.38,0.36000001,1};
	colorSelect[]={0.69999999,0.69999999,0.69999999,1};
	colorDisabled[]={1,0,0,1};
	colorText[]={1,1,1,0.75};
	colorSelectText[]={0,0,0,1};
	colorBorder[]={1,1,1,1};
	colorSearch[]={1,1,1,1};
	colorMarked[]={0.2,0.30000001,0.69999999,1};
	colorMarkedText[]={0,0,0,1};
	colorMarkedSelected[]={0,0.5,0.5,1};
	multiselectEnabled=0;
	expandOnDoubleclick=0;
	colorPicture[]={1,1,1,1};
	colorPictureSelected[]={0,0,0,1};
	colorPictureDisabled[]={1,1,1,0.25};
	colorPictureRight[]={1,1,1,1};
	colorPictureRightSelected[]={1,1,1,1};
	colorPictureRightDisabled[]={1,1,1,0.25};
	colorArrow[]={1,1,1,1};
	font="TahomaB";
	sizeEx=0.039999999;
	maxHistoryDelay=1;
	shadow=0;
};
class RscSlider
{
	deletable=0;
	fade=0;
	access=0;
	type=3;
	style=1024;
	x=0;
	y=0;
	h=0.028000001;
	w=0.30000001;
	color[]={1,1,1,1};
	colorActive[]={1,1,1,1};
	shadow=0;
};
class RscSliderH: RscSlider
{
};
class RscXSliderH
{
	deletable=0;
	fade=0;
	type=43;
	style="0x400  + 0x10";
	h="scalar NaN";
	color[]={1,1,1,0.60000002};
	colorActive[]={1,1,1,1};
	colorDisable[]={1,1,1,0.40000001};
	arrowEmpty="#(argb,8,8,3)color(1,1,1,1)";
	arrowFull="#(argb,8,8,3)color(1,1,1,1)";
	border="#(argb,8,8,3)color(1,1,1,1)";
	thumb="#(argb,8,8,3)color(1,1,1,1)";
	shadow=0;
};
class RscActiveText
{
	deletable=0;
	fade=0;
	access=0;
	type=11;
	style=2;
	h=0.050000001;
	w=0.15000001;
	font="TahomaB";
	sizeEx=0.039999999;
	color[]={1,1,1,1};
	colorActive[]={1,0.5,0,1};
	colorDisabled[]={1,1,1,0.25};
	soundEnter[]=
	{
		"",
		0.1,
		1
	};
	soundPush[]=
	{
		"",
		0.1,
		1
	};
	soundClick[]=
	{
		"",
		0.1,
		1
	};
	soundEscape[]=
	{
		"",
		0.1,
		1
	};
	text="";
	default=0;
	shadow=0;
};
class RscStructuredText
{
	deletable=0;
	fade=0;
	access=0;
	type=13;
	idc=-1;
	style=0;
	h=0.050000001;
	text="";
	size=0.039999999;
	colorText[]={1,1,1,1};
	shadow=0;
	class Attributes
	{
		font="TahomaB";
		color="#ffffff";
		colorLink="#ff0000";
		align="center";
		shadow=1;
	};
};
class RscControlsGroup
{
	deletable=0;
	fade=0;
	type=15;
	idc=-1;
	style=0;
	x=0;
	y=0;
	w=1;
	h=1;
	shadow=0;
	class VScrollbar: ScrollBar
	{
		color[]={1,1,1,1};
		width=0.021;
		autoScrollEnabled=1;
	};
	class HScrollbar: ScrollBar
	{
		color[]={1,1,1,1};
		height=0.028000001;
	};
	class Controls
	{
	};
};
class RscBackgroundStripeTop: RscText
{
	access=0;
	x=-10;
	y=-10;
	w=21;
	h=10.125;
	text="";
	colorBackground[]={0.1,0.1,0.1,1};
};
class RscBackgroundStripeBottom: RscText
{
	access=0;
	x=-10;
	y=0.875;
	w=21;
	h=10.125;
	text="";
	colorBackground[]={0.1,0.1,0.1,1};
};
class RscDisplayBackgroundStripes
{
	access=0;
	class Background1: RscBackgroundStripeTop
	{
	};
	class Background2: RscBackgroundStripeBottom
	{
	};
};
class RscCinemaBorder: RscDisplayBackgroundStripes
{
	idd=-1;
	movingEnable=0;
	enableSimulation=1;
	class controlsBackground
	{
		class Background1: RscBackgroundStripeTop
		{
			colorBackground[]={0,0,0,1};
		};
		class Background2: RscBackgroundStripeBottom
		{
			colorBackground[]={0,0,0,1};
		};
	};
};
class RscToolbox
{
	deletable=0;
	fade=0;
	access=0;
	type=6;
	style=2;
	colorText[]={1,1,1,1};
	color[]={1,1,1,1};
	colorTextSelect[]={1,1,1,1};
	colorSelect[]={1,1,1,1};
	colorTextDisable[]={1,1,1,1};
	colorDisable[]={1,1,1,1};
	colorSelectedBg[]={0,0,0,255};
	font="TahomaB";
	sizeEx=0.027000001;
	shadow=0;
	rows=1;
	columns=2;
	strings[]=
	{
		"",
		""
	};
	x=0;
	y=0;
	w=0.30000001;
	h=0.025;
};
class RscHitZones
{
	type=17;
	style=0;
	shadow=0;
	x=0;
	y=0;
	w=0;
	h=0;
	xCount=0;
	yCount=0;
	xSpace=0;
	ySpace=0;
};
class RscXKeyShadow
{
	type=40;
	idc=-1;
	style=0;
	h=0.059999999;
	size="( 21 / 408 )";
	shadow=0;
	class Attributes
	{
		font="FontX";
		color="#C0C1BF";
		align="left";
	};
	class AttributesImage
	{
		color="#ffffff";
	};
};
class RscXKey: RscXKeyShadow
{
	class Attributes
	{
		shadow=0;
	};
};
class RscMapControl
{
	deletable=0;
	fade=0;
	access=0;
	type=101;
	idc=51;
	style=48;
	shadow=0;
	colorBackground[]={1,1,1,1};
	colorOutside[]={1,0,0,1};
	colorText[]={0,0,0,1};
	font="TahomaB";
	sizeEx=0.039999999;
	scaleMin=0.001;
	scaleMax=1;
	scaleDefault=0.16;
	colorSea[]={0.56,0.80000001,0.98000002,0.5};
	colorForest[]={0.60000002,0.80000001,0.2,0.5};
	colorRocks[]={0.5,0.5,0.5,0.5};
	colorCountlines[]={0.64999998,0.44999999,0.27000001,0.5};
	colorMainCountlines[]={0.64999998,0.44999999,0.27000001,1};
	colorCountlinesWater[]={0,0.52999997,1,0.5};
	colorMainCountlinesWater[]={0,0.52999997,1,1};
	colorForestBorder[]={0.40000001,0.80000001,0,1};
	colorRocksBorder[]={0.5,0.5,0.5,1};
	colorPowerLines[]={0,0,0,1};
	colorRailWay[]={0.80000001,0.2,0.30000001,1};
	colorNames[]={0,0,0,1};
	colorInactive[]={1,1,1,0.5};
	colorLevels[]={0,0,0,1};
	colorTracks[]={0.34999999,0.2,0.1,0.80000001};
	colorRoads[]={0.34999999,0.2,0.1,1};
	colorMainRoads[]={0,0,0,1};
	colorTracksFill[]={0,0,0,0};
	colorRoadsFill[]={1,0.92000002,0.74000001,1};
	colorMainRoadsFill[]={0.93000001,0.11,0.14,0.80000001};
	colorGrid[]={0.15000001,0.15000001,0.050000001,0.89999998};
	colorGridMap[]={0.25,0.25,0.1,0.75};
	fontLabel="TahomaB";
	sizeExLabel=0.039999999;
	fontGrid="TahomaB";
	sizeExGrid=0.039999999;
	fontUnits="TahomaB";
	sizeExUnits=0.039999999;
	fontNames="TahomaB";
	sizeExNames=0.039999999;
	fontInfo="TahomaB";
	sizeExInfo=0.039999999;
	fontLevel="TahomaB";
	sizeExLevel=0.039999999;
	text="#(argb,8,8,3)color(1,1,1,1)";
	stickX[]=
	{
		0.2,
		
		{
			"Gamma",
			1,
			1.5
		}
	};
	stickY[]=
	{
		0.2,
		
		{
			"Gamma",
			1,
			1.5
		}
	};
	ptsPerSquareSea=6;
	ptsPerSquareTxt=8;
	ptsPerSquareCLn=8;
	ptsPerSquareExp=8;
	ptsPerSquareCost=8;
	ptsPerSquareFor=4;
	ptsPerSquareForEdge=10;
	ptsPerSquareRoad=2;
	ptsPerSquareObj=10;
	showCountourInterval=1;
	maxSatelliteAlpha=0.66000003;
	alphaFadeStartScale=0.050000001;
	alphaFadeEndScale=0.15000001;
	class Legend
	{
		x=0.69999999;
		y=0.85000002;
		w=0.25;
		h=0.1;
		font="TahomaB";
		sizeEx=0.039999999;
		colorBackground[]={1,1,1,1};
		color[]={0,0,0,1};
	};
	class ActiveMarker
	{
		color[]={0.30000001,0.1,0.89999998,1};
		size=50;
	};
	class Command
	{
		icon="#(argb,8,8,3)color(1,1,1,1)";
		color[]={0,0,0,1};
		size=18;
		importance=1;
		coefMin=1;
		coefMax=1;
	};
	class Task
	{
		taskNone="#(argb,8,8,3)color(0,0,0,0)";
		taskCreated="#(argb,8,8,3)color(0,0,0,1)";
		taskAssigned="#(argb,8,8,3)color(1,1,1,1)";
		taskSucceeded="#(argb,8,8,3)color(0,1,0,1)";
		taskFailed="#(argb,8,8,3)color(1,0,0,1)";
		taskCanceled="#(argb,8,8,3)color(1,0.5,0,1)";
		colorCreated[]={1,1,1,1};
		colorCanceled[]={1,1,1,1};
		colorDone[]={1,1,1,1};
		colorFailed[]={1,1,1,1};
		color[]={1,1,1,1};
		size=18;
		importance=1;
		coefMin=1;
		coefMax=1;
	};
	class CustomMark
	{
		icon="#(argb,8,8,3)color(1,0.5,0,1)";
		color[]={1,1,1,1};
		size=18;
		importance=1;
		coefMin=1;
		coefMax=1;
	};
	class Tree
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,0,1};
		size=16;
		importance="0.9 * 16 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class SmallTree
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,0,1};
		size=16;
		importance="0.6 * 16 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Bush
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,0,1};
		size=16;
		importance="0.2 * 16 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Church
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,0,1};
		size=16;
		importance="2 * 16 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Chapel
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,0,1};
		size=16;
		importance="1 * 16 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Cross
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,0,1};
		size=16;
		importance="0.7 * 16 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Rock
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,0,1};
		size=16;
		importance="1.5 * 16 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Bunker
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,0,1};
		size=16;
		importance="1.5 * 16 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Fortress
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,0,1};
		size=16;
		importance="2 * 16 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Fountain
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,1,1};
		size=16;
		importance="1 * 16 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class ViewTower
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,0,1};
		size=16;
		importance="2.5 * 16 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Lighthouse
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,0,1};
		size=16;
		importance="3 * 16 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Quay
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,0,1};
		size=16;
		importance="2 * 16 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Fuelstation
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,0,1};
		size=16;
		importance="2 * 16 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Hospital
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={1,0,0,1};
		size=16;
		importance="2 * 16 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class BusStop
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,1,1};
		size=8;
		importance="1 * 8 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class LineMarker
	{
		lineWidthThin=0.0080000004;
		lineWidthThick=0.014;
		lineDistanceMin=2.9999999e-005;
		lineLengthMin=5;
		textureComboBoxColor="#(argb,8,8,3)color(1,1,1,1)";
	};
	class Transmitter
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,1,1};
		size=8;
		importance="1 * 8 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Stack
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,1,1};
		size=8;
		importance="1 * 8 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Ruin
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,1,1};
		size=8;
		importance="1 * 8 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Tourism
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,1,1};
		size=8;
		importance="1 * 8 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Watertower
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,1,1};
		size=8;
		importance="1 * 8 * 0.05";
		coefMin=0.25;
		coefMax=4;
	};
	class Waypoint
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,0,1};
		size=24;
		importance=1;
		coefMin=1;
		coefMax=1;
	};
	class WaypointCompleted
	{
		icon="#(argb,8,8,3)color(0,0,0,1)";
		color[]={0,0,0,1};
		size=24;
		importance=1;
		coefMin=1;
		coefMax=1;
	};
};
class RscObject
{
	access=0;
	type=80;
	scale=1;
	direction[]={0,0,1};
	up[]={0,1,0};
	shadow=0;
};
class RscStandardDisplay
{
	access=0;
	movingEnable=0;
	enableSimulation=0;
	enableDisplay=0;
};
class RscLineBreak
{
	idc=-1;
	type=98;
	shadow=0;
};
class RscCompass: RscObject
{
	idc=-1;
	type=81;
	model="\core\compass\compass.p3d";
	selectionArrow="arrow";
	position[]={0.026000001,0.046999998,0.2};
	direction[]={0,1,1};
	up[]={0,0,-1};
	positionBack[]={0.074900001,-0.059,0.315};
	inBack=1;
	enableZoom=0;
	zoomDuration=0.5;
};
class RscWatch: RscObject
{
	idc=-1;
	type=81;
	model="\core\watch\watch.p3d";
	selectionDate1="date1";
	selectionDate2="date2";
	selectionDay="day";
	position[]={0.026000001,0.046999998,0.2};
	positionBack[]={0.050000001,-0.050000001,0.22};
	inBack=1;
	enableZoom=1;
	zoomDuration=0.5;
};
class RscMiniMap
{
	access=0;
	idd=133;
	movingEnable=0;
	enableSimulation=1;
	enableDisplay=1;
	class controls
	{
		class MiniMap: RscMapControl
		{
			IDC=101;
			x=0.1;
			y=0.1;
			w=0.30000001;
			h=0.30000001;
			showCountourInterval=0;
		};
	};
};
class RscMiniMapSmall: RscMiniMap
{
};
class RscButtonImages
{
};
class RscObjectives
{
	access=0;
	done="#(argb,8,8,3)color(1,1,1,1)";
	failed="#(argb,8,8,3)color(1,1,1,1)";
	active="#(argb,8,8,3)color(1,1,1,1)";
	cancled="#(argb,8,8,3)color(1,1,1,1)";
};
class RscCheckBox
{
	type=77;
};
class RscMsgBox
{
	access=0;
	class Top
	{
		class Title: RscText
		{
			x=0.15000001;
			y=0.40000001;
			w=0.69999999;
			h=0.1;
			colorBackground[]={0.2,0.2,0.2,1};
			text="Arma 3";
			style=2;
		};
	};
	class Middle
	{
		class Background: RscText
		{
			x=0.15000001;
			y=0.40000001;
			w=0.69999999;
			h=0.2;
			colorBackground[]={0.25,0.25,0.25,1};
		};
		class SubBackground: RscText
		{
			x=0.17;
			y=0.47999999;
			w=0.66000003;
			h=0.039999999;
			colorBackground[]={0.75,0.75,0.75,1};
		};
		class Text: RscStructuredText
		{
			idc=101;
			x=0.19;
			y=0.5;
			w=0.62;
			h=0;
			size=0.039999999;
			class Attributes
			{
				font="TahomaB";
				color="#000000";
				align="center";
				shadow=0;
			};
		};
	};
	class Bottom
	{
		class Button1: RscShortcutButton
		{
			type=16;
			idc=1;
			text="$STR_DISP_OK";
			style=0;
			default=0;
			x=0.40000001;
			y=0.54000002;
			w=0.2;
			h=0.039999999;
			color[]={1,1,1,1};
			colorText[]={1,0.537,0,1};
			colorDisabled[]={1,1,1,0.25};
			colorBackground[]={1,0.537,0,0.60000002};
			colorActiveBackground[]={1,0.537,0,1};
			period=0.5;
			font="TahomaB";
			size=0.039999999;
			sizeEx=0.039999999;
			soundEnter[]=
			{
				"",
				0.1,
				1
			};
			soundPush[]=
			{
				"",
				0.1,
				1
			};
			soundClick[]=
			{
				"",
				0.1,
				1
			};
			soundEscape[]=
			{
				"",
				0.1,
				1
			};
			action="";
			class Attributes
			{
				font="TahomaB";
				color="#E5E5E5";
				align="center";
			};
			class AttributesImage
			{
				font="TahomaB";
				color="#E5E5E5";
				align="center";
			};
		};
		class Button2: Button1
		{
			idc=2;
			text="$STR_DISP_CANCEL";
			default=1;
			x=0.63;
		};
	};
};
class RscMsgBoxError
{
	access=0;
	class Top
	{
		class Title: RscText
		{
			x=0.15000001;
			y=0.40000001;
			w=0.69999999;
			h=0.1;
			colorBackground[]={0.2,0.2,0.2,1};
			text="Arma 3";
			style=2;
		};
	};
	class Middle
	{
		class Background: RscText
		{
			x=0.15000001;
			y=0.40000001;
			w=0.69999999;
			h=0.2;
			colorBackground[]={0.25,0.25,0.25,1};
		};
		class SubBackground: RscText
		{
			x=0.17;
			y=0.47999999;
			w=0.66000003;
			h=0.039999999;
			colorBackground[]={0.75,0.75,0.75,1};
		};
		class Text: RscStructuredText
		{
			idc=101;
			x=0.19;
			y=0.5;
			w=0.62;
			h=0;
			size=0.039999999;
			class Attributes
			{
				font="TahomaB";
				color="#000000";
				align="center";
				shadow=0;
			};
		};
	};
	class Bottom
	{
		class Button1: RscShortcutButton
		{
			type=16;
			idc=1;
			text="$STR_DISP_OK";
			style=0;
			default=0;
			x=0.40000001;
			y=0.54000002;
			w=0.2;
			h=0.039999999;
			color[]={1,1,1,1};
			colorText[]={1,0.537,0,1};
			colorDisabled[]={1,1,1,0.25};
			colorBackground[]={1,0.537,0,0.60000002};
			colorActiveBackground[]={1,0.537,0,1};
			period=0.5;
			font="TahomaB";
			size=0.039999999;
			sizeEx=0.039999999;
			soundEnter[]=
			{
				"",
				0.1,
				1
			};
			soundPush[]=
			{
				"",
				0.1,
				1
			};
			soundClick[]=
			{
				"",
				0.1,
				1
			};
			soundEscape[]=
			{
				"",
				0.1,
				1
			};
			action="";
			class Attributes
			{
				font="TahomaB";
				color="#E5E5E5";
				align="center";
			};
			class AttributesImage
			{
				font="TahomaB";
				color="#E5E5E5";
				align="center";
			};
		};
		class Button2: Button1
		{
			idc=2;
			text="$STR_DISP_CANCEL";
			default=1;
			x=0.63;
		};
	};
};
class RscMsgBox3
{
	access=0;
	class Top
	{
		class Title: RscText
		{
			x=0.15000001;
			y=0.40000001;
			w=0.69999999;
			h=0.1;
			colorBackground[]={0.2,0.2,0.2,1};
			text="Arma 3";
			style=2;
		};
	};
	class Middle
	{
		class Background: RscText
		{
			x=0.15000001;
			y=0.40000001;
			w=0.69999999;
			h=0.2;
			colorBackground[]={0.25,0.25,0.25,1};
		};
		class SubBackground: RscText
		{
			x=0.17;
			y=0.47999999;
			w=0.66000003;
			h=0.039999999;
			colorBackground[]={0.75,0.75,0.75,1};
		};
		class Text: RscStructuredText
		{
			idc=101;
			x=0.19;
			y=0.5;
			w=0.62;
			h=0;
			size=0.039999999;
			class Attributes
			{
				font="TahomaB";
				color="#000000";
				align="center";
				shadow=0;
			};
		};
	};
	class Bottom
	{
		class Button1: RscShortcutButton
		{
			type=16;
			idc=1;
			text="$STR_DISP_OK";
			style=0;
			default=0;
			x=0.18000001;
			y=0.50999999;
			w=0.2;
			h=0.1;
			color[]={1,1,1,1};
			colorText[]={1,0.537,0,1};
			colorDisabled[]={1,1,1,0.25};
			colorBackground[]={1,0.537,0,0.60000002};
			colorActiveBackground[]={1,0.537,0,1};
			period=0.5;
			font="TahomaB";
			size=0.039999999;
			sizeEx=0.039999999;
			soundEnter[]=
			{
				"",
				0.1,
				1
			};
			soundPush[]=
			{
				"",
				0.1,
				1
			};
			soundClick[]=
			{
				"",
				0.1,
				1
			};
			soundEscape[]=
			{
				"",
				0.1,
				1
			};
			action="";
			class Attributes
			{
				font="TahomaB";
				color="#E5E5E5";
				align="center";
			};
			class AttributesImage
			{
				font="TahomaB";
				color="#E5E5E5";
				align="center";
			};
		};
		class Button2: Button1
		{
			idc=2;
			text="$STR_DISP_CANCEL";
			default=1;
			x=0.62;
		};
		class Button3: Button1
		{
			idc=6;
			text="$STR_DISP_LATER";
			x=0.40000001;
		};
	};
};
class RscDisplayFileSelect
{
	idd=167;
	class controlsBackground
	{
		class TitleBackground: RscText
		{
			colorBackground[]={0.2,0.2,0.2,1};
			x="1 * 0.03 + -0.1";
			y="1 * 0.04 + 0.0";
			w="31.5 * 0.03";
			h="1 * 0.04";
		};
		class TreeBackground: RscText
		{
			colorBackground[]={0.2,0.2,0.2,1};
			x="1 * 0.03 + -0.1";
			y="2.1 * 0.04 + 0.0";
			w="15.7 * 0.03";
			h="20 * 0.04";
		};
		class ListBackground: RscText
		{
			colorBackground[]={0.2,0.2,0.2,1};
			x="16.8 * 0.03 + -0.1";
			y="2.1 * 0.04 + 0.0";
			w="15.7 * 0.03";
			h="20 * 0.04";
		};
	};
	class controls
	{
		class Title: RscTitle
		{
			style=0;
			idc=101;
			text="";
			x="1 * 0.03 + -0.1";
			y="1 * 0.04 + 0.0";
			w="31.5 * 0.03";
			h="1 * 0.04";
		};
		class Button1: RscShortcutButton
		{
			idc=1;
			text="$STR_DISP_OK";
			x="26.5 * 0.03 + -0.1";
			y="22 * 0.04 + 0.0";
			w="6 * 0.03";
			h="1 * 0.04";
		};
		class Button2: Button1
		{
			idc=2;
			text="$STR_DISP_CANCEL";
			x="1 * 0.03 + -0.1";
			y="22 * 0.04 + 0.0";
			w="6.25 * 0.03";
			h="1 * 0.04";
		};
		class TreeDirectory: RscTree
		{
			idc=102;
			x="1 * 0.03 + -0.1";
			y="2.5 * 0.04 + 0.0";
			w="14 * 0.03";
			h="19 * 0.04";
		};
		class ListFiles: RscListBox
		{
			idc=103;
			x="15.5 * 0.03 + -0.1";
			y="2.5 * 0.04 + 0.0";
			w="17 * 0.03";
			h="19 * 0.04";
		};
	};
};
class RscDisplayFileSelectImage
{
	idd=167;
	class controlsBackground
	{
		class TitleBackground: RscText
		{
			colorBackground[]={0.2,0.2,0.2,1};
			x="1 * 0.03 + -0.1";
			y="1 * 0.04 + 0.0";
			w="31.5 * 0.03";
			h="1 * 0.04";
		};
		class TreeBackground: RscText
		{
			colorBackground[]={0.2,0.2,0.2,1};
			x="1 * 0.03 + -0.1";
			y="2.1 * 0.04 + 0.0";
			w="15.7 * 0.03";
			h="20 * 0.04";
		};
		class ListBackground: RscText
		{
			colorBackground[]={0.2,0.2,0.2,1};
			x="16.8 * 0.03 + -0.1";
			y="2.1 * 0.04 + 0.0";
			w="15.7 * 0.03";
			h="11.95 * 0.04";
		};
		class PictureBackground: RscText
		{
			colorBackground[]={0.2,0.2,0.2,1};
			x="16.8 * 0.03 + -0.1";
			y="14.15 * 0.04 + 0.0";
			w="15.7 * 0.03";
			h="7.95 * 0.04";
		};
	};
	class controls
	{
		class Title: RscTitle
		{
			style=0;
			idc=101;
			text="";
			x="1 * 0.03 + -0.1";
			y="1 * 0.04 + 0.0";
			w="31.5 * 0.03";
			h="1 * 0.04";
		};
		class Button1: RscShortcutButton
		{
			idc=1;
			text="$STR_DISP_OK";
			x="26.5 * 0.03 + -0.1";
			y="22 * 0.04 + 0.0";
			w="6 * 0.03";
			h="1 * 0.04";
		};
		class Button2: Button1
		{
			idc=2;
			text="$STR_DISP_CANCEL";
			x="1 * 0.03 + -0.1";
			y="22 * 0.04 + 0.0";
			w="6.25 * 0.03";
			h="1 * 0.04";
		};
		class TreeDirectory: RscTree
		{
			idc=102;
			x="1 * 0.03 + -0.1";
			y="2.5 * 0.04 + 0.0";
			w="14 * 0.03";
			h="19 * 0.04";
		};
		class ListFiles: RscListBox
		{
			idc=103;
			x="15.5 * 0.03 + -0.1";
			y="2.5 * 0.04 + 0.0";
			w="17 * 0.03";
			h="10.5 * 0.04";
		};
		class OverviewPicture: RscPicture
		{
			idc=104;
			x="15.5 * 0.03 + -0.1";
			y="13.5 * 0.04 + 0.0";
			w="17 * 0.03";
			h="8 * 0.04";
		};
	};
};
class RscMap
{
	access=0;
	class controls
	{
		class Map: RscMapControl
		{
			moveOnEdges=0;
			x=0;
			y=0;
			w=0.82999998;
			h=1;
			shadow=0;
		};
	};
};
class RscDisplayChannel
{
	idd=63;
	class controls
	{
		class Channel: RscText
		{
			idc=101;
			x=0.41;
			y=0.74000001;
			w=0.18000001;
			h=0.039999999;
			style=2;
			text="$STR_DISP_ERROR";
			colorBackground[]={0,0,0,0.75};
		};
		class Background: RscText
		{
			x=0.41;
			y=0.62;
			w=0.18000001;
			h=0.12;
			colorBackground[]={0,0,0,0.75};
			colorText[]={0,0,0,1};
			text="";
		};
		class Picture: RscPicture
		{
			idc=102;
			text="#(argb,8,8,3)color(1,1,1,1)";
			x=0.46000001;
			y=0.63;
			w=0.079999998;
			h=0.1;
			colorText[]={1,1,1,1};
		};
	};
};
class RscDisplayChat
{
	idd=24;
	class controls
	{
		class Background: RscText
		{
			x=0.14;
			y=0.81;
			w=0.5;
			colorBackground[]={0,0,0,0.75};
			colorText[]={0,0,0,1};
			text="";
		};
		class Line: RscEdit
		{
			idc=101;
			x=0.14;
			y=0.81;
			w=0.5;
			text="";
			colorBackground[]={0,0,0,0.5};
			colorText[]={1,1,1,1};
			autocomplete="general";
		};
	};
};
class RscDisplayVoiceChat
{
	idd=55;
	class controls
	{
		class Background: RscText
		{
			x=0.015;
			y=0.773;
			w=0.039999999;
			h=0.050000001;
			colorBackground[]={0,0,0,0.75};
			colorText[]={0,0,0,1};
			text="";
		};
		class Picture: RscPicture
		{
			idc=101;
			text="#(argb,8,8,3)color(1,1,1,1)";
			x=0.015;
			y=0.773;
			w=0.039999999;
			h=0.050000001;
			colorText[]={1,1,1,1};
		};
	};
};
class RscDisplayMissionEditor
{
	idd=128;
	colorAttrDialog[]={1,1,1,1};
	colorAttrPosition[]={0,1,0,1};
	colorAttrDirection[]={0,1,0,1};
	colorAttrLink[]={0,0,1,1};
	colorAttrParent[]={1,0,0,1};
	colorAttrCounter[]={0.5,0,0.5,1};
	class ControlsBackground
	{
		class Background: RscListBox
		{
			idc=203;
			x=0;
			y=0;
			w=1;
			h=1;
			colorBackground[]={0,0,0,0};
		};
	};
	class Controls
	{
		class T_Background1: RscText
		{
			x=0;
			y=0;
			w=1;
			h=0.059999999;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class T_Frame1: RscText
		{
			x=0;
			y=0;
			w=1;
			h=0.059999999;
			style=64;
		};
		class B_Load: RscButton
		{
			idc=206;
			x=0.28999999;
			y=0.0099999998;
			w=0.1;
			h=0.039999999;
			sizeEx=0.027000001;
			text="$STR_DISP_ARCMAP_LOAD";
			toolTip="$STR_UI_EDITOR_LOAD_T";
			default=0;
		};
		class B_Save: B_Load
		{
			idc=205;
			x=0.40000001;
			text="$STR_DISP_ARCMAP_SAVE";
			toolTip="$STR_UI_EDITOR_SAVE_T";
		};
		class B_Restart: B_Load
		{
			idc=207;
			x=0.50999999;
			text="$STR_UI_EDITOR_RESTART";
			toolTip="$STR_UI_EDITOR_RESTART_T";
		};
		class B_Clear: B_Load
		{
			idc=210;
			x=0.62;
			text="$STR_DISP_ARCMAP_CLEAR";
			toolTip="$STR_UI_EDITOR_CLEAR_T";
		};
		class B_Preview: B_Load
		{
			idc=208;
			x=0.73000002;
			text="$STR_DISP_ARCMAP_PREVIEW";
			toolTip="$STR_UI_EDITOR_PREVIEW_T";
			default=1;
		};
		class B_Map: B_Load
		{
			idc=209;
			x=0.83999997;
			text="$STR_UI_EDITOR_HIDE_MAP";
			toolTip="$STR_UI_EDITOR_HIDE_MAP_T";
		};
		class B_Exit: B_Load
		{
			idc=2;
			x=0.94999999;
			w=0.039999999;
			text="X";
			toolTip="$STR_UI_EDITOR_QUIT_T";
		};
		class T_Background2: RscText
		{
			x=0.75;
			y=0.059999999;
			w=0.25;
			h=0.94;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class T_ObjectBrowser: RscTree
		{
			idc=201;
			style=0;
			x=0.75;
			y=0.059999999;
			w=0.25;
			h=0.30000001;
			sizeEx=0.017999999;
			colorBackground[]={0,0,0,0};
		};
		class T_Help1: RscText
		{
			idc=220;
			style=16;
			sizeEx=0.027000001;
			lineSpacing=1;
			x=0.75;
			y=0.36000001;
			w=0.25;
			h=0.28999999;
		};
		class L_ObjectInfo: RscListBox
		{
			idc=202;
			x=0.75;
			y=0.64999998;
			w=0.25;
			h=0.175;
			sizeEx=0.027000001;
			colorSelect[]={0,0,0,1};
			colorSelect2[]={0,0,0,1};
			colorSelectBackground[]={1,1,1,1};
			colorSelectBackground2[]={1,1,1,1};
			rowHeight=0.028999999;
			period=0;
		};
		class L_NewObject: RscListBox
		{
			idc=211;
			x=0.75;
			y=0.82499999;
			w=0.25;
			h=0.175;
			sizeEx=0.027000001;
			colorSelect[]={0,0,0,1};
			colorSelect2[]={0,0,0,1};
			colorSelectBackground[]={1,1,1,1};
			colorSelectBackground2[]={1,1,1,1};
			rowHeight=0.028999999;
			period=0;
		};
		class M_Map: RscMapControl
		{
			moveOnEdges=0;
			x=0;
			y=0.059999999;
			w=0.75;
			h=0.94;
			iconCamera="#(argb,8,8,3)color(1,1,1,1)";
			iconCameraColor[]={0,0.60000002,0,1};
			iconCameraSize=24;
		};
	};
	class Menu
	{
		type=14;
		idc=204;
		style=0;
		x=0;
		y=0;
		w=0;
		h=0;
		colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		colorBorder[]={1,1,1,1};
		colorSeparator[]={1,1,1,1};
		colorSelectBackground[]={1,1,1,0.30000001};
		colorChecked[]={0,0,1,1};
		colorEnabled[]={1,1,1,1};
		colorDisabled[]={1,1,1,0.5};
		sizeEx=0.025;
		font="TahomaB";
	};
};
class RscDisplayEditObject
{
	idd=121;
	class Controls
	{
		class T_Background: RscText
		{
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
			x=0.02;
			y=0.079999998;
			w=0.70999998;
			h=0.89999998;
		};
		class T_Title: RscTitle
		{
			style="0x20 + 0x02";
			x=0.02;
			y=0.090000004;
			w=0.70999998;
			text="$STR_UI_EDITOR_OBJECT_PROPERTIES";
		};
		class G_ControlsGroup: RscControlsGroup
		{
			idc=101;
			x=0.02;
			y=0.15000001;
			w=0.70999998;
			h=0.73000002;
			class Controls
			{
			};
		};
		class B_OK: RscShortcutButton
		{
			idc=1;
			x=0.23;
			y=0.91500002;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_OK";
			default=1;
		};
		class B_Cancel: B_OK
		{
			idc=2;
			x=0.37;
			text="$STR_DISP_CANCEL";
			default=0;
		};
	};
	class Title: RscText
	{
		x=0.02;
		y=0;
		w=0.18000001;
		h=0.025;
		sizeEx=0.025;
		text="";
	};
	class Preview: RscText
	{
		style=48;
		x=0.02;
		y=0.029999999;
		w=0.18000001;
		h=0.23999999;
		sizeEx=0.025;
		text="";
	};
	class Edit: RscEdit
	{
		x=0.20999999;
		y=0;
		w=0.47;
		h=0.025;
		sizeEx=0.025;
		text="";
		colorSelection[]={1,1,1,0.25};
	};
	class Combo: RscCombo
	{
		x=0.20999999;
		y=0;
		w=0.47;
		h=0.025;
		wholeHeight=0.125;
		sizeEx=0.025;
	};
	class Slider: RscSliderH
	{
		x=0.20999999;
		y=0;
		w=0.47;
		h=0.025;
	};
	class Tree: RscTree
	{
		x=0.20999999;
		y=0;
		w=0.47;
		h=0.38999999;
		sizeEx=0.025;
	};
};
class RscDisplayMissionLoad
{
	idd=122;
	class Controls
	{
		class T_Background: RscText
		{
			x=0.175;
			y=0.31999999;
			w=0.40000001;
			h=0.30000001;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class T_Title: RscTitle
		{
			style="0x20 + 0x02";
			x=0.175;
			y=0.33000001;
			w=0.40000001;
			text="$STR_UI_EDITOR_LOAD_TITLE";
		};
		class T_Island: RscText
		{
			x=0.18000001;
			y=0.40000001;
			w=0.14;
			h=0.029999999;
			sizeEx=0.029999999;
			text="$STR_UI_EDITOR_LOAD_ISLAND";
		};
		class C_Island: RscCombo
		{
			idc=101;
			x=0.32499999;
			y=0.40000001;
			w=0.23999999;
			h=0.029999999;
			wholeHeight=0.23999999;
			sizeEx=0.029999999;
		};
		class T_Mission: T_Island
		{
			y=0.44999999;
			text="$STR_UI_EDITOR_LOAD_MISSION";
		};
		class C_Mission: C_Island
		{
			idc=102;
			y=0.44999999;
		};
		class B_OK: RscShortcutButton
		{
			idc=1;
			x=0.23999999;
			y=0.55000001;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_OK";
			default=1;
		};
		class B_Cancel: B_OK
		{
			idc=2;
			x=0.38;
			text="$STR_DISP_CANCEL";
			default=0;
		};
	};
};
class RscDisplayMissionSave
{
	idd=123;
	class Controls
	{
		class T_Background: RscText
		{
			x=0.175;
			y=0.31999999;
			w=0.40000001;
			h=0.30000001;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class T_Title: RscTitle
		{
			style="0x20 + 0x02";
			x=0.175;
			y=0.33000001;
			w=0.40000001;
			text="$STR_UI_EDITOR_SAVE_TITLE";
		};
		class T_Mission: RscText
		{
			x=0.18000001;
			y=0.40000001;
			w=0.14;
			h=0.029999999;
			sizeEx=0.029999999;
			text="$STR_UI_EDITOR_SAVE_MISSION";
		};
		class E_Mission: RscEdit
		{
			idc=101;
			x=0.32499999;
			y=0.40000001;
			w=0.23999999;
			h=0.029999999;
			sizeEx=0.029999999;
		};
		class T_Placement: T_Mission
		{
			y=0.44999999;
			text="$STR_UI_EDITOR_SAVE_EXPORT";
		};
		class C_Placement: RscCombo
		{
			idc=104;
			x=0.32499999;
			y=0.44999999;
			w=0.23999999;
			h=0.029999999;
			wholeHeight=0.23999999;
			sizeEx=0.029999999;
		};
		class B_OK: RscShortcutButton
		{
			idc=1;
			x=0.23999999;
			y=0.55000001;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_OK";
			default=1;
		};
		class B_Cancel: B_OK
		{
			idc=2;
			x=0.38;
			text="$STR_DISP_CANCEL";
			default=0;
		};
	};
};
class RscDisplayScriptingHelp
{
	idd=-1;
	class Controls
	{
		class Background: RscText
		{
			x=0.2;
			y=0.2;
			w=0.60000002;
			h=0.60000002;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class Content: RscHTML
		{
			idc=101;
			x=0.22;
			y=0.22;
			w=0.56;
			h=0.46000001;
			class H1
			{
				font="TahomaB";
				fontBold="TahomaB";
				sizeEx=0.039999999;
			};
			class H2
			{
				font="TahomaB";
				fontBold="TahomaB";
				sizeEx=0.027000001;
			};
			class P
			{
				font="TahomaB";
				fontBold="TahomaB";
				sizeEx=0.017999999;
			};
		};
		class Back: RscButtonSmall
		{
			idc=102;
			x=0.22;
			y=0.70999998;
			w=0.050000001;
			h=0.050000001;
			text="<-";
		};
		class Forward: RscButtonSmall
		{
			idc=103;
			x=0.28999999;
			y=0.70999998;
			w=0.050000001;
			h=0.050000001;
			text="->";
		};
		class CopyExample: RscButtonSmall
		{
			idc=104;
			x=0.46000001;
			y=0.70999998;
			w=0.15000001;
			h=0.050000001;
			text="Copy example";
		};
		class Done: RscButtonSmall
		{
			idc=2;
			x=0.63;
			y=0.70999998;
			w=0.15000001;
			h=0.050000001;
			text="$STR_DISP_CLOSE";
			default=1;
		};
	};
};
class RscDisplayCapture
{
	idd=149;
	class Controls
	{
		class Background: RscText
		{
			x=0.029999999;
			y=0.1;
			w=0.89999998;
			h=0.85000002;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
			moving=1;
		};
		class Index: RscTree
		{
			idc=101;
			x="0.03 + 0.02";
			y=0.12;
			w="0.90 - 0.04";
			h=0.40000001;
		};
		class TimeLines
		{
			type=99;
			style=0;
			idc=102;
			shadow=0;
			x="0.03 + 0.02";
			y=0.52999997;
			w="0.90 - 0.04";
			h=0.25999999;
			class Scrollbar
			{
			};
			font="TahomaB";
			colorLines[]={0,0,0,1};
			colorBackground[]={1,1,1,1};
			colorBar[]={0.80000001,0.80000001,0.80000001,1};
			colorSelection[]={1,0,0,1};
		};
		class Info: RscText
		{
			idc=106;
			x="0.03 + 0.02";
			y=0.79500002;
			w="0.90 - 0.04";
			h=0.035;
			text="Info about the selection";
			sizeEx=0.027000001;
		};
		class ZoomIn: RscShortcutButton
		{
			idc=103;
			shortcuts[]=
			{
				"0x00050000 + 2"
			};
			x=0.029999999;
			y=0.81;
			w="0.90 * 0.33";
			h=0.11;
			text="Zoom +";
		};
		class ZoomOut: RscShortcutButton
		{
			idc=104;
			shortcuts[]=
			{
				"0x00050000 + 3"
			};
			x="0.03 + 0.33 * 0.90";
			y=0.81;
			w="0.90 * 0.33";
			h=0.11;
			text="Zoom -";
		};
		class Done: RscShortcutButton
		{
			idc=2;
			shortcuts[]=
			{
				"0x00050000 + 1"
			};
			x="0.03 + 0.66 * 0.90";
			y=0.81;
			w="0.90 * 0.33";
			h=0.11;
			text="$STR_DISP_CLOSE";
		};
		class Export: RscShortcutButton
		{
			idc=105;
			shortcuts[]=
			{
				"0x00050000 + 11"
			};
			x=0.029999999;
			y=0.86500001;
			w="0.90 * 0.33";
			h=0.11;
			text="Copy";
		};
		class ExportAll: RscShortcutButton
		{
			idc=107;
			shortcuts[]={};
			x="0.03 + 0.33 * 0.90";
			y=0.86500001;
			w="0.90 * 0.33";
			h=0.11;
			text="Copy All";
		};
		class ImportAll: RscShortcutButton
		{
			idc=108;
			shortcuts[]={};
			x="0.03 + 0.66 * 0.90";
			y=0.86500001;
			w="0.90 * 0.33";
			h=0.11;
			text="Paste All";
		};
		class ButtonAverages: RscShortcutButton
		{
			idc=110;
			shortcuts[]={};
			text="Averages";
			x=0.029999999;
			y=1.5;
			w="0.90 * 0.33";
			h=0.60000002;
		};
		class ButtonSavePreviousData: RscShortcutButton
		{
			idc=111;
			shortcuts[]={};
			text="Save archive";
			x="0.03 + 0.33 * 0.90";
			y=1.5;
			w="0.90 * 0.33";
			h=0.60000002;
		};
		class ButtonPreviousData: RscShortcutButton
		{
			idc=109;
			shortcuts[]={};
			text="Show archived";
			x="0.03 + 0.66 * 0.90";
			y=1.5;
			w="0.90 * 0.33";
			h=0.60000002;
		};
	};
};
class RscDisplayInterruptEditorPreview: RscStandardDisplay
{
	idd=49;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_INT_TITLE";
		};
		class B_Edit2D: RscButton
		{
			idc=113;
			x=0.34999999;
			y=0.2;
			h=0.079999998;
			text="$STR_UI_EDITOR_INT_EDIT2D";
			default=0;
		};
		class B_Edit3D: B_Edit2D
		{
			idc=114;
			y=0.28;
			text="$STR_UI_EDITOR_INT_EDIT3D";
		};
		class B_Restart: B_Edit2D
		{
			idc=105;
			y=0.36000001;
			text="$STR_UI_EDITOR_RESTART";
		};
		class B_Options: B_Edit2D
		{
			idc=101;
			y=0.51999998;
			text="$STR_DISP_INT_OPTIONS";
		};
		class B_Quit: B_Edit2D
		{
			idc=104;
			y=0.68000001;
			text="$STR_UI_EDITOR_INT_QUIT";
		};
		class B_Cancel: B_Edit2D
		{
			idc=2;
			y=0.75999999;
			text="$STR_UI_EDITOR_INT_CONTINUE";
			default=1;
		};
	};
};
class RscDisplayInterruptEditor3D: RscStandardDisplay
{
	idd=49;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_INT_3DEDIT_TITLE";
		};
		class B_Edit2D: RscButton
		{
			idc=113;
			x=0.34999999;
			y=0.2;
			h=0.079999998;
			text="$STR_UI_EDITOR_INT_EDIT2D";
			default=0;
		};
		class B_Preview: B_Edit2D
		{
			idc=115;
			y=0.28;
			text="$STR_DISP_ARCMAP_PREVIEW";
		};
		class B_Restart: B_Edit2D
		{
			idc=105;
			y=0.36000001;
			text="$STR_UI_EDITOR_RESTART";
		};
		class B_Options: B_Edit2D
		{
			idc=101;
			y=0.51999998;
			text="$STR_DISP_INT_OPTIONS";
		};
		class B_Quit: B_Edit2D
		{
			idc=104;
			y=0.68000001;
			text="$STR_UI_EDITOR_INT_QUIT";
		};
		class B_Cancel: B_Edit2D
		{
			idc=2;
			y=0.75999999;
			text="$STR_UI_EDITOR_INT_CONTINUE";
			default=1;
		};
	};
};
class RscDisplayAddonActions
{
	idd=156;
	class Controls
	{
		class T_Background: RscText
		{
			x=0.175;
			y=0.31999999;
			w=0.40000001;
			h=0.30000001;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class T_Title: RscTitle
		{
			style="0x20 + 0x02";
			x=0.175;
			y=0.33000001;
			w=0.40000001;
			text="$STR_DISP_ADDON_ACTIONS_TITLE";
		};
		class T_Actions: RscText
		{
			x=0.18000001;
			y=0.40000001;
			w=0.14;
			h=0.029999999;
			sizeEx=0.029999999;
			text="$STR_DISP_ADDON_ACTIONS_ACTIONS";
		};
		class C_Actions: RscCombo
		{
			idc=101;
			x=0.32499999;
			y=0.40000001;
			w=0.23999999;
			h=0.029999999;
			wholeHeight=0.23999999;
			sizeEx=0.029999999;
		};
		class B_OK: RscShortcutButton
		{
			idc=1;
			x=0.23999999;
			y=0.55000001;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_OK";
			default=1;
		};
		class B_NewMod: B_OK
		{
			idc=102;
			x=0.51999998;
			text="New Mod";
			default=0;
		};
		class B_Cancel: B_OK
		{
			idc=2;
			x=0.38;
			text="$STR_DISP_CANCEL";
			default=0;
		};
	};
};
class RscDisplayNewMod: RscStandardDisplay
{
	idd=158;
	class Controls
	{
		class Title: RscTitle
		{
			text="Install New Mod";
		};
		class TextName: RscText
		{
			x=0.025;
			y=0.12;
			w=0.30000001;
			text="Mod name";
		};
		class ValueName: RscEdit
		{
			idc=101;
			x=0.34999999;
			y=0.12;
			w=0.40000001;
		};
		class TextDir: RscText
		{
			x=0.025;
			y=0.22;
			w=0.30000001;
			text="Mod directory";
		};
		class ValueDir: RscEdit
		{
			idc=102;
			x=0.34999999;
			y=0.22;
			w=0.40000001;
		};
		class B_Cancel: RscShortcutButton
		{
			idc=2;
			text="$STR_DISP_CANCEL";
			x=0.5;
			y=0.89999998;
			w=0.25;
			h=0.1;
		};
		class B_OK: B_Cancel
		{
			idc=1;
			text="$STR_DISP_OK";
			x=0.75;
			default=1;
		};
	};
};
class RscDisplayUavTerminalWaypointMenu
{
	type=14;
	idc=108;
	style=0;
	x=0;
	y=0;
	w=0;
	h=0;
	colorBackground[]={0.30000001,0.30000001,0.30000001,1};
	colorBorder[]={1,1,1,1};
	colorSeparator[]={1,1,1,1};
	colorSelectBackground[]={1,1,1,0.30000001};
	colorChecked[]={0,0,1,1};
	colorEnabled[]={1,1,1,1};
	colorDisabled[]={1,1,1,0.5};
	sizeEx=0.025;
	font="TahomaB";
};
class RscDisplayInsertMarker
{
	idd=54;
	movingEnable=0;
	class controls
	{
		class Picture: RscPicture
		{
			idc=102;
			x=0;
			y=0;
			w=0.050000001;
			h="0.05 * 4 / 3";
			colorText[]={0,0,0,1};
		};
		class Text: RscEdit
		{
			idc=101;
			x=0.039999999;
			y=0;
			w=0.15000001;
			h=0.039999999;
			text="";
		};
		class ButtonOK: RscActiveText
		{
			idc=1;
			x=0;
			y=0;
			w=0;
			h=0;
			default=1;
		};
	};
};
class RscDisplayPhysX3Debug
{
	idd=157;
	movingEnable=1;
	class Controls
	{
		class Background1: RscText
		{
			x="SafezoneX+0.1";
			y="SafezoneY+0.0";
			w="SafezoneW-0.2";
			h="SafeZoneH";
			colorBackground[]={0,0,0,0.75};
		};
		class Background2: RscText
		{
			x=0.1;
			y="SafezoneY+0.0";
			w=0.80000001;
			h="SafeZoneH";
			colorBackground[]={1,1,1,0.025};
		};
		class Title: RscTitle
		{
			x="SafezoneX+0.1";
			y="SafezoneY+0.02";
			w="SafezoneW-0.2";
			h=0.035;
			moving=1;
			text="PhysX3 Debug Console";
			sizeEx=0.027000001;
			colorBackground[]={0.30000001,0,0,1};
			colorText[]={0.89999998,0.89999998,0.89999998,1};
		};
		class B_OK: RscButton
		{
			idc=1;
			x=0.5;
			y=0.917;
			text="Close";
			sizeEx=0.027000001;
			default=1;
		};
		class Value: RscButton
		{
			idc=101;
			x=0.2;
			y=0.0099999998;
			w=0.050000001;
			h=0.021;
			text="on";
			sizeEx=0.027000001;
		};
		class Caption: RscText
		{
			x=0.25;
			y=0.0099999998;
			w=0.40000001;
			h=0.021;
			sizeEx=0.027000001;
			colorText[]={0.89999998,0.89999998,0.89999998,1};
			text="diag mode";
		};
		class Value00: Value
		{
			idc=102;
			y=0.032000002;
		};
		class Caption00: Caption
		{
			y=0.032000002;
			text="diag mode draw";
		};
		class Value000: Value
		{
			idc=192;
			y=0.054000001;
		};
		class Caption000: Caption
		{
			y=0.054000001;
			text="diag mode perf";
		};
		class Value0000: Value
		{
			idc=193;
			y=0.075999998;
		};
		class Caption0000: Caption
		{
			y=0.075999998;
			text="diag mode stats";
		};
		class ValueDS: Value
		{
			idc=194;
			y=0.0099999998;
			x=0.60000002;
		};
		class CaptionDS: Caption
		{
			y=0.0099999998;
			x=0.64999998;
			text="diag immediate fetch";
		};
		class Value0: Value
		{
			idc=103;
			y=0.12;
		};
		class Caption0: Caption
		{
			y=0.12;
			text="terrain";
		};
		class Value1: Value
		{
			idc=104;
			y=0.142;
		};
		class Caption1: Caption
		{
			y=0.142;
			text="static";
		};
		class Value2: Value
		{
			idc=105;
			y=0.164;
		};
		class Caption2: Caption
		{
			y=0.164;
			text="kinematic";
		};
		class Value3: Value
		{
			idc=106;
			y=0.186;
		};
		class Caption3: Caption
		{
			y=0.186;
			text="dynamic";
		};
		class Value5: Value
		{
			idc=150;
			y=0.23;
		};
		class Caption5: Caption
		{
			y=0.23;
			text="world axes";
		};
		class Value6: Value
		{
			idc=151;
			y=0.252;
		};
		class Caption6: Caption
		{
			y=0.252;
			text="body axes";
		};
		class Value7: Value
		{
			idc=152;
			y=0.27399999;
		};
		class Caption7: Caption
		{
			y=0.27399999;
			text="body mass axes";
		};
		class Value8: Value
		{
			idc=153;
			y=0.296;
		};
		class Caption8: Caption
		{
			y=0.296;
			text="body lin velocity";
		};
		class Value9: Value
		{
			idc=154;
			y=0.31799999;
		};
		class Caption9: Caption
		{
			y=0.31799999;
			text="body ang velocity";
		};
		class Value10: Value
		{
			idc=155;
			y=0.34;
		};
		class Caption10: Caption
		{
			y=0.34;
			text="body joint groups";
		};
		class Value11: Value
		{
			idc=156;
			y=0.36199999;
		};
		class Caption11: Caption
		{
			y=0.36199999;
			text="contact points";
		};
		class Value12: Value
		{
			idc=157;
			y=0.384;
		};
		class Caption12: Caption
		{
			y=0.384;
			text="contact normals";
		};
		class Value13: Value
		{
			idc=158;
			y=0.40599999;
		};
		class Caption13: Caption
		{
			y=0.40599999;
			text="contact errors";
		};
		class Value14: Value
		{
			idc=159;
			y=0.428;
		};
		class Caption14: Caption
		{
			y=0.428;
			text="contact forces";
		};
		class Value15: Value
		{
			idc=160;
			y=0.44999999;
		};
		class Caption15: Caption
		{
			y=0.44999999;
			text="actor axes";
		};
		class Value16: Value
		{
			idc=161;
			y=0.472;
		};
		class Caption16: Caption
		{
			y=0.472;
			text="collision AABBs";
		};
		class Value17: Value
		{
			idc=162;
			y=0.49399999;
		};
		class Caption17: Caption
		{
			y=0.49399999;
			text="collision shapes";
		};
		class Value18: Value
		{
			idc=163;
			y=0.51599997;
		};
		class Caption18: Caption
		{
			y=0.51599997;
			text="collision axes";
		};
		class Value19: Value
		{
			idc=164;
			y=0.53799999;
		};
		class Caption19: Caption
		{
			y=0.53799999;
			text="collision compounds";
		};
		class Value20: Value
		{
			idc=165;
			y=0.56;
		};
		class Caption20: Caption
		{
			y=0.56;
			text="collision face normals";
		};
		class Value21: Value
		{
			idc=166;
			y=0.58200002;
		};
		class Caption21: Caption
		{
			y=0.58200002;
			text="collision edges";
		};
		class Value22: Value
		{
			idc=167;
			y=0.60399997;
		};
		class Caption22: Caption
		{
			y=0.60399997;
			text="collision static";
		};
		class Value23: Value
		{
			idc=168;
			y=0.62599999;
		};
		class Caption23: Caption
		{
			y=0.62599999;
			text="collision dynamic";
		};
		class Value24: Value
		{
			idc=169;
			y=0.648;
		};
		class Caption24: Caption
		{
			y=0.648;
			text="collision pairs";
		};
		class Value25: Value
		{
			idc=170;
			y=0.67000002;
		};
		class Caption25: Caption
		{
			y=0.67000002;
			text="joint local axes";
		};
		class Value26: Value
		{
			idc=171;
			y=0.69199997;
		};
		class Caption26: Caption
		{
			y=0.69199997;
			text="joint limits";
		};
		class Value27: Value
		{
			idc=172;
			y=0.71399999;
		};
		class Caption27: Caption
		{
			y=0.71399999;
			text="particle system positions";
		};
		class Value28: Value
		{
			idc=173;
			y=0.736;
		};
		class Caption28: Caption
		{
			y=0.736;
			text="particle system velocities";
		};
		class Value29: Value
		{
			idc=174;
			y=0.75800002;
		};
		class Caption29: Caption
		{
			y=0.75800002;
			text="particle system bounds";
		};
		class Value30: Value
		{
			idc=175;
			y=0.77999997;
		};
		class Caption30: Caption
		{
			y=0.77999997;
			text="particle system grid";
		};
		class Value31: Value
		{
			idc=176;
			y=0.80199999;
		};
		class Caption31: Caption
		{
			y=0.80199999;
			text="particle system broad phase bounds";
		};
		class Value32: Value
		{
			idc=177;
			y=0.824;
		};
		class Caption32: Caption
		{
			y=0.824;
			text="particle system max motion distance";
		};
		class ValueAll: Value
		{
			idc=190;
			text="All";
			y=0.86799997;
		};
		class ValueNone: Value
		{
			idc=191;
			text="None";
			y=0.88999999;
		};
		class ValueBasic: Value
		{
			idc=198;
			text="Basic";
			y=0.912;
		};
	};
};
class RscDisplayDebug
{
	idd=56;
	movingEnable=1;
	onLoad="private [""_ctrlB_Camera"", ""_script""]; _ctrlB_Camera = (_this select 0) displayCtrl 666; _script = getText (configFile >> ""cameraScript""); if (!(isNil ""BIS_DEBUG_CAM"") || ((typeOf cameraOn) == ""EditCursor"") || (isNull player) || (_script == """")) then {_ctrlB_Camera ctrlEnable false; _ctrlB_Camera ctrlShow false}";
	class Controls
	{
		class Background1: RscText
		{
			x="SafezoneX+0.1";
			y="SafezoneY+0.0";
			w="SafezoneW-0.2";
			h="SafeZoneH";
			colorBackground[]={0,0,0,0.75};
		};
		class Background2: RscText
		{
			x=0.1;
			y="SafezoneY+0.0";
			w=0.80000001;
			h="SafeZoneH";
			colorBackground[]={1,1,1,0.025};
		};
		class Title: RscTitle
		{
			x="SafezoneX+0.1";
			y="SafezoneY+0.02";
			w="SafezoneW-0.2";
			h=0.035;
			moving=1;
			text="$STR_UI_DEBUG_TITLE";
			sizeEx=0.027000001;
			colorBackground[]={0.30000001,0,0,1};
			colorText[]={0.89999998,0.89999998,0.89999998,1};
		};
		class G_Expression: RscControlsGroup
		{
			x="SafezoneX+0.1";
			y="SafezoneY+0.055";
			w="SafezoneW-0.2";
			h=0.23;
			class VScrollbar
			{
				color[]={0,0,0,0};
				width=0.001;
				autoScrollSpeed=-1;
				autoScrollDelay=5;
				autoScrollRewind=0;
			};
			class HScrollbar
			{
				color[]={0,0,0,0};
				height=0.001;
			};
			class ScrollBar: ScrollBar
			{
			};
			class Controls
			{
				class TextExpression: RscText
				{
					x=0.0099999998;
					y=0;
					w=0.2;
					h=0.029999999;
					sizeEx=0.027000001;
					text="$STR_UI_DEBUG_EXPRESSION";
				};
				class ValueExpression: RscEdit
				{
					idc=101;
					style=16;
					x=0.017999999;
					y=0.029999999;
					w="SafezoneW-1+0.76";
					h=0.16;
					sizeEx=0.027000001;
					colorBackground[]={0,0,0,1};
					colorSelection[]={0,0.40000001,0,1};
					autocomplete="scripting";
				};
				class B_Apply: RscButton
				{
					idc=102;
					x="0.018+0.1";
					y=0.19499999;
					w="SafezoneW-1+0.76-0.1";
					h=0.029999999;
					sizeEx=0.027000001;
					text="$STR_UI_DEBUG_BUT_APPLY";
					default=0;
				};
			};
		};
		class G_Watch: G_Expression
		{
			x="SafezoneX+0.1";
			y="SafezoneY+0.262";
			w="SafezoneW-0.2";
			h=0.36000001;
			class Controls
			{
				class TextWatch: RscText
				{
					x=0.0099999998;
					y=0;
					w=0.1;
					h=0.029999999;
					sizeEx=0.027000001;
					text="$STR_UI_DEBUG_WATCH";
				};
				class TextVar1: RscText
				{
					x=0.0099999998;
					y=0.029999999;
					w=0.050000001;
					h=0.029999999;
					sizeEx=0.027000001;
					text="$STR_UI_DEBUG_1";
				};
				class ValueExp1: RscEdit
				{
					idc=121;
					x=0.039999999;
					y=0.029999999;
					w="SafezoneW-1+0.738";
					h=0.029999999;
					sizeEx=0.027000001;
					colorSelection[]={0,0.40000001,0,1};
					autocomplete="scripting";
				};
				class ValueRes1: RscEdit
				{
					idc=141;
					style=16;
					x=0.017999999;
					y=0.059999999;
					w="SafezoneW-1+0.76";
					h=0.052000001;
					lineSpacing=1;
					sizeEx=0.027000001;
					autocomplete="scripting";
				};
				class TextVar2: TextVar1
				{
					y=0.113;
					text="$STR_UI_DEBUG_2";
				};
				class ValueExp2: ValueExp1
				{
					idc=122;
					y=0.113;
				};
				class ValueRes2: ValueRes1
				{
					idc=142;
					y=0.14300001;
				};
				class TextVar3: TextVar1
				{
					y=0.19599999;
					text="$STR_UI_DEBUG_3";
				};
				class ValueExp3: ValueExp1
				{
					idc=123;
					y=0.19599999;
				};
				class ValueRes3: ValueRes1
				{
					idc=143;
					y=0.226;
				};
				class TextVar4: TextVar1
				{
					y=0.27900001;
					text="$STR_UI_DEBUG_4";
				};
				class ValueExp4: ValueExp1
				{
					idc=124;
					y=0.27900001;
				};
				class ValueRes4: ValueRes1
				{
					idc=144;
					y=0.30899999;
				};
			};
		};
		class G_But: G_Expression
		{
			x="SafezoneX+0.1";
			y="SafezoneY+0.64";
			w="SafezoneW-0.2";
			h=0.12;
			class Controls
			{
				class TextSwitch: RscText
				{
					x="(-SafeZoneX)+0.01";
					y=0;
					w=0.1;
					h=0.029999999;
					sizeEx=0.027000001;
					text="$STR_UI_DEBUG_SWITCH";
				};
				class ButtonA1: RscButton
				{
					idc=-1;
					x="(-SafeZoneX)+0.01 + 0.083	* 1";
					y=0;
					w=0.079999998;
					h=0.039999999;
					text="$STR_UI_DEBUG_BUT_ALL";
					action="""all"" diag_enable true";
					sizeEx=0.027000001;
				};
				class ButtonA2: ButtonA1
				{
					x="(-SafeZoneX)+0.01 + 0.083 * 2";
					text="$STR_UI_DEBUG_BUT_NO";
					action="""all"" diag_enable false";
				};
				class ButtonA3: ButtonA1
				{
					x="(-SafeZoneX)+0.01 + 0.083 * 3";
					text="$STR_UI_DEBUG_BUT_COMBAT";
					action="diag_toggle ""combat""";
				};
				class ButtonA4: ButtonA1
				{
					x="(-SafeZoneX)+0.01 + 0.083 * 4";
					text="$STR_UI_DEBUG_BUT_COST";
					action="diag_toggle ""costmap""";
				};
				class ButtonA5: ButtonA1
				{
					x="(-SafeZoneX)+0.01 + 0.083 * 5";
					text="$STR_UI_DEBUG_BUT_TRANSPARENT";
					action="diag_toggle ""transparent""";
				};
				class ButtonA6: ButtonA1
				{
					x="(-SafeZoneX)+0.01 + 0.083 * 6";
					text="$STR_UI_DEBUG_BUT_COLLISION";
					action="diag_toggle ""collision""";
				};
				class ButtonA7: ButtonA1
				{
					x="(-SafeZoneX)+0.01 + 0.083 * 7";
					text="$STR_UI_DEBUG_BUT_PATH";
					action="diag_toggle ""path""";
				};
				class B_Functions: ButtonA1
				{
					x="(-SafeZoneX)+0.01 + 0.083 * 8";
					text="Functions";
					action="[] spawn {if (isnil 'bis_fnc_init') then {createcenter sidelogic; _logicGrp = creategroup sidelogic; _logicFnc = _logicGrp createunit ['FunctionsManager',[1,1,1],[],0,'none']}; waituntil {!isnil 'bis_fnc_init'};[] call bis_fnc_help}";
					onButtonClick="(ctrlParent (_this select 0)) closeDisplay 2";
				};
				class ButtonA8: ButtonA1
				{
					x="(-SafeZoneX)+0.01 + 0.083 * 1";
					y=0.041000001;
					text="$STR_UI_DEBUG_BUT_FORCE";
					action="diag_toggle ""force""";
				};
				class ButtonA9: ButtonA8
				{
					x="(-SafeZoneX)+0.01 + 0.083 * 2";
					text="$STR_UI_DEBUG_BUT_ANIMATION";
					action="diag_toggle ""animation""";
				};
				class ButtonB1: ButtonA8
				{
					idc=-1;
					x="(-SafeZoneX)+0.01 + 0.083 * 3";
					text="$STR_UI_DEBUG_BUT_NORMAL";
					action="diag_drawmode ""Normal""";
					sizeEx=0.027000001;
				};
				class ButtonB2: ButtonA8
				{
					x="(-SafeZoneX)+0.01 + 0.083 * 4";
					text="$STR_UI_DEBUG_BUT_FIREGEOMETRY";
					action="diag_drawmode ""FireGeometry""";
				};
				class ButtonB3: ButtonA8
				{
					x="(-SafeZoneX)+0.01 + 0.083 * 5";
					text="$STR_UI_DEBUG_BUT_VIEWGEOMETRY";
					action="diag_drawmode ""ViewGeometry""";
				};
				class ButtonB4: ButtonA8
				{
					x="(-SafeZoneX)+0.01 + 0.083 * 6";
					text="$STR_UI_DEBUG_BUT_GEOMETRY";
					action="diag_drawmode ""Geometry""";
				};
				class B_ConfigViewer: ButtonA8
				{
					x="(-SafeZoneX)+0.01 + 0.083 * 7";
					text="Config";
					action="[] spawn {if (isnil 'bis_fnc_init') then {createcenter sidelogic; _logicGrp = creategroup sidelogic; _logicFnc = _logicGrp createunit ['FunctionsManager',[1,1,1],[],0,'none']}; waituntil {!isnil 'bis_fnc_init'};[] call bis_fnc_configviewer}";
					onButtonClick="(ctrlParent (_this select 0)) closeDisplay 2";
				};
				class B_Camera: ButtonA8
				{
					idc=666;
					x="(-SafeZoneX)+0.01 + 0.083 * 8";
					text="Camera";
					action="cameraOn exec (getText (configFile >> ""cameraScript""))";
					onButtonClick="(ctrlParent (_this select 0)) closeDisplay 2";
				};
			};
		};
		class G_Log: G_Expression
		{
			x=0.1;
			y="SafeZoneY+0.74";
			w=0.64999998;
			h="0.29+(SafeZoneH-1)";
			class Controls
			{
				class TextFilter: RscText
				{
					x=0.0099999998;
					y=0;
					w=0.1;
					h=0.029999999;
					sizeEx=0.027000001;
					text="Log Filter:";
				};
				class ValueRes1: RscEdit
				{
					idc=152;
					style=16;
					x=0.017999999;
					y=0.027000001;
					w=0.63;
					h=0.029999999;
					lineSpacing=1;
					sizeEx=0.027000001;
				};
				class TextLog: RscText
				{
					x=0.0099999998;
					y=0.07;
					w=0.1;
					h=0.029999999;
					sizeEx=0.027000001;
					text="$STR_UI_DEBUG_LOG";
				};
				class ValueLog: RscListBox
				{
					idc=103;
					sizeEx=0.027000001;
					x=0.017999999;
					y=0.1;
					w=0.63;
					h="0.13+(SafeZoneH-1)";
					colorSelect[]={1,1,1,1};
					colorSelect2[]={1,1,1,1};
					colorSelectBackground[]={0,0.40000001,0,1};
					colorSelectBackground2[]={0,0.40000001,0,1};
					rowHeight=0.028571401;
				};
			};
		};
		class B_Clear: RscShortcutButton
		{
			idc=151;
			x=0.77499998;
			y=0.80299997;
			w=0.15000001;
			h=0.039999999;
			text="Clear";
			sizeEx=0.027000001;
			default=0;
		};
		class B_OK: RscShortcutButton
		{
			idc=1;
			x=0.77499998;
			y=0.875;
			w=0.15000001;
			h=0.039999999;
			text="$STR_DISP_OK";
			default=1;
		};
		class B_Cancel: RscShortcutButton
		{
			idc=2;
			x=0.77499998;
			y=0.917;
			w=0.15000001;
			h=0.039999999;
			text="$STR_DISP_CANCEL";
			default=0;
		};
	};
};
class RscChatListDefault
{
	x=0;
	y=0;
	w=1;
	h=0.043000001;
	font="TahomaB";
	size=0.039000001;
	rows=2;
	colorBackground[]={0,0,0,0.5};
	colorGlobalChannel[]={0.80000001,0.80000001,0.80000001,1};
	colorGlobalChannelPlayerBackground[]={0.80000001,0.80000001,0.80000001,0.5};
	colorGlobalChannelPlayerText[]={0,0,0,1};
	colorSideChannel[]={0,0.89999998,0.89999998,1};
	colorSideChannelPlayerBackground[]={0,0.89999998,0.89999998,0.5};
	colorSideChannelPlayerText[]={0,0,0,1};
	colorCommandChannel[]={0,0,1,1};
	colorCommandChannelPlayerBackground[]={0,0,1,0.5};
	colorCommandChannelPlayerText[]={0,0,0,1};
	colorGroupChannel[]={0.1,0.89999998,0.2,1};
	colorGroupChannelPlayerBackground[]={0.1,0.89999998,0.2,0.5};
	colorGroupChannelPlayerText[]={0,0,0,1};
	colorVehicleChannel[]={0.89999998,0.80000001,0,1};
	colorVehicleChannelPlayerBackground[]={0.89999998,0.80000001,0,0.5};
	colorVehicleChannelPlayerText[]={0,0,0,1};
	colorDirectChannel[]={0.89999998,0,0.80000001,1};
	colorDirectChannelPlayerBackground[]={0.89999998,0,0.80000001,0.5};
	colorDirectChannelPlayerText[]={0,0,0,1};
	colorPlayerChannel[]={1,1,1,1};
	colorPlayerChannelPlayerBackground[]={1,1,1,0.5};
	colorPlayerChannelPlayerText[]={0,0,0,1};
	colorMessage[]={1,1,1,1};
	colorMessageProtocol[]={0.5,0.5,0.5,1};
	shadow=2;
	shadowPlayer=0;
	shadowColor[]={0,0,0,1};
};
class RscChatListMission: RscChatListDefault
{
	x=0;
	y=0.80000001;
	w=1;
	rows=5;
};
class RscChatListBriefing: RscChatListDefault
{
	x=0;
	y=0.80000001;
	w=1;
	rows=2;
};
class RscChatListMap: RscChatListDefault
{
	x=0;
	y=0.80000001;
	w=1;
	rows=2;
};
class RscTitlesText
{
	access=0;
	fontBasic="TahomaB";
	sizeExBasic="( 21 / 408 )";
	fontDown="TahomaB";
	sizeExDown="( 21 / 408 )";
	offsetDown=0.245;
	class Attributes
	{
		shadow=1;
		shadowOffset=0.059999999;
		shadowColor="#000000";
	};
};
class RscIGText: RscText
{
	access=0;
	h=0.039999999;
	colorText[]={0.80000001,0.80000001,0.80000001,1};
	font="TahomaB";
	sizeEx=0.024;
	style="0x00 + 0x100";
};
class RscIGProgress: RscProgress
{
	style=0;
	h=0.017999999;
	colorFrame[]={0.80000001,0.80000001,0.80000001,0.75};
	colorBar[]={0.80000001,0.80000001,0.80000001,0.5};
	texture="#(argb,8,8,3)color(0,1,0,1)";
};
class RscDisplayHintC
{
	access=0;
	idd=57;
	movingEnable=1;
	class controls
	{
		class Background: RscText
		{
			idc=101;
			style=128;
			moving=1;
			x=0.34999999;
			y=0.40000001;
			w=0.5;
			h=0.059999999;
			text="";
			colorBackground[]={0.2,0.15000001,0.1,0.80000001};
			colorText[]={0,0,0,0};
			font="TahomaB";
			sizeEx=0;
			fixedWidth=0;
		};
		class Hint: RscIGText
		{
			idc=102;
			style=16;
			lineSpacing=1;
			sizeEx="( 16 / 408 )";
			x=0.36000001;
			y=0.41;
			w=0.47999999;
			colorBackground[]={0,0,0,0};
			text="STR_DISP_ERROR";
		};
		class continue: RscShortcutButton
		{
			idc=2;
			x=0.55000001;
			y=0.41;
			w=0.30000001;
			h=0.035;
			text="$STR_DISP_HINTC_CONTINUE";
		};
	};
};
class RscDisplayHintCEx
{
	access=0;
	idd=72;
	movingEnable=1;
	soundOpen[]=
	{
		"",
		0.5,
		1
	};
	indent="#(argb,8,8,3)color(1,1,1,1)";
	class controls
	{
		class Background: RscText
		{
			idc=101;
			style=128;
			moving=1;
			x=0.15000001;
			y=0.40000001;
			w=0.69999999;
			h=0.155;
			text="";
			colorBackground[]={0.2,0.15000001,0.1,0.80000001};
			colorText[]={0,0,0,0};
			font="TahomaB";
			sizeEx=0;
			fixedWidth=0;
		};
		class Title: RscText
		{
			idc=103;
			style=0;
			x=0.17;
			y=0.41999999;
			w=0.66000003;
			h=0.059999999;
			text="STR_DISP_ERROR";
			colorText[]={0.80000001,0.80000001,0.80000001,1};
			font="TahomaB";
			sizeEx="( 21 / 408 )";
		};
		class Line1: RscText
		{
			idc=105;
			style=176;
			x=0.17;
			y=0.47999999;
			w=0.66000003;
			h=0;
			text="";
			colorBackground[]={0.80000001,0.80000001,0.80000001,1};
			colorText[]={1,1,1,1};
		};
		class Hint: RscStructuredText
		{
			idc=102;
			style=0;
			x=0.17;
			y=0.47999999;
			w=0.66000003;
			h=0;
			size="( 16 / 408 )";
			text="STR_DISP_ERROR";
			class Attributes
			{
				font="TahomaB";
				color="#e0e0e0";
				shadow=0;
			};
		};
		class Line2: RscText
		{
			idc=106;
			style=176;
			x=0.17;
			y=0.47999999;
			w=0.66000003;
			h=0;
			text="";
			colorBackground[]={0.80000001,0.80000001,0.80000001,1};
			color[]={0.80000001,0.80000001,0.80000001,1};
			colorText[]={0.80000001,0.80000001,0.80000001,1};
		};
		class continue: RscActiveText
		{
			idc=104;
			style=1;
			font="TahomaB";
			sizeEx="( 16 / 408 )";
			x=0.17;
			y=0.49000001;
			w=0.66000003;
			h=0.035;
			text="$STR_DISP_HINTC_CONTINUE";
			color[]={0.80000001,0.80000001,0.80000001,1};
			colorActive[]={0.80000001,0.80000001,0,1};
		};
	};
};
class RscInGameUI
{
	access=0;
	colorReady[]={1,1,1,1};
	colorReadyWest[]={1,1,1,1};
	colorReadyEast[]={1,1,1,1};
	colorReadyIndependent[]={1,1,1,1};
	colorReadyCivilian[]={1,1,1,1};
	colorPrepare[]={0.69,0.69999999,0.1,1};
	colorUnload[]={0.75,0.28999999,0.28999999,1};
	class RscUnitInfo
	{
		idd=300;
		movingEnable=0;
		controls[]=
		{
			"Background",
			"Background2",
			"Hitzones",
			"ValueFuel",
			"Speed",
			"Alt",
			"TextArmor",
			"TextFuel",
			"Weapon",
			"Ammo",
			"AmmoCount",
			"MagCount",
			"Heading"
		};
		class Background: RscText
		{
			idc=124;
			style=128;
			x=0;
			y=0.138;
			w=0.33000001;
			h=0.090000004;
			text="";
			colorBackground[]={0.2,0.15000001,0.1,0.80000001};
			colorText[]={0,0,0,0};
			font="TahomaB";
			sizeEx=0;
			fixedWidth=0;
		};
		class Background2: RscText
		{
			idc=124;
			style=128;
			x=0.67000002;
			y=0.138;
			w=0.33000001;
			h=0.090000004;
			text="";
			colorBackground[]={0.2,0.15000001,0.1,0.80000001};
			colorText[]={0,0,0,0};
			font="TahomaB";
			sizeEx=0;
			fixedWidth=0;
		};
		class Speed: RscIGText
		{
			idc=121;
			x=0.0049999999;
			y=0.145;
			w=0.2;
			text="$STR_DISP_ERROR";
		};
		class Alt: RscIGText
		{
			idc=122;
			style="0x01+0x100";
			x=0.16;
			y=0.145;
			w=0.16;
			text="$STR_DISP_ERROR";
		};
		class TextArmor: RscIGText
		{
			x=0.68000001;
			y=0.145;
			w=0.19;
			text="$STR_UI_ABAR";
		};
		class Hitzones: RscHitZones
		{
			idc=111;
			x=0.81999999;
			y=0.155;
			w=0.16500001;
			h=0.025;
		};
		class TextFuel: RscIGText
		{
			x=0.68000001;
			y=0.185;
			w=0.19;
			text="$STR_UI_FBAR";
		};
		class ValueFuel: RscIGProgress
		{
			idc=113;
			x=0.81999999;
			y=0.19;
			w=0.16500001;
			h=0.025;
		};
		class ValueReload: RscIGProgress
		{
			idc=154;
			x=0.92000002;
			y=0.19;
			w=0.16500001;
			h=0.025;
		};
		class Weapon: RscIGText
		{
			idc=118;
			x=0.0049999999;
			y=0.185;
			w=0.25;
			text="$STR_DISP_ERROR";
		};
		class Ammo: RscIGText
		{
			idc=119;
			style="0x01 + 0x100";
			x=0.17;
			y=0.19;
			w=0.15000001;
			text="$STR_DISP_ERROR";
		};
		class AmmoCount: RscIGText
		{
			idc=184;
			style="0x01 + 0x100";
			x=0.31999999;
			y=0.19;
			w=0.15000001;
			text="$STR_DISP_ERROR";
		};
		class MagCount: RscIGText
		{
			idc=185;
			style="0x01 + 0x100";
			x=0.17;
			y=0.19;
			w=0.15000001;
			text="$STR_DISP_ERROR";
		};
		class Heading: RscIGText
		{
			idc=148;
			style="0x00	+ 0x100";
			x=0.017000001;
			y=0.0099999998;
			w=0.17;
		};
	};
	class RscUnitInfoSoldier: RscUnitInfo
	{
		idd=300;
		movingEnable=0;
		controls[]=
		{
			"Background",
			"Weapon",
			"Ammo",
			"AmmoCount",
			"MagCount",
			"GUI_Body",
			"GUI_Bleeding0",
			"GUI_Bleeding0",
			"GUI_InjuredHead0",
			"GUI_InjuredHead1",
			"GUI_InjuredLegs0",
			"GUI_InjuredLegs1",
			"GUI_InjuredLegs2",
			"GUI_InjuredHands0",
			"GUI_InjuredHands1",
			"GUI_InjuredHands2"
		};
		class Background: RscText
		{
			idc=124;
			style=128;
			x=0;
			y=0;
			w=0.38499999;
			h=0.050000001;
			text="";
			colorBackground[]={0.2,0.15000001,0.1,0.80000001};
			colorText[]={0,0,0,0};
			font="TahomaB";
			sizeEx="( 16 / 408 )";
			fixedWidth=0;
		};
		class Weapon: RscIGText
		{
			idc=118;
			x=0;
			y=0.0080000004;
			w=0.28200001;
			text="$STR_DISP_ERROR";
		};
		class Ammo: RscIGText
		{
			idc=119;
			style="0x01 + 0x100";
			x=0;
			y=0.0089999996;
			w=0.37799999;
			text="$STR_DISP_ERROR";
		};
		class AmmoCount: RscIGText
		{
			idc=184;
			style="0x01 + 0x100";
			x=0.17;
			y=0.19;
			w=0.15000001;
			text="$STR_DISP_ERROR";
		};
		class MagCount: RscIGText
		{
			idc=185;
			style="0x01 + 0x100";
			x=0.31999999;
			y=0.19;
			w=0.15000001;
			text="$STR_DISP_ERROR";
		};
		class GUI_Body: RscPicture
		{
			idc=411;
			text="";
		};
		class GUI_Bleeding0: RscPicture
		{
			idc=401;
			text="";
		};
		class GUI_Bleeding1: RscPicture
		{
			idc=402;
			text="";
		};
		class GUI_InjuredHead0: RscPicture
		{
			idc=403;
			text="";
		};
		class GUI_InjuredHead1: RscPicture
		{
			idc=404;
			text="";
		};
		class GUI_InjuredLegs0: RscPicture
		{
			idc=408;
			text="";
		};
		class GUI_InjuredLegs1: RscPicture
		{
			idc=409;
			text="";
		};
		class GUI_InjuredLegs2: RscPicture
		{
			idc=410;
			text="";
		};
		class GUI_InjuredHands0: RscPicture
		{
			idc=405;
			text="";
		};
		class GUI_InjuredHands1: RscPicture
		{
			idc=406;
			text="";
		};
		class GUI_InjuredHands2: RscPicture
		{
			idc=407;
			text="";
		};
	};
	class RscUnitInfoTank: RscUnitInfo
	{
		idd=300;
		movingEnable=0;
		controls[]=
		{
			"Background",
			"Weapon",
			"Ammo",
			"AmmoCount",
			"MagCount",
			"Commander",
			"Gunner",
			"Driver",
			"Heading"
		};
		class Background: RscText
		{
			idc=124;
			style=128;
			x=0.02;
			y=0.18000001;
			w=0.20999999;
			h=0.25;
			text="";
			colorBackground[]={0.2,0.15000001,0.1,0.80000001};
			colorText[]={0,0,0,0};
			font="TahomaB";
			sizeEx=0;
			fixedWidth=0;
		};
		class Weapon: RscIGText
		{
			idc=118;
			x=0.025;
			y=0.38;
			w=0.19;
			text="$STR_DISP_ERROR";
		};
		class Ammo: RscIGText
		{
			idc=119;
			style="0x01 + 0x100";
			x=0.035;
			y=0.38;
			w=0.19;
			text="$STR_DISP_ERROR";
		};
		class AmmoCount: RscIGText
		{
			idc=184;
			style="0x01 + 0x100";
			x=0.17;
			y=0.19;
			w=0.15000001;
			text="$STR_DISP_ERROR";
		};
		class MagCount: RscIGText
		{
			idc=185;
			style="0x01 + 0x100";
			x=0.31999999;
			y=0.19;
			w=0.15000001;
			text="$STR_DISP_ERROR";
		};
		class Commander: RscIGText
		{
			idc=125;
			x=0.025;
			y="0.38 + 0.04";
			w=0.19;
			text="$STR_DISP_ERROR";
		};
		class Gunner: RscIGText
		{
			idc=127;
			x=0.025;
			y="0.38 + 2 * 0.04";
			w=0.19;
			text="$STR_DISP_ERROR";
		};
		class Driver: RscIGText
		{
			idc=126;
			x=0.025;
			y="0.38 + 3 * 0.04";
			w=0.19;
			text="$STR_DISP_ERROR";
		};
		class Heading: RscIGText
		{
			idc=148;
			style="0x00	+ 0x100";
			x=0.017000001;
			y=0.0099999998;
			w=0.17;
		};
	};
	class RscUnitInfoAir: RscUnitInfo
	{
	};
	class RscStanceInfo
	{
		idd=303;
		controls[]=
		{
			"StanceIndicatorBackground",
			"StanceIndicator"
		};
		class StanceIndicatorBackground: RscPicture
		{
			colorText[]={0,0,0,0};
			idc=1201;
			text="";
			x="10.1 * IGUI_GRID_WEAPON_W + IGUI_GRID_WEAPON_X";
			y="0 * IGUI_GRID_WEAPON_H + IGUI_GRID_WEAPON_Y";
			w="2.3 * IGUI_GRID_WEAPON_W";
			h="3.7 * IGUI_GRID_WEAPON_H";
		};
		class StanceIndicator: RscPictureKeepAspect
		{
			idc=188;
			text="";
			x="10.1 * IGUI_GRID_WEAPON_W + IGUI_GRID_WEAPON_X";
			y="0 * IGUI_GRID_WEAPON_H + IGUI_GRID_WEAPON_Y";
			w="2.3 * IGUI_GRID_WEAPON_W";
			h="2.3 * IGUI_GRID_WEAPON_H";
		};
	};
	class UnitInfoSoldier: RscUnitInfoSoldier
	{
	};
	class UnitInfoTank: RscUnitInfoTank
	{
	};
	class UnitInfoCar: RscUnitInfo
	{
	};
	class UnitInfoShip: RscUnitInfo
	{
	};
	class UnitInfoAirplane: RscUnitInfoAir
	{
	};
	class UnitInfoHelicopter: RscUnitInfoAir
	{
	};
	class RscHint
	{
		idd=301;
		movingEnable=0;
		controls[]=
		{
			"Background",
			"Hint"
		};
		class Background: RscText
		{
			idc=101;
			style=128;
			x=0;
			y=0.02;
			w=0.28;
			h=0.059999999;
			text="";
			colorBackground[]={0.2,0.15000001,0.1,0.80000001};
			colorText[]={0,0,0,0};
			font="TahomaB";
			sizeEx=0;
			fixedWidth=0;
			shadow=0;
		};
		class Hint: RscStructuredText
		{
			idc=102;
			x=0.001;
			y=0.030999999;
			w=0.27500001;
			h=0.039999999;
			style=16;
			lineSpacing=1;
			sizeEx=0.027000001;
			colorText[]={1,1,1,1};
			colorBackground[]={0,0,0,0};
			font="TahomaB";
			size=0.027000001;
			text="$STR_DISP_ERROR";
			class Attributes: Attributes
			{
				color="#ffffff";
				align="center";
				shadow=0;
			};
		};
	};
	class RscTaskHint
	{
		idd=302;
		movingEnable=0;
		class controlsBackground
		{
			class Background: RscText
			{
				idc=103;
				style=128;
				x=0.36000001;
				y=0.22;
				w=0.28;
				h=0.059999999;
				text="";
				colorBackground[]={0.2,0.15000001,0.1,0.80000001};
				colorText[]={0,0,0,0};
				font="TahomaB";
				sizeEx=0;
				fixedWidth=0;
				shadow=0;
			};
		};
		class Controls
		{
			class Hint: RscStructuredText
			{
				idc=104;
				x=0.40400001;
				y=0.23100001;
				w=0.23;
				h=0.039999999;
				style=16;
				lineSpacing=1;
				sizeEx=0.027000001;
				colorText[]={1,1,1,1};
				colorBackground[]={0,0,0,0};
				font="TahomaB";
				size=0.027000001;
				text="$STR_DISP_ERROR";
				class Attributes: Attributes
				{
					color="#ffffff";
					align="left";
					shadow=0;
				};
			};
		};
		class TaskIcon
		{
			x=0.36500001;
			y=0.235;
			w=0.039999999;
			h=0.079999998;
		};
	};
	class RscTaskOverview
	{
		idd=174;
		showMaxDescLines=5;
		enableSimulation=1;
		enableDisplay=1;
		closeOnMissionEnd=1;
		paddingX=0.003;
		paddingY=0.001;
		minW=0.1;
		maxW=0.40000001;
		class controls
		{
			class TaskOverviewAssigned: RscControlsGroup
			{
				idc=1040;
				x=-0.2;
				y=-0.2;
				w=0.40000001;
				h=0.1;
				show=0;
				class controls
				{
					class Background: RscPicture
					{
						text="#(argb,8,8,3)color(0,0,0,1)";
						x=0;
						y=0;
						w=0.40000001;
						h=0.1;
					};
					class Title: RscText
					{
						idc=1042;
						text="<TaskTitle>";
						x=0.5;
						y=0.059999999;
						w=0.34999999;
						h=0.029999999;
						sizeEx=0.025;
						font="TahomaB";
						shadow=0;
					};
					class Icon: RscPicture
					{
						idc=1043;
						text="#(argb,8,8,3)color(1,0.5,0,1)";
						colorText[]={0.80000001,0.60000002,0,1};
						x=0.0099999998;
						y=0.059999999;
						w=0.029999999;
						h=0.029999999;
						shadow=0;
					};
					class HeaderBackground: RscPicture
					{
						text="#(argb,8,8,3)color(0,0,0,1)";
						x=0;
						y=0;
						w=0.40000001;
						h=0.050000001;
					};
					class HeaderText: RscText
					{
						text="ASSIGNED TASK:";
						x=0;
						y=0;
						w=0.40000001;
						h=0.050000001;
						colorText[]={0.80000001,0.80000001,0.80000001,1};
						colorBackground[]={0,0,0,0};
						style="0x10 + 0x200";
						sizeEx=0.025;
						font="TahomaB";
						shadow=0;
					};
				};
			};
			class TaskOverviewUnassigned: TaskOverviewAssigned
			{
				idc=1041;
				show=0;
				class controls
				{
					class HeaderBackground: RscPicture
					{
						text="#(argb,8,8,3)color(0,0,0,1)";
						x=0;
						y=0;
						w=0.40000001;
						h=0.050000001;
					};
					class HeaderText: RscText
					{
						text="NO TASK IS ASSIGNED!";
						x=0;
						y=0;
						w=0.40000001;
						h=0.050000001;
						colorText[]={0.80000001,0.80000001,0.80000001,1};
						colorBackground[]={0,0,0,0};
						style="0x10 + 0x200";
						sizeEx=0.025;
						font="TahomaB";
						shadow=0;
					};
				};
			};
		};
	};
};
class RscTitles
{
};
class RscDisplayLoading
{
	class Variants
	{
		class LoadingOne
		{
			idd=-1;
			movingEnable=0;
			class controlsBackground
			{
				class Background1: RscText
				{
					x=0;
					y=0;
					w=1;
					h=1;
					colorBackground[]={0.30000001,0.30000001,0.30000001,1};
				};
			};
			class controls
			{
				class Name: RscText
				{
					idc=101;
					text="$STR_DISP_ERROR";
					style=2;
					x=0;
					y=0.039999999;
					w=1;
				};
				class Date: RscText
				{
					idc=102;
					text="$STR_DISP_ERROR";
					style=2;
					x=0;
					y=0.69999999;
					w=1;
				};
				class FakeProgress: RscText
				{
					x=0.25;
					y=0.5;
					w=0.5;
					colorBackground[]={0.80000001,0.80000001,0.80000001,0.2};
				};
				class Progress: RscProgress
				{
					idc=104;
					x=0.25;
					y=0.5;
					w=0.5;
					h=0.050000001;
				};
				class Progress2: RscProgress
				{
					idc=103;
					x=0.40000001;
					y=0.60000002;
					w=0.2;
					h=0.029999999;
				};
				class TextLoad: RscText
				{
					style=2;
					x=0.25;
					y=0.44999999;
					w=0.5;
					text="$STR_LOADING";
				};
			};
		};
	};
};
class RscDisplayLoadMission: RscStandardDisplay
{
	idd=-1;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_LOADING";
		};
		class Name: RscText
		{
			idc=101;
			style=2;
			x=0;
			y=0.12;
			w=1;
		};
		class Briefing: RscHTML
		{
			idc=56;
			x=0.090000004;
			y=0.18000001;
			w=0.85000002;
			h=0.60000002;
		};
		class Progress: RscProgress
		{
			idc=104;
			x=0.15000001;
			y=0.84799999;
			w=0.69999999;
			h=0.050000001;
		};
		class Progress2: RscProgress
		{
			idc=103;
			x=0.40000001;
			y=0.89999998;
			w=0.2;
			h=0.029999999;
		};
		class Date: RscText
		{
			idc=102;
			text="$STR_DISP_ERROR";
			style=2;
			x=0;
			y=0.94;
			w=1;
		};
	};
};
class RscDisplayNotFreeze: RscStandardDisplay
{
	idd=-1;
	class controls
	{
		class Text: RscText
		{
			idc=101;
			style=2;
			x=0;
			y=0.44999999;
			w=1;
		};
		class Progress: RscProgress
		{
			idc=104;
			x=0.30000001;
			y=0.5;
			w=0.40000001;
			h=0.050000001;
		};
		class Progress2: RscProgress
		{
			idc=103;
			x=0.40000001;
			y=0.60000002;
			w=0.2;
			h=0.029999999;
		};
	};
};
class RscDisplayNotFreezeBig: RscStandardDisplay
{
	idd=-1;
	class controls
	{
		class Text: RscText
		{
			idc=101;
			style=2;
			x=0;
			y=0.44999999;
			w=1;
		};
		class Progress: RscProgress
		{
			idc=104;
			x=0.30000001;
			y=0.5;
			w=0.40000001;
			h=0.050000001;
		};
		class Progress2: RscProgress
		{
			idc=103;
			x=0.40000001;
			y=0.60000002;
			w=0.2;
			h=0.029999999;
		};
	};
};
class RscDisplayStart: RscStandardDisplay
{
	idd=-1;
	class controls
	{
		class Text: RscText
		{
			idc=101;
			style=2;
			x=0;
			y=0.44999999;
			w=1;
		};
		class Progress: RscProgress
		{
			idc=104;
			x=0.30000001;
			y=0.5;
			w=0.40000001;
			h=0.050000001;
		};
		class Progress2: RscProgress
		{
			idc=103;
			x=0.40000001;
			y=0.60000002;
			w=0.2;
			h=0.029999999;
		};
	};
};
class RscDisplayEditDiaryRecord
{
	access=0;
	idd=125;
	movingEnable=1;
	class Controls
	{
		class RecordBackground: RscText
		{
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
			x=0.51999998;
			y=0.155;
			w=0.44999999;
			h=0.34;
		};
		class RecordTitle: RscTitle
		{
			style="0x20 + 0x02";
			text="$STR_UI_RECORD_TITLE";
			x=0.51999998;
			y=0.16500001;
			w=0.44999999;
		};
		class Record: RscEdit
		{
			idc=101;
			style=16;
			x=0.52999997;
			y=0.23;
			w=0.43000001;
			h=0.2;
			sizeEx=0.027000001;
		};
		class B_OK: RscButton
		{
			idc=1;
			x=0.52999997;
			y=0.435;
			w=0.2;
			h=0.050000001;
			text="$STR_DISP_OK";
			sizeEx=0.027000001;
			default=1;
		};
		class B_Cancel: B_OK
		{
			idc=2;
			x=0.75999999;
			text="$STR_DISP_CANCEL";
			default=0;
		};
		class Title: RscEdit
		{
			idc=102;
			x=0.52999997;
			y=0.52999997;
			w=0.43000001;
			h=0.2;
			sizeEx=0.027000001;
		};
	};
};
class RscDisplayDiary
{
	access=0;
	idd=129;
	movingEnable=1;
	onKeyDown="if ((_this select 1) == 22) then {closeDialog 129; true} else {false}";
	class Controls
	{
		class DiaryBackground: RscText
		{
			x=0.1;
			y=0.025;
			w=0.80000001;
			h=0.94999999;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class DiaryTitle: RscTitle
		{
			style="0x20 + 0x02";
			text="$STR_UI_DIARY_TITLE";
			x=0.1;
			y=0.035;
			w=0.80000001;
		};
		class DiaryPage: RscCombo
		{
			idc=103;
			x=0.60000002;
			y=0.1;
			w=0.28999999;
			h=0.050000001;
			sizeEx=0.027000001;
		};
		class B_Add: RscButton
		{
			idc=104;
			x=0.60000002;
			y=0.155;
			w=0.28999999;
			h=0.050000001;
			colorText[]={1,1,1,1};
			text="$STR_UI_DIARY_ADDRECORD";
			sizeEx=0.027000001;
		};
		class DiaryIndex: RscListBox
		{
			idc=102;
			x=0.60000002;
			y=0.20999999;
			w=0.28999999;
			h=0.69999999;
		};
		class B_Quit: B_Add
		{
			idc=2;
			y=0.91500002;
			text="$STR_UI_DIARY_QUIT";
			default=1;
		};
		class Diary: RscHTML
		{
			idc=101;
			x=0.11;
			y=0.1;
			w=0.47999999;
			h=0.86500001;
			colorBackground[]={0.60000002,0.60000002,0.60000002,1};
			colorText[]={1,1,1,1};
			class H1
			{
				font="TahomaB";
				fontBold="TahomaB";
				sizeEx=0.039999999;
			};
			class P
			{
				font="TahomaB";
				fontBold="TahomaB";
				sizeEx=0.027000001;
			};
		};
	};
};
class RscDisplayMainMap
{
	access=0;
	idd=12;
	movingEnable=0;
	saveParams=0;
	class controlsBackground
	{
		class Map: RscMapControl
		{
			moveOnEdges=1;
			x=-0.088;
			y=-0.088;
			w=1.176;
			h=1.176;
			class Command
			{
				icon="#(argb,8,8,3)color(1,1,1,1)";
				color[]={0,0,0,1};
				size=18;
				importance=1;
				coefMin=1;
				coefMax=1;
			};
			class ActiveMarker
			{
				color[]={0.30000001,0.1,0.89999998,1};
				size=50;
			};
		};
	};
	class controls
	{
	};
	class objects
	{
		class Watch: RscObject
		{
			idc=101;
			type=80;
			model="\core\watch\watch.p3d";
			selectionDate1="date1";
			selectionDate2="date2";
			selectionDay="day";
			x=0.69999999;
			xBack=0.69999999;
			y=0.12;
			yBack=0.12;
			z=0.22;
			zBack=0.22;
			inBack=0;
			enableZoom=0;
			direction[]={0,0,1};
			up[]={0,1,0};
			zoomDuration=1;
			scale=0.69999999;
			waitForLoad=0;
		};
		class Compass: RscObject
		{
			idc=102;
			type=80;
			model="\core\compass\compass.p3d";
			selectionArrow="arrow";
			x=0.92000002;
			xBack=0.92000002;
			y=0.079999998;
			yBack=0.079999998;
			z=0.22;
			zBack=0.22;
			inBack="False";
			enableZoom=0;
			direction[]={1,0,0};
			up[]={0,1,0};
			zoomDuration=1;
			scale=0.60000002;
			waitForLoad=0;
		};
		class GPS: RscObject
		{
			idc=106;
			type=82;
			model="\core\gps\gps.p3d";
			x=0.30000001;
			xBack=0.30000001;
			y=0.079999998;
			yBack=0.079999998;
			z=0.22;
			zBack=0.22;
			inBack=0;
			enableZoom=0;
			up[]={0,1,0};
			direction[]={0,50,1};
			zoomDuration=1;
			scale=1;
			waitForLoad=0;
			class Areas
			{
				class Display
				{
					selection="display";
					class controls
					{
						class GPSSquare: RscText
						{
							style=2;
							idc=75;
							x=0;
							y="0 * 0.660";
							w=1;
							h="1 * 0.660";
							color[]={0,0,0,1};
							sizeEx="1 * 0.660";
							text="";
						};
					};
				};
			};
		};
		class WalkieTalkie: RscObject
		{
			idc=103;
			type=82;
			model="\core\radio\radio.p3d";
			position[]={0.093999997,-0.043000001,0.25};
			scale=1.3;
			direction[]={0,1,0};
			up[]={0,0,-1};
			positionBack[]={0.28,-0.155,0.625};
			inBack=1;
			enableZoom=1;
			zoomDuration=0.5;
			class Areas
			{
				class Papir
				{
					selection="papir";
					class controls
					{
						class RscRadioText: RscActiveText
						{
							idc=-1;
							sizeEx="0.12 * 1.359";
							color[]={0,0,0,1};
							colorActive[]={0.30000001,0.30000001,0.30000001,1};
							style=0;
							x=0.050000001;
							y="0.02 * 1.359";
							w=0.94999999;
							h="0.08 * 1.359";
						};
						class RadioAlpha: RscRadioText
						{
							idc=63;
							y="0.02 * 1.359";
						};
						class RadioBravo: RscRadioText
						{
							idc=64;
							y="0.12 * 1.359";
						};
						class RadioCharlie: RscRadioText
						{
							idc=65;
							y="0.22 * 1.359";
						};
						class RadioDelta: RscRadioText
						{
							idc=66;
							y="0.32 * 1.359";
						};
						class RadioEcho: RscRadioText
						{
							idc=67;
							y="0.42 * 1.359";
						};
						class RadioFoxtrot: RscRadioText
						{
							idc=68;
							y="0.52 * 1.359";
						};
						class RadioGolf: RscRadioText
						{
							idc=69;
							y="0.62 * 1.359";
						};
						class RadioHotel: RscRadioText
						{
							idc=70;
							y="0.72 * 1.359";
						};
						class RadioIndia: RscRadioText
						{
							idc=71;
							y="0.82 * 1.359";
						};
						class RadioJuliet: RscRadioText
						{
							idc=72;
							y="0.92 * 1.359";
						};
					};
				};
			};
		};
		class Notepad: RscObject
		{
			idc=104;
			type=82;
			model="\core\notepad\notepad.p3d";
			selectionPaper="paper";
			position[]={-0.079999998,0,0.31999999};
			scale=1.2;
			positionBack[]={-0.32499999,0.197,0.80000001};
			inBack=0;
			enableZoom=1;
			zoomDuration=0.5;
			paper1="#(argb,8,8,3)color(1,1,1,1)";
			paper2="#(argb,8,8,3)color(1,1,1,1)";
			paper3="#(argb,8,8,3)color(1,1,1,1)";
			paper4="#(argb,8,8,3)color(1,1,1,1)";
			paper5="#(argb,8,8,3)color(1,1,1,1)";
			paper6="#(argb,8,8,3)color(1,1,1,1)";
			paper7="#(argb,8,8,3)color(1,1,1,1)";
			class Areas
			{
				class Paper
				{
					selection="paper";
					class controls
					{
						class Name: RscText
						{
							sizeEx="0.04 * 2.082";
							color[]={1,1,1,1};
							idc=73;
							style=2;
							x=0;
							y="0 * 2.082";
							w=1;
							h="0.05 * 2.082";
						};
						class RscBookmarkText: RscActiveText
						{
							idc=-1;
							sizeEx="0.04 * 2.082";
							color[]={1,1,1,1};
							colorActive[]={0.85000002,0.85000002,0.85000002,1};
							style=2;
							x=0;
							y="0.05 * 2.082";
							w=0.25;
							h="0.05 * 2.082";
						};
						class Bookmark1: RscBookmarkText
						{
							idc=58;
							x=0;
							text="$STR_MAP_PLAN";
						};
						class Bookmark2: RscBookmarkText
						{
							idc=57;
							x=0.25;
							text="$STR_MAP_NOTES";
						};
						class Bookmark3: RscBookmarkText
						{
							idc=60;
							x=0.5;
							text="$STR_MAP_GROUP";
						};
						class Bookmark4: RscBookmarkText
						{
							idc=59;
							x=0.75;
							text="$STR_BRIEF_TEAM_SWITCH";
						};
						class Briefing: RscHTML
						{
							size="1 * 2.082";
							idc=56;
							x=0.02;
							y="0.11 * 2.082";
							w=0.98000002;
							h="0.89 * 2.082";
							class H1: H1
							{
								sizeEx="0.04 * 2.082";
							};
							class H2: H2
							{
								sizeEx="0.04 * 2.082";
							};
							class H3: H3
							{
								sizeEx="0.04 * 2.082";
							};
							class H4: H4
							{
								sizeEx="0.04 * 2.082";
							};
							class H5: H5
							{
								sizeEx="0.04 * 2.082";
							};
							class H6: H6
							{
								sizeEx="0.04 * 2.082";
							};
							class P: P
							{
								sizeEx="0.04 * 2.082";
							};
						};
					};
				};
			};
		};
	};
};
class RscDisplayMain: RscStandardDisplay
{
	idd=0;
	class controls
	{
		class Version: RscText
		{
			idc=118;
			style=2;
			x=0.2;
			y=0.1;
			w=0.2;
			sizeEx=0.027000001;
		};
		class TrafficLight: RscActiveText
		{
			idc=121;
			x="0.95 * safezoneW + safezoneX";
			y="0.92 * safezoneH + safezoneY";
			w="0.025 * safezoneW";
			h="0.04 * safezoneH";
			style=48;
			color[]={1,1,1,0.69999999};
			colorActive[]={1,1,1,1};
			text="#(argb,8,8,3)color(1,1,1,1)";
		};
		class ModList: RscStructuredText
		{
			idc=139;
			style=0;
			x=0.75;
			y=0.40000001;
			w=0.23999999;
			h=0.5;
			size="( 16 / 408 )";
			class Attributes
			{
				font="TahomaB";
				color="#ffffff";
				align="right";
				shadow=0;
			};
		};
		class Date: Version
		{
			idc=112;
			x=0.60000002;
		};
		class B_Campaign: RscButton
		{
			idc=101;
			x=0.133;
			y=0.2;
			text="$STR_DISP_MAIN_XBOX_CAMPAIGN";
		};
		class B_SingleMission: B_Campaign
		{
			idc=117;
			y="0.2 + 0.1";
			text="$STR_DISP_MAIN_SINGLE";
			default=1;
		};
		class B_MultiPlayer: B_Campaign
		{
			idc=105;
			y="0.2 + 0.2";
			text="$STR_DISP_MAIN_MULTI";
		};
		class B_MissionEditor: B_Campaign
		{
			idc=115;
			y="0.2 + 0.3";
			text="$STR_DISP_MAIN_CUSTOM";
		};
		class B_SinglePlayer: B_Campaign
		{
			idc=138;
			y="0.2 + 0.4";
			text="$STR_DISP_MAIN_SINGLE_PLAYER";
		};
		class B_Options: RscButton
		{
			idc=102;
			x=0.56599998;
			y=0.2;
			text="$STR_DISP_MAIN_OPTIONS";
		};
		class B_Player: B_Options
		{
			idc=109;
			y="0.2 + 0.1";
			text="$STR_DISP_ERROR";
		};
		class B_Credits: B_Options
		{
			idc=107;
			y="0.2 + 0.2";
			text="$STR_DISP_MAIN_CREDITS";
		};
		class B_Expansions: B_Options
		{
			idc=140;
			y="0.2 + 0.5";
			text="Expansions";
		};
		class B_Quit: B_Options
		{
			idc=106;
			y="0.2 + 0.3";
			text="$STR_DISP_MAIN_QUIT";
		};
		class ModIcons: RscControlsGroup
		{
			idc=141;
			x="SafeZoneX+0.03";
			y="(SafeZoneH + SafeZoneY) - (0.113*SafeZoneH)";
			w=0.80000001;
			h=0.2;
			class Controls
			{
			};
		};
	};
	class IconPicture: RscPicture
	{
		x=0;
		y=0;
		w="0.07*SafeZoneH";
		h="0.093*SafeZoneH";
		spacing=0.0070000002;
		text="";
	};
	class DlcIconPicture: IconPicture
	{
	};
	class DlcOwnedIconPicture: IconPicture
	{
	};
};
class RscDisplayCardA
{
	idd="IDD_CARDA_WIN";
	class controls
	{
		class testingList: RscListBox
		{
			idc=110;
			x=0.133;
			y=0.050000001;
			w=0.30000001;
		};
		class testingSlider: RscSlider
		{
			idc=112;
			x=0.133;
			y=0.69999999;
		};
		class testingButton: RscButton
		{
			idc=111;
			x=0.60000002;
			y="0.2 + 0.2";
			text="add text";
		};
		class B_Back: testingButton
		{
			idc=2;
			y="0.2 + 0.4";
			text="$STR_DISP_BACK";
		};
		class kompas: RscCompass
		{
		};
	};
};
class RscDisplaySingleMission: RscStandardDisplay
{
	idd=2;
	none="#(argb,8,8,3)color(1,1,1,1)";
	done="#(argb,8,8,3)color(1,1,1,1)";
	locked="#(argb,8,8,3)color(1,1,1,1)";
	package="#(argb,8,8,3)color(1,1,1,1)";
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_SINGLE_TITLE";
		};
		class Missions: RscListBox
		{
			idc=101;
			x=0.067000002;
			y=0.15000001;
			h=0.64999998;
		};
		class Overview: RscHTML
		{
			idc=102;
			x=0.52999997;
			y=0.15000001;
			w=0.40000001;
			h=0.64999998;
		};
		class B_Difficulty: RscActiveText
		{
			idc=104;
			x=0.029999999;
			y=0.89999998;
		};
		class B_Cancel: B_Difficulty
		{
			idc=2;
			x=0.20999999;
			text="$STR_DISP_CANCEL";
		};
		class B_Start: B_Difficulty
		{
			idc=105;
			x=0.38999999;
		};
		class B_Continue: B_Difficulty
		{
			idc=1;
			x=0.56999999;
			w=0.40000001;
			default=1;
		};
	};
};
class RscDisplayCampaignLoad: RscStandardDisplay
{
	idd=43;
	class controlsBackground
	{
		class TitleBackground: RscText
		{
			idc=1080;
			x=-0.31428599;
			y=-0.157143;
			w=1.4;
			h=0.057142898;
			colorBackground[]={0.76999998,0.50999999,0.079999998,0.80000001};
		};
		class PictureBackground: RscText
		{
			idc=1081;
			x=0.371429;
			y=0.083999999;
			w=0.88;
			h=0.51999998;
			colorBackground[]={0,0,0,0.69999999};
		};
		class NameAndAuthorBackground: RscText
		{
			idc=1082;
			x=0.371429;
			y=-0.094285697;
			w=0.88;
			h=0.1;
			colorBackground[]={0,0,0,0.69999999};
		};
		class OverviewTextBackground: RscText
		{
			idc=1083;
			x=0.371429;
			y=0.60799998;
			w=0.88;
			h=0.308;
			colorBackground[]={0,0,0,0.69999999};
		};
	};
	class controls
	{
		class Title: RscTitle
		{
			idc=1000;
			colorBackground[]={0,0,0,0};
			style=0;
			text="$STR_A3_RSCDISPLAYMAIN_BUTTONCAMPAIGN";
			x=-0.31428599;
			y=-0.157143;
			w=0.68142903;
			h=0.057142898;
		};
		class PlayersName: Title
		{
			idc=8434;
			style=1;
			colorBackground[]={0,0,0,0};
			x=0.371429;
			y=-0.157143;
			w=0.94285703;
			h=0.057142898;
		};
		class BriefingName: RscText
		{
			idc=104;
			shadow=0;
			x=0.371429;
			y=-0.094285697;
			w=0.94285703;
			h=0.068571404;
		};
		class Author: RscText
		{
			idc=105;
			shadow=0;
			x=0.371429;
			y=-0.025714301;
			w=0.94285703;
			h=0.0457143;
			colorText[]={1,1,1,0.5};
		};
		class OverviewGroup: RscControlsGroup
		{
			idc=2300;
			x=0.371429;
			y=0.02;
			w=0.94285703;
			h=0.62857097;
			class VScrollbar: VScrollbar
			{
				width=0;
			};
			class HScrollbar: HScrollbar
			{
				height=0;
			};
			class controls
			{
				class OverviewPicture: RscPictureKeepAspect
				{
					idc=106;
					text="#(argb,8,8,3)color(0,0,0,0)";
					x=0;
					y=0;
					w=0.89999998;
					h=0.44999999;
				};
				class OverviewNoise: RscPicture
				{
					idc=1201;
					text="#(argb,8,8,3)color(0,0,0,0)";
					x=0;
					y=0;
					w=0.66000003;
					h=0.44;
				};
				class DLCStripe: RscPicture
				{
					idc=111;
					colorText[]=
					{
						"GUI_BCG_RGB",
						1
					};
					text="#(argb,8,8,3)color(0,0,0,0)";
					x=0;
					y=0;
					w=0.66000003;
					h=0.44;
				};
				class DLCIcon: RscPicture
				{
					idc=112;
					text="#(argb,8,8,3)color(1,1,1,1)";
					x=0.60000002;
					y=0;
					w=0.059999999;
					h=0.079999998;
				};
			};
		};
		class OverviewControlsGroup: RscControlsGroup
		{
			idc=2301;
			x=0.371429;
			y=0.65428603;
			w=0.94285703;
			h=0.371429;
			class HScrollbar: HScrollbar
			{
				height=0;
			};
			class controls
			{
				class OverviewText: RscStructuredText
				{
					idc=107;
					x=0;
					y=0;
					w=0.64499998;
					h=0.16;
				};
				class EstimatedDeployment: RscStructuredText
				{
					idc=108;
					text="$STR_A3_Campaign_Full_Dynamic";
					x=0;
					y=0.16;
					w=0.64499998;
					h=0.039999999;
				};
				class ReleaseDate: RscHTML
				{
					idc=109;
					x=0;
					y=0.2;
					w=0.64499998;
					h=0.048;
				};
			};
		};
		class SearchBackground: RscText
		{
			idc=1005;
			colorBackground[]={0,0,0,0.69999999};
			x=-0.31428599;
			y=-0.094285697;
			w=0.68142903;
			h=0.057142898;
		};
		class Search: RscEdit
		{
			idc=645;
			x=-0.31428599;
			y=-0.094285697;
			w=0.63857102;
			h=0.057142898;
		};
		class SearchButton: RscButton
		{
			idc=646;
			x=0.32428601;
			y=-0.1;
			w=0.042857099;
			h=0.057142898;
		};
		class MissionsTree: RscTree
		{
			idc=101;
			colorBackground[]={0,0,0,0.69999999};
			expandOnDoubleclick=1;
			idcSearch="IDC_SEARCH";
			x=-0.31428599;
			y=-0.037142899;
			w=0.68142903;
			h=1.13143;
		};
		class ValueDifficulty: RscStructuredText
		{
			idc=103;
			x=0.371429;
			y=1.03714;
			w=0.94285703;
			h=0.057142898;
		};
		class ButtonCancel: RscShortcutButton
		{
			idc=2;
			shortcuts[]=
			{
				"0x00050000 + 1"
			};
			text="$STR_DISP_BACK";
			x=-0.31428599;
			y=1.1;
			w=0.26785699;
			h=0.057142898;
		};
		class ButtonGameOptions: RscShortcutButton
		{
			idc=307;
			text="$STR_DISP_OPTIONS_GAME_OPTIONS";
			x=-0.039999999;
			y=1.1;
			w=0.26785699;
			h=0.057142898;
		};
		class ButtonBuyDLC: RscShortcutButton
		{
			idc=110;
			shortcuts[]=
			{
				"INPUT_SHIFT_OFFSET + 0x19"
			};
			colorBackground[]={0.031372551,0.72156864,0.91764706,1};
			text="$STR_A3_DLC_SCENARIO_PURCHASE_BUTTON";
			x=1.04643;
			y=1.1;
			w=0.26785699;
			h=0.057142898;
			tooltip="$STR_A3_DLC_SCENARIO_PURCHASE_TOOLTIP";
		};
		class ButtonRevert: RscShortcutButton
		{
			idc=102;
			shortcuts[]=
			{
				"0x00050000 + 2"
			};
			text="$STR_CAMPAIGN_RESTART";
			x=0.77428597;
			y=1.1;
			w=0.26785699;
			h=0.057142898;
		};
		class ButtonOK: RscShortcutButton
		{
			idc=1;
			shortcuts[]=
			{
				"0x00050000 + 0",
				28,
				57,
				156
			};
			default=1;
			text="$STR_DISP_CONTINUE";
			x=1.04643;
			y=1.1;
			w=0.26785699;
			h=0.057142898;
		};
		class ButtonMPCampaign: ButtonOK
		{
			idc=1020;
			text="$STR_SINGLE_OPEN";
			show=0;
			onButtonClick="";
			default=0;
		};
	};
};
class RscDisplayRevert: RscStandardDisplay
{
	idd=66;
	class controls
	{
		class Title: RscTitle
		{
			idc=102;
			text="$STR_SURE";
		};
		class Question: RscText
		{
			idc=103;
			x=0.54000002;
			y=0.34999999;
			w=0.40000001;
			h=0.5;
			text="$STR_DISP_REVERT_QUESTION";
			style=2;
		};
	};
};
class RscDisplayGetReady: RscDisplayMainMap
{
	idd=37;
	showGearOnExit=0;
	class controlsBackground
	{
		class Background1: RscText
		{
			x=0;
			y=0;
			w=0.5;
			h=1;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class Background2: Background1
		{
			x=0.5;
			y=0;
			h=0.050000001;
		};
		class Background3: Background2
		{
			y=0.94999999;
		};
		class Background4: Background1
		{
			x=0.94999999;
			w=0.050000001;
		};
	};
	class controls
	{
		class Title: RscTitle
		{
			idc=114;
			x=0;
			w=0.5;
		};
		class B_Continue: RscActiveText
		{
			idc=1;
			x=0.1;
			y=0.89999998;
			w=0.15000001;
			text="$STR_DISP_CONTINUE";
			default=1;
		};
		class B_Cancel: B_Continue
		{
			idc=2;
			x=0.25;
			text="$STR_DISP_CANCEL";
			default=0;
		};
	};
};
class RscDisplayGear
{
	idd=106;
	emptyGun="#(argb,8,8,3)color(1,1,1,1)";
	emptySec="#(argb,8,8,3)color(1,1,1,1)";
	emptyEq="#(argb,8,8,3)color(1,1,1,1)";
	emptyMag="#(argb,8,8,3)color(1,1,1,1)";
	emptyMag2="#(argb,8,8,3)color(1,1,1,1)";
	emptyHGun="#(argb,8,8,3)color(1,1,1,1)";
	emptyHGunMag="#(argb,8,8,3)color(1,1,1,1)";
	movingEnable=0;
	enableDisplay=1;
	class controls
	{
		class Title: RscTitle
		{
			idc=101;
			text="$STR_GEAR_TITLE";
		};
		class Pool: RscListNBox
		{
			idc=105;
			style=16;
			x=0.050000001;
			y=0.60000002;
			w=0.40000001;
			h=0.30000001;
			color[]={0,0,0,1};
			xcolumn1=0.1;
			xcolumn2=0.25;
			xcolumn3=0.85000002;
			colorPlayerItem[]={1,0.5,0,1};
		};
		class B_Add: RscButton
		{
			idc=146;
			x=0;
			y=0.2;
			h=0.1;
			w=0.1;
			text="";
		};
		class B_Remove: B_Add
		{
			idc=147;
			x=0.2;
			y=0.2;
			text="";
		};
		class Skill: RscPicture
		{
			idc=102;
			x=0.73000002;
			y=0.2;
			w=0.050000001;
			h=0.050000001;
		};
		class Vehicle: RscPicture
		{
			idc=103;
			x=0.80000001;
			y=0.2;
			w=0.059999999;
			h=0.059999999;
		};
		class Weapons: RscHTML
		{
			idc="IDC_GEAR_WEAPONS";
			x=0.55000001;
			y=0.18000001;
			w=0.40000001;
			h=0.60000002;
			align="center";
			cycleLinks=0;
		};
		class B_Rearm: RscActiveText
		{
			idc=132;
			x=0.75;
			y=0.89999998;
			w=0.15000001;
			text="$STR_GEAR_REARM";
		};
		class B_OpenBag: RscActiveText
		{
			idc=157;
			x=0.69999999;
			y=0.89999998;
			w=0.15000001;
			text="OPEN";
		};
		class B_CloseBag: RscActiveText
		{
			idc=158;
			x=0.69999999;
			y=0.89999998;
			w=0.15000001;
			text="CLOSE";
		};
		class B_Close: RscActiveText
		{
			idc=2;
			x=0.85000002;
			y=0.89999998;
			w=0.15000001;
			text="$STR_DISP_CLOSE";
			default=1;
		};
	};
	class Filters
	{
		class All
		{
			name="$STR_A3_RscDisplayGear_Filters_All0";
			mask=8191;
			image="";
		};
		class Primary
		{
			name="$STR_A3_RscDisplayGear_Filters_Primary0";
			mask=257;
			image="";
		};
		class Secondary
		{
			name="$STR_A3_RscDisplayGear_Filters_Secondary0";
			mask=260;
			image="";
		};
		class HandGun
		{
			name="$STR_A3_RscDisplayGear_Filters_HandGun0";
			mask=8128;
			image="";
		};
		class Items
		{
			name="$STR_A3_RscDisplayGear_Filters_Items0";
			mask=1023;
			image="";
		};
	};
};
class RscDisplayGearWeapon: RscStandardDisplay
{
	idd="IDD_GEAR_SELECT";
	class controls
	{
		class Title: RscTitle
		{
			idc="IDC_GEAR_SELECT_TITLE";
		};
		class Weapon: RscListBox
		{
			idc="IDC_GEAR_SELECT_LIST";
			style=16;
			x=0.07;
			y=0.2;
			w=0.44;
			h=0.60000002;
			rowHeight=0.064999998;
		};
		class Overview: RscHTML
		{
			idc="IDC_GEAR_SELECT_OVERVIEW";
			x=0.523;
			y=0.2;
			w=0.42199999;
			h=0.68000001;
			align="center";
		};
		class B_Drop: RscActiveText
		{
			idc="IDC_GEAR_SELECT_DROP";
			x=0.25;
			y=0.89999998;
			w=0.15000001;
			text="$STR_TOOLTIP_DROP";
			default=1;
		};
		class B_OK: B_Drop
		{
			idc=1;
			x=0.85000002;
			text="$STR_DISP_OK";
			default=1;
		};
		class B_CANCEL: B_Drop
		{
			idc=2;
			x=0.89999998;
			text="$STR_DISP_CANCEL";
			default=1;
		};
	};
};
class RscDisplayArtillery: RscStandardDisplay
{
	idd=-1;
	enableSimulation=1;
	movingEnable=0;
	class controls
	{
	};
};
class RscDisplayEmpty
{
	access=0;
	movingEnable=0;
	class controls
	{
	};
};
class RscDisplayMission: RscDisplayEmpty
{
	access=0;
	idd=46;
};
class RscDisplayIntro: RscDisplayEmpty
{
	access=0;
	idd=47;
};
class RscDisplayOutro: RscDisplayEmpty
{
	access=0;
	idd=48;
};
class RscDisplayAward: RscDisplayEmpty
{
	access=0;
	idd=62;
};
class RscDisplayCampaign: RscDisplayEmpty
{
	access=0;
	idd=33;
};
class RscDisplayMissionEnd: RscStandardDisplay
{
	idd=58;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_MISSION_KILLED";
		};
		class Quotation: RscText
		{
			idc=102;
			style=16;
			lineSpacing=1;
			x=0.1;
			y=0.69999999;
			w=0.85000002;
			h=0.2;
		};
		class Author: RscText
		{
			idc=103;
			style=1;
			x=0.44999999;
			y=0.85000002;
			w=0.40000001;
		};
		class B_Load: RscButton
		{
			idc=105;
			x=0.34999999;
			y=0.2;
			text="$STR_DISP_ME_LOAD";
		};
		class B_Retry: B_Load
		{
			idc=104;
			y="0.2 + 0.1";
			text="$STR_DISP_ME_RETRY";
			default=1;
		};
		class B_Restart: B_Load
		{
			idc=106;
			y="0.2 + 0.2";
			text="$STR_XBOX_PLAY_AGAIN";
		};
		class B_Abort: B_Load
		{
			idc=2;
			y="0.2 + 0.3";
			text="$STR_DISP_ME_ABORT";
		};
		class B_TeamSwitch: B_Load
		{
			idc=107;
			y="0.2 + 0.4";
			text="$STR_DISP_ME_TEAM_SWITCH";
		};
		class MissionTitle: RscText
		{
			idc=120;
			x="0.025 * safezoneW + safezoneX";
			y="0.92 * safezoneH + safezoneY";
			w="0.625 * safezoneW";
			h="0.04 * safezoneH";
		};
		class TrafficLight: RscActiveText
		{
			idc=121;
			x="0.95 * safezoneW + safezoneX";
			y="0.92 * safezoneH + safezoneY";
			w="0.025 * safezoneW";
			h="0.04 * safezoneH";
			style=48;
			color[]={1,1,1,0.69999999};
			colorActive[]={1,1,1,1};
			text="#(argb,8,8,3)color(1,1,1,1)";
		};
	};
};
class RscDisplayTeamSwitch: RscStandardDisplay
{
	idd=130;
	movingEnable=0;
	colorPlayer[]={1,1,1,1};
	colorPlayerSelected[]={1,0.5,0,1};
	class Controls
	{
		class Background: RscText
		{
			x=0.60000002;
			y=0;
			w=0.40000001;
			h=0.40000001;
			style=128;
			colorBackground[]={0.1,0.1,0.1,1};
		};
		class Roles: RscListBox
		{
			idc=101;
			style=16;
			x=0.61000001;
			y=0.0099999998;
			w=0.38999999;
			h=0.28999999;
		};
		class ButtonOK: RscButton
		{
			idc=1;
			x=0.61000001;
			y=0.31;
			w=0.19;
			h=0.079999998;
			text="$STR_DISP_OK";
			default=1;
		};
		class ButtonCancel: RscButton
		{
			idc=2;
			x=0.81;
			y=0.31;
			w=0.19;
			h=0.079999998;
			text="$STR_DISP_CANCEL";
		};
	};
};
class RscDisplayInterrupt: RscStandardDisplay
{
	idd=49;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_INT_TITLE";
		};
		class B_Continue: RscButton
		{
			idc=2;
			x=0.34999999;
			y=0.2;
			h=0.079999998;
			text="$STR_DISP_INT_CONTINUE";
			default=1;
		};
		class B_Save: B_Continue
		{
			idc=103;
			y="0.2 + 0.08";
			text="$STR_DISP_INT_SAVE";
			default=0;
		};
		class B_Load: B_Continue
		{
			idc=102;
			y="0.2 + 0.16";
			text="$STR_DISP_INT_LOAD";
			default=0;
		};
		class B_Retry: B_Continue
		{
			idc=105;
			y="0.2 + 0.24";
			text="$STR_DISP_INT_RETRY";
			default=0;
		};
		class B_Options: B_Continue
		{
			idc=101;
			y="0.2 + 0.32";
			text="$STR_DISP_INT_OPTIONS";
			default=0;
		};
		class B_Abort: B_Continue
		{
			idc=104;
			y="0.2 + 0.56";
			text="$STR_DISP_INT_ABORT";
			default=0;
		};
		class B_Diary: RscButton
		{
			idc=118;
			x=0.34999999;
			y="MP_Interrupt_Y + 0.70";
			h=0.079999998;
			text="$STR_ACTION_DIARY";
			default=0;
		};
		class B_Revert: RscButton
		{
			idc=119;
			x=0.34999999;
			y="MP_Interrupt_Y + 0.78";
			h=0.079999998;
			text="$STR_DISP_REVERT";
			default=0;
		};
		class MissionTitle: RscText
		{
			idc=120;
			x="0.025 * safezoneW + safezoneX";
			y="0.92 * safezoneH + safezoneY";
			w="0.625 * safezoneW";
			h="0.04 * safezoneH";
		};
		class TrafficLight: RscActiveText
		{
			idc=121;
			x="0.95 * safezoneW + safezoneX";
			y="0.92 * safezoneH + safezoneY";
			w="0.025 * safezoneW";
			h="0.04 * safezoneH";
			style=48;
			color[]={1,1,1,0.69999999};
			colorActive[]={1,1,1,1};
			text="#(argb,8,8,3)color(1,1,1,1)";
		};
	};
};
class RscDisplayInterruptRevert: RscStandardDisplay
{
	idd=144;
	movingEnable=0;
	class Controls
	{
		class Background: RscText
		{
			x=0.60000002;
			y=0;
			w=0.40000001;
			h=0.40000001;
			style=128;
			colorBackground[]={0.1,0.1,0.1,1};
		};
		class RevertTypes: RscListBox
		{
			idc=101;
			x=0.61000001;
			y=0.0099999998;
			w=0.38999999;
			h=0.28999999;
		};
		class ButtonOK: RscButton
		{
			idc=1;
			x=0.61000001;
			y=0.31;
			w=0.19;
			h=0.079999998;
			text="$STR_DISP_OK";
			default=1;
		};
		class ButtonCancel: RscButton
		{
			idc=2;
			x=0.81;
			y=0.31;
			w=0.19;
			h=0.079999998;
			text="$STR_DISP_CANCEL";
		};
		class MissionTitle: RscText
		{
			idc=120;
			x="0.025 * safezoneW + safezoneX";
			y="0.92 * safezoneH + safezoneY";
			w="0.625 * safezoneW";
			h="0.04 * safezoneH";
		};
		class TrafficLight: RscActiveText
		{
			idc=121;
			x="0.95 * safezoneW + safezoneX";
			y="0.92 * safezoneH + safezoneY";
			w="0.025 * safezoneW";
			h="0.04 * safezoneH";
			style=48;
			color[]={1,1,1,0.69999999};
			colorActive[]={1,1,1,1};
			text="#(argb,8,8,3)color(1,1,1,1)";
		};
	};
};
class RscDisplaySelectSave: RscStandardDisplay
{
	idd=154;
	movingEnable=0;
	class Controls
	{
		class Background: RscText
		{
			x=0.60000002;
			y=0;
			w=0.40000001;
			h=0.40000001;
			style=128;
			colorBackground[]={0.1,0.1,0.1,1};
		};
		class SaveTypes: RscListBox
		{
			idc=101;
			x=0.61000001;
			y=0.0099999998;
			w=0.38999999;
			h=0.28999999;
		};
		class ButtonOK: RscButton
		{
			idc=1;
			x=0.61000001;
			y=0.31;
			w=0.19;
			h=0.079999998;
			text="$STR_DISP_OK";
			default=1;
		};
		class ButtonCancel: RscButton
		{
			idc=2;
			x=0.81;
			y=0.31;
			w=0.19;
			h=0.079999998;
			text="$STR_DISP_CANCEL";
		};
		class MissionTitle: RscText
		{
			idc=120;
			x="0.025 * safezoneW + safezoneX";
			y="0.92 * safezoneH + safezoneY";
			w="0.625 * safezoneW";
			h="0.04 * safezoneH";
		};
		class TrafficLight: RscActiveText
		{
			idc=121;
			x="0.95 * safezoneW + safezoneX";
			y="0.92 * safezoneH + safezoneY";
			w="0.025 * safezoneW";
			h="0.04 * safezoneH";
			style=48;
			color[]={1,1,1,0.69999999};
			colorActive[]={1,1,1,1};
			text="#(argb,8,8,3)color(1,1,1,1)";
		};
	};
};
class RscDisplayMPInterrupt: RscStandardDisplay
{
	idd=49;
	class controls
	{
		class Title: RscTitle
		{
			idc=111;
		};
		class B_Continue: RscButton
		{
			idc=2;
			x=0.34999999;
			y=0.2;
			h=0.079999998;
			text="$STR_DISP_INT_CONTINUE";
			default=1;
		};
		class B_Players: B_Continue
		{
			idc=109;
			y="0.2 + 0.08";
			text="$STR_MPTABLE_PLAYERS";
			default=0;
		};
		class B_Save: B_Continue
		{
			idc=103;
			y="0.2 + 0.24";
			text="$STR_DISP_INT_SAVE";
			default=0;
		};
		class B_Load: B_Continue
		{
			idc=102;
			y="0.2 + 0.32";
			text="$STR_DISP_INT_LOAD";
			default=0;
		};
		class B_Retry: B_Continue
		{
			idc=105;
			y="0.2 + 0.40";
			text="$STR_DISP_INT_RETRY";
			default=0;
		};
		class B_Abort: B_Continue
		{
			idc=104;
			y="0.2 + 0.56";
			text="$STR_DISP_INT_ABORT";
			default=0;
		};
		class B_Diary: RscButton
		{
			idc=118;
			x=0.34999999;
			y="0.2 + 0.70";
			h=0.079999998;
			text="$STR_ACTION_DIARY";
			default=0;
		};
		class MissionTitle: RscText
		{
			idc=120;
			x="0.025 * safezoneW + safezoneX";
			y="0.92 * safezoneH + safezoneY";
			w="0.625 * safezoneW";
			h="0.04 * safezoneH";
		};
		class TrafficLight: RscActiveText
		{
			idc=121;
			x="0.95 * safezoneW + safezoneX";
			y="0.92 * safezoneH + safezoneY";
			w="0.025 * safezoneW";
			h="0.04 * safezoneH";
			style=48;
			color[]={1,1,1,0.69999999};
			colorActive[]={1,1,1,1};
			text="#(argb,8,8,3)color(1,1,1,1)";
		};
	};
};
class RscDisplayDebriefing: RscStandardDisplay
{
	idd=50;
	statisticsLinks=0;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_DEBRIEFING";
		};
		class MissionTitle: RscText
		{
			x=0.25;
			y=0.050000001;
			w=0.5;
			h=0.050000001;
			idc=112;
		};
		class MissionResult: RscText
		{
			x=0.25;
			y=0.15000001;
			w=0.5;
			h=0.050000001;
			idc=111;
		};
		class DebriefingInfo: RscHTML
		{
			idc=115;
			x=0.25;
			y=0.25;
			w=0.5;
			h=0.2;
		};
		class DebriefingText: RscHTML
		{
			idc=113;
			x=0.25;
			y=0.5;
			w=0.5;
			h=0.2;
		};
		class DebriefingObjectives: RscHTML
		{
			idc=114;
			x=0.25;
			y=0.75;
			w=0.5;
			h=0.2;
		};
		class Right: RscHTML
		{
			idc=102;
			x=0.75;
			y=0.050000001;
			w=0.40000001;
			h=0.15000001;
		};
		class Left: RscHTML
		{
			idc=103;
			x=0.25;
			y=0.18000001;
			w=0.5;
			h=0.1;
		};
		class PlayersTitle: RscText
		{
			idc=107;
			x=0.69999999;
			y=0.69999999;
			w=0.25;
			text="$STR_DISP_SRVSETUP_PLAYERS";
			style="0x00 + 0xA0";
		};
		class Players: RscListBox
		{
			idc=109;
			x=0.69999999;
			y=0.75;
			w=0.25;
			h=0.125;
		};
		class B_Restart: RscActiveText
		{
			idc=104;
			x=0.64999998;
			y=0.89999998;
			w=0.15000001;
			text="$STR_DISP_DEBRIEFING_RESTART";
		};
		class B_Continue: B_Restart
		{
			idc=2;
			x=0.80000001;
			text="$STR_DISP_CONTINUE";
			default=1;
		};
	};
};
class RscDisplayMissionFail: RscStandardDisplay
{
	idd=58;
	statisticsLinks=0;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_DEBRIEFING";
		};
		class MissionTitle: RscText
		{
			x=0.25;
			y=0.050000001;
			w=0.5;
			h=0.050000001;
			idc=112;
		};
		class MissionResult: RscText
		{
			x=0.25;
			y=0.15000001;
			w=0.5;
			h=0.050000001;
			idc=111;
		};
		class DebriefingInfo: RscHTML
		{
			idc=115;
			x=0.25;
			y=0.25;
			w=0.5;
			h=0.2;
		};
		class DebriefingText: RscHTML
		{
			idc=113;
			x=0.25;
			y=0.5;
			w=0.5;
			h=0.2;
		};
		class DebriefingObjectives: RscHTML
		{
			idc=114;
			x=0.25;
			y=0.75;
			w=0.5;
			h=0.2;
		};
		class Right: RscHTML
		{
			idc=102;
			x=0.75;
			y=0.050000001;
			w=0.40000001;
			h=0.15000001;
		};
		class Left: RscHTML
		{
			idc=103;
			x=0.25;
			y=0.18000001;
			w=0.5;
			h=0.1;
		};
		class PlayersTitle: RscText
		{
			idc=107;
			x=0.69999999;
			y=0.69999999;
			w=0.25;
			text="$STR_DISP_SRVSETUP_PLAYERS";
			style="0x00 + 0xA0";
		};
		class Players: RscListBox
		{
			idc=109;
			x=0.69999999;
			y=0.75;
			w=0.25;
			h=0.125;
		};
		class B_Load: RscButton
		{
			idc=105;
			x=0.34999999;
			y=0.2;
			text="$STR_DISP_ME_LOAD";
		};
		class B_Retry: RscButton
		{
			idc=104;
			y="0.2 + 0.1";
			x=0.34999999;
			text="$STR_DISP_ME_RETRY";
			default=1;
		};
		class B_Restart: RscButton
		{
			idc=106;
			y="0.2 + 0.2";
			x=0.34999999;
			text="$STR_XBOX_PLAY_AGAIN";
		};
		class B_Abort: RscButton
		{
			idc=2;
			y="0.2 + 0.3";
			x=0.34999999;
			text="$STR_DISP_ME_ABORT";
		};
	};
};
class RscDisplayLogin: RscStandardDisplay
{
	idd=31;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_LOGIN_TITLE";
		};
		class TextUser: RscText
		{
			x=0.1;
			y=0.15000001;
			w=0.44999999;
			text="$STR_DISP_LOGIN_USER";
		};
		class ValueUser: RscListBox
		{
			idc=101;
			x=0.1;
			y=0.2;
			w=0.44999999;
			h=0.5;
			rows=10;
		};
		class B_New: RscActiveText
		{
			idc=103;
			x=0.64999998;
			y=0.2;
			w=0.2;
			text="$STR_DISP_NEW";
		};
		class B_Edit: RscActiveText
		{
			idc=102;
			x=0.64999998;
			y=0.25;
			w=0.2;
			text="$STR_DISP_EDIT";
		};
		class B_Discard: RscActiveText
		{
			idc=114;
			x=0.85100001;
			y=0.25;
			w=0.2;
			text="Discard";
		};
		class B_Delete: RscActiveText
		{
			idc=104;
			x=0.64999998;
			y=0.30000001;
			w=0.2;
			text="$STR_DISP_DELETE";
		};
		class B_Cancel: RscActiveText
		{
			idc=2;
			x=0.60000002;
			y=0.89999998;
			w=0.12;
			text="$STR_DISP_CANCEL";
		};
		class B_OK: B_Cancel
		{
			idc=1;
			text="$STR_DISP_OK";
			x=0.85000002;
			default=1;
		};
		class TextName: RscText
		{
			x=0.025;
			y=0.25;
			w=0.44999999;
			text="$STR_DISP_NEW_USER_NAME";
		};
		class ValueName: RscEdit
		{
			idc=105;
			x=0.025;
			y=0.30000001;
			w=0.44999999;
			h=0.059999999;
		};
		class ValueId: RscText
		{
			idc=111;
			x=0.025;
			y=0.2;
			w=0.44999999;
		};
		class TextFace: RscText
		{
			x=0.52499998;
			y=0.2;
			w=0.44999999;
			text="$STR_DISP_NEW_USER_FACE";
		};
		class ValueFace: RscListBox
		{
			idc=106;
			x=0.52499998;
			y=0.25;
			w=0.44999999;
			h=0.18000001;
			rows=3;
		};
		class TextGlasses: RscText
		{
			x=0.52499998;
			y=0.44999999;
			w=0.44999999;
			text="$STR_DISP_NEW_USER_GLASSES";
		};
		class ValueGlasses: RscListBox
		{
			idc=110;
			x=0.52499998;
			y=0.5;
			w=0.44999999;
			h=0.12;
			rows=2;
		};
		class TextSpeaker: RscText
		{
			x=0.52499998;
			y=0.64999998;
			w=0.44999999;
			text="$STR_DISP_NEW_USER_SPEAKER";
		};
		class ValueSpeaker: RscListBox
		{
			idc=107;
			x=0.52499998;
			y=0.69999999;
			w=0.44999999;
			h=0.12;
			rows=2;
		};
		class TextPitch: RscText
		{
			x=0.025;
			y=0.5;
			w=0.44999999;
			text="$STR_DISP_NEW_USER_PITCH";
		};
		class ValuePitch: RscSlider
		{
			idc=108;
			x=0.025;
			y=0.55000001;
			w=0.44999999;
			h=0.050000001;
		};
		class TextSquad: RscText
		{
			idc=113;
			x=0.025;
			y=0.37;
			w=0.44999999;
			text="$STR_DISP_NEW_USER_SQUAD";
		};
		class ValueSquad: RscEdit
		{
			idc=112;
			x=0.025;
			y=0.41999999;
			w=0.44999999;
			h=0.059999999;
		};
	};
};
class RscDisplayModLauncher: RscStandardDisplay
{
	idd=157;
	class controls
	{
		class Title: RscTitle
		{
			text="Expansions";
		};
		class ValueMods: RscListBox
		{
			idc=101;
			x=0.1;
			y=0.2;
			w=0.44999999;
			h=0.5;
			rows=10;
			active="#(argb,8,8,3)color(0,1,0,1)";
			enabled="#(argb,8,8,3)color(1,1,1,1)";
			disabled="#(argb,8,8,3)color(1,0,0,1)";
		};
		class ModPicture: RscPicture
		{
			idc=102;
			x=0.60000002;
			y=0.2;
			w=0.15000001;
			h=0.2;
		};
		class B_Up: RscActiveText
		{
			idc=103;
			x=0.64999998;
			y=0.40000001;
			w=0.2;
			text="Up";
		};
		class B_Down: RscActiveText
		{
			idc=104;
			x=0.64999998;
			y=0.44999999;
			w=0.2;
			text="Down";
		};
		class B_DisableEnable: RscActiveText
		{
			idc=105;
			x=0.64999998;
			y=0.5;
			w=0.2;
			text="Disable";
		};
		class B_Cancel: RscActiveText
		{
			idc=2;
			x=0.44999999;
			y=0.89999998;
			w=0.12;
			text="$STR_DISP_CANCEL";
		};
		class B_ModAction: RscActiveText
		{
			idc=106;
			x=0.64999998;
			y=0.89999998;
			w=0.12;
			text="Mod Info";
		};
		class B_OK: B_Cancel
		{
			idc=1;
			text="$STR_DISP_OK";
			x=0.85000002;
			default=1;
		};
	};
};
class RscDisplayOptions
{
	idd=3;
	movingEnable=1;
	enableDisplay=1;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_OPTIONS_TITLE";
		};
		class Video: RscButton
		{
			idc=301;
			style=2;
			x=0.34999999;
			y=0.2;
			h=0.050000001;
			w=0.30000001;
			text="$STR_DISP_OPTIONS_VIDEO";
		};
		class Audio: Video
		{
			idc=302;
			y="0.2 + 0.1";
			text="$STR_DISP_OPTIONS_AUDIO";
		};
		class Configure: Video
		{
			idc=303;
			y="0.2 + 0.2";
			text="$STR_DISP_OPTIONS_CONFIGURE";
		};
		class GameOptions: Video
		{
			idc=307;
			y="0.2 + 0.3";
			text="$STR_DISP_OPTIONS_GAME_OPTIONS";
		};
		class B_Credits: RscActiveText
		{
			idc=306;
			x=0.050000001;
			y=0.89999998;
			w=0.15000001;
			text="$STR_DISP_MAIN_CREDITS";
		};
		class B_Close: B_Credits
		{
			idc=2;
			x=0.85000002;
			text="$STR_DISP_CLOSE";
			default=1;
		};
	};
};
class RscDisplayOptionsInGame
{
	idd=3;
	movingEnable=1;
	enableDisplay=1;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_OPTIONS_TITLE";
		};
		class Video: RscButton
		{
			idc=301;
			style=2;
			x=0.34999999;
			y=0.2;
			h=0.050000001;
			text="$STR_DISP_OPTIONS_VIDEO";
		};
		class Audio: Video
		{
			idc=302;
			y="0.2 + 0.1";
			text="$STR_DISP_OPTIONS_AUDIO";
		};
		class Configure: Video
		{
			idc=303;
			y="0.2 + 0.2";
			text="$STR_DISP_OPTIONS_CONFIGURE";
		};
		class GameOptions: Video
		{
			idc=307;
			y="0.2 + 0.3";
			text="$STR_DISP_OPTIONS_GAME_OPTIONS";
		};
		class B_Credits: RscActiveText
		{
			idc=306;
			x=0.050000001;
			y=0.89999998;
			w=0.15000001;
			text="$STR_DISP_MAIN_CREDITS";
		};
		class B_Close: B_Credits
		{
			idc=2;
			x=0.85000002;
			text="$STR_DISP_CLOSE";
			default=1;
		};
	};
};
class RscDisplayOptionsVideo
{
	idd=5;
	movingEnable=1;
	enableDisplay=1;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_OPTIONS_VIDEO";
		};
		class TextIGUISize: RscText
		{
			x=0.018999999;
			y=0.13500001;
			w=0.2;
			text="IGUI size";
		};
		class ValueIGUISize: RscListBox
		{
			idc=136;
			x=0.018999999;
			y=0.18000001;
			w=0.185;
			h=0.20999999;
		};
		class TextResolution: TextIGUISize
		{
			x=0.018999999;
			text="$STR_DISP_OPT_RESOLUTION";
		};
		class ValueResolution: ValueIGUISize
		{
			idc=113;
			x=0.018999999;
		};
		class TextAspectRatio: TextIGUISize
		{
			x=0.214;
			text="$STR_DISP_OPT_ASPECT_RATIO";
		};
		class ValueAspectRatio: ValueIGUISize
		{
			idc=134;
			x=0.214;
		};
		class TextRefresh: TextIGUISize
		{
			x=0.40900001;
			text="$STR_DISP_OPT_REFRESH";
		};
		class ValueRefresh: ValueIGUISize
		{
			idc=114;
			x=0.40900001;
			w=0.145;
		};
		class TextObjectsDetail: RscText
		{
			x=0.018999999;
			y=0.41499999;
			w=0.185;
			sizeEx=0.027000001;
			text="$STR_DISP_OPT_OBJECTS_DETAIL";
		};
		class ValueObjectsDetail: RscListBox
		{
			idc=124;
			x=0.018999999;
			y=0.46000001;
			w=0.185;
			h=0.13500001;
			sizeEx=0.027000001;
			rows=5;
		};
		class TextTextureDetail: TextObjectsDetail
		{
			x=0.214;
			y=0.41499999;
			sizeEx=0.027000001;
			text="$STR_DISP_OPT_TEXTURE_DETAIL";
		};
		class ValueTextureDetail: ValueObjectsDetail
		{
			idc=125;
			sizeEx=0.027000001;
			x=0.214;
			y=0.46000001;
		};
		class TextQualityPreference: TextObjectsDetail
		{
			x=0.40900001;
			y=0.41499999;
			sizeEx=0.027000001;
			text="$STR_DISP_OPT_QUALITY_PREFERENCE";
		};
		class ValueQualityPreference: ValueObjectsDetail
		{
			idc=126;
			x=0.40900001;
			y=0.46000001;
			sizeEx=0.027000001;
		};
		class TextShadingDetail: TextObjectsDetail
		{
			x=0.018999999;
			y=0.61500001;
			text="$STR_DISP_OPT_SHADING_DETAIL";
			sizeEx=0.027000001;
		};
		class ValueShadingDetail: ValueObjectsDetail
		{
			idc=127;
			x=0.018999999;
			y=0.66000003;
			sizeEx=0.027000001;
		};
		class TextTerrain: TextObjectsDetail
		{
			x=0.214;
			y=0.61500001;
			text="$STR_DISP_OPT_TERRAIN";
			sizeEx=0.027000001;
		};
		class ValueTerrain: ValueObjectsDetail
		{
			idc=123;
			x=0.214;
			y=0.66000003;
			sizeEx=0.027000001;
		};
		class TextShadowDetail: TextObjectsDetail
		{
			x=0.40900001;
			y=0.61500001;
			text="$STR_DISP_OPT_SHADOW_DETAIL";
			sizeEx=0.027000001;
		};
		class ValueShadowDetail: ValueObjectsDetail
		{
			idc=128;
			x=0.40900001;
			y=0.66000003;
			sizeEx=0.027000001;
		};
		class TextHDRDetail: TextObjectsDetail
		{
			x=0.60399997;
			y=0.41499999;
			text="$STR_DISP_OPT_HDR_DETAIL";
			sizeEx=0.027000001;
		};
		class ValueHDRDetail: ValueObjectsDetail
		{
			idc=131;
			x=0.60399997;
			y=0.46000001;
			sizeEx=0.027000001;
		};
		class TextAnisotropicDetail: TextObjectsDetail
		{
			x=0.60399997;
			y=0.61500001;
			text="$STR_DISP_OPT_ANISO_DETAIL";
			sizeEx=0.027000001;
		};
		class ValueAnisotropicDetail: ValueObjectsDetail
		{
			idc=130;
			x=0.60399997;
			y=0.66000003;
			sizeEx=0.027000001;
		};
		class TextVsync: TextObjectsDetail
		{
			x=0.60399997;
			y=0.815;
			text="Vsync";
			sizeEx=0.027000001;
		};
		class ValueVsync: ValueObjectsDetail
		{
			idc=140;
			x=0.60399997;
			y=0.86000001;
			sizeEx=0.027000001;
		};
		class TextPostprocessEffects: TextObjectsDetail
		{
			x=0.79900002;
			y=0.41499999;
			text="$STR_DISP_OPT_POSTPROCESS_EFFECTS";
			sizeEx=0.027000001;
		};
		class ValuePostprocessEffects: ValueObjectsDetail
		{
			idc=132;
			x=0.79900002;
			y=0.46000001;
			sizeEx=0.027000001;
		};
		class TextAntialiasing: TextObjectsDetail
		{
			x=0.79900002;
			y=0.61500001;
			text="$STR_DISP_OPT_FSAA_DETAIL";
			sizeEx=0.027000001;
		};
		class ValueAntialiasing: ValueObjectsDetail
		{
			idc=133;
			x=0.79900002;
			y=0.66000003;
			sizeEx=0.027000001;
		};
		class TextPIPDetail: TextObjectsDetail
		{
			x=0.050000001;
			y=0.15000001;
			text="$STR_DISP_OPT_PIP";
			sizeEx=0.027000001;
		};
		class ValuePIPDetail: RscListBox
		{
			idc=334;
			x=0.34999999;
			y=0.15000001;
			sizeEx=0.027000001;
			w=0.185;
			h=0.13500001;
			rows=2;
		};
		class ValueFXAADetail: RscListBox
		{
			idc=336;
			x=0.34999999;
			y=0.15000001;
			sizeEx=0.027000001;
			w=0.185;
			h=0.13500001;
			rows=2;
		};
		class TextSWDetail: TextObjectsDetail
		{
			x=0.55000001;
			y=0.15000001;
			text="$STR_DISP_OPT_CLOUDS";
			sizeEx=0.027000001;
		};
		class ValueSWDetail: RscListBox
		{
			idc=335;
			x=0.75;
			y=0.15000001;
			sizeEx=0.027000001;
			w=0.185;
			h=0.13500001;
			rows=2;
		};
		class TextWBuffer: RscTextSmall
		{
			x=0.018999999;
			y=0.815;
			w=0.30000001;
			text="$STR_DISP_OPT_WBUFFER";
		};
		class ValueWBuffer: RscActiveText
		{
			idc=121;
			x=0.17900001;
			y=0.815;
			w=0.15000001;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextBrightness: RscText
		{
			x=0.56;
			y=0.13500001;
			w=0.30000001;
			sizeEx=0.027000001;
			text="$STR_DISP_OPT_BRIGHT";
		};
		class ValueBrightness: RscText
		{
			idc=111;
			x=0.86000001;
			y=0.13500001;
			w=0.1;
			sizeEx=0.027000001;
		};
		class SliderBrightness: RscSlider
		{
			idc=112;
			x=0.56;
			y=0.19;
			w=0.41499999;
		};
		class TextGamma: RscText
		{
			x=0.56;
			y=0.22499999;
			w=0.30000001;
			sizeEx=0.027000001;
			text="$STR_DISP_OPT_GAMMA";
		};
		class ValueGamma: RscText
		{
			idc=109;
			x=0.86000001;
			y=0.22499999;
			w=0.1;
			sizeEx=0.027000001;
		};
		class SliderGamma: RscSlider
		{
			idc=110;
			x=0.56;
			y=0.28;
			w=0.41499999;
		};
		class TextVisibility: RscText
		{
			x=0.56;
			y=0.315;
			w=0.30000001;
			sizeEx=0.027000001;
			text="$STR_DISP_OPT_VISIBILITY";
		};
		class ValueVisibility: RscText
		{
			idc=103;
			x=0.86000001;
			y=0.315;
			w=0.1;
			sizeEx=0.027000001;
		};
		class SliderVisibility: RscSlider
		{
			idc=104;
			x=0.56;
			y=0.37;
			w=0.41499999;
		};
		class TextShadowVisibility: RscText
		{
			idc=313;
			x=0.050000001;
			y=0.050000001;
			w=0.30000001;
			sizeEx=0.027000001;
			text="$STR_DISP_OPT_SHADOW_DIST";
		};
		class ValueShadowVisibility: RscText
		{
			idc=311;
			x=0.40000001;
			y=0.050000001;
			w=0.1;
			sizeEx=0.027000001;
		};
		class SliderShadowVisibility: RscSlider
		{
			idc=312;
			x=0.55000001;
			y=0.050000001;
			w=0.41499999;
		};
		class B_Cancel: RscActiveText
		{
			idc=2;
			x=0.60000002;
			y=0.89999998;
			w=0.13;
			text="$STR_DISP_CANCEL";
		};
		class B_OK: B_Cancel
		{
			idc=1;
			text="$STR_DISP_OK";
			x=0.85000002;
			default=1;
		};
		class B_Default: RscActiveText
		{
			idc=129;
			x=0.050000001;
			y=0.89999998;
			w=0.15000001;
			text="$STR_DISP_DEFAULT";
		};
	};
};
class RscDisplayOptionsAudio
{
	idd=6;
	movingEnable=1;
	enableDisplay=1;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_OPTIONS_AUDIO";
		};
		class TextEffects: RscText
		{
			x=0.34999999;
			y=0.2;
			w=0.30000001;
			text="$STR_DISP_OPT_EFFECTS";
		};
		class ValueEffects: RscText
		{
			idc=103;
			x=0.5;
			y=0.2;
		};
		class SliderEffects: RscSlider
		{
			idc=104;
			x=0.2;
			y=0.25;
			w=0.60000002;
		};
		class TextVoices: RscText
		{
			x=0.34999999;
			y=0.30000001;
			w=0.30000001;
			text="$STR_DISP_OPT_VOICES";
		};
		class ValueVoices: RscText
		{
			idc=105;
			x=0.5;
			y=0.30000001;
		};
		class SliderVoices: RscSlider
		{
			idc=106;
			x=0.2;
			y=0.34999999;
			w=0.60000002;
		};
		class ValueVON: RscText
		{
			idc=113;
			x=0.5;
			y=0.69999999;
		};
		class SliderVON: RscSlider
		{
			idc=114;
			x=0.2;
			y=0.75;
			w=0.60000002;
		};
		class ValueSamplesCount: RscText
		{
			idc=115;
			x=0.5;
			y=0.69999999;
		};
		class SliderSamplesCount: RscSlider
		{
			idc=116;
			x=0.2;
			y=0.85000002;
			w=0.60000002;
		};
		class TextMusic: RscText
		{
			x=0.34999999;
			y=0.40000001;
			w=0.30000001;
			text="$STR_DISP_OPT_MUSIC";
		};
		class ValueMusic: RscText
		{
			idc=101;
			x=0.5;
			y=0.40000001;
		};
		class SliderMusic: RscSlider
		{
			idc=102;
			x=0.2;
			y=0.44999999;
			w=0.60000002;
		};
		class TextMicSensitivity: RscText
		{
			x=0.159803;
			y="(0.420549 + 3*0.069854)";
			text="Mic. sens.:";
		};
		class SliderMicSensitivity: RscSlider
		{
			idc=117;
			x=0.2;
			y="(0.420549 + 3*0.069854)";
			w=0.40000001;
		};
		class AutoAdjustMicSensitivity: RscActiveText
		{
			idc=118;
			x=0.30000001;
			y=0.69999999;
			w=0.60000002;
			text="Auto adjust";
		};
		class TextHWAcc: RscText
		{
			x=0.22;
			y=0.60000002;
			w=0.40000001;
			text="$STR_DISP_OPT_HWACC";
		};
		class ValueHWAcc: RscListBox
		{
			idc=108;
			x=0.62;
			y=0.60000002;
			w=0.15000001;
			h=0.079999998;
		};
		class TextEAX: TextHWAcc
		{
			y="0.6 + (1 * 0.09)";
			text="$STR_DISP_OPT_EAX";
		};
		class ValueEAX: ValueHWAcc
		{
			idc=109;
			y="0.6 + (1 * 0.09)";
		};
		class TextPlayerVoice: TextHWAcc
		{
			y="0.6 + (2 * 0.09)";
			text="$STR_DISP_OPT_PLAYER_VOICE";
		};
		class ValuePlayerVoice: ValueHWAcc
		{
			idc=110;
			y="0.6 + (2 * 0.09)";
		};
		class B_Cancel: RscActiveText
		{
			idc=2;
			x=0.60000002;
			y=0.89999998;
			w=0.15000001;
			text="$STR_DISP_CANCEL";
		};
		class B_OK: B_Cancel
		{
			idc=1;
			text="$STR_DISP_OK";
			x=0.85000002;
			default=1;
		};
		class B_Default: RscActiveText
		{
			idc=111;
			x=0.050000001;
			y=0.89999998;
			w=0.15000001;
			text="$STR_DISP_DEFAULT";
		};
	};
};
class RscDisplayMicSensitivityOptions
{
	idd=262;
	movingEnable=1;
	enableDisplay=1;
	class controls
	{
		class Title: RscTitle
		{
			text="Microphone sensitivity adjustment";
		};
		class B_Start: RscActiveText
		{
			idc="IDC_OPTIONS_MIC_START_ADJUST";
			x=0.1;
			y=0.15000001;
			w=0.15000001;
			text="Start";
		};
		class TextProgress: RscText
		{
			x=0.25;
			y=0.15000001;
			w=0.30000001;
			text="Done:";
		};
		class TextProgressVal: RscText
		{
			x=0.30000001;
			y=0.15000001;
			w=0.30000001;
			text=" 0%";
			idc=1002;
		};
		class B_Cancel: RscActiveText
		{
			idc=2;
			x=0.1;
			y=0.2;
			w=0.15000001;
			text="$STR_DISP_CANCEL";
		};
		class B_OK: B_Cancel
		{
			idc=1;
			text="$STR_DISP_OK";
			x=0.2;
			y=0.2;
			default=1;
		};
	};
};
class RscDisplayGameOptions
{
	idd=151;
	movingEnable=1;
	enableDisplay=1;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_OPTIONS_GAME_OPTIONS";
		};
		class TextSubtitles: RscText
		{
			x=0.025;
			y=0.2;
			w="0.95 * 0.6";
			text="$STR_OPT_SUBTITLES";
		};
		class RadioSubtitles: TextSubtitles
		{
			y=0.30000001;
			text="$STR_OPT_RADIO_SUBTITLES";
		};
		class TextGore: TextSubtitles
		{
			idc=122;
			y=0.40000001;
			text="$STR_DISP_OPT_BLOOD";
		};
		class TextLanguage: TextSubtitles
		{
			y=0.5;
			text="$STR_DISP_OPT_LANGUAGE";
		};
		class TextFloatingZone: RscText
		{
			x=0.60000002;
			y=0.60000002;
			w=0.15000001;
			text="$STR_DISP_CONF_FLOATING_ZONE";
		};
		class Subtitles: RscListBox
		{
			idc=102;
			x=0.60000002;
			y=0.2;
			w=0.15000001;
			h=0.079999998;
		};
		class Radio: Subtitles
		{
			idc=103;
			x=0.60000002;
			y=0.30000001;
			w=0.15000001;
			h=0.079999998;
		};
		class ValueBlood: Subtitles
		{
			idc=119;
			x=0.60000002;
			y=0.40000001;
			h=0.12;
		};
		class ValueLanguage: Subtitles
		{
			idc=135;
			x=0.60000002;
			y=0.5;
			h=0.12;
		};
		class ValueFloatingZone: RscSlider
		{
			idc=109;
			x=0.60000002;
			y=0.60000002;
			w=0.34999999;
			h=0.029999999;
		};
		class TextHeadBob: RscText
		{
			x=0.60000002;
			y=0.69999999;
			w=0.15000001;
			text="$STR_DISP_OPT_HEADBOB";
		};
		class ValueHeadBob: RscSlider
		{
			idc=138;
			x=0.60000002;
			y=0.69999999;
			w=0.34999999;
			h=0.029999999;
		};
		class B_Difficulty: RscActiveText
		{
			idc=304;
			x=0.025;
			y=0.60000002;
			w=0.15000001;
			text="$STR_DISP_OPTIONS_DIFFICULTY";
		};
		class B_OK: B_Difficulty
		{
			idc=1;
			x=0.85000002;
			y=0.89999998;
			text="$STR_DISP_OK";
			default=1;
		};
		class B_Cancel: B_Difficulty
		{
			idc=2;
			x=0.60000002;
			y=0.89999998;
			text="$STR_DISP_CANCEL";
		};
	};
};
class RscListBoxKeys: RscListBox
{
	collisionColor[]={1,0,0,1};
	collisionColorFirstKey[]={0,0.69999999,0.89999998,1};
	disabledKeyColor[]={0.30000001,0.30000001,0.30000001,1};
	mainCollumW=0.40000001;
	secndCollumW=0.60000002;
};
class RscDisplayControlSchemes
{
	idd=163;
	movingEnable=1;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_OPTIONS_SCHEME";
			x=0.31;
			y=0.25;
			w=0.37;
			h=0.039999999;
		};
		class ControlsSchemes: RscListBox
		{
			idc=101;
			rows=10;
			x=0.31;
			y=0.30000001;
			w=0.37;
			h=0.40000001;
			colorBackground[]={0,0,0,1};
		};
		class ButtonOK: RscButton
		{
			idc=1;
			x=0.5;
			y=0.69999999;
			w=0.18000001;
			h=0.039999999;
			text="$STR_DISP_OK";
			default=1;
		};
		class ButtonCancel: ButtonOK
		{
			idc=2;
			x=0.31;
			y=0.69999999;
			w=0.18000001;
			h=0.039999999;
			text="$STR_DISP_CANCEL";
			default=0;
		};
	};
};
class RscDisplayConfigure
{
	idd=4;
	movingEnable=1;
	enableDisplay=1;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_OPTIONS_CONFIGURE";
		};
		class TextName: RscText
		{
			x=0.025;
			y=0.2;
			w="0.95 * 0.95 * 0.4";
			text="$STR_DISP_CONF_NAME";
		};
		class TextKeys: RscText
		{
			x="0.025 + 0.95 * 0.95 * 0.4";
			y=0.2;
			w="0.95 * 0.95 * 0.6";
			text="$STR_DISP_CONF_KEYS";
		};
		class ControlsPageText: RscText
		{
			x=0.0099999998;
			y=0.15000001;
			w=0.1;
			h=0.039999999;
			text="$STR_DISP_CONF_SHOW";
		};
		class ControlsPage: RscCombo
		{
			idc=108;
			x=0.12;
			y=0.15000001;
			w=0.28999999;
			h=0.039999999;
		};
		class ValueKeys: RscListBoxKeys
		{
			idc=102;
			x=0.025;
			y=0.25;
			w=0.94999999;
			h=0.40000001;
			rowHeight=0.029999999;
			rows="0.4 / 0.03";
		};
		class TextReserved: RscText
		{
			x=0.0099999998;
			y=0.667;
			w=0.94999999;
			text="$STR_DISP_CONF_RES";
		};
		class TextMouseSens: RscText
		{
			x=0.0099999998;
			y=0.69999999;
			w=0.60000002;
			h=0.15000001;
			text="$STR_DISP_CONF_SENS";
		};
		class TextXAxis: RscText
		{
			x=0.050000001;
			y=0.78500003;
			w=0.15000001;
			text="$STR_DISP_CONF_XAXIS";
		};
		class TextMouseSmoothing: RscText
		{
			x=0.050000001;
			y=0.875;
			w=0.15000001;
			text="Smoothing:";
		};
		class ValueXAxis: RscSlider
		{
			idc=103;
			x=0.20999999;
			y=0.80000001;
			w=0.34999999;
			h=0.029999999;
		};
		class TextYAxis: RscText
		{
			x=0.050000001;
			y=0.82999998;
			w=0.15000001;
			text="$STR_DISP_CONF_YAXIS";
		};
		class ValueYAxis: RscSlider
		{
			idc=104;
			x=0.20999999;
			y=0.85000002;
			w=0.34999999;
			h=0.029999999;
		};
		class ValueMouseSmoothing: RscSlider
		{
			idc=110;
			x=0.20999999;
			y=0.88999999;
			w=0.34999999;
			h=0.029999999;
		};
		class ValueYReversed: RscListBox
		{
			idc=105;
			x=0.62;
			y=0.79000002;
			w=0.34999999;
			h=0.079999998;
		};
		class TextButtons: RscText
		{
			x=0.050000001;
			y=0.92000002;
			w=0.30000001;
			text="$STR_DISP_CONF_MOUSE_BUTTON";
		};
		class ValueButtons: RscActiveText
		{
			idc=107;
			x=0.5;
			y=0.92000002;
			w=0.075000003;
			style=2;
		};
		class ValueJoystick: RscActiveText
		{
			idc=106;
			x=0.60000002;
			y=0.98000002;
			w=0.34999999;
			text="Controllers";
			style=2;
		};
		class B_Default: RscActiveText
		{
			idc=101;
			x=0.16;
			y=0.98000002;
			w=0.15000001;
			text="$STR_DISP_DEFAULT";
		};
		class B_OK: B_Default
		{
			idc=1;
			x=0.86000001;
			text="$STR_DISP_OK";
			default=1;
		};
		class B_Cancel: B_Default
		{
			idc=2;
			x=0;
			text="$STR_DISP_CANCEL";
		};
	};
};
class RscDisplayConfigureAction
{
	idd=131;
	access=0;
	movingEnable=0;
	enableSimulation=0;
	enableDisplay=0;
	class ControlsBackground
	{
		class Background: RscText
		{
			x=0.2;
			y=0.2;
			w=0.60000002;
			h=0.69999999;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
	};
	class Controls
	{
		class Title: RscTitle
		{
			idc=101;
			style=2;
			x=0.2;
			y=0.2;
			w=0.60000002;
			text="$STR_DISP_CONFACT_TITLE";
		};
		class TextHelp: RscText
		{
			x=0.2;
			y=0.64999998;
			w=0.94999999;
			text="$STR_DISP_CONF_HELP";
		};
		class TextReserved: RscText
		{
			x=0.2;
			y=0.86000001;
			w=0.94999999;
			text="$STR_DISP_CONF_RES";
		};
		class ValueCurrentKeys: RscListBoxKeys
		{
			idc=102;
			x=0.2;
			y=0.25;
			w=0.25;
			h=0.40000001;
			rowHeight=0.029999999;
			rows="0.4 / 0.03";
			canDrag=1;
		};
		class ValueSpecialKeys: RscListBox
		{
			idc=103;
			x=0.55000001;
			y=0.25;
			w=0.25;
			h=0.40000001;
			rowHeight=0.029999999;
			rows="0.4 / 0.03";
			canDrag=1;
			colorSelect[]={0,0,0,1};
			colorSelect2[]={0,0,0,1};
			colorSelectBackground[]={0.30000001,0.30000001,0.30000001,1};
			colorSelectBackground2[]={0.30000001,0.30000001,0.30000001,1};
		};
		class RscConfActionButton: RscButton
		{
			w=0.1;
			h=0.050000001;
			font="TahomaB";
			sizeEx=0.027000001;
		};
		class B_Delete: RscConfActionButton
		{
			idc=104;
			x=0.2;
			y=0.69999999;
			text="$STR_DISP_DELETE";
		};
		class B_Default: RscConfActionButton
		{
			idc=105;
			x=0.32499999;
			y=0.69999999;
			text="$STR_DISP_DEFAULT";
		};
		class B_Clear: RscConfActionButton
		{
			idc=106;
			x=0.44999999;
			y=0.69999999;
			text="$STR_DISP_CONFACT_UNDO";
		};
		class B_Cancel: RscConfActionButton
		{
			idc=107;
			x=0.57499999;
			y=0.69999999;
			text="$STR_DISP_CANCEL,";
		};
		class B_Prev: RscConfActionButton
		{
			idc=108;
			x=0.2;
			y=0.76999998;
			text="$STR_USRACT_MENU_DOWN";
		};
		class B_Next: RscConfActionButton
		{
			idc=109;
			x=0.32499999;
			y=0.76999998;
			text="$STR_USRACT_MENU_UP";
		};
		class B_OK: RscConfActionButton
		{
			idc=1;
			x=0.69999999;
			y=0.69999999;
			text="$STR_DISP_OK";
			default=1;
		};
	};
};
class RscDisplayConfigureControllers
{
	idd=148;
	movingEnable=1;
	enableDisplay=1;
	class controls
	{
		class Title: RscTitle
		{
			text="Configure controllers";
		};
		class RscConfJoysticksButton: RscButton
		{
			w=0.2;
			h=0.050000001;
			font="TahomaB";
			sizeEx=0.027000001;
		};
		class RscControllersListBox: RscListBox
		{
			disabledCtrlColor[]={0.30000001,0.30000001,0.30000001,1};
		};
		class TextControllerList: RscText
		{
			x=0.30000001;
			y=0.2;
			w=0.34999999;
			text="Customizable controllers";
		};
		class ControllerList: RscControllersListBox
		{
			idc=104;
			x=0.30000001;
			y=0.25;
			w=0.34999999;
			h=0.30000001;
			rowHeight=0.050000001;
			rows="0.7 / 0.05";
		};
		class TextXInputList: RscText
		{
			x=0.30000001;
			y=0.55000001;
			w=0.34999999;
			text="Controllers with scheme";
		};
		class XInputList: RscControllersListBox
		{
			idc=103;
			x=0.30000001;
			y=0.60000002;
			w=0.34999999;
			h=0.2;
			rowHeight=0.050000001;
			rows="0.7 / 0.05";
		};
		class EnableDisable: RscConfJoysticksButton
		{
			idc=102;
			x=0.69999999;
			y=0.40000001;
			text="Enable";
		};
		class Customize: RscConfJoysticksButton
		{
			idc=101;
			x=0.69999999;
			y=0.5;
			text="Customize";
		};
		class Refresh: RscConfJoysticksButton
		{
			idc=105;
			x=0.69999999;
			y=0.60000002;
			text="Refresh";
		};
		class B_OK: RscConfJoysticksButton
		{
			idc=1;
			x=0.69999999;
			y=0.69999999;
			text="$STR_DISP_OK";
			default=1;
		};
	};
};
class RscDisplayCustomizeController
{
	idd=150;
	class Controls
	{
		class T_Background: RscText
		{
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
			x=0.02;
			y=0.079999998;
			w=0.70999998;
			h=0.41;
		};
		class T_Title: RscTitle
		{
			idc=104;
			style="0x20 + 0x02";
			x=0.02;
			y=0.090000004;
			w=0.70999998;
		};
		class G_ControlsGroup: RscControlsGroup
		{
			idc=101;
			x=0.02;
			y=0.15000001;
			w=0.81;
			h=0.23999999;
			class Controls
			{
			};
		};
		class B_OK: RscButton
		{
			idc=1;
			x=0.37;
			y=0.41999999;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_OK";
			default=1;
		};
		class B_Unmap: B_OK
		{
			idc=102;
			x=0.090000004;
			text="$STR_OPT_CONTROLLERS_UNMAP";
			default=0;
		};
		class B_Default: B_OK
		{
			idc=103;
			x=0.23;
			text="$STR_DISP_DEFAULT_CURVE";
			default=0;
		};
		class B_Default_Bind: B_OK
		{
			idc=105;
			x=0.23;
			y=0.5;
			text="$STR_DISP_DEFAULT_MAP";
			default=0;
		};
		class B_Cancel: B_OK
		{
			idc=2;
			x=0.50999999;
			text="$STR_DISP_CANCEL";
			default=0;
		};
		class B_Advanced: B_OK
		{
			idc=106;
			x=0.61000001;
			text="$STR_DISP_SHOW";
			default=0;
		};
	};
	class Title: RscText
	{
		x=0.059999999;
		y=0;
		w=0.12;
		h=0.025;
		sizeEx=0.025;
		text="";
	};
	axisActiveIcon="#(argb,8,8,3)color(1,0,0,1)";
	class ActiveAxis: RscPicture
	{
		idc=320;
		x=0.02;
		y=0;
		w=0.025;
		h=0.025;
		text="#(argb,8,8,3)color(1,0,0,1)";
	};
	class Slider: RscXSliderH
	{
		x=0.18000001;
		y=0;
		w=0.40000001;
		h=0.025;
		vspacing=0.015;
	};
	class DeadZoneSlider: RscXSliderH
	{
		type=43;
		style="0x400	+ 0x10";
		x=0.60000002;
		y=0;
		w=0.13;
		h=0.045000002;
		vspacing=0.050000001;
	};
	class Steepness: RscListBox
	{
		x=0.75;
		y=0;
		w=0.12;
		h=0.045000002;
		vspacing=0.050000001;
		values[]={"1.0","1.2","1.5","1.9","2.4","3.0"};
	};
	class AxisValue: RscText
	{
		x=0.88999999;
		y=0;
		w=0.1;
		h=0.045000002;
		vspacing=0.050000001;
	};
};
class RscDisplayJoystickSchemes
{
	idd=159;
	movingEnable=1;
	enableDisplay=1;
	class controls
	{
		class T_Title: RscTitle
		{
			idc=101;
			style="0x20 + 0x02";
			x=0.02;
			y=0.090000004;
			w=0.70999998;
			text="Map controller: %s";
		};
		class RscJoysticksSchemeButton: RscButton
		{
			w=0.2;
			h=0.050000001;
			font="TahomaB";
			sizeEx=0.027000001;
		};
		class TextJoySchemesList: RscText
		{
			x=0.30000001;
			y=0.2;
			w=0.34999999;
			text="Joystick schemes";
		};
		class SchemesList: RscListBox
		{
			idc=102;
			x=0.30000001;
			y=0.25;
			w=0.34999999;
			h=0.30000001;
			rowHeight=0.050000001;
			rows="0.7 / 0.05";
		};
		class B_MapScheme: RscJoysticksSchemeButton
		{
			idc=103;
			x=0.69999999;
			y=0.40000001;
			text="Map";
		};
		class B_Cancel: RscJoysticksSchemeButton
		{
			idc=2;
			x=0.69999999;
			y=0.5;
			text="$STR_DISP_CANCEL";
			default=1;
		};
	};
};
class RscDisplayCredits: RscStandardDisplay
{
	idd=34;
	class controls
	{
		class Text1: RscText
		{
			idc=50001;
			x=0;
			y=0.40000001;
			w=1;
			style=2;
			text="$STR_CREDIT_FP2ENGINE";
		};
		class Text2: Text1
		{
			idc=50002;
			y=0.44999999;
			sizeEx=0.027000001;
			text="$STR_CREDIT_COPYRIGHT";
		};
		class Text3: Text1
		{
			idc=50003;
			y=0.47999999;
			sizeEx=0.027000001;
			text="$STR_CREDIT_RIGHTS";
		};
		class B_Cancel: RscActiveText
		{
			idc=2;
			x=0.40000001;
			y=0.89999998;
			w=0.2;
			text="$STR_DISP_CANCEL";
		};
	};
};
class RscDisplayFieldManual: RscStandardDisplay
{
	idd=162;
	class controlsBackground
	{
		class TitleBackground: RscText
		{
			idc=-1;
			x="0.025 * safezoneW + safezoneX";
			y="0.04 * safezoneH + safezoneY";
			w="0.35 * safezoneW";
			h="0.04 * safezoneH";
			colorBackground[]={0,0,0,0.80000001};
		};
		class HintContentBackground: RscText
		{
			idc=-1;
			x="0.4875 * safezoneW + safezoneX";
			y="0.124 * safezoneH + safezoneY";
			w="0.408333 * safezoneW";
			h="0.792 * safezoneH";
			colorBackground[]={0,0,0,0.69999999};
		};
	};
	class controls
	{
		class ButtonCancel: RscShortcutButton
		{
			idc=2;
			shortcuts[]=
			{
				"0x00050000 + 1"
			};
			text="$STR_DISP_BACK";
			x="0.025 * safezoneW + safezoneX";
			y="0.92 * safezoneH + safezoneY";
			w="0.15625 * safezoneW";
			h="0.04 * safezoneH";
		};
		class ListBoxTopic: RscListBox
		{
			idc=1500;
			x="0.025 * safezoneW + safezoneX";
			y="0.124 * safezoneH + safezoneY";
			w="0.205 * safezoneW";
			h="0.792 * safezoneH";
			colorBackground[]={0,0,0,0.69999999};
		};
		class ListBoxItem: RscListBox
		{
			idc=1501;
			x="0.2325 * safezoneW + safezoneX";
			y="0.124 * safezoneH + safezoneY";
			w="0.25 * safezoneW";
			h="0.792 * safezoneH";
			colorBackground[]={0,0,0,0.69999999};
		};
		class DescriptionControlsGroup: RscControlsGroup
		{
			idc=2300;
			x="0.495 * safezoneW + safezoneX";
			y="0.324 * safezoneH + safezoneY";
			w="0.48 * safezoneW";
			h="0.584 * safezoneH";
			class controls
			{
				class HintDescription: RscStructuredText
				{
					idc=1100;
					size=0.027000001;
					x="0 * safezoneW";
					y="0 * safezoneH";
					w="0.47 * safezoneW";
					h="0.584 * safezoneH";
				};
			};
		};
		class Title: RscTitle
		{
			idc=1000;
			text="$STR_A3_RscDisplayFieldManual_Title";
			x="0.025 * safezoneW + safezoneX";
			y="0.04 * safezoneH + safezoneY";
			w="0.35 * safezoneW";
			h="0.04 * safezoneH";
		};
		class PlayersName: Title
		{
			idc=8434;
			style=1;
			x="0.375 * safezoneW + safezoneX";
			y="0.04 * safezoneH + safezoneY";
			w="0.6 * safezoneW";
			h="0.04 * safezoneH";
		};
		class TextTopics: RscText
		{
			idc=1002;
			text="$STR_A3_RscDisplayFieldManual_TextTopics";
			x="0.025 * safezoneW + safezoneX";
			y="0.084 * safezoneH + safezoneY";
			w="0.205 * safezoneW";
			h="0.04 * safezoneH";
			colorBackground[]={0,0,0,1};
		};
		class TextHints: RscText
		{
			idc=1003;
			text="$STR_A3_RscDisplayFieldManual_TextHints";
			x="0.2325 * safezoneW + safezoneX";
			y="0.084 * safezoneH + safezoneY";
			w="0.25 * safezoneW";
			h="0.04 * safezoneH";
			colorBackground[]={0,0,0,1};
		};
		class TextHintContent: RscText
		{
			idc=1004;
			text="$STR_A3_RscDisplayFieldManual_TextHintContent";
			x="0.485 * safezoneW + safezoneX";
			y="0.084 * safezoneH + safezoneY";
			w="0.49 * safezoneW";
			h="0.04 * safezoneH";
			colorBackground[]={0,0,0,1};
		};
		class Picture: RscPicture
		{
			idc=1200;
			text="#(argb,8,8,3)color(1,1,1,0.1)";
			x="0.4975 * safezoneW + safezoneX";
			y="0.144 * safezoneH + safezoneY";
			w="0.1 * safezoneW";
			h="0.16 * safezoneH";
		};
		class HintTitle: RscStructuredText
		{
			idc=1101;
			size=0.027000001;
			x="0.61 * safezoneW + safezoneX";
			y="0.144 * safezoneH + safezoneY";
			w="0.365 * safezoneW";
			h="0.16 * safezoneH";
		};
	};
};
class RscDisplaySelectIsland: RscStandardDisplay
{
	idd=51;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_SELECT_ISLAND";
		};
		class Islands: RscListBox
		{
			idc=101;
			x=0.025;
			y=0.2;
			w=0.94999999;
			h=0.60000002;
			rows=8;
		};
		class B_Editor: RscActiveText
		{
			idc=105;
			x=0.0099999998;
			y=0.89999998;
			w=0.30000001;
			text="Old-style editor";
		};
		class B_Cancel: RscActiveText
		{
			idc=2;
			x=0.58999997;
			y=0.89999998;
			w=0.25;
			text="$STR_DISP_CANCEL";
		};
		class B_OK: B_Cancel
		{
			idc=104;
			x=0.83999997;
			w=0.15000001;
			text="$STR_DISP_OK";
			default=1;
		};
	};
};
class RscDisplaySelectIslandNew: RscStandardDisplay
{
	idd=351;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_SELECT_ISLAND";
		};
		class Islands: RscListBox
		{
			idc=101;
			x=0.025;
			y=0.2;
			w=0.94999999;
			h=0.60000002;
			rows=8;
		};
		class B_Editor: RscActiveText
		{
			idc=105;
			x=0.0099999998;
			y=0.89999998;
			w=0.30000001;
			text="Old-style editor";
		};
		class B_Cancel: RscActiveText
		{
			idc=2;
			x=0.58999997;
			y=0.89999998;
			w=0.25;
			text="$STR_DISP_CANCEL";
		};
		class B_OK: B_Cancel
		{
			idc=104;
			x=0.83999997;
			w=0.15000001;
			text="$STR_DISP_OK";
			default=1;
		};
	};
};
class RscDisplayCustomArcade: RscStandardDisplay
{
	idd=25;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_MAIN_DESIGN";
		};
		class Game: RscTree
		{
			idc=101;
			x=0.23999999;
			y=0.22;
			w=0.51999998;
			h=0.56;
			style=2;
		};
		class B_Edit: RscShortcutButton
		{
			idc=103;
			x=0.22;
			y=0.89999998;
			w=0.16;
			h=0.050000001;
			text="$STR_DISP_ERROR";
		};
		class B_Delete: RscButton
		{
			idc=104;
			x=0.36000001;
			y=0.89999998;
			w=0.16;
			h=0.050000001;
			text="$STR_DISP_DELETE";
		};
		class B_Play: B_Delete
		{
			idc=102;
			x=0.51999998;
			text="$STR_DISP_CUST_PLAY";
			default=1;
		};
		class B_Cancel: B_Delete
		{
			idc=2;
			x=0.66000003;
			text="$STR_DISP_CANCEL";
		};
	};
};
class RscDisplayArcadeMap: RscMap
{
	movingEnable=0;
	idd=26;
	textureClear="#(argb,8,8,3)color(1,1,1,1)";
	textureCloudly="#(argb,8,8,3)color(1,1,1,1)";
	textureOvercast="#(argb,8,8,3)color(1,1,1,1)";
	textureRainy="#(argb,8,8,3)color(1,1,1,1)";
	textureStormy="#(argb,8,8,3)color(1,1,1,1)";
	defaultSide=1;
	class controls: controls
	{
		class Map: Map
		{
		};
		class Background1: RscText
		{
			x=0.82999998;
			y=0;
			w=0.17;
			h=1;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class MissionName: RscText
		{
			x=0;
			y=0;
			w=0.55000001;
			text="";
			idc=113;
		};
		class ToolboxMode: RscToolbox
		{
			idc=104;
			x=0.83999997;
			y=0.11;
			w=0.15000001;
			h=0.2;
			strings[]=
			{
				"$STR_DISP_ARCMAP_UNITS",
				"$STR_DISP_ARCMAP_GROUPS",
				"$STR_DISP_ARCMAP_SENSORS",
				"$STR_DISP_ARCMAP_WAYPOINTS",
				"$STR_DISP_ARCMAP_SYNCHRONIZE",
				"$STR_DISP_ARCMAP_MARKERS",
				"$STR_DISP_ARCMAP_MODULE"
			};
			rows=7;
			columns=1;
		};
		class B_Intel: RscActiveText
		{
			idc=105;
			x=0.82999998;
			y=0.059999999;
			w=0.17;
			style=2;
			text="$STR_DISP_ARCMAP_INTEL";
		};
		class B_Load: RscButton
		{
			idc=101;
			x=0.83999997;
			y=0.31999999;
			w=0.15000001;
			h=0.035;
			sizeEx=0.027000001;
			text="$STR_DISP_ARCMAP_LOAD";
		};
		class B_Merge: B_Load
		{
			idc=106;
			y=0.38;
			text="$STR_DISP_ARCMAP_MERGE";
		};
		class B_Save: B_Load
		{
			idc=102;
			y=0.44;
			text="$STR_DISP_ARCMAP_SAVE";
		};
		class B_Clear: B_Load
		{
			idc=103;
			y=0.5;
			text="$STR_DISP_ARCMAP_CLEAR";
		};
		class Section: RscCombo
		{
			idc=109;
			x=0.83999997;
			y=0.56;
			w=0.15000001;
			h=0.029999999;
			wholeHeight=0.12;
			sizeEx=0.027000001;
		};
		class B_Ids: B_Load
		{
			idc=111;
			y=0.62;
			text="$STR_DISP_ERROR";
		};
		class B_Textures: B_Load
		{
			idc=112;
			y=0.68000001;
			text="$STR_DISP_ERROR";
		};
		class B_Preview: B_Load
		{
			idc=107;
			y=0.755;
			text="$STR_DISP_ARCMAP_PREVIEW";
			default=1;
		};
		class B_Continue: B_Load
		{
			idc=108;
			y=0.815;
			text="$STR_DISP_ARCMAP_CONTINUE";
		};
		class B_Cancel: B_Load
		{
			idc=2;
			y=0.875;
			text="$STR_DISP_ARCMAP_EXIT";
		};
		class TrafficLight: RscActiveText
		{
			idc=121;
			x="0.95 * safezoneW + safezoneX";
			y="0.92 * safezoneH + safezoneY";
			w="0.025 * safezoneW";
			h="0.04 * safezoneH";
			style=48;
			color[]={1,1,1,0.69999999};
			colorActive[]={1,1,1,1};
			text="#(argb,8,8,3)color(1,1,1,1)";
		};
	};
};
class RscDisplayArcadeUnit
{
	idd=27;
	movingEnable=1;
	class controls
	{
		class Background: RscText
		{
			x=0.15000001;
			y=0.02;
			w=0.60000002;
			h=0.94999999;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class Title: RscTitle
		{
			idc=101;
			style="0x20 + 0x02";
			x=0.15000001;
			y=0.039999999;
			w=0.60000002;
			text="";
		};
		class TextSide: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.13;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_SIDE";
			sizeEx=0.027000001;
		};
		class ValueSide: RscCombo
		{
			idc=102;
			x=0.30250001;
			y=0.14;
			w=0.1375;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextFaction: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.18000001;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_FACTION";
			sizeEx=0.027000001;
		};
		class ValueFaction: RscCombo
		{
			idc=123;
			x=0.30250001;
			y=0.19;
			w=0.1375;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextRank: RscText
		{
			idc=-1;
			x=0.44;
			y=0.18000001;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_RANK";
			sizeEx=0.027000001;
		};
		class ValueRank: RscCombo
		{
			idc=104;
			x=0.57749999;
			y=0.19;
			w=0.1375;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextClass: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.23;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_CLASS";
			sizeEx=0.027000001;
		};
		class ValueClass: RscCombo
		{
			idc=107;
			x=0.30250001;
			y=0.23999999;
			w=0.1375;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextVehicle: RscText
		{
			idc=-1;
			x=0.44;
			y=0.23;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_VEHICLE";
			sizeEx=0.027000001;
		};
		class ValueVehicle: RscCombo
		{
			idc=103;
			x=0.57749999;
			y=0.23999999;
			w=0.1375;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextControl: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.28;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_CTRL";
			sizeEx=0.027000001;
		};
		class ValueControl: RscCombo
		{
			idc=105;
			x=0.30250001;
			y=0.28999999;
			w=0.1375;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextSpecial: RscText
		{
			idc=-1;
			x=0.44;
			y=0.28;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_SPECIAL";
			sizeEx=0.027000001;
		};
		class ValueSpecial: RscCombo
		{
			idc=112;
			x=0.57749999;
			y=0.28999999;
			w=0.1375;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextAge: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.33000001;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_AGE";
			sizeEx=0.027000001;
		};
		class ValueAge: RscCombo
		{
			idc=113;
			x=0.30250001;
			y=0.34;
			w=0.1375;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextText: RscText
		{
			idc=-1;
			x=0.44;
			y=0.33000001;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_TEXT";
			sizeEx=0.027000001;
		};
		class ValueText: RscEdit
		{
			idc=118;
			x=0.57749999;
			y=0.34;
			w=0.1375;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextLock: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.38;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_LOCK";
			sizeEx=0.027000001;
		};
		class ValueLock: RscCombo
		{
			idc=119;
			x=0.30250001;
			y=0.38999999;
			w=0.1375;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextSkill: RscText
		{
			idc=-1;
			x=0.44;
			y=0.38;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_SKILL";
			sizeEx=0.027000001;
		};
		class ValueSkill: RscSlider
		{
			idc=121;
			x=0.57749999;
			y=0.38999999;
			w=0.1375;
			h=0.029999999;
		};
		class TextInit: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.43000001;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_INIT";
			sizeEx=0.027000001;
		};
		class ValueInit: RscEdit
		{
			idc=120;
			x=0.30250001;
			y=0.44;
			w=0.41249999;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			autocomplete="scripting";
			sizeEx=0.027000001;
		};
		class TextDescription: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.47999999;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_DESC";
			sizeEx=0.027000001;
		};
		class ValueDescription: RscEdit
		{
			idc=122;
			x=0.30250001;
			y=0.49000001;
			w=0.41249999;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class Azimut: RscPicture
		{
			idc=114;
			text="#(argb,8,8,3)color(1,1,1,1)";
			x=0.55250001;
			y=0.52999997;
			w=0.2;
			h=0.25999999;
			colorText[]={0.079999998,0.079999998,0.12,1};
		};
		class TextAzimut: RscText
		{
			x=0.60500002;
			y=0.62;
			w=0.15000001;
			sizeEx=0.027000001;
			text="$STR_DISP_ARCUNIT_AZIMUT";
		};
		class ValueAzimut: RscEdit
		{
			idc=111;
			x=0.63;
			y=0.67000002;
			w=0.050000001;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextHealth: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.57999998;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_HEALTH";
			sizeEx=0.027000001;
		};
		class ValueHealth: RscSlider
		{
			idc=108;
			x=0.30250001;
			y=0.58999997;
			w=0.22;
			h=0.029999999;
		};
		class TextFuel: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.63;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_FUEL";
			sizeEx=0.027000001;
		};
		class ValueFuel: RscSlider
		{
			idc=109;
			x=0.30250001;
			y=0.63999999;
			w=0.22;
			h=0.029999999;
		};
		class TextAmmo: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.68000001;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_AMMO";
			sizeEx=0.027000001;
		};
		class ValueAmmo: RscSlider
		{
			idc=110;
			x=0.30250001;
			y=0.69;
			w=0.22;
			h=0.029999999;
		};
		class TextPresence: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.77999997;
			w=0.27500001;
			text="$STR_DISP_ARCUNIT_PRESENCE";
			sizeEx=0.027000001;
		};
		class ValuePresence: RscSlider
		{
			idc=116;
			x=0.44;
			y=0.79000002;
			w=0.27500001;
			h=0.029999999;
		};
		class TextPresenceCondition: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.82999998;
			w=0.27500001;
			text="$STR_DISP_ARCUNIT_PRESENCE_COND";
			sizeEx=0.027000001;
		};
		class ValuePresenceCondition: RscEdit
		{
			idc=117;
			x=0.44;
			y=0.83999997;
			w=0.27500001;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			autocomplete="scripting";
			sizeEx=0.027000001;
		};
		class TextPlacement: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.88;
			w=0.27500001;
			text="$STR_DISP_ARCUNIT_PLACE";
			sizeEx=0.027000001;
		};
		class ValuePlacement: RscEdit
		{
			idc=115;
			x=0.44;
			y=0.88999999;
			w=0.27500001;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class ButtonOK: RscButton
		{
			idc=1;
			x=0.45199999;
			y=0.89499998;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_OK";
			default=1;
			sizeEx=0.027000001;
		};
		class ButtonCancel: RscButton
		{
			idc=2;
			x=0.597;
			y=0.89499998;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_CANCEL";
			default=0;
			sizeEx=0.027000001;
		};
	};
};
class RscDisplayArcadeModules
{
	idd=153;
	movingEnable=1;
	class controls
	{
		class Background: RscText
		{
			x=0.15000001;
			y=0.02;
			w=0.60000002;
			h=0.94999999;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class Title: RscTitle
		{
			idc=101;
			style="0x20 + 0x02";
			x=0.15000001;
			y=0.039999999;
			w=0.60000002;
			text="";
		};
		class ValueSide: RscCombo
		{
			idc=102;
			x=0.30250001;
			y=0.14;
			w=0.1375;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class ValueFaction: RscCombo
		{
			idc=123;
			x=0.30250001;
			y=0.19;
			w=0.1375;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class ValueClass: RscCombo
		{
			idc=107;
			x=0.30250001;
			y=0.19;
			w=0.1375;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextVehicle: RscText
		{
			idc=-1;
			x=0.44;
			y=0.18000001;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_VEHICLE";
			sizeEx=0.027000001;
		};
		class ValueVehicle: RscCombo
		{
			idc=103;
			x=0.57749999;
			y=0.19;
			w=0.1375;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextText: RscText
		{
			idc=-1;
			x=0.44;
			y=0.23;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_TEXT";
			sizeEx=0.027000001;
		};
		class ValueText: RscEdit
		{
			idc=118;
			x=0.57749999;
			y=0.23999999;
			w=0.1375;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextInit: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.33000001;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_INIT";
			sizeEx=0.027000001;
		};
		class ValueInit: RscEdit
		{
			idc=120;
			x=0.30250001;
			y=0.34;
			w=0.41249999;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			autocomplete="scripting";
			sizeEx=0.027000001;
		};
		class TextDescription: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.38;
			w=0.1375;
			text="$STR_DISP_ARCUNIT_DESC";
			sizeEx=0.027000001;
		};
		class ValueDescription: RscEdit
		{
			idc=122;
			x=0.30250001;
			y=0.38999999;
			w=0.41249999;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextPresence: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.52999997;
			w=0.27500001;
			text="$STR_DISP_ARCUNIT_PRESENCE";
			sizeEx=0.027000001;
		};
		class ValuePresence: RscSlider
		{
			idc=116;
			x=0.44;
			y=0.54000002;
			w=0.27500001;
			h=0.029999999;
		};
		class TextPresenceCondition: RscText
		{
			idc=-1;
			x=0.16500001;
			y=0.57999998;
			w=0.27500001;
			text="$STR_DISP_ARCUNIT_PRESENCE_COND";
			sizeEx=0.027000001;
		};
		class ValuePresenceCondition: RscEdit
		{
			idc=117;
			x=0.44;
			y=0.58999997;
			w=0.27500001;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			autocomplete="scripting";
			sizeEx=0.027000001;
		};
		class ButtonOK: RscButton
		{
			idc=1;
			x=0.45199999;
			y=0.89499998;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_OK";
			default=1;
			sizeEx=0.027000001;
		};
		class ButtonCancel: RscButton
		{
			idc=2;
			x=0.597;
			y=0.89499998;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_CANCEL";
			default=0;
			sizeEx=0.027000001;
		};
	};
};
class RscDisplayArcadeGroup
{
	idd=40;
	movingEnable=1;
	class controls
	{
		class Background: RscText
		{
			x=0.2;
			y=0.30000001;
			w=0.60000002;
			h=0.41;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class Title: RscTitle
		{
			idc=-1;
			style="0x20 + 0x02";
			x=0.2;
			y=0.31999999;
			w=0.60000002;
			text="$STR_DISP_ARCGRP_TITLE";
		};
		class Azimut: RscPicture
		{
			idc=105;
			text="#(argb,8,8,3)color(1,1,1,1)";
			x=0.57249999;
			y=0.36000001;
			w=0.2;
			h=0.25999999;
			colorText[]={0.079999998,0.079999998,0.12,1};
		};
		class TextAzimut: RscText
		{
			x=0.625;
			y=0.44999999;
			w=0.15000001;
			sizeEx=0.027000001;
			text="$STR_DISP_ARCUNIT_AZIMUT";
		};
		class ValueAzimut: RscEdit
		{
			idc=104;
			x=0.64999998;
			y=0.5;
			w=0.050000001;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextSide: RscText
		{
			idc=-1;
			x=0.215;
			y=0.41;
			w=0.1375;
			text="$STR_DISP_ARCGRP_SIDE";
			sizeEx=0.027000001;
		};
		class ValueSide: RscCombo
		{
			idc=101;
			x=0.35249999;
			y=0.41999999;
			w=0.22;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextFaction: RscText
		{
			idc=-1;
			x=0.215;
			y=0.46000001;
			w=0.1375;
			text="$STR_DISP_ARCGRP_FACTION";
			sizeEx=0.027000001;
		};
		class ValueFaction: RscCombo
		{
			idc=106;
			x=0.35249999;
			y=0.47;
			w=0.22;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextType: RscText
		{
			idc=-1;
			x=0.215;
			y=0.50999999;
			w=0.1375;
			text="$STR_DISP_ARCGRP_TYPE";
			sizeEx=0.027000001;
		};
		class ValueType: RscCombo
		{
			idc=102;
			x=0.35249999;
			y=0.51999998;
			w=0.22;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextName: RscText
		{
			idc=-1;
			x=0.215;
			y=0.56;
			w=0.1375;
			text="$STR_DISP_ARCGRP_NAME";
			sizeEx=0.027000001;
		};
		class ValueName: RscCombo
		{
			idc=103;
			x=0.35249999;
			y=0.56999999;
			w=0.22;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class ButtonOK: RscButton
		{
			idc=1;
			x=0.50199997;
			y=0.63499999;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_OK";
			default=1;
			sizeEx=0.027000001;
		};
		class ButtonCancel: RscButton
		{
			idc=2;
			x=0.64700001;
			y=0.63499999;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_CANCEL";
			default=0;
			sizeEx=0.027000001;
		};
	};
};
class RscDisplayArcadeWaypoint
{
	idd=28;
	movingEnable=1;
	class controls
	{
		class Background: RscText
		{
			x=0.2;
			y=0.050000001;
			w=0.56;
			h=0.91000003;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class Title: RscTitle
		{
			idc=101;
			style="0x20 + 0x02";
			x=0.2;
			y=0.07;
			w=0.56;
			text="";
		};
		class TextType: RscText
		{
			idc=-1;
			x=0.215;
			y=0.16;
			w=0.255;
			text="$STR_DISP_ARCWP_TYPE";
			sizeEx=0.027000001;
		};
		class ValueType: RscCombo
		{
			idc=102;
			x=0.47;
			y=0.17;
			w=0.255;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextSequence: RscText
		{
			idc=-1;
			x=0.215;
			y=0.20999999;
			w=0.255;
			text="$STR_DISP_ARCWP_SEQ";
			sizeEx=0.027000001;
		};
		class ValueSequence: RscCombo
		{
			idc=103;
			x=0.47;
			y=0.22;
			w=0.255;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextDescription: RscText
		{
			idc=-1;
			x=0.215;
			y=0.25999999;
			w=0.255;
			text="$STR_DISP_ARCWP_DESC";
			sizeEx=0.027000001;
		};
		class ValueDescription: RscEdit
		{
			idc=104;
			x=0.47;
			y=0.27000001;
			w=0.255;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextCombatMode: RscText
		{
			idc=-1;
			x=0.215;
			y=0.31;
			w=0.255;
			text="$STR_DISP_ARCWP_SEMAPHORE";
			sizeEx=0.027000001;
		};
		class ValueCombatMode: RscCombo
		{
			idc=105;
			x=0.47;
			y=0.31999999;
			w=0.255;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextFormation: RscText
		{
			idc=-1;
			x=0.215;
			y=0.36000001;
			w=0.255;
			text="$STR_DISP_ARCWP_FORM";
			sizeEx=0.027000001;
		};
		class ValueFormation: RscCombo
		{
			idc=106;
			x=0.47;
			y=0.37;
			w=0.255;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextSpeed: RscText
		{
			idc=-1;
			x=0.215;
			y=0.41;
			w=0.255;
			text="$STR_DISP_ARCWP_SPEED";
			sizeEx=0.027000001;
		};
		class ValueSpeed: RscCombo
		{
			idc=107;
			x=0.47;
			y=0.41999999;
			w=0.255;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextCombat: RscText
		{
			idc=-1;
			x=0.215;
			y=0.46000001;
			w=0.255;
			text="$STR_DISP_ARCWP_COMBAT";
			sizeEx=0.027000001;
		};
		class ValueCombat: RscCombo
		{
			idc=108;
			x=0.47;
			y=0.47;
			w=0.255;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextPlacement: RscText
		{
			idc=-1;
			x=0.215;
			y=0.50999999;
			w=0.255;
			text="$STR_DISP_ARCWP_PLACE";
			sizeEx=0.027000001;
		};
		class ValuePlacement: RscEdit
		{
			idc=109;
			x=0.47;
			y=0.51999998;
			w=0.255;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextPrecision: RscText
		{
			idc=-1;
			x=0.215;
			y=0.56;
			w=0.255;
			text="$STR_DISP_ARCWP_PREC";
			sizeEx=0.027000001;
		};
		class ValuePrecision: RscEdit
		{
			idc=120;
			x=0.47;
			y=0.56999999;
			w=0.255;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextHousePos: RscText
		{
			idc=115;
			x=0.215;
			y=0.61000001;
			w=0.255;
			text="$STR_DISP_ARCWP_HOUSEPOS";
			sizeEx=0.027000001;
		};
		class ValueHousePos: RscCombo
		{
			idc=114;
			x=0.47;
			y=0.62;
			w=0.255;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextTimeout: RscText
		{
			idc=-1;
			x=0.215;
			y=0.66000003;
			w=0.1275;
			text="$STR_DISP_ARCWP_TIMEOUT";
			sizeEx=0.027000001;
		};
		class TextTimeoutMin: RscText
		{
			idc=-1;
			x=0.3425;
			y=0.66000003;
			w=0.063749999;
			text="$STR_DISP_ARCWP_TIMEOUT_MIN";
			sizeEx=0.027000001;
		};
		class ValueTimeoutMin: RscEdit
		{
			idc=111;
			x=0.40625;
			y=0.67000002;
			w=0.063749999;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextTimeoutMax: RscText
		{
			idc=-1;
			x=0.47;
			y=0.66000003;
			w=0.063749999;
			text="$STR_DISP_ARCWP_TIMEOUT_MAX";
			sizeEx=0.027000001;
		};
		class ValueTimeoutMax: RscEdit
		{
			idc=112;
			x=0.53375;
			y=0.67000002;
			w=0.063749999;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextTimeoutMid: RscText
		{
			idc=-1;
			x=0.59750003;
			y=0.66000003;
			w=0.063749999;
			text="$STR_DISP_ARCWP_TIMEOUT_MID";
			sizeEx=0.027000001;
		};
		class ValueTimeoutMid: RscEdit
		{
			idc=113;
			x=0.66125;
			y=0.67000002;
			w=0.063749999;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextExpCond: RscText
		{
			idc=-1;
			x=0.215;
			y=0.70999998;
			w=0.1275;
			text="$STR_DISP_ARCWP_EXPCOND";
			sizeEx=0.027000001;
		};
		class ValueExpCond: RscEdit
		{
			idc=118;
			x=0.3425;
			y=0.72000003;
			w=0.38249999;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextExpActiv: RscText
		{
			idc=-1;
			x=0.215;
			y=0.75999999;
			w=0.1275;
			text="$STR_DISP_ARCWP_EXPACTIV";
			sizeEx=0.027000001;
		};
		class ValueExpActiv: RscEdit
		{
			idc=116;
			x=0.3425;
			y=0.76999998;
			w=0.38249999;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			autocomplete="scripting";
			sizeEx=0.027000001;
		};
		class Show: RscToolbox
		{
			idc=117;
			x=0.215;
			y=0.81;
			w=0.50999999;
			h=0.059999999;
			strings[]=
			{
				"$STR_DISP_ARCWP_SHOW_NEVER",
				"$STR_DISP_ARCWP_SHOW_EASY",
				"$STR_DISP_ARCWP_SHOW_ALWAYS"
			};
			rows=1;
			columns=3;
		};
		class TextExpScript: RscText
		{
			idc=-1;
			x=0.215;
			y=0.86000001;
			w=0.1275;
			text="$STR_DISP_ARCWP_SCRIPT";
			sizeEx=0.027000001;
		};
		class ValueExpScript: RscEdit
		{
			idc=119;
			x=0.3425;
			y=0.87;
			w=0.38249999;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class ButtonEffects: RscButton
		{
			idc=110;
			x=0.22;
			y=0.88499999;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_ARCWP_EFFECTS";
			default=0;
			sizeEx=0.027000001;
		};
		class ButtonOK: RscButton
		{
			idc=1;
			x=0.46200001;
			y=0.88499999;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_OK";
			default=1;
			sizeEx=0.027000001;
		};
		class ButtonCancel: RscButton
		{
			idc=2;
			x=0.60699999;
			y=0.88499999;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_CANCEL";
			default=0;
			sizeEx=0.027000001;
		};
	};
};
class RscDisplayArcadeMarker
{
	idd=45;
	movingEnable=1;
	class controls
	{
		class Background: RscText
		{
			x=0.2;
			y=0.2;
			w=0.60000002;
			h=0.5;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class Title: RscTitle
		{
			idc=101;
			style="0x20 + 0x02";
			x=0.2;
			y=0.22;
			w=0.60000002;
			text="";
		};
		class TextName: RscText
		{
			idc=-1;
			x=0.215;
			y=0.31;
			w=0.27500001;
			text="$STR_DISP_ARCMARK_NAME";
			sizeEx=0.027000001;
		};
		class ValueName: RscEdit
		{
			idc=102;
			x=0.49000001;
			y=0.31999999;
			w=0.27500001;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class Marker: RscToolbox
		{
			idc=103;
			x=0.215;
			y=0.36000001;
			w=0.55000001;
			h=0.039999999;
			strings[]=
			{
				"$STR_DISP_ARCMARK_ICON",
				"$STR_DISP_ARCMARK_RECT",
				"$STR_DISP_ARCMARK_ELLIPSE"
			};
			rows=1;
			columns=3;
		};
		class TextColorName: RscText
		{
			idc=-1;
			x=0.215;
			y=0.41;
			w=0.27500001;
			text="$STR_DISP_ARCMARK_COLOR";
			sizeEx=0.027000001;
		};
		class ValueColorName: RscCombo
		{
			idc=105;
			x=0.49000001;
			y=0.41999999;
			w=0.27500001;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextType: RscText
		{
			idc=109;
			x=0.215;
			y=0.46000001;
			w=0.27500001;
			text="";
			sizeEx=0.027000001;
		};
		class ValueIcon: RscCombo
		{
			idc=104;
			x=0.49000001;
			y=0.47;
			w=0.27500001;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class ValueFill: RscCombo
		{
			idc=110;
			x=0.49000001;
			y=0.47;
			w=0.27500001;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextA: RscText
		{
			idc=-1;
			x=0.215;
			y=0.50999999;
			w=0.091849998;
			text="$STR_DISP_ARCMARK_A";
			sizeEx=0.027000001;
		};
		class ValueA: RscEdit
		{
			idc=106;
			x=0.30684999;
			y=0.51999998;
			w=0.091849998;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextB: RscText
		{
			idc=-1;
			x=0.3987;
			y=0.50999999;
			w=0.091849998;
			text="$STR_DISP_ARCMARK_B";
			sizeEx=0.027000001;
		};
		class ValueB: RscEdit
		{
			idc=107;
			x=0.49055001;
			y=0.51999998;
			w=0.091849998;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextAngle: RscText
		{
			idc=-1;
			x=0.58240002;
			y=0.50999999;
			w=0.091849998;
			text="$STR_DISP_ARCMARK_ANGLE";
			sizeEx=0.027000001;
		};
		class ValueAngle: RscEdit
		{
			idc=108;
			x=0.67425001;
			y=0.51999998;
			w=0.091849998;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextText: RscText
		{
			idc=-1;
			x=0.215;
			y=0.56;
			w=0.27500001;
			text="$STR_DISP_ARCMARK_TEXT";
			sizeEx=0.027000001;
		};
		class ValueText: RscEdit
		{
			idc=111;
			x=0.49000001;
			y=0.56999999;
			w=0.27500001;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class ButtonOK: RscButton
		{
			idc=1;
			x=0.50199997;
			y=0.625;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_OK";
			default=1;
			sizeEx=0.027000001;
		};
		class ButtonCancel: RscButton
		{
			idc=2;
			x=0.64700001;
			y=0.625;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_CANCEL";
			default=0;
			sizeEx=0.027000001;
		};
	};
};
class RscDisplayArcadeSensor
{
	idd=41;
	movingEnable=1;
	class controls
	{
		class Background: RscText
		{
			x=0.2;
			y=0.050000001;
			w=0.56;
			h=0.91000003;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class Title: RscTitle
		{
			idc=101;
			style="0x20 + 0x02";
			x=0.2;
			y=0.07;
			w=0.56;
			text="$STR_DISP_ARCSENS_TITLE";
		};
		class TextA: RscText
		{
			idc=-1;
			x=0.215;
			y=0.16;
			w=0.1275;
			text="$STR_DISP_ARCSENS_A";
			sizeEx=0.027000001;
		};
		class ValueA: RscEdit
		{
			idc=102;
			x=0.3425;
			y=0.17;
			w=0.1275;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextB: RscText
		{
			idc=-1;
			x=0.47;
			y=0.16;
			w=0.1275;
			text="$STR_DISP_ARCSENS_B";
			sizeEx=0.027000001;
		};
		class ValueB: RscEdit
		{
			idc=103;
			x=0.59750003;
			y=0.17;
			w=0.1275;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextAngle: RscText
		{
			idc=-1;
			x=0.215;
			y=0.20999999;
			w=0.1275;
			text="$STR_DISP_ARCSENS_ANGLE";
			sizeEx=0.027000001;
		};
		class ValueAngle: RscEdit
		{
			idc=104;
			x=0.3425;
			y=0.22;
			w=0.1275;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class Rectangular: RscToolbox
		{
			idc=120;
			x=0.215;
			y=0.25999999;
			w=0.255;
			h=0.029999999;
			strings[]=
			{
				"$STR_DISP_ARCSENS_ELLIPSE",
				"$STR_DISP_ARCSENS_RECT"
			};
			rows=1;
			columns=2;
		};
		class Repeating: RscToolbox
		{
			idc=107;
			x=0.47;
			y=0.25999999;
			w=0.255;
			h=0.029999999;
			strings[]=
			{
				"$STR_DISP_ARCSENS_ONCE",
				"$STR_DISP_ARCSENS_REPEAT"
			};
			rows=1;
			columns=2;
		};
		class TextType: RscText
		{
			idc=-1;
			x=0.215;
			y=0.31;
			w=0.1275;
			text="$STR_DISP_ARCSENS_TYPE";
			sizeEx=0.027000001;
		};
		class ValueType: RscCombo
		{
			idc=112;
			x=0.3425;
			y=0.31999999;
			w=0.1275;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextActivation: RscText
		{
			idc=-1;
			x=0.47;
			y=0.31;
			w=0.1275;
			text="$STR_DISP_ARCSENS_ACTIV";
			sizeEx=0.027000001;
		};
		class ValueActivation: RscCombo
		{
			idc=105;
			x=0.59750003;
			y=0.31999999;
			w=0.1275;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class Presence: RscToolbox
		{
			idc=106;
			x=0.215;
			y=0.36000001;
			w=0.50999999;
			h=0.059999999;
			strings[]=
			{
				"$STR_DISP_ARCSENS_PRESYES",
				"$STR_DISP_ARCSENS_PRESNO",
				"$STR_DISP_ARCSENS_DETWEST",
				"$STR_DISP_ARCSENS_DETEAST",
				"$STR_DISP_ARCSENS_DETGUERRILA",
				"$STR_DISP_ARCSENS_DETCIVILIAN"
			};
			rows=2;
			columns=3;
		};
		class Interruptable: RscToolbox
		{
			idc=108;
			x=0.215;
			y=0.46000001;
			w=0.255;
			h=0.029999999;
			strings[]=
			{
				"$STR_DISP_ARCSENS_COUNTDOWN",
				"$STR_DISP_ARCSENS_TIMEOUT"
			};
			rows=1;
			columns=2;
		};
		class TextTimeoutMin: RscText
		{
			idc=-1;
			x=0.215;
			y=0.50999999;
			w=0.085170001;
			text="$STR_DISP_ARCSENS_TIMEOUT_MIN";
			sizeEx=0.027000001;
		};
		class ValueTimeoutMin: RscEdit
		{
			idc=109;
			x=0.30017;
			y=0.51999998;
			w=0.085170001;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextTimeoutMax: RscText
		{
			idc=-1;
			x=0.38534001;
			y=0.50999999;
			w=0.085170001;
			text="$STR_DISP_ARCSENS_TIMEOUT_MAX";
			sizeEx=0.027000001;
		};
		class ValueTimeoutMax: RscEdit
		{
			idc=110;
			x=0.47051001;
			y=0.51999998;
			w=0.085170001;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextTimeoutMid: RscText
		{
			idc=-1;
			x=0.55567998;
			y=0.50999999;
			w=0.085170001;
			text="$STR_DISP_ARCSENS_TIMEOUT_MID";
			sizeEx=0.027000001;
		};
		class ValueTimeoutMid: RscEdit
		{
			idc=111;
			x=0.64085001;
			y=0.51999998;
			w=0.085170001;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextName: RscText
		{
			idc=-1;
			x=0.215;
			y=0.56;
			w=0.1275;
			text="$STR_DISP_ARCSENS_NAME";
			sizeEx=0.027000001;
		};
		class ValueName: RscEdit
		{
			idc=121;
			x=0.3425;
			y=0.56999999;
			w=0.1275;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextText: RscText
		{
			idc=-1;
			x=0.47;
			y=0.56;
			w=0.1275;
			text="$STR_DISP_ARCSENS_TEXT";
			sizeEx=0.027000001;
		};
		class ValueText: RscEdit
		{
			idc=114;
			x=0.59750003;
			y=0.56999999;
			w=0.1275;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextExpCond: RscText
		{
			idc=-1;
			x=0.215;
			y=0.61000001;
			w=0.1275;
			text="$STR_DISP_ARCSENS_EXPCOND";
			sizeEx=0.027000001;
		};
		class ValueExpCond: RscEdit
		{
			idc=117;
			x=0.3425;
			y=0.62;
			w=0.38249999;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			autocomplete="scripting";
			sizeEx=0.027000001;
		};
		class TextExpActiv: RscText
		{
			idc=-1;
			x=0.215;
			y=0.66000003;
			w=0.1275;
			text="$STR_DISP_ARCSENS_EXPACTIV";
			sizeEx=0.027000001;
		};
		class ValueExpActiv: RscEdit
		{
			idc=118;
			x=0.3425;
			y=0.67000002;
			w=0.38249999;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			autocomplete="scripting";
			sizeEx=0.027000001;
		};
		class TextExpDesactiv: RscText
		{
			idc=-1;
			x=0.215;
			y=0.70999998;
			w=0.1275;
			text="$STR_DISP_ARCSENS_EXPDESACTIV";
			sizeEx=0.027000001;
		};
		class ValueExpDesactiv: RscEdit
		{
			idc=119;
			x=0.3425;
			y=0.72000003;
			w=0.38249999;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			autocomplete="scripting";
			sizeEx=0.027000001;
		};
		class ButtonEffects: RscButton
		{
			idc=116;
			x=0.22;
			y=0.88499999;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_ARCSENS_EFFECTS";
			default=0;
			sizeEx=0.027000001;
		};
		class ButtonOK: RscButton
		{
			idc=1;
			x=0.46200001;
			y=0.88499999;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_OK";
			default=1;
			sizeEx=0.027000001;
		};
		class ButtonCancel: RscButton
		{
			idc=2;
			x=0.60699999;
			y=0.88499999;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_CANCEL";
			default=0;
			sizeEx=0.027000001;
		};
	};
};
class RscDisplayArcadeEffects
{
	idd=44;
	movingEnable=1;
	class controls
	{
		class Background: RscText
		{
			x=0.2;
			y=0.050000001;
			w=0.60000002;
			h=0.85000002;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class Title: RscTitle
		{
			idc=-1;
			style="0x20 + 0x02";
			x=0.2;
			y=0.07;
			w=0.60000002;
			text="$STR_DISP_ARCEFF_TITLE";
		};
		class Condition: RscEdit
		{
			idc=113;
			x=0.215;
			y=0.17;
			w=0.55000001;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			autocomplete="scripting";
			sizeEx=0.027000001;
		};
		class TextSound: RscText
		{
			idc=-1;
			x=0.215;
			y=0.20999999;
			w=0.27500001;
			text="$STR_DISP_ARCEFF_SOUND_ANON";
			sizeEx=0.027000001;
		};
		class ValueSound: RscCombo
		{
			idc=103;
			x=0.49000001;
			y=0.22;
			w=0.27500001;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextVoice: RscText
		{
			idc=-1;
			x=0.215;
			y=0.25999999;
			w=0.27500001;
			text="$STR_DISP_ARCEFF_VOICE";
			sizeEx=0.027000001;
		};
		class ValueVoice: RscCombo
		{
			idc=104;
			x=0.49000001;
			y=0.27000001;
			w=0.27500001;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextSoundEnv: RscText
		{
			idc=-1;
			x=0.215;
			y=0.31;
			w=0.27500001;
			text="$STR_DISP_ARCEFF_SOUND_ENV";
			sizeEx=0.027000001;
		};
		class ValueSoundEnv: RscCombo
		{
			idc=105;
			x=0.49000001;
			y=0.31999999;
			w=0.27500001;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextSoundDet: RscText
		{
			idc=-1;
			x=0.215;
			y=0.36000001;
			w=0.27500001;
			text="$STR_DISP_ARCEFF_SOUND_DET";
			sizeEx=0.027000001;
		};
		class ValueSoundDet: RscCombo
		{
			idc=106;
			x=0.49000001;
			y=0.37;
			w=0.27500001;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextMusic: RscText
		{
			idc=-1;
			x=0.215;
			y=0.41;
			w=0.27500001;
			text="$STR_DISP_ARCEFF_TRACK";
			sizeEx=0.027000001;
		};
		class ValueMusic: RscCombo
		{
			idc=107;
			x=0.49000001;
			y=0.41999999;
			w=0.27500001;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextTitleType: RscText
		{
			idc=-1;
			x=0.215;
			y=0.46000001;
			w=0.27500001;
			text="$STR_DISP_ARCEFF_TITTYPE";
			sizeEx=0.027000001;
		};
		class ValueTitleType: RscCombo
		{
			idc=108;
			x=0.49000001;
			y=0.47;
			w=0.27500001;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextTitleEffect: RscText
		{
			idc=-1;
			x=0.215;
			y=0.50999999;
			w=0.27500001;
			text="$STR_DISP_ARCEFF_TITEFF";
			sizeEx=0.027000001;
		};
		class ValueTitleEffect: RscCombo
		{
			idc=109;
			x=0.49000001;
			y=0.51999998;
			w=0.27500001;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextTitle: RscText
		{
			idc=114;
			x=0.215;
			y=0.56;
			w=0.1375;
			text="$STR_DISP_ARCEFF_TITTEXT";
			sizeEx=0.027000001;
		};
		class ValueTitleText: RscEdit
		{
			idc=110;
			x=0.35249999;
			y=0.56999999;
			w=0.41249999;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class ValueTitleRes: RscCombo
		{
			idc=111;
			x=0.49000001;
			y=0.56999999;
			w=0.27500001;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class ValueTitleObj: RscCombo
		{
			idc=112;
			x=0.49000001;
			y=0.56999999;
			w=0.27500001;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class ButtonOK: RscButton
		{
			idc=1;
			x=0.50199997;
			y=0.82499999;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_OK";
			default=1;
			sizeEx=0.027000001;
		};
		class ButtonCancel: RscButton
		{
			idc=2;
			x=0.64700001;
			y=0.82499999;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_CANCEL";
			default=0;
			sizeEx=0.027000001;
		};
	};
};
class RscDisplayTemplateSave
{
	idd=29;
	movingEnable=1;
	class controls
	{
		class Background: RscText
		{
			x=0.28;
			y=0.2;
			w=0.46000001;
			h=0.33000001;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class Title: RscTitle
		{
			idc=-1;
			style="0x20 + 0x02";
			x=0.28;
			y=0.22;
			w=0.46000001;
			text="$STR_DISP_TEMPL_SAVE";
		};
		class TextName: RscText
		{
			idc=-1;
			x=0.29499999;
			y=0.31;
			w=0.205;
			text="$STR_DISP_TEMPL_NAME";
			sizeEx=0.027000001;
		};
		class ValueName: RscEdit
		{
			idc=101;
			x=0.5;
			y=0.31999999;
			w=0.205;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextMode: RscText
		{
			idc=-1;
			x=0.29499999;
			y=0.36000001;
			w=0.205;
			text="$STR_DISP_TEMPL_MODE";
			sizeEx=0.027000001;
		};
		class ValueMode: RscCombo
		{
			idc=103;
			x=0.5;
			y=0.37;
			w=0.205;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class ButtonOK: RscButton
		{
			idc=1;
			x=0.442;
			y=0.45500001;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_OK";
			default=1;
			sizeEx=0.027000001;
		};
		class ButtonCancel: RscButton
		{
			idc=2;
			x=0.58700001;
			y=0.45500001;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_CANCEL";
			default=0;
			sizeEx=0.027000001;
		};
	};
};
class RscDisplayPublishMission
{
	idd=165;
	movingEnable=1;
	class Title: RscTitle
	{
		idc=-1;
		style="0x20 + 0x02";
		x=0.28;
		y=0.22;
		w=0.46000001;
		text="STR_MISSION_PUBLISH_TEXT";
	};
	class controls
	{
		class Background: RscText
		{
			x=0.28;
			y=0.2;
			w=0.46000001;
			h=0.33000001;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class TextName: RscText
		{
			idc=-1;
			x=0.29499999;
			y=0.31;
			w=0.205;
			text="$STR_MISSION_TITLE_TEXT";
			sizeEx=0.027000001;
		};
		class ValueName: RscEdit
		{
			idc="IDC_STEAM_TITLE";
			x=0.5;
			y=0.31999999;
			w=0.205;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class ButtonOK: RscButton
		{
			idc="IDC_BUTTON_PUBLISH";
			x="scalar NaN";
			y=0.45500001;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_OK";
			default=1;
			sizeEx=0.027000001;
		};
		class ButtonCancel: RscButton
		{
			idc=2;
			x=0.58700001;
			y=0.45500001;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_CANCEL";
			default=0;
			sizeEx=0.027000001;
		};
	};
};
class RscDisplayPublishMissionSelectTags
{
	idd=166;
	class controls
	{
		class Title: RscTitle
		{
			style=0;
			text="$STR_DISP_TAGS_TITLE";
			x=0.2;
			y=0.2;
			w=0.60000002;
			h=0.039999999;
		};
		class TextUnused: RscText
		{
			style=2;
			text="$STR_DISP_TAGS_UNUSED";
			x=0.2;
			y=0.25;
			w=0.25999999;
			h=0.039999999;
			colorBackground[]={0,0,0,1};
		};
		class TextUsed: RscText
		{
			style=2;
			text="$STR_DISP_TAGS_USED";
			x=0.52700001;
			y=0.252;
			w=0.266;
			h=0.039999999;
			colorBackground[]={0,0,0,1};
		};
		class ButtonAdd: RscActiveText
		{
			idc="IDC_STEAM_TAGS_ADD";
			text=">>";
			x=0.47;
			y=0.41999999;
			w=0.045000002;
			h=0.059999999;
		};
		class ButtonRemove: RscActiveText
		{
			idc="IDC_STEAM_TAGS_REMOVE";
			text="<<";
			x=0.47;
			y=0.51999998;
			w=0.045000002;
			h=0.059999999;
		};
		class ListUnusedTags: RscListBox
		{
			idc="IDC_STEAM_TAGS_AVAILABLE";
			x=0.2;
			y=0.30000001;
			w=0.25999999;
			h=0.44;
		};
		class ListUsedTags: RscListBox
		{
			idc="IDC_STEAM_TAGS_SELECTED";
			x=0.51999998;
			y=0.30000001;
			w=0.25999999;
			h=0.44;
		};
		class ButtonOK: RscShortcutButton
		{
			idc=1;
			text="$STR_DISP_OK";
			x=0.61199999;
			y=0.75999999;
			w=0.18000001;
			h=0.039999999;
		};
		class ButtonCancel: ButtonOK
		{
			idc=2;
			text="$STR_DISP_CANCEL";
			x=0.19;
			y=0.75999999;
			w=0.18000001;
			h=0.039999999;
		};
	};
};
class RscDisplayTemplateLoad
{
	idd=30;
	movingEnable=1;
	class controls
	{
		class Background: RscText
		{
			x=0.28;
			y=0.2;
			w=0.46000001;
			h=0.31;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class Title: RscTitle
		{
			idc=102;
			style="0x20 + 0x02";
			x=0.28;
			y=0.22;
			w=0.46000001;
			text="$STR_DISP_TEMPL_LOAD";
		};
		class TextIsland: RscText
		{
			idc=-1;
			x=0.29499999;
			y=0.31;
			w=0.205;
			text="$STR_DISP_TEMPL_ISLAND";
			sizeEx=0.027000001;
		};
		class ValueIsland: RscCombo
		{
			idc=104;
			x=0.5;
			y=0.31999999;
			w=0.205;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class TextName: RscText
		{
			idc=-1;
			x=0.29499999;
			y=0.36000001;
			w=0.205;
			text="$STR_DISP_TEMPL_NAME";
			sizeEx=0.027000001;
		};
		class ValueName: RscCombo
		{
			idc=101;
			x=0.5;
			y=0.37;
			w=0.205;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class ButtonOK: RscButton
		{
			idc=1;
			x=0.442;
			y=0.435;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_OK";
			default=1;
			sizeEx=0.027000001;
		};
		class ButtonCancel: RscButton
		{
			idc=2;
			x=0.58700001;
			y=0.435;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_CANCEL";
			default=0;
			sizeEx=0.027000001;
		};
	};
};
class RscDisplayIntel
{
	idd=32;
	movingEnable=1;
	class controls
	{
		class Background: RscText
		{
			x=0.2;
			y=0.02;
			w=0.63999999;
			h=0.95999998;
			colorBackground[]={0.30000001,0.30000001,0.30000001,1};
		};
		class Title: RscTitle
		{
			idc=-1;
			style="0x20 + 0x02";
			x=0.2;
			y=0.039999999;
			w=0.63999999;
			text="$STR_DISP_INTEL_TITLE";
		};
		class TextBriefingName: RscText
		{
			idc=-1;
			x=0.215;
			y=0.13;
			w=0.14749999;
			text="$STR_DISP_INTEL_NAME";
			sizeEx=0.027000001;
		};
		class ValueBriefingName: RscEdit
		{
			idc=106;
			x=0.36250001;
			y=0.14;
			w=0.4425;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextBriefingDescription: RscText
		{
			idc=-1;
			x=0.215;
			y=0.18000001;
			w=0.14749999;
			text="$STR_DISP_INTEL_DESC";
			sizeEx=0.027000001;
		};
		class ValueBriefingDescription: RscEdit
		{
			idc=107;
			x=0.36250001;
			y=0.19;
			w=0.4425;
			h=0.029999999;
			text="$STR_DISP_ERROR";
			sizeEx=0.027000001;
		};
		class TextDate: RscText
		{
			idc=-1;
			x=0.215;
			y=0.28;
			w=0.073749997;
			text="$STR_DISP_INTEL_DATE";
			sizeEx=0.027000001;
		};
		class ValueMonth: RscCombo
		{
			idc=102;
			x=0.28874999;
			y=0.28999999;
			w=0.073749997;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class ValueDay: RscCombo
		{
			idc=103;
			x=0.36250001;
			y=0.28999999;
			w=0.073749997;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class ValueYear: ValueDay
		{
			idc=112;
			from=1980;
			to=2020;
			x=0.43625;
		};
		class TextTime: RscText
		{
			idc=-1;
			x=0.58375001;
			y=0.28;
			w=0.073749997;
			text="$STR_DISP_INTEL_TIME";
			sizeEx=0.027000001;
		};
		class ValueHour: RscCombo
		{
			idc=104;
			x=0.65750003;
			y=0.28999999;
			w=0.073749997;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class ValueMinute: RscCombo
		{
			idc=105;
			x=0.73124999;
			y=0.28999999;
			w=0.073749997;
			h=0.029999999;
			sizeEx=0.027000001;
		};
		class ValueWeather: RscSlider
		{
			idc=108;
			x=0.215;
			y=0.34;
			w=0.58999997;
			h=0.029999999;
		};
		class ValueFog: RscSlider
		{
			idc=109;
			x=0.215;
			y=0.38999999;
			w=0.4425;
			h=0.029999999;
		};
		class ValueWind: RscSlider
		{
			idc="IDC_INTEL_WIND";
			x=0.215;
			y=0.44;
			w=0.4425;
			h=0.029999999;
		};
		class ValueWeatherForecast: RscSlider
		{
			idc=110;
			x=0.215;
			y=0.49000001;
			w=0.58999997;
			h=0.029999999;
		};
		class ValueFogForecast: RscSlider
		{
			idc=111;
			x=0.215;
			y=0.54000002;
			w=0.58999997;
			h=0.029999999;
		};
		class ValueWindForecast: RscSlider
		{
			idc="IDC_INTEL_WIND_FORECAST";
			x=0.215;
			y=0.58999997;
			w=0.58999997;
			h=0.029999999;
		};
		class ValueResistance: RscToolbox
		{
			idc=101;
			x=0.215;
			y=0.63;
			w=0.58999997;
			h=0.039999999;
			strings[]=
			{
				"$STR_DISP_INTEL_NONE_FRIENDLY",
				"$STR_DISP_INTEL_WEST_FRIENDLY",
				"$STR_DISP_INTEL_EAST_FRIENDLY",
				"$STR_DISP_INTEL_BOTH_FRIENDLY"
			};
			rows=1;
			columns=4;
		};
		class ButtonOK: RscButton
		{
			idc=1;
			x=0.542;
			y=0.90499997;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_OK";
			default=1;
			sizeEx=0.027000001;
		};
		class ButtonCancel: RscButton
		{
			idc=2;
			x=0.68699998;
			y=0.90499997;
			w=0.13;
			h=0.050000001;
			text="$STR_DISP_CANCEL";
			default=0;
			sizeEx=0.027000001;
		};
	};
};
class RscDisplayESRBOnline: RscStandardDisplay
{
	idd=136;
	class Controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_ESRB_TITLE";
		};
		class Text: RscStructuredText
		{
			x=0.025;
			y=0.12;
			w=0.30000001;
			h=0.30000001;
			text="$STR_DISP_ESRB_ONLINE";
		};
		class B_Cancel: RscButton
		{
			idc=2;
			text="$STR_DISP_CANCEL";
			x=0.55000001;
			y=0.89999998;
			w=0.25;
		};
		class B_OK: B_Cancel
		{
			idc=1;
			text="$STR_DISP_OK";
			x=0.75;
			default=1;
		};
	};
};
class RscDisplayMultiplayer: RscStandardDisplay
{
	idd=8;
	sortUp="#(argb,8,8,3)color(1,1,1,1)";
	sortDown="#(argb,8,8,3)color(1,0.5,0,1)";
	showPassworded="#(argb,8,8,3)color(0,1,0,1)";
	hidePassworded="#(argb,8,8,3)color(0,0,1,1)";
	showFull="#(argb,8,8,3)color(0.3,0.3,0.3,1)";
	hideFull="#(argb,8,8,3)color(1,0,0,1)";
	showBattlEye="#(argb,8,8,3)color(1,0,0,1)";
	showNoBattlEye="#(argb,8,8,3)color(1,0.5,0,1)";
	hideBattlEye="#(argb,8,8,3)color(0.3,0.3,0.3,1)";
	showExpansions="#(argb,8,8,3)color(0.3,0.3,0.3,1)";
	hideExpansions="#(argb,8,8,3)color(1,0,0,1)";
	colorPingUnknown[]={1,1,1,1};
	colorPingGood[]={0,1,0,1};
	colorPingPoor[]={1,1,0,1};
	colorPingBad[]={1,0,0,1};
	colorVersionGood[]={1,1,1,1};
	colorVersionBad[]={1,0,0,1};
	class controls
	{
		class IconServer: RscPicture
		{
			idc=111;
			x=0;
			y=0.061000001;
			w=0.02;
			h=0.02;
			text="#(argb,8,8,3)color(1,1,1,1)";
		};
		class ColumnServer: RscActiveText
		{
			idc=112;
			text="$STR_MP_SERVER";
			style=0;
			sizeEx=0.027000001;
			x=0;
			y=0.07;
			w=0.167;
		};
		class FilterServer: RscText
		{
			idc=125;
			style=2;
			x=0.18000001;
			y=0.125;
			w=0.2;
		};
		class ColumnType: ColumnServer
		{
			idc=141;
			text="$STR_DISP_ARCSENS_TYPE";
			x=0.167;
		};
		class IconType: IconServer
		{
			idc=140;
			x=0.91000003;
		};
		class ColumnMission: ColumnServer
		{
			idc=114;
			text="$STR_SECTION_MISSION";
			x=0.333;
			w=0.167;
		};
		class IconMission: IconServer
		{
			idc=113;
			x=0.333;
		};
		class FilterMission: FilterServer
		{
			idc=126;
			x=0.167;
			w=0.30000001;
		};
		class IconState: IconServer
		{
			idc=115;
			x=0.5;
		};
		class ColumnState: ColumnServer
		{
			idc=116;
			text="$STR_MENU_STATUS";
			x=0.5;
			w=0.167;
		};
		class IconPlayers: IconServer
		{
			idc=117;
			x=0.667;
		};
		class ColumnPlayers: ColumnServer
		{
			idc=118;
			text="$STR_MPTABLE_PLAYERS";
			x=0.667;
			w=0.12;
		};
		class FilterPlayers: FilterServer
		{
			idc=127;
			x=0.66500002;
			w=0.12;
		};
		class IconPing: IconServer
		{
			idc=119;
			x=0.81;
		};
		class ColumnPing: ColumnServer
		{
			idc=120;
			text="$STR_DISP_MULTI_PING";
			x=0.82999998;
			w=0.079999998;
		};
		class FilterPing: FilterServer
		{
			idc=128;
			x=0.82999998;
			w=0.079999998;
		};
		class FilterType: FilterServer
		{
			idc=152;
			x=0.93000001;
			w=0.079999998;
		};
		class ValueSessions: RscListBox
		{
			idc=102;
			x=0;
			y=0.12800001;
			w=1;
			h=0.373;
			sizeEx=0.027000001;
			rows=9;
			password="#(argb,8,8,3)color(1,1,1,1)";
			version="#(argb,8,8,3)color(1,1,1,1)";
			addons="#(argb,8,8,3)color(1,0,0,1)";
			mods="#(argb,8,8,3)color(1,0.5,0,1)";
			locked="#(argb,8,8,3)color(0.75,0,0.75,1)";
			allowedFilePatching="#(argb,8,8,3)color(1,0,0,1)";
			none="#(argb,8,8,3)color(1,1,1,1)";
			star="#(argb,8,8,3)color(1,1,1,1)";
			serverLike="#(argb,8,8,3)color(1,1,0,1)";
			serverDislike="#(argb,8,8,3)color(1,0,0,1)";
			serverEmpty="#(argb,8,8,3)color(0.3,0.3,0.3,1)";
			colorPingUnknown[]={1,1,1,1};
			colorPingGood[]={0,1,0,1};
			colorPingPoor[]={1,1,0,1};
			colorPingBad[]={1,0,0,1};
			class Columns
			{
				class ColumnFavorite
				{
					x="1.2 * (((safezoneW / safezoneH) min 1.2) / 40) + SafezoneX";
					w="(2 * (((safezoneW / safezoneH) min 1.2) / 40))";
				};
				class ColumnServer
				{
					x="2.7 * (((safezoneW / safezoneH) min 1.2) / 40) + SafezoneX";
					w="(11 * (((safezoneW / safezoneH) min 1.2) / 40)) + 0.45*(safezoneW - ((safezoneW / safezoneH) min 1.2))";
				};
				class ColumnType
				{
					x="safezoneX + (15 * (((safezoneW / safezoneH) min 1.2) / 40)) + 0.45*(safezoneW - ((safezoneW / safezoneH) min 1.2))";
					w="3 * (((safezoneW / safezoneH) min 1.2) / 40)";
				};
				class ColumnMission
				{
					x="safezoneX + (18.3 * (((safezoneW / safezoneH) min 1.2) / 40)) + 0.45*(safezoneW - ((safezoneW / safezoneH) min 1.2))";
					w="(10.5 * (((safezoneW / safezoneH) min 1.2) / 40)) + 0.45*(safezoneW - ((safezoneW / safezoneH) min 1.2))";
				};
				class ColumnState
				{
					x="safezoneX + (29.1 * (((safezoneW / safezoneH) min 1.2) / 40)) + 0.9*(safezoneW - ((safezoneW / safezoneH) min 1.2))";
					w="3 * (((safezoneW / safezoneH) min 1.2) / 40)";
				};
				class ColumnPlayers
				{
					x="safezoneX + (32.4 * (((safezoneW / safezoneH) min 1.2) / 40)) + 0.9*(safezoneW - ((safezoneW / safezoneH) min 1.2))";
					w="3 * (((safezoneW / safezoneH) min 1.2) / 40)";
				};
				class ColumnPing
				{
					x="safezoneX + (35.7 * (((safezoneW / safezoneH) min 1.2) / 40)) + 0.9*(safezoneW - ((safezoneW / safezoneH) min 1.2))";
					w="3 * (((safezoneW / safezoneH) min 1.2) / 40)";
				};
			};
		};
		class B_Internet: RscActiveText
		{
			idc=122;
			x=0;
			y=0.5;
			w=0.30000001;
			style=0;
			sizeEx=0.027000001;
		};
		class B_Remote: RscActiveText
		{
			idc="IDC_MULTI_REMOTE";
			x=0.167;
			y=0.5;
			w=0.30000001;
			style=0;
			sizeEx=0.027000001;
			text="$STR_MULTI_REMOTE";
		};
		class B_Password: RscActiveText
		{
			idc=107;
			x=0.333;
			y=0.5;
			w=0.40000001;
			style=0;
			sizeEx=0.027000001;
		};
		class B_Refresh: RscActiveText
		{
			idc=123;
			text="$STR_DISP_MULTI_REFRESH";
			x=0.5;
			y=0.5;
			w=0.30000001;
			style=0;
			sizeEx=0.027000001;
		};
		class B_Filter: RscActiveText
		{
			idc=124;
			text="$STR_DISP_MULTI_FILTER";
			x=0.667;
			y=0.5;
			w=0.30000001;
			style=0;
			sizeEx=0.027000001;
		};
		class B_Port: RscActiveText
		{
			idc=108;
			text="$STR_DISP_PORT_TITLE";
			x=0.833;
			y=0.5;
			w=0.30000001;
			style=0;
			sizeEx=0.027000001;
		};
		class Progress: RscProgress
		{
			idc=121;
			x=0;
			y=0.11;
			w=1;
			h=0.02;
		};
		class ServerDetailHost: RscText
		{
			idc=129;
			x=0;
			y=0.55299997;
			w=0.23999999;
			sizeEx=0.027000001;
		};
		class ServerDetailType: ServerDetailHost
		{
			idc=130;
			x=0.25;
		};
		class ServerDetailMission: ServerDetailHost
		{
			idc=131;
			x=0.5;
		};
		class ServerDetailState: ServerDetailHost
		{
			idc=133;
			x=0.75;
		};
		class ServerDetailSlots: ServerDetailHost
		{
			idc=135;
			x=0;
			y=0.60299999;
		};
		class ServerDetailPing: ServerDetailHost
		{
			idc=142;
			x=0.25;
			y=0.60299999;
		};
		class ServerDetailLanguage: ServerDetailHost
		{
			idc=139;
			x=0.5;
			y=0.60299999;
		};
		class ServerDetailCountry: ServerDetailHost
		{
			idc=145;
			x=0.75;
			y=0.60299999;
		};
		class ServerDetailVersion: ServerDetailHost
		{
			idc=146;
			x=0;
			y=0.653;
		};
		class ServerDetailVersionRequired: ServerDetailHost
		{
			idc=147;
			x=0.25;
			y=0.653;
		};
		class ServerDetailMods: ServerDetailHost
		{
			idc=148;
			x=0.5;
			y=0.653;
		};
		class ServerDetailIsland: ServerDetailHost
		{
			idc=132;
			x=0.75;
			y=0.653;
		};
		class ServerDetailDifficulty: ServerDetailHost
		{
			idc=138;
			x=0;
			y=0.70300001;
		};
		class ServerDetailTimeLeft: ServerDetailHost
		{
			idc=134;
			x=0.25;
			y=0.70300001;
		};
		class ServerDetailPlatform: ServerDetailHost
		{
			idc=144;
			x=0.5;
			y=0.70300001;
		};
		class ServerDetailPlayers: ServerDetailHost
		{
			idc=149;
			x=0.75;
			y=0.70300001;
		};
		class ServerDetailPassword: RscPicture
		{
			idc=143;
			x=0.1;
			y=0.80000001;
			w=0.050000001;
			h=0.050000001;
		};
		class FilterFullServers: RscPicture
		{
			idc=151;
			x=0.1;
			y=0.80000001;
			w=0.050000001;
			h=0.050000001;
			text="#(argb,8,8,3)color(1,1,1,1)";
		};
		class FilterPasswordedServers: RscPicture
		{
			idc=150;
			x=0.1;
			y=0.80000001;
			w=0.050000001;
			h=0.050000001;
			text="#(argb,8,8,3)color(1,1,1,1)";
		};
		class FilterBattlEyeServers: RscPicture
		{
			idc=154;
			x=0.1;
			y=0.80000001;
			w=0.050000001;
			h=0.050000001;
			text="#(argb,8,8,3)color(1,1,1,1)";
		};
		class B_Cancel: RscActiveText
		{
			idc=2;
			text="$STR_DISP_CANCEL";
			x=0.55000001;
			y=0.94999999;
			w=0.15000001;
		};
		class B_Join: B_Cancel
		{
			idc=105;
			text="$STR_DISP_MULTI_JOIN";
			x=0.69999999;
		};
		class B_New: B_Cancel
		{
			idc="IDC_MULTI_NEW";
			text="$STR_DISP_MULTI_NEW";
			x=0.85000002;
			default=1;
		};
	};
};
class RscDisplayHostSettings: RscStandardDisplay
{
	idd=132;
	class Controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_SERVER_TITLE";
		};
		class TextName: RscText
		{
			x=0.025;
			y=0.12;
			w=0.30000001;
			text="$STR_DISP_GAME_NAME";
		};
		class ValueName: RscEdit
		{
			idc=101;
			x=0.34999999;
			y=0.12;
			w=0.40000001;
		};
		class TextPassword: RscText
		{
			x=0.025;
			y=0.22;
			w=0.30000001;
			text="$STR_DISP_PASSWORD";
		};
		class ValuePassword: RscEdit
		{
			idc=102;
			x=0.34999999;
			y=0.22;
			w=0.40000001;
		};
		class TextMaxPlayers: RscText
		{
			x=0.025;
			y=0.31999999;
			w=0.30000001;
			text="$STR_DISP_FILTER_MAXPLAYERS";
		};
		class ValueMaxPlayers: RscEdit
		{
			idc=103;
			x=0.34999999;
			y=0.31999999;
			w=0.40000001;
		};
		class TextPrivate: RscText
		{
			x=0.025;
			y=0.41999999;
			w=0.30000001;
			text="$STR_DISP_FILTER_SERVER";
		};
		class ValuePrivate: RscListBox
		{
			idc=104;
			x=0.34999999;
			y=0.41999999;
			w=0.40000001;
		};
		class TextPort: RscText
		{
			x=0.025;
			y=0.51999998;
			w=0.30000001;
			text="$STR_DISP_IP_PORT";
		};
		class ValuePort: RscEdit
		{
			idc=105;
			x=0.34999999;
			y=0.51999998;
			w=0.40000001;
		};
		class B_Cancel: RscActiveText
		{
			idc=2;
			text="$STR_DISP_CANCEL";
			x=0.55000001;
			y=0.89999998;
			w=0.25;
		};
		class B_OK: B_Cancel
		{
			idc=1;
			text="$STR_DISP_OK";
			x=0.75;
			default=1;
		};
	};
};
class RscDisplayRemoteMissions: RscStandardDisplay
{
	idd=17;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_SERVER_TITLE";
		};
		class TextMaps: RscText
		{
			x=0.025;
			y=0.12;
			w=0.30000001;
			text="$STR_DISP_SERVER_ISLAND";
		};
		class ValueMaps: RscListBox
		{
			idc=101;
			x=0.025;
			y=0.17;
			w=0.44999999;
			h=0.60000002;
			rows=5;
		};
		class TextMissions: TextMaps
		{
			x=0.52499998;
			text="$STR_DISP_SERVER_MISSION";
		};
		class ValueMissions: ValueMaps
		{
			idc=102;
			x=0.52499998;
			rows=10;
		};
		class B_Difficulty: RscListBox
		{
			idc=104;
			x=0.050000001;
			y=0.89999998;
			w=0.25;
		};
		class B_Editor: RscActiveText
		{
			idc=103;
			x=0.34999999;
			y=0.89999998;
			w=0.25;
			text="$STR_DISP_EDIT";
		};
		class Overview: RscHTML
		{
			idc=130;
			x=0.025;
			y=0.25;
			w=0.44999999;
			h=0.40000001;
		};
		class Respawn: RscText
		{
			idc=133;
			x=0.025;
			y=0.64999998;
			w=0.44999999;
			h=0.1;
		};
		class GameType: RscText
		{
			idc=131;
			x=0.025;
			y=0.75;
			w=0.44999999;
			h=0.1;
		};
		class MaxPlayers: RscText
		{
			idc=132;
			x=0.025;
			y=0.85000002;
			w=0.44999999;
			h=0.1;
		};
		class B_Cancel: B_Editor
		{
			idc=2;
			text="$STR_DISP_CANCEL";
			x=0.55000001;
		};
		class B_OK: B_Editor
		{
			idc=1;
			text="$STR_DISP_OK";
			x=0.75;
			default=1;
		};
	};
};
class RscDisplayRemoteMissionVoted: RscStandardDisplay
{
	idd=126;
	class controls
	{
		class TextWait: RscText
		{
			text="Please wait...";
			x=0.025;
			y=0.40000001;
			w=0.94999999;
		};
		class B_Cancel: RscActiveText
		{
			idc=2;
			text="$STR_DISP_CANCEL";
			x=0.050000001;
			y=0.89999998;
			w=0.25;
		};
	};
};
class RscDisplayServer: RscDisplayRemoteMissions
{
	idd=17;
	colorEditor[]={1,0.2,0.2,1};
	colorWizard[]={0.2,1,0.2,1};
	colorMission[]={0.2,0.60000002,1,1};
	colorMissionEditor[]={1,0.2,1,1};
	colorMissionWizard[]={0.2,1,1,1};
	colorMissionSteam[]={0.2,0.2,1,0.2};
	textNew="$STR_MPW_NEW_EDIT";
	textNew3DEN="$STR_MPW_NEW_EDIT";
	textEdit="$STR_DISP_EDIT";
	textEdit3DEN="$STR_DISP_EDIT";
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_SERVER_TITLE";
		};
		class TextIslands: RscText
		{
			x=0.025;
			y=0.2;
			w=0.30000001;
			text="$STR_DISP_SERVER_ISLAND";
		};
		class ValueIslands: RscListBox
		{
			idc=101;
			x=0.025;
			y=0.25;
			w=0.44999999;
			h=0.60000002;
		};
		class TextMissions: RscText
		{
			x=0.52499998;
			y=0.2;
			w=0.30000001;
			text="$STR_DISP_SERVER_MISSION";
		};
		class ValueMissions: RscListBox
		{
			idc=102;
			x=0.52499998;
			y=0.25;
			w=0.44999999;
			h=0.60000002;
		};
		class B_Difficulty: RscListBox
		{
			idc=104;
			x=0.050000001;
			y=0.050000001;
			w=0.2;
		};
		class TitlePrivateSlots: RscStructuredText
		{
			idc=124;
			x=0.2;
			y=0.66500002;
			w=0.5;
			h=0.050000001;
			text="$STR_DISP_XBOX_PRIVATE_SLOTS";
			size="( 21 / 408 )";
			class Attributes
			{
				font="TahomaB";
				shadow=0;
				color="#000000";
				align="left";
			};
		};
		class ValuePrivateSlots: TitlePrivateSlots
		{
			idc=125;
			x=0.68000001;
		};
		class SliderPrivateSlots: RscSlider
		{
			idc=126;
			style="0x400 + 0x10";
			x=0.25;
			y=0.69999999;
			w=0.5;
			h=0.050000001;
			class Title
			{
				idc=124;
				colorBase[]={1,1,1,1};
				colorActive[]={1,0.5,0,1};
			};
			class Value
			{
				idc=125;
				colorBase[]={1,1,1,1};
				colorActive[]={1,0.5,0,1};
			};
		};
		class TitleMaxSlots: RscStructuredText
		{
			idc=127;
			x=0.2;
			y=0.75;
			w=0.5;
			h=0.050000001;
			text="$STR_DISP_XBOX_MULTI_MAX_SLOTS_DED";
			size="( 21 / 408 )";
			class Attributes
			{
				font="TahomaB";
				shadow=0;
				color="#000000";
				align="left";
			};
		};
		class ValueMaxSlots: TitleMaxSlots
		{
			idc=129;
			x=0.68000001;
		};
		class SliderMaxSlots: RscSlider
		{
			idc=128;
			style="0x400 + 0x10";
			x=0.25;
			y=0.80000001;
			w=0.5;
			h=0.050000001;
			class Title
			{
				idc=127;
				colorBase[]={1,1,1,1};
				colorActive[]={1,0.5,0,1};
			};
			class Value
			{
				idc=129;
				colorBase[]={1,1,1,1};
				colorActive[]={1,0.5,0,1};
			};
		};
		class B_Copy: RscActiveText
		{
			idc=121;
			x=0.15000001;
			y=0;
			w=0.2;
			text="$STR_CA_COPY";
		};
		class B_Delete: B_Copy
		{
			idc=120;
			x=0.25;
			text="$STR_DISP_DELETE";
		};
		class B_Editor: B_Copy
		{
			idc=103;
			x=0.44999999;
			text="$STR_DISP_EDIT";
		};
		class B_Cancel: B_Copy
		{
			idc=2;
			x=0.64999998;
			text="$STR_DISP_CANCEL";
		};
		class B_OK: B_Copy
		{
			idc=1;
			x=0.85000002;
			text="$STR_DISP_OK";
			default=1;
		};
		class B_Start: B_Copy
		{
			idc=123;
			x=0.85000002;
			y=0.050000001;
		};
	};
};
class RscDisplayClient: RscStandardDisplay
{
	idd=18;
	class controls
	{
		class Background: RscText
		{
			idc=101;
			style=2;
			x=0;
			y=0.079999998;
			w=1;
			text="$STR_DISP_CLIENT_TEXT";
		};
		class Progress: RscProgress
		{
			idc=103;
			x=0;
			y=0.91000003;
			w=1;
			h=0.079999998;
		};
		class PlayersTitle: RscText
		{
			x=0.69999999;
			y=0.69999999;
			w=0.25;
			text="$STR_DISP_SRVSETUP_PLAYERS";
			style="0x00 + 0xA0";
		};
		class Players: RscListBox
		{
			idc=102;
			x=0.69999999;
			y=0.75;
			w=0.25;
			h=0.125;
		};
	};
};
class RscDisplayMultiplayerSetup: RscStandardDisplay
{
	idd=70;
	none="#(argb,8,8,3)color(1,1,1,1)";
	westUnlocked="#(argb,8,8,3)color(1,1,1,1)";
	westLocked="#(argb,8,8,3)color(1,1,1,1)";
	eastUnlocked="#(argb,8,8,3)color(1,1,1,1)";
	eastLocked="#(argb,8,8,3)color(1,1,1,1)";
	guerUnlocked="#(argb,8,8,3)color(1,1,1,1)";
	guerLocked="#(argb,8,8,3)color(1,1,1,1)";
	civlUnlocked="#(argb,8,8,3)color(1,1,1,1)";
	civlLocked="#(argb,8,8,3)color(1,1,1,1)";
	disabledAllAI="#(argb,8,8,3)color(1,1,1,1)";
	enabledAllAI="#(argb,8,8,3)color(1,1,1,1)";
	hostLocked="#(argb,8,8,3)color(1,1,1,1)";
	hostUnlocked="#(argb,8,8,3)color(1,1,1,1)";
	logicUnlocked="#(argb,8,8,3)color(1,1,1,1)";
	logicLocked="#(argb,8,8,3)color(1,1,1,1)";
	colorNotAssigned[]={0.69999999,0,0,1};
	colorAssigned[]={0.80000001,0.80000001,0,1};
	colorConfirmed[]={0,0.69999999,0,1};
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_MPSETUP_TITLE";
		};
		class TextMission: RscText
		{
			x=0.050000001;
			y=0.17;
			w=0.15000001;
			text="$STR_DISP_SRVSETUP_NAME";
		};
		class ValueMission: RscTitle
		{
			idc=101;
			x=0.205;
			y=0.17;
			w=0.38999999;
		};
		class TextIsland: RscText
		{
			x=0.60000002;
			y=0.17;
			w=0.12;
			text="$STR_DISP_SRVSETUP_ISLAND";
		};
		class ValueIsland: RscText
		{
			idc=102;
			x=0.72500002;
			y=0.17;
			w=0.23999999;
		};
		class TextDescription: RscText
		{
			x=0.050000001;
			y=0.20999999;
			w=0.18000001;
			text="$STR_DISP_SRVSETUP_DESC";
		};
		class ValueDescription: RscText
		{
			idc=103;
			x=0.22499999;
			y=0.20999999;
			w=0.75;
		};
		class TextSide: RscText
		{
			x=0.025;
			y=0.26499999;
			w=0.125;
			text="$STR_DISP_MPSETUP_SIDE";
		};
		class B_Side: RscActiveText
		{
			x=0.02;
			w=0.085000001;
			h=0.079999998;
			colorShade[]={1,1,1,1};
			colorDisabled[]={0.30000001,0.30000001,0.30000001,1};
			pictureWidth=0.60000002;
			pictureHeight=0.60000002;
			textHeight=0.40000001;
			sideDisabled="#(argb,8,8,3)color(1,1,1,1)";
			sideToggle="#(argb,8,8,3)color(1,0,0,1)";
		};
		class B_West: B_Side
		{
			idc=104;
			y=0.34;
			text="$STR_WEST";
			picture="#(argb,8,8,3)color(1,1,1,1)";
		};
		class B_East: B_Side
		{
			idc=105;
			y=0.44;
			text="$STR_EAST";
			picture="#(argb,8,8,3)color(1,1,1,1)";
		};
		class B_Guerrila: B_Side
		{
			idc=106;
			y=0.54000002;
			text="$STR_GUERRILA";
			picture="#(argb,8,8,3)color(1,1,1,1)";
		};
		class B_Civilian: B_Side
		{
			idc=107;
			y=0.63999999;
			text="$STR_CIVILIAN";
			picture="#(argb,8,8,3)color(1,1,1,1)";
		};
		class B_EnableAll: RscActiveText
		{
			idc=117;
			x=0.025;
			y=0.77200001;
			w=0.050000001;
			h=0.067000002;
			style=48;
		};
		class B_Lock: RscActiveText
		{
			idc=118;
			x=0.075000003;
			y=0.77200001;
			w=0.050000001;
			h=0.067000002;
			style=48;
		};
		class TextRoles: RscText
		{
			idc=108;
			x=0.15000001;
			y=0.26499999;
			w=0.5;
			text="$STR_DISP_ERROR";
		};
		class ValueRoles: RscListBox
		{
			idc=109;
			x=0.15000001;
			y=0.31999999;
			w=0.5;
			h=0.40000001;
			rows=6;
			colorPlayer[]={0,0.69999999,0,1};
			colorAI[]={0.80000001,0.80000001,0,1};
			colorNobody[]={0.40000001,0.40000001,0.40000001,1};
			enabledAI="#(argb,8,8,3)color(1,1,1,1)";
			disabledAI="#(argb,8,8,3)color(1,1,1,1)";
		};
		class TextParam1: RscText
		{
			idc=110;
			x=0.15000001;
			y=0.722;
			w=0.23999999;
		};
		class ValueParam1: RscListBox
		{
			idc=111;
			x=0.15000001;
			y=0.77200001;
			w=0.23999999;
			h=0.12;
			rows=3;
		};
		class TextParam2: RscText
		{
			idc=112;
			x=0.41;
			y=0.722;
			w=0.23999999;
		};
		class ValueParam2: RscListBox
		{
			idc=113;
			x=0.41;
			y=0.77200001;
			w=0.23999999;
			h=0.12;
			rows=3;
		};
		class TextPool: RscText
		{
			x=0.67500001;
			y=0.26499999;
			w=0.30000001;
			text="$STR_DISP_SRVSIDE_POOL";
		};
		class ValuePool: RscListBox
		{
			idc=114;
			x=0.67500001;
			y=0.31999999;
			w=0.30000001;
			h=0.40000001;
			rows=15;
			canDrag=1;
		};
		class TextMessage: RscText
		{
			idc=115;
			style=2;
			x=0.025;
			y=0.1;
			w=0.94999999;
		};
		class B_Kick: RscActiveText
		{
			idc=116;
			text="$STR_DISP_MP_KICKOFF";
			x=0.050000001;
			y=0.89999998;
			w=0.15000001;
		};
		class Y_GamerCard: RscActiveText
		{
			idc=125;
			text="Gamer card";
			x=0.25;
			y=-20;
			w=0.15000001;
		};
		class PartyGUI: RscActiveText
		{
			idc=126;
			text="Show party";
			x=0.40000001;
			y=-20;
			w=0.15000001;
		};
		class AssignRole: RscActiveText
		{
			idc=127;
			text="Assign role";
			x=0.55000001;
			y=-20;
			w=0.15000001;
		};
		class B_Cancel: B_Kick
		{
			idc=2;
			text="$STR_DISP_CANCEL";
			x=0.64999998;
		};
		class B_OK: B_Kick
		{
			idc=1;
			text="$STR_DISP_OK";
			x=0.85000002;
			default=1;
		};
	};
};
class RscDisplayMultiplayerSetupParams: RscStandardDisplay
{
	idd=146;
	class controls
	{
		class Title: RscTitle
		{
			idc=-1;
			text="Params";
		};
		class LB_ParamsTitles: RscListNBox
		{
			idc=102;
			x=0.15000001;
			y=0.15000001;
			w=0.5;
			h=0.40000001;
			columns[]={0.075000003,0.57499999};
			drawSideArrows=0;
		};
		class B_Edit: RscActiveText
		{
			idc=104;
			x=0.64999998;
			y=0.89999998;
			w=0.15000001;
			text="$STR_DISP_EDIT";
		};
		class B_OK: B_Edit
		{
			idc=1;
			x=0.85000002;
			text="$STR_DISP_OK";
			default=1;
		};
	};
};
class RscDisplayMultiplayerSetupParameter: RscStandardDisplay
{
	idd=147;
	class controls
	{
		class Title: RscTitle
		{
			idc=105;
			text="";
		};
		class LB_ParamsTitles: RscListBox
		{
			idc=103;
			x=0.15000001;
			y=0.15000001;
			w=0.30000001;
			h=0.40000001;
		};
		class B_OK: RscActiveText
		{
			idc=1;
			x=0.44999999;
			y=0.89999998;
			w=0.15000001;
			text="$STR_DISP_OK";
			default=1;
		};
		class B_CANCEL: B_OK
		{
			idc=2;
			x=0.85000002;
			default=1;
			text="$STR_DISP_CANCEL";
		};
	};
};
class RscDisplayPassword: RscStandardDisplay
{
	idd=64;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_PASSWORD_TITLE";
		};
		class TextPassword: RscText
		{
			x=0.25;
			y=0.44999999;
			w=0.2;
			text="$STR_DISP_PASSWORD";
		};
		class ValuePassword: RscEdit
		{
			idc=101;
			x=0.43000001;
			y=0.44999999;
			w=0.40000001;
		};
		class B_Cancel: RscActiveText
		{
			idc=2;
			text="$STR_DISP_CANCEL";
			x=0.55000001;
			y=0.89999998;
			w=0.25;
		};
		class B_OK: B_Cancel
		{
			idc=1;
			text="$STR_DISP_OK";
			x=0.75;
			default=1;
		};
	};
};
class RscDisplayPort: RscStandardDisplay
{
	idd=69;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_PORT_TITLE";
		};
		class TextPort: RscText
		{
			x=0.25;
			y=0.44999999;
			w=0.2;
			text="$STR_DISP_IP_PORT";
		};
		class ValuePort: RscEdit
		{
			idc=101;
			x=0.43000001;
			y=0.44999999;
			w=0.40000001;
		};
		class B_Cancel: RscActiveText
		{
			idc=2;
			x=0.55000001;
			y=0.89999998;
			w=0.15000001;
			text="$STR_DISP_CANCEL";
		};
		class B_OK: B_Cancel
		{
			idc=1;
			x=0.75;
			text="$STR_DISP_OK";
			default=1;
		};
	};
};
class RscDisplayIPAddress: RscStandardDisplay
{
	idd=19;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_IP_TITLE";
		};
		class TextAddress: RscText
		{
			x=0.25;
			y=0.44999999;
			w=0.2;
			text="$STR_DISP_IP_ADDRESS";
		};
		class ValueAddress: RscEdit
		{
			idc=101;
			x=0.43000001;
			y=0.44999999;
			w=0.40000001;
		};
		class TextPort: RscText
		{
			x=0.25;
			y=0.5;
			w=0.2;
			text="$STR_DISP_IP_PORT";
		};
		class ValuePort: RscEdit
		{
			idc=102;
			x=0.43000001;
			y=0.5;
			w=0.40000001;
		};
		class B_Cancel: RscActiveText
		{
			idc=2;
			x=0.55000001;
			y=0.89999998;
			w=0.15000001;
			text="$STR_DISP_CANCEL";
		};
		class B_OK: B_Cancel
		{
			idc=1;
			x=0.75;
			text="$STR_DISP_OK";
			default=1;
		};
	};
};
class RscDisplayFilter: RscStandardDisplay
{
	idd=71;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_FILTER_TITLE";
		};
		class TextServer: RscText
		{
			x=0.1;
			y=0.2;
			w=0.27500001;
			text="$STR_DISP_FILTER_SERVER";
		};
		class TextMaxPing: TextServer
		{
			y="0.2 + 0.05";
			text="$STR_DISP_FILTER_MAXPING";
		};
		class TextMinPlayers: TextServer
		{
			y="0.2 + 0.1";
			text="$STR_DISP_FILTER_MINPLAYERS";
		};
		class TextMaxPlayers: TextServer
		{
			y="0.2 + 0.15";
			text="$STR_DISP_FILTER_MAXPLAYERS";
		};
		class ValueServer: RscEdit
		{
			idc=101;
			x=0.40000001;
			y=0.2;
			w=0.40000001;
		};
		class ValueMaxPing: ValueServer
		{
			idc=103;
			y="0.2 + 0.05";
		};
		class ValueMinPlayers: ValueServer
		{
			idc=104;
			y="0.2 + 0.1";
		};
		class ValueMaxPlayers: ValueServer
		{
			idc=105;
			y="0.2 + 0.15";
		};
		class FullServers: RscListBox
		{
			idc=106;
			x=0.15000001;
			y=0.5;
			w=0.69999999;
		};
		class PasswordedServers: FullServers
		{
			idc=107;
			y=0.56999999;
		};
		class BattlEyeServers: FullServers
		{
			idc=110;
			y=0.63999999;
		};
		class FilterType: RscListBox
		{
			idc=109;
			x=0.15000001;
			y=0.5;
			w=0.69999999;
			h=0.2;
		};
		class B_Default: RscActiveText
		{
			idc=108;
			x=0.1;
			y=0.89999998;
			w=0.15000001;
			text="$STR_DISP_DEFAULT";
		};
		class B_Cancel: B_Default
		{
			idc=2;
			text="$STR_DISP_CANCEL";
			x=0.55000001;
		};
		class B_OK: B_Default
		{
			idc=1;
			x=0.75;
			text="$STR_DISP_OK";
			default=1;
		};
	};
};
class RscDisplayMPPlayers: RscStandardDisplay
{
	idd=65;
	class controls
	{
		class Title: RscTitle
		{
			text="$STR_DISP_MP_PLAYERS_TITLE";
		};
		class TextMission: RscTextSmall
		{
			x=0.025;
			y=0.12;
			w=0.12;
			text="$STR_DISP_SRVSETUP_NAME";
		};
		class ValueMission: RscTextSmall
		{
			idc=116;
			x=0.145;
			y=0.12;
			w=0.23;
		};
		class TextIsland: RscTextSmall
		{
			x=0.40000001;
			y=0.12;
			w=0.1;
			text="$STR_DISP_SRVSETUP_ISLAND";
		};
		class ValueIsland: RscTextSmall
		{
			idc=117;
			x=0.5;
			y=0.12;
			w=0.2;
		};
		class TextTime: RscTextSmall
		{
			x=0.625;
			y=0.12;
			w=0.1;
			text="$STR_DISP_MP_PL_TIME";
		};
		class ValueTime: RscTextSmall
		{
			idc=118;
			x=0.72500002;
			y=0.12;
			w=0.1;
		};
		class ValueRest: RscTextSmall
		{
			idc=126;
			x=0.82499999;
			y=0.12;
			w=0.15000001;
		};
		class TextPlayers: RscTextSmall
		{
			x=0.025;
			y=0.15000001;
			w=0.25;
			text="$STR_DISP_MP_PLAYERS";
		};
		class ValuePlayers: RscListBox
		{
			idc=101;
			x=0.025;
			y=0.2;
			w=0.25;
			h=0.64999998;
			rows=18.5;
		};
		class TextPlayer: RscTextSmall
		{
			x=0.30000001;
			y=0.15000001;
			w=0.15000001;
			text="$STR_DISP_MP_PL";
		};
		class ValuePlayer: RscTextSmall
		{
			idc=102;
			x=0.44999999;
			y=0.15000001;
			w=0.52499998;
		};
		class TextPlayerName: RscTextSmall
		{
			x=0.32499999;
			y=0.18000001;
			w=0.125;
			text="$STR_DISP_MP_PL_NAME";
		};
		class ValuePlayerName: RscTextSmall
		{
			idc=103;
			x=0.44999999;
			y=0.18000001;
			w=0.52499998;
		};
		class TextPlayerMail: RscTextSmall
		{
			x=0.32499999;
			y=0.20999999;
			w=0.125;
			text="$STR_DISP_MP_PL_MAIL";
		};
		class ValuePlayerMail: RscTextSmall
		{
			idc=104;
			x=0.44999999;
			y=0.20999999;
			w=0.52499998;
		};
		class TextPlayerICQ: RscTextSmall
		{
			x=0.32499999;
			y=0.23999999;
			w=0.125;
			text="$STR_DISP_MP_PL_ICQ";
		};
		class ValuePlayerICQ: RscTextSmall
		{
			idc=105;
			x=0.44999999;
			y=0.23999999;
			w=0.52499998;
		};
		class TextPlayerRemark: RscTextSmall
		{
			x=0.32499999;
			y=0.27000001;
			w=0.125;
			text="$STR_DISP_MP_PL_REMARK";
		};
		class ValuePlayerRemark: RscTextSmall
		{
			idc=106;
			x=0.44999999;
			y=0.27000001;
			w=0.52499998;
			h=0.2;
			style=16;
			lines=5;
		};
		class PingTitle: RscTextSmall
		{
			x=0.32499999;
			y=0.41999999;
			w=0.15000001;
			text="$STR_DISP_MP_PING";
		};
		class PingMinValue: RscTextSmall
		{
			idc=119;
			x=0.47999999;
			y=0.41999999;
			w=0.050000001;
		};
		class PingAvgValue: RscTextSmall
		{
			idc=120;
			x=0.57999998;
			y=0.41999999;
			w=0.050000001;
		};
		class PingMaxValue: RscTextSmall
		{
			idc=121;
			x=0.68000001;
			y=0.41999999;
			w=0.050000001;
		};
		class BandwidthTitle: RscTextSmall
		{
			x=0.32499999;
			y=0.44999999;
			w=0.15000001;
			text="$STR_DISP_MP_BANDWIDTH";
		};
		class BandwidthMinValue: RscTextSmall
		{
			idc=122;
			x=0.47999999;
			y=0.44999999;
			w=0.050000001;
		};
		class BandwidthAvgValue: RscTextSmall
		{
			idc=123;
			x=0.57999998;
			y=0.44999999;
			w=0.050000001;
		};
		class BandwidthMaxValue: RscTextSmall
		{
			idc=124;
			x=0.68000001;
			y=0.44999999;
			w=0.050000001;
		};
		class DesyncTitle: RscTextSmall
		{
			x=0.32499999;
			y=0.47999999;
			w=0.15000001;
			text="$STR_DISP_MP_DESYNC";
		};
		class DesyncValue: RscTextSmall
		{
			idc=125;
			x=0.47999999;
			y=0.47999999;
			w=0.050000001;
		};
		class TextSquad: RscTextSmall
		{
			x=0.30000001;
			y=0.54000002;
			w=0.15000001;
			text="$STR_DISP_MP_SQ";
		};
		class ValueSquad: RscTextSmall
		{
			idc=107;
			x=0.44999999;
			y=0.54000002;
			w=0.52499998;
		};
		class TextSquadName: RscTextSmall
		{
			x=0.32499999;
			y=0.56999999;
			w=0.125;
			text="$STR_DISP_MP_SQ_NAME";
		};
		class ValueSquadName: RscTextSmall
		{
			idc=108;
			x=0.44999999;
			y=0.56999999;
			w=0.52499998;
		};
		class TextSquadId: RscTextSmall
		{
			x=0.32499999;
			y=0.60000002;
			w=0.125;
			text="$STR_DISP_MP_SQ_ID";
		};
		class ValueSquadId: RscTextSmall
		{
			idc=109;
			x=0.44999999;
			y=0.60000002;
			w=0.52499998;
		};
		class TextSquadMail: RscTextSmall
		{
			x=0.32499999;
			y=0.63;
			w=0.125;
			text="$STR_DISP_MP_SQ_MAIL";
		};
		class ValueSquadMail: RscTextSmall
		{
			idc=110;
			x=0.44999999;
			y=0.63;
			w=0.52499998;
		};
		class TextSquadWeb: RscTextSmall
		{
			x=0.32499999;
			y=0.66000003;
			w=0.125;
			text="$STR_DISP_MP_SQ_WEB";
		};
		class ValueSquadWeb: RscTextSmall
		{
			idc=111;
			x=0.44999999;
			y=0.66000003;
			w=0.52499998;
		};
		class TextSquadPicture: RscTextSmall
		{
			x=0.32499999;
			y=0.69;
			w=0.125;
			text="$STR_DISP_MP_SQ_PICTURE";
		};
		class ValueSquadPicture: RscText
		{
			idc=112;
			style=48;
			x=0.44999999;
			y=0.69;
			w=0.093000002;
			h=0.124;
			color[]={1,1,1,1};
		};
		class TextSquadTitle: RscTextSmall
		{
			x=0.32499999;
			y=0.81999999;
			w=0.125;
			text="$STR_DISP_MP_SQ_TITLE";
		};
		class ValueSquadTitle: RscTextSmall
		{
			idc=113;
			x=0.44999999;
			y=0.81999999;
			w=0.52499998;
		};
		class B_KickOff: RscActiveText
		{
			idc=114;
			text="$STR_DISP_MP_KICKOFF";
			x=0.050000001;
			y=0.89999998;
			w=0.2;
		};
		class B_KickOffVote: B_KickOff
		{
			idc=128;
			text="$STR_DISP_MP_KICKOFF";
			x=0.60000002;
		};
		class B_Ban: B_KickOff
		{
			idc=115;
			text="$STR_DISP_MP_BAN";
			x=0.30000001;
		};
		class B_AdminVote: B_KickOff
		{
			idc=129;
			text="$STR_DISP_MP_BAN";
			x=0.89999998;
		};
		class B_Mute: B_KickOff
		{
			idc=127;
			text="$STR_DIK_MUTE";
			x=0.55000001;
			y=0.89999998;
			w=0.2;
		};
		class B_Cancel: B_KickOff
		{
			idc=2;
			x=0.75;
			default=1;
			text="$STR_DISP_CLOSE";
		};
	};
};
class RscDisplayClientWait: RscDisplayMPPlayers
{
	idd=22;
	class Title: RscTitle
	{
		idc=130;
		text="$STR_DISP_CLIENT_WAIT_TEXT";
	};
	class ButtonCancel: RscActiveText
	{
		idc=2;
		text="$STR_DISP_CANCEL";
		x=0.85000002;
		y=0.89999998;
		w=0.25;
		default=1;
	};
};
class RscDisplayServerGetReady: RscDisplayGetReady
{
	idd=52;
	color0[]={0.69999999,0,0,1};
	color1[]={0.80000001,0.80000001,0,1};
	color2[]={0,0.69999999,0,1};
	class controls
	{
		class PlayersTitle: RscText
		{
			x=0.125;
			y=0.2;
			w=0.25;
			text="$STR_DISP_SRVSETUP_PLAYERS";
			style="0x00 + 0xA0";
		};
		class Players: RscListBox
		{
			idc=120;
			x=0.125;
			y=0.25;
			w=0.25;
			h=0.30000001;
		};
		class B_Continue: RscActiveText
		{
			idc=1;
			x=0.25;
			y=0.89999998;
			w=0.15000001;
			text="$STR_DISP_CONTINUE";
			default=1;
		};
		class B_Cancel: B_Continue
		{
			idc=2;
			x=0.1;
			text="$STR_DISP_CANCEL";
			default=0;
		};
	};
};
class RscDisplayClientGetReady: RscDisplayGetReady
{
	idd=53;
	color0[]={0.69999999,0,0,1};
	color1[]={0.80000001,0.80000001,0,1};
	color2[]={0,0.69999999,0,1};
	class controls
	{
		class PlayersTitle: RscText
		{
			x=0.125;
			y=0.2;
			w=0.25;
			text="$STR_DISP_SRVSETUP_PLAYERS";
			style="0x00 + 0xA0";
		};
		class Players: RscListBox
		{
			idc=120;
			x=0.125;
			y=0.25;
			w=0.25;
			h=0.30000001;
		};
		class B_Continue: RscActiveText
		{
			idc=1;
			x=0.25;
			y=0.89999998;
			w=0.15000001;
			text="$STR_DISP_CONTINUE";
			default=1;
		};
		class B_Cancel: B_Continue
		{
			idc=2;
			x=0.1;
			text="$STR_DISP_CANCEL";
			default=0;
		};
	};
};
class RscMPSetupMessage
{
	access=0;
	idd=-1;
	movingEnable=1;
	enableSimulation=0;
	enableDisplay=0;
	class Controls
	{
		class Background: RscText
		{
			idc=-1;
			style="";
			x=0.13;
			y=0.38;
			w=0.755;
			h=0.33000001;
			text="";
			sizeEx=0.039999999;
			colorBackground[]={0,0,0,1};
			colorText[]={0,0,0,0};
		};
		class Text
		{
			access=0;
			type=13;
			idc=101;
			style=0;
			x=0.12;
			y=0.44;
			w=0.66000003;
			h=0.1;
			size="( 21 / 408 )";
			text="$STR_DISP_ERROR";
			class Attributes
			{
				font="TahomaB";
				color="#323232";
				align="center";
				shadow=0;
			};
		};
		class Progress
		{
			access=0;
			type=8;
			idc=102;
			style=0;
			x=0.28;
			y=0.5;
			w=0.40000001;
			h=0.050000001;
			colorFrame[]={0.2,0.2,0.2,1};
			colorBar[]={0.2,0.2,0.2,1};
		};
		class ProgressIcon: RscPicture
		{
			idc=103;
			x=0.28;
			y=0.60000002;
			w=0.050000001;
			h=0.050000001;
			text="#(argb,8,8,3)color(1,1,1,1)";
		};
	};
};
class RscPendingInvitation
{
	textureConnectionQualityPoor="#(argb,8,8,3)color(1,0.5,0,1)";
	textureConnectionQualityBad="#(argb,8,8,3)color(1,0,0,1)";
	textureDesyncLow="#(argb,8,8,3)color(1,0.5,0,1)";
	textureDesyncHigh="#(argb,8,8,3)color(1,0,0,1)";
	color[]={1,1,1,1};
	x=0.94;
	y=0;
	w=0.059999999;
	h=0.079999998;
	timeout=10;
	blinkingPeriod=2;
};
class RscPendingInvitationInGame
{
	textureConnectionQualityPoor="#(argb,8,8,3)color(1,0.5,0,1)";
	textureConnectionQualityBad="#(argb,8,8,3)color(1,0,0,1)";
	textureDesyncLow="#(argb,8,8,3)color(1,0.5,0,1)";
	textureDesyncHigh="#(argb,8,8,3)color(1,0,0,1)";
	color[]={1,1,1,1};
	x=0.94;
	y=0;
	w=0.059999999;
	h=0.079999998;
	timeout=10;
	blinkingPeriod=2;
};
class cfgBuldozer
{
	uiBackground[]={0,0,0,1};
	uiForeground[]={1,1,1,1};
	uiBorderSize=0.0020000001;
	infoHeight=0.022;
	scaleInfoWidth=0.30000001;
	toolInfoWidth=0.60000002;
	fadeTimeMs=6000;
	font="LucidaConsoleB";
	fontSize=0.015;
	class BrushSelection
	{
		sampledHeightValidityTime=120;
	};
	class RoadHelper
	{
		autoReloadAfterEdit=1;
		updateTime=0.5;
		updateDist=50;
		drawDist=50;
	};
};
class RscGroupRootMenu
{
	access=0;
	title="";
	atomic=0;
	vocabulary="";
	contexsensitive=1;
	class Items
	{
		class Empty1
		{
			title="$STR_rscmenu.hpprscgrouprootmenu_items_empty1";
			shortcuts[]={0};
			command="";
			show="(IsLeader * (1 - IsAlone)) * ((IsLeader * (1 - CursorOnVehicleCanGetIn) * ((1 - PlayerVehicleCanGetIn) + (1 - NotEmptySoldiers)) * (1 - CursorOnEnemy) * (1-EnemyTargeted) * (1 - SelectedArtillery) * (1 - NotEmptyInVehicle) * (1 - IsWatchCommanded) * (1 - SomeSelectedHaveTarget) * (1 - CursorOnNeedFirstAID) * (1 - CursorOnNeedHeal) * (1 - CursorOnNeedRepair)) + (IsLeader * CursorOnGround * SomeSelectedHaveTarget) + (1 - IsLeader))";
			enable="0";
			speechId=0;
		};
		class EmptyBlank1
		{
			title="";
			shortcuts[]={0};
			command="";
			show="(1 - IsLeader) * IsAlone * (1 - CursorOnGround)";
			enable="0";
			speechId=0;
		};
		class Surpress
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Suppress";
			shortcuts[]={0};
			command="CMD_SUPPRESS";
			show="IsLeader * (IsWatchCommanded) * (1 - CursorOnNeedFirstAID) * (1 - CursorOnNeedHeal) * (1 - CursorOnNeedRepair)";
			enable="NotEmpty";
			speechId=0;
		};
		class GetIn
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_GetIn0";
			shortcuts[]={0};
			command="CMD_GETIN_AUTO";
			show="IsLeader * ((NotEmptySoldiers) * (CursorOnVehicleCanGetIn) * (1 - PlayerVehicleCanGetIn) * (1 - IsWatchCommanded)) * (1 - CursorOnNeedFirstAID) * (1 - CursorOnNeedHeal) * (1 - CursorOnNeedRepair)";
			enable="NotEmpty";
			speechId=0;
		};
		class DisableMine
		{
			title="$STR_A3_RscGroupRootMenu_Items_DisableMine0";
			shortcuts[]={0};
			command="CMD_DISABLE_MINE";
			show="IsLeader * ((NotEmptySoldiers) * (CursorOnActiveMine) * (SelectedCanDisableMine) * (1 - IsWatchCommanded)) * (1 - CursorOnNeedFirstAID) * (1 - CursorOnNeedHeal) * (1 - CursorOnNeedRepair)";
			enable="NotEmpty";
			speechId=0;
		};
		class GetInCurrent
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_GetIn1";
			shortcuts[]={0};
			command="CMD_GETIN_AUTO";
			show="IsLeader * ((NotEmptySoldiers) * (PlayerVehicleCanGetIn) * (1 - IsWatchCommanded)) * (1 - CursorOnNeedFirstAID) * (1 - CursorOnNeedHeal) * (1 - CursorOnNeedRepair)";
			enable="NotEmpty";
			speechId=0;
		};
		class GetOut
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_GetOut0";
			shortcuts[]={0};
			command="CMD_GETOUT";
			show="IsLeader * ((1 - NotEmptySoldiers) + (NotEmptyInVehicle)) * ((1 - NotEmptySoldiers) + ((1 - CursorOnVehicleCanGetIn) * (1 - PlayerVehicleCanGetIn))) * (NotEmptySoldiers + NotEmptyInVehicle) * (1 - CursorOnEnemy) * (1 - SelectedArtillery) * (1 - IsWatchCommanded) * (1 - CursorOnNeedFirstAID) * (1 - CursorOnNeedHeal) * (1 - CursorOnNeedRepair)";
			enable="NotEmpty";
			speechId=0;
		};
		class Attack
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Attack0";
			shortcuts[]={0};
			command="CMD_ATTACK_AUTO";
			show="IsLeader * CursorOnEnemy*(1-CursorOnEnemyTargeted)*(1-CursorOnEnemyEngaged) * (1 - IsWatchCommanded) * (1 - SelectedArtillery) * (1 - CursorOnNeedFirstAID) * (1 - CursorOnNeedHeal) * (1 - CursorOnNeedRepair)";
			enable="NotEmpty";
			speechId=0;
		};
		class Engage
		{
			title="$STR_engage_now";
			shortcuts[]={0};
			command="CMD_ENGAGE_AUTO";
			show="IsLeader * CursorOnEnemyTargeted * EnemyTargeted * (1-EnemyEngaged) * (1 - IsWatchCommanded) * (1 - SelectedArtillery) * (1 - CursorOnNeedFirstAID) * (1 - CursorOnNeedHeal) * (1 - CursorOnNeedRepair)";
			enable="NotEmpty";
			speechId=0;
		};
		class Fire
		{
			title="$STR_fire";
			shortcuts[]={0};
			command="CMD_FIRE_AUTO";
			show="IsLeader * CursorOnEnemyEngaged * EnemyEngaged * (1 - IsWatchCommanded) * (1 - SelectedArtillery) * (1 - CursorOnNeedFirstAID) * (1 - CursorOnNeedHeal) * (1 - CursorOnNeedRepair)";
			enable="NotEmpty";
			speechId=0;
		};
		class FireArtilery
		{
			title="$STR_A3_RscGroupRootMenu_Items_FireArtilery0";
			shortcuts[]={0};
			menu="#ARTILLERY";
			show="IsLeader * CursorOnGround * SelectedArtillery * (1 - IsWatchCommanded)";
			enable="NotEmpty";
			class Params
			{
				artillerySavePos=1;
				itemsCmd=-2;
				itemSubmenu="RscBurst";
				itemCursorTexture="#(argb,8,8,3)color(0,0,0,0)";
			};
			cursorTexture="#(argb,8,8,3)color(0,0,0,0)";
			speechId=0;
		};
		class FireArtileryAgain
		{
			title="$STR_A3_RscGroupRootMenu_Items_FireArtileryAgain0";
			shortcuts[]={0};
			command="CMD_FIRE_AT_POSITION_AMMO";
			show="IsLeader * CursorOnGround * SelectedArtillery * (1 - IsWatchCommanded) * NoEmptyLastArtilleryAmmo";
			enable="NotEmpty";
			speechId=0;
			cursorTexture="#(argb,8,8,3)color(0,0,0,0)";
			class Params
			{
				itemsCmd=-2;
				artillerySavePos=1;
			};
		};
		class Heal
		{
			title="$STR_A3_RscGroupRootMenu_Items_Heal0";
			shortcuts[]={0};
			command="CMD_HEAL";
			show="IsLeader * ((NotEmptySoldiers) * CursorOnNeedHeal * (1 - IsWatchCommanded))";
			enable="NotEmpty";
			speechId=0;
		};
		class HealSelf
		{
			title="$STR_A3_RscGroupRootMenu_Items_HealSelf0";
			shortcuts[]={0};
			command="CMD_HEAL_SELF";
			show="IsLeader * ((NotEmptySoldiers) * CursorOnNeedHealSelf * (1 - IsWatchCommanded))";
			enable="NotEmpty";
			speechId=0;
		};
		class PatchSoldier
		{
			title="$STR_A3_RscGroupRootMenu_Items_PatchSoldier0";
			shortcuts[]={0};
			command="CMD_HEALBLEEDING";
			show="IsLeader * ((NotEmptySoldiers) * CursorOnHealBleeding * (1 - IsWatchCommanded))";
			enable="NotEmpty";
			speechId=0;
		};
		class Carry
		{
			title="Carry";
			shortcuts[]={0};
			command="CMD_CARRY";
			show="IsLeader * ((NotEmptySoldiers) * CursorOnCarry * (1 - IsWatchCommanded))";
			enable="NotEmpty";
			speechId=0;
		};
		class DropCarried
		{
			title="Drop Carried";
			shortcuts[]={0};
			command="CMD_DROP_CARRIED";
			show="IsLeader * ((NotEmptySoldiers) * CursorOnDropCarried * (1 - IsWatchCommanded))";
			enable="NotEmpty";
			speechId=0;
		};
		class PutIn
		{
			title="Load in Vehicle";
			shortcuts[]={0};
			command="CMD_PUTIN";
			show="IsLeader * ((NotEmptySoldiers) * (CursorOnPutInVehicle) * (1 - IsWatchCommanded)) * (1 - CursorOnNeedFirstAID) * (1 - CursorOnNeedHeal) * (1 - CursorOnNeedRepair)";
			enable="NotEmpty";
			speechId=0;
		};
		class UnLoadFrom
		{
			title="Unload from Vehicle";
			shortcuts[]={0};
			command="CMD_UNLOADFROM";
			show="IsLeader * ((NotEmptySoldiers) * (CursorOnUnloadFromVehicle) * (1 - IsWatchCommanded)) * (1 - CursorOnNeedFirstAID) * (1 - CursorOnNeedHeal) * (1 - CursorOnNeedRepair)";
			enable="NotEmpty";
			speechId=0;
		};
		class RepairVehicle
		{
			title="$STR_rscmenu.hpprscgrouprootmenu_items_repair_vehiclel0";
			shortcuts[]={0};
			command="CMD_REPAIR_VEHICLE";
			show="IsLeader * ((NotEmptySoldiers) * CursorOnNeedRepair * (1 - IsWatchCommanded))";
			enable="NotEmpty";
			speechId=0;
		};
		class CancelTarget
		{
			title="$STR_watch_auto";
			shortcuts[]={0};
			command="CMD_NOTARGET";
			show="IsLeader * (1 - CursorOnGround) * SomeSelectedHaveTarget * (1 - CursorOnNeedFirstAID) * (1 - CursorOnNeedHeal) * (1 - CursorOnNeedRepair)";
			enable="NotEmpty";
			speechId=0;
		};
		class Copy
		{
			title="$STR_REPLY_COPY";
			shortcuts[]={0};
			command="CMD_REPLY_COPY";
			show="(1 - IsLeader) * (1 - IsAlone)";
			enable="CanAnswer";
		};
		class OpenParachute
		{
			title="$STR_A3_RscGroupRootMenu_Items_OpenParachute0";
			shortcuts[]={0};
			command="CMD_OPENPARACHUTE";
			show="IsLeader * CursorOnOpenParachute * (1 - IsWatchCommanded)";
			enable="NotEmpty";
			speechId=0;
		};
		class Empty2: Empty1
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Move0";
			show="IsLeader * (1 - CursorOnGround) * (IsWatchCommanded)";
		};
		class EmptyBlank2: Empty1
		{
			title="";
			show="IsAlone";
		};
		class Move
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Move0";
			shortcuts[]={0};
			command="CMD_MOVE_AUTO";
			show="IsLeader * CursorOnGround * (1 - IsWatchCommanded) * (1-(IsRopeEmpty * CursorOnHookable))";
			enable="NotEmpty";
			speechId=0;
		};
		class Watch
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Watch0";
			shortcuts[]={0};
			command="CMD_WATCH_CTX";
			show="IsLeader * CursorOnGround * IsWatchCommanded";
			enable="NotEmpty";
			speechId=0;
		};
		class NextWP
		{
			title="$STR_NEXT_WAYPOINT";
			shortcuts[]={0};
			command="CMD_NEXT_WAYPOINT";
			show="IsLeader * (1 - CursorOnGround) * (1 - IsWatchCommanded)";
			enable="NotEmpty + CommandsToPilot";
			speechId=0;
		};
		class HookCargo
		{
			title="$STR_RSCMENU.HPPRSCGROUPROOTMENU_ITEMS_HOOKCARGO0";
			shortcuts[]={0};
			command="CMD_HOOK_CARGO";
			show="IsLeader * IsHelicopterPilotSelected * IsRopeEmpty * CursorOnHookable";
			enable="NotEmpty";
			speechId=0;
		};
		class VehicleInVehicleGetIn
		{
			title="$STR_A3_ACTION_LOAD_VEHICLE";
			shortcuts[]={0};
			command="CMD_VIV_GETIN";
			show="IsLeader * CanTransportTargetVehicle * IsDriverSelected";
			enable="NotEmpty";
			speechId=0;
		};
		class VehicleInVehicleGetOut
		{
			title="$STR_A3_ACTION_DROP_VEHICLE";
			shortcuts[]={0};
			command="CMD_VIV_GETOUT";
			show="IsLeader * (IsLoadedInsideVehicle + HasSomeVehicleInside) * (1 - IsLandContact) * IsDriverSelected";
			enable="NotEmpty";
			speechId=0;
		};
		class VehicleInVehicleUnload
		{
			title="$STR_A3_ACTION_UNLOAD_VEHICLE";
			shortcuts[]={0};
			command="CMD_VIV_UNLOAD";
			show="IsLeader * CursorOnGround * (IsLoadedInsideVehicle + HasSomeVehicleInside) * IsDriverSelected";
			enable="NotEmpty";
			speechId=0;
		};
		class HookCargoCurrent
		{
			title="$STR_RSCMENU.HPPRSCGROUPROOTMENU_ITEMS_HOOKCARGO0";
			shortcuts[]={0};
			command="CMD_HOOK_CARGO";
			show="IsLeader * IsHelicopterPilotSelected * IsRopeEmpty * PlayerVehicleIsHookable * (1-CursorOnHookable)";
			enable="NotEmpty";
			speechId=0;
		};
		class Repeat
		{
			title="$STR_REPLY_REPEAT";
			shortcuts[]={0};
			command="CMD_REPLY_REPEAT";
			show="(1 - IsLeader) * (1 - IsAlone)";
			enable="CanAnswer";
		};
		class EmptyBlank3: Empty1
		{
			title="";
			show="IsAlone";
		};
		class UnhookCargo
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_UnhookCargo0";
			shortcuts[]={0};
			command="CMD_UNHOOK_CARGO";
			show="IsLeader * CursorOnGround * IsHelicopterPilotSelected * (1 - IsRopeEmpty)";
			enable="NotEmpty";
			speechId=0;
		};
		class Regroup
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Regroup0";
			shortcuts[]={0};
			command="CMD_JOIN";
			show="IsLeader * NotEmptySubgroups * (NotEmptySoldiers + NotEmptyInVehicle)";
			enable="1";
			speechId=0;
		};
		class Stop
		{
			title="$STR_STOP";
			shortcuts[]={0};
			command="CMD_STOP";
			show="IsLeader * (1 - NotEmptySubgroups) * (NotEmptySoldiers + NotEmptyInVehicle)";
			enable="1";
			speechId=0;
		};
		class FormationDiamond
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_FormationDiamond0";
			shortcuts[]={0};
			command="CMD_FORM_DIAMOND";
			show="IsLeader * (1 - NotEmptySoldiers) * (1 - NotEmptyInVehicle) * (1 - NotEmptySubgroups) * FormationLine";
			enable="1";
			speechId=0;
		};
		class FormationLine
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_FormationLine0";
			shortcuts[]={0};
			command="CMD_FORM_LINE";
			show="IsLeader * (1 - NotEmptySoldiers) * (1 - NotEmptyInVehicle) * (1 - NotEmptySubgroups) * (1 - FormationLine)";
			enable="1";
			speechId=0;
		};
		class Done
		{
			title="$STR_REPLY_DONE";
			shortcuts[]={0};
			command="CMD_REPLY_DONE";
			show="(1 - IsLeader) * (1 - IsAlone)";
			enable="CanAnswer";
		};
		class EmptyBlank4: Empty1
		{
			title="";
			show="IsAlone";
		};
		class OpenFire
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_OpenFire0";
			shortcuts[]=
			{
				0,
				"0x00050000 + 2",
				"0x00050000 + 2"
			};
			command="CMD_OPEN_FIRE";
			show="IsLeader * SomeSelectedHoldingFire";
			enable="NotEmpty";
			speechId=0;
		};
		class HoldFire
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_HoldFire0";
			shortcuts[]=
			{
				0,
				"0x00050000 + 2"
			};
			command="CMD_HOLD_FIRE";
			show="IsLeader * (1 - SomeSelectedHoldingFire)";
			enable="NotEmpty";
			speechId=0;
		};
		class Fail
		{
			title="$STR_REPLY_FAIL";
			shortcuts[]={0};
			command="CMD_REPLY_FAIL";
			show="(1 - IsLeader) * (1 - IsAlone)";
			enable="CanAnswer";
		};
		class Separator
		{
			title="";
			shortcuts[]={0};
			show="(1 - IsAlone)";
			enable="0";
		};
		class Empty5: Empty1
		{
			title="$STR_rscmenu.hpprscgrouprootmenu_items_empty5";
			show=" (IsLeader * (1 - CursorOnGroupMember))";
		};
		class EmptyBlank5: Empty1
		{
			title="";
			show="IsAlone";
		};
		class JoinAuto
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_JoinAuto0";
			shortcuts[]={0};
			command="CMD_JOIN_AUTO";
			show="IsLeader * CursorOnGroupMember * (CursorOnNotEmptySubgroups)";
			enable="1";
			speechId=0;
		};
		class StopAuto
		{
			title="$STR_rscmenu.hpprscgrouprootmenu_items_stopauto0";
			shortcuts[]={0};
			command="CMD_STOP_AUTO";
			show="IsLeader * CursorOnGroupMember * (1 - CursorOnNotEmptySubgroups)";
			enable="1";
			speechId=0;
		};
		class OneLess
		{
			title="$STR_REPLY_ONE_LESS";
			shortcuts[]={0};
			command="CMD_REPLY_ONE_LESS";
			show="(1 - IsLeader) * (1 - IsAlone)";
		};
		class Empty6: Empty1
		{
			title="$STR_rscmenu.hpprscgrouprootmenu_items_empty6";
			show="(IsLeader * (1 - CursorOnGroupMember))";
		};
		class EmptyBlank6: Empty1
		{
			title="";
			show="IsAlone";
		};
		class OpenFireAuto
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_OpenFireAuto0";
			shortcuts[]={0};
			command="CMD_OPEN_FIRE_AUTO";
			show="IsLeader * CursorOnGroupMember * CursorOnHoldingFire";
			enable="1";
			speechId=0;
		};
		class HoldFireAuto
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_HoldFireAuto0";
			shortcuts[]={0};
			command="CMD_HOLD_FIRE_AUTO";
			show="IsLeader * CursorOnGroupMember * (1 - CursorOnHoldingFire)";
			enable="1";
			speechId=0;
		};
		class WhereAreYou
		{
			title="$STR_REPLY_WHERE_ARE_YOU";
			shortcuts[]={0};
			command="CMD_REPLY_WHERE_ARE_YOU";
			show="(1 - IsLeader) * (1 - IsAlone)";
		};
		class Empty7: Empty1
		{
			title="$STR_rscmenu.hpprscgrouprootmenu_items_empty7";
			show="(IsLeader * (1 - CursorOnGroupMember) * (1 - CursorOnGroupMemberSelected))";
		};
		class EmptyBlank7: Empty1
		{
			title="";
			show="IsAlone";
		};
		class Select
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_SelectSet0";
			shortcuts[]={0};
			command="CMD_SELECT_AUTO";
			show="IsLeader * CursorOnGroupMember * (1 - IsSelectedToAdd)";
			enable="1";
			speechId=0;
		};
		class SelectAdd
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Select0";
			shortcuts[]={0};
			command="CMD_SELECT_AUTO_ADD";
			show="IsLeader * CursorOnGroupMember * (1 - CursorOnGroupMemberSelected) * IsSelectedToAdd";
			enable="1";
			speechId=0;
		};
		class Deselect
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Deselect0";
			shortcuts[]={0};
			command="CMD_DESELECT_AUTO";
			show="IsLeader * (CursorOnGroupMemberSelected) * IsSelectedToAdd";
			enable="1";
			speechId=0;
		};
		class UserRadio
		{
			title="$STR_RADIO_CUSTOM";
			shortcuts[]={0};
			menu="#CUSTOM_RADIO";
			show="(1 - IsLeader) * (1 - IsAlone)";
		};
		class Empty9: Empty1
		{
			title="$STR_rscmenu.hpprscgrouprootmenu_items_empty9";
			show="(IsXbox) * (1 - (IsLeader) * (1 - (IsLeader * (1 - CanSelectUnitFromBar) * (1 - CanDeselectUnitFromBar) * (1 - CanSelectVehicleFromBar) * (1 - CanDeselectVehicleFromBar) * (1 - CanSelectTeamFromBar) * (1 - CanDeselectTeamFromBar))))";
		};
		class EmptyBlank9: Empty1
		{
			title="";
			show="(1 - IsXbox) * (1 - (IsLeader) * (1 - (IsLeader * (1 - CanSelectUnitFromBar) * (1 - CanDeselectUnitFromBar) * (1 - CanSelectVehicleFromBar) * (1 - CanDeselectVehicleFromBar) * (1 - CanSelectTeamFromBar) * (1 - CanDeselectTeamFromBar))))";
			enable="0";
		};
		class SelectUnitFromBar
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_SelectUnitFromBar0";
			shortcuts[]=
			{
				0,
				"0x00050000 + 3"
			};
			command="CMD_SELECT_UNIT_FROM_BAR";
			show="IsXbox * CanSelectUnitFromBar";
			enable="NotEmpty";
			speechId=0;
		};
		class DeselectUnitFromBar
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_DeselectUnitFromBar0";
			shortcuts[]=
			{
				0,
				"0x00050000 + 3"
			};
			command="CMD_DESELECT_UNIT_FROM_BAR";
			show="IsXbox * CanDeselectUnitFromBar";
			enable="NotEmpty";
			speechId=0;
		};
		class SelectVehicleFromBar
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_SelectVehicleFromBar0";
			shortcuts[]=
			{
				0,
				"0x00050000 + 3"
			};
			command="CMD_SELECT_VEHICLE_FROM_BAR";
			show="IsXbox * CanSelectVehicleFromBar";
			enable="NotEmpty";
			speechId=0;
		};
		class DeselectVehicleFromBar
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_DeselectVehicleFromBar0";
			shortcuts[]=
			{
				0,
				"0x00050000 + 3"
			};
			command="CMD_DESELECT_VEHICLE_FROM_BAR";
			show="IsXbox * CanDeselectVehicleFromBar";
			enable="NotEmpty";
			speechId=0;
		};
		class SelectTeamFromBar
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_SelectTeamFromBar0";
			shortcuts[]=
			{
				0,
				"0x00050000 + 3"
			};
			command="CMD_SELECT_TEAM_FROM_BAR";
			show="IsXbox * CanSelectTeamFromBar";
			enable="NotEmpty";
			speechId=0;
		};
		class DeselectTeamFromBar
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_DeselectTeamFromBar0";
			shortcuts[]=
			{
				0,
				"0x00050000 + 3"
			};
			command="CMD_DESELECT_TEAM_FROM_BAR";
			show="IsXbox * CanDeselectTeamFromBar";
			enable="NotEmpty";
			speechId=0;
		};
		class EmptyBlank8: Empty1
		{
			title="";
			show="IsAlone";
		};
		class SwitchToLeader
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_SwitchToLeader0";
			shortcuts[]={0};
			command="CMD_SWITCH_TO_LEADER";
			show="(1 - IsLeader) * (1 - IsAlone) * PlayableLeader";
			enable="1";
			speechId=0;
		};
		class SwitchToSelected
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_SwitchToSelected0";
			shortcuts[]={0};
			command="CMD_SWITCH_TO_SELECTED";
			show="IsLeader * PlayableSelected";
			enable="NotEmpty";
			speechId=0;
		};
		class Team
		{
			title="$STR_TEAM";
			shortcuts[]={0};
			menu="RscTeam";
			show="IsLeader * (1 - PlayableSelected)";
			speechId=0;
		};
		class Empty10: Empty1
		{
			title="$STR_rscmenu.hpprscgrouprootmenu_items_empty0";
			show="(1 - FuelLow) * (1 - AmmoLow) * (1 - Injured)";
		};
		class Injured
		{
			title="$STR_REPLY_INJURED";
			shortcuts[]={0};
			command="CMD_REPLY_INJURED";
			show="Injured";
		};
		class AmmoLow
		{
			title="$STR_REPLY_AMMO_LOW";
			shortcuts[]={0};
			command="CMD_REPLY_AMMO_LOW";
			show="AmmoLow * (1 - Injured)";
		};
		class FuelLow
		{
			title="$STR_REPLY_FUEL_LOW";
			shortcuts[]={0};
			command="CMD_REPLY_FUEL_LOW";
			show="FuelLow * (1 - AmmoLow) * (1 - Injured)";
		};
		class Communication
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Communication0";
			shortcuts[]={0};
			menu="#User:BIS_MENU_GroupCommunication";
			show="1";
			enable="1";
			speechId=0;
		};
	};
};
class RscMainMenu
{
	access=0;
	title="$STR_COMMAND";
	atomic=0;
	vocabulary="";
	class Items
	{
		class Move
		{
			title="$STR_MOVE";
			shortcuts[]={2};
			shortcutsAction="CommandingMenu1";
			menu="RscMoveHigh";
			show="IsLeader + VehicleCommander";
			enable="NotEmpty + CommandsToPilot";
			speechId=0;
		};
		class Target
		{
			title="$STR_WATCH_TARGET";
			shortcuts[]={3};
			shortcutsAction="CommandingMenu2";
			menu="#WATCH";
			show="IsLeader + VehicleCommander";
			enable="NotEmpty + CommandsToGunner";
			speechId=0;
		};
		class Engage
		{
			title="$STR_WATCH";
			shortcuts[]={4};
			shortcutsAction="CommandingMenu3";
			menu="RscWatchDir";
			show="IsLeader + VehicleCommander";
			enable="NotEmpty + CommandsToGunner";
			speechId=0;
		};
		class GetIn
		{
			title="$STR_GETIN";
			shortcuts[]={5};
			shortcutsAction="CommandingMenu4";
			menu="#GET_IN";
			show="IsLeader";
			enable="NotEmpty";
			speechId=0;
		};
		class Status
		{
			title="$STR_STATUS";
			shortcuts[]={6};
			shortcutsAction="CommandingMenu5";
			menu="RscStatus";
			speechId=0;
		};
		class Action
		{
			title="$STR_ACTION";
			shortcuts[]={7};
			shortcutsAction="CommandingMenu6";
			menu="#ACTION";
			show="IsLeader";
			enable="AreActions";
			speechId=0;
		};
		class CombatMode
		{
			title="$STR_COMBAT_MODE";
			shortcuts[]={8};
			shortcutsAction="CommandingMenu7";
			menu="RscCombatMode";
			show="(IsLeader + VehicleCommander)*(1-CursorOnSwimmingCommands)";
			enable="NotEmpty + CommandsToGunner";
			speechId=0;
		};
		class Formations
		{
			title="$STR_FORMATION";
			shortcuts[]={9};
			shortcutsAction="CommandingMenu8";
			menu="RscFormations";
			show="IsLeader";
			speechId=0;
		};
		class Team
		{
			title="$STR_TEAM";
			shortcuts[]={10};
			shortcutsAction="CommandingMenu9";
			menu="RscTeam";
			show="IsLeader";
			speechId=0;
		};
		class Reply
		{
			title="$STR_REPLY";
			shortcuts[]={11};
			shortcutsAction="CommandingMenu0";
			menu="RscReply";
			speechId=0;
		};
		class Back
		{
			title="";
			shortcuts[]={14};
			shortcutsAction="NavigateMenu";
			command=-4;
			speechId=0;
		};
	};
};
class RscSubmenu
{
	access=0;
	atomic=0;
	class Separator
	{
		title="";
		shortcuts[]={0};
		command=-1;
	};
	class SeparatorUnderWater
	{
		title="";
		shortcuts[]={0};
		command=-1;
		show="CursorOnSwimmingCommands";
	};
	class Back
	{
		title="";
		shortcuts[]={14};
		shortcutsAction="NavigateMenu";
		command=-4;
		speechId=0;
	};
};
class RscMoveHigh: RscSubmenu
{
	title="$STR_MOVE";
	vocabulary="";
	items[]=
	{
		"Join",
		"Separator",
		"Advance",
		"StayBack",
		"FlankLeft",
		"FlankRight",
		"Separator",
		"Stop",
		"SeparatorUnderWater",
		"Ascend",
		"AscendRelative",
		"KeepDepthLeader",
		"Descend",
		"DescendRelative",
		"Expect",
		"Hide",
		"Separator",
		"NextWP",
		"Back"
	};
	class Join
	{
		title="$STR_FOLLOW_ME";
		shortcuts[]={2};
		shortcutsAction="CommandingMenu1";
		command="CMD_JOIN";
		show="IsLeader + VehicleCommander";
		enable="NotEmpty + CommandsToPilot";
		speechId=0;
	};
	class Advance
	{
		title="$STR_ADVANCE";
		shortcuts[]={3};
		shortcutsAction="CommandingMenu2";
		command="CMD_ADVANCE";
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class StayBack
	{
		title="$STR_STAY_BACK";
		shortcuts[]={4};
		shortcutsAction="CommandingMenu3";
		command="CMD_STAY_BACK";
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class FlankLeft
	{
		title="$STR_FLANK_LEFT";
		shortcuts[]={5};
		shortcutsAction="CommandingMenu4";
		command="CMD_FLANK_LEFT";
		show="IsLeader";
		enable="NotEmpty";
	};
	class FlankRight
	{
		title="$STR_FLANK_RIGHT";
		shortcuts[]={6};
		shortcutsAction="CommandingMenu5";
		command="CMD_FLANK_RIGHT";
		show="IsLeader";
		enable="NotEmpty";
	};
	class Stop
	{
		title="$STR_STOP";
		shortcuts[]={7};
		shortcutsAction="CommandingMenu6";
		command="CMD_STOP";
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class Ascend
	{
		title="$STR_A3_RscMoveHigh_Ascend0";
		shortcuts[]={8};
		shortcutsAction="CommandingMenu7";
		command="CMD_KEEP_DEPTH_ABOVESURFACE";
		show="IsLeader * CursorOnSwimmingCommands";
		enable="NotEmpty";
		speechId=0;
	};
	class AscendRelative
	{
		title="$STR_A3_RscMoveHigh_AscendRelative0";
		shortcuts[]={0};
		command="CMD_KEEP_DEPTH_RELATIVE_UP";
		show="IsLeader * CursorOnSwimmingCommands * IsOutsideLeaderVehicle";
		enable="NotEmpty";
		speechId=0;
	};
	class KeepDepthLeader
	{
		title="$STR_A3_RscMoveHigh_KeepDepthLeader0";
		shortcuts[]={0};
		command="CMD_KEEP_DEPTH_LEADER";
		show="IsLeader * CursorOnSwimmingCommands * IsOutsideLeaderVehicle";
		enable="NotEmpty";
		speechId=0;
	};
	class Descend
	{
		title="$STR_A3_RscMoveHigh_Descend0";
		shortcuts[]={0};
		command="CMD_KEEP_DEPTH_BOTTOM";
		show="IsLeader * CursorOnSwimmingCommands";
		enable="NotEmpty";
		speechId=0;
	};
	class DescendRelative
	{
		title="$STR_A3_RscMoveHigh_DescendRelative0";
		shortcuts[]={0};
		command="CMD_KEEP_DEPTH_RELATIVE_DOWN";
		show="IsLeader * CursorOnSwimmingCommands  * IsOutsideLeaderVehicle";
		enable="NotEmpty";
		speechId=0;
	};
	class Expect
	{
		title="$STR_EXPECT";
		shortcuts[]={8};
		shortcutsAction="CommandingMenu7";
		command="CMD_EXPECT";
		show="IsLeader * (1-CursorOnSwimmingCommands)";
		enable="NotEmpty";
	};
	class Hide
	{
		title="$STR_HIDE";
		shortcuts[]={9};
		shortcutsAction="CommandingMenu8";
		command="CMD_HIDE";
		show="IsLeader * (1-CursorOnSwimmingCommands)";
		enable="NotEmpty";
	};
	class NextWP
	{
		title="$STR_NEXT_WAYPOINT";
		shortcuts[]={10};
		shortcutsAction="CommandingMenu9";
		command="CMD_NEXT_WAYPOINT";
		show="IsLeader + VehicleCommander";
		enable="NotEmpty + CommandsToPilot";
		speechId=0;
	};
};
class RscMoveDir: RscSubmenu
{
	atomic=1;
	title="$STR_MOVE_DIR";
	vocabulary="";
	items[]=
	{
		"N",
		"NE",
		"E",
		"SE",
		"S",
		"SW",
		"W",
		"NW",
		"Back"
	};
	class N
	{
		title="$STR_MOVE_N";
		shortcuts[]={2};
		shortcutsAction="CommandingMenu1";
		menu="RscMoveDist";
		class Params
		{
			dir=0;
		};
		show="IsLeader";
		enable="NotEmpty";
	};
	class NE
	{
		title="$STR_MOVE_NE";
		shortcuts[]={3};
		shortcutsAction="CommandingMenu2";
		menu="RscMoveDist";
		class Params
		{
			dir=45;
		};
		show="IsLeader";
		enable="NotEmpty";
	};
	class E
	{
		title="$STR_MOVE_E";
		shortcuts[]={4};
		shortcutsAction="CommandingMenu3";
		menu="RscMoveDist";
		class Params
		{
			dir=90;
		};
		show="IsLeader";
		enable="NotEmpty";
	};
	class SE
	{
		title="$STR_MOVE_SE";
		shortcuts[]={5};
		shortcutsAction="CommandingMenu4";
		menu="RscMoveDist";
		class Params
		{
			dir=135;
		};
		show="IsLeader";
		enable="NotEmpty";
	};
	class S
	{
		title="$STR_MOVE_S";
		shortcuts[]={6};
		shortcutsAction="CommandingMenu5";
		menu="RscMoveDist";
		class Params
		{
			dir=180;
		};
		show="IsLeader";
		enable="NotEmpty";
	};
	class SW
	{
		title="$STR_MOVE_SW";
		shortcuts[]={7};
		shortcutsAction="CommandingMenu6";
		menu="RscMoveDist";
		class Params
		{
			dir=225;
		};
		show="IsLeader";
		enable="NotEmpty";
	};
	class W
	{
		title="$STR_MOVE_W";
		shortcuts[]={8};
		shortcutsAction="CommandingMenu7";
		menu="RscMoveDist";
		class Params
		{
			dir=270;
		};
		show="IsLeader";
		enable="NotEmpty";
	};
	class NW
	{
		title="$STR_MOVE_NW";
		shortcuts[]={9};
		shortcutsAction="CommandingMenu8";
		menu="RscMoveDist";
		class Params
		{
			dir=315;
		};
		show="IsLeader";
		enable="NotEmpty";
	};
};
class RscReply: RscSubmenu
{
	title="$STR_REPLY_MENU";
	vocabulary="";
	items[]=
	{
		"Done",
		"Fail",
		"FireReady",
		"FireNotReady",
		"Repeat",
		"Copy",
		"Separator",
		"Communication",
		"UserRadio",
		"Radio",
		"Back"
	};
	class Done
	{
		title="$STR_REPLY_DONE";
		shortcuts[]={2};
		shortcutsAction="CommandingMenu1";
		command="CMD_REPLY_DONE";
		enable="CanAnswer";
	};
	class Fail
	{
		title="$STR_REPLY_FAIL";
		shortcuts[]={3};
		shortcutsAction="CommandingMenu2";
		command="CMD_REPLY_FAIL";
		enable="CanAnswer";
	};
	class FireReady
	{
		title="$STR_REPLY_FIREREADY";
		shortcuts[]={4};
		shortcutsAction="CommandingMenu3";
		command="CMD_REPLY_FIREREADY";
	};
	class FireNotReady
	{
		title="$STR_REPLY_FIRENOTREADY";
		shortcuts[]={5};
		shortcutsAction="CommandingMenu4";
		command="CMD_REPLY_FIRENOTREADY";
	};
	class Repeat
	{
		title="$STR_REPLY_REPEAT";
		shortcuts[]={7};
		shortcutsAction="CommandingMenu6";
		command="CMD_REPLY_REPEAT";
		enable="CanAnswer";
	};
	class Copy
	{
		title="$STR_REPLY_COPY";
		shortcuts[]={8};
		shortcutsAction="CommandingMenu7";
		command="CMD_REPLY_COPY";
		enable="CanAnswer";
	};
	class Separator
	{
		title="";
		shortcuts[]={0};
		command=-1;
	};
	class Communication
	{
		title="$STR_rscMenu.hppRscGroupRootMenu_Items_Communication0";
		shortcuts[]={9};
		shortcutsAction="CommandingMenu8";
		menu="#User:BIS_MENU_GroupCommunication";
		show="1";
		enable="1";
		speechId=0;
	};
	class UserRadio
	{
		title="$STR_RADIO_CUSTOM";
		shortcuts[]={10};
		shortcutsAction="CommandingMenu9";
		menu="#CUSTOM_RADIO";
	};
	class Radio
	{
		title="$STR_RADIO";
		shortcuts[]={11};
		shortcutsAction="CommandingMenu0";
		menu="RscRadio";
		enable="HasRadio";
	};
};
class RscCallSupport: RscSubmenu
{
	title="$STR_SUPPORT_MENU";
	vocabulary="";
	items[]=
	{
		"Medic",
		"Ambulance",
		"Repair",
		"Rearm",
		"Refuel",
		"Done",
		"Back"
	};
	class Medic
	{
		title="$STR_SUPPORT_MEDIC";
		shortcuts[]={2};
		shortcutsAction="CommandingMenu1";
		command="CMD_SUPPORT_MEDIC";
		show="IsLeader * (1-CursorOnSwimmingCommands)";
		speechId=0;
	};
	class Ambulance
	{
		title="$STR_A3_RscCallSupport_Ambulance0";
		shortcuts[]={3};
		shortcutsAction="CommandingMenu2";
		command="CMD_SUPPORT_AMBULANCE";
		show="IsLeader * (1-CursorOnSwimmingCommands)";
		speechId=0;
	};
	class Repair
	{
		title="$STR_SUPPORT_REPAIR";
		shortcuts[]={4};
		shortcutsAction="CommandingMenu3";
		command="CMD_SUPPORT_REPAIR";
		show="IsLeader * (1-CursorOnSwimmingCommands)";
		speechId=0;
	};
	class Rearm
	{
		title="$STR_SUPPORT_REARM";
		shortcuts[]={5};
		shortcutsAction="CommandingMenu4";
		command="CMD_SUPPORT_REARM";
		show="IsLeader * (1-CursorOnSwimmingCommands)";
		speechId=0;
	};
	class Refuel
	{
		title="$STR_SUPPORT_REFUEL";
		shortcuts[]={6};
		shortcutsAction="CommandingMenu5";
		command="CMD_SUPPORT_REFUEL";
		show="IsLeader * (1-CursorOnSwimmingCommands)";
		speechId=0;
	};
	class Done
	{
		title="$STR_SUPPORT_DONE";
		shortcuts[]={7};
		shortcutsAction="CommandingMenu6";
		command="CMD_SUPPORT_DONE";
		show="IsLeader * (1-CursorOnSwimmingCommands)";
		speechId=0;
	};
};
class RscStatus: RscSubmenu
{
	title="$STR_MENU_STATUS";
	vocabulary="";
	items[]=
	{
		"Support",
		"FuelLow",
		"AmmoLow",
		"Injured",
		"WhereAreYou",
		"Report",
		"UnderFire",
		"OneLess",
		"IsDown",
		"OutOfFAKs",
		"Back"
	};
	class Support
	{
		title="$STR_CALL_SUPPORT";
		shortcuts[]={2};
		shortcutsAction="CommandingMenu1";
		menu="RscCallSupport";
		show="1-CursorOnSwimmingCommands";
	};
	class FuelLow
	{
		title="$STR_REPLY_FUEL_LOW";
		shortcuts[]={3};
		shortcutsAction="CommandingMenu2";
		command="CMD_REPLY_FUEL_LOW";
	};
	class AmmoLow
	{
		title="$STR_REPLY_AMMO_LOW";
		shortcuts[]={4};
		shortcutsAction="CommandingMenu3";
		command="CMD_REPLY_AMMO_LOW";
	};
	class Injured
	{
		title="$STR_REPLY_INJURED";
		shortcuts[]={5};
		shortcutsAction="CommandingMenu4";
		command="CMD_REPLY_INJURED";
	};
	class WhereAreYou
	{
		title="$STR_REPLY_WHERE_ARE_YOU";
		shortcuts[]={6};
		shortcutsAction="CommandingMenu5";
		command="CMD_REPLY_WHERE_ARE_YOU";
		show="1 - IsLeader";
	};
	class Report
	{
		title="$STR_REPORT";
		shortcuts[]={6};
		shortcutsAction="CommandingMenu5";
		command="CMD_REPORT";
		show="IsLeader";
		enable="NotEmpty";
	};
	class UnderFire
	{
		title="$STR_REPLY_UNDER_FIRE";
		shortcuts[]={7};
		shortcutsAction="CommandingMenu6";
		command="CMD_REPLY_UNDER_FIRE";
	};
	class OneLess
	{
		title="$STR_REPLY_ONE_LESS";
		shortcuts[]={8};
		shortcutsAction="CommandingMenu7";
		command="CMD_REPLY_ONE_LESS";
	};
	class IsDown
	{
		title="$STR_REPLY_KILLED";
		shortcuts[]={9};
		shortcutsAction="CommandingMenu8";
		command="CMD_REPLY_KILLED";
		enable="NotEmpty";
	};
	class OutOfFAKs
	{
		title="$STR_A3_RscStatus_OutOfFAKs0";
		shortcuts[]={10};
		shortcutsAction="CommandingMenu9";
		command="CMD_REPLY_OUT_OF_FAKs";
		show="CursorOnOutOfFak";
	};
};
class RscWatchDir: RscSubmenu
{
	title="$STR_WATCH";
	vocabulary="";
	items[]=
	{
		"OpenFire",
		"HoldFire",
		"Fire",
		"Separator",
		"Engage",
		"EngageAtWill",
		"Disengage",
		"Separator",
		"LookAround",
		"WatchDir",
		"Separator",
		"Suppress",
		"Back"
	};
	class OpenFire
	{
		title="$STR_OPEN_FIRE";
		shortcuts[]={2};
		shortcutsAction="CommandingMenu1";
		command="CMD_OPEN_FIRE";
		show="IsLeader + VehicleCommander";
		enable="NotEmpty + CommandsToGunner";
	};
	class HoldFire
	{
		title="$STR_HOLD_FIRE";
		shortcuts[]={3};
		shortcutsAction="CommandingMenu2";
		command="CMD_HOLD_FIRE";
		show="IsLeader + VehicleCommander";
		enable="NotEmpty + CommandsToGunner";
	};
	class Fire
	{
		title="$STR_FIRE";
		shortcuts[]={4};
		shortcutsAction="CommandingMenu3";
		command="CMD_FIRE";
		show="IsLeader";
		enable="NotEmpty";
	};
	class Engage
	{
		title="$STR_ENGAGE_NOW";
		shortcuts[]={5};
		shortcutsAction="CommandingMenu4";
		command="CMD_ENGAGE";
		show="IsLeader";
		enable="NotEmpty";
	};
	class EngageAtWill
	{
		title="$STR_ENGAGE_AT_WILL";
		shortcuts[]={6};
		shortcutsAction="CommandingMenu5";
		command="CMD_LOOSE_FORM";
		show="IsLeader";
		enable="NotEmpty";
	};
	class Disengage
	{
		title="$STR_DISENGAGE";
		shortcuts[]={7};
		shortcutsAction="CommandingMenu6";
		command="CMD_KEEP_FORM";
		show="IsLeader";
		enable="NotEmpty";
	};
	class Auto
	{
		title="$STR_WATCH_AUTO";
		shortcuts[]={8};
		shortcutsAction="CommandingMenu7";
		command="CMD_WATCH_AUTO";
		show="IsLeader";
		enable="NotEmpty";
	};
	class LookAround
	{
		title="$STR_LOOK_AROUND";
		shortcuts[]={8};
		shortcutsAction="CommandingMenu7";
		command="CMD_WATCH_AROUND";
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class WatchDir
	{
		title="$STR_WATCH_DIR";
		shortcuts[]={9};
		shortcutsAction="CommandingMenu8";
		menu="RscWatchMoreDir";
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class Suppress
	{
		title="$STR_rscMenu.hppRscGroupRootMenu_Items_Suppress";
		shortcuts[]={10};
		shortcutsAction="CommandingMenu9";
		command="CMD_SUPPRESS";
		show="IsLeader * (1-CursorOnSwimmingCommands)";
		enable="NotEmpty";
		speechId=0;
	};
};
class RscWatchMoreDir: RscSubmenu
{
	title="$STR_WATCH_DIR";
	atomic=1;
	vocabulary="";
	items[]=
	{
		"N",
		"NE",
		"E",
		"SE",
		"S",
		"SW",
		"W",
		"NW",
		"Back"
	};
	class N
	{
		title="$STR_MOVE_N";
		shortcuts[]={2};
		shortcutsAction="CommandingMenu1";
		command="CMD_WATCH_DIR";
		class Params
		{
			dir=0;
		};
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class NE
	{
		title="$STR_MOVE_NE";
		shortcuts[]={3};
		shortcutsAction="CommandingMenu2";
		command="CMD_WATCH_DIR";
		class Params
		{
			dir=45;
		};
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class E
	{
		title="$STR_MOVE_E";
		shortcuts[]={4};
		shortcutsAction="CommandingMenu3";
		command="CMD_WATCH_DIR";
		class Params
		{
			dir=90;
		};
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class SE
	{
		title="$STR_MOVE_SE";
		shortcuts[]={5};
		shortcutsAction="CommandingMenu4";
		command="CMD_WATCH_DIR";
		class Params
		{
			dir=135;
		};
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class S
	{
		title="$STR_MOVE_S";
		shortcuts[]={6};
		shortcutsAction="CommandingMenu5";
		command="CMD_WATCH_DIR";
		class Params
		{
			dir=180;
		};
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class SW
	{
		title="$STR_MOVE_SW";
		shortcuts[]={7};
		shortcutsAction="CommandingMenu6";
		command="CMD_WATCH_DIR";
		class Params
		{
			dir=225;
		};
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class W
	{
		title="$STR_MOVE_W";
		shortcuts[]={8};
		shortcutsAction="CommandingMenu7";
		command="CMD_WATCH_DIR";
		class Params
		{
			dir=270;
		};
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class NW
	{
		title="$STR_MOVE_NW";
		shortcuts[]={9};
		shortcutsAction="CommandingMenu8";
		command="CMD_WATCH_DIR";
		class Params
		{
			dir=315;
		};
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
};
class RscMoveDist: RscSubmenu
{
	title="$STR_MOVE_DIST";
	vocabulary="";
	items[]=
	{
		"D50",
		"D100",
		"D200",
		"D500",
		"D1000",
		"D2000",
		"Back"
	};
	class D50
	{
		title="$STR_MOVE_50";
		shortcuts[]={2};
		shortcutsAction="CommandingMenu1";
		command="CMD_MOVE";
		class Params
		{
			dist=50;
		};
		show="IsLeader";
		enable="NotEmpty";
	};
	class D100
	{
		title="$STR_MOVE_100";
		shortcuts[]={3};
		shortcutsAction="CommandingMenu2";
		command="CMD_MOVE";
		class Params
		{
			dist=100;
		};
		show="IsLeader";
		enable="NotEmpty";
	};
	class D200
	{
		title="$STR_MOVE_200";
		shortcuts[]={4};
		shortcutsAction="CommandingMenu3";
		command="CMD_MOVE";
		class Params
		{
			dist=200;
		};
		show="IsLeader";
		enable="NotEmpty";
	};
	class D500
	{
		title="$STR_MOVE_500";
		shortcuts[]={5};
		shortcutsAction="CommandingMenu4";
		command="CMD_MOVE";
		class Params
		{
			dist=500;
		};
		show="IsLeader";
		enable="NotEmpty";
	};
	class D1000
	{
		title="$STR_MOVE_1000";
		shortcuts[]={6};
		shortcutsAction="CommandingMenu5";
		command="CMD_MOVE";
		class Params
		{
			dist=1000;
		};
		show="IsLeader";
		enable="NotEmpty";
	};
	class D2000
	{
		title="$STR_MOVE_2000";
		shortcuts[]={7};
		shortcutsAction="CommandingMenu6";
		command="CMD_MOVE";
		class Params
		{
			dist=2000;
		};
		show="IsLeader";
		enable="NotEmpty";
	};
};
class RscFormations: RscSubmenu
{
	title="$STR_FORMATION";
	vocabulary="";
	items[]=
	{
		"Column",
		"Staggered",
		"Wedge",
		"EchL",
		"EchR",
		"Vee",
		"Line",
		"File",
		"Diamond",
		"Back"
	};
	class Column
	{
		title="$STR_COLUMN";
		shortcuts[]={2};
		shortcutsAction="CommandingMenu1";
		command="CMD_FORM_COLUMN";
		show="IsLeader";
		speechId=0;
	};
	class Staggered
	{
		title="$STR_STAGGERED";
		shortcuts[]={3};
		shortcutsAction="CommandingMenu2";
		command="CMD_FORM_STAGCOL";
		show="IsLeader";
	};
	class Wedge
	{
		title="$STR_WEDGE";
		shortcuts[]={4};
		shortcutsAction="CommandingMenu3";
		command="CMD_FORM_WEDGE";
		show="IsLeader";
		speechId=0;
	};
	class EchL
	{
		title="$STR_ECHL";
		shortcuts[]={5};
		shortcutsAction="CommandingMenu4";
		command="CMD_FORM_ECHLEFT";
		show="IsLeader";
		speechId=0;
	};
	class EchR
	{
		title="$STR_ECHR";
		shortcuts[]={6};
		shortcutsAction="CommandingMenu5";
		command="CMD_FORM_ECHRIGHT";
		show="IsLeader";
		speechId=0;
	};
	class Vee
	{
		title="$STR_VEE";
		shortcuts[]={7};
		shortcutsAction="CommandingMenu6";
		command="CMD_FORM_VEE";
		show="IsLeader";
	};
	class Line
	{
		title="$STR_LINE";
		shortcuts[]={8};
		shortcutsAction="CommandingMenu7";
		command="CMD_FORM_LINE";
		show="IsLeader";
		speechId=0;
	};
	class File
	{
		title="$STR_FILE";
		shortcuts[]={9};
		shortcutsAction="CommandingMenu8";
		command="CMD_FORM_FILE";
		show="IsLeader";
		speechId=0;
	};
	class Diamond
	{
		title="$STR_DIAMOND";
		shortcuts[]={10};
		shortcutsAction="CommandingMenu9";
		command="CMD_FORM_DIAMOND";
		show="IsLeader";
		speechId=0;
	};
};
class RscCombatMode: RscSubmenu
{
	title="$STR_COMBAT_MODE";
	vocabulary="";
	items[]=
	{
		"Stealth",
		"Combat",
		"Aware",
		"Safe",
		"Separator",
		"PosUp",
		"PosCrouch",
		"PosDown",
		"PosAuto",
		"Back"
	};
	class Stealth
	{
		title="$STR_STEALTH";
		shortcuts[]={2};
		shortcutsAction="CommandingMenu1";
		command="CMD_STEALTH";
		show="IsLeader";
		enable="NotEmpty";
	};
	class Combat
	{
		title="$STR_COMBAT";
		shortcuts[]={3};
		shortcutsAction="CommandingMenu2";
		command="CMD_COMBAT";
		show="IsLeader";
		enable="NotEmpty";
	};
	class Aware
	{
		title="$STR_AWARE";
		shortcuts[]={4};
		shortcutsAction="CommandingMenu3";
		command="CMD_AWARE";
		show="IsLeader";
		enable="NotEmpty";
	};
	class Safe
	{
		title="$STR_SAFE";
		shortcuts[]={5};
		shortcutsAction="CommandingMenu4";
		command="CMD_SAFE";
		show="IsLeader";
		enable="NotEmpty";
	};
	class PosUp
	{
		title="$STR_POS_UP";
		shortcuts[]={7};
		shortcutsAction="CommandingMenu6";
		command="CMD_POS_UP";
		show="IsLeader*(1-CursorOnSwimmingCommands)";
		enable="NotEmptySoldiers";
		speechId=0;
	};
	class PosCrouch
	{
		title="$STR_POS_CROUCH";
		shortcuts[]={8};
		shortcutsAction="CommandingMenu7";
		command="CMD_POS_MIDDLE";
		show="IsLeader*(1-CursorOnSwimmingCommands)";
		enable="NotEmptySoldiers";
		speechId=0;
	};
	class PosDown
	{
		title="$STR_POS_DOWN";
		shortcuts[]={9};
		shortcutsAction="CommandingMenu8";
		command="CMD_POS_DOWN";
		show="IsLeader*(1-CursorOnSwimmingCommands)";
		enable="NotEmptySoldiers";
		speechId=0;
	};
	class PosAuto
	{
		title="$STR_POS_AUTO";
		shortcuts[]={10};
		shortcutsAction="CommandingMenu9";
		command="CMD_POS_AUTO";
		show="IsLeader*(1-CursorOnSwimmingCommands)";
		enable="NotEmptySoldiers";
		speechId=0;
	};
};
class RscBurst: RscSubmenu
{
	title="$STR_A3_RscBurst0";
	vocabulary="";
	contexsensitive=1;
	items[]=
	{
		"Item1",
		"Item2",
		"Item3",
		"Item4"
	};
	class Item1
	{
		title="$STR_A3_RscBurst_Item10";
		shortcuts[]={2};
		shortcutsAction="CommandingMenu1";
		command="CMD_FIRE_AT_POSITION_AMMO";
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
		cursorTexture="#(argb,8,8,3)color(0,0,0,0)";
		class Params
		{
			artilleryBurst=1;
		};
	};
	class Item2
	{
		title="Burst 2";
		shortcuts[]={3};
		shortcutsAction="CommandingMenu2";
		command="CMD_FIRE_AT_POSITION_AMMO";
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
		cursorTexture="#(argb,8,8,3)color(0,0,0,0)";
		class Params
		{
			artilleryBurst=2;
		};
	};
	class Item3
	{
		title="Burst 3";
		shortcuts[]={4};
		shortcutsAction="CommandingMenu3";
		command="CMD_FIRE_AT_POSITION_AMMO";
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
		cursorTexture="#(argb,8,8,3)color(0,0,0,0)";
		class Params
		{
			artilleryBurst=3;
		};
	};
	class Item4
	{
		title="Burst 4";
		shortcuts[]={5};
		shortcutsAction="CommandingMenu4";
		command="CMD_FIRE_AT_POSITION_AMMO";
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
		cursorTexture="#(argb,8,8,3)color(0,0,0,0)";
		class Params
		{
			artilleryBurst=4;
		};
	};
};
class RscTeam: RscSubmenu
{
	title="$STR_ASSIGN";
	vocabulary="";
	items[]=
	{
		"AssignRed",
		"AssignGreen",
		"AssignBlue",
		"AssignYellow",
		"AssignMain",
		"Separator",
		"SelectTeam",
		"Back"
	};
	class AssignRed
	{
		title="$STR_ASSIGN_RED";
		shortcuts[]={2};
		shortcutsAction="CommandingMenu1";
		command="CMD_ASSIGN_RED";
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class AssignGreen
	{
		title="$STR_ASSIGN_GREEN";
		shortcuts[]={3};
		shortcutsAction="CommandingMenu2";
		command="CMD_ASSIGN_GREEN";
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class AssignBlue
	{
		title="$STR_ASSIGN_BLUE";
		shortcuts[]={4};
		shortcutsAction="CommandingMenu3";
		command="CMD_ASSIGN_BLUE";
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class AssignYellow
	{
		title="$STR_ASSIGN_YELLOW";
		shortcuts[]={5};
		shortcutsAction="CommandingMenu4";
		command="CMD_ASSIGN_YELLOW";
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class AssignMain
	{
		title="$STR_ASSIGN_MAIN";
		shortcuts[]={6};
		shortcutsAction="CommandingMenu5";
		command="CMD_ASSIGN_MAIN";
		show="IsLeader";
		enable="NotEmpty";
		speechId=0;
	};
	class SelectTeam
	{
		title="$STR_TEAM";
		shortcuts[]={10};
		shortcutsAction="CommandingMenu9";
		menu="RscSelectTeam";
		show="IsLeader";
	};
};
class RscSelectTeam: RscSubmenu
{
	title="$STR_TEAM";
	vocabulary="";
	items[]=
	{
		"TeamRed",
		"TeamGreen",
		"TeamBlue",
		"TeamYellow",
		"TeamMain",
		"Back"
	};
	class TeamRed
	{
		title="$STR_TEAM_RED";
		shortcuts[]={2};
		shortcutsAction="CommandingMenu1";
		command="CMD_TEAM_RED";
		show="IsLeader";
		enable="NotEmptyRedTeam";
	};
	class TeamGreen
	{
		title="$STR_TEAM_GREEN";
		shortcuts[]={3};
		shortcutsAction="CommandingMenu2";
		command="CMD_TEAM_GREEN";
		show="IsLeader";
		enable="NotEmptyGreenTeam";
	};
	class TeamBlue
	{
		title="$STR_TEAM_BLUE";
		shortcuts[]={4};
		shortcutsAction="CommandingMenu3";
		command="CMD_TEAM_BLUE";
		show="IsLeader";
		enable="NotEmptyBlueTeam";
	};
	class TeamYellow
	{
		title="$STR_TEAM_YELLOW";
		shortcuts[]={5};
		shortcutsAction="CommandingMenu4";
		command="CMD_TEAM_YELLOW";
		show="IsLeader";
		enable="NotEmptyYellowTeam";
	};
	class TeamMain
	{
		title="$STR_TEAM_MAIN";
		shortcuts[]={6};
		shortcutsAction="CommandingMenu5";
		command="CMD_TEAM_MAIN";
		show="IsLeader";
		enable="NotEmptyMainTeam";
	};
};
class RscRadio: RscSubmenu
{
	title="$STR_RADIO";
	vocabulary="";
	items[]=
	{
		"Alpha",
		"Bravo",
		"Charlie",
		"Delta",
		"Echo",
		"Foxtrot",
		"Golf",
		"Hotel",
		"India",
		"Juliet",
		"Back"
	};
	class Alpha
	{
		title="$STR_RADIO_ALPHA";
		shortcuts[]={2};
		shortcutsAction="CommandingMenu1";
		command="CMD_RADIO_ALPHA";
		speechId=0;
	};
	class Bravo
	{
		title="$STR_RADIO_BRAVO";
		shortcuts[]={3};
		shortcutsAction="CommandingMenu2";
		command="CMD_RADIO_BRAVO";
		speechId=0;
	};
	class Charlie
	{
		title="$STR_RADIO_CHARLIE";
		shortcuts[]={4};
		shortcutsAction="CommandingMenu3";
		command="CMD_RADIO_CHARLIE";
		speechId=0;
	};
	class Delta
	{
		title="$STR_RADIO_DELTA";
		shortcuts[]={5};
		shortcutsAction="CommandingMenu4";
		command="CMD_RADIO_DELTA";
		speechId=0;
	};
	class Echo
	{
		title="$STR_RADIO_ECHO";
		shortcuts[]={6};
		shortcutsAction="CommandingMenu5";
		command="CMD_RADIO_ECHO";
		speechId=0;
	};
	class Foxtrot
	{
		title="$STR_RADIO_FOXTROT";
		shortcuts[]={7};
		shortcutsAction="CommandingMenu6";
		command="CMD_RADIO_FOXTROT";
		speechId=0;
	};
	class Golf
	{
		title="$STR_RADIO_GOLF";
		shortcuts[]={8};
		shortcutsAction="CommandingMenu7";
		command="CMD_RADIO_GOLF";
		speechId=0;
	};
	class Hotel
	{
		title="$STR_RADIO_HOTEL";
		shortcuts[]={9};
		shortcutsAction="CommandingMenu8";
		command="CMD_RADIO_HOTEL";
		speechId=0;
	};
	class India
	{
		title="$STR_RADIO_INDIA";
		shortcuts[]={10};
		shortcutsAction="CommandingMenu9";
		command="CMD_RADIO_INDIA";
		speechId=0;
	};
	class Juliet
	{
		title="$STR_RADIO_JULIET";
		shortcuts[]={11};
		shortcutsAction="CommandingMenu0";
		command="CMD_RADIO_JULIET";
		speechId=0;
	};
};
class RscMenuBasicLevel
{
	access=0;
	title="$STR_COMMAND";
	atomic=0;
	vocabulary="";
	items[]={};
};
class RscHCGroupRootMenu
{
	access=0;
	contexsensitive=1;
	title="";
	atomic=0;
	vocabulary="";
	class Items
	{
		class Empty1
		{
			title="$STR_rscmenu.hpprscgrouprootmenu_items_empty1";
			shortcuts[]={0};
			command="";
			show="HCIsLeader * (1 - HCCursorOnIconEnemy)";
			enable="0";
			speechId=0;
		};
		class EmptyBlank1: Empty1
		{
			title="";
			show="(1 - HCIsLeader)";
			enable="0";
		};
		class Attack
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Attack0";
			shortcuts[]={0};
			command=-5;
			class Params
			{
			};
			show="HCIsLeader * HCCursorOnIconEnemy";
			enable="HCNotEmpty";
			speechId=0;
			cursorTexture="#(argb,8,8,3)color(0,0,0,0)";
			priority=2;
		};
		class EmptyBlank2: Empty1
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Move0";
			show="(1 - HCIsLeader) + (HCIsLeader * (1 - CursorOnGround)) + (HCCursorOnIconSelectable)";
			enable="0";
		};
		class Move
		{
			title="$STR_hc_menu_wpset";
			shortcuts[]={0};
			command=-5;
			class Params
			{
			};
			show="HCIsLeader * CursorOnGround * (1 - IsWatchCommanded) * (1 - HCCursorOnIconSelectable) * (1 - IsSelectedToAdd)";
			enable="HCNotEmpty";
			speechId=0;
			cursorTexture="#(argb,8,8,3)color(0,0,0,0)";
			priority=1;
		};
		class MoveAdd
		{
			title="$STR_hc_menu_wpadd";
			shortcuts[]={0};
			command=-5;
			class Params
			{
			};
			show="HCIsLeader * CursorOnGround * (1 - IsWatchCommanded) * (1 - HCCursorOnIconSelectable) * IsSelectedToAdd";
			enable="HCNotEmpty";
			speechId=0;
			cursorTexture="#(argb,8,8,3)color(0,0,0,0)";
			priority=2;
		};
		class Watch
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Watch0";
			shortcuts[]={0};
			command="CMD_WATCH_CTX";
			show="HCIsLeader * CursorOnGround * IsWatchCommanded";
			enable="HCNotEmpty";
			speechId=0;
			cursorTexture="#(argb,8,8,3)color(0,0,0,0)";
			priority=2;
		};
		class Empty3: Empty1
		{
			title="$STR_hc_menu_moveempty";
			show="(HCIsLeader)";
		};
		class Empty4: Empty1
		{
			title="$STR_hc_menu_fireempty";
			show="(HCIsLeader)";
		};
		class Separator
		{
			title="";
			shortcuts[]={0};
			command=-1;
		};
		class Empty5: Empty1
		{
			title="$STR_hc_menu_empty5";
			show="(HCIsLeader)";
		};
		class Empty6: Empty1
		{
			title="$STR_hc_menu_empty6";
			show="(HCIsLeader)";
		};
		class Empty7: Empty1
		{
			title="$STR_hc_menu_empty7";
			show="HCIsLeader * (1 - HCCursorOnIconSelectable) * (1 - HCCursorOnIconSelectableSelected)";
		};
		class EmptyBlank7: Empty1
		{
			title="";
			show="(1 - HCIsLeader)";
		};
		class Select
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Selectset0";
			shortcuts[]={0};
			command="CMD_HC_SELECT_AUTO";
			show="HCIsLeader * HCCursorOnIconSelectable * (1 - IsSelectedToAdd)";
			enable="1";
			speechId=0;
			cursorTexture="#(argb,8,8,3)color(0,0,0,0)";
			priority=2;
		};
		class SelectAdd
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Select0";
			shortcuts[]={0};
			command="CMD_HC_SELECT_AUTO_ADD";
			show="HCIsLeader * HCCursorOnIconSelectable * (1 - HCCursorOnIconSelectableSelected) * IsSelectedToAdd";
			enable="1";
			speechId=0;
			cursorTexture="#(argb,8,8,3)color(0,0,0,0)";
			priority=2;
		};
		class Deselect
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Deselect0";
			shortcuts[]={0};
			command="CMD_HC_DESELECT_AUTO";
			show="HCIsLeader * HCCursorOnIconSelectable * (HCCursorOnIconSelectableSelected) * IsSelectedToAdd";
			enable="1";
			speechId=0;
			cursorTexture="#(argb,8,8,3)color(0,0,0,0)";
			priority=2;
		};
		class Empty8: Empty1
		{
			title="";
			command=-1;
			show="1 - (HCIsLeader) * (1 - (HCIsLeader * (1 - HCCanSelectUnitFromBar) * (1 - HCCanDeselectUnitFromBar) * (1 - HCCanSelectTeamFromBar) * (1 - HCCanDeselectTeamFromBar)))";
		};
		class SelectUnitFromBar
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_SelectUnitFromBar0";
			shortcuts[]=
			{
				0,
				"0x00050000 + 3"
			};
			command="CMD_SELECT_UNIT_FROM_BAR";
			show="IsXbox * HCCanSelectUnitFromBar";
			enable="HCNotEmpty";
			speechId=0;
			priority=3;
		};
		class DeselectUnitFromBar
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_DeselectUnitFromBar0";
			shortcuts[]=
			{
				0,
				"0x00050000 + 3"
			};
			command="CMD_DESELECT_UNIT_FROM_BAR";
			show="IsXbox * HCCanDeselectUnitFromBar";
			enable="HCNotEmpty";
			speechId=0;
			priority=3;
		};
		class SelectTeamFromBar
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_SelectTeamFromBar0";
			shortcuts[]=
			{
				0,
				"0x00050000 + 3"
			};
			command="CMD_SELECT_TEAM_FROM_BAR";
			show="IsXbox * HCCanSelectTeamFromBar";
			enable="HCNotEmpty";
			speechId=0;
			priority=3;
		};
		class DeselectTeamFromBar
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_DeselectTeamFromBar0";
			shortcuts[]=
			{
				0,
				"0x00050000 + 3"
			};
			command="CMD_DESELECT_TEAM_FROM_BAR";
			show="IsXbox * HCCanDeselectTeamFromBar";
			enable="HCNotEmpty";
			speechId=0;
			priority=3;
		};
		class Empty9: Empty1
		{
			title="";
			show="1";
		};
		class Empty10: Empty1
		{
			title="";
			show="1";
		};
		class Reply
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Communication0";
			shortcuts[]={0};
			menu="#User:BIS_MENU_GroupCommunication";
			show="1";
			enable="1";
			speechId=0;
		};
	};
};
class RscHCMainMenu
{
	access=0;
	title="$STR_hc_hc";
	atomic=0;
	vocabulary="";
	class Items
	{
		class Move
		{
			title="$STR_MOVE";
			shortcuts[]={2};
			shortcutsAction="CommandingMenu1";
			menu="RscHCMoveHigh";
			show="";
			enable="HCNotEmpty";
			speechId=0;
		};
		class Target
		{
			title="$STR_WATCH_TARGET";
			shortcuts[]={3};
			shortcutsAction="CommandingMenu2";
			menu="#USER:HC_Targets_0";
			show="";
			enable="HCNotEmpty";
			speechId=0;
		};
		class Engage
		{
			title="$STR_WATCH";
			shortcuts[]={4};
			shortcutsAction="CommandingMenu3";
			menu="RscHCWatchDir";
			show="";
			enable="HCNotEmpty";
			speechId=0;
		};
		class Speed
		{
			title="$STR_HC_MENU_SPEED";
			shortcuts[]={5};
			shortcutsAction="CommandingMenu4";
			menu="RscHCSpeedMode";
			show="";
			enable="HCNotEmpty";
			speechId=0;
		};
		class Mission
		{
			title="$STR_HC_MENU_MISSION";
			shortcuts[]={6};
			shortcutsAction="CommandingMenu5";
			menu="#USER:HC_Missions_0";
			show="";
			enable="HCNotEmpty";
			speechId=0;
		};
		class Action
		{
			title="$STR_ACTION";
			shortcuts[]={7};
			shortcutsAction="CommandingMenu6";
			menu="#USER:HC_Custom_0";
			show="";
			enable="HCNotEmpty";
			speechId=0;
		};
		class CombatMode
		{
			title="$STR_COMBAT_MODE";
			shortcuts[]={8};
			shortcutsAction="CommandingMenu7";
			menu="RscHCCombatMode";
			show="";
			enable="HCNotEmpty";
			speechId=0;
		};
		class Formations
		{
			title="$STR_FORMATION";
			shortcuts[]={9};
			shortcutsAction="CommandingMenu8";
			menu="RscHCFormations";
			show="";
			enable="HCNotEmpty";
			speechId=0;
		};
		class Team
		{
			title="$STR_TEAM";
			shortcuts[]={10};
			shortcutsAction="CommandingMenu9";
			menu="RscHCTeam";
			show="";
			enable="HCNotEmpty";
			speechId=0;
		};
		class Reply
		{
			title="$STR_REPLY";
			shortcuts[]={11};
			shortcutsAction="CommandingMenu0";
			menu="RscHCReply";
			speechId=0;
		};
		class Back
		{
			title="";
			shortcuts[]=
			{
				"BACK"
			};
			command=-4;
			speechId=0;
		};
	};
};
class RscHCMoveHigh
{
	title="$STR_MOVE";
	access=0;
	atomic=0;
	vocabulary="";
	class Items
	{
		class NextWP
		{
			title="$STR_HC_MENU_NEXTWP";
			shortcuts[]={2};
			shortcutsAction="CommandingMenu1";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
			speechId=0;
		};
		class CancelWP
		{
			title="$STR_HC_MENU_CANCELLASTWP";
			shortcuts[]={3};
			shortcutsAction="CommandingMenu2";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
			speechId=0;
		};
		class CancelAllWPs
		{
			title="$STR_HC_MENU_CANCELALLWP";
			shortcuts[]={4};
			shortcutsAction="CommandingMenu3";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
			speechId=0;
		};
		class Back
		{
			title="";
			shortcuts[]=
			{
				"BACK"
			};
			command=-4;
			speechId=0;
		};
	};
};
class RscHCWatchDir
{
	title="$STR_WATCH";
	access=0;
	atomic=0;
	vocabulary="";
	class items
	{
		class OpenFire
		{
			title="$STR_OPEN_FIRE";
			shortcuts[]={2};
			shortcutsAction="CommandingMenu1";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
		class HoldFire
		{
			title="$STR_HOLD_FIRE";
			shortcuts[]={3};
			shortcutsAction="CommandingMenu2";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
	};
};
class RscHCCombatMode
{
	title="$STR_COMBAT_MODE";
	access=0;
	atomic=0;
	vocabulary="";
	class items
	{
		class Stealth
		{
			title="$STR_STEALTH";
			shortcuts[]={2};
			shortcutsAction="CommandingMenu1";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
		class Combat
		{
			title="$STR_COMBAT";
			shortcuts[]={3};
			shortcutsAction="CommandingMenu2";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
		class Aware
		{
			title="$STR_AWARE";
			shortcuts[]={4};
			shortcutsAction="CommandingMenu3";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
		class Safe
		{
			title="$STR_SAFE";
			shortcuts[]={5};
			shortcutsAction="CommandingMenu4";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
	};
};
class RscHCSpeedMode
{
	title="$STR_hc_menu_speed";
	access=0;
	atomic=0;
	vocabulary="";
	class items
	{
		class Limited
		{
			title="$STR_SPEED_LIMITED";
			shortcuts[]={3};
			shortcutsAction="CommandingMenu2";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
		class Normal
		{
			title="$STR_SPEED_NORMAL";
			shortcuts[]={4};
			shortcutsAction="CommandingMenu3";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
		class Full
		{
			title="$STR_SPEED_FULL";
			shortcuts[]={5};
			shortcutsAction="CommandingMenu4";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
	};
};
class RscHCFormations
{
	title="$STR_FORMATION";
	access=0;
	atomic=0;
	vocabulary="";
	class items
	{
		class Column
		{
			title="$STR_COLUMN";
			shortcuts[]={2};
			shortcutsAction="CommandingMenu1";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
		class ColumnStag
		{
			title="$STR_STAGGERED";
			shortcuts[]={3};
			shortcutsAction="CommandingMenu2";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
		class Wedge
		{
			title="$STR_WEDGE";
			shortcuts[]={4};
			shortcutsAction="CommandingMenu3";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
		class EchelonL
		{
			title="$STR_ECHL";
			shortcuts[]={5};
			shortcutsAction="CommandingMenu4";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
		class EchelonR
		{
			title="$STR_ECHR";
			shortcuts[]={6};
			shortcutsAction="CommandingMenu5";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
		class Vee
		{
			title="$STR_VEE";
			shortcuts[]={7};
			shortcutsAction="CommandingMenu6";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
		class Line
		{
			title="$STR_LINE";
			shortcuts[]={8};
			shortcutsAction="CommandingMenu7";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
		class ColumnCompact
		{
			title="$STR_FILE";
			shortcuts[]={9};
			shortcutsAction="CommandingMenu8";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
		class Delta
		{
			title="$STR_DIAMOND";
			shortcuts[]={10};
			shortcutsAction="CommandingMenu9";
			command=-5;
			class Params
			{
			};
			show="";
			enable="HCNotEmpty";
		};
	};
};
class RscHCTeam
{
	title="$STR_ASSIGN";
	vocabulary="";
	class items
	{
		class AssignRed
		{
			title="$STR_ASSIGN_RED";
			shortcuts[]={2};
			shortcutsAction="CommandingMenu1";
			command="CMD_ASSIGN_RED";
			show="IsLeader";
			enable="NotEmpty";
			speechId=0;
		};
		class AssignGreen
		{
			title="$STR_ASSIGN_GREEN";
			shortcuts[]={3};
			shortcutsAction="CommandingMenu2";
			command="CMD_ASSIGN_GREEN";
			show="IsLeader";
			enable="NotEmpty";
			speechId=0;
		};
		class AssignBlue
		{
			title="$STR_ASSIGN_BLUE";
			shortcuts[]={4};
			shortcutsAction="CommandingMenu3";
			command="CMD_ASSIGN_BLUE";
			show="IsLeader";
			enable="NotEmpty";
			speechId=0;
		};
		class AssignYellow
		{
			title="$STR_ASSIGN_YELLOW";
			shortcuts[]={5};
			shortcutsAction="CommandingMenu4";
			command="CMD_ASSIGN_YELLOW";
			show="IsLeader";
			enable="NotEmpty";
			speechId=0;
		};
		class AssignMain
		{
			title="$STR_ASSIGN_MAIN";
			shortcuts[]={6};
			shortcutsAction="CommandingMenu5";
			command="CMD_ASSIGN_MAIN";
			show="IsLeader";
			enable="NotEmpty";
			speechId=0;
		};
		class SelectTeam
		{
			title="$STR_TEAM";
			shortcuts[]={10};
			shortcutsAction="CommandingMenu9";
			menu="RscSelectTeam";
			show="IsLeader";
		};
	};
};
class RscHCSelectTeam
{
	title="$STR_TEAM";
	vocabulary="";
	class items
	{
		class TeamRed
		{
			title="$STR_TEAM_RED";
			shortcuts[]={2};
			shortcutsAction="CommandingMenu1";
			command="CMD_TEAM_RED";
			show="IsLeader";
			enable="NotEmptyRedTeam";
		};
		class TeamGreen
		{
			title="$STR_TEAM_GREEN";
			shortcuts[]={3};
			shortcutsAction="CommandingMenu2";
			command="CMD_TEAM_GREEN";
			show="IsLeader";
			enable="NotEmptyGreenTeam";
		};
		class TeamBlue
		{
			title="$STR_TEAM_BLUE";
			shortcuts[]={4};
			shortcutsAction="CommandingMenu3";
			command="CMD_TEAM_BLUE";
			show="IsLeader";
			enable="NotEmptyBlueTeam";
		};
		class TeamYellow
		{
			title="$STR_TEAM_YELLOW";
			shortcuts[]={5};
			shortcutsAction="CommandingMenu4";
			command="CMD_TEAM_YELLOW";
			show="IsLeader";
			enable="NotEmptyYellowTeam";
		};
		class TeamMain
		{
			title="$STR_TEAM_MAIN";
			shortcuts[]={6};
			shortcutsAction="CommandingMenu5";
			command="CMD_TEAM_MAIN";
			show="IsLeader";
			enable="NotEmptyMainTeam";
		};
	};
};
class RscHCReply
{
	title="$STR_REPLY";
	access=0;
	atomic=0;
	vocabulary="";
	class items
	{
		class SITREP
		{
			title="$STR_HC_MENU_SITREP";
			shortcuts[]={2};
			shortcutsAction="CommandingMenu1";
			show="HCIsLeader";
			enable="HCNotEmpty";
			speechId=0;
			command=-5;
			class Params
			{
			};
		};
		class Communication
		{
			title="$STR_rscMenu.hppRscGroupRootMenu_Items_Communication0";
			shortcuts[]={9};
			shortcutsAction="CommandingMenu8";
			menu="#User:BIS_MENU_GroupCommunication";
		};
		class UserRadio
		{
			title="$STR_RADIO_CUSTOM";
			shortcuts[]={10};
			shortcutsAction="CommandingMenu9";
			menu="#CUSTOM_RADIO";
		};
		class Radio
		{
			title="$STR_RADIO";
			shortcuts[]={11};
			shortcutsAction="CommandingMenu0";
			menu="RscRadio";
			enable="HasRadio";
		};
	};
};
class RscHCUAV
{
	title="$STR_A3_RscHCUAV0";
	access=0;
	atomic=0;
	vocabulary="";
	class Items
	{
		class UAVDriver
		{
			title="$STR_A3_RscHCUAV_Items_UAVDriver0";
			shortcuts[]={2};
			shortcutsAction="CommandingMenu1";
			command=-5;
			class Params
			{
				expression="switchToUAV [hcselected player, 'DRIVER']";
			};
			show="";
			enable="HCNotEmpty * UAVHasDriver";
			speechId=0;
		};
		class UAVGunner
		{
			title="$STR_A3_RscHCUAV_Items_UAVGunner0";
			shortcuts[]={3};
			shortcutsAction="CommandingMenu2";
			command=-5;
			class Params
			{
				expression="switchToUAV [hcselected player, 'GUNNER']";
			};
			show="";
			enable="HCNotEmpty * UAVHasGunner";
			speechId=0;
		};
		class UAVWatch
		{
			title="$STR_A3_RscHCUAV_Items_UAVWatch0";
			shortcuts[]={4};
			shortcutsAction="CommandingMenu3";
			command=-5;
			class Params
			{
				expression="switchToUAV [hcselected player, 'WATCH']";
			};
			show="";
			enable="HCNotEmpty * UAVHasDriver";
			speechId=0;
		};
		class Back
		{
			title="";
			shortcuts[]=
			{
				"BACK"
			};
			command=-4;
			speechId=0;
		};
	};
};
class RscHCWPRootMenu
{
	access=0;
	title="";
	atomic=0;
	vocabulary="";
	class Items
	{
		class Type
		{
			title="$STR_DISP_ARCSENS_TYPE";
			shortcuts[]={2};
			shortcutsAction="CommandingMenu1";
			menu="RscHCWPType";
			show="";
			enable="";
			speechId=0;
		};
		class CombatMode
		{
			title="$STR_COMBAT_MODE";
			shortcuts[]={3};
			shortcutsAction="CommandingMenu2";
			menu="RscHCWPCombatMode";
			show="";
			enable="";
			speechId=0;
		};
		class Formations
		{
			title="$STR_FORMATION";
			shortcuts[]={4};
			shortcutsAction="CommandingMenu3";
			menu="RscHCWPFormations";
			show="";
			enable="";
			speechId=0;
		};
		class Speed
		{
			title="$STR_HC_MENU_SPEED";
			shortcuts[]={5};
			shortcutsAction="CommandingMenu4";
			menu="RscHCWPSpeedMode";
			show="";
			enable="";
			speechId=0;
		};
		class Wait
		{
			title="$STR_DISP_ARCWP_TIMEOUT";
			shortcuts[]={6};
			shortcutsAction="CommandingMenu5";
			menu="RscHCWPWait";
			show="";
			enable="";
			speechId=0;
		};
		class WaitUntil
		{
			title="$STR_HC_MENU_WAITUNTIL";
			shortcuts[]={7};
			shortcutsAction="CommandingMenu6";
			menu="#USER:HCWPWaitUntil";
			show="";
			enable="";
			speechId=0;
		};
		class WaitRadio
		{
			title="$STR_RADIO";
			shortcuts[]={8};
			shortcutsAction="CommandingMenu7";
			menu="#USER:HCWPWaitRadio";
			show="";
			enable="";
			speechId=0;
		};
		class Separator1
		{
			title="";
			shortcuts[]={0};
			command=-1;
		};
		class CreateTask
		{
			title="$STR_HC_MENU_CREATETASK";
			shortcuts[]={9};
			shortcutsAction="CommandingMenu8";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
			speechId=0;
		};
		class Separator2
		{
			title="";
			shortcuts[]={0};
			command=-1;
		};
		class CancelWP
		{
			title="$STR_HC_MENU_CANCELWP";
			shortcuts[]={10};
			shortcutsAction="CommandingMenu9";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
			speechId=0;
		};
		class Back
		{
			title="";
			shortcuts[]={14};
			shortcutsAction="NavigateMenu";
			command=-4;
			speechId=0;
		};
	};
};
class RscHCWPType
{
	title="$STR_DISP_ARCSENS_TYPE";
	access=0;
	atomic=0;
	vocabulary="";
	class items
	{
		class Move
		{
			title="$STR_AC_MOVE";
			shortcuts[]={2};
			shortcutsAction="CommandingMenu1";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Cycle
		{
			title="$STR_AC_CYCLE";
			shortcuts[]={3};
			shortcutsAction="CommandingMenu2";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class SAD
		{
			title="$STR_AC_SEEKANDDESTROY";
			shortcuts[]={4};
			shortcutsAction="CommandingMenu3";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Guard
		{
			title="$STR_AC_GUARD";
			shortcuts[]={5};
			shortcutsAction="CommandingMenu4";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Separator1
		{
			title="";
			shortcuts[]={0};
			command=-1;
		};
		class Unload
		{
			title="$STR_AC_UNLOAD";
			shortcuts[]={6};
			shortcutsAction="CommandingMenu5";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Load
		{
			title="$STR_AC_LOAD";
			shortcuts[]={7};
			shortcutsAction="CommandingMenu6";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Separator2
		{
			title="";
			shortcuts[]={0};
			command=-1;
		};
		class GetOut
		{
			title="$STR_AC_GETOUT";
			shortcuts[]={8};
			shortcutsAction="CommandingMenu7";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class GetIn
		{
			title="$STR_AC_GETIN";
			shortcuts[]={9};
			shortcutsAction="CommandingMenu8";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
	};
};
class RscHCWPCombatMode
{
	title="$STR_COMBAT_MODE";
	access=0;
	atomic=0;
	vocabulary="";
	class items
	{
		class Stealth
		{
			title="$STR_STEALTH";
			shortcuts[]={2};
			shortcutsAction="CommandingMenu1";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Combat
		{
			title="$STR_COMBAT";
			shortcuts[]={3};
			shortcutsAction="CommandingMenu2";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Aware
		{
			title="$STR_AWARE";
			shortcuts[]={4};
			shortcutsAction="CommandingMenu3";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Safe
		{
			title="$STR_SAFE";
			shortcuts[]={5};
			shortcutsAction="CommandingMenu4";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Unchanged
		{
			title="$STR_COMBAT_UNCHANGED";
			shortcuts[]={11};
			shortcutsAction="CommandingMenu0";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
	};
};
class RscHCWPFormations
{
	title="$STR_FORMATION";
	access=0;
	atomic=0;
	vocabulary="";
	class items
	{
		class Column
		{
			title="$STR_COLUMN";
			shortcuts[]={2};
			shortcutsAction="CommandingMenu1";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class ColumnStag
		{
			title="$STR_STAGGERED";
			shortcuts[]={3};
			shortcutsAction="CommandingMenu2";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Wedge
		{
			title="$STR_WEDGE";
			shortcuts[]={4};
			shortcutsAction="CommandingMenu3";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class EchelonL
		{
			title="$STR_ECHL";
			shortcuts[]={5};
			shortcutsAction="CommandingMenu4";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class EchelonR
		{
			title="$STR_ECHR";
			shortcuts[]={6};
			shortcutsAction="CommandingMenu5";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Vee
		{
			title="$STR_VEE";
			shortcuts[]={7};
			shortcutsAction="CommandingMenu6";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Line
		{
			title="$STR_LINE";
			shortcuts[]={8};
			shortcutsAction="CommandingMenu7";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class ColumnCompact
		{
			title="$STR_FILE";
			shortcuts[]={9};
			shortcutsAction="CommandingMenu8";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Delta
		{
			title="$STR_DIAMOND";
			shortcuts[]={10};
			shortcutsAction="CommandingMenu9";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Unchanged
		{
			title="$STR_COMBAT_UNCHANGED";
			shortcuts[]={11};
			shortcutsAction="CommandingMenu0";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
	};
};
class RscHCWPSpeedMode
{
	title="$STR_hc_menu_speed";
	access=0;
	atomic=0;
	vocabulary="";
	class items
	{
		class Limited
		{
			title="$STR_SPEED_LIMITED";
			shortcuts[]={2};
			shortcutsAction="CommandingMenu1";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Normal
		{
			title="$STR_SPEED_NORMAL";
			shortcuts[]={3};
			shortcutsAction="CommandingMenu2";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Full
		{
			title="$STR_SPEED_FULL";
			shortcuts[]={4};
			shortcutsAction="CommandingMenu3";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class Unchanged
		{
			title="$STR_SPEED_UNCHANGED";
			shortcuts[]={11};
			shortcutsAction="CommandingMenu0";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
	};
};
class RscHCWPWait
{
	title="$STR_DISP_ARCWP_TIMEOUT";
	access=0;
	atomic=0;
	vocabulary="";
	class items
	{
		class NoWait
		{
			title="$STR_HC_MENU_NOWAIT";
			shortcuts[]={2};
			shortcutsAction="CommandingMenu1";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class 1min
		{
			title="$STR_hc_menu_wpwait1";
			shortcuts[]={3};
			shortcutsAction="CommandingMenu2";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class 5min
		{
			title="$STR_hc_menu_wpwait5";
			shortcuts[]={4};
			shortcutsAction="CommandingMenu3";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class 10min
		{
			title="$STR_hc_menu_wpwait10";
			shortcuts[]={5};
			shortcutsAction="CommandingMenu4";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class 15min
		{
			title="$STR_hc_menu_wpwait15";
			shortcuts[]={6};
			shortcutsAction="CommandingMenu5";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class 20min
		{
			title="$STR_hc_menu_wpwait20";
			shortcuts[]={7};
			shortcutsAction="CommandingMenu6";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class 25min
		{
			title="$STR_hc_menu_wpwait25";
			shortcuts[]={8};
			shortcutsAction="CommandingMenu7";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class 30min
		{
			title="$STR_hc_menu_wpwait30";
			shortcuts[]={9};
			shortcutsAction="CommandingMenu8";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class 45min
		{
			title="$STR_hc_menu_wpwait45";
			shortcuts[]={10};
			shortcutsAction="CommandingMenu9";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
		class 60min
		{
			title="$STR_hc_menu_wpwait60";
			shortcuts[]={11};
			shortcutsAction="CommandingMenu0";
			command=-5;
			class Params
			{
			};
			show="";
			enable="";
		};
	};
};
class RadioChannels
{
	class GlobalChannel
	{
		level=1;
		noise="loop";
		micOuts="micOuts";
		pauseAfterWord=0;
		pauseInNumber=0;
		pauseAfterNumber=0;
		pauseInUnitList=0;
		pauseAfterUnitList=0.050000001;
	};
	class SideChannel
	{
		level=2;
		noise="loop";
		micOuts="micOuts";
		pauseAfterWord=0;
		pauseInNumber=0;
		pauseAfterNumber=0;
		pauseInUnitList=0;
		pauseAfterUnitList=0.050000001;
	};
	class CommandChannel
	{
		level=3;
		noise="loop";
		micOuts="micOuts";
		pauseAfterWord=0;
		pauseInNumber=0;
		pauseAfterNumber=0;
		pauseInUnitList=0;
		pauseAfterUnitList=0.050000001;
	};
	class GroupChannel
	{
		level=4;
		noise="loop";
		micOuts="micOuts";
		pauseAfterWord=0;
		pauseInNumber=0;
		pauseAfterNumber=0;
		pauseInUnitList=0;
		pauseAfterUnitList=0.050000001;
	};
	class VehicleChannel
	{
		level=5;
		noise="";
		micOuts="";
		pauseAfterWord=0;
		pauseInNumber=0;
		pauseAfterNumber=0;
		pauseInUnitList=0;
		pauseAfterUnitList=0.050000001;
	};
	class DirectSpeakingChannel
	{
		level=0;
		noise="";
		micOuts="";
		pauseAfterWord=0;
		pauseInNumber=0;
		pauseAfterNumber=0;
		pauseInUnitList=0;
		pauseAfterUnitList=0.050000001;
		sound3D=1;
	};
};
class RadioProtocolBase
{
	access=0;
	class Words
	{
		loop[]={};
		pause[]={};
		xmit[]={};
		zero[]={};
		one[]={};
		two[]={};
		three[]={};
		four[]={};
		five[]={};
		six[]={};
		seven[]={};
		eight[]={};
		nine[]={};
		ten[]={};
		eleven[]={};
		twelve[]={};
		thirteen[]={};
		fourteen[]={};
		fifteen[]={};
		sixteen[]={};
		seventeen[]={};
		eighteen[]={};
		nineteen[]={};
		twenty[]={};
		thirty[]={};
		forty[]={};
		fifty[]={};
		sixty[]={};
		seventy[]={};
		eighty[]={};
		ninety[]={};
		hundred[]={};
		zero2[]={};
		one2[]={};
		two2[]={};
		three2[]={};
		four2[]={};
		five2[]={};
		six2[]={};
		seven2[]={};
		eight2[]={};
		nine2[]={};
		ten2[]={};
		eleven2[]={};
		twelve2[]={};
		alpha[]={};
		bravo[]={};
		charlie[]={};
		delta[]={};
		echo[]={};
		foxtrot[]={};
		golf[]={};
		hotel[]={};
		india[]={};
		juliet[]={};
		kilo[]={};
		lima[]={};
		mike[]={};
		november[]={};
		oscar[]={};
		papa[]={};
		quebec[]={};
		romeo[]={};
		sierra[]={};
		tango[]={};
		uniform[]={};
		victor[]={};
		whiskey[]={};
		xray[]={};
		yankee[]={};
		zulu[]={};
		all[]={};
		allGroup[]={};
		whiteTeam[]={};
		redTeam[]={};
		greenTeam[]={};
		blueTeam[]={};
		yellowTeam[]={};
		unknown[]={};
		enemy[]={};
		friendly[]={};
		neutral[]={};
		north[]={};
		northEast[]={};
		east[]={};
		southEast[]={};
		south[]={};
		southWest[]={};
		west[]={};
		northWest[]={};
		at10[]={};
		at11[]={};
		at12[]={};
		at1[]={};
		at2[]={};
		at3[]={};
		at4[]={};
		at5[]={};
		at6[]={};
		at7[]={};
		at8[]={};
		at9[]={};
		dist50[]={};
		dist100[]={};
		dist200[]={};
		dist500[]={};
		dist1000[]={};
		dist2000[]={};
		far[]={};
		inFrontOf[]={};
		rightOf[]={};
		behind[]={};
		leftOf[]={};
		dangerCloseTo[]={};
		notFarFrom[]={};
		farFrom[]={};
		front[]={};
		right[]={};
		rear[]={};
		left[]={};
		rightFlank[]={};
		leftFlank[]={};
		damnClose[]={};
		notFar[]={};
		closeTo[]={};
		and[]={};
	};
	class Default
	{
		priority=0;
		timeout=1000;
	};
	class Report
	{
		priority=100;
		timeout=30;
	};
	class PriorityReport
	{
		priority=200;
		timeout=60;
	};
	class Confirmation
	{
		priority=300;
		timeout=3;
	};
	class Completition
	{
		priority=400;
		timeout=5;
	};
	class JoinCompleted
	{
		priority=400;
		timeout=30;
	};
	class Failure
	{
		priority=500;
		timeout=30;
	};
	class Notify
	{
		priority=600;
		timeout=5;
	};
	class Detected
	{
		priority=700;
		timeout=5;
	};
	class NormalCommand
	{
		priority=800;
		timeout=1000;
	};
	class CriticalReport
	{
		priority=850;
		timeout=60;
	};
	class UrgentCommand
	{
		priority=900;
		timeout=1000;
	};
	class UICommand
	{
		priority=1000;
		timeout=1000;
	};
	class Design
	{
		priority=950;
		timeout=1000;
	};
	class SentUnitKilled: CriticalReport
	{
		versions[]={};
	};
	class SentSupportAskHeal: NormalCommand
	{
		versions[]={};
	};
	class SentSupportAskRepair: NormalCommand
	{
		versions[]={};
	};
	class SentSupportAskRefuel: NormalCommand
	{
		versions[]={};
	};
	class SentSupportAskRearm: NormalCommand
	{
		versions[]={};
	};
	class SentSupportConfirm: NormalCommand
	{
		versions[]={};
	};
	class SentSupportReady: NormalCommand
	{
		versions[]={};
	};
	class SentSupportDone: NormalCommand
	{
		versions[]={};
	};
	class SentSupportNotAvailable: NormalCommand
	{
		versions[]={};
	};
	class SentHealthCritical: CriticalReport
	{
		versions[]={};
	};
	class SentHealthNormal: CriticalReport
	{
		versions[]={};
	};
	class SentHealthUnconscious: CriticalReport
	{
		versions[]={};
	};
	class SentDammageCritical: CriticalReport
	{
		versions[]={};
	};
	class SentOutOfFirstAidKits: Report
	{
		versions[]={};
	};
	class SentFuelCritical: CriticalReport
	{
		versions[]={};
	};
	class SentFuelLow: Report
	{
		versions[]={};
	};
	class SentAmmoCritical: CriticalReport
	{
		versions[]={};
	};
	class SentAmmoLow: Report
	{
		versions[]={};
	};
	class SentReportPosition: Report
	{
		versions[]={};
	};
	class SentIsLeader: CriticalReport
	{
		versions[]={};
	};
	class SentCommandCompleted: Completition
	{
		versions[]={};
	};
	class SentJoinCompleted: JoinCompleted
	{
		versions[]={};
	};
	class SentFireReady: Completition
	{
		versions[]={};
	};
	class SentDetectedMine: Completition
	{
		versions[]={};
	};
	class SentDetectedBomb: Completition
	{
		versions[]={};
	};
	class SentDetectedExplosive: Completition
	{
		versions[]={};
	};
	class SentFireNegative: Completition
	{
		versions[]={};
	};
	class SentCommandFailed: Failure
	{
		versions[]={};
	};
	class SentDestinationUnreacheable: Failure
	{
		versions[]={};
	};
	class SelectEnemyDetectedSentence
	{
		sentences[]={};
	};
	class SentEnemyDetectedGroupCoreRelative: Detected
	{
		versions[]={};
	};
	class SentEnemyDetectedOnGridReference: Detected
	{
		versions[]={};
	};
	class SentEnemyDetectedLocationRelative: Detected
	{
		versions[]={};
	};
	class SentEnemyDetectedUnitRelative: Detected
	{
		versions[]={};
	};
	class SentEnemyDetectedSenderRelative: Detected
	{
		versions[]={};
	};
	class SentObjectDestroyed: Completition
	{
		versions[]={};
	};
	class SentObjectDestroyedUnknown: Completition
	{
		versions[]={};
	};
	class SentContact: UrgentCommand
	{
		versions[]={};
	};
	class SentUnderFire: UrgentCommand
	{
		versions[]={};
	};
	class SentCoverMe: Confirmation
	{
		versions[]={};
	};
	class SentCovering: Confirmation
	{
		versions[]={};
	};
	class SentSuppressing: Report
	{
		versions[]={};
	};
	class SentReloading: Confirmation
	{
		versions[]={};
	};
	class SentThrowingGrenade: Confirmation
	{
		versions[]={};
	};
	class SentThrowingSmoke: Report
	{
		versions[]={};
	};
	class SentIncomingGrenade: Report
	{
		versions[]={};
	};
	class SentEnemyContact: Report
	{
		versions[]={};
	};
	class SentEndangered: Report
	{
		versions[]={};
	};
	class SentRouted: Report
	{
		versions[]={};
	};
	class SentWitnessDeadBody: Report
	{
		versions[]={};
	};
	class SentWitnessKilled: Report
	{
		versions[]={};
	};
	class SentCombatGeneric: Report
	{
		versions[]={};
	};
	class SentCheering: Report
	{
		versions[]={};
	};
	class SentScreaming: Report
	{
		versions[]={};
	};
	class SentClear: NormalCommand
	{
		versions[]={};
	};
	class SentRepeatCommand: NormalCommand
	{
		versions[]={};
	};
	class SentWhereAreYou: NormalCommand
	{
		versions[]={};
	};
	class SentReturnToFormation: NormalCommand
	{
		versions[]={};
	};
	class SentFormColumn: NormalCommand
	{
		versions[]={};
	};
	class SentFormStaggeredColumn: NormalCommand
	{
		versions[]={};
	};
	class SentFormWedge: NormalCommand
	{
		versions[]={};
	};
	class SentFormEcholonLeft: NormalCommand
	{
		versions[]={};
	};
	class SentFormEcholonRight: NormalCommand
	{
		versions[]={};
	};
	class SentFormVee: NormalCommand
	{
		versions[]={};
	};
	class SentFormLine: NormalCommand
	{
		versions[]={};
	};
	class SentFormFile: NormalCommand
	{
		versions[]={};
	};
	class SentFormDiamond: NormalCommand
	{
		versions[]={};
	};
	class SentBehaviourCareless: NormalCommand
	{
		versions[]={};
	};
	class SentBehaviourSafe: NormalCommand
	{
		versions[]={};
	};
	class SentBehaviourAware: NormalCommand
	{
		versions[]={};
	};
	class SentBehaviourCombat: NormalCommand
	{
		versions[]={};
	};
	class SentBehaviourStealth: NormalCommand
	{
		versions[]={};
	};
	class SentOpenFire: NormalCommand
	{
		versions[]={};
	};
	class SentOpenFireInCombat: NormalCommand
	{
		versions[]={};
	};
	class SentHoldFire: UrgentCommand
	{
		versions[]={};
	};
	class SentHoldFireInCombat: UrgentCommand
	{
		versions[]={};
	};
	class SentCeaseFireInsideGroup: UrgentCommand
	{
		versions[]={};
	};
	class SentCeaseFire: UrgentCommand
	{
		versions[]={};
	};
	class SentLooseFormation: NormalCommand
	{
		versions[]={};
	};
	class SentKeepFormation: NormalCommand
	{
		versions[]={};
	};
	class SentUnitPosDown: NormalCommand
	{
		versions[]={};
	};
	class SentUnitPosMiddle: NormalCommand
	{
		versions[]={};
	};
	class SentUnitPosUp: NormalCommand
	{
		versions[]={};
	};
	class SentUnitPosAuto: NormalCommand
	{
		versions[]={};
	};
	class SentFormPosAdvance: NormalCommand
	{
		versions[]={};
	};
	class SentFormPosStayBack: NormalCommand
	{
		versions[]={};
	};
	class SentFormPosFlankLeft: NormalCommand
	{
		versions[]={};
	};
	class SentFormPosFlankRight: NormalCommand
	{
		versions[]={};
	};
	class SentReportStatus: NormalCommand
	{
		versions[]={};
	};
	class SentTeam: NormalCommand
	{
		versions[]={};
	};
	class SentTeamPlural: NormalCommand
	{
		versions[]={};
	};
	class SentWatchTgt: NormalCommand
	{
		versions[]={};
	};
	class SentWatchDir: NormalCommand
	{
		versions[]={};
	};
	class SentWatchPos: NormalCommand
	{
		versions[]={};
	};
	class SentWatchAround: NormalCommand
	{
		versions[]={};
	};
	class SentNoTarget: NormalCommand
	{
		versions[]={};
	};
	class SentTarget: UrgentCommand
	{
		versions[]={};
	};
	class SentEngage: NormalCommand
	{
		versions[]={};
	};
	class SentFire: NormalCommand
	{
		versions[]={};
	};
	class SentEngageNoTarget: NormalCommand
	{
		versions[]={};
	};
	class SentFireNoTarget: NormalCommand
	{
		versions[]={};
	};
	class SelectCmdMoveSentence
	{
		sentences[]={};
	};
	class SentCmdMoveGroupRelative: NormalCommand
	{
		versions[]={};
	};
	class SentCmdMoveRecipientsRelative: NormalCommand
	{
		versions[]={};
	};
	class SentCmdMoveToGrid: NormalCommand
	{
		versions[]={};
	};
	class SentCmdMoveToTarget: NormalCommand
	{
		versions[]={};
	};
	class SentCmdMoveToObject: NormalCommand
	{
		versions[]={};
	};
	class SentCmdMoveLocationRelative: NormalCommand
	{
		versions[]={};
	};
	class SentCmdHealSomeone: NormalCommand
	{
		versions[]={};
	};
	class SentCmdHealSelf: NormalCommand
	{
		versions[]={};
	};
	class SentAssemble: NormalCommand
	{
		versions[]={};
	};
	class SentDisassemble: NormalCommand
	{
		versions[]={};
	};
	class SentCmdActionTakeBag: NormalCommand
	{
		versions[]={};
	};
	class SentCmdActionDropBag: NormalCommand
	{
		versions[]={};
	};
	class SentCmdActionOpenBag: NormalCommand
	{
		versions[]={};
	};
	class SentLightsOn: NormalCommand
	{
		versions[]={};
	};
	class SentLightsOff: NormalCommand
	{
		versions[]={};
	};
	class SentPointersOn: NormalCommand
	{
		versions[]={};
	};
	class SentPointersOff: NormalCommand
	{
		versions[]={};
	};
	class SentCmdHeal: NormalCommand
	{
		versions[]={};
	};
	class SentCmdHealFar: NormalCommand
	{
		versions[]={};
	};
	class SentCmdHealAt: NormalCommand
	{
		versions[]={};
	};
	class SentCmdRepair: NormalCommand
	{
		versions[]={};
	};
	class SentCmdRepairFar: NormalCommand
	{
		versions[]={};
	};
	class SentCmdRepairAt: NormalCommand
	{
		versions[]={};
	};
	class SentCmdRefuel: NormalCommand
	{
		versions[]={};
	};
	class SentCmdRefuelFar: NormalCommand
	{
		versions[]={};
	};
	class SentCmdRefuelAt: NormalCommand
	{
		versions[]={};
	};
	class SentCmdRearm: NormalCommand
	{
		versions[]={};
	};
	class SentCmdRearmFar: NormalCommand
	{
		versions[]={};
	};
	class SentCmdRearmAt: NormalCommand
	{
		versions[]={};
	};
	class SentCmdSupport: NormalCommand
	{
		versions[]={};
	};
	class SentCmdSupportFar: NormalCommand
	{
		versions[]={};
	};
	class SentCmdSupportAt: NormalCommand
	{
		versions[]={};
	};
	class SentCmdDropWeapon: NormalCommand
	{
		versions[]={};
	};
	class SentCmdDropMagazine: NormalCommand
	{
		versions[]={};
	};
	class SentCmdTakeWeapon: NormalCommand
	{
		versions[]={};
	};
	class SentCmdTakeWeaponFar: NormalCommand
	{
		versions[]={};
	};
	class SentCmdTakeWeaponAt: NormalCommand
	{
		versions[]={};
	};
	class SentCmdTakeMagazine: NormalCommand
	{
		versions[]={};
	};
	class SentCmdTakeMagazineFar: NormalCommand
	{
		versions[]={};
	};
	class SentCmdTakeMagazineAt: NormalCommand
	{
		versions[]={};
	};
	class SentCmdAction: NormalCommand
	{
		versions[]={};
	};
	class SentCmdActionNear: NormalCommand
	{
		versions[]={};
	};
	class SentCmdActionFar: NormalCommand
	{
		versions[]={};
	};
	class SentCmdActionAt: NormalCommand
	{
		versions[]={};
	};
	class SentCmdTakeFlag: NormalCommand
	{
		versions[]={};
	};
	class SentCmdTakeFlagFar: NormalCommand
	{
		versions[]={};
	};
	class SentCmdTakeFlagAt: NormalCommand
	{
		versions[]={};
	};
	class SentCmdReturnFlag: NormalCommand
	{
		versions[]={};
	};
	class SentCmdReturnFlagFar: NormalCommand
	{
		versions[]={};
	};
	class SentCmdReturnFlagAt: NormalCommand
	{
		versions[]={};
	};
	class SentCmdEject: NormalCommand
	{
		versions[]={};
	};
	class SentCmdPlaceCharge: NormalCommand
	{
		versions[]={};
	};
	class SentCmdDetonate: NormalCommand
	{
		versions[]={};
	};
	class SentCmdActivateTimer: NormalCommand
	{
		versions[]={};
	};
	class SentCmdDeactivateBomb: NormalCommand
	{
		versions[]={};
	};
	class SentCmdDeactivateMine: NormalCommand
	{
		versions[]={};
	};
	class SentCmdTakeMine: NormalCommand
	{
		versions[]={};
	};
	class SentCmdLightFire: NormalCommand
	{
		versions[]={};
	};
	class SentCmdLightFireFar: NormalCommand
	{
		versions[]={};
	};
	class SentCmdLightFireAt: NormalCommand
	{
		versions[]={};
	};
	class SentCmdPutOutFire: NormalCommand
	{
		versions[]={};
	};
	class SentCmdPutOutFireFar: NormalCommand
	{
		versions[]={};
	};
	class SentCmdPutOutFireAt: NormalCommand
	{
		versions[]={};
	};
	class SentCmdOpenDoor: NormalCommand
	{
		versions[]={};
	};
	class SentCmdOpenDoorFar: NormalCommand
	{
		versions[]={};
	};
	class SentCmdOpenDoorAt: NormalCommand
	{
		versions[]={};
	};
	class SentCmdCloseDoor: NormalCommand
	{
		versions[]={};
	};
	class SentCmdCloseDoorFar: NormalCommand
	{
		versions[]={};
	};
	class SentCmdCloseDoorAt: NormalCommand
	{
		versions[]={};
	};
	class SentCmdFollowMe: UrgentCommand
	{
		versions[]={};
	};
	class SentCmdFollow: UrgentCommand
	{
		versions[]={};
	};
	class SentCmdAttack: UrgentCommand
	{
		versions[]={};
	};
	class SentAttackNoTarget: UrgentCommand
	{
		versions[]={};
	};
	class SentCmdFire: UrgentCommand
	{
		versions[]={};
	};
	class SentCmdGetIn: NormalCommand
	{
		versions[]={};
	};
	class SentCmdGetInCommander: NormalCommand
	{
		versions[]={};
	};
	class SentCmdGetInDriver: NormalCommand
	{
		versions[]={};
	};
	class SentCmdGetInPilot: NormalCommand
	{
		versions[]={};
	};
	class SentCmdGetInGunner: NormalCommand
	{
		versions[]={};
	};
	class SentCmdGetInCargo: NormalCommand
	{
		versions[]={};
	};
	class SentCmdSwitchToDriver: NormalCommand
	{
		versions[]={};
	};
	class SentCmdSwitchToGunner: NormalCommand
	{
		versions[]={};
	};
	class SentCmdSwitchToCommander: NormalCommand
	{
		versions[]={};
	};
	class SentCmdSwitchToCargo: NormalCommand
	{
		versions[]={};
	};
	class SentCmdGetOut: NormalCommand
	{
		versions[]={};
	};
	class SentCmdStop: NormalCommand
	{
		versions[]={};
	};
	class SentCmdExpect: NormalCommand
	{
		versions[]={};
	};
	class SentCmdHide: NormalCommand
	{
		versions[]={};
	};
	class SentCmdDismiss: NormalCommand
	{
		versions[]={};
	};
	class SentNotifyAttack: Notify
	{
		versions[]={};
	};
	class SentNotifyAttackSubgroup: SentNotifyAttack
	{
	};
	class SentNotifySupport: Notify
	{
		versions[]={};
	};
	class SentConfirmMove: Confirmation
	{
		versions[]={};
	};
	class SentConfirmAttack: Confirmation
	{
		versions[]={};
	};
	class SentConfirmOther: Confirmation
	{
		versions[]={};
	};
	class SentARTYFireAt: UrgentCommand
	{
		versions[]={};
	};
	class SentARTYFireAtWithAmmo: UrgentCommand
	{
		versions[]={};
	};
	class SentRepairThat: UrgentCommand
	{
		versions[]={};
	};
	class SentARTYRoundsComplete: NormalCommand
	{
		versions[]={};
	};
	class SentARTYCannotExecuteAdjustCoordinates: NormalCommand
	{
		versions[]={};
	};
	class SentARTYCannotExecuteThatsOutsideOurFiringEnvelope: NormalCommand
	{
		versions[]={};
	};
	class SentCmdSuppress: UrgentCommand
	{
		versions[]={};
	};
	class SentNotifySuppress: Notify
	{
		versions[]={};
	};
	class SentConfirmSuppress: Confirmation
	{
		versions[]={};
	};
	class SelectVehicleMoveSentence
	{
		sentences[]={};
	};
	class VehicleMoveGroupRelative: NormalCommand
	{
		versions[]={};
	};
	class VehicleMoveRecipientsRelative: NormalCommand
	{
		versions[]={};
	};
	class VehicleMoveToGrid: NormalCommand
	{
		versions[]={};
	};
	class VehicleMoveToObject: NormalCommand
	{
		versions[]={};
	};
	class VehicleMoveLocationRelative: NormalCommand
	{
		versions[]={};
	};
	class VehicleWatchTgt
	{
		versions[]={};
	};
	class VehicleWatchPos
	{
		versions[]={};
	};
	class VehicleJoin
	{
		versions[]={};
	};
	class VehicleFire
	{
		versions[]={};
	};
	class VehicleTarget
	{
		versions[]={};
	};
	class VehicleNoTarget
	{
		versions[]={};
	};
	class VehicleCeaseFire
	{
		versions[]={};
	};
	class VehicleForward
	{
		versions[]={};
	};
	class VehicleStop
	{
		versions[]={};
	};
	class VehicleBackward
	{
		versions[]={};
	};
	class VehicleFaster
	{
		versions[]={};
	};
	class VehicleSlower
	{
		versions[]={};
	};
	class VehicleLeft
	{
		versions[]={};
	};
	class VehicleRight
	{
		versions[]={};
	};
	class VehicleManualFire
	{
		versions[]={};
	};
	class VehicleCancelManualFire
	{
		versions[]={};
	};
	class VehicleDirectFire
	{
		versions[]={};
	};
	class VehicleLoad
	{
		versions[]={};
	};
	class VehicleLoadMagazine
	{
		versions[]={};
	};
	class VehicleAzimut
	{
		versions[]={};
	};
	class VehicleFireFailed
	{
		versions[]={};
	};
	class ClausePosition
	{
		text="";
		speech[]={};
	};
	class ClausePositionNear
	{
		text="";
		speech[]={};
	};
	class Arguments
	{
		class Direction
		{
			class Compass1
			{
				class 0
				{
					text="$STR_Q_NORTH";
					speech[]=
					{
						"North"
					};
				};
				class 45
				{
					text="$STR_Q_NORTH_EAST";
					speech[]=
					{
						"NorthEast"
					};
				};
				class 90
				{
					text="$STR_Q_EAST";
					speech[]=
					{
						"East"
					};
				};
				class 135
				{
					text="$STR_Q_SOUTH_EAST";
					speech[]=
					{
						"SouthEast"
					};
				};
				class 180
				{
					text="$STR_Q_SOUTH";
					speech[]=
					{
						"South"
					};
				};
				class 225
				{
					text="$STR_Q_SOUTH_WEST";
					speech[]=
					{
						"SouthWest"
					};
				};
				class 270
				{
					text="$STR_Q_WEST";
					speech[]=
					{
						"West"
					};
				};
				class 315
				{
					text="$STR_Q_NORTH_WEST";
					speech[]=
					{
						"NorthWest"
					};
				};
			};
			class Compass2
			{
				class 0
				{
					text="$STR_Q_NORTH";
					speech[]=
					{
						"North2"
					};
				};
				class 45
				{
					text="$STR_Q_NORTH_EAST";
					speech[]=
					{
						"NorthEast2"
					};
				};
				class 90
				{
					text="$STR_Q_EAST";
					speech[]=
					{
						"East2"
					};
				};
				class 135
				{
					text="$STR_Q_SOUTH_EAST";
					speech[]=
					{
						"SouthEast2"
					};
				};
				class 180
				{
					text="$STR_Q_SOUTH";
					speech[]=
					{
						"South2"
					};
				};
				class 225
				{
					text="$STR_Q_SOUTH_WEST";
					speech[]=
					{
						"SouthWest2"
					};
				};
				class 270
				{
					text="$STR_Q_WEST";
					speech[]=
					{
						"West2"
					};
				};
				class 315
				{
					text="$STR_Q_NORTH_WEST";
					speech[]=
					{
						"NorthWest2"
					};
				};
			};
			class Relative1
			{
				class 0
				{
					text="in front of";
					speach[]=
					{
						"InFrontOf"
					};
				};
				class 90
				{
					text="right of";
					speach[]=
					{
						"RightOf"
					};
				};
				class 180
				{
					text="behind";
					speach[]=
					{
						"Behind"
					};
				};
				class 270
				{
					text="left of";
					speach[]=
					{
						"LeftOf"
					};
				};
			};
		};
		class Distance1
		{
			class Level0
			{
				text="";
				speech[]=
				{
					"DangerCloseTo"
				};
			};
			class Level1
			{
				text="";
				speech[]=
				{
					"NotFarFrom"
				};
			};
			class Level2
			{
				text="";
				speech[]=
				{
					"FarFrom"
				};
			};
		};
		class AggrTargets
		{
			modes[]=
			{
				"Default"
			};
		};
	};
};
class RadioProtocolDefault: RadioProtocolBase
{
};
class PreloadConfig
{
	RadioProtocolBase="*";
	RadioProtocolDefault="*";
	CfgVoice="*";
	class CfgCloudlets
	{
		CraterBlood=".";
		CloudletsMissileManual="*";
		CloudletsMissile="*";
		CloudletsScud="*";
		CraterDustSmall="*";
		CraterDustBig="*";
		CraterSmoke1="*";
		CraterSmoke2="*";
		CraterSmoke3="*";
		CraterWater="*";
		Explosion="*";
	};
	CfgDestructPos="*";
	CfgCloudletShapes="*";
	CfgMimics="*";
	CfgVehicles="fastFind";
	CfgNonAIVehicles="fastFind";
	CfgAmmo="fastFind";
	CfgMusic="*";
	CfgTitles="*";
	CfgCameraEffects="*";
	RscTitlesText="*";
	CfgFonts="*";
	CfgFontFamilies="*";
	RscMainMenu="*";
	RscSubmenu="*";
	RscMoveHigh="*";
	RscMoveDir="*";
	RscReply="*";
	RscStatus="*";
	RscWatchDir="*";
	RscWatchMoreDir="*";
	RscMoveDist="*";
	RscFormations="*";
	RscCombatMode="*";
	RscTeam="*";
	RscSelectTeam="*";
	RscRadio="*";
	CfgHQIdentities="*";
	RscButtonImages="*";
	class RscInGameUI
	{
		RscUnitInfoSoldier="*";
	};
	RscObjectives="*";
};
class CfgCameraShake
{
	posChangeCoef=0.0049999999;
	rotXChangeCoef=0.5;
	rotYChangeCoef=0.5;
	rotZChangeCoef=0.5;
	performLERP=1;
	useDefaultValues=1;
	defaultPower=12;
	defaultDuration=1;
	defaultMaxDistance=120;
	defaultFrequency=20;
	defaultMinSpeed=0;
	defaultMinMass=10000;
	defaultCaliberCoefPlayerHit=0.5;
	defaultCaliberCoefWeaponFire=0.2;
	defaultPassingVehicleCoef=0.050000001;
	defaultPassingVehicleUpdateTime=1;
	defaultVehicleAttenuationCoef=0.2;
};
class CfgLensFlare
{
	flarePos[]={0,-0.30000001,-0.15000001,0.375,0.41249999,0.44999999,0.60000002,0.75,0.97500002,1.05,1.0875,1.125,1.3125,1.3275,1.5,1.65};
	flareSizeCam[]={0.5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};
	flareSizeEye[]={0.30000001};
	flareSizeEyeSun[]={0.15000001};
	flareBright[]={1,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5};
};
class CfgSoundEffects
{
	class WeaponsEffects
	{
		class Default
		{
			distance=1;
			frequency=1;
			center[]={100,800,2000,10000};
			bandwidth[]={1,1,1,1};
			gain[]={1,1,1,1};
			threshold=1;
			ratio=1;
			attack=1;
			release=1;
		};
	};
	class UnderWaterEffects
	{
		class Mono
		{
			distance=1;
		};
		class Equalizer
		{
			distance=3;
			center[]={100,800,2000,10000};
			bandwidth[]={2,2,2,2};
			gain[]={3.1622777,1.7782794,0.17782794,0.12589253};
		};
	};
	class UnconsciousStateEffect
	{
		class Echo0
		{
			WetDryMix=0.25;
			Feedback=0.25;
			Delay=100;
		};
		class Echo1
		{
			WetDryMix=0.5;
			Feedback=0.30000001;
			Delay=300;
		};
		class Equalizer0
		{
			center[]={100,800,2000,10000};
			bandwidth[]={1,1,1,1};
			gain[]={1,1,1,1};
		};
		class Equalizer1
		{
			center[]={100,800,2000,10000};
			bandwidth[]={2,2,2,2};
			gain[]={1.7782794,1,0.12589253,0.12589253};
		};
	};
};
class CfgMineDetectionCoefs
{
	NVGNightCoef=0.5;
	FlashLightCoef=0.25;
	EyePeripheralCoef=0.25;
	EyeCoef=1;
	EyeFocusCoef=1.3;
	EyeFocusDirectCoef=2;
	slowCoef=1.25;
	normalCoef=1;
	fastCoef=0.5;
	veryfastCoef=0.25;
};
class CfgFire
{
	access=1;
	manDelay=3;
	vehicleDelayPart=25;
	vehicleDelayFull=180;
};
class CfgIRLaserSettings
{
	laserMaxRange=1000;
	maxViewDistance=2000;
	maxNumberOfRays=16;
};
