:::::::::::::::::::::::::::::::::::::::::
::	file: DevP.bat
::	======
::	Author: Tom_48_97
::  © 2014 Bohemia Interactive a.s.
::	Description: Creating of P: drive with content required for Buldozer for Arma 3
::	Note:
::		uses batch file from Tom_48_97 (twitter: @tom_48_97) to get correct admin rights for the creation of P: drive
::		Valve encourages the setup programs to be silent that is why echo is off all the time
::		By default, devP will use default registry entries but you can define your own paths to use in settings.ini
::	Usage:
::		DevP.bat -DEBUG: Only display the paths and values used, no action will be made.
::		DevP.bat -clearInstall: Remove almost every files or references made by DevP
::		DevP.bat -cleanInstall: Perform "clearInstall", then, execute DevP in normal state.
::		DevP.bat -mapDiskOnly: Just map the P drive and ignore all the rest
::		DevP.bat -DIAG: used by diagnostic script
::		DevP.bat -update: used to update Buldozer installation (no file deletion)
::		DevP.bat -all: Will run in default mode then, execture futuraToP
::	Wiki:
::		Go to https://community.bistudio.com/wiki/P_drive for more information
:::::::::::::::::::::::::::::::::::::::::
:: Small kid, after this line, GET OUT OF MY CODE ;-)
@echo off
color 0c
mode con:cols=140 lines=60
title Arma 3 Tools: DevP
set scriptVersion=0.93.4
cls
::--- Init log file
set logFileDevP="%~dp0\Logs\devP.rpt"
set logMaxSize=1048576
if not exist %logFileDevP% goto beginOfJob
for %%A in (%logFileDevP%) do set logSize=%%~zA
call:formatDate
if %logSize% GTR %logMaxSize% (echo %formatedDate% - log erased > %logFileDevP%)
:beginOfJob
call:echoLog =====================================================================
call:echoLog == %~0
call:echoLog == Params: %*
call:echoLog Version: %scriptVersion%
call:echoLog Current time: %formatedDate%
call:echoLog =====================================================================

if "%1"=="-DIAG" goto yes

:ask
set _question="DevP is deprecated and no longer maintained and has been replaced by WorkDrive. Use at your own risk. Do you want to continue with DevP? (yes/no)"
set /P INPUT=%_question%: %=%
If /I "%INPUT%"=="yes" goto yes
If /I "%INPUT%"=="no" goto no
goto ask

:no
color 0f
WorkDrive\WorkDrive.exe
exit /B

:yes
color 0f
::--- Script parameters
call:BeginOfSection Define Parameters
set P_DrivePersistent=1
set A3_User=0
set SETTINGS="%~dp0settings.ini"
set startUp="%ProgramData%\Microsoft\Windows\Start Menu\Programs\StartUp\mapdisk.bat"

::--- Get path to Arma dir
call:BeginOfSection Retrieve User settings
if exist %SETTINGS% (
	call:getValue %SETTINGS% "A3_User" "Arma3" A3_User
	call:getValue %SETTINGS% "mapFolders" "Arma3Tools" mapFolders
)

call:BeginOfSection Retrieve Arma 3 path
if %A3_User% EQU 0 (
	:v64_path_a3
	For /F "Tokens=2* skip=2" %%A In ('REG QUERY "HKLM\SOFTWARE\Wow6432Node\Bohemia Interactive\Arma 3" /v "MAIN"') Do (set ArmAPath=%%B) & IF NOT DEFINED ArmAPath (goto v32_path_a3) else (goto then)
	:v32_path_a3
	For /F "Tokens=2* skip=2" %%C In ('REG QUERY "HKLM\SOFTWARE\Bohemia Interactive\Arma 3" /v "MAIN"') Do (set ArmAPath=%%D) & IF NOT DEFINED ArmAPath (goto uac_PATH_a3) else (goto then)
	:uac_PATH_a3
	for /F "tokens=2* delims=	 " %%I IN ('REG QUERY "HKLM\SOFTWARE\Wow6432Node\Bohemia Interactive\Arma 3" /v "MAIN"') DO (SET ArmAPath=%%J) & IF NOT DEFINED ArmAPath (goto std_PATH_a3) else (goto then)
	:std_PATH_a3
	for /F "tokens=2* delims=	 " %%K IN ('REG QUERY "HKLM\SOFTWARE\Bohemia Interactive\Arma 3" /v "MAIN"') DO (SET ArmAPath=%%L)
) else (
	call:getValue %SETTINGS% "A3_Path" "General" ArmAPath
)
:then
::--- Check P_Drive key exists, if not, add it
call:BeginOfSection Check P Drive
set ArmAWorkPath=0
For /F "Tokens=2* skip=2" %%A In ('REG QUERY "HKEY_CURRENT_USER\SOFTWARE\Bohemia Interactive\P Drive" /v "Path"') Do (set ArmAWorkPath=%%B)
if not exist "%ArmAWorkPath%" (
	set ArmAWorkPath="%~dp0"
	echo ArmAWorkPath Registry entry is missing, now adding it >> %logFileDevP% 2>&1
	REG ADD "HKEY_CURRENT_USER\SOFTWARE\Bohemia Interactive\P Drive" /F /v "Path" /t reg_sz /d "%~dp0" >> %logFileDevP% 2>&1
)

::--- Get path to Arma 3 installation
call:BeginOfSection variables to use
for %%f in ("%ArmAPath%\") do set ArmAPath=%%~sf
for %%f in ("%ArmAWorkPath%\") do set ArmAWorkPath=%%~sf
echo Arma 3 path is [%ArmAPath%] >> %logFileDevP% 2>&1
echo Arma 3 Work path is [%ArmAWorkPath%] >> %logFileDevP% 2>&1
echo Arma 3 Tools path is [%~dp0] >> %logFileDevP% 2>&1

::--- Exec the given script command
if "%1" EQU "-clearInstall" goto:clearInstall
if "%1" EQU "-cleanInstall" goto:clearInstall
if "%1" EQU "-update" goto:updateBuldozer

::--- DISPLAY DEBUG RESULTS
if "%1"=="-DEBUG" (
	echo DEBUG RESULTS
	echo Arma 3 path user defined? %A3_User%
	echo Arma 3 path is "%ArmAPath%"
	echo ArmAWorkPath path is "%ArmAWorkPath%" - Registry value
	pause
	exit /B
)
if "%1"=="-DIAG" (
	echo Arma 3 path user defined? %A3_User%
	echo Arma 3 path is "%ArmAPath%"
	echo ArmAWorkPath path is "%ArmAWorkPath%" - Registry value
	exit /B
)


::--- Call mapdisk
call:BeginOfSection mapdisk
if exist p: (
	if "%1" EQU "-mapDiskOnly" subst p: /d
)
call mapdisk.bat >> %logFileDevP% 2>&1

::--- if P is absent after mapdisk, we cannot proceed
if not exist p: goto:error_3

if "%1" EQU "-mapDiskOnly" goto:endOfFile

::--- If Arma path does not exist, we cannot proceed
if not exist "%ArmAPath%" goto:error_1

::--- Update Buldozer only
:updateBuldozer

call:BeginOfSection Add directories
::---
if not exist "P:\Bin" 			mkdir P:\Bin >> %logFileDevP% 2>&1
if not exist "P:\Core"			mkdir P:\Core >> %logFileDevP% 2>&1
if not exist "%temp%\BIStudio"	mkdir %temp%\BIStudio >> %logFileDevP% 2>&1
if not exist "%temp%\BIStudio\Bin"	mkdir %temp%\BIStudio\Bin >> %logFileDevP% 2>&1
if not exist "%temp%\BIStudio\Core" 	mkdir %temp%\BIStudio\Core >> %logFileDevP% 2>&1

::--- Uncompressing required files from Arma 3
call:BeginOfSection Prepare Arma 3 data
echo unpack data [bin.pbo] >> %logFileDevP% 2>&1
Bankrev\bankrev.exe -f "%temp%\BIStudio\Bin" "%ArmAPath%\Dta\bin.pbo" >> %logFileDevP% 2>&1
echo unpack data [core.pbo] >> %logFileDevP% 2>&1
Bankrev\bankrev.exe -f "%temp%\BIStudio\Core" "%ArmAPath%\Dta\core.pbo" >> %logFileDevP% 2>&1

::--- Removed previous content (to be sure the client is up to date)
call:BeginOfSection Clean P
if exist "p:\PhysX3_x86.dll" del /Q "p:\PhysX3_x86.dll" >> %logFileDevP% 2>&1
if exist "p:\PhysX3Common_x86.dll" del /Q "p:\PhysX3Common_x86.dll" >> %logFileDevP% 2>&1
if exist "p:\PhysX3Cooking_x86.dll" del /Q "p:\PhysX3Cooking_x86.dll" >> %logFileDevP% 2>&1
if exist "p:\PhysX3Gpu_x86.dll" del /Q "p:\PhysX3Gpu_x86.dll" >> %logFileDevP% 2>&1
if exist "p:\steam_api.dll" del /Q "p:\steam_api.dll" >> %logFileDevP% 2>&1
if exist "P:\buldozer.exe" del "P:\buldozer.exe" >> %logFileDevP% 2>&1
echo 107410 > p:\steam_appid.txt

::--- Copy requirements for Buldozer
call:BeginOfSection Place needed files in P
xcopy /D /S /E /Y %temp%\BIStudio\Bin\Bin\*.* "P:\Bin" >> %logFileDevP% 2>&1
xcopy /D /S /E /Y %temp%\BIStudio\Core\Core\*.* "P:\Core" >> %logFileDevP% 2>&1
copy /Y /B /V /L "%ArmAPath%\arma3.exe" "P:\buldozer.exe" >> %logFileDevP% 2>&1
copy /Y /B /V /L "%ArmAPath%\steam_api.dll" "P:\steam_api.dll" >> %logFileDevP% 2>&1
copy /Y /B /V /L "%ArmAPath%\PhysX3_x86.dll" "P:\PhysX3_x86.dll" >> %logFileDevP% 2>&1
copy /Y /B /V /L "%ArmAPath%\PhysX3Common_x86.dll" "P:\PhysX3Common_x86.dll"  >> %logFileDevP% 2>&1
copy /Y /B /V /L "%ArmAPath%\PhysX3Cooking_x86.dll" "P:\PhysX3Cooking_x86.dll" >> %logFileDevP% 2>&1
copy /Y /B /V /L "%ArmAPath%\PhysX3Gpu_x86.dll" "P:\PhysX3Gpu_x86.dll" >> %logFileDevP% 2>&1

::--- Call mapfolder
call:BeginOfSection mapfolders
call mapfolders.bat >> %logFileDevP% 2>&1

:endOfFile
::--- Clean & exit
call:BeginOfSection Clean temp files
rmdir /Q /S %temp%\BIStudio\ >> %logFileDevP% 2>&1

call:EndOfSection File
exit /B 0

:clearInstall
if exist %startUp% (del %startUp% >> %logFileDevP% 2>&1)
rmdir /Q /S "P:\Bin" >> %logFileDevP% 2>&1
rmdir /Q /S "P:\Core" >> %logFileDevP% 2>&1
del "P:\buldozer.exe" >> %logFileDevP% 2>&1
del /Q /S p:\PhysX3_x86.dll >> %logFileDevP% 2>&1
del /Q /S p:\PhysX3Common_x86.dll >> %logFileDevP% 2>&1
del /Q /S p:\PhysX3Cooking_x86.dll >> %logFileDevP% 2>&1
del /Q /S p:\PhysX3Gpu_x86.dll >> %logFileDevP% 2>&1
rmdir /Q /S %temp%\BIStudio\ >> %logFileDevP% 2>&1
subst p: /d >> %logFileDevP% 2>&1
if exist %startUp% (del %startUp%)
if "%1" EQU "cleanInstall" (call devP.bat & exit /B)
exit 0

:exitScript
endlocal
exit 0

::---------------------------------------------------------------------------
::	ERRORS
::---------------------------------------------------------------------------
:throwError
::	Description:
::	Parameter(s):
::	Returns:
echo.
starter.exe /parent=shell /mode=messageBox /tool=DevP %2
call:echoLog /!\ Error code = %1 /!\
Call:echoLog %2
endLocal
exit /b %1

:error_1
echo.  >> %logFileDevP% 2>&1
call:echoLog /!\ CRITICAL ERROR 1 /!\
call:echoLog DevP was unable to find your Arma 3 installation.
call:echoLog Define your path to Arma 3 in the file %SETTINGS%
echo. >> %logFileDevP% 2>&1
call:echoLog ACTION CANCELLED
starter.exe /parent=shell /mode=messageBox /tool=DevP "DevP was unable to find your Arma 3 installation.\nDefine your path to Arma 3 in this file:\n%SETTINGS%"
timeout /T 3 /noBreak
exit 1

:error_3
echo.  >> %logFileDevP% 2>&1
call:echoLog /!\ CRITICAL ERROR 3 /!\
call:echoLog DevP was unable to find your P Drive
echo. >> %logFileDevP% 2>&1
call:echoLog ACTION CANCELLED
starter.exe /parent=shell /mode=messageBox /tool=DevP "DevP was unable to find your P Drive path."
timeout /T 3 /noBreak
exit 3

::---------------------------------------------------------------------------
::	FUNCTIONS
::---------------------------------------------------------------------------

:echoLog
::	Description:
::	Parameter(s):
::		%0-9: Data
::	Returns:
::		Nothing
echo %*
echo %* >> %logFileDevP% 2>&1
goto:eof

:getValue
::	Description:
::		returns the given value from the ini
::	Parameter(s):
::		%1 - ini file
::		%2 - search term
::		%3 - group name
::		%4 - variable name to store the value
::	Returns:
::		Any - Value of the key
FOR /F "eol=; eol=[ tokens=1,2* delims==" %%i in ('findstr /b /l /i %~2= %1') DO set %~4=%%~j >> %logFileDevP% 2>&1
goto:eof

:formatDate
::	Description:
::		Set the real date & time
::	Parameter(s):
::	Returns:
set timeIs=%TIME::=-%
set today=%DATE:/=-%
set formatedDate=%today% %timeIs%
goto:eof

:BeginOfSection
::	Description: Print new title and store it to log
::	Parameter(s):
::		%0-9: Title
::	Returns:
::		Nothing
echo.
call:formatDate
call:echoLog ------------------------------------------------
call:echoLog %* [%formatedDate%]
call:echoLog ------------------------------------------------
goto:eof

:EndOfSection
::	Description: Print new title and store it to log
::	Parameter(s):
::		%0-9: Title
::	Returns:
::		Nothing
echo.
call:formatDate
call:echoLog ------------------------------------------------
call:echoLog End of %* [%formatedDate%]
call:echoLog ------------------------------------------------
goto:eof