@ECHO OFF

REM Try to find register entry for Arma 3 Tools
for /f "skip=2 tokens=3*" %%A in ('REG Query "HKEY_CURRENT_USER\Software\bohemia interactive\Arma 3 Tools" /v path') do (
  set "ToolDir=%%A %%B\ObjectBuilder"
)

if not exist "%ToolDir%" (
    echo Cannot find Arma 3 Tools - verify if they are installed correctly.
	goto exit
)

set Object=%ToolDir%\O2Script.exe
set Script=%ToolDir%\O2Scripts\addNewCharacterGeometry.bio2s
set ScriptCopy=%~dp0%addNewCharacterGeometry.bio2s
set TemplateP3D=%~dp0%NewGeometryTemplate.p3d

if exist "%Object%" (
	REM copy script to Object Builder o2scripts folder
	if not exist "%Script%" (
    	xcopy %ScriptCopy% "%ToolDir%\O2Scripts"
	)
) else (
    echo O2Script.exe was not found, adjust batch file manually or make sure the tools are correctly installed.
	goto exit
)

if exist %1\* goto directory

:file
for %%f in (%*) do (
	"%Object%"  "%Script%" ['"%%f"','"%TemplateP3D%"']
)
goto exit

:directory
for /R %%G in (*.p3d) do (
	"%Object%"  "%Script%" ['"%%G"','"%TemplateP3D%"']
)
goto exit
ECHO

:exit
pause